<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
 https://www.templatedlefr.fr/
-----------------------------------------------------
Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/

@error_reporting ( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set ( 'display_errors', true );
@ini_set ( 'html_errors', false );
@ini_set ( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

@session_start();

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', substr( dirname(  __FILE__ ), 0, -18 ) );
define( 'ENGINE_DIR', ROOT_DIR . '/engine' );


require_once ENGINE_DIR . '/classes/plugins.class.php';

include_once (DLEPlugins::Check(ENGINE_DIR . '/classes/htmlpurifier/HTMLPurifier.standalone.php'));

include ENGINE_DIR . '/data/config.php';
include ENGINE_DIR . '/forum/data/config.php';

require_once (DLEPlugins::Check(ENGINE_DIR . '/classes/mysql.php'));
require_once (DLEPlugins::Check(ENGINE_DIR . '/data/dbconfig.php'));
require_once ENGINE_DIR . '/forum/sources/components/functions.php';
require_once (DLEPlugins::Check(ENGINE_DIR . '/modules/functions.php'));
require_once (DLEPlugins::Check(ENGINE_DIR . '/classes/templates.class.php'));

	if ( file_exists( DLEPlugins::Check(ROOT_DIR.'/language/'.$config['langs'].'/adminpanel.lng') ) ) {
		include_once (DLEPlugins::Check(ROOT_DIR.'/language/'.$config['langs'].'/adminpanel.lng'));
	}


//#################
$user_group = get_vars( "usergroup" );

if( ! $user_group ) {
	$user_group = array ();
	
	$db->query( "SELECT * FROM " . USERPREFIX . "_usergroups ORDER BY id ASC" );
	
	while ( $row = $db->get_row() ) {
	
		$user_group[$row['id']] = array ();
		
		foreach ( $row as $key => $value ) {
			$user_group[$row['id']][$key] = stripslashes($value);
		}
		
	}
	set_vars( "usergroup", $user_group );
	$db->free();
}

$forum_groups = get_vars_forum( "forum_groups" );

if( ! $forum_groups ) {
	$forum_groups = array ();
	
	$db->query("SELECT * FROM " . PREFIX . "_forum_groups ORDER BY group_id ASC");
	
	while ( $row = $db->get_row() ) {
	
		$forum_groups[$row['id']] = array ();
		
		foreach ( $row as $key => $value ) {
			$forum_groups[$row['id']][$key] = stripslashes($value);
		}
		
	}
	set_vars_forum( "forum_groups", $forum_groups );
	$db->free();
}

require_once (DLEPlugins::Check(ENGINE_DIR . '/modules/sitelogin.php'));

if( ! $is_logged ) {
	$member_id['user_group'] = 5;
}

if( $member_id['banned'] )
{
  die("Hacking attempt!");
}

require_once ENGINE_DIR . '/forum/sources/components/init.php';

if( ! function_exists('convert_unicode') ) {
	
	function convert_unicode ($t, $to = 'windows-1251')
	{
		$to = strtolower($to);

		if ($to == 'utf-8') {

			$t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "decode_to_utf8(hexdec('\\1'))", utf8_encode($t) );
			$t = urldecode ($t);

		} else {

			$t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "'&#' . hexdec('\\1') . ';'", $t );
			$t = urldecode ($t);
    		$t = @html_entity_decode($t, ENT_NOQUOTES, $to);

		}

		return $t;
	}
}

?>