<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
 https://www.templatedlefr.fr/
-----------------------------------------------------Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/
@error_reporting(7);
@ini_set('display_errors', true);
@ini_set('html_errors', false);

//define('DATALIFEENGINE', true);
include 'init.php';

if( !$config['fast_search'] OR !$user_group[$member_id['user_group']]['allow_search'] ) die( "error" );

if ( !$config['allow_registration'] ) {
	$dle_login_hash = sha1( SECURE_AUTH_KEY . $_IP );
}

if( $_REQUEST['user_hash'] == "" OR $_REQUEST['user_hash'] != $dle_login_hash ) {

	echo $f_lang['sess_error'];
	die();

}

function strip_data($text) {

	$quotes = array ( "\x60", "\t", "\n", "\r", ".", ",", ";", ":", "&", "(", ")", "[", "]", "{", "}", "=", "*", "^", "%", "$", "<", ">", "+", "-" );
	$goodquotes = array ("#", "'", '"' );
	$repquotes = array ("\#", "\'", '\"' );
	$text = stripslashes( $text );
	$text = trim( strip_tags( $text ) );
	$text = str_replace( $quotes, ' ', $text );
	$text = str_replace( $goodquotes, $repquotes, $text );
	
	return $text;
}

$query = dle_substr( strip_data( $_POST['query'] ), 0, 90, $config['charset'] );

$arr = explode( ' ', $query );
$query = array ();

foreach ( $arr as $word ) {
	if( $word ) $query[] = $word;
}

$query = implode( "%", $query );

$query = $db->safesql( addslashes( $query ) );

if( $query == "" ) die();

$buffer = "";

$_TIME = time ();
$this_postdate = date( "Y-m-d H:i:s", $_TIME );
if( $config['no_date'] AND !$config['news_future'] ) $this_postdate = " AND p.post_date < '" . $this_postdate . "'"; else $this_postdate = "";

$this_topicsdate = date( "Y-m-d H:i:s", $_TIME );
if( $config['no_date'] AND !$config['news_future'] ) $this_topicsdate = " OR t.start_date < '" . $this_topicsdate . "'"; else $this_topicsdate = "";


$db->query("SELECT p.pid, p.post_date, p.post_text, t.tid, t.title, t.post, t.start_date, t.alt_name, t.last_post_id FROM " . PREFIX . "_forum_posts p LEFT JOIN " . PREFIX . "_forum_topics t ON (p.topic_id=t.tid) WHERE p.hidden=0".$this_postdate.$this_topicsdate." AND (p.post_text LIKE '%{$query}%' OR t.title LIKE '%{$query}%') ORDER by p.post_date DESC LIMIT 5");


while($row = $db->get_row()){
		
		if ($setting['mod_rewrite'])
				{
					if( $row['pid'] ) {
			
			          if( $setting['seo_type'] == 1 OR $setting['seo_type'] == 2 ) {
					
			  		      if( $row['title'] and $setting['seo_type'] == 2 ) {
						
						    $topic_title = cleantranslit( stripslashes( $row['title'] ), true, false );
						
						    $full_link = $forum_url."/searchtopic_{$row['tid']}/{$topic_title}/{$row['last_post_id']}.html";
					
			  		      } else {
						
						    $full_link = $config['http_home_url']."forum/topic_{$row['tid']}/{$row['last_post_id']}";
					
			  		      }
				
				      }
										
					}else{
			
			          if( $setting['seo_type'] == 1 OR $setting['seo_type'] == 2 ) {
					
			  		      if( $row['title'] and $setting['seo_type'] == 2 ) {
						
						    $topic_title = cleantranslit( stripslashes( $row['title'] ), true, false );
						
						    $full_link = $forum_url."/topic_{$row['tid']}/{$topic_title}.html";
					
			  		      } else {
						
						    $full_link = $config['http_home_url']."forum/topic_{$row['tid']}";
					
			  		      }
				
				      }
	
					}
				}
				else
				{
					if( $row['pid'] ) {
					$full_link = $config['http_home_url']."index.php?do=forum&showtopic={$row['tid']}&cstart={$row['last_post_id']}#post-{$row['last_post_id']}";
					}else{
					$full_link = $config['http_home_url']."index.php?do=forum&showtopic={$row['tid']}";	
					}
				}

		$row['title'] = stripslashes($row['title']);

		if( dle_strlen( $row['title'], $config['charset'] ) > 43 ) $title = dle_substr( $row['title'], 0, 43, $config['charset'] ) . " ...";
		else $title = $row['title'];

		$row['post_text'] = trim (htmlspecialchars( strip_tags( stripslashes( str_replace( array("<br>", "<br />", "&nbsp;"), " ", $row['post_text'] ) ) ), ENT_QUOTES, $config['charset'] ) );

		if (stripos ( $row['post_text'], "[hide" ) !== false ) {
			
			$row['post_text'] = preg_replace_callback ( "#\[hide(.*?)\](.+?)\[/hide\]#is", 
				function ($matches) use ($member_id, $user_group, $f_lang) {
					
					$matches[1] = str_replace(array("=", " "), "", $matches[1]);
					$matches[2] = $matches[2];
	
					if( $matches[1] ) {
						
						$groups = explode( ',', $matches[1] );
	
						if( in_array( $member_id['user_group'], $groups ) OR $member_id['user_group'] == "1") {
							return $matches[2];
						} else return "";
						
					} else {
						
						if( $user_group[$member_id['user_group']]['allow_hide'] ) return $matches[2]; else return "";
						
					}
	
			}, $row['post_text'] );
		}

		if( dle_strlen( $row['post_text'], $config['charset'] ) > 150 ) $description = dle_substr( $row['post_text'], 0, 150, $config['charset'] ) . " ...";
		else $description = $row['post_text'];

		$description = str_replace('&amp;', '&', $description);

		$description = preg_replace( "'\[attachment=(.*?)\]'si", "", $description );

	    $buffer .= "<a href=\"" . $full_link . "\"><span class=\"searchheading\">" . stripslashes( $title ) . "</span>";

		$buffer .= "<span>".$description."</span></a>";

}

if ( !$buffer ) $buffer .= "<span class=\"notfound\">{$f_lang['search_not_found']}</span>";

$query = rawurlencode(dle_substr(trim( strip_tags( stripslashes( $_POST['query'] ) ) ), 0, 90, $config['charset'] ));

$buffer .= '<span class="seperator"><a href="'.$config['http_home_url'].'index.php?do=forum&act=search">'.$f_lang['s_fsearchstart'].'</a></span><br class="break" />';

echo $buffer;

?>