<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
 https://www.templatedlefr.fr/
-----------------------------------------------------
 Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/
	@session_start();
	@error_reporting ( E_ALL ^ E_WARNING ^ E_NOTICE );
	@ini_set ( 'display_errors', true );
	@ini_set ( 'html_errors', false );
	@ini_set ( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

	define('DATALIFEENGINE', true);
	define('ROOT_DIR', substr(dirname( __FILE__ ), 0, -18));
	define('ENGINE_DIR', ROOT_DIR . '/engine');

	include ENGINE_DIR . '/data/config.php';
    include ENGINE_DIR . '/forum/data/config.php';
	if( $config['http_home_url'] == "" ) {
		$config['http_home_url'] = explode( "engine/forum/ajax/thanks.php", $_SERVER['PHP_SELF'] );
		$config['http_home_url'] = reset( $config['http_home_url'] );
		$config['http_home_url'] = "http://" . $_SERVER['HTTP_HOST'] . $config['http_home_url'];
	}

	require_once ENGINE_DIR . '/classes/mysql.php';
	require_once ENGINE_DIR . '/data/dbconfig.php';
require_once ENGINE_DIR . '/classes/plugins.class.php';
	require_once ENGINE_DIR . '/modules/functions.php';
	require_once ENGINE_DIR . '/forum/sources/components/functions.php';
	require_once ROOT_DIR."/language/{$config['langs']}/adminpanel.lng";
	require_once ENGINE_DIR . "/forum/language/{$config['langs']}/forum.lng";	

	include_once ROOT_DIR . '/language/' . $config['langs'] . '/website.lng';
	
$forum_groups = get_vars_forum( "forum_groups" );

if( ! $forum_groups ) {
	$forum_groups = array ();
	
	$db->query("SELECT * FROM " . PREFIX . "_forum_groups ORDER BY group_id ASC");
	
	while ( $row = $db->get_row() ) {
	
		$forum_groups[$row['id']] = array ();
		
		foreach ( $row as $key => $value ) {
			$forum_groups[$row['id']][$key] = stripslashes($value);
		}
		
	}
	set_vars_forum( "forum_groups", $forum_groups );
	$db->free();
}	

	require_once ENGINE_DIR . '/modules/sitelogin.php';
	
    include_once ENGINE_DIR . '/forum/classes/parse_board.class.php';

    $parse = new FilterParse();	
	
	if( !$is_logged ) $member_id['user_group'] = 5;

	if ( ! $_REQUEST['post_id'])
	echo "<script type=\"text/javascript\">DLEalert('{$lang_common['Bad request']}', '{$f_lang['js_error_b']}')</script>";
	
    if ($forum_groups[$member_id['user_group']]['g_can_thanks'] == '0' OR ! $is_logged)
	echo "<script type=\"text/javascript\">DLEalert('{$f_lang['No view']}', '{$f_lang['js_error_b']}')</script>";
	  
	$post_id = isset($_REQUEST['post_id']) ? intval($_REQUEST['post_id']) : 0;
	

	$check_news_id = $db->query("SELECT * FROM ".PREFIX."_forum_posts where pid = '{$post_id}'");

	$f_thxNews = $db->get_row($check_news_id);
	
	$config['charset'] = ($lang['charset'] != '') ? $lang['charset'] : $config['charset'];
	@header( "Content-type: text/html; charset=" . $config['charset'] );
	
	if ($db->num_rows($check_news_id) > 0 AND $f_thxNews['post_author'] != $member_id['name']) {

		$check_forum_thanks = $db->query("SELECT id FROM ".PREFIX."_forum_thanks WHERE post_id = '{$post_id}' AND thanks_by='{$member_id['name']}'");
		if($db->num_rows($check_forum_thanks) == 0)
		{
			$db->query("INSERT INTO ".PREFIX."_forum_thanks (`post_id`, `thanks_by_id`, `thanks_by`) values ('{$post_id}', '{$member_id['user_id']}', '{$member_id['name']}')");
			$db->query("UPDATE ".PREFIX."_users SET f_thx_num = f_thx_num + 1  WHERE name='{$f_thxNews['post_author']}'");

		$f_thxNews['post_author'] = $db->safesql($f_thxNews['post_author']);
        $db->query( "SELECT email, name, user_id, pm_all, user_group FROM " . USERPREFIX . "_users WHERE name = '{$f_thxNews['post_author']}'" );
		$row = $db->get_row();
		$time = time();
		$member_id['name'] = $db->safesql($member_id['name']);
		$send_id = 0;
		
			if ($setting['mod_rewrite'])
			{
			
			if( $setting['seo_type'] == 1 OR $setting['seo_type'] == 2 ) {
					
					if( $topic_title['title'] and $setting['seo_type'] == 2 ) {
						
						$topic_title = cleantranslit( stripslashes( $topic_title['title'] ), true, false );
						
						$last_post = "[url={$config['http_home_url']}forum/thanks_{$f_thxNews['topic_id']}/lastpost{$f_thxNews['pid']}.html]{$f_lang['Thanks_pm_comment_link']}[/url]";
					
					} else {
						
						$last_post = " [url={$config['http_home_url']}forum/topic_{$f_thxNews['topic_id']}/#post-{$f_thxNews['pid']}]{$f_lang['Thanks_pm_comment_link']}[/url]";
					
					}
				
				}
			}
			else
			{
				$last_post = " [url={$config['http_home_url']}index.php?do=forum&showtopic={$f_thxNews['topic_id']}#post-{$f_thxNews['pid']}]{$f_lang['Thanks_pm_comment_link']}[/url]";
			}		
		
		$subj = $db->safesql($f_lang['Thanks_pm_subject']);
		$comments = $f_lang['Thanks_pm_comment'].$member_id['name'].$f_lang['Thanks_pm_comment_'].$last_post;

	if( $setting['wysiwyg'] ) {
			
		$parse->wysiwyg = true;
			
		$comments = $db->safesql( $parse->BB_Parse( $parse->process( trim( $comments ) ) ) );
	
	} else {
		
		$comments = $db->safesql( $parse->BB_Parse( $parse->process( trim( $comments ) ), false ) );
	}
		 
		$db->query( "INSERT INTO " . USERPREFIX . "_pm (subj, text, user, user_from, date, pm_read, folder, sendid) values ('{$subj}', '{$comments}', '{$row['user_id']}', '{$member_id['name']}', '{$time}', '0', 'inbox', '{$send_id}')" );
		$newpmid = $db->insert_id();
		
		$db->query( "UPDATE " . USERPREFIX . "_users SET pm_all=pm_all+1, pm_unread=pm_unread+1  WHERE name='{$f_thxNews['post_author']}'" );
		
			echo "<script type=\"text/javascript\">DLEalert('{$f_lang['Thanks_redirect_ok']}', '{$f_lang['js_success_b']}')</script>";
		}
		else
		{
		    echo "<script type=\"text/javascript\">DLEalert('{$f_lang['Thanks_redirect_already']}', '{$f_lang['js_error_b']}')</script>";
		}
	}
	elseif($db->num_rows($check_news_id) > 0 AND $f_thxNews['post_author'] == $member_id['name'])
	{ 
		echo "<script type=\"text/javascript\">DLEalert('{$f_lang['Thanks_redirect_self']}', '{$f_lang['js_error_b']}')</script>";
	}
	
	
	$sql_result_f_thx = $db->query("SELECT t.*, u.* FROM " . PREFIX . "_forum_thanks AS t LEFT JOIN " . USERPREFIX . "_users AS u ON t.thanks_by=u.name WHERE t.post_id = '{$post_id}' ORDER by id ASC");
	if($db->num_rows($sql_result_f_thx) > 0)
	{
		while ($f_thx = $db->get_row())
		{
						
	        $group_span = $forum_groups[$f_thx['user_group']]['group_colour'];
			
          if ($setting['mod_rewrite']){
			
			if( $config['allow_alt_url'] ) {

				$go_page = $config['http_home_url'] . "user/" . urlencode( $f_thx['thanks_by'] ) . "/";

			} else {

				$go_page = "$PHP_SELF?subaction=userinfo&user=" . urlencode( $f_thx['thanks_by'] );
				
			}
		  }

			$go_page = "onclick=\"ShowProfile('" . urlencode( $f_thx['thanks_by'] ) . "', '" . htmlspecialchars( $go_page, ENT_QUOTES, $config['charset'] ) . "', '" . $user_group[$member_id['user_group']]['admin_editusers'] . "'); return false;\"";

         if ( !$f_thx['name'] ) {
			$row_author = $f_lang['user_del'];
		}else{
			
			if( $config['allow_alt_url'] ){ 
			   $f_thx_member[] = "<a {$go_page} href=\"" . $config['http_home_url'] . "user/" . urlencode( $f_thx['thanks_by'] ) . "/\"><span style=\"color:{$group_span}\">".$f_thx['thanks_by']."</span></a>";
			}else{ 
			   $f_thx_member[] = "<a {$go_page} href=\"$PHP_SELF?subaction=userinfo&amp;user=" . urlencode( $f_thx['thanks_by'] ) . "\"><span style=\"color:{$group_span}\">".$f_thx['thanks_by']."</span></a>";
			}

		}			
			
			$all_members  = implode(', ',$f_thx_member);
			
			if (count($f_thx_member) > 0)
		    $numUsers = $db->num_rows($sql_result_f_thx);
            $user_list = ($numUsers>0) ? implode("", $f_thx_member) : $f_lang['Thanks_one'];
		
		}

		echo <<<HTML
         <!--num:{$numUsers}-->
           <div class="title_spoiler">
		     <i id="image-thanks" class="fa fa-plus"></i>&nbsp;<a href="javascript:ShowOrHide('thanks_{$row['pid']}')">{$f_lang['Num_Thanks']}: {$numUsers}</a>
		   </div>
		   
           <div id="thanks_{$row['pid']}" class="text_spoiler" style="display:none;">
		   {$user_list}
		   </div>
HTML;
           
	}
	else 
	{
		echo $f_lang['No_Thanks'];
	}
?>