var tinymce_dle_plugin_loaded = false;
var playlist = '';

tinymce.PluginManager.add('dlebutton', function(editor, url) {
    editor.on('init', function() {

    	if (!tinymce_dle_plugin_loaded) {
    		tinymce_dle_plugin_loaded = true;
	        var cssURL = url + '/dlebutton.css';
	        if(document.createStyleSheet){
	            document.createStyleSheet(cssURL);
	        } else {
	            cssLink = editor.dom.create('link', {
	                        rel: 'stylesheet',
	                        href: cssURL
	                      });
	            document.getElementsByTagName('head')[0].
	                      appendChild(cssLink);
	        }
	    }
    });

    var scriptLoader = new tinymce.dom.ScriptLoader(),
        tp,
        typo = function () {
            if (tp) {
                editor.setContent(tp.execute(editor.getContent()));
                editor.undoManager.add();
            }
        };

    scriptLoader.add(url + '/typograf.min.js');

    scriptLoader.loadQueue(function () {
    	tp = new Typograf({
    		locale: ['ru', 'en-US'],
    		htmlEntity: {type: 'name', onlyInvisible: true}
		});

		tp.disableRule('common/space/afterPunctuation');
		tp.disableRule('common/space/delBeforePunctuation');

		tp.addSafeTag('\\[code\\]', '\\[/code\\]');
		tp.addSafeTag('\\[', '\\]');
		tp.addSafeTag('<code>', '</code>');

    });

    editor.ui.registry.addButton('dletypo', {
        tooltip: 'Typographical Word Processing',
        text: '<i class="mce-i-dleicon icon-typo"></i>',
        onAction: typo
    });

	editor.ui.registry.addButton('dleemo', {
		tooltip : 'Add emoticons',
		icon : 'emoji',
		onAction : function() {
			editor.windowManager.openUrl({
			    title: "Add emoticons",
			    url: editor.settings.dle_root + 'engine/editor/jscripts/tiny_mce/plugins/dlebutton/emotions.php',
			    width: 390,
			    height: 350
			});
		}
    });

	editor.ui.registry.addButton('dleupload', {
		tooltip : 'Uploading files',
		text: '<i class="mce-i-dleicon icon-up"></i>',
		onAction : function() {
			editor.focus();
			forum_upload( editor.settings.dle_upload_area, editor.settings.dle_upload_user, editor.settings.dle_upload_forum_id, editor.settings.dle_upload_topic_id, editor.settings.dle_upload_post_id, '2');
		}
    });

	editor.ui.registry.addButton('dleleech', {
		tooltip : 'Insert protected link',
		text : '<i class="mce-i-dleicon icon-leech"></i>',
		onAction : function() {
            editor.windowManager.open({
                title: 'Insert protected link',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							}
				      ]
				    },
			        initialData: {
			          descr: editor.selection.getContent()
			      },
				  buttons: [
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   var data = e.getData();
                   editor.insertContent('[leech=' +data.href+']' + data.descr +'[/leech]');
                   e.close();
                }
            });
		}
    });


	editor.ui.registry.addButton('dlequote', {
		tooltip : 'Insert quote',
		text : '<i class="mce-i-dleicon icon-quote"></i>',
			
		onAction: function() {
			
			if( editor.selection.getContent() ) {

				var it = editor.selection.getContent();
				it = it.replace(/(<p[^>]+?>|<p>|<\/p>)/img, "");
				it = it.replace(/\n/g, '<br>');
				it = it.replace(/\r/g, '');

				editor.execCommand('mceReplaceContent',false,'<div class="quote_block noncontenteditable"><div class="quote"><div class="quote_body contenteditable">' + it + '</div></div></div><p><br></p>');

			} else {


	            editor.windowManager.open({
	                title: 'Insert quote',
	                size: 'medium',

	  				body: {
	    				type: 'panel', // The root body type - a Panel or TabPanel
					    items: [ // A list of panel components
								{
					                    type: 'textarea',
					                    name: 'qttext'
					                }
					      ]
					    },
					  buttons: [ // A list of footer buttons
					    {
					      type: 'cancel',
					      text: 'Cancel'
					    },
					    {
					      type: 'submit',
					      primary: true,
					      text: 'Insert'
					    }
					  ],
	                onSubmit: function(e) {
	                   		var data = e.getData();

							var it = data.qttext.replace(/\n/g, '<br>');
							it = it.replace(/\r/g, '');

							editor.execCommand('mceReplaceContent',false,'<div class="quote_block noncontenteditable"><div class="quote"><div class="quote_body contenteditable">' + it + '</div></div></div><p><br></p>');
							e.close();

	                }
	            });


			}

		}
	});


	editor.ui.registry.addButton('dlehide', {
		tooltip : 'Insert hidden text',
		text : '<i class="mce-i-dleicon icon-hide"></i>',
			
		onAction: function() {

			var selected_text = editor.selection.getContent();
			selected_text = selected_text.replace(/<br>/g, "\n");
			selected_text = $('<span>'+selected_text+'</span>').text();

            editor.windowManager.open({
                title: 'Insert hidden text',
                size: 'medium',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                    type: 'textarea',
				                    name: 'qttext'
				                }
				      ]
				    },
		        initialData: {
		          qttext: selected_text
		     	},
				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						var text = data.qttext;
						text = text.replace(/</g, '&lt;');
						text = text.replace(/>/g, '&gt;');

						text = text.replace(/\n/g, '<br>');
						text = text.replace(/\r/g, '');

						editor.execCommand('mceReplaceContent',false,'[hide]' +text +'[/hide]');
						e.close();

                }
            });

		}
	});

	editor.ui.registry.addButton('dlecode', {
		tooltip : 'Insert source code',
		text : '<i class="mce-i-dleicon icon-code"></i>',

		onAction : function() {
			var selected_text = editor.selection.getContent();
			selected_text = selected_text.replace(/<br>/g, "\n");
			selected_text = $('<span>'+selected_text+'</span>').text();

            editor.windowManager.open({
                title: 'Insert source code',
                size: 'medium',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                    type: 'textarea',
				                    name: 'qttext'
				                }
				      ]
				    },
		        initialData: {
		          qttext: selected_text
		     	},
				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						var text = data.qttext;
						text = text.replace(/</g, '&lt;');
						text = text.replace(/>/g, '&gt;');

						text = text.replace(/\n/g, '<br>');
						text = text.replace(/\r/g, '');

						editor.execCommand('mceReplaceContent',false,'[code]' +text +'[/code]');
						e.close();

                }
            });

		}
    });

	editor.ui.registry.addButton('dlespoiler', {
		tooltip : 'Insert spoiler',
		text : '<i class="mce-i-dleicon icon-spoiler"></i>',
		onAction : function() {

			var selected_text = editor.selection.getContent();
			selected_text = selected_text.replace(/<br>/g, "\n");
			selected_text = $('<span>'+selected_text+'</span>').text();

            editor.windowManager.open({
                title: 'Insert spoiler',
                size: 'medium',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                    type: 'textarea',
				                    name: 'qttext'
				                }
				      ]
				    },
		        initialData: {
		          qttext: selected_text
		     	},
				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						var text = data.qttext;
						text = text.replace(/</g, '&lt;');
						text = text.replace(/>/g, '&gt;');

						text = text.replace(/\n/g, '<br>');
						text = text.replace(/\r/g, '');

						editor.execCommand('mceReplaceContent',false,'[spoiler]' +text +'[/spoiler]');
						e.close();

                }
            });
		}
    });		

	editor.ui.registry.addButton('dlebreak', {
		tooltip : 'Insert page breaks',
		text : '<i class="mce-i-dleicon icon-br"></i>',
		onAction : function() {
			editor.execCommand('mceInsertContent',false,'{PAGEBREAK}');
		}
    });	

	editor.ui.registry.addButton('dletube', {
		tooltip : 'Play video from media services',
		text : '<i class="mce-i-dleicon icon-yt"></i>',

		onAction : function() {

            editor.windowManager.open({
                title: 'Play video from media services',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Url'
				            }
				      ]
				    },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						editor.insertContent('[media=' + data.href +']');

						e.close();

                }
            });

		}
    });

	editor.ui.registry.addButton('dlepage', {
		tooltip : 'Insert link to the page',
		text : '<i class="mce-i-dleicon icon-pl"></i>',
		onAction : function() {
			editor.windowManager.open({
                title: 'Insert link to the page',

   				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Page Number'
				            },
							{
				                type: 'input',
				                name: 'text',
				                label: 'Text to display'
				            },
				      ]
				    },

			      initialData: {
			          text: editor.selection.getContent(),
			          href: '1'
			      },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

                onSubmit: function(e) {
                   		var data = e.getData();

						editor.insertContent('[page=' +data.href +']' + data.text +'[/page]');

						e.close();

                }

            });
		}
    });

	editor.ui.registry.addButton('dlemp', {
		tooltip : 'Insert video (BB Codes)',
		text : '<i class="mce-i-dleicon icon-video"></i>',

		onAction : function() {

			var win = {
                title: 'Insert video (BB Codes)',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							},
				            {type: 'input', 
								name: 'poster', 
								label: 'Link to poster', 
							}
				          ]
				},

				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Close'
				    },
				    {
				      type: 'custom',
				      name: 'addbtn',
				      primary: true,
				      text: 'Add to Playlist'
				    },

				    {
				      type: 'submit',
				      name: 'submitbtn',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

				onAction: function(dialogApi, details) {

					var data = dialogApi.getData();

					var videourl = data.href;
					var videoposter = data.poster;
					var videodescr = data.descr;
								
					var videolink = videourl;

					if (videoposter != "" || videodescr != "" ) { 
						videolink += '|' + videoposter;
					}
								
					if (videodescr != "" ) { 
						videolink += '|' + videodescr;
					}

					if (videolink != "") {
						playlist +=  videolink + ',';
					}
								
					dialogApi.redial(win);
				},

                onSubmit: function(dialogApi) {

					var data = dialogApi.getData();
					
					var videolink = data.href;
					var poster = data.poster;
					var descr = data.descr;

					if (poster != "" || descr != "" ) { 
						videolink += '|' + poster;
					}
					
					if (descr != "" ) { 
						videolink += '|' + descr;
					}
					
					if(videolink != "" && videolink != "https://") {
						playlist += videolink;
					}else if(playlist != "") {
						playlist = playlist.substring(0, playlist.length - 1)
					}

					if(playlist != "") {
                   		editor.insertContent('[video=' + playlist +']');
                   	}

					playlist = '';
					dialogApi.close();
                }
            };

           editor.windowManager.open( win );

		}

    });

	editor.ui.registry.addButton('dlaudio', {
		tooltip : 'Insert audio (BB Codes)',
		text : '<i class="mce-i-dleicon icon-audio"></i>',

		onAction : function() {

			var win = {
                title: 'Insert audio (BB Codes)',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							}
				          ]
				},

				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Close'
				    },
				    {
				      type: 'custom',
				      name: 'addbtn',
				      primary: true,
				      text: 'Add to Playlist'
				    },

				    {
				      type: 'submit',
				      name: 'submitbtn',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

				onAction: function(dialogApi, details) {

					var data = dialogApi.getData();

					var videourl = data.href;
					var videodescr = data.descr;
								
					var videolink = videourl;
					
					if (videodescr != "" ) { 
						videolink += '|' + videodescr;
					}
					
					if (videolink != "") {
						playlist +=  videolink + ',';
					}
								
					dialogApi.redial(win);
				},

                onSubmit: function(dialogApi) {

					var data = dialogApi.getData();
					
					var videolink = data.href;
					var descr = data.descr;

					if (descr != "" ) { 
						videolink += '|' + descr;
					}
					
					if(videolink != "") {
						playlist += videolink;
					}else if(playlist != "") {
						playlist = playlist.substring(0, playlist.length - 1);
					}

					if(playlist != "") {
                   		editor.insertContent('[audio=' + playlist +']');
                   	}

					playlist = '';

					dialogApi.close();
                }
            };

           editor.windowManager.open( win );

		}

    });



	editor.ui.registry.addButton('dleimage', {
		tooltip : 'Insert image',
		icon : 'image',

		onAction : function() {
			editor.windowManager.open({
                title: 'Insert image',

   				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Url'
				            },
							{
				                type: 'input',
				                name: 'text',
				                label: 'Image description'
				            },
				            {
			                    type: 'listbox',
			                    name: 'align',
			                    label: 'Alignment',

								  items: [
								    { text: 'None', value: '' },
								    { text: 'Left', value: 'left' },
								    { text: 'Right', value: 'right' },
								    { text: 'Center', value: 'center' }
								    ]

			                }
				      ]
				    },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

                onSubmit: function(e) {
                   		var data = e.getData();

						var imageurl = data.href;
						var imagealt = data.text;
						var imagealign = data.align;
						
						var imgoption = "";
				
						if (imagealt != "") { 
				
							imgoption = "|"+imagealt;
				
						}
				
						if (imagealign != "" && imagealign != "center") { 
				
							imgoption = imagealign+imgoption;
				
						}
				
						if (imgoption != "" ) {
				
							imgoption = "="+imgoption;
				
						}
				
						if (imagealign == "center") {
							editor.insertContent('<p style="text-align: center;">[img'+imgoption+']'+imageurl+'[/img]</p>');
						}
						else {
							editor.insertContent("[img"+imgoption+"]"+imageurl+"[/img]", "", false);
						}

						e.close();

                }

            });
		}
    });



});