<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
https://www.templatedlefr.fr/
-----------------------------------------------------
Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/

if( !defined( 'DATALIFEENGINE' ) ) {
	header( "HTTP/1.1 403 Forbidden" );
	header ( 'Location: ../../' );
	die( "Hacking attempt!" );
}

// ********************************************************************************
// FORUM sessions
// ********************************************************************************
	function forum_sessions ($act_forum = 0, $act_topic = 0)
	{
		global $db, $act, $setting, $member_id;
		
		$id = $db->safesql($_COOKIE['dle_forum_sessions']);
		
		$ip = $db->safesql($_SERVER['REMOTE_ADDR']);
		
		if (!$id) { $id = session_id(); }
		
		$browser = $db->safesql($_SERVER['HTTP_USER_AGENT']);
		
		$member_name = $member_id['name'];
		
		$crawlers = array(
		'GoogleBot'     => "Google",
		'Mediapartners' => "Google MP",
		'msnbot'        => "MSN Bot",
		'Bingbot'       => "Bing",
		'yahoo'         => "Yahoo Bot",
		'Slurpbot'      => "Yahoo",
		'DuckDuckBot'   => "DuckDuckGo",
		'Baiduspider'   => "Baidu",
		'Yandex Bot'    => "Yandex",
		'Sogou Spider'  => "Sogou",
		'Exabot'        => "Exalead",
		'Facebot'       => "Facebook",
		'Alexa Crawler' => "Amazon",
		);
		
		if (intval($member_id['user_group']) == "0"){ $member_id['user_group'] = "5"; }
		
		if ($member_id['user_group'] == "5" and $setting['bot_agent'])
		{
			foreach ($crawlers as $bot => $bot_name)
			{
				if ( stristr ($browser, $bot) )
				{
					$member_name = $bot_name;
					
					$id = md5 ($bot);
					
					$botname = 'crawler';
					
					break;
				}
			}
		}
		
		$time = time();
		
		$stime = time() - ($setting['session_time'] * 60);
		
		if ($id)
		{
			$row = $db->super_query("SELECT id, member_id FROM " . PREFIX . "_forum_sessions WHERE id = '$id' AND ip = '$ip'"); // OR
		}
		
		if (!$row['id'])
		{
			set_cookie ('dle_forum_sessions', session_id(), 365);
			
			$where_mn = $member_name ? " OR member_name = '$member_name'" : "";
			
			$db->query("DELETE FROM " . PREFIX . "_forum_sessions WHERE running_time < '$stime' OR id = '$id'".$where_mn);
			
			$db->query("INSERT INTO " . PREFIX . "_forum_sessions (id, member_name, member_id, user_group, ip, bot, browser, running_time, location, act_forum, act_topic) VALUES ('$id', '$member_name', '$member_id[user_id]', '$member_id[user_group]', '$ip', '$botname', '$browser', '$time', '$act', '$act_forum', '$act_topic')");
			
			
		}
		
		else
		{
			$db->query("UPDATE " . PREFIX . "_forum_sessions SET member_name = '$member_name', member_id = '$member_id[user_id]', user_group = '$member_id[user_group]', bot = '$botname', running_time = '$time', location = '$act', act_forum = '$act_forum', act_topic = '$act_topic' WHERE id = '$id'");
		}
	}

// ********************************************************************************
// FORUM Online
// ********************************************************************************
	function get_forum_online ($type = false, $value = false)
	{
		global $db, $setting, $forum_groups, $forum_online;
		
		$stime = time() - ($setting['session_time'] * 60);
		
		if ($type and $value)
		{
			$WHERE = "".$type." = '$value' and";
		}
		
		$sessions = $db->query("SELECT member_name, member_id, user_group FROM " . PREFIX . "_forum_sessions WHERE {$WHERE} running_time > '$stime'");
		
		$forum_online['member_count'] = 0;
		
		$forum_online['guest_count'] = 0;
		
        $member_list = array();
        
		while ($row = $db->get_row($sessions))
		{
			$forum_online['all_count']++;
			
			if ($row['member_name'])
			{
				if ($row['user_group'] !== "5")
                {
                    $forum_online['member_count']++;
                    
                    if ($forum_groups) $group_span = $forum_groups[$row['user_group']]['group_colour'];
                    
                    $member_list[$row['member_id']] = link_user($row['member_name'], $row['member_name']);
                }
                else
                {
                    $forum_online['guest_count']++;
                    
                    $member_list['b'.$forum_online['all_count']] = $row['member_name'];
                }
			}
			
			else
			{
				$forum_online['guest_count']++;
			}
		}
        
        $forum_online['member_list'] = implode(', ', $member_list);
        
		if ($forum_online['all_count'] > $setting['_max_online_'])
		{
			global $fcache;
			
			$max_online = array ('count' => $forum_online['all_count'], 'time' => $GLOBALS['_TIME']);
			
			$fcache->set('online', $max_online);
			
			$fcache->cache_delete('stats');
		}
	}	

// ********************************************************************************
// FORUM STATUS
// ********************************************************************************
	function forum_status ($last_date, $close = false, $redirect = false, $icon = false)
	{
		global $member_id, $lasttime, $f_lang;
		
		$last_date = strtotime($last_date);
		
		if ($icon)
		{
			$icon = "_".$icon;
		}
		
        if ($redirect)
        {
            $image = "forum_link{$icon}"; 
			$alt = $f_lang['fs_redirect'];
            
            $topic_info = $image;
            
            return($topic_info);
        }
        
		if ($last_date > $lasttime AND $last_date > $member_id['forum_time'])
		{
			if (!$close)
			{
				$image = "forum_unread{$icon}"; 
				$alt = $f_lang['fs_new'];
			}
			else
			{
				$image = "forum_unread_locked{$icon}"; 
				$alt = $f_lang['fs_new_locked'];
			}
		}
		
		else
		{
			if (!$close)
			{
				$image = "forum_read{$icon}"; 
				$alt = $f_lang['fs_nonew'];
			}
			else
			{
				$image = "forum_read_locked{$icon}"; 
				$alt = $f_lang['fs_nonew_locked'];
			}
		}
		
		$topic_info = $image;
		
		return($topic_info);
	}

// ********************************************************************************
// FORUM LAST
// ********************************************************************************
	function forum_last ($topic_id, $title, $last_user, $last_date, $password = false, $redirect = false, $fid = false, $access_read = false, $is_category = false, $last_pid = 0)
	{
		global $setting, $f_lang, $_TIME, $member_id, $forum_url;
		
        if ($redirect)
        {
            return '';
        }
        
        //check_access
        
		$title = stripslashes($title);
		
		$last_date = strtotime($last_date);
		
  		    if( date( 'Ymd', $last_date ) == date( 'Ymd', $_TIME ) ) {
			
			  $last_date_info = $f_lang['time_heute'] . langdate( ", H:i", $last_date );
		
		    } elseif( date( 'Ymd', $last_date ) == date( 'Ymd', ($_TIME - 86400) ) ) {
			
			  $last_date_info = $f_lang['time_gestern'] . langdate( ", H:i", $last_date );
		
		    } else {
			
			  $last_date_info = langdate( $setting['timestamp'], $last_date );
		
		   }		
		
		$h_title = $f_lang['topic_last_p'].' '.$title;
		
		if ($setting['last_abc'])
		{
			if (strlen($title) > $setting['last_abc'])
			{
				$title = substr($title, 0, $setting['last_abc']).'...';
			}
		}
		
		if ($password AND md5($password) !== $_COOKIE["dle_forum_{$fid}"])
		{
			$link_topic = $f_lang['fl_c_forum'];
		}
        elseif (!check_access($access_read) && !$is_category)
        {
            $link_topic = $f_lang['fl_c_forum'];
        }        
		else
		{
			if ($setting['mod_rewrite'])
				{
				
			      if( $setting['seo_type'] == 1 OR $setting['seo_type'] == 2 ) {
					
					if( $title and $setting['seo_type'] == 2 ) {

		                $translittitle = totranslit( stripslashes( cleansearch($title) ), true, false, $config['translit_url'] ); 
						
						$link_topic = "<a href='{$forum_url}/topic_{$topic_id}/{$translittitle}/last.html#post-{$last_pid}' title='{$h_title}'>{$title}</a><br />";
					
					} else {
						
						$link_topic = "<a href='{$forum_url}/topic_{$topic_id}/last#post-{$last_pid}' title='{$h_title}'>{$title}</a><br />";
					
					}
				
				 }	
				
				}
				else
				{
					$link_topic = "<a href='{$forum_url}/&showtopic={$topic_id}&lastpost=1#post-{$last_pid}' title='{$h_title}'>{$title}</a><br />";
				}
			
		}
        
		$last_date_info .= $f_lang['fl_topic'].' '.$link_topic;
		
		$last_date_info .= $f_lang['last_post'].' '.link_user($last_user);
		
		if (!$last_user or !$last_date){ $last_date_info = $f_lang['fl_nopost']; }
		
		return($last_date_info);
	}

// ********************************************************************************
// TOPIC STATUS
// ********************************************************************************
	function topic_status ($topic_id, $last_date, $post, $topic_status, $frage, $fixed, $announce)
	{
		global $topic_views, $setting, $member_id, $f_lang, $topic_a_time, $row;
		
		$last_date = strtotime($last_date);
		
		if ($last_date > $topic_a_time AND $last_date > $member_id['forum_time']){ 
		$topic_views_time = 1;
		}
		
		if ($post >= $setting['topic_hot']){
		      $topic_hot = 1;
		}
		
		if (!$topic_views[$topic_id] AND $topic_views_time)
		{
			$image = 'topic_unread'; 
			
			if ($topic_hot){
			$image = 'topic_unread_hot'; 
			}
			
			if ($frage){ 
			$image = 'topic_poll_unread'; 
			}
			
			if (!$fixed){ 
			$image = 'sticky_unread'; 
			}
			
			if (!$announce){ 
			$image = 'announce_unread'; 
			}
		}
		
		else
		{
			$image = 'topic_read'; 
			
			if ($topic_hot){ 
			$image = 'topic_read_hot'; 
			}
			
			if ($frage){ 
			$image = 'topic_poll_read'; 
			}
			
			if (!$fixed){ 
			$image = 'sticky_read'; 
			}
			
			if (!$announce){ 
			$image = 'announce_read'; 
			}
		}
		
		if ($topic_status == 1){
			
			$image = 'topic_read_locked'; 
			
			if ($topic_hot){ 
			$image = 'topic_read_hot_locked'; 
			}
			
			if ($frage){ 
			$image = 'topic_poll_read'; 
			}
			
			if (!$fixed){ 
			$image = 'sticky_read_locked'; 
			}
			
			if (!$announce){ 
			$image = 'announce_read_locked';
			}
		}
		
		return  $image;
	}
	
function cleansearch($str, $charset='utf-8')
{
    $str = htmlentities($str, ENT_NOQUOTES, $charset);   
    $str = preg_replace('#&([A-za-z])(?:acute|cedil|caron|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str);
    $str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str); // pour les ligatures e.g. '&oelig;'
    //$str = preg_replace('#&[^;]+;#', '', $str); // supprime les autres caractères
    $str = str_replace(array('à','á','â','ã','ä','å'),'a',$str);
    $str = str_replace(array('ò','ó','ô','õ','ö','ø'),'o',$str);
    $str = str_replace(array('è','é','ê','ë'),'e',$str);
    $str = str_replace('ç','c',$str);
    $str = str_replace(array('ì','í','î','ï'),'i',$str);
    $str = str_replace(array('ù','ú','û','ü'),'u',$str);
    $str = str_replace('ÿ','y',$str);
    $str = str_replace('ñ','n',$str);	
	$str = str_replace("-"," ",$str);	
	$str = str_replace("039;","'",$str);
	$str = str_replace("amp","'",$str);
    return $str;
}	

// ********************************************************************************
// TOPIC LAST
// ********************************************************************************
	function topic_last ($topic_id, $title, $last_user, $last_date, $posts, $last_pid = 0)
	{
		global $setting, $f_lang, $_TIME, $forum_url;
		
		$last_date = strtotime($last_date);
		
  		    if( date( 'Ymd', $last_date ) == date( 'Ymd', $_TIME ) ) {
			
			  $last_date_info = $f_lang['time_heute'] . langdate( ", H:i", $last_date );
		
		    } elseif( date( 'Ymd', $last_date ) == date( 'Ymd', ($_TIME - 86400) ) ) {
			
			  $last_date_info = $f_lang['time_gestern'] . langdate( ", H:i", $last_date );
		
		    } else {
			
			  $last_date_info = langdate( $setting['timestamp'], $last_date );
		
		   }	
		
		if ($setting['last_plink'])
		{
			$last_page = @ceil(($posts + 1) / $setting['post_inpage']);
			
			if (!$last_page) $last_page = 1;

			if ($setting['mod_rewrite'])
				{
				
			      if( $setting['seo_type'] == 1 OR $setting['seo_type'] == 2 ) {
					
					if( $title and $setting['seo_type'] == 2 ) {

		                $title = totranslit( stripslashes( cleansearch($title) ), true, false, $config['translit_url'] ); 
						
						$last_date_info .= "<br /><a href='{$forum_url}/topic_{$topic_id}/{$title}/lastpost.html#post-{$last_pid}' title='{$f_lang['topic_last_p']}'>{$f_lang['last_post']}&nbsp;".link_user($last_user)."</a><br />";
					
					} else {
						
						$last_date_info .= "<br /><a href='{$forum_url}/topic_{$topic_id}/lastpost#post-{$last_pid}' title='{$f_lang['topic_last_p']}'>{$f_lang['last_post']}&nbsp;".link_user($last_user)."</a><br />";
					
					}
				
				 }	
				
				}
				else
				{
					$last_date_info .= "<br /><a href='{$forum_url}/&showtopic={$topic_id}&lastpost={$last_pid}#post-{$last_pid}' title='{$f_lang['topic_last_p']}'>{$f_lang['last_post']}&nbsp;".link_user($last_user)."</a><br />";
				}	
			
		}
		
		else
		{
			$last_date_info .= "<br />{$f_lang['last_post']}".link_user($last_user)."<br />";
		}
		
		if (!$last_user or !$last_date){$last_date_info = $f_lang['fl_nopost'];}
		
		return($last_date_info);
	}

// ********************************************************************************
// CHECK ACCESS
// ********************************************************************************
	function check_access ($value = false)
	{
		global $member_id;
		
		$value = explode(":", $value);
		
		$check = in_array($member_id['user_group'], $value);
		
		if ($check) return true;
		
		else return false;
	}

// ********************************************************************************
// CHECK MODERATOR
// ********************************************************************************
	function check_moderator($value, $moderators)
	{
		global $member_id, $m_member;
		
        $m_member = false;
        
		$value = explode(":", $value);
		
		$check = in_array($member_id['user_group'], $value);
		
		if (!$check and $moderators)
		{
			$moderators = explode(":", $moderators);
			
			$check = in_array($member_id['user_id'], $moderators);
			
			$m_member = true;
		}
		
		if ($check) return true;
		
		else return false;
	}

// ********************************************************************************
// GROUP VALUE
// ********************************************************************************
	function group_value($value)
	{
		global $member_id, $forum_groups;
		
		if ($forum_groups[$member_id['user_group']][$value])
		{
			return true;
		}
		
		return false;
	}

// ********************************************************************************
// MODERATOR VALUE
// ********************************************************************************	
	function moderator_value($value, $forum_id, $m_member = false)
	{
		global $member_id, $forum_moderators;
		
		if ($forum_moderators == "a:0:{}") return false;
		
		if ($forum_moderators)
		{
			if ($m_member)
			{
				$search = 'member_id';
				
				$search_value = $member_id['user_id'];
			}
			
			else
			{
				$search = 'group_id';
				
				$forum_id = '0';
				
				$search_value = $member_id['user_group'];
			}
			
			foreach ($forum_moderators as $key => $val)
			{
				if ($forum_moderators[$key]['forum_id'] == $forum_id)
				{
					if ($forum_moderators[$key][$search] == $search_value)
					{
						if ($forum_moderators[$key][$value])
						{
							return true;
						}
					}
				}
			}
		}
		
		return false;
	}

// ********************************************************************************
// IS MODERATION
// ********************************************************************************
	function is_moderation($forum_id = 0, $topic_id = 0, $post_id = 0, $value = '')
	{
		global $db, $member_id, $forum_groups, $m_member, $is_mod; //$forum_id
		
		$forum_id = intval($forum_id);
		
		$topic_id = intval($topic_id);
		
		$post_id = intval($post_id);
		
		if ($post_id)
		{
			$get_post = $db->super_query("SELECT * FROM " . PREFIX . "_forum_posts WHERE pid = '$post_id'");
			
			$topic_id = $get_post['topic_id'];
			
			$is_mod['topic_id'] = $get_post['topic_id'];
			
			$is_mod['author'] = $get_post['post_author'];
			
			if ($member_id['name'] == $get_post['post_author'] AND $forum_groups[$member_id['user_group']][$value] AND !$get_post['hidden'])
			{
				return true;
				
				$topic_id = false;
			}
		}
		
		if ($topic_id)
		{
			if (!$forum_id)
			{
				$get_topic = $db->super_query("SELECT * FROM " . PREFIX . "_forum_topics WHERE tid = '$topic_id'");
				
				if ($get_topic['tid'] != $topic_id) return false;
				
				$forum_id = $get_topic['forum_id'];
			}
			
			$is_mod['forum_id'] = $get_topic['forum_id'];
			
			$get_forum = $db->super_query("SELECT * FROM " . PREFIX . "_forum_forums WHERE id = '$forum_id'");
			
			if (check_moderator($get_forum['access_mod'], $get_forum['moderators']))
			{
				return true;
			}
		}
		
		if (!$post_id and !$topic_id)
		{
			$get_forum = $db->super_query("SELECT * FROM " . PREFIX . "_forum_forums WHERE id = '$forum_id'");
			
			if (check_moderator($get_forum['access_mod'], $get_forum['moderators']))
			{
				return true;
			}
		}
		
		return false;
	}
    
    function require_file($file = ''){}

// ********************************************************************************
// GROUP MODERATION
// ********************************************************************************
	function group_moderation ($topic_id = 0, $value = false)
	{
		global $db, $member_id, $forum_groups;
		
		if (intval($topic_id))
		{
			$row = $db->super_query("SELECT * FROM " . PREFIX . "_forum_topics WHERE tid = '$topic_id'");
			
			if ($member_id['name'] == $row['author_topic'])
			{
				foreach ($forum_groups as $key => $val)
				{
					if ($forum_groups[$key]['group_id'] == $member_id['user_group'])
					{
						if ($forum_groups[$key][$value])
						{
							return true;
						}
					}
				}
			}
		}
		
		return false;
	}

// ********************************************************************************
// FORUM MSG
// ********************************************************************************
	function forum_msg($title, $msg_text, $tpl_found = false, $tpl_set = false)
	{
		global $tpl, $tpl_dir;
		
		$tpl->load_template($tpl_dir.'msg.tpl');
		
		$tpl->set('{title}', $title);
		
		$tpl->set('{msg}', '<br />'.$msg_text.'<br /><br />');
		
		if ($tpl_found)
		{
			$tpl->set("{".$tpl_found."}", $tpl_set);
		}
		
		$tpl->compile('main_content');
		
		$tpl->clear();
	}

// ********************************************************************************
// POST ICONS
// ********************************************************************************
	function post_icons ($icon = false)
	{
		global $config, $setting, $f_lang;
		
		$br_count = 7;
		
		$setting['post_icons'] = 'fire,heart,radioactive,star,thinking,alert,info,mrgreen,question,redface';

			$icon_array = explode(',', $setting['post_icons']);
			
			if ($setting['post_icons'])
			{
				$dir = $config['http_home_url'].'engine/forum/images/post_icons';
				
				foreach ($icon_array as $value)
				{
					$icon_count++;
					
					if ($icon == $value)
					{
						$checked = "checked='checked'";
						
						$checked_icon = true;
					}
					else
					{
						$checked = "";
					}
					
					$code .= "<label for=\"{$value}\"><input type=\"radio\" name=\"icon\" id=\"{$value}\" value=\"{$value}\" {$checked}><img src=\"{$dir}/{$value}.gif\" width=\"16\" height=\"16\" alt=\"\" title=\"\"></label>&nbsp;";
				}
			}
			
			if (!$checked_icon) $checked = "checked='checked'";
			
			$code .= "<label for=\"icon2\"><input type=\"radio\" name=\"icon\" id=\"icon2\" value=\"0\" {$checked}> {$f_lang['f_no_icon']}</label>";			
		return $code;
	}

// ********************************************************************************
// Get Salt
// ********************************************************************************
	function get_salt()
	{
		$salt = str_shuffle("abchefghjkmnpqrstuvwxyz0123456789");
		$rand = "";

		for($i=0;$i < 9; $i++) {
			$rand .= $salt[mt_rand(0,33)];
		}
		
		return ($rand);
	}
	
// ********************************************************************************
// Strip Data
// ********************************************************************************
	function data_strip ($text)
	{
		$quotes = array( "\x27", "\x22", "\x60", "\t","\n","\r","'",",","/","\\","¬",";",":","@","~","[","]","{","}","=",")","(","*","&","^","%","$","<",">","?","!", '"' );
		$text = trim(strip_tags ($text));
		$text = str_replace($quotes, '', $text);
		return $text;
	}

// ********************************************************************************
// hilites
// ********************************************************************************
	function hilites ($search, $txt)
	{
		$r = preg_split('((>)|(<))', $txt, -1, PREG_SPLIT_DELIM_CAPTURE);
		
		for ($i = 0; $i < count($r); $i++)
		{
			if ($r[$i] == "<")
			{
				$i++; continue;
			}
			
			$r[$i] = preg_replace("#($search)#i", "<span style='background-color:yellow;'><font color='red'>\\1</font></span>", $r[$i]);
		}
		
		return join("", $r);
	}

// ********************************************************************************
// CHECK ATTACHMENT
// ********************************************************************************
function check_attachment($post_id, $sources)
{
	global $db;
	
	$post_id = intval($post_id);
	
	if (!$post_id OR !$sources) return false;
	
	$query = $db->query("SELECT * FROM " . PREFIX . "_forum_files WHERE post_id = '$post_id'");
	
	while ($row = $db->get_row($query))
	{
		if (stristr($sources, "[attachment={$row['file_id']}]") OR stristr($sources, "/forum/files/{$row['onserver']}"))
		{
			$file_attach_y[] = $row['file_id'];
		}
		
		else
		{
			$file_attach_n[] = $row['file_id'];
		}
	}
	
	if ($file_attach_y)
	{
		$update_list_y = implode(',', $file_attach_y);
		
		$db->query("UPDATE " . PREFIX . "_forum_files SET file_attach = '1' WHERE file_id IN ({$update_list_y})");
	}
	
	if ($file_attach_n)
	{
		$update_list_n = implode(',', $file_attach_n);
		
		$db->query("UPDATE " . PREFIX . "_forum_files SET file_attach = '0' WHERE file_id IN ({$update_list_n})");
	}
}

// ********************************************************************************
// Auto Wrap
// ********************************************************************************
function auto_wrap($post)
{
	global $forum_config;
	
	if (!$forum_config['auto_wrap']) return $post;
	
	$post = preg_split('((>)|(<))', $post, -1, PREG_SPLIT_DELIM_CAPTURE);
	
	$n = count($post);
	
	for ($i = 0; $i < $n; $i++)
	{
		if ($post[$i] == "<")
		{
			$i++; continue;
		}
		
		$post[$i] = preg_replace("#([^\s\n\r]{".intval($forum_config['auto_wrap'])."})#i", "\\1<br />", $post[$i]);
	}
	
	$post = join("", $post);
	
	return $post;
}



function set_vars_forum($file, $data) {

	$file = totranslit($file, true, false);

	if ( is_array($data) OR is_int($data) ) {
		
		file_put_contents (ENGINE_DIR . '/forum/cache/system/' . $file . '.php', json_encode( $data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES ), LOCK_EX);
		@chmod( ENGINE_DIR . '/forum/cache/system/' . $file . '.php', 0666 );

	}

}

function get_vars_forum($file) {
	$file = totranslit($file, true, false);

	$data = @file_get_contents( ENGINE_DIR . '/forum/cache/system/' . $file . '.php' );

	if ( $data !== false ) {

		$data = json_decode( $data, true );
		if ( is_array($data) OR is_int($data) ) return $data;

	} 

	return false;

}
// ********************************************************************************
// Forum Metatags
// ********************************************************************************
function forum_metatags($story)
{
	global $db;
	
	$keyword_count = 20;
	$newarr = array ();
	$headers = array ();
	$quotes = array ("\x27", "\x22", "\x60", "\t", '\n', '\r', "\n", "\r", '\\', "'", ",", ".", "/", "¬", "#", ";", ":", "@", "~", "[", "]", "{", "}", "=", "-", "+", ")", "(", "*", "&", "^", "%", "$", "<", ">", "?", "!", '"' );
	$fastquotes = array ("\x27", "\x22", "\x60", "\t", "\n", "\r", '"', "'", '\r', '\n', "/", "\\", "{", "}", "[", "]" );
	
	$story = preg_replace( "'\[hide\](.*?)\[/hide\]'si", "", $story );
	$story = preg_replace( "'\[attachment=(.*?)\]'si", "", $story );
	
	$story = str_replace( '<br />', ' ', $story );
	$story = trim( strip_tags( $story ) );
	
	$story = str_replace( $fastquotes, '', $story );
	$headers['description'] = $db->safesql( substr( $story, 0, 190 ) );
				
	$headers['description'] = stripslashes( preg_replace( array ("&quot;", "&#039;" ), array ("'\"'", "'\''" ), $headers['description'] ) );

	
	$story = str_replace( $quotes, '', $story );
	
	$arr = explode( " ", $story );
	
	foreach ( $arr as $word )
	{
		if( strlen( $word ) > 4 ) $newarr[] = $word;
	}
	
	$arr = array_count_values( $newarr );
	arsort( $arr );
	
	$arr = array_keys( $arr );
	
	$total = count( $arr );
	
	$offset = 0;
	
	$arr = array_slice( $arr, $offset, $keyword_count );
	
	$headers['keywords'] = $db->safesql( implode( ", ", $arr ) );
	
	$headers['keywords'] = stripslashes( preg_replace( array ("&quot;", "&#039;" ), array ("'\"'", "'\''" ), $headers['keywords'] ) );
	
	return $headers;
}

function set_first_post_id ($tid, $pid = 0)
{
	global $db;
	
	$tid = intval($tid);
	
	if (!$pid)
	{
		$row = $db->super_query("SELECT pid FROM " . PREFIX . "_forum_posts WHERE topic_id = $tid");
		
		$pid = $row['pid'];
	}
	
	$db->query("UPDATE " . PREFIX . "_forum_topics SET first_post = '$pid', last_post_id = '$pid' WHERE tid = '$tid'");
	
	return $pid;
}

function calk_topic_del ($topic_id, $del_count = 0, $act = '-')
{
	global $db, $setting;
	
	if (!$topic_id) return false;
	
	$row = $db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_forum_posts WHERE topic_id = $topic_id");
	
	if (!$setting['set_topic_post']) $row['count'] = ($row['count'] - 1);
	
	$new_result = $db->super_query("SELECT * FROM ". PREFIX ."_forum_posts WHERE topic_id = $topic_id ORDER by post_date DESC");
	
	$db->query("UPDATE " . PREFIX . "_forum_topics SET post = '{$row['count']}', last_date = '$new_result[post_date]', last_poster_name = '$new_result[post_author]' WHERE tid = $topic_id");
	
	$row2 = $db->super_query("SELECT forum_id FROM " . PREFIX . "_forum_topics WHERE tid = $topic_id");
	
	$new_f_r = $db->super_query("SELECT * FROM ". PREFIX ."_forum_topics WHERE forum_id = {$row2['forum_id']} ORDER by last_date DESC");
	
	if ($del_count)
	{
		$db->query("UPDATE " . PREFIX . "_forum_forums SET posts = posts{$act}{$del_count}, f_last_date = '$new_f_r[last_date]', f_last_poster_name = '$new_f_r[last_poster_name]' WHERE id = {$row2['forum_id']}");
	}
	
	return true;
}


// ********************************************************************************
// POLL
// ********************************************************************************

function get_poll($all) {
	
	$data = array ();
	
	if( $all != "" ) {
		$all = explode( "|", $all );
		
		foreach ( $all as $vote ) {
			list ( $answerid, $answervalue ) = explode( ":", $vote );
			$data[$answerid] = intval( $answervalue );
		}
	}
	
	return $data;
}
	
	function forum_cut_text($texte, $nbreCar)
{
        $RawTextLengthWithoutHtml = strlen(strip_tags($texte));

        if($RawTextLengthWithoutHtml < $nbreCar) return $texte;

        $MaskHtmlSplit = '#</?([a-zA-Z1-6]+)(?: +[a-zA-Z]+="[^"]*")*( ?/)?>#';
        $MaskHtmlMatch = '#<(?:/([a-zA-Z1-6]+)|([a-zA-Z1-6]+)(?: +[a-zA-Z]+="[^"]*")*( ?/)?)>#';

        $texte .= ' ';

        $TipsTexts = preg_split($MaskHtmlSplit, $texte, -1,  PREG_SPLIT_OFFSET_CAPTURE | PREG_SPLIT_NO_EMPTY);

        $NumberTips = count($TipsTexts);

        if( $NumberTips == 1 )
        {
                $Leng = strlen($texte);

                return substr($texte, 0, strpos($texte, ' ', $Leng > $nbreCar ? $nbreCar : $Leng));
        }

        $Leng = 0;

        $indexDernierBout = $NumberTips - 1;

        $position = $TipsTexts[$indexDernierBout][1] + strlen($TipsTexts[$indexDernierBout][0]) - 1;

        $indexBout = $indexDernierBout;
        $rechercheEspace = true;

        foreach( $TipsTexts as $index => $bout )
        {
                $Leng += strlen($bout[0]);

                if( $Leng >= $nbreCar )
                {
                        $position_fin_bout = $bout[1] + strlen($bout[0]) - 1;

                        $position = $position_fin_bout - ($Leng - $nbreCar);

                        if( ($positionEspace = strpos($bout[0], ' ', $position - $bout[1])) !== false  )
                        {
                                $position = $bout[1] + $positionEspace;
                                $rechercheEspace = false;
                        }

                        if( $index != $indexDernierBout )
                                $indexBout = $index + 1;
                        break;
                }
        }

        if( $rechercheEspace === true )
        {
                for( $i=$indexBout; $i<=$indexDernierBout; $i++ )
                {
                        $position = $TipsTexts[$i][1];
                        if( ($positionEspace = strpos($TipsTexts[$i][0], ' ')) !== false )
                        {
                                $position += $positionEspace;
                                break;
                        }
                }
        }

        $texte = substr($texte, 0, $position);

        preg_match_all($MaskHtmlMatch, $texte, $retour, PREG_OFFSET_CAPTURE);

        $BoutsTag = array();

        foreach( $retour[0] as $index => $tag )
        {
                if( isset($retour[3][$index][0]) )
                {
                        continue;
                }

                if( $retour[0][$index][0][1] != '/' )
                {
                        array_unshift($BoutsTag, $retour[2][$index][0]);
                }

                else
                {
                        array_shift($BoutsTag);
                }
        }

        if( !empty($BoutsTag) )
        {
                foreach( $BoutsTag as $tag )
                {
                        $texte .= '</' . $tag . '>';
                }
        }

        if ($RawTextLengthWithoutHtml > $nbreCar)
        {
                $texte .= ' [......]';

                $texte =  str_replace('</p> [......]', '... </p>', $texte);
                $texte =  str_replace('</ul> [......]', '... </ul>', $texte);
                $texte =  str_replace('</div> [......]', '... </div>', $texte);
        }

        return $texte;
}



function forum_substr($str, $start, $length, $charset = "utf-8" ) {

	if( function_exists( 'mb_substr' ) ) {
		return mb_substr( $str, $start, $length, $charset );
	
	} elseif( function_exists( 'iconv_substr' ) ) {
		return iconv_substr($str, $start, $length, $charset);
	}

	return substr($str, $start, $length);

}

// ********************************************************************************
// ACCESS
// ********************************************************************************
function access_forum($user_group, $forum_id){
	global $access_forum, $db, $f_lg;
	
	$access_mod = array();
	
	$access_topic = array();
	
	$access_write = array();
	
	$access_read = array();
	
	$access_upload = array();
	
	$access_download = array();
	
	// JavaScript by ShVad //
	$access_forum = <<<HTML
	<script language='JavaScript' type="text/javascript">

function access_check( id, value )
{
	if (value == 'y'){ value = 1; } else { value = 0; }
	
	document.getElementById( 'access_mod' + '[' + id + ']' ).checked = value;
	
	document.getElementById( 'access_topic' + '[' + id + ']' ).checked = value;
	
	document.getElementById( 'access_write' + '[' + id + ']' ).checked = value;
	
	document.getElementById( 'access_read' + '[' + id + ']' ).checked = value;
	
	document.getElementById( 'access_upload' + '[' + id + ']' ).checked = value;
	
	document.getElementById( 'access_download' + '[' + id + ']' ).checked = value;
}

</script>
HTML;
	
	if ($forum_id)
	{
		$access_result = $db->query("SELECT * FROM " . PREFIX . "_forum_forums WHERE id = '$forum_id'");
		
		while ($row = $db->get_row($access_result))
		{
			$access_mod = $row['access_mod'];
			
			$access_topic = $row['access_topic'];
			
			$access_write = $row['access_write'];
			
			$access_read = $row['access_read'];
			
			$access_upload = $row['access_upload'];
			
			$access_download = $row['access_download'];
		}
	}
	
	$access_forum .= "<tr>
        <td style=\"width:16%; text-align:center;\"><b>{$f_lg['access_forum_group']}</b></td>
        <td style=\"width:10%; text-align:center;\"><b>{$f_lg['access_forum_mod']}</b></td>
        <td style=\"width:14%; text-align:center;\"><b>{$f_lg['access_forum_topic']}</b></td>
        <td style=\"width:14%; text-align:center;\"><b>{$f_lg['access_forum_write']}</b></td>
        <td style=\"width:14%; text-align:center;\"><b>{$f_lg['access_forum_read']}</b></td>
        <td style=\"width:14%; text-align:center;\"><b>{$f_lg['access_forum_upload']}</b></td>
        <td style=\"width:16%; text-align:center;\"><b>{$f_lg['access_forum_download']}</b></td>
		</tr>
		";
		

    foreach($user_group as $id => $group_name)
	{
		if ($forum_id)
		{
		$access_mod_array = explode(":",$access_mod);
		if (in_array($id, $access_mod_array)){$checked1 = "checked";}else{$checked1 = "";}
		
		$access_topic_array = explode(":",$access_topic);
		if (in_array($id, $access_topic_array)){$checked2 = "checked";}else{$checked2 = "";}
		
		$access_write_array = explode(":",$access_write);
		if (in_array($id, $access_write_array)){$checked3 = "checked";}else{$checked3 = "";}
		
		$access_read_array = explode(":",$access_read);
		if (in_array($id, $access_read_array)){$checked4 = "checked";}else{$checked4 = "";}
		
		$access_upload_array = explode(":",$access_upload);
		if (in_array($id, $access_upload_array)){$checked5 = "checked";}else{$checked5 = "";}
		
		$access_download_array = explode(":",$access_download);
		if (in_array($id, $access_download_array)){$checked6 = "checked";}else{$checked6 = "";}
		}
		
		$access_forum .= "<tr>
	    <td width='16%'>
		<left><a href=\"javascript:access_check('$id', 'y')\"><img src='engine/forum/admin/ico/plus.png'></a>&nbsp;<a href=\"javascript:access_check('$id', 'n')\"><img src='engine/forum/admin/ico/minus.png'></a> {$group_name['group_name']}
	    </td>
        <td width='10%'>
		<center><input type='checkbox' name='access_mod[$id]' id='access_mod[$id]' value='$id' $checked1></center></td>
        <td width='14%'>
		<center><input type='checkbox' name='access_topic[$id]' id='access_topic[$id]' value='$id' $checked2></center></td>
        <td width='14%'>
		<center><input type='checkbox' name='access_write[$id]' id='access_write[$id]' value='$id' $checked3></center></td>
        <td width='14%'>
		<center><input type='checkbox' name='access_read[$id]' id='access_read[$id]' value='$id' $checked4></center></td>
        <td width='14%'>
		<center><input type='checkbox' name='access_upload[$id]' id='access_upload[$id]' value='$id' $checked5></center></td>
        <td width='16%'>
		<center><input type='checkbox' name='access_download[$id]' id='access_download[$id]' value='$id' $checked6></center></td>
		</tr>";
	}
        
    
    return($access_forum);
}

define('BULLETSHARE', true);

// ********************************************************************************
// Category and Forum POSITION
// ********************************************************************************
function category_posi($category_posi, $category_id, $result_posi){
	global $db,$row;
	
	$cat_posi = array();
	
	$select_posi = "<select class=\"select-uniform\" data-min-width=\"20px\" name=\"cat_posi[$category_id]\">";
	
	for($j=1; $j<=$result_posi; $j++)
	{
		if ($j == $category_posi)
		{
			$select_posi .= "<option value='$j' selected>$j</option>";
		}
		
		else
		{
			$select_posi .= "<option value='$j'>$j</option>";
		}
	}
	
	$select_posi .= "</select>";
	
	return ($select_posi);
}

function position_count ($parent_id = '-1')
{
    global $db;
    $row = $db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_forum_forums WHERE parentid = '{$parent_id}'");
    
    return $row['count'];
}

function position_forum ($id)
{
    global $db;
    $row = $db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_forum_forums WHERE parentid = '{$id}' ORDER BY position");
    
    return $row['count'];
}

// ********************************************************************************
// showRow
// ********************************************************************************

	function showRow($title = "", $description = "", $field = "", $class = "") {
		
		
		echo "<tr>
        <td class=\"col-xs-6 col-sm-6 col-md-7\"><h6 class=\"media-heading text-semibold\">{$title}</h6><span class=\"text-muted text-size-small hidden-xs\">{$description}</span></td>
        <td class=\"col-xs-6 col-sm-6 col-md-5\">{$field}</td>
        </tr>";
	}

// ********************************************************************************
// Show Radio
// ********************************************************************************
function showRadio($title = "", $description = "", $allow_name = "", $row = false){
	 global $f_lg;
	 
		if ($row[$allow_name])
		{
			$o_value = "checked";
		}
		
		else
		{
			$o_value = "";
		}
		
	echo " 
	<tr>
        <td><h6>$title</h6><span class=\"note large\">$description</span></td>
        <td><input class=\"switch\" type=\"checkbox\" name=\"save[{$allow_name}]\" {$o_value} value=\"1\" ></td>
    </tr>
    ";		
	}

// ********************************************************************************
// Dir Size
// ********************************************************************************
function dirsize($directory)
  {
    if(!defined('Dleforum_CACHE')) { exit; }

     if (!is_dir($directory)) return -1;

     $size = 0;

     if ($DIR = opendir($directory))
     {
        while (($dirfile = readdir($DIR)) !== false)
        {

           if (@is_link($directory . '/' . $dirfile) || $dirfile == '.' || $dirfile == '..')
              continue;

           if (@is_file($directory . '/' . $dirfile))
              $size += filesize($directory . '/' . $dirfile);

           else if (@is_dir($directory . '/' . $dirfile))
           {

             $dirSize = dirsize($directory . '/' . $dirfile);
              if ($dirSize >= 0) $size += $dirSize;
              else return -1;

           }

        }

        closedir($DIR);

     }

     return $size;

  }
  
  
  
// ********************************************************************************
// Clean URL for SEO type 2
// ********************************************************************************
function cleantranslit($var, $lower = true, $punkt = true ) {
	global $langtranslit;
	
	if ( !is_string($var) ) return "";

	$bads = array( '!', '*', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '#', '[', ']', '%', '\\', '"', '<', '>', '^', '{', '}', '|', '`', '.php', '&#039;' );
	
	$var = strip_tags( $var );
	$var = str_replace(chr(0), '', $var);
	
	if ( $lower ) {
		$var = dle_strtolower($var);	
	}
	
	$var = str_replace( array( "\r\n", "\r", "\n" ), ' ', $var );
	$var = preg_replace( "/\s+/u", "-", $var );

	if ( !$punkt ) {
		$bads[] = '.';
	}
	
	$var = str_ireplace( $bads, '', $var );
	
	if( $translit ) {
		
		if (is_array($langtranslit) AND count($langtranslit) ) {
			$var = strtr($var, $langtranslit);
		}
		
		if ( $punkt ) {
			
			$var = preg_replace( "/[^a-z0-9\_\-.]+/mi", '', $var );
			$var = preg_replace( '#[.]+#i', '.', $var );
			
		} else $var = preg_replace( "/[^a-z0-9\_\-]+/mi", '', $var );
	
	}
	
	$var = str_ireplace( ".php", ".ppp", $var );
	$var = preg_replace( '/\-+/', '-', $var );
	
	if( dle_strlen( $var ) > 200 ) {
		
		$var = dle_substr( $var, 0, 200 );
		
		if( ($temp_max = dle_strrpos( $var, '-' )) ) $var = dle_substr( $var, 0, $temp_max );
	
	}
    
	$var = trim( $var, '-' );
    $var = trim( $var );
	
	return $var;
} 
?>