<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
 https://www.templatedlefr.fr/
-----------------------------------------------------
Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/

if( !defined( 'DATALIFEENGINE' ) ) {
	header( "HTTP/1.1 403 Forbidden" );
	header ( 'Location: ../../' );
	die( "Hacking attempt!" );
}
	if ($cstart) { $post_num_id = $cstart; }
	
	if ($fixpost and $cstart)
	{
		$post_num_id = $post_num_id - 1;
	}
	
	if ($check_moderator)
	{
		$deny_edit_post = moderator_value('edit_post', $forum_id, $m_member);
		
		$deny_del_post = moderator_value('delete_post', $forum_id, $m_member);;
	}
	
	if ($forum_groups[$member_id['user_group']]['post_edit'])
	{
		$group_post_edit = true;
	}
	else
	{
		$group_post_edit = false;
	}
	
	if ($forum_groups[$member_id['user_group']]['post_del'])
	{
		$group_post_del = true;
	}
	else
	{
		$group_post_del = false;
	}
	
	if ($forum_groups[$member_id['user_group']]['can_thanks'])
	{
		$group_can_thanks = true;
	}
	else
	{
		$group_can_thanks = false;
	}

	$posts_found = false;
	
	while ($row = $db->get_row($result_posts))
	{
		$post_num_id++;
		
		if (!$row['user_group']) $row['user_group'] = 5;
		
		if ($ajax_adds) $post_num_id = "--";
		
		$row['post_text'] = preg_replace( '#(\A[\s]*<br[^>]*>[\s]*|<br[^>]*>[\s]*\Z)#is', '', $row['post_text'] ); // remove <br/> at end of string
		
		if ($row['hidden'] == "1")
		{
			if ($check_moderator)
			{
				$row['post_text'] = "<div class=\"hidden_post\">{$f_lang['h_post']}:<br />".$row['post_text']."</div>";
			}
			else
			{
				$row['post_text'] = "<div class=\"hidden_post\">{$f_lang['h_post']}</div>";
			}
		}
		
		if ($search_text)
		{
			$row['post_text'] = hilites($search_text, $row['post_text']);
		}

// ********************************************************************************
// LOAD TEMPLATE
// ********************************************************************************	
		$tpl->load_template($tpl_dir.'post.tpl');
		
		if ($row['pid'] == $first_post)
		{
			$tpl->set('{post_id}', "<a href=\"javascript:PostLink({$row['pid']});\" name=\"post-{$row['pid']}\">1</a>");
		}
		else
		{
			$tpl->set('{post_id}', "<a href=\"javascript:PostLink({$row['pid']});\" name=\"post-{$row['pid']}\">{$post_num_id}</a>");
		}
		
		if ($row['edit_time'] and $row['reason_text']){

			$row['edit_time'] = strtotime($row['edit_time']);
			
  		    if( date( 'Ymd', $row['edit_time'] ) == date( 'Ymd', $_TIME ) ) {
			
			  $edit_time = $f_lang['time_heute'] . langdate( ", H:i", $row['edit_time'] );
		
		    } elseif( date( 'Ymd', $row['edit_time'] ) == date( 'Ymd', ($_TIME - 86400) ) ) {
			
			  $edit_time = $f_lang['time_gestern'] . langdate( ", H:i", $row['edit_time'] );
		
		    } else {
			
			  $edit_time = langdate( $setting['timestamp'], $row['edit_time'] );
		
		   }
	   
			
		$tpl->set('{edit-info}', "<br /><span class='edit-info'>{$f_lang['edit_info']}&nbsp;<b>{$row['edit_user']}</b> - ".$edit_time."<br /><b>{$f_lang['f_reason']}:</b><br /> ".$row['reason_text']."</span>");
		}else{
		$tpl->set('{edit-info}', "");
		}
		
		$go_page = "onClick=\"return dropdownmenu(this, event, FUserMenu('".urlencode($row['name'])."', '".$row['user_id']."', '".$member_id['user_group']."', '$a_forum_url'), '170px')\" onMouseout=\"delayhidemenu()\"";

			$group_span = $forum_groups[$row['user_group']]['group_colour'];
		
          if ($setting['mod_rewrite']){
			
			if( $config['allow_alt_url'] ) {

				$go_page = $config['http_home_url'] . "user/" . urlencode( $row['post_author'] ) . "/";

			} else {

				$go_page = "$PHP_SELF?subaction=userinfo&user=" . urlencode( $row['post_author'] );
				
			}
		  }

			$go_page = "onclick=\"ShowProfile('" . urlencode( $row['post_author'] ) . "', '" . htmlspecialchars( $go_page, ENT_QUOTES, $config['charset'] ) . "', '" . $user_group[$member_id['user_group']]['admin_editusers'] . "'); return false;\"";

         if ( !$row['name'] ) {
			$row_author = $f_lang['user_del'];
		}else{
		
			if( $config['allow_alt_url'] ){ 
			   $row_author = "<a {$go_page} href=\"" . $config['http_home_url'] . "user/" . urlencode( $row['post_author'] ) . "/\"><span style=\"color:{$group_span}\">".$row['post_author']."</span></a>";
			}else{ 
			   $row_author = "<a {$go_page} href=\"$PHP_SELF?subaction=userinfo&amp;user=" . urlencode( $row['post_author'] ) . "\"><span style=\"color:{$group_span}\">".$row['post_author']."</span></a>";
			}
			
		}
		
		if ($row['is_register']){ 			
		$tpl->set('{author}', $row_author);
		}else{ 			
		$tpl->set('{author}', "<a rel=\"nofollow\" href=\"mailto:".$row['e_mail']."\"><span style=\"color:{$group_span}\">{$row['post_author']}</span></a>");
		}
		
	if ($forum_groups[$row['user_group']]['icon']){
		
	$tpl->set( '{icon-group}', "<img src=\"" . $forum_groups[$row['user_group']]['icon'] . "\" border=\"0\" />" );

    }else{ 
	
	$tpl->set( '{icon-group}', "" );
	
	}
	
	$tpl->set( '{topic_url}', "");

	if ( count(explode("@", $row['foto'])) == 2 ) {
		$tpl->set( '{gravatar}', $row['foto'] );	

		$tpl->set( '{foto}', '//www.gravatar.com/avatar/' . md5(trim($row['foto'])) . '?s=' . intval($user_group[$row['user_group']]['max_foto']) );
	
	} else {
	
		if( $row['foto'] ) {
			
			if (strpos($row['foto'], "//") === 0) $avatar = "http:".$row['foto']; else $avatar = $row['foto'];

			$avatar = @parse_url ( $avatar );

			if( $avatar['host'] ) {
				
				$tpl->set( '{foto}', $row['foto'] );
				
			} else $tpl->set( '{foto}', $config['http_home_url'] . "uploads/fotos/" . $row['foto'] );
			
		} else $tpl->set( '{foto}', "{THEME}/dleimages/noavatar.png" );

		$tpl->set( '{gravatar}', '' );
	}
	
		$row_topic = $db->super_query("SELECT * FROM " . PREFIX . "_forum_topics as t LEFT JOIN " . PREFIX . "_forum_posts as p ON t.tid=p.topic_id WHERE t.tid = {$row['topic_id']}");  

         $tpl->set('{title}', $row_topic['title']);		
	
		//~~~~~~~~~~~~~~~~~~~~~
		// Уровень доверия
		//~~~~~~~~~~~~~~~~~~~~~
		$conf_points = array();
		$conf_points['regtime'] = round( ( ( $_TIME-$row['reg_date'])/864000 ), 2 ); // 0.1 за день с момента регистрации
		$conf_points['info'] = strlen($row['info']) < 10 ? 0 : 0.1; // 0.1 за зполнение информации о себе
		$conf_points['foto'] = ($row['foto'] and (file_exists( ROOT_DIR . "/uploads/fotos/" . $member_id['foto'] ))) ? 0.5 : 0; // 0.5 за загрузку авы
		$conf_points['land'] = $row['land'] == '' ? 0 : 0.2; // 0.2 за зполнение места жительства
		$conf_points['name'] = $row['fullname'] == '' ? 0 : 0.2; // 0.2 за зполнение имени
		$conf_points['news'] = ( $row['news_num']/10 ); // 0.1 за каждую новость
		$conf_points['comments'] = ( $row['comm_num']/100 ); // 0.01 за каждый комментарий

		$tpl->set('{confidence_level}', array_sum($conf_points));
		
		if( $is_logged AND $setting['confidence'] ) $tpl->set_block( "'\\[show_confidence\\](.*?)\\[/show_confidence\\]'si", "\\1" );
		else $tpl->set_block( "'\\[show_confidence\\](.*?)\\[/show_confidence\\]'si", "" );
		//~~~~~~~~~~~~~~~~~~~~
		// Уровень доверия
		//~~~~~~~~~~~~~~~~~~~~	
		
		if ($row['land']) $tpl->set('{land}', stripslashes($row['land']));
		else $tpl->set('{land}', '--');
		
		if ($row['fullname']) $tpl->set('{fullname}', stripslashes($row['fullname']));
		else $tpl->set('{fullname}', '--');
		
		if ($row['reg_date']) $tpl->set('{registration}', langdate("j.m.Y", $row['reg_date']));
		else $tpl->set('{registration}', '--');
		
		if ($row['is_register'] AND $row['signature'])
		{
			$tpl->set_block("'\\[signature\\](.*?)\\[/signature\\]'si","\\1");
			$tpl->set('{signature}', stripslashes($row['signature']));
		}
		else $tpl->set_block("'\\[signature\\](.*?)\\[/signature\\]'si","");
		
		if ($user_group[$row['user_group']]['icon'])
		$tpl->set('{group-icon}', "<img src=\"".$user_group[$row['user_group']]['icon']."\" border=\"0\" />");
		else
		$tpl->set('{group-icon}', "");
		
		if ($forum_groups)
		{
			$group_span = $forum_groups[$row['user_group']]['group_colour'];
			
			$group_name =  "<span style=\"color:{$group_span}\">".$user_group[$row['user_group']]['group_name']."</span>";
		}
		else
		{
			$group_name = $user_group[$row['user_group']]['group_name'];
		}
		
		if ($row['banned'])
		{
			$group_name = "BANNED";
		}
		
		$tpl->set('{group-name}', $group_name);
		
		$tpl->set('{post-num}', intval($row['forum_post']));
		$tpl->set('{news-num}', intval($row['news_num']));
		$tpl->set('{f_thx_num}', intval($row['f_thx_num']));
		$tpl->set('{comm-num}', intval($row['comm_num']));

// ********************************************************************************
// POST SELECTED
// ********************************************************************************	
		if ($check_moderator AND $post_num_id != 1)
		$tpl->set('{selected}', "<input class=\"check-input \" OnClick=\"select_id('{$row['pid']}');\" type='checkbox' name=\"sid[{$row['pid']}]\" value=\"{$row['pid']}\">");
		else
		$tpl->set('{selected}', "");
	
include_once ENGINE_DIR.'/forum/sources/components/edit_options.php';
// ********************************************************************************
// POST DATE
// ********************************************************************************	
		$row['post_date'] = strtotime($row['post_date']);
		
  		    if( date( 'Ymd', $row['post_date'] ) == date( 'Ymd', $_TIME ) ) {
			
			  $tpl->set( '{post-date}', $f_lang['time_heute'] . langdate( ", H:i", $row['post_date'] ) );
		
		    } elseif( date( 'Ymd', $row['post_date'] ) == date( 'Ymd', ($_TIME - 86400) ) ) {
			
			  $tpl->set( '{post-date}', $f_lang['time_gestern'] . langdate( ", H:i", $row['post_date'] ) );
		
		    } else {
			
			  $tpl->set( '{post-date}', langdate( $setting['timestamp'], $row['post_date'] ) );
		
		   }	
		
		if (!$setting['mod_report'] and $is_logged)
		{
			$tpl->set('[report]',"<a href=\"{$a_forum_url}&act=_topic&code=report&tid={$tid}&pid={$post_num_id}\">");
			$tpl->set('[/report]',"</a>");
		}
		else
		{
			$tpl->set_block("'\\[report\\](.*?)\\[/report\\]'si","");
		}

// ********************************************************************************
// Systeme de quote
// ********************************************************************************	
		if ($check_write AND !$row['hidden'])
		{
			$tpl->set('[fast]',"<a href=\"{$a_forum_url}&act=_topic&code=reply&tid={$tid}&quote={$row['pid']}\">");
			$tpl->set('[/fast]',"</a>");
		}
		else
		{
			$tpl->set_block("'\\[fast\\](.*?)\\[/fast\\]'si","");
		}		

// ********************************************************************************
// RANK
// ********************************************************************************	
		if ($setting['mod_rank'] and $rank_array != 'empty')
		{
			if (!$row['forum_post']) $row['forum_post'] = 0;
			
			foreach ($rank_array as $value)
			{
				if ($row['forum_post'] >= $value['posts'])
				{
					$rank_title = $value['title'];
					
					$rank_num = $value['pips'];
				}
			}
			
			if ($row['forum_rank']) $rank_title = $row['forum_rank'];
			
			if ($row['forum_pips']) $rank_num = $row['forum_pips'];
			
			$rating = $rank_num * 17;
			
			$rank_image = "<div class=\"rank\">
			<ul class=\"unit-rank\">
			<li class=\"current-rank\" style=\"width:{$rating}px;\">{$rating}</li>
			</ul>
			</div><br />";
		}
		
		$tpl->set('{rank-title}', $rank_title);
		
		$tpl->set('{rank-image}', $rank_image);
		
// **********************
// ONLINE
// *********************

        if ( ($row['lastdate'] + 1200) > $_TIME ) {

            $tpl->set( '[online]', "" );
            $tpl->set( '[/online]', "" );
            $tpl->set_block( "'\\[offline\\](.*?)\\[/offline\\]'si", "" );

        } else {
            $tpl->set( '[offline]', "" );
            $tpl->set( '[/offline]', "" );
            $tpl->set_block( "'\\[online\\](.*?)\\[/online\\]'si", "" );
        }

// ********************************************************************************
// WARN
// ********************************************************************************	
		if ($setting['warn'] and $setting['warn_group'])
		{
			if (in_array($row['user_group'], explode (',', $setting['warn_group'])) AND !$setting['warn_sh_pg']){ $not_warn = 1; }
		}
		
		if ($setting['warn_show'] AND $member_id['name'] == $row['post_author']) $is_warn = 1;
		
		if ($setting['warn_show_all']) { $is_warn = 1; }
		
		if ($check_moderator) { $is_warn = 1; }
		
		if ($setting['warn'] and $is_warn and !$not_warn and $row['user_id'])
		{
			if ($check_moderator)
			{
				$warn_add = "<a OnClick=\"FWarn('add', '$row[user_id]', '$row[pid]', '$forum_id');\" title='".$f_lang['f_display']."'><i class=\"fa fa-plus\" aria-hidden=\"true\" style=\"color:#08c30d;\"></i></a>";
				
				$warn_minus = "<a OnClick=\"FWarn('minus', '$row[user_id]', '$row[pid]', '$forum_id');\" title='".$f_lang['f_hide']."'><i class=\"fa fa-minus\" aria-hidden=\"true\" style=\"color:#c30835;\"></i></a>";
			}
			
			$warn_user = $row['forum_warn'];
			
			if ($warn_user > $setting['warn_max']) $warn_user = $setting['warn_max'];
			
			$warn_set = (5 / $setting['warn_max']);
			
			$warn_num = ceil($warn_set * $warn_user);
			
			$warn_pt = "{$warn_user} / {$setting['warn_max']}";
			
			$warn = $warn_minus . link_warn($row['post_author'], "<div id='warn-{$row['pid']}'><img src='{THEME}/forum/images/warn{$warn_num}.png' title='{$warn_pt}' border='0' /></div>") . $warn_add;
			
			$tpl->set_block("'\\[warn\\](.*?)\\[/warn\\]'si","\\1");
			
			$tpl->set('{warn}', $warn);
		}
		else
		{
			$tpl->set_block("'\\[warn\\](.*?)\\[/warn\\]'si","");
		}
		
		unset($warn); unset($is_warn); unset($not_warn);

// ********************************************************************************
// REPUTATION
// ********************************************************************************	
		if ($setting['reputation'] and $row['user_id'])
		{
			if ($is_logged && !$read_mode)
            {
                $rep_m = "<a OnClick=\"FRep('-', '$row[user_id]', '$row[pid]', '$forum_id');\"><i class=\"fa fa-thumbs-down\" aria-hidden=\"true\" title=\"{$f_lang['f_rep_m']}\" style=\"color:#c30835;\"></i></a>&nbsp;";
                
			$rep_p = "&nbsp;<a OnClick=\"FRep('+', '$row[user_id]', '$row[pid]', '$forum_id');\"><i class=\"fa fa-thumbs-up\" aria-hidden=\"true\" title=\"{$f_lang['f_rep_p']}\" style=\"color:#08c30d;\"></i></a>";
            }
            else
            {
                $rep_m = ''; $rep_p = '';
            }
			
			$reputation = $rep_m . link_rep($row['post_author'], "<span id='rep-{$row['pid']}'>" . $row['forum_reputation'] . "</span>") . $rep_p;
			
			$tpl->set('{reputation}', $reputation);
		}
		else
		{
			$tpl->set('{reputation}', "--");
		}
		
		unset ($reputation);
		
		if ($check_moderator)
		$tpl->set('{ip}', "IP: <a onClick=\"return dropdownmenu(this, event, IPMenu('".$row['post_ip']."', '".$lang['ip_info']."', '".$lang['ip_tools']."', '".$lang['ip_ban']."'), '190px')\" onMouseout=\"delayhidemenu()\" href=\"http://www.nic.ru/whois/?ip={$row['post_ip']}\" target=\"_blank\">{$row['post_ip']}</a>");
		else $tpl->set('{ip}', '');

// ********************************************************************************
// POST EDIT
// ********************************************************************************	
		if (($member_id['name'] == $row['post_author']) && $group_post_edit && !$row['hidden'] && !$read_mode OR $deny_edit_post)
		{
                
			   if($setting['edit_ajax']){ 
                $tpl->set('[post-edit]',"<a onClick=\"return dropdownmenu(this, event, PostEditMenu('$row[pid]', '$a_forum_url', '$page', '$post_num_id'), '170px')\" onMouseout=\"delayhidemenu()\" href=\"#\">");
			   $tpl->set('[/post-edit]',"</a>");
               }else{
			    $tpl->set('[post-edit]',"<a href=\"{$a_forum_url}&amp;act=post&amp;code=02&amp;pid=$row[pid]&amp;p=$page&amp;pn=$post_num_id\">");
			   $tpl->set('[/post-edit]',"</a>");
               }
		}
		else
		{
			$tpl->set_block("'\\[post-edit\\](.*?)\\[/post-edit\\]'si","");
		}

// ********************************************************************************
// POST DEL
// ********************************************************************************	
		if (($member_id['name'] == $row['post_author']) AND $group_post_del AND !$row['hidden'] && !$read_mode OR $deny_del_post)
		{
			if ($post_num_id != 1)
			{
			       $tpl->set('[post-del]','<a href=\'javascript:postDelete("'.$a_forum_url.'&act=post&code=04&selected_id='.$row['pid'].'")\'>');
				   $tpl->set('[/post-del]',"</a>");
			}
			else
			{
				$tpl->set_block("'\\[post-del\\](.*?)\\[/post-del\\]'si","");
			}
		}
		else
		{
			$tpl->set_block("'\\[post-del\\](.*?)\\[/post-del\\]'si","");
		}
		
// ********************************************************************************
// POST THANKS
// ********************************************************************************
	
	$users_thanks = array();
	
	$result_thanks = $db->query("SELECT t.*, u.* FROM " . PREFIX . "_forum_thanks AS t LEFT JOIN " . USERPREFIX . "_users AS u ON t.thanks_by=u.name WHERE t.post_id = ".$row['pid']);
	while ($thanks = $db->get_row($result_thanks))
	{
		$top_count++;
				
				if ($top_count > 1)
				{
					$symbol = ", ";
				}
	        $group_span = $forum_groups[$thanks['user_group']]['group_colour'];
				
          if ($setting['mod_rewrite']){
			
			if( $config['allow_alt_url'] ) {

				$go_page = $config['http_home_url'] . "user/" . urlencode( $f_thx['thanks_by'] ) . "/";

			} else {

				$go_page = "$PHP_SELF?subaction=userinfo&user=" . urlencode( $f_thx['thanks_by'] );
				
			}
		  }

			$go_page = "onclick=\"ShowProfile('" . urlencode( $f_thx['thanks_by'] ) . "', '" . htmlspecialchars( $go_page, ENT_QUOTES, $config['charset'] ) . "', '" . $user_group[$member_id['user_group']]['admin_editusers'] . "'); return false;\"";

			if( $config['allow_alt_url'] ){ 
			   $users_thanks[] = "<a {$go_page} href=\"" . $config['http_home_url'] . "user/" . urlencode( $f_thx['thanks_by'] ) . "/\"><span style=\"color:{$group_span}\">".$f_thx['thanks_by']."</span></a>";
			}else{ 
			   $users_thanks[] = "<a {$go_page} href=\"$PHP_SELF?subaction=userinfo&amp;user=" . urlencode( $f_thx['thanks_by'] ) . "\"><span style=\"color:{$group_span}\">".$f_thx['thanks_by']."</span></a>";
			}
	}
	
	

		$numUsers = $db->num_rows($result_thanks);

		$user_list = ($numUsers>0) ? implode(', ',$users_thanks) : $f_lang['Thanks_one'];


$thank_user = <<<HTML
<!--num:{$numUsers}-->
<div class="title_spoiler"><i id="image-thanks" class="fa fa-plus"></i>&nbsp;<a href="javascript:ShowOrHide('thanks_{$row['pid']}')">{$f_lang['Num_Thanks']}: {$numUsers}</a></div>
<div id="thanks_{$row['pid']}" class="text_spoiler" style="display:none;">{$user_list}</div>
HTML;

	    $tpl->set('{thank_user}', $thank_user);

     if (!$group_can_thanks OR ! $is_logged OR $member_id['name'] == $row['post_author']){
		 $tpl->set_block("'\\[can_thanks\\](.*?)\\[/can_thanks\\]'si","");
     }else{
		if ($group_can_thanks && !$row['hidden'] && !$read_mode OR $deny_edit_post)
		{
                $tpl->set('[can_thanks]',"<a href=\"#\" onclick=\"ajax_tanks('{$row['pid']}'); return false;\">");
                $tpl->set('[/can_thanks]',"</a>");
		}
		else
		{
			$tpl->set_block("'\\[can_thanks\\](.*?)\\[/can_thanks\\]'si","");
		}
		
		$tpl->set('{pid}',$row['pid']);


$tpl->copy_template .= <<<HTML
<script type="text/javascript">
<!--

function ajax_tanks(pid) {
    ShowLoadingBoard();

    $.post(dle_root + "engine/forum/ajax/controller.php?mod=thanks", 
	{thanks:'ajax_tanks', post_id:pid},
	function (data) {
        $("#thx-layer-" + pid).html(data);
    });
    HideLoadingBoard();
    return false;
}
//-->

</script>
HTML;
	}
// ********************************************************************************
// POST TEXT
// ********************************************************************************	
		
		$tpl->set('{text}', "<div id='post-id-{$row['pid']}'>".$row['post_text']."</div>");
		
		if (stristr ($tpl->copy_template, "[xfvalue_")) $xfound = true; else $xfound = false;
		if ($xfound) $xfields = xfieldsload(true);
		
		if ($xfound)
		{
			include ENGINE_DIR.'/forum/sources/components/xfields.php';
		}
		
		
		$tpl->compile('posts');
		
		$tpl->clear();
		
		
		$posts_found = true;
	}
	
	$access_download = $forums_array[$row['forum_id']]['access_download'];
	
	if ($is_logged OR $access_download){
		
	if (stristr ($tpl->result['posts'], "[attachment="))
	{
		require_once ENGINE_DIR.'/forum/sources/components/attachment.php';
	}
	}else{
		$attachment = <<<HTML
	<div class="rules rules-link">
		<div class="inner">
              <h4>Information</h4>

				{$f_lang['no_download']}
		
		</div>
	</div>
HTML;
		
		$tpl->result['posts'] = preg_replace( "'\[attachment=(.*?)\]'si", $attachment, $tpl->result['posts'] );
	}
	
	$tpl->result['posts'] .= "\n<span id='ajax-post'></span>\n";
?>