<!DOCTYPE html>
<html lang="ru">
    <head>
        {headers}
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="referrer" content="no-referrer" />
        <link rel="shortcut icon" href="{THEME}/images/favicon.png" />
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet" />
        [group=1]
        <link href="{THEME}/css/swiper.min.css" type="text/css" rel="stylesheet" />
        <link href="{THEME}/css/common.css" type="text/css" rel="stylesheet" />
        <link href="{THEME}/css/styles.css" type="text/css" rel="stylesheet" />
        <link href="{THEME}/css/engine.css" type="text/css" rel="stylesheet" />
        [/group] [not-group=1]
        <link type="text/css" rel="stylesheet" href="/engine/classes/min/index.php?f={THEME}/css/swiper.min.css,{THEME}/css/common.css,{THEME}/css/styles.css,{THEME}/css/engine.css" />
        [/not-group]
    </head>

    <body>
        {AJAX}
        <div class="wrapper">
            <header class="header [not-available=main|showfull]header-full[/not-available] d-flex jc-space-between ai-center">
                <a class="header__logo" href="/">
                    <span>K1no</span><p>lite</p>
                    {*<img src="{THEME}/images/logo.png" />*}
                </a>
                <ul class="header__menu d-flex js-this-in-mobile-menu">
                    <li><a href="/lastnews/">Премьеры</a></li>
                    <li class="submenu">
                        <a href="#">Жанр</a>
                        <ul class="header__menu-hidden">
                            <li><a href="/xfsearch/tags/Комедия/">Комедия</a></li>
                            <li><a href="/xfsearch/tags/Мелодрама/">Мелодрама</a></li>
                            <li><a href="/xfsearch/tags/Приключения/">Приключения</a></li>
                            <li><a href="/xfsearch/tags/Детектив/">Детектив</a></li>
                            <li><a href="/xfsearch/tags/Военный/">Военный</a></li>
                            <li><a href="/xfsearch/tags/Мультфильмы/">Мультфильмы</a></li>
                            <li><a href="/xfsearch/tags/Драма/">Драма</a></li>
                            <li><a href="/xfsearch/tags/Семейный/">Семейный</a></li>
                            <li><a href="/xfsearch/tags/Фантастика/">Фантастика</a></li>
                            <li><a href="/xfsearch/tags/Боевик/">Боевик</a></li>
                            <li><a href="/xfsearch/tags/Фэнтези/">Фэнтези</a></li>
                            <li><a href="/xfsearch/tags/Исторический/">История</a></li>
                        </ul>
                    </li>
                    <li><a href="/film/">Фильмы</a></li>
                    <li><a href="/series/">Сериалы</a></li>
                    <li><a href="/multfilm/">Мультфильмы</a></li>
                </ul>

                <div class="header__authorization d-flex ai-center">
                    <form id="quicksearch" method="post">
                        <input type="hidden" name="do" value="search" />
                        <input type="hidden" name="subaction" value="search" />
                        <div class="header__search">
                            <div class="header__search-icon" type="submit"><i class="fa fa-search"></i></div>
                            <input id="story" name="story" class="header__search-input" placeholder="Найти..." />
                        </div>
                    </form>
                    [group=5] {*<a href="/?do=register" class="header__register-link">Регистрация</a>*}
                    <div class="header__sign-in js-show-login"><span class="far fa-sign-in"></span></div>
                    [/group] [not-group=5]
                    <div class="header__sign-in js-show-login"><span class="far fa-user"></span></div>
                    [/not-group]
                    <div class="header__btn-menu d-none js-show-mobile-menu"><span class="fal fa-bars"></span></div>
                </div>
            </header>

            [available=main]

            <div class="swiper-container slider-main">
                <div class="swiper-wrapper">
                    {custom fixed="yes" template="slider" aviable="global" from="0" limit="12" order="date" sort="desc" cache="yes"}
                </div>
                <div class="slider-button-prev">
                    <i class="fal fa-angle-left"></i>
                </div>
                <div class="slider-button-next">
                    <i class="fal fa-angle-right"></i>
                </div>
            </div>

            [/available] [available=main]{include file="main-page.tpl"} [/available]

            <div class="container">
                [not-available=cat|search]{info}[/not-available] [available=cat|search]
                <div class="content">
                    {content}{info}
                </div>
                [/available] [not-available=main|showfull|cat|search|static|register|userinfo|pm|stats|feedback|addnews|lostpassword|lastcomments] [aviable=cat]
                <h1 class="section__title">{category-title}</h1>
                [/aviable] [aviable=favorites]
                <h1 class="section__title">Избранное</h1>
                [/aviable] [aviable=lastnews]
                <h1 class="section__title">Премьеры</h1>
                [/aviable] [aviable=xfsearch]
                <h1 class="section__title">{page-title}</h1>
                [/aviable] {content} [/not-available] [available=static|register|userinfo|pm|stats|feedback|addnews|lostpassword|lastcomments]
                <div class="pages-bg">{content}</div>
                [/available]
            </div>

            [available=showfull]{content}[/available]

            <footer class="footer d-flex ai-center">
                <div class="container">
                    {*
                    <div class="footer__left order-last">
                        <a href="//freekassa.ru/"><img src="//www.free-kassa.ru/img/fk_btn/5.png" title="Приём оплаты на сайте картами" /></a>
                    </div>
                    *}
                    <div class="footer__right stretch-free-width">
                        <ul class="footer__menu d-flex js-flex-start">
                            <li><a href="#">Премьеры</a></li>
                            <li><a href="#">Новинки 2020</a></li>
                            <li><a href="#">Мультфильмы</a></li>
                            <li><a href="#">Подборки</a></li>
                            <li><a href="#">Обратная связь</a></li>
                        </ul>
                        <div class="footer__copyright">
                            Copyright © 2021 MegaK1no
                        </div>
                    </div>
                </div>
            </footer>
        </div>

        {login}
        <script src="{THEME}/js/swiper.min.js"></script>
        <script src="{THEME}/js/libs.js"></script>
        <script async="" src="https://yastatic.net/share2/share.js"></script>
    </body>
</html>