<?php
/*
=================================================================
Bullet Energy - by White-Master 
-----------------------------------------------------------------
http://white-master.ru/
-----------------------------------------------------------------
Copyright (c) 2011 White-Master
=================================================================
    
=================================================================
: linck.class.php
=================================================================
*/
class BulletEnergyLinck
{
  private $cpu = false;
  private $root = '';
  private $rootNotPrefix = '';
  private $endLinckSymbol = '';
  private $router = array();
  private $type = 0;
  public function __construct(array $data = array())
  {
    $this->rootNotPrefix = $data['home'];
    if ($data['cpu']) {
      $this->cpu = true;
      $this->root = $data['home'];
    } else {
      $this->cpu = false;
      $this->root = $data['home'] . "index.php";
    }
    $this->router = $data['router'];
    $this->type = (int)$data['type'];
    if (!empty($data['slash']) and $this->cpu) {
      $this->endLinckSymbol = '/';
    }
  }
  /**
   * BulletEnergyLinck::postLinck()
   *      .
   * @param string $topicId   -  .
   * @param string $messageId -  .
   * @param string $topicName -    .
   * @return
   */
  public function postLinck($topicId = '', $messageId = '', $topicName = '')
  {
    $result = '';
    if ($this->cpu) {
      if ($this->type) {
        $result = "{$this->root}{$this->router['main']}/{$this->router['topic']}{$topicId}/findpost-{$messageId}{$this->endLinckSymbol}";
      } else {
        $result = "{$this->root}{$this->router['main']}/{$this->router['topic']}/{$topicId}-{$topicName}/findpost-{$messageId}{$this->endLinckSymbol}";
      }
    } else {
      $result = "{$this->root}?do=forum&action=findpost&id={$topicId}&findpost={$messageId}";
    }
    return $result;
  }
  /**
   * BulletEnergyLinck::cat_linck()
   *      .
   * @param string $id   -  .
   * @param string $name -    .
   * @return
   */
  public function cat_linck($id = '', $name = '')
  {
    $result = '';
    if ($this->cpu) {
      if ($this->type) {
        $result = "<a href=\"{$this->root}{$this->router['main']}/{$this->router['tree']}{$id}{$this->endLinckSymbol}\">";
      } else {
        $result = "<a href=\"{$this->root}{$this->router['main']}/{$this->router['tree']}/{$id}-{$name}{$this->endLinckSymbol}\">";
      }
    } else {
      $result = "<a href=\"{$this->root}?do=forum&action=categories&id={$id}\">";
    }
    return $result;
  }
  /**
   * BulletEnergyLinck::topic_linck()
   *     .
   * @param string $id   -  .
   * @param string $name -    .
   * @return
   */
  public function topic_linck($id = '', $name = '')
  {
    $result = '';
    if ($this->cpu) {
      if ($this->type) {
        $result = "<a href=\"{$this->root}{$this->router['main']}/{$this->router['topic']}{$id}{$this->endLinckSymbol}\">";
      } else {
        $result = "<a href=\"{$this->root}{$this->router['main']}/{$this->router['topic']}/{$id}-{$name}{$this->endLinckSymbol}\">";
      }
    } else {
      $result = "<a href=\"{$this->root}?do=forum&action=showtopic&id={$id}\">";
    }
    return $result;
  }
  /**
   * BulletEnergyLinck::topicIsRedirect()
   *      .
   * @param string $id   -  .
   * @param string $name -    .
   * @return
   */
  public function topicIsRedirect($id = '', $name = '')
  {
    $result = '';
    if ($this->cpu) {
      if ($this->type) {
        $result = "{$this->root}{$this->router['main']}/{$this->router['topic']}{$id}{$this->endLinckSymbol}";
      } else {
        $result = "{$this->root}{$this->router['main']}/{$this->router['topic']}/{$id}-{$name}{$this->endLinckSymbol}";
      }
    } else {
      $result = "{$this->root}?do=forum&action=showtopic&id={$id}";
    }
    return $result;
  }
  public function topicIsUnread($id = '', $name = '')
  {
    $result = '';
    if ($this->cpu) {
      $result = "{$this->root}{$this->router['main']}/unread/{$id}{$this->endLinckSymbol}";
    } else {
      $result = "{$this->root}?do=forum&action=unread&id={$id}";
    }
    return $result;
  }
  /**
   * BulletEnergyLinck::treeLinck()
   *      .
   * @param string $id   -  .
   * @param string $name -    .
   * @return
   */
  public function treeLinck($id = '', $name = '')
  {
    if ($this->cpu) {
      if ($this->type) {
        return "{$this->root}{$this->router['main']}/{$this->router['tree']}{$id}{$this->endLinckSymbol}";
      } else {
        return "{$this->root}{$this->router['main']}/{$this->router['tree']}/{$id}-{$name}{$this->endLinckSymbol}";
      }
    } else {
      return "{$this->root}?do=forum&action=categories&id={$id}";
    }
  }
  /**
   * BulletEnergyLinck::topicLinck()
   *     .
   * @param string $id   -  .
   * @param string $name -    .
   * @return
   */
  public function topicLinck($id = '', $name = '')
  {
    // var_dump("{$this->root}{$this->router['main']}/{$this->router['topic']}{$id}{$this->endLinckSymbol}");
    if ($this->cpu) {
      if ($this->type) {
        return "{$this->root}{$this->router['main']}/{$this->router['topic']}{$id}{$this->endLinckSymbol}";
      } else {
        return "{$this->root}{$this->router['main']}/{$this->router['topic']}/{$id}-{$name}{$this->endLinckSymbol}";
      }
    } else {
      return "{$this->root}?do=forum&action=showtopic&id={$id}";
    }
  }
  public function pageNewPost()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['new_post']}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=new_post";
  }
  public function userMessage($userName = '')
  {
    return $this->cpu ? "{$this->root}user/" . urlencode($userName) . "/message{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=message_user&name=" . urlencode($userName);
  }
  public function userTrophies($userName = '', $userId = 0, $ajax = false, $title = '')
  {
    if ($ajax) {
      return $this->cpu ? '<a onclick="getTrophiesUser(\'' . $userId . '\'); return false;" title="' . $title . '" href="' . $this->root . 'user/' . urlencode($userName) . '/trophies' . $this->endLinckSymbol . '">' : '<a onclick="getTrophiesUser(\'' . $userId . '\'); return false;" title="' . $title . '" href="' . $this->root . '?do=forum&action=trophies&name=' . urlencode($userName) . '">';
    } else {
      return $this->cpu ? '<a title="' . $title . '" href="' . $this->root . 'user/' . urlencode($userName) . '/trophies' . $this->endLinckSymbol . '">' : '<a title="' . $title . '" href="' . $this->root . '?do=forum&action=trophies&name=' . urlencode($userName) . '">';
    }
  }
  public function userTopic($userName = '')
  {
    return $this->cpu ? "{$this->root}user/" . urlencode($userName) . "/topic{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=topic_user&name=" . urlencode($userName);
  }
  public function watchedLinck()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['watched']}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=watched";
  }
  public function watchedLinckAll()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['watched']}/all{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=watched_all";
  }
  public function linck_autor($userName = '')
  {
    return $this->cpu ? "<a href=\"{$this->root}user/" . urlencode($userName) . "/\">" . $userName . "</a>" : "<a href=\"{$this->root}?subaction=userinfo&user=" . urlencode($userName) . "\">" . $userName . "</a>";
  }
  public function linckUserSiteProfile($userName = '')
  {
    return $this->cpu ? "<a href=\"" . $this->root . "user/" . urlencode($userName) . "/\">" : "<a href=\"{$this->root}?subaction=userinfo&user=" . urlencode($userName) . "\">";
  }
  public function new_topic_linck($id = '')
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['new_topic']}{$id}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=newtopic&id={$id}";
  }
  public function user_linck($name = '')
  {
    $ajax = $this->cpu ? "{$this->root}user/" . urlencode($name) . "/" : "{$this->root}?subaction=userinfo&user=" . urlencode($name);
    return "<a onclick=\"ShowProfile('" . urlencode($name) . "', '" . $ajax . "'); return false;\" href=\"" . $ajax . "\">" . $name . "</a>";
  }
  public function attachLinck($id = '')
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['attachment']}{$id}{$this->endLinckSymbol}" : "{$this->rootNotPrefix}engine/bullet_energy/modules/download.php?id={$id}";
  }
  public function rssTree($id = '')
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['rss_tree']}{$id}.xml" : "{$this->rootNotPrefix}engine/bullet_energy/modules/rss.php?action=tree_rss&id={$id}";
  }
  public function rssTopic($id = '')
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['rss_topic']}{$id}.xml" : "{$this->rootNotPrefix}engine/bullet_energy/modules/rss.php?action=topic_rss&id={$id}";
  }
  public function linckMainPageForum()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=main";
  }
  public function linckModeration()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['moderation']}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=moderation";
  }
  public function searchLinck()
  {
    return $this->cpu ? "{$this->root}{$this->router['main']}/{$this->router['search']}{$this->endLinckSymbol}" : "{$this->root}?do=forum&action=search";
  }
  public function sub_navigate_linck($action = '')
  {
    if ($this->cpu) {
      $result = $this->router['main'];
      switch ($action) {
        case 'search':
          $result .= "/{$this->router['search']}{$this->endLinckSymbol}";
          break;
        case 'new_post':
          $result .= "/{$this->router['new_post']}{$this->endLinckSymbol}";
          break;
        default:
          $result .= "";
          break;
      }
    } else {
      switch ($action) {
        case 'search':
          $result = '?do=forum&action=search';
          break;
        case 'new_post':
          $result = '?do=forum&action=new_post';
          break;
        default:
          $result = '?do=forum&action=main';
          break;
      }
    }
    return $this->root . $result;
  }
  public function card_user($data = array())
  {
    $url = $this->cpu ? $this->root . 'user/' . urlencode($data[0]) : $this->root . '?subaction=userinfo&user=' . urlencode($data[0]);
    $ajax = "onclick=\"getUserCard('" . $data[1] . "','" . $url . "/','" . urlencode($data[0]) . "'); return false;\"";
    return $this->cpu ? "<a class=\"popup_profile\" {$ajax} href=\"{$this->root}user/" . urlencode($data[0]) . "/\">" : "<a class=\"popup_profile\" {$ajax} href=\"{$this->root}?subaction=userinfo&user=" . urlencode($data[0]) . "\">";
  }
  public function setLinckCardUser(array $data = array())
  {
    $url = $this->cpu ? $this->root . 'user/' . urlencode($data[0]) : $this->root . '?subaction=userinfo&user=' . urlencode($data[0]);
    $ajax = "onclick=\"getUserCard('" . $data[1] . "','" . $url . "/','" . urlencode($data[0]) . "'); return false;\"";
    return $this->cpu ? "<a title = \"" . $data[2] . "\" class=\"popup_profile\" {$ajax} href=\"{$this->root}user/" . urlencode($data[0]) . "/\">" : "<a title = \"" . $data[2] . "\" class=\"popup_profile\" {$ajax} href=\"{$this->root}?subaction=userinfo&user=" . urlencode($data[0]) . "\">";
  }
  public function reputationPermaLinck($name = '', $action = '', $subInfo = '', $uID = '', $pID = '')
  {
    if ($action == 'plus') {
      return $this->cpu ? "<a onclick=\"repa_global('form', '1', $uID, $pID); return false;\" href=\"#\"><img title=\" \" src=\"{THEME}/images/repa_up.gif\" border=\"0\"></a>" : "<a onclick=\"repa_global('form', '1', $uID, $pID); return false;\" href=\"#\" ><img title=\" \" src=\"{THEME}/images/repa_up.gif\" border=\"0\"></a>";
    } elseif ($action == 'minus') {
      return $this->cpu ? "<a onclick=\"repa_global('form', '0', $uID, $pID); return false;\" href=\"#\"><img title=\" \" src=\"{THEME}/images/repa_dn.gif\" border=\"0\"></a>" : "<a onclick=\"repa_global('form', '0', $uID, $pID); return false;\" href=\"#\" ><img title=\" \" src=\"{THEME}/images/repa_dn.gif\" border=\"0\"></a>";
    } elseif ($action == 'user') {
      return $this->cpu ? "<a href=\"{$this->root}user/reputation/" . urlencode($name) . "/\">" . $subInfo . "</a>" : "<a href=\"{$this->root}?do=reputation&user=" . urlencode($name) . "\">" . $subInfo . "</a> ";
    }
  }
  public function spedbar_linck($action = '')
  {
    if ($this->cpu) {
      switch ($action) {
        case 'online':
          $result = "{$this->router['main']}/members{$this->endLinckSymbol}";
          break;
        case 'help':
          $result = "{$this->router['main']}/help{$this->endLinckSymbol}";
          break;
        default:
          $result = "{$this->router['main']}";
          break;
      }
    } else {
      switch ($action) {
        case 'online':
          $result = '?do=forum&action=members';
          break;
        case 'help':
          $result = '?do=forum&action=help';
          break;
        default:
          $result = '?do=forum&action=main';
          break;
      }
    }
    return $this->root . $result;
  }
}

?>