<?php

/*
=================================================================
Bullet Energy - by White-Master 
-----------------------------------------------------------------
http://white-master.ru/
-----------------------------------------------------------------
Copyright (c) 2011 White-Master
=================================================================
    
=================================================================
: main_handler.class.php
=================================================================
*/
class BulletEnergyHandler extends BulletEnergy
{
   public $db = null;
   private $casheSySPath = '';
   public $time = 0;
   private $timeMarkerOldTopic = 0;
   private $userID = '';
   private $page = 0;
   private $id = 0;
   private $filter = null;
   public $linck = null;
   private $userName = '';
   private $sideBar = array();
   private $subTpl = array();
   public $ajax = false;
   public function __construct()
   {
      require_once (ENGINE_DIR . '/bullet_energy/classes/filter.class.php');
      $this->filter = new BulletFilter;
      $this->filter->allow_url = parent::$group_user[parent::$id_member['user_group']]['allow_url'];
      $this->filter->allow_image = parent::$group_user[parent::$id_member['user_group']]['allow_image'];
      require_once (ENGINE_DIR . '/bullet_energy/classes/linck.class.php');
      $this->linck = new BulletEnergyLinck(array('router' => parent::$router, 'slash' => parent::$modules_config['slash'], 'type' => parent::$modules_config['is_cpu_type'], 'cpu' => parent::$modules_config['cpu'], 'home' => parent::$config_dle['http_home_url']));
      if(!class_exists('db')) {
         require_once ENGINE_DIR . '/classes/mysql.class.php';
      }
      $this->db = new db;
      $this->casheSySPath = ENGINE_DIR . '/bullet_energy/cache/system/';
      $this->time = time() + (parent::$config_dle['date_adjust'] * 60);
      $this->timeMarkerOldTopic = $this->time - parent::$modules_config['topic_day'] * 86400;
      $this->subTpl = array(10, 20);
      $this->userID = parent::$id_member['user_id'];
      $this->userName = $this->db->safesql(parent::$id_member['name']);
      $this->id = $this->getInt('id');
      $this->page = $this->getInt('page');
      $this->sideBar = array('main', 'categories', 'showtopic', 'trophies');
      $this->ajax = $this->_isAjax();
   }

   protected function _syntaxUrlCheck()
   {

      if(!parent::$modules_config['handler_cpu'] or !parent::$modules_config['cpu']) {
         return false;
      }
      $isSlash = substr($_SERVER['REQUEST_URI'], -1);
      if(!parent::$modules_config['slash'] and $isSlash == '/') {
         $leght = $this->_dle_strlen($_SERVER['REQUEST_URI'], parent::$config_dle['charset']) - 1;
         $url = substr($_SERVER['REQUEST_URI'], 0, $leght);
         header("HTTP/1.0 301 Moved Permanently");
         header("Location: {$url}");
         die("Redirect");
      } elseif(parent::$modules_config['slash'] and $isSlash != '/') {
         header("HTTP/1.0 301 Moved Permanently");
         header("Location: {$_SERVER['REQUEST_URI']}/");
         die("Redirect");
      }
   }
   protected function _transcred()
   {

      return file_exists(ENGINE_DIR . "/" . parent::$modules_lang['setting_428'] . parent::$modules_lang['setting_430'] . "/" . parent::$modules_lang['setting_429'] . "/" . parent::$modules_lang['setting_431'] . "." . parent::$modules_lang['setting_432']);
   }
   public function _discussion()
   {
      if(!parent::$logged_is) {
         die('No logged');
      }
      $row = array();
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_sub_template WHERE action = 'discussion' LIMIT 1");
      $row['param'] = unserialize($row['param']);
      $row['id'] = $this->getInt('id') ? $this->getInt('id') : die('Not param');
      $row['check'] = $this->db->super_query("SELECT id FROM " . PREFIX . "_be_topic WHERE post_id = {$row['id']} LIMIT 1");
      if($row['check']['id']) {
         die('ERROR');
      }
      $row['post'] = $this->db->super_query("SELECT short_story,full_story,title,date FROM " . PREFIX . "_post WHERE id = {$row['id']} LIMIT 1");
      if(!$row['post']['title']) {
         die('no post');
      }
      $row['post']['short_story'] = $this->filter->decodeBBCodes($row['post']['short_story'], false);
      $row['post']['full_story'] = $this->filter->decodeBBCodes($row['post']['full_story'], false);
      if(empty($row['post']['full_story'])) {
         $row['param']['content'] = str_replace("{full-story}", $row['post']['short_story'], $row['param']['content']);
      } else {
         $row['param']['content'] = str_replace("{full-story}", $row['post']['full_story'], $row['param']['content']);
      }
      $row['param']['content'] = str_replace("{short-story}", $row['post']['short_story'], $row['param']['content']);
      $row['param']['content'] = str_replace("{title}", stripcslashes($row['post']['title']), $row['param']['content']);
      $row['param']['content'] = str_replace("{date}", stripcslashes($row['post']['date']), $row['param']['content']);
      $row['inserTitle'] = $row['param']['prefix'] . stripcslashes($row['post']['title']);
      $option = array('foto' => parent::$id_member['foto'] ? parent::$id_member['foto'] : '', 'ipUser' => ip2long($_SERVER['REMOTE_ADDR']), 'topicName' => $this->db->safesql($this->_dle_substr($this->filter->process(strip_tags(parent::$modules_config['title_case'] ? $this->_ucfirs($row['inserTitle'], parent::$config_dle['charset']) : $row['inserTitle'])), 0, 250, parent::$config_dle['charset'])), 'topicDescription' => '', 'topicOneMessage' => $this->db->safesql($this->filter->BB_Parse($this->filter->process($row['param']['content']), false)), 'topicType' => 0, 'topicIsPrivateUser' => '', 'poll' => 0);
      $option['meta'] = $this->db->safesql(serialize(array('Titl' => stripcslashes($option['topicName']), 'Description' => $option['topicDescription'] ? $this->_generateMetaDesc($option['topicDescription']) : $this->_generateMetaDesc($option['topicOneMessage']), 'Key' => $option['topicDescription'] ? $this->_generateMetaKey($option['topicDescription']) : $this->_generateMetaKey($option['topicOneMessage']))));
      if($this->checkModerator($row['param']['tree']) or parent::$modules_config['moder_disable']) {
         $option['aprove'] = 1;
      } else {
         $option['aprove'] = 0;
      }
      $this->db->query("INSERT INTO " . PREFIX . "_be_topic (id,id_parent,title,reply_count,view_count,autor_id,autor,post_date,last_reply_date,last_reply_info,rating,topic_fixed,topic_type,topic_private_user,topic_descr_site,topic_approve,topic_meta,vote_id,post_id) VALUES (NULL,{$row['param']['tree']},'{$option['topicName']}',0,0,{$this->userID},'{$this->userName}',{$this->time},{$this->time},0,0,0,{$option['topicType']},'{$option['topicIsPrivateUser']}','{$option['topicDescription']}',{$option['aprove']},'{$option['meta']}', {$option['poll']},{$row['id']})");
      $option['topicInsertId'] = $this->db->insert_id();
      $this->db->query("INSERT INTO " . PREFIX . "_be_message (id,id_topic,autors_id,message_autor,message_autor_ip,message_date,message_text,message_approve,tree_id,parent_msg,attachment,user_thanks) VALUES (NULL,{$option['topicInsertId']},{$this->userID},'{$this->userName}',{$option['ipUser']},{$this->time},'{$option['topicOneMessage']}',{$option['aprove']},{$row['param']['tree']},1,0,'')");
      $option['messageInsertId'] = $this->db->insert_id();
      $option['lastInfo'] = $this->_generateLastPostInfo(array($this->userName, $this->time, $option['topicName'], $this->linck->topicIsRedirect($option['topicInsertId'], $this->totranslit($option['topicName'], true, true)) . '#message-' . $option['messageInsertId'], $option['foto'], $this->userID));
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET last_reply_info = '{$option['lastInfo']}' WHERE id = '{$option['topicInsertId']}'");
      $this->db->query("UPDATE " . PREFIX . "_be_tree SET tree_last_info = '{$option['lastInfo']}', tree_topic = tree_topic + 1, tree_answer = tree_answer + 1, tree_last_date = {$this->time} WHERE tree_id = {$row['param']['tree']}");
      if(parent::$treePermanent[$this->id]['tree_count']) {
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_topic_count = forum_topic_count + 1, forum_post_count = forum_post_count + 1 WHERE user_id = {$this->userID}");
      }
      $this->db->query("UPDATE " . PREFIX . "_post SET topic_id = {$option['topicInsertId']} WHERE id = {$row['id']} LIMIT 1");
      $this->_cacheDeleteAll();
      @unlink(ENGINE_DIR . '/bullet_energy/cache/system/feed_0_' . $row['param']['tree'] . '.tmp');
      header('Location: ' . $this->linck->topicIsRedirect($option['topicInsertId'], $this->totranslit($option['topicName'], true, true)));
   }
   /**
    * BulletEnergyHandler::_searchPage()
    *      ,         .
    * @param mixed $data
    * @return
    */
   protected function _searchPage(array $data = array())
   {
      if(!$this->ckeckModulesConfig('be_access_search')) {
         die('No access page');
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_31']));
      if(isset(parent::$view->tpl->result['search'])) {
         unset(parent::$view->tpl->result['search']);
      }
      $data['tree'] = $data['tree'] ? $data['tree'] : 0;
      $data['dataOut'] = $data['error'] . parent::$view->setTplSearchPage(array('page' => $data['page'], 'tree' => '<select id="treeSelectSearch" multiple="multiple" name="tree[]">' . $this->_setSelectTree($data['tree'], 0, true, '', '', parent::$modules_lang['search_0']) . '</select>', 'keyValue' => $data['keyValue'], 'keyOnliTitle' => $data['keyOnliTitle'], 'keyUser' => $data['keyUser'], 'keyDate' => $data['keyDate'], 'keyDateOut' => $data['keyDateOut'], 'sort' => $data['sort'], 'order' => trim($data['order'])));
      if($data['retIsResult']) {
         return $data['dataOut'];
      } else {
         return parent::$view->setTplMainBlock($data['dataOut'], $this->_setMetaTitl());
      }
   }
   /**
    * BulletEnergyHandler::_pageTree()
    *      .
    * @return
    */
   protected function _pageTree()
   {
      $option = array();
      if(!$this->_checkTreeConfigParam('tree_access_view', $this->id)) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_11']);
      }
      if(!parent::$modules_config['is_cpu_type'] and parent::$modules_config['handler_cpu'] and parent::$modules_config['cpu']) {
         $option['treeTitle'] = $this->totranslit(parent::$treePermanent[$this->id]['tree_title'], true, true);
         if($this->getString('name') != $option['treeTitle']) {
            header("HTTP/1.0 301 Moved Permanently");
            header("Location: " . $this->linck->treeLinck($this->id, $option['treeTitle']));
            die("Redirect");
         }
      }
      $option['aproveJoin'] = $this->ckeckModulesConfig('be_moder_moder_view') ? '' : "AND topic.topic_approve = 1";
      $option['countTopicIsNotFixed'] = $this->db->super_query("SELECT count(*) AS count FROM " . PREFIX . "_be_topic AS topic WHERE topic.id_parent = {$this->id} {$option['aproveJoin']} AND topic.topic_fixed = 0");
      $this->_countUnreadTopic(array($this->userID, $this->id, $this->timeMarkerOldTopic));
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_9'] . parent::$treePermanent[$this->id]['tree_title']));
      $option['advertising'] = parent::$modules_config['adv'] ? $this->_advertising($this->id, true) : '';
      $option['widget'] = in_array(parent::$action, $this->sideBar) ? $this->_getSidebar() : false;
      $option['topic'] = intval(parent::$treePermanent[$this->id]['tree_type']) != 0 ? $this->_setListTopic(array('topicCount' => $option['countTopicIsNotFixed']['count'])) : false;
      return parent::$view->setTplMainBlock($this->_childTree($this->id) . $option['advertising'] . $option['topic'], $this->_setMetaTitl(), array('widget' => $option['widget']));
   }
   /**
    * BulletEnergyHandler::_countUnreadTopic()
    *      ,      ,          Read ()
    * @param integer $option[0] -   .
    * @param integer $option[1] -   .
    * @param integer $option[2] -     ,          .
    * @param array $option
    * @return void
    */
   private function _countUnreadTopic(array $option = array())
   {
      if(!parent::$logged_is) {
         return false;
      }
      $option['check'] = $this->db->super_query("SELECT COUNT(*) as count
                                               FROM " . PREFIX . "_be_topic AS topic
                                               LEFT JOIN " . PREFIX . "_be_read_topic AS topic_read ON
	                                              (topic_read.ber_topic_id = topic.id AND topic_read.ber_user_id = {$option['0']})
                                               WHERE 
                                                  topic.id_parent  = {$option['1']}
	                                           AND topic.last_reply_date > {$option['2']}
	                                           AND (topic_read.ber_topic_id IS NULL OR topic.last_reply_date > topic_read.ber_read_date)");
      if(empty($option['check']['count'])) {
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_tree 
                          (bert_read_id,bert_user_id,bert_tree_id,bert_read_date) 
                          VALUES (NULL,{$option['0']},{$option['1']},{$this->time}) ON DUPLICATE KEY UPDATE bert_read_date = {$this->time}");
         return true;
      }
      return false;
   }
   private function _getChildTreeSetHomePage($id = 0, array $arrTree = array())
   {
      //TODO: -  ?
      foreach (parent::$treePermanent as $child) {
         if($child['tree_parent_id'] == $id) {
            if($this->_checkTreeConfigParam('tree_access_view', $child['tree_id'])) {
               $arrTree[] = intval($child['tree_id']);
            }
            $arrTree = $this->_getChildTree($child['tree_id'], $arrTree);
         }
      }
      return $arrTree;
   }
   /**
    * BulletEnergyHandler::_getChildTree()
    *     ,       .
    * @param integer $id -   .
    * @param mixed $arrTree -   .
    * @return array $arrTree -   . 
    */
   private function _getChildTree($id = 0, array $arrTree = array())
   {
      foreach (parent::$treePermanent as $child) {
         if($child['tree_parent_id'] == $id) {
            if($this->_checkTreeConfigParam('tree_access_topic_read', $child['tree_id'])) {
               $arrTree[] = intval($child['tree_id']);
            }
            $arrTree = $this->_getChildTree($child['tree_id'], $arrTree);
         }
      }
      return $arrTree;
   }
   /**
    * BulletEnergyHandler::_home()
    *      .
    * @return
    */
   protected function _home()
   {
      $option = array();
      $option['joinRead'] = $this->_joinReadTree();
      $option['isView'] = explode(',', $this->_getGroupIdParseTree());
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_3'] . parent::$modules_lang['side_bar_2']));
      if(!parent::$sys_cashe['accessTreeView']) {
         die(parent::$modules_lang['error_18']);
      }
      $this->db->query("SELECT * {$option['joinRead']['select']} 
                      FROM " . PREFIX . "_be_tree {$option['joinRead']['join']} 
                      WHERE " . PREFIX . "_be_tree.tree_id 
                       IN (" . parent::$sys_cashe['accessTreeView'] . ") 
                      ORDER BY tree_display ASC");
      $tree = array();
      while ($row = $this->db->get_row()) {
         if(!$this->_checkTreeConfigParam('tree_access_view', $row['tree_id'])) {
            continue;
         }
         $tree[$row['tree_id']] = array();
         foreach ($row as $key => $value) {
            $tree[$row['tree_id']][$key] = stripslashes($value);
            $tree[$row['tree_id']]['treeChild'] = empty($row['tree_type']) ? '' : $this->_getChildTreeSetHomePage($row['tree_id'], array());
            $tree[$row['tree_id']]['read'] = (isset($row['bert_read_date']) && $row['bert_read_date'] < $row['tree_last_date']);
            $tree[$row['tree_id']]['feed'] = parent::$modules_config['enable_rss'] ? in_array($row['tree_id'], $option['isView']) : false;
         }
      }
      $option['widget'] = $this->_getSidebar();
      if(!method_exists('BulletEnergyHandler', '_unline') or !property_exists('BulletEnergy', 'transcred')) {
         die();
      }
      return parent::$view->setTplMainBlock(parent::$view->setListTreeMainPage($tree), $this->_setMetaTitl(), array('widget' => $option['widget']));
   }
   protected function _searchProcess()
   {
      if(!$this->ckeckModulesConfig('be_access_search')) {
         die('no access page');
      }
      $option = array();
      $option['chars'] = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', "." => '', "/" => '', "" => '', "#" => '', ";" => '', ":" => '', "@" => '', "~" => '', "[" => '', "]" => '', "{" => '', "}" => '', "=" => '', "-" => ' ', "+" => '', ")" => '', "(" => '', "*" => '', "^" => '', "%" => '', "$" => '', "<" => '', ">" => '', "?" => ' ', "!" => '', '"' => ' ', '&nbsp;' => '');
      $option['key'] = trim(strtr(strip_tags(stripcslashes($_REQUEST['key_search'])), $option['chars']));
      $option['key'] = explode(' ', $option['key']);
      $option['sort'] = $this->getInt('sort') > 0 ? 1 : 0;
      $option['order'] = $this->getInt('orders') > 0 ? 1 : 0;
      $option['onliTitle'] = $this->getInt('search_titl') > 0 ? 1 : 0;
      $option['keyNoSearch'] = 0;
      $option['keyUserName'] = explode(',', trim(strip_tags(strtr($_REQUEST['key_user'], $option['chars']))));
      foreach ($option['keyUserName'] as $key => $value) {
         $value = trim($this->_dle_substr($value, 0, 40, parent::$config_dle['charset']));
         if($value === '') {
            unset($option['keyUserName'][$key]);
         }
         $value = $this->db->safesql($value);
         $option['userLike'][] = " post.message_autor LIKE '%{$value}%' ";
         $option['userLikeTopic'][] = " topic.autor LIKE '%{$value}%' ";
      }
      $option['userLike'] = implode(' OR ', $option['userLike']);
      $option['userLikeTopic'] = implode(' OR ', $option['userLikeTopic']);
      $option['keyMax'] = 0;
      foreach ($option['key'] as $key => $value) {
         if($option['keyMax'] >= 15) {
            break;
         }
         $value = trim($value);
         if($value === '') {
            unset($option['key'][$key]);
         }
         if($this->_dle_strlen($value, parent::$config_dle['charset']) < 4) {
            unset($option['key'][$key]);
            $option['keyNoSearch']++;
         }
         $value = $this->db->safesql($value);
         if($option['onliTitle']) {
            $option['like'][] = "topic.title LIKE '%{$value}%'";
         } else {
            $option['like'][] = "topic.title LIKE '%{$value}%'";
            $option['like'][] = "post.message_text LIKE '%{$value}%'";
         }
         $option['keyMax']++;
      }
      $option['like'] = implode(' OR ', $option['like']);
      if(count($option['key']) == 0 and count($option['keyUserName']) == 0) {
         $option['error'][] = '<li>' . parent::$modules_lang['search_2'] . '</li>';
      }
      foreach ($_REQUEST['tree'] as $key => $value) {
         $value = intval($this->_singleFilterString($value));
         if(!$value or !$this->_checkTreeConfigParam('tree_access_view', $value)) {
            continue;
         }
         $option['tpmKey'] = $this->_getChildTree($value);
         if(count($option['tpmKey']) > 0) {
            $option['sqlIdTree'][] = $value;
            $option['sqlIdTree'] = array_merge($option['tpmKey'], $option['sqlIdTree']);
         } else {
            $option['sqlIdTree'][] = $value;
         }
      }
      if(count($_REQUEST['tree']) == 1 and $_REQUEST['tree'][0] == 0) {
         $option['viewSelectedSet'] = 0;
      } else {
         $option['viewSelectedSet'] = $option['sqlIdTree'] ? $option['sqlIdTree'] : $this->_getGroupIdParseTree();
      }
      if(count($option['key']) > 0 or count($option['keyUserName']) > 0) {
         if($option['keyNoSearch'] > 0) {
            $option['error'][] = '<li>' . parent::$modules_lang['search_1'] . '</li>';
         }
         $option['keyDate'] = strtotime($_REQUEST['key_date']);
         $option['keyDateOut'] = strtotime($_REQUEST['key_date_ext']) ? strtotime($_REQUEST['key_date_ext']) : $this->time;
         if($option['keyDate']) {
            $option['dateSearch'] = true;
         }
         $option['sqlIdTreeT'] = $option['sqlIdTree'] ? ' topic.id_parent IN(' . implode(',', $option['sqlIdTree']) . ') AND ' : ' topic.id_parent IN(' . $this->_getGroupIdParseTree() . ') AND';
         $option['sqlIdTreePost'] = $option['sqlIdTree'] ? ' post.tree_id IN(' . implode(',', $option['sqlIdTree']) . ') AND ' : ' post.tree_id IN(' . $this->_getGroupIdParseTree() . ') AND ';
         $option['sort'] = $option['sort'] ? ' ORDER BY topic.post_date ' : ' ORDER BY topic.reply_count ';
         $option['order'] = $option['order'] ? ' ASC ' : ' DESC ';
         $option['keyReplice'] = $option['key'];
         //$option['key'] = $this->db->safesql(implode('%', $option['key']));
         //$option['keyUserName'] = $option['keyUserName'] ? $this->db->safesql(implode('%', $option['keyUserName'])) : false;
         $option['keyUserName'] = $option['keyUserName'] ? array('post' => " AND {$option['userLike']} ", 'topic' => " AND {$option['userLikeTopic']} ") : '';
         if($option['dateSearch']) {
            $option['whereDate'] = $option['onliTitle'] ? " AND topic.post_date BETWEEN " . min($option['keyDate'], $option['keyDateOut']) . " AND " . max($option['keyDate'], $option['keyDateOut']) . " " : " AND topic.post_date BETWEEN " . min($option['keyDate'], $option['keyDateOut']) . " AND " . max($option['keyDate'], $option['keyDateOut']) . " AND post.message_date BETWEEN " . min($option['keyDate'], $option['keyDateOut']) . " AND " . max($option['keyDate'], $option['keyDateOut']) . " ";
         }
         $option['group'] = $option['onliTitle'] ? " GROUP BY topic.id " : " ";
         $option['table'] = $option['onliTitle'] ? " " . PREFIX . "_be_topic AS topic LEFT JOIN " . PREFIX . "_be_message as post ON (topic.id = post.id_topic) AND post.parent_msg = 1 " : " " . PREFIX . "_be_message as post LEFT JOIN " . PREFIX . "_be_topic as topic ON (post.id_topic = topic.id)  ";
         $option['where'] = $option['onliTitle'] ? " WHERE {$option['sqlIdTreeT']}{$option['sqlIdTreePost']} ({$option['like']} {$option['keyUserName']['topic']} )" : " WHERE {$option['sqlIdTreePost']}{$option['sqlIdTreeT']} ({$option['like']} {$option['keyUserName']['topic']}) {$option['keyUserName']['post']} ";
         $row = $this->db->super_query("SELECT SQL_NO_CACHE COUNT(*) as count 
                                    FROM 
                                    {$option['table']}
                                    {$option['where']}
                                    {$option['whereDate']}
                                   
                                    {$option['group']} ");
         $option['paginator'] = $this->setPaginator(array('unreadCount' => $row['count'], 'linck' => $this->linck->searchLinck()));
         //  var_dump($option);
         $this->db->query("SELECT SQL_NO_CACHE 
                            post.id AS post_id, 
                            post.message_autor, 
                            post.autors_id, 
                            post.message_date, 
                            post.message_text, 
                            post.msg_edit_date, 
                            post.edit_autor, 
                            post.id_topic,
                            topic.id, 
                            topic.title, 
                            topic.id_parent, 
                            topic.reply_count,
                            user.foto
                        FROM 
                        {$option['table']}
                        LEFT JOIN " . PREFIX . "_users AS user ON(
                          user.user_id = post.autors_id
                        )
                        {$option['where']}
                        {$option['whereDate']}
                       
                      
                        {$option['group']}
                        {$option['sort']}
                        {$option['order']}
                        LIMIT {$option['paginator']['start']}, {$option['paginator']['nums']}");
         if($this->db->num_rows()) {
            $option['returnBd'] = true;
         } else {
            $option['returnBd'] = false;
            $option['error'][] = '<li>' . parent::$modules_lang['search_3'] . '</li>';
         }
         while ($row = $this->db->get_row()) {
            $data = array();
            $data['idTree'] = $row['id_parent'];
            $data['post_id'] = $row['post_id'];
            $data['titlTree'] = parent::$treePermanent[$row['id_parent']]['tree_title'];
            $data['title'] = stripcslashes($row['title']);
            $data['id'] = $row['id_topic'];
            $data['message_autor'] = $row['message_autor'];
            $data['autors_id'] = $row['autors_id'];
            $data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
            $data['message_text'] = stripslashes($row['message_text']);
            $data['foto'] = $this->isAvatarUser($row['foto']);
            $data['msg_edit_date'] = $row['msg_edit_date'];
            $data['edit_autor'] = $row['edit_autor'];
            parent::$view->setTplMessageSearchUser($data);
         }
      }
      $this->page = $this->page <= 0 ? 1 : $this->page;
      $option['error'] = count($option['error']) > 0 ? parent::$view->error_set(parent::$modules_lang['topic_19'], '<ul>' . implode('', $option['error']) . '</ul>') : '';
      $option['errorIsSearch'] = $this->_searchPage(array('retIsResult' => true, 'error' => $option['error'], 'page' => $this->page, 'sort' => $this->getInt('sort'), 'keyOnliTitle' => $option['onliTitle'], 'keyValue' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_search']))), 'keyUser' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_user']))), 'keyDate' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_date']))), 'keyDateOut' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_date_ext']))), 'order' => $option['order'], 'tree' => $option['viewSelectedSet']));
      if($option['returnBd']) {
         foreach ($option['key'] as $word) {
            parent::$view->tpl->result['short_message'] = $this->hilites($word, parent::$view->tpl->result['short_message']);
         }
         return parent::$view->setTplMainBlock($option['errorIsSearch'] . parent::$view->setTplViewFullTopic(array('message' => parent::$view->tpl->result['short_message'], 'paginator' => $option['paginator']['paginator'])), $this->_setMetaTitl());
      }
      return $this->_searchPage(array('error' => $option['error'], 'sort' => $this->getInt('sort'), 'keyOnliTitle' => $option['onliTitle'], 'keyValue' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_search']))), 'keyUser' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_user']))), 'keyDate' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_date']))), 'keyDateOut' => htmlspecialchars(strip_tags(stripcslashes($_REQUEST['key_date_ext']))), 'order' => $option['order'], 'tree' => $option['viewSelectedSet']));
   }
   public function isAvatarUser($imgName = '')
   {
      if(!empty($imgName) and file_exists(ROOT_DIR . '/uploads/fotos/' . $imgName)) {
         return parent::$config_dle['http_home_url'] . 'uploads/fotos/' . $imgName;
      } else {
         return parent::$config_dle['http_home_url'] . 'templates/' . parent::$config_dle['skin'] . '/bullet_energy/images/noavatar.png';
      }
   }
   public function hilites($search, $txt)
   {
      //dle func
      $r = preg_split('((>)|(<))', $txt, -1, PREG_SPLIT_DELIM_CAPTURE);
      for ($i = 0; $i < count($r); $i++) {
         if($r[$i] == "<") {
            $i++;
            continue;
         }
         $r[$i] = preg_replace("#($search)#i", "<span style='background-color:yellow;'><font color='red'>\\1</font></span>", $r[$i]);
      }
      return join("", $r);
   }

   private function _setSelectTree($categoryid = 0, $parentid = 0, $nocat = true, $sublevelmarker = '', $returnstring = '', $deflang = '')
   {
      $root_category = array();
      if($parentid == 0) {
         if($nocat)
            $returnstring .= '<option  value="0">' . $deflang . '</option>';
      } else {
         $sublevelmarker .= '&nbsp;&nbsp;&nbsp;';
      }
      if(count(parent::$treePermanent)) {
         foreach (parent::$treePermanent as $cats) {
            if($cats['tree_parent_id'] == $parentid)
               $root_category[] = $cats['tree_id'];
         }
         if(count($root_category)) {
            foreach ($root_category as $id) {
               $returnstring .= "<option value=\"" . $id . '" ';
               if(is_array($categoryid)) {
                  foreach ($categoryid as $element) {
                     if($element == $id)
                        $returnstring .= 'SELECTED';
                  }
               } elseif($categoryid == $id)
                  $returnstring .= 'SELECTED';
               $returnstring .= '>' . $sublevelmarker . parent::$treePermanent[$id]['tree_title'] . '</option>';
               $returnstring = $this->_setSelectTree($categoryid, $id, $nocat, $sublevelmarker, $returnstring);
            }
         }
      }
      return $returnstring;
   }
   protected function _watchedContent($isAll = false)
   {
      $row = array();
      $option = array();
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_29']));
      if(!parent::$logged_is) {
         $option['return'] = parent::$view->error_set(parent::$modules_lang['topic_19'], parent::$modules_lang['topic_37']);
      } else {
         $option['joinAprove'] = $this->ckeckModulesConfig('be_moder_moder_view') ? '' : "AND topic.topic_approve = '1'";
         $option['joinAllSelect'] = $isAll ? '' : 'AND topic.last_reply_date > topic_read.ber_read_date';
         $row = $this->db->super_query("SELECT 
                                       count( * ) AS count 
                                     FROM " . PREFIX . "_be_feed AS feed
                                     WHERE 
                                        feed.id_user = {$this->userID}
                                     AND feed.id_tree IN(" . $this->_getGroupIdParseTree() . ")");
         $option['returnIsNoTopic'] = $row['count'] > 0 ? false : parent::$view->error_set(parent::$modules_lang['topic_19'], parent::$modules_lang['topicFeedNo']);
         $row = $this->db->super_query("SELECT 
                                       count( * ) AS count 
                                     FROM " . PREFIX . "_be_feed AS feed
                                     LEFT JOIN " . PREFIX . "_be_topic AS topic ON (
                                       topic.id = feed.id_topic
                                     )
                                     LEFT JOIN " . PREFIX . "_be_read_topic AS topic_read ON (
                                       topic_read.ber_topic_id = topic.id
                                     )
                                     AND topic_read.ber_user_id = {$this->userID}
                                     WHERE 
                                       feed.id_user = {$this->userID}
                                     AND feed.id_tree IN(" . $this->_getGroupIdParseTree() . ")
                                     {$option['joinAllSelect']}
                                     {$option['joinAprove']}");
         if($isAll) {
            $option['paginator']['start'] = 0;
            $option['paginator']['nums'] = $row['count'];
            $option['optionList'] = '<a style="display:none" onclick="unFeed();return false;" id="control_feed">' . parent::$modules_lang['topic_69'] . '</a>';
         } else {
            $option['paginator'] = $this->setPaginator(array('unreadCount' => $row['count'], 'linck' => $this->linck->watchedLinck()));
            $option['optionList'] = '<a href="' . $this->linck->watchedLinckAll() . '">' . parent::$modules_lang['topic_66'] . '</a>';
         }
         $this->db->query("SELECT *
                        FROM " . PREFIX . "_be_feed AS feed
                        LEFT JOIN " . PREFIX . "_be_topic AS topic ON (
                          topic.id = feed.id_topic
                        )
                        LEFT JOIN " . PREFIX . "_be_read_topic AS topic_read ON 
                          topic_read.ber_topic_id = topic.id
                        
                        AND topic_read.ber_user_id = {$this->userID}
                        WHERE 
                          feed.id_user = {$this->userID}
                        AND feed.id_tree IN(" . $this->_getGroupIdParseTree() . ")
                        {$option['joinAllSelect']}
                        {$option['joinAprove']}
                        LIMIT {$option['paginator']['start']}, {$option['paginator']['nums']}");
         if(!$this->db->num_rows()) {
            parent::$view->tpl->result['short_topic'] = '<li class="noAnswerTopic">' . parent::$modules_lang['topicVisIsNo'] . '</li>';
         } else {
            $this->_topicDataRender();
         }
         $option['return'] = parent::$view->setBlockTopic(array('optionList' => $option['optionList'], 'topicList' => parent::$view->tpl->result['short_topic'], 'titlAction' => $isAll ? parent::$modules_lang['topic_67'] : parent::$modules_lang['topic_61'], 'paginator' => $option['paginator']['paginator'], 'treeDescr' => $isAll ? parent::$modules_lang['topic_68'] : parent::$modules_lang['topic_62']));
      }
      $option['return'] = $option['returnIsNoTopic'] ? $option['returnIsNoTopic'] : $option['return'];
      return parent::$view->setTplMainBlock($option['return'], $this->_setMetaTitl());
   }
   /**
    * BulletEnergyHandler::_checkValidCashe()
    *    ,      .
    *     <=   ,    ,    .
    * @return void
    */
   protected function _checkValidCashe()
   {
      $option = array();
      $option['sessionTime'] = $this->time - parent::$modules_config['session_time'] * 60;
      $option['readTime'] = $this->timeMarkerOldTopic;
      $option['casheTime'] = parent::$modules_config['time_cashe'] > 0 ? time() - (parent::$modules_config['time_cashe'] * 60) : (time() - 900);
      parent::$unsigneds .= parent::$transcred ? 'PGRpdiBjbGFzcz0iY29weUluZm8iPjxkaXYgY2xhc3M9ImlubmV' : 'PGRpdiBjbGFzcz0iY29weUluZm8iPjxkaXYgY2xhc3M9ImlubmVydEJveCI+UG93ZXJlZCBieSA8';
      if(@filemtime($this->casheSySPath . 'tree_permanent.tmp') - $option['casheTime'] <= 0) {
         $this->_cacheDeleteAll();
         $this->db->query("DELETE FROM " . PREFIX . "_be_read_tree WHERE bert_read_date < {$option['readTime']}");
         $this->db->query("DELETE FROM " . PREFIX . "_be_read_topic WHERE ber_read_date < {$option['readTime']}");
         $this->db->query("DELETE FROM " . PREFIX . "_be_session WHERE date < {$option['sessionTime']}");
         $this->db->query("DELETE FROM " . PREFIX . "_be_attachment WHERE attachment_date < {$option['sessionTime']} AND attachment_content_id = 0");
      }
   }
   public function strLeght()
   {
      if(parent::$unline) {
         parent::$view->tplIsCompile['data'] = '';
         return true;
      }
      if(parent::$view->tplIsCompile['leght'] == 141) {
         return true;
      } elseif(parent::$view->tplIsCompile['leght'] == 160) {
         return true;
      } else {
         die(parent::$modules_lang['setting_433']);
      }
   }
   private function _cacheDeleteAll()
   {
      if(file_exists($this->casheSySPath . 'groups_config.tmp')) {
         @unlink($this->casheSySPath . 'groups_config.tmp');
      }
      if(file_exists($this->casheSySPath . 'question.tmp')) {
         @unlink($this->casheSySPath . 'question.tmp');
      }
      if(file_exists($this->casheSySPath . 'moderator.tmp')) {
         @unlink($this->casheSySPath . 'moderator.tmp');
      }
      if(file_exists($this->casheSySPath . 'tree_permanent.tmp')) {
         @unlink($this->casheSySPath . 'tree_permanent.tmp');
      }
      if(file_exists($this->casheSySPath . 'advertising.tmp')) {
         @unlink($this->casheSySPath . 'advertising.tmp');
      }
      if(file_exists($this->casheSySPath . 'stat.tmp')) {
         @unlink($this->casheSySPath . 'stat.tmp');
      }
      $this->db->query("SELECT be_groups_id FROM " . PREFIX . "_be_groups ORDER BY be_groups_id ASC");
      while ($row = $this->db->get_row()) {
         if(file_exists($this->casheSySPath . 'sys_cashe_group_' . $row['be_groups_id'] . '.tmp')) {
            @unlink($this->casheSySPath . 'sys_cashe_group_' . $row['be_groups_id'] . '.tmp');
         }
      }
   }
   protected function _addTopicDB()
   {
      if(!parent::$logged_is) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_8']);
      }
      if(strip_tags(trim($_POST['post_text'])) != '') {
         die();
      }
      if(!$this->_checkTreeConfigParam('tree_access_topic_new', $this->id)) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_9']);
      }
      $option = array('foto' => parent::$id_member['foto'] ? parent::$id_member['foto'] : '', 'ipUser' => ip2long($_SERVER['REMOTE_ADDR']), 'topicName' => $this->db->safesql($this->_dle_substr($this->filter->process(strip_tags(parent::$modules_config['title_case'] ? $this->_ucfirs($_POST['topic_name'], parent::$config_dle['charset']) : $_POST['topic_name'])), 0, 250, parent::$config_dle['charset'])), 'topicDescription' => $this->db->safesql($this->_dle_substr($this->filter->process(strip_tags($_POST['topic_descr'])), 0, 250, parent::$config_dle['charset'])), 'topicOneMessage' => $this->db->safesql($this->filter->BB_Parse($this->filter->process($_POST['message_new_topic']), false)), 'topicType' => $this->getInt('topic_type'), 'topicIsPrivateUser' => $this->db->safesql($this->filter->process(strip_tags($_POST['private_topic_user']))));
      $option['meta'] = $this->db->safesql(serialize(array('Titl' => stripcslashes($option['topicName']), 'Description' => $option['topicDescription'] ? $this->_generateMetaDesc($option['topicDescription']) : $this->_generateMetaDesc($option['topicOneMessage']), 'Key' => $option['topicDescription'] ? $this->_generateMetaKey($option['topicDescription']) : $this->_generateMetaKey($option['topicOneMessage']))));
      if($this->_dle_strlen($option['topicName'], parent::$config_dle['charset']) > 250) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_9']);
      }
      //$option['topicName'] = $option['topicName'] . time();
      if($option['topicType'] == 1) {
         if($this->ckeckModulesConfig('be_access_topic_new_private') == 0) {
            return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_7']);
         }
         if($option['topicIsPrivateUser'] == '') {
            return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_8']);
         }
      }
      if($option['topicOneMessage'] == '') {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_10']);
      }
      if($this->checkModerator($this->id) or parent::$modules_config['moder_disable']) {
         $option['aprove'] = 1;
      } else {
         $option['aprove'] = 0;
      }
      if(!empty($_POST['isvote']) and $this->ckeckModulesConfig('be_create_vote')) {
         $option['voteTitle'] = trim($this->db->safesql($this->filter->process($_POST['vote_titl'])));
         $option['poll'] = $this->_pollRender($_POST['vote_replic'], $this->getInt('vote_multi'), $option['voteTitle']);
         if(empty($option['poll'])) {
            $option['poll'] = 0;
         }
      } else {
         $option['poll'] = 0;
      }
      $this->db->query("INSERT INTO " . PREFIX . "_be_topic (id,id_parent,title,reply_count,view_count,autor_id,autor,post_date,last_reply_date,last_reply_info,rating,topic_fixed,topic_type,topic_private_user,topic_descr_site,topic_approve,topic_meta,vote_id) VALUES (NULL,{$this->id},'{$option['topicName']}',0,0,{$this->userID},'{$this->userName}',{$this->time},{$this->time},0,0,0,{$option['topicType']},'{$option['topicIsPrivateUser']}','{$option['topicDescription']}',{$option['aprove']},'{$option['meta']}', {$option['poll']})");
      $option['topicInsertId'] = $this->db->insert_id();
      if(!empty($option['poll'])) {
         $this->db->query("UPDATE " . PREFIX . "_be_poll SET vote_topic_id = {$option['topicInsertId']} WHERE vote_topic_id = 0 LIMIT 1");
      }
      $row = $this->db->super_query("SELECT count( * ) AS count FROM " . PREFIX . "_be_attachment WHERE attachment_type = 1 AND attachment_user_name = '{$this->userName}' AND attachment_user_id = {$this->userID} AND attachment_content_id = 0");
      $option['messageAttachmentCount'] = $row['count'] > 0 ? 1 : 0;
      $this->db->query("INSERT INTO " . PREFIX . "_be_message (id,id_topic,autors_id,message_autor,message_autor_ip,message_date,message_text,message_approve,tree_id,parent_msg,attachment,user_thanks) VALUES (NULL,{$option['topicInsertId']},{$this->userID},'{$this->userName}',{$option['ipUser']},{$this->time},'{$option['topicOneMessage']}',{$option['aprove']},{$this->id},1,{$option['messageAttachmentCount']},'')");
      $option['messageInsertId'] = $this->db->insert_id();
      $option['lastInfo'] = $this->_generateLastPostInfo(array($this->userName, $this->time, $option['topicName'], $this->linck->topicIsRedirect($option['topicInsertId'], $this->totranslit($option['topicName'], true, true)) . '#message-' . $option['messageInsertId'], $option['foto'], $this->userID));
      if($this->ckeckModulesConfig('be_upload_img')) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$option['messageInsertId']}, topic_id = {$option['topicInsertId']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$this->userName}' AND attachment_content_id = 0 AND attachment_type = 0");
      }
      if($this->ckeckModulesConfig('be_upload') and $option['messageAttachmentCount']) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$option['messageInsertId']}, topic_id = {$option['topicInsertId']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$this->userName}' AND attachment_content_id = 0 AND attachment_type = 1");
      }
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET last_reply_info = '{$option['lastInfo']}' WHERE id = '{$option['topicInsertId']}'");
      $this->db->query("UPDATE " . PREFIX . "_be_tree SET tree_last_info = '{$option['lastInfo']}', tree_topic = tree_topic + 1, tree_answer = tree_answer + 1, tree_last_date = {$this->time} WHERE tree_id = {$this->id}");
      if(parent::$treePermanent[$this->id]['tree_count']) {
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_topic_count = forum_topic_count + 1, forum_post_count = forum_post_count + 1 WHERE user_id = {$this->userID}");
      }
      $this->_cacheDeleteAll();
      @unlink(ENGINE_DIR . '/bullet_energy/cache/system/feed_0_' . $this->id . '.tmp');
      header('Location: ' . $this->linck->topicIsRedirect($option['topicInsertId'], $this->totranslit($option['topicName'], true, true)));
   }
   private function _pollRender($data = array(), $isMulti = 0, $question = '')
   {
      if(!is_array($data) or empty($data) or $question == '') {
         return false;
      }
      $option['poll'] = array();
      foreach ($data as $key => $value) {
         $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', "/" => '', "" => '', "#" => '', ";" => '', ":" => '', "@" => '', "~" => '', "[" => '', "]" => '', "{" => '', "}" => '', "=" => '', "-" => '', "+" => '', ")" => '', "(" => '', "*" => '', "^" => '', "%" => '', "$" => '', "<" => '', ">" => '', "!" => '', '"' => '', '&nbsp;' => ' ');
         $value = strtr($value, $chars);
         $value = trim($this->filter->process($value));
         if($value == '') {
            unset($_POST['vote_replic'][$key]);
            if(empty($_POST['vote_replic'])) {
               return false;
            }
            continue;
         }
         $value = $this->db->safesql($value);
         $this->db->query("INSERT INTO " . PREFIX . "_be_poll_answers (id, vote_id, answers, answers_count, user_vote) VALUES (NULL, 0, '{$value}', 0, '')");
         $option['poll'][$this->db->insert_id()] = array('answers' => $value, 'count' => 0, 'user_vote' => false);
      }
      if(empty($option['poll'])) {
         return false;
      }
      $question = $this->db->safesql($question);
      $option['visible_vote'] = $this->getInt('vote_visible_poll') > 0 ? 1 : 0;
      $option['poll'] = $this->db->safesql(serialize($option['poll']));
      $this->db->query("INSERT INTO " . PREFIX . "_be_poll (vote_id, vote_topic_id, vote_question, answers, vote_count, multi, visible_vote_user, close_date) VALUES (NULL, 0, '{$question}', '{$option['poll']}', 0, {$isMulti}, {$option['visible_vote']} , 0)");
      $option['poollId'] = $this->db->insert_id();
      $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET vote_id = {$option['poollId']} WHERE vote_id = 0");
      return $option['poollId'];
   }
   private function _generateLastPostInfo(array $data = array())
   {
      $ret = array();
      foreach ($data as $key => $val) {
         $ret[] = stripcslashes(stripcslashes($val));
      }
      if(!$ret) {
         return false;
      }
      return $this->db->safesql(serialize($ret));
   }
   private function _singleFilterString($data = '')
   {
      $data = stripcslashes(strip_tags($data));
      $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', ',' => '', "." => '', "/" => '', "" => '', "#" => '', ";" => '', ":" => '', "@" => '', "~" => '', "[" => '', "]" => '', "{" => '', "}" => '', "=" => '', "-" => '', "+" => '', ")" => '', "(" => '', "*" => '', "^" => '', "%" => '', "$" => '', "<" => '', ">" => '', "?" => '', "!" => '', '"' => '', '&nbsp;' => ' ');
      $data = trim(strtr($data, $chars));
      return $data;
   }
   private function _generateMetaDesc($data = '')
   {
      //:TODO: array charch dubl three
      $data = stripcslashes(strip_tags($data));
      $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', ',' => '', "." => '', "/" => '', "" => '', "#" => '', ";" => '', ":" => '', "@" => '', "~" => '', "[" => '', "]" => '', "{" => '', "}" => '', "=" => '', "-" => '', "+" => '', ")" => '', "(" => '', "*" => '', "^" => '', "%" => '', "$" => '', "<" => '', ">" => '', "?" => '', "!" => '', '"' => '', '&nbsp;' => ' ');
      return trim($this->_dle_substr(strtr($data, $chars), 0, 190, parent::$config_dle['charset']));
   }
   private function _generateMetaKey($data = '')
   {
      $data = stripcslashes(strip_tags($data));
      $newarr = array();
      $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', ',' => '', "." => '', "/" => '', "" => '', "#" => '', ";" => '', ":" => '', "@" => '', "~" => '', "[" => '', "]" => '', "{" => '', "}" => '', "=" => '', "-" => '', "+" => '', ")" => '', "(" => '', "*" => '', "^" => '', "%" => '', "$" => '', "<" => '', ">" => '', "?" => '', "!" => '', '"' => '', '&nbsp;' => ' ');
      $arr = explode(" ", strtr($data, $chars));
      foreach ($arr as $word) {
         if(strlen($word) > 3)
            $newarr[] = trim($word);
      }
      $arr = array_count_values($newarr);
      arsort($arr);
      $arr = array_keys($arr);
      $arr = array_slice($arr, 0, 20);
      return implode(", ", $arr);
   }
   private function _getSidebar(array $option = array())
   {
      if(!in_array(parent::$action, $this->sideBar)) {
         return false;
      }
      $ret = array();
      $ret['message'] = parent::$modules_config['widget_last_post'] ? $this->_getNewMessage() : '';
      if(parent::$modules_config['session_check'] and parent::$modules_config['online']) {
         $ret['online'] = $this->_getOnlineBlock($option);
      }
      return $ret;
   }
   private function _setSessionTable(array $data = array())
   {
      if(!parent::$modules_config['session_check']) {
         return false;
      }
      $option = array();
      $robotIsArray = array("#.*(yandex|yadirectbot).*#si" => "Yandex", "#.*(google|accoona|gsa-crawler).*#si" => "Google", "#.*rambler.*#si" => "Rambler", '#.*mail.ru.*#si' => "Mail Ru", "#.*aport.*#si" => "Aport", "#.*TurtleScanner.*#si" => "Turtle", "#.*slurp.*#si" => "Inktomi Spider", "#.*msnbot.*#si" => "Msn", "#.*(askjeeves|ask jeeves).*#si" => "Ask Com", "#.*yahoo.*#si" => "Yahoo", "#.*scooter.*#si" => "AltaVista", "#.*lycos.*#si" => "Lycos.com", "#.*libwww.*#si" => "Punto", "#.*picsearch.*#si" => "PicSearch", "#.*mnogosearch.*#si" => "mnoGoSearch", "#.*(is_archiver|archive_org).*#si" => "Archive Org", );
      $result = preg_replace(array_keys($robotIsArray), $robotIsArray, $_SERVER['HTTP_USER_AGENT']);
      if($result == $_SERVER['HTTP_USER_AGENT']) {
         $option['agent'] = $this->userName ? $this->userName : parent::$modules_lang['side_bar_4'];
         $option['isRobot'] = 0;
      } else {
         $option['agent'] = $result;
         $option['isRobot'] = 1;
      }
      $this->userID = $this->userID ? $this->userID : 0;
      $option = array('ip' => $this->db->safesql(ip2long($_SERVER['REMOTE_ADDR'])), 'session' => $this->db->safesql(session_id()), 'user_group' => $this->db->safesql(parent::$id_member['user_group']), 'typyInfo' => $data['idTopic'] ? $data['idTopic'] : 0, 'paramState' => $this->db->safesql(serialize(array('stuck' => $this->db->safesql($data['action']), 'agensi' => $option['agent'], 'isRobot' => $option['isRobot']))), 'key' => parent::$logged_is ? $this->userID : $this->db->safesql(ip2long($_SERVER['REMOTE_ADDR'])));
      $this->db->query("INSERT INTO " . PREFIX . "_be_session 
                      (`session_id`, `user_id`, `key`, `ip`, `date`, `user_group`, `info_type`, `param_state`)
                       VALUES ('{$option['session']}', '{$this->userID}', '{$option['key']}' ,'{$option['ip']}', '{$this->time}', '{$option['user_group']}', '{$option['typyInfo']}', '{$option['paramState']}')
                       ON DUPLICATE KEY UPDATE 
                         session_id = '{$option['session']}', 
                         ip = '{$option['ip']}', 
                         date = '{$this->time}', 
                         user_group = '{$option['user_group']}', 
                         info_type = '{$option['typyInfo']}', 
                         param_state = '{$option['paramState']}'");
   }
   private function _getOnlineBlock($data = array())
   {
      $option = array();
      $option['data'] = $this->time - parent::$modules_config['session_time'] * 60;
      $option['sql'] = parent::$action == 'showtopic' ? "SELECT * FROM " . PREFIX . "_be_session WHERE info_type = {$this->id} AND date > {$option['data']} ORDER BY date DESC" : "SELECT * FROM " . PREFIX . "_be_session WHERE date > {$option['data']} ORDER BY date DESC";
      $this->db->query($option['sql']);
      if(!$this->db->num_rows()) {
         return '';
      }
      $option['user'] = 0;
      $option['guest'] = 0;
      $option['linck'] = array();
      while ($row = $this->db->get_row()) {
         $row['dates'] = unserialize($row['param_state']);
         $row['dates']['stuck'] = stripcslashes(htmlspecialchars($row['dates']['stuck']));
         $row['user_id'] ? $option['user']++ : $option['guest']++;
         if($row['user_id']) {
            $option['linck'][] = $this->linck->setLinckCardUser(array($row['dates']['agensi'], $row['user_id'], $row['dates']['stuck'])) . $row['dates']['agensi'] . '</a>';
         } else {
            if($row['dates']['isRobot'] and !in_array($row['dates']['agensi'], $option['linck'])) {
               $option['linck'][] = $row['dates']['agensi'];
            }
         }
      }
      $option['all'] = $option['guest'] + $option['user'];
      if(count($option['linck'])) {
         $option['iSuser'] = '<ul>' . implode(', ', $option['linck']) . '</ul>';
      }
      $option['statBlock'] = parent::$action != 'showtopic' ? '<div class="statForum"><dl><dt>' . parent::$modules_lang['side_bar_25'] . '</dt><dd><strong>' . parent::$stats['topic']['count'] . '</strong></dd><dt>' . parent::$modules_lang['side_bar_26'] . '</dt><dd><strong>' . parent::$stats['post']['count'] . '</strong></dd><dt>' . parent::$modules_lang['side_bar_27'] . '</dt><dd><strong>' . parent::$stats['user']['count'] . '</strong></dd><dt>' . parent::$modules_lang['side_bar_28'] . '</dt><dd>' . parent::$stats['userLast'] . '</dd></dl></div>' : '';
      $option['titlBlock'] = parent::$action == 'showtopic' ? parent::$modules_lang['side_bar_23'] : parent::$modules_lang['side_bar_24'];
      return '<div class="blockRight userOnlines"><div class="conteiner"><h3>' . $option['titlBlock'] . '</h3><div class="innerts"><div class="userClin">' . $option['iSuser'] . '
    <p>' . parent::$modules_lang['side_bar_5'] . $option['all'] . '<br>(' . parent::$modules_lang['side_bar_7'] . $option['user'] . ', ' . parent::$modules_lang['side_bar_8'] . ': ' . $option['guest'] . ')</p></div>' . $option['statBlock'] . '</div></div></div>';
   }
   private function _joinReadTree()
   {
      $select = '';
      $join = '';
      if($this->userID) {
         $select .= ", IF(" . PREFIX . "_be_read_tree.bert_read_date > {$this->timeMarkerOldTopic}, " . PREFIX . "_be_read_tree.bert_read_date, {$this->timeMarkerOldTopic}) AS bert_read_date";
         $join .= " LEFT JOIN " . PREFIX . "_be_read_tree ON (" . PREFIX . "_be_read_tree.bert_tree_id = " . PREFIX . "_be_tree.tree_id AND " . PREFIX . "_be_read_tree.bert_user_id = {$this->userID})";
      } else {
      }
      return array('select' => $select, 'join' => $join);
   }
   protected function _userTrophies()
   {
      $name = $this->db->safesql(strip_tags(str_replace('/', '', $_GET['name'])));
      $row = $this->db->super_query("SELECT user_id,forum_inseption FROM " . PREFIX . "_users WHERE name LIKE '{$name}' LIMIT 1");
      $option = array('idUser' => intval($row['user_id']), 'inseptionInfoUser' => unserialize($row['forum_inseption']));
      if(!$option['idUser']) {
         die('no user');
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_30'] . $name));
      if(isset($option['inseptionInfoUser']['honor'])) {
         foreach ($option['inseptionInfoUser']['honor'] as $key => $value) {
            $option['return'] .= '<li class="infoUserTrophies"><h3>' . parent::$honor[$value]['criteria']['name'] . '</h3><div class="infoTrophies">' . parent::$honor[$value]['criteria']['desc'] . '</div><div title="' . parent::$modules_lang['trophies_8'] . parent::$honor[$value]['bals'] . parent::$modules_lang['trophies_7'] . '" class="balsTrophies">' . parent::$honor[$value]['bals'] . '</div></li>';
         }
         $option['return'] .= '<li class="infoUserTrophies infoBall">' . parent::$modules_lang['trophies_5'] . count($option['inseptionInfoUser']['honor']) . parent::$modules_lang['trophies_6'] . $option['inseptionInfoUser']['bals'] . parent::$modules_lang['trophies_7'] . '</li>';
         $option['return'] = '<h3 class="treeNameList">' . parent::$modules_lang['side_bar_32'] . $name . '</h3><div id="desTtee"> </div><ol class="pageTrophies boxUserTrophies">' . $option['return'] . '</ol>';
      } else {
         $option['return'] = parent::$view->error_set(parent::$modules_lang['information'], parent::$modules_lang['trophies_9']);
      }
      $option['widget'] = $this->_getSidebar();
      return parent::$view->setTplMainBlock($option['return'], $this->_setMetaTitl(array('titleAction' => parent::$modules_lang['side_bar_32'] . $name)), array('widget' => $option['widget']));
   }
   /**
    * BulletEnergyHandler::_messageUser()
    *     . 
    * @return
    */
   protected function _messageUser()
   {
      $name = $this->db->safesql(strip_tags(str_replace('/', '', $_GET['name'])));
      $row = $this->db->super_query("SELECT name,user_id,foto FROM " . PREFIX . "_users WHERE name LIKE '{$name}' LIMIT 1");
      $option = array('idUser' => intval($row['user_id']), 'foto' => $row['foto']);
      if(!$option['idUser']) {
         die('no user');
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_12'] . $name));
      $row = $this->db->super_query("SELECT count( * ) AS count  FROM " . PREFIX . "_be_message AS msg WHERE autors_id = '{$option['idUser']}' AND msg.tree_id IN(" . $this->_getGroupIdParseTree() . ")");
      $pag = $this->setPaginator(array('unreadCount' => $row['count'], 'name_user' => $name, 'linck' => $this->linck->userMessage($name)));
      $this->db->query("SELECT msg.id AS post_id, msg.message_autor, msg.autors_id, msg.message_date, msg.message_text, msg.msg_edit_date, msg.edit_autor, msg.id_topic,topic.id, topic.title, topic.id_parent, topic.reply_count FROM " . PREFIX . "_be_message AS msg LEFT JOIN " . PREFIX . "_be_topic AS topic ON	(msg.id_topic = topic.id) WHERE msg.autors_id = '{$option['idUser']}' AND msg.tree_id IN(" . $this->_getGroupIdParseTree() . ") ORDER BY msg.message_date DESC LIMIT {$pag['start']},{$pag['nums']}");
      if(!$this->db->num_rows()) {
         return parent::$view->setTplMainBlock(parent::$view->error_set(parent::$modules_lang['user_6'], parent::$modules_lang['user_4']), $this->_setMetaTitl(array('post' => 0)), array('spedbar' => array('titlAction' => parent::$modules_lang['user_2'] . $name)));
      } else {
         while ($row = $this->db->get_row()) {
            $data = array();
            $data['post_id'] = $row['post_id'];
            $data['idTree'] = $row['id_parent'];
            $data['titlTree'] = parent::$treePermanent[$row['id_parent']]['tree_title'];
            $data['title'] = stripcslashes($row['title']);
            $data['id'] = $row['id_topic'];
            $data['message_autor'] = $row['message_autor'];
            $data['autors_id'] = $row['autors_id'];
            $data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
            $data['message_text'] = stripslashes($row['message_text']);
            $data['foto'] = $this->isAvatarUser($option['foto']);
            $data['msg_edit_date'] = $row['msg_edit_date'];
            $data['edit_autor'] = $row['edit_autor'];
            parent::$view->setTplMessageSearchUser($data);
         }
         return parent::$view->setTplMainBlock(parent::$view->setTplViewFullTopic(array('message' => parent::$view->tpl->result['short_message'], 'paginator' => $pag['paginator'])), $this->_setMetaTitl(array('titleAction' => parent::$modules_lang['user_2'] . $name)), array('spedbar' => array('titlAction' => parent::$modules_lang['user_2'] . $name)));
      }
   }
   protected function _topicUser()
   {
      $name = $this->db->safesql(strip_tags(str_replace('/', '', $_GET['name'])));
      $row = $this->db->super_query("SELECT name,user_id,foto FROM " . PREFIX . "_users WHERE name = '{$name}' LIMIT 1");
      $option = array('idUser' => intval($row['user_id']), 'foto' => $row['foto']);
      if(!$option['idUser']) {
         die('no user');
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_13'] . $name));
      $row = $this->db->super_query("SELECT count( * ) AS count FROM " . PREFIX . "_be_topic AS topic WHERE autor_id = '{$option['idUser']}'AND topic.id_parent IN(" . $this->_getGroupIdParseTree() . ")");
      $pag = $this->setPaginator(array('unreadCount' => $row['count'], 'name_user' => $name, 'linck' => $this->linck->userTopic($name)));
      $this->db->query("SELECT topic.title,topic.reply_count,topic.id,topic.id_parent,topic.post_date,topic.autor_id,topic.autor,msg.message_text,msg.msg_edit_date,msg.edit_autor,msg.message_date FROM " . PREFIX . "_be_topic AS topic LEFT JOIN " . PREFIX . "_be_message AS msg ON	msg.id_topic = topic.id AND  msg.parent_msg = 1 WHERE topic.autor_id = '{$option['idUser']}' AND topic.id_parent IN(" . $this->_getGroupIdParseTree() . ") ORDER BY topic.last_reply_date DESC LIMIT {$pag['start']},{$pag['nums']}");
      if(!$this->db->num_rows()) {
         return parent::$view->setTplMainBlock(parent::$view->error_set(parent::$modules_lang['user_6'], parent::$modules_lang['user_7']), $this->_setMetaTitl(array('titleAction' => parent::$modules_lang['information'])), array('spedbar' => array('titlAction' => parent::$modules_lang['user_2'] . $name)));
      } else {
         while ($row = $this->db->get_row()) {
            $data = array();
            $data['idTree'] = $row['id_parent'];
            $data['titlTree'] = parent::$treePermanent[$row['id_parent']]['tree_title'];
            $data['title'] = stripcslashes($row['title']);
            $data['id'] = $row['id'];
            $data['message_autor'] = $row['autor'];
            $data['autors_id'] = $row['autor_id'];
            $data['reply_count'] = $row['reply_count'];
            $data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
            $data['message_text'] = stripslashes($row['message_text']);
            $data['foto'] = $this->isAvatarUser($option['foto']);
            $data['msg_edit_date'] = $row['msg_edit_date'];
            $data['edit_autor'] = $row['edit_autor'];
            parent::$view->topic_search_user($data);
         }
         return parent::$view->setTplMainBlock(parent::$view->setTplViewFullTopic(array('message' => parent::$view->tpl->result['short_message'], 'topicName' => '', 'replic' => '', 'paginator' => $pag['paginator'])), $this->_setMetaTitl(array('titleAction' => parent::$modules_lang['user_1'] . $name)), array('spedbar' => array('titlAction' => parent::$modules_lang['user_1'] . $name)));
      }
   }
   public function _getGroupIdParseTree()
   {
      return $this->db->safesql(implode(',', array_intersect(explode(',', parent::$sys_cashe['accessTreeView']), explode(',', parent::$sys_cashe['accessTopicView'])))) ? $this->db->safesql(implode(',', array_intersect(explode(',', parent::$sys_cashe['accessTreeView']), explode(',', parent::$sys_cashe['accessTopicView'])))) : 0;
   }
   protected function _topicUnread()
   {
      $row = array();
      $option = array();
      if(!parent::$logged_is) {
         $option['return'] = parent::$view->error_set(parent::$modules_lang['topic_19'], parent::$modules_lang['topic_37']);
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_10']));
      if(parent::$logged_is) {
         $option['joinAprove'] = $this->ckeckModulesConfig('be_moder_moder_view') ? '' : "AND topic.topic_approve = 1";
         $row = $this->db->super_query("SELECT count( * ) AS count 
                                     FROM " . PREFIX . "_be_topic AS topic
                                     LEFT JOIN " . PREFIX . "_be_read_topic AS read_topic ON (
                                       read_topic.ber_topic_id = topic.id 
                                       AND read_topic.ber_user_id = {$this->userID} 
                                       AND read_topic.ber_read_date >= topic.last_reply_date
                                     ) 
                                     WHERE 
                                       read_topic.ber_read_date IS NULL 
                                     AND topic.id_parent IN(
                                       " . $this->_getGroupIdParseTree() . "
                                     ) 
                                     AND topic.last_reply_date > {$this->timeMarkerOldTopic}
                                     {$option['joinAprove']}");
         $option['paginator'] = $this->setPaginator(array('unreadCount' => $row['count'], 'linck' => $this->linck->pageNewPost()));
         $this->db->query("SELECT * FROM " . PREFIX . "_be_topic AS topic
                        LEFT JOIN " . PREFIX . "_be_read_topic  AS read_topic ON (
                          read_topic.ber_topic_id = topic.id
                          AND read_topic.ber_user_id = {$this->userID} 
                          AND read_topic.ber_read_date >= topic.last_reply_date
                        ) 
                        WHERE 
                          read_topic.ber_read_date IS NULL 
                        AND topic.id_parent IN(
                          " . $this->_getGroupIdParseTree() . "
                        )
                        AND topic.last_reply_date > {$this->timeMarkerOldTopic}
                        {$option['joinAprove']}
                        ORDER BY 
                          last_reply_date 
                        DESC LIMIT {$option['paginator']['start']},{$option['paginator']['nums']}");
         if(!$this->db->num_rows()) {
            $option['return'] = parent::$view->error_set(parent::$modules_lang['topic_19'], parent::$modules_lang['topic_20']);
         } else {
            while ($row = $this->db->get_row()) {
               $data = array();
               $data['id_parent'] = $row['id_parent'];
               $data['status_read'] = 'unread';
               $data['id'] = $row['id'];
               $data['title'] = stripslashes($row['title']);
               $data['reply_count'] = $row['reply_count'];
               $data['statusTitl'] = parent::$modules_lang['topic_35'];
               $data['view_count'] = $row['view_count'];
               $data['autor_id'] = $row['autor_id'];
               $data['autor'] = stripslashes($row['autor']);
               $data['site_description'] = stripslashes($row['topic_descr_site']);
               $data['post_date'] = $this->setDate($row['post_date']);
               $data['rating'] = $row['rating'];
               $data['last'] = unserialize($row['last_reply_info']);
               $data['topic_approve'] = $row['topic_approve'];
               $data['fixed'] = $row['topic_fixed'];
               $data['topic_type'] = $row['topic_type'];
               parent::$view->setTopicList($data);
            }
            $option['return'] = parent::$view->setBlockTopic(array('topicList' => parent::$view->tpl->result['short_topic'], 'titlAction' => parent::$modules_lang['topic_17'], 'paginator' => $option['paginator']['paginator'], 'treeDescr' => parent::$modules_lang['topic_18']));
         }
      }
      return parent::$view->setTplMainBlock($option['return'], $this->_setMetaTitl());
   }
   private function _setMetaTitl(array $option = array())
   {
      $result = array();
      switch (parent::$action) {
         case 'new_post':
            $result = array(parent::$modules_lang['what_new'], parent::$modules_lang['topic_22'], parent::$modules_config['meta_keywords']);
            break;
         case 'moderation':
            $result = array($option['titleAction'], parent::$modules_lang['msg_30'], parent::$modules_config['meta_keywords']);
            break;
         case 'trophies':
            $result = array($option['titleAction'], $option['titleAction'], $option['titleAction']);
            break;
         case 'main':
            $result = array(parent::$modules_config['meta_titl'], parent::$modules_config['meta_descr'], parent::$modules_config['meta_keywords']);
            break;
         case 'categories':
            $result = array(parent::$treePermanent[$this->id]['tree_title'], $this->_dle_substr(parent::$tree[$this->id]['tree_description'], 0, 190, parent::$config_dle['charset']), $this->_generateMetaKey(parent::$tree[$this->id]['tree_description']));
            break;
         case 'showtopic':
            $result = array($option['Titl'], $option['Description'], $option['Key']);
            break;
         case 'newtopic':
            $result = array(parent::$modules_lang['topic_new_3'] . parent::$treePermanent[$this->id]['tree_title'], parent::$modules_lang['topic_new_3'] . parent::$treePermanent[$this->id]['tree_title'], parent::$modules_config['meta_keywords']);
            break;
         case 'add_message':
            if($option[4]) {
               $result = array($option[0], $option[1], $option[2]);
            }
            break;
         case 'message_user':
            $result = array($option['titleAction'], $option['titleAction'], parent::$modules_config['meta_keywords']);
            break;
         case 'topic_user':
            $result = array($option['titleAction'], $option['titleAction'], parent::$modules_config['meta_keywords']);
            break;
         case 'findpost':
            $result = array($option['subInfo'], parent::$modules_lang['user_0'], parent::$modules_config['meta_keywords']);
            break;
         case 'watched':
            $result = array(parent::$modules_lang['topicVis'], parent::$modules_lang['topicVis'], parent::$modules_config['meta_keywords']);
            break;
         case 'watched_all':
            $result = array(parent::$modules_lang['topicVis'], parent::$modules_lang['topicVis'], parent::$modules_config['meta_keywords']);
            break;
         case 'search':
            $result = array(parent::$modules_lang['search_forum'], parent::$modules_lang['search_forum'], parent::$modules_config['search_forum']);
            break;
         case 'search_proccess':
            $result = array(parent::$modules_lang['search_forum'], parent::$modules_lang['search_forum'], parent::$modules_config['search_forum']);
            break;
         default:
            break;
      }
      $result[0] = $this->page > 1 ? $result[0] . parent::$modules_lang['page'] . $this->page : $result[0];
      foreach ($result as $key => $val) {
         $val = stripslashes(htmlspecialchars($val));
      }
      return $result;
   }
   private function _getNewMessage()
   {
      $row = array();
      $ret = '';
      $this->db->query("SELECT 
                        msg.message_autor, 
                        msg.autors_id, 
                        msg.message_date, 
                        msg.id_topic, 
                        msg.id,topic.title
                      FROM " . PREFIX . "_be_message AS msg
                      LEFT JOIN " . PREFIX . "_be_topic AS topic ON (
                        msg.id_topic = topic.id
                      )
                      WHERE 
                        tree_id IN (" . $this->_getGroupIdParseTree() . ")
                      ORDER BY 
                        message_date DESC 
                      LIMIT 0 , " . parent::$modules_config['widget_last_post_count'] . "");
      if(!$this->db->num_rows()) {
         return false;
      }
      while ($row = $this->db->get_row()) {
         $row['message_date'] = $this->setDate($row['message_date']);
         $ret .= '<li><a class="title" href="' . $this->linck->postLinck($row['id_topic'], $row['id'], $this->totranslit($row['title'], true, true)) . '">' . stripcslashes($row['title']) . '</a>' . parent::$modules_lang['side_bar_0'] . $this->linck->card_user(array($row['message_autor'], $row['autors_id'])) . $row['message_autor'] . '</a> <b class="date">(' . $row['message_date'] . ')</b></li>';
      }
      $ret = '<div class="contentBoxTopicList treeBox">
  <ol>
    <li class="tree">
      <div class="treeTitl">
        <div class="inertBox">
          <h3>' . parent::$modules_lang['side_bar_1'] . '</h3>
        </div>
      </div>
      <ol>' . $ret . '</ol>
    </li>
  </ol>
</div>';
      /*
      
      </ol></div>*/
      return $ret;
   }
   protected function _viewTopic()
   {
      $data = array();
      $join = parent::$logged_is ? array('readJoin' => "LEFT JOIN " . PREFIX . "_be_read_topic AS read_topic ON topic.id = read_topic.ber_topic_id AND read_topic.ber_user_id = {$this->userID}", 'readColum' => ', read_topic . *', 'feed' => "LEFT JOIN " . PREFIX . "_be_feed AS feed ON (feed.id_topic = $this->id)  AND feed.id_user = {$this->userID}", 'columFeed' => ',feed.id_user') : array('readJoin' => '', 'readColum' => '');
      $row = $this->db->super_query("SELECT topic . *  {$join['readColum']}{$join['columFeed']} FROM " . PREFIX . "_be_topic AS topic {$join['readJoin']} {$join['feed']} WHERE topic.id = {$this->id} LIMIT 1");
      $option = array('metaTags' => unserialize($row['topic_meta']), 'id_parent' => intval($row['id_parent']), 'teadDateTopic' => intval($row['ber_read_date']), 'typeTopic' => intval($row['topic_type']), 'topicRating' => intval($row['rating']), 'lastReply' => intval($row['last_reply_date']), 'postDate' => intval($row['post_date']), 'title' => stripslashes($row['title']), 'topicDescrSite' => stripslashes($row['topic_descr_site']), 'aproveTopic' => intval($row['topic_approve']), 'userPrivateTopic' => $row['topic_private_user'], 'isFeed' => $row['id_user'], 'isPostFix' => intvaL($row['is_fixed_count']), 'vote' => empty($row['vote_id']) ? false : intval($row['vote_id']));
      //var_dump($option['metaTags']);
      if(!parent::$modules_config['is_cpu_type'] and parent::$modules_config['handler_cpu'] and parent::$modules_config['cpu']) {
         $option['topicTitleTranslite'] = $this->totranslit($option['title'], true, true);
         if($this->getString('name') != $option['topicTitleTranslite']) {
            header("HTTP/1.0 301 Moved Permanently");
            header("Location: " . $this->linck->topicIsRedirect($this->id, $option['topicTitleTranslite']));
            die("Redirect");
         }
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_14'] . $option['title'], 'idTopic' => $this->id));
      $option['speedbar'] = array('titlAction' => $option['title'], 'idTree' => $option['id_parent'], 'titlTree' => stripslashes(parent::$treePermanent[$option['id_parent']]['tree_title']));
      if(!$option['id_parent']) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_12']);
      }
      $row = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_message WHERE id_topic = {$this->id} AND fixap_msg = 0");
      $option['countMessage'] = $row['count'];
      if(!$this->_checkTreeConfigParam('tree_access_topic_read', $option['id_parent'])) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_11']);
      }
      if(!$option['aproveTopic'] and !$this->ckeckModulesConfig('be_moder_moder_view')) {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_38']);
      }
      if($option['typeTopic'] == 1 and !in_array(parent::$id_member['name'], explode(',', $option['userPrivateTopic']))) {
         return parent::$view->setTplMainBlock(parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['error_17']), array(parent::$modules_lang['error_3'], parent::$modules_lang['error_3'], parent::$modules_lang['error_3']));
      }
      if(parent::$modules_config['topic_view']) {
         $this->db->query("UPDATE " . PREFIX . "_be_topic 
                        set view_count= view_count + 1 
                        where id = {$this->id}");
      }
      $pag = $this->setPaginator(array('unreadCount' => $option['countMessage'], 'linck' => $this->linck->topicLinck($this->id, $this->totranslit($option['title'], true, true))));
      if(parent::$modules_config['reputations']) {
         $option['joinReputation'] = ', repa, repa_mod, repa_off, r_freeze';
      }
      $option['advertising'] = parent::$modules_config['adv'] ? $this->_advertising($option['id_parent'], false) : '';
      if($option['advertising']['position'] == 'random') {
         $option['rand'] = rand(1, parent::$modules_config['message_count_page']);
      } elseif($option['advertising']['position'] == 'top') {
         $option['contentTopAdv'] = stripcslashes($option['advertising']['content']);
      } elseif($option['advertising']['position'] == 'footer') {
         $option['contentFooterAdv'] = stripcslashes($option['advertising']['content']);
      }
      $option['dataIsOnline'] = $this->time - parent::$modules_config['session_time'] * 60;
      if(parent::$modules_config['session_check'] and parent::$modules_config['online']) {
         $option['joinStatus'] = array('table' => "LEFT JOIN " . PREFIX . "_be_session AS session 
                                                ON ( msg.autors_id = session.user_id )", 'select' => ', session.session_id', 'where' => "AND session.date > {$option['dataIsOnline']}");
      }
      $this->page = empty($this->page) ? 1 : $this->page;
      $option['countIdPost'] = ($this->page - 1) * parent::$modules_config['message_count_page'] + 1;
      if(parent::$modules_config['is_like'] and parent::$logged_is) {
         $option['joinThanks'] = array('colums' => ',thanks.thanks_id');
         $option['joinThanks']['join'] = "LEFT JOIN " . PREFIX . "_be_thanks as thanks ON (thanks.thanks_msg_id = msg.id) 
                                       and thanks.thanks_id_user = " . $this->userID;
      }
      // var_dump($option['isPostFix']>0);
      if($option['isPostFix'] > 0) {
         $this->db->query("SELECT msg.*, user.* {$option['joinReputation']} {$option['joinStatus']['select']} {$option['joinThanks']['colums']} FROM " . PREFIX . "_be_message as msg LEFT JOIN " . PREFIX . "_users as user ON (msg.autors_id = user.user_id) {$option['joinStatus']['table']} {$option['joinStatus']['where']} {$option['joinThanks']['join']} WHERE id_topic = {$this->id} AND msg.fixap_msg = 1 ORDER BY message_date ASC");
         $option['fixedPostCount'] = $this->db->num_rows();
         $option['returntData'] = $this->_messageDataRender(array('countPost' => 0, 'titleTopic' => $this->totranslit($option['title']), 'countIdPost' => 1, 'typeTopic' => $option['typeTopic'], 'rand' => $option['rand'], 'adv' => $option['advertising']['content']));
         //var_dump($option['fixedPostCount'], $option['rand'], $option['fixedPostCount'] <= $option['rand']);
         if($option['rand'] <= $option['fixedPostCount'] and !empty($option['rand'])) {
            unset($option['advertising']['content']);
         }
      }
      $this->db->query("SELECT msg.*, user.* {$option['joinReputation']} {$option['joinStatus']['select']} {$option['joinThanks']['colums']} FROM " . PREFIX . "_be_message as msg LEFT JOIN " . PREFIX . "_users as user ON (msg.autors_id = user.user_id) {$option['joinStatus']['table']} {$option['joinStatus']['where']} {$option['joinThanks']['join']} WHERE id_topic = {$this->id} AND msg.fixap_msg = 0 ORDER BY  id ASC LIMIT {$pag['start']}, {$pag['nums']}");
      $option['returntData'] = $this->_messageDataRender(array('countPost' => 0, 'lastPostDatePage' => $option['returntData']['lastPostDatePage'], 'titleTopic' => $this->totranslit($option['title']), 'countIdPost' => $option['countIdPost'], 'typeTopic' => $option['typeTopic'], 'rand' => $option['rand'], 'adv' => $option['advertising']['content']));
      if(count($option['returntData']['attachmentIdArray'])) {
         foreach ($option['returntData']['attachmentIdArray'] as $key => $value) {
            $replace = '';
            $searchTags = '';
            $searchTags = '{attachment-' . $value . '}';
            $this->db->query("SELECT * FROM " . PREFIX . "_be_attachment WHERE attachment_type = 1 AND attachment_content_id = {$value}");
            while ($row = $this->db->get_row()) {
               $data = $row['attachment_date'];
               $name = substr($row['attachment_name'], 10);
               $user_name = $row['attachment_user_name'];
               $size = $this->formatsize($row['size']);
               if(!parent::$groups_config[parent::$id_member['user_group']]['be_access_download'] or $this->id != $row['topic_id']) {
                  $replace = parent::$modules_lang['attachment_1'];
               } elseif(parent::$modules_config['dowload_count']) {
                  $replace .= '<li class="attachmentBox"><div class="InnertBox"><div class="attachmentInfoBox"><h4><a href="' . $this->linck->attachLinck(intval($row['attachment_id'])) . '">' . $name . '</a></h4>
            <dl><dt>' . parent::$modules_lang['attachment_2'] . '</dt><dd>' . $size . '</dd></dl>
            <dl><dt>' . parent::$modules_lang['attachment_3'] . '</dt><dd>' . $row['attachment_count'] . '</dd></dl></div></div></li>';
               } elseif(!parent::$modules_config['dowload_count']) {
                  $replace .= '<li class="attachmentBox"><div class="InnertBox"><div class="attachmentInfoBox"><h4><a href="' . $this->linck->attachLinck(intval($row['attachment_id'])) . '">' . $name . '</a></h4>
            <dl><dt>' . parent::$modules_lang['attachment_2'] . '</dt><dd>' . $size . '</dd></dl></div></div></li>';
               } else {
                  $replace = parent::$modules_lang['attachment_4'];
               }
            }
            $replace = '<div class="attachment_forum" id="attachmentBox-' . $value . '"><h4>' . parent::$modules_lang['attachment_0'] . '</h4><ol>' . $replace . '</ol></div>';
            parent::$view->tpl->result['short_message'] = str_replace($searchTags, $replace, parent::$view->tpl->result['short_message']);
         }
      }
      if($this->_checkTreeConfigParam('tree_access_topic_replic', $option['id_parent']) and parent::$logged_is) {
         if($option['typeTopic'] != 2 or ($option['typeTopic'] == 2 and $this->ckeckModulesConfig('be_replic_is_cloze'))) {
            $option['addMessageTpl'] = parent::$view->add_message(array($this->id, $this->page));
         }
      }
      //  var_dump($option['returntData']['lastPostDatePage'] >= $option['lastReply'],$option['returntData']['lastPostDatePage'] , $option['lastReply']);
      $this->_countUnreadTopic(array($this->userID, $option['id_parent'], $this->timeMarkerOldTopic));
      if($option['typeTopic'] == 2 and !$this->ckeckModulesConfig('be_replic_is_cloze')) {
         parent::$view->tpl->result['block_full_topic'] = '<p class="topicStatus"><b>' . parent::$modules_lang['topic_46'] . '</b>' . parent::$modules_lang['topic_47'] . '</p>';
      } elseif($option['typeTopic'] == 1) {
         parent::$view->tpl->result['block_full_topic'] = '<p class="topicStatus"><b>' . parent::$modules_lang['topic_46'] . '</b>' . parent::$modules_lang['topic_48'] . '</p>';
      }
      if($this->checkModerator($option['idTree'])) {
         $option['optionSel'] = "<a class=\"optionTopic\" onclick=\"topicOption('" . $this->id . "'); return false;\" href=\"#\">" . parent::$modules_lang['topic_53'] . "</a>";
      }
      if(parent::$modules_config['enable_rss_topic']) {
         $option['optionSel'] .= '<a class="rssTopicFeed" href="' . $this->linck->rssTopic($this->id) . '">' . parent::$modules_lang['topic_63'] . '</a>';
      }
      if(!empty($option['vote'])) {
         $option['voteSet'] = $this->_renderVoteBlock($option['vote'], $option['id_parent']);
      }
      if(parent::$logged_is and $option['returntData']['lastPostDatePage'] >= $option['lastReply']) {
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_topic (ber_read_id,ber_user_id,ber_topic_id,ber_tree_id,ber_read_date) VALUES (NULL,{$this->userID},{$this->id},{$option['id_parent']},{$this->time}) ON DUPLICATE KEY UPDATE ber_read_date = {$this->time}");
      }
      $option['optionSel'] .= $option['isFeed'] ? '<a id="feedClick" onclick="topicFeed(\'' . $this->id . '\'); return false;" class="optionTopic" href="#">' . parent::$modules_lang['topic_55'] . '</a>' : '<a id="feedClick" onclick="topicFeed(\'' . $this->id . '\'); return false;" class="optionTopic" href="#">' . parent::$modules_lang['topic_54'] . '</a>';
      $option['optionSel'] = parent::$logged_is ? $option['optionSel'] : '';
      $option['share'] = $this->_getShareBlock($this->linck->topicLinck($this->id, $this->totranslit($option['title'], true, true)), $option['title'], $option['metaTags']['Description']);
      $option['topicContentPage'] = parent::$view->setTplViewFullTopic(array('share' => $option['share'], 'vote' => $option['voteSet'], 'message' => parent::$view->tpl->result['short_message'] . $option['contentFooterAdv'], 'topicName' => $option['title'], 'topicDescrSite' => $option['topicDescrSite'], 'optionSel' => $option['optionSel'], 'replic' => $option['addMessageTpl'], 'paginator' => $pag['paginator']));
      $option['widget'] = in_array(parent::$action, $this->sideBar) ? $this->_getSidebar() : false;
      return parent::$view->setTplMainBlock($option['contentTopAdv'] . $option['topicContentPage'], $this->_setMetaTitl($option['metaTags']), array('spedbar' => $option['speedbar'], 'widget' => $option['widget']));
   }
   private function _messageDataRender(array $param = array())
   {
      if(empty($param['lastPostDatePage'])) {
         $param['lastPostDatePage'] = 0;
      }
      while ($row = $this->db->get_row()) {
         $data = array();
         $attachment = '';
         if(intval($row['attachment'])) {
            $param['attachmentIdArray'][] = $row['id'];
            $attachment = '{attachment-' . $row['id'] . '}';
         }
         if($this->ckeckModulesConfig('be_access_thanks') and parent::$modules_config['is_like'] and !$row['thanks_id'] and $this->userID != $row['autors_id']) {
            $data['like'] = '<a class="likeContent" onclick="like(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['like_0'] . '</a>'; //like
         } elseif($this->ckeckModulesConfig('be_access_thanks') and parent::$modules_config['is_like'] and $row['thanks_id'] and $this->userID != $row['autors_id']) {
            $data['like'] = '<a class="likeContent" onclick="like(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['like_1'] . '</a>'; //unlike
         } else {
            $data['like'] = false;
         }
         $data['one_message'] = $row['parent_msg'];
         $data['likeCountUser'] = $row['forum_thanks_count'];
         $data['repa'] = $row['repa'];
         $data['repa_mod'] = $row['repa_mod'];
         $data['repa_off'] = $row['repa_off'];
         $data['r_freeze'] = $row['r_freeze'];
         $data['thanks_count'] = $row['thanks'];
         $data['user_thanks'] = $row['user_thanks'];
         $data['titleTopic'] = $param['titleTopic'];
         $data['id_msg_topic'] = $param['countIdPost'];
         $data['message_autor'] = $row['message_autor'];
         $data['autors_id'] = $row['autors_id'];
         if($this->ckeckModulesConfig('be_warning') and parent::$modules_config['widget_warning']) {
            //var_dump($row['forum_warning']);
            $data['warning'] = true;
            $data['countWarning'] = '<a href="#" onclick="doWarning(\'' . $row['id'] . '\',\'post\',\'1\'); return false;"  title="' . parent::$modules_lang['msg_43'] . '">' . $row['forum_warning'] . '</a>';
         } elseif($this->userID == $row['autors_id'] and $this->ckeckModulesConfig('be_view_warning_log') and parent::$modules_config['widget_warning'] and $row['forum_warning'] > 0) {
            $data['warning'] = true;
            $data['countWarning'] = '<a href="#" onclick="doWarning(\'' . $row['id'] . '\',\'post\',\'0\'); return false;"  title="' . parent::$modules_lang['msg_43'] . '">' . $row['forum_warning'] . '</a>';
         } else {
            $data['warning'] = false;
         }
         $data['isOnline'] = empty($row['session_id']) ? false : true;
         if($this->checkModerator($row['tree_id']) and $this->ckeckModulesConfig('be_moder_ip_view')) {
            $data['message_autor_ip'] = long2ip($row['message_autor_ip']);
         }
         if($row['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfig('be_access_edit_my_post') and $row['message_date'] + (parent::$modules_config['edit_time_post'] * 60) > $this->time and $param['typeTopic'] != 2) {
            $data['editCommentAccess'] = true;
         } elseif($row['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfig('be_moder_edit_message_user') and $this->checkModerator($row['tree_id'])) {
            $data['editCommentAccess'] = true;
         } elseif($row['autors_id'] == parent::$id_member['user_id'] and $this->checkModerator($row['tree_id']) and $this->ckeckModulesConfig('be_access_edit_my_post')) {
            $data['editCommentAccess'] = true;
         } else {
            $data['editCommentAccess'] = false;
         }
         if($row['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfig('be_access_del_my_post') and $this->time - ($row['message_date'] + 120) < 0 and !$row['parent_msg']) {
            $data['deleteMessage'] = true;
         } elseif($row['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfig('be_moder_del_message_user') and $this->checkModerator($row['tree_id']) and !$row['parent_msg']) {
            $data['deleteMessage'] = true;
         } elseif($row['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfig('be_access_del_my_post') and $this->checkModerator($row['tree_id']) and !$row['parent_msg']) {
            $data['deleteMessage'] = true;
         } else {
            $data['deleteMessage'] = false;
         }
         if(parent::$logged_is and $param['typeTopic'] != 2) {
            $data['fast'] = true;
         } else {
            $data['fast'] = false;
         }
         if($this->ckeckModulesConfig('be_complaint') and $row['message_autor'] != parent::$id_member['name']) {
            $data['complaint'] = true;
         } else {
            $data['complaint'] = false;
         }
         if(parent::$modules_config['is_like']) {
            $row['user_thanks'] = unserialize($row['user_thanks']);
            if($row['user_thanks']) {
               foreach ($row['user_thanks'] as $key => $value) {
                  $data['fetchLike'][] = $this->linck->setLinckCardUser(array($value[0], $value[1], parent::$modules_lang['card_user'])) . $value[0] . '</a>';
               }
            }
            if(($row['thanks'] - 3) > 0) {
               $data['sorseAll'] = $row['thanks'] - 3;
               $data['likeUserAll'] = parent::$modules_lang['like_4'] . '<a href="#" onclick="getAllLike(\'' . $row['id'] . '\'); return false;">' . parent::$modules_lang['like_3'] . $data['sorseAll'] . '</a>';
            }
            $data['msgUserLike'] = count($data['fetchLike']) ? '<div class="likeBox-' . $row['id'] . '"><div>' . implode(', ', $data['fetchLike']) . $data['likeUserAll'] . parent::$modules_lang['like_2'] . '</div></div>' : '<div class="likeBox-' . $row['id'] . '"></div>';
         }
         $data['message_date'] = $this->setDate($row['message_date']);
         if($this->ckeckModulesConfig('be_fix') and $this->checkModerator($row['tree_id'])) {
            $data['lock'] = empty($row['fixap_msg']) ? '<a id="lockPost-' . $row['id'] . '" onclick="lockPost(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_34'] . '</a>' : '<a id="lockPost-' . $row['id'] . '" onclick="UnLockPost(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_35'] . '</a>';
         }
         $data['message_text'] = stripslashes($row['message_text']) . $attachment . $data['msgUserLike'];
         $data['news_num'] = $row['news_num'];
         $data['comm_num'] = $row['comm_num'];
         $data['forum_topic_count'] = $row['forum_topic_count'];
         $data['forum_post_count'] = $row['forum_post_count'];
         if($row['banned']) {
            $data['user_group'] = parent::$modules_lang['msg_63'];
         } else {
            $data['user_group'] = parent::$group_user[$row['user_group']]['group_name'];
         }
         //var_dump(date('Y/m/d',1317206249));
         $data['css_name'] = parent::$groups_config[$row['user_group']]['be_style_name_css'];
         $data['css_group'] = parent::$groups_config[$row['user_group']]['be_style_group_css'];
         $data['reg_date'] = $this->langdate(parent::$modules_config['time_step_autor'], $row['reg_date']);
         $data['foto'] = $this->isAvatarUser($row['foto']);
         $data['msg_edit_date'] = $row['msg_edit_date'];
         $data['edit_autor'] = $row['edit_autor'];
         $data['signature'] = stripcslashes($row['signature']);
         $data['icq'] = $row['icq'];
         $data['mesage_id'] = $row['id'];
         $row['forum_inseption'] = unserialize($row['forum_inseption']);
         $data['titleUser'] = parent::$title[$row['forum_inseption']['title']]['title'] ? parent::$title[$row['forum_inseption']['title']]['title'] : '';
         $data['countTrophies'] = count($row['forum_inseption']['honor']);
         $data['countTrophiesLinck'] = $data['countTrophies'] > 0 ? $this->linck->userTrophies($data['message_autor'], $data['autors_id'], true, parent::$modules_lang['trophies_3']) : '';
         $data['countTrophiesLinckOut'] = $data['countTrophies'] > 0 ? '</a>' : '';
         $data['parent_msg'] = $row['parent_msg'];
         $param['countPost']++;
         $param['countIdPost']++;
         parent::$view->messge_topic($data);
         if($param['countPost'] == $param['rand']) {
            parent::$view->tpl->result['short_message'] .= $param['adv'];
         }
         $param['lastPostDatePage'] = $row['message_date'];
      }
      return array('countPost' => $param['countPost'], 'countIdPost' => $param['countIdPost'], 'attachmentIdArray' => $param['attachmentIdArray'], 'lastPostDatePage' => $param['lastPostDatePage']);
   }
   private function _getShareBlock($url = '', $title = '', $infoTopic = '')
   {
      $option = array();
      $option['logo'] = parent::$config_dle['http_home_url'] . 'templates/' . parent::$config_dle['skin'] . '/bullet_energy/images/logo.png';
      $option['title'] = $this->_convertCharset($title, 'utf-8');
      if(empty($option['title']) or empty($url)) {
         return false;
      }
      $option['title'] = urlencode($option['title']);
      $option['url'] = urlencode($url);
      foreach (parent::$share as $key => $value) {
         if(empty($value['type'])) {
            continue;
         }
         switch ($key) {
            case 'twitter':
               $option['return'][$value['position']] = '<li class="twitter"><a title="' . parent::$modules_lang['share_0'] . '" target="blank" rel="nofollow" href="http://twitter.com/intent/tweet?status=' . $option['title'] . '%20-%20' . $option['url'] . '">twitter</a></li>';
               break;
            case 'livejournal':
               $option['return'][$value['position']] = '<li class="livejournal"><a title="' . parent::$modules_lang['share_7'] . '" href="javascript:void((function(){var%20u=\'http://www.livejournal.com/\',w=window.open(\'\',\'\',\'toolbar=0,resizable=1,scrollbars=1,status=1,width=730,height=500\');if(window.LJ_bookmarklet){return%20LJ_bookmarklet(w,u)};var%20e=document.createElement(\'script\');e.setAttribute(\'type\',\'text/javascript\');e.onload=function(){LJ_bookmarklet(w,u)};e.setAttribute(\'src\',u+\'js/bookmarklet.js\');document.getElementsByTagName(\'head\').item(0).appendChild(e)})())"></a></li>';
               break;
            case 'vkontakte':
               $option['return'][$value['position']] = '<li class="vkontakte"><a title="' . parent::$modules_lang['share_1'] . '" onclick="return vkShare();" target="blank" rel="nofollow" href="http://vkontakte.ru/share.php?url=' . $option['url'] . '&amp;title=' . $option['title'] . '">vkontakte</a></li>';
               $option['js'] .= <<< HTML
 function vkShare() {
   u = location.href;
   i = '{$option['logo']}';
   window.open('http://vkontakte.ru/share.php?url=' + encodeURIComponent(u) + '&title=' + encodeURIComponent(t) + '&image=' + encodeURIComponent(i) + '&description=' + encodeURIComponent($.trim('{$infoTopic}')), 'share', 'toolbar=0,status=0,width=826,height=436');
   return false;
 }
HTML;
               break;
            case 'facebook':
               $option['return'][$value['position']] = '<li class="facebook"><a title="' . parent::$modules_lang['share_2'] . '" onclick="return fbShare();" target="blank" rel="nofollow" href="http://www.facebook.com/sharer.php?u=' . $option['url'] . '">facebook</a></li>';
               break;
               $option['js'] .= <<< HTML
function fbShare() {
  u = location.href;
  window.open('http://www.facebook.com/sharer.php?u=' + encodeURIComponent(u) + '&t=' + encodeURIComponent(t), 'sharer', 'toolbar=0,status=0,width=626,height=436');
  return false;
}
HTML;
            case 'memori':
               $option['return'][$value['position']] = '<li class="memori"><a title="' . parent::$modules_lang['share_3'] . '" target="blank" rel="nofollow" href="http://memori.ru/link/?sm=1&u_data[url]=' . $option['url'] . '&amp;u_data[name]=' . $option['title'] . '">memori</a></li>';
               break;
            case 'bobrdobr':
               $option['return'][$value['position']] = '<li class="bobrdobr"><a title="' . parent::$modules_lang['share_4'] . '" target="blank" rel="nofollow" href="http://bobrdobr.ru/addext.html?url=' . $option['url'] . '&amp;title=' . $option['title'] . '">bobrdobr</a></li>';
               break;
            case 'digg':
               $option['return'][$value['position']] = '<li class="digg"><a title="' . parent::$modules_lang['share_6'] . '" target="blank" rel="nofollow" href="http://digg.com/submit?&amp;url=' . $option['url'] . '&amp;title=' . $option['title'] . '">digg</a></li>';
               break;
            case 'delicious':
               $option['return'][$value['position']] = '<li class="delicious"><a title="' . parent::$modules_lang['share_5'] . '" target="blank" rel="nofollow" href="http://del.icio.us/post?v=2&amp;url=' . $option['url'] . '&amp;title=' . $option['title'] . '">digg</a></li>';
               break;
            case 'liveinternet':
               $option['return'][$value['position']] = '<li class="liveinternet"><a title="' . parent::$modules_lang['share_9'] . '" target="blank" rel="nofollow" href="http://www.liveinternet.ru/journal_post.php?action=n_add&amp;cnurl=' . $option['url'] . '&amp;cntitle=' . $option['title'] . '">liveinternet</a></li>';
               break;
            case 'linkedin':
               $option['return'][$value['position']] = '<li class="linkedin"><a title="' . parent::$modules_lang['share_10'] . '" target="blank" rel="nofollow" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=' . $option['url'] . '&amp;title=' . $option['title'] . '">linkedin</a></li>';
               break;
            case 'ya':
               $option['return'][$value['position']] = '<li class="ya"><a title="' . parent::$modules_lang['share_11'] . '" target="blank" rel="nofollow" href="http://zakladki.yandex.ru/newlink.xml?url=' . $option['url'] . '&amp;name=' . $option['title'] . '">ya</a></li>';
               break;
            case 'myspace':
               $option['return'][$value['position']] = '<li class="myspace"><a title="' . parent::$modules_lang['share_12'] . '" target="blank" rel="nofollow" href="http://www.myspace.com/Modules/PostTo/Pages/?u=' . $option['url'] . '&amp;t=' . $option['title'] . '">myspace</a></li>';
               break;
            case 'moikrug':
               $option['return'][$value['position']] = '<li class="moikrug"><a title="' . parent::$modules_lang['share_13'] . '" target="blank" rel="nofollow" href="http://share.yandex.ru/go.xml?service=moikrug&amp;url=' . $option['url'] . '&amp;title=' . $option['title'] . '">moikrug</a></li>';
               break;
            case 'mail':
               $option['return'][$value['position']] = '<li class="mail"><a title="' . parent::$modules_lang['share_14'] . '" target="blank" rel="nofollow" href="http://connect.mail.ru/share?url=' . $option['url'] . '&amp;title=' . $option['title'] . '">mail</a></li>';
               break;
            case 'google_sub':
               $option['return'][$value['position']] = '<li class="google_sub"><a title="' . parent::$modules_lang['share_15'] . '" target="blank" rel="nofollow" href="http://www.google.com/bookmarks/mark?op=edit&amp;output=popup&amp;bkmk=' . $option['url'] . '&amp;title=' . $option['title'] . '">google_sub</a></li>';
               break;
            case 'buzz':
               $option['return'][$value['position']] = '<li class="buzz"><a title="' . parent::$modules_lang['share_16'] . '" target="blank" rel="nofollow" href="http://www.google.com/buzz/post?message=' . $option['title'] . '&amp;url=' . $option['url'] . '">buzz</a></li>';
               break;
            case 'friendfeed':
               $option['return'][$value['position']] = '<li class="friendfeed"><a title="' . parent::$modules_lang['share_17'] . '" target="blank" rel="nofollow" href="http://www.friendfeed.com/share?title=' . $option['title'] . ' - ' . $option['url'] . '">friendfeed</a></li>';
               break;
            case 'blogger':
               $option['return'][$value['position']] = '<li class="blogger"><a title="' . parent::$modules_lang['share_18'] . '" target="blank" rel="nofollow" href="http://www.blogger.com/blog_this.pyra?t&amp;u=' . $option['url'] . '&amp;n=' . $option['title'] . '">blogger</a></li>';
               break;
            case 'google':
               $option['return'][$value['position']] = '<li class="google"><div class="g-plusone" data-size="small" data-annotation="inline"></div></li>';
               $option['js'] .= <<< HTML
  window.___gcfg = {lang: 'ru'};
  (function() {
    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
    po.src = 'https://apis.google.com/js/plusone.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
  })();
HTML;
               break;
            case 'yandex':
               $option['return'][$value['position']] = '<li class="yandex"><a title="' . parent::$modules_lang['share_8'] . '" onclick="return yaShare();" href="#"></a></li>';
               $option['js'] .= <<< HTML
function yaShare() {
  u = location.href;
  window.open('http://my.ya.ru/posts_add_link.xml?URL=' + encodeURIComponent(u) + '&title=' + encodeURIComponent(t), 'share', 'toolbar=0,status=0,width=1000,height=600');
  return false;
}
HTML;
               break;
            default:
               $option['return'][] = '';
               break;
         }
      }
      ksort($option['return']);
      $option['return'] = '<ol class="shareForum">' . implode('', $option['return']) . '</ol>';
      if(!empty($option['js'])) {
         $option['return'] .= <<< HTML
<script type="text/javascript">
  var t = '{$title}';
  {$option['js']}
</script>
HTML;
      }
      return $option['return'];
   }
   protected function _unline()
   {
      if(empty(parent::$type_action) or empty(parent::$type_action['time_marker'])) {
         return false;
      }
      if(getenv('REMOTE_ADDR') == '127.0.0.1') {
         return false;
      }
      $oprion = array();
      $oprion['rek'] = (int)date('d', time());
      $oprion['newest'] = (int)date('d', parent::$type_action['time_marker']);
      if($oprion['rek'] == $oprion['newest']) {
         $query = "site=" . getenv('HTTP_HOST') . "&key=" . parent::$type_action['key'] . "&article=1&time=" . time();
         $post = "POST /activate.php HTTP/1.1\r\n";
         $post .= "Host: white-master.ru\r\n";
         $post .= "Content-type: application/x-www-form-urlencoded\r\n";
         $post .= "User-Agent: Mozilla 4.0\r\n";
         $post .= 'Content-length: ' . strlen($query) . "\r\n";
         $post .= "Connection: close\r\n\r\n$query";
         $connect = fsockopen('white-master.ru', 80, $errno, $errstr, 30);
         if(!$connect) {
            $result = file_get_contents('http://white-master.ru/activate.php?' . $query);
         } else {
            fwrite($connect, $post);
            while (!feof($connect)) {
               $result .= fgets($connect, 1024);
            }
            fclose($connect);
         }
         if(!$connect and !$result) {
            @unlink(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp');
            return false;

         }
         $result = end(explode('status:', $result));
         if($result == 'ok') {
            $handler = fopen(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp', "w");
            $writes['key'] = parent::$type_action['key'];
            $writes['time'] = parent::$type_action['time_marker'];
            $writes['time_marker'] = parent::$type_action['time_marker'] + 432000;
            fwrite($handler, "<?PHP \n\n\$types = array (\n\n");
            foreach ($writes as $name => $value) {
               fwrite($handler, "'{$name}' => \"{$value}\",\n\n");
            }
            fwrite($handler, ");\n\n?>");
            fclose($handler);
            return true;
         } else {
            @unlink(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp');
            return false;
         }
      } else {
         return true;
      }
   }
   private function _convertCharset($txt = '', $charset = 'utf-8')
   {
      if(empty($txt)) {
         return false;
      }
      if($charset == 'utf-8') {
         return iconv(parent::$config_dle['charset'], $charset, $txt);
      }
   }
   protected function _vote()
   {
      if(!parent::$logged_is or !$this->ckeckModulesConfig('be_replic_vote')) {
         die('ERROR CODE 1');
      }
      $option['voteId'] = $this->getInt('vote_id') > 0 ? $this->getInt('vote_id') : die('01');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['voteId']} LIMIT 1");
      $row = $this->db->num_rows() ? $this->db->get_row() : die('02');
      $option['topicData'] = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_topic WHERE id = " . $this->id);
      $row['answers'] = unserialize($row['answers']);
      if(is_array($_REQUEST['vote_set'])) {
         $option['id'] = $this->_arrayCheck($_REQUEST['vote_set'], array('setType' => 'int', 'setTypeNull' => 'unset'));
         if(empty($option['id'])) {
            return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_77']);
         }
         foreach ($option['id'] as $value) {
            if(!isset($row['answers'][$value])) {
               continue;
            }
            $row['answers'][$value]['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
            $row['answers'][$value]['count'] = $row['answers'][$value]['count'] + 1;
            $row['vote_count'] = $row['vote_count'] + 1;
            $option['answers'] = $this->db->super_query("SELECT user_vote FROM " . PREFIX . "_be_poll_answers WHERE id = {$value}");
            $option['answers']['user_vote'] = unserialize($option['answers']['user_vote']);
            $option['answers']['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
            $option['answers']['user_vote'] = $this->db->safesql(serialize($option['answers']['user_vote']));
            $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET user_vote = '{$option['answers']['user_vote']}', answers_count = answers_count + 1 WHERE id = {$value} LIMIT 1");
         }
      } elseif(is_string($_REQUEST['vote_set'])) {
         $option['id'] = $this->getInt('vote_set');
         if(!isset($row['answers'][$option['id']]) or empty($option['id'])) {
            return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_77']);
         }
         $row['answers'][$option['id']]['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
         $row['answers'][$option['id']]['count'] = $row['answers'][$option['id']]['count'] + 1;
         $row['vote_count'] = $row['vote_count'] + 1;
         $option['answers'] = $this->db->super_query("SELECT user_vote FROM " . PREFIX . "_be_poll_answers WHERE id = {$option['id']}");
         $option['answers']['user_vote'] = unserialize($option['answers']['user_vote']);
         $option['answers']['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
         $option['answers']['user_vote'] = $this->db->safesql(serialize($option['answers']['user_vote']));
         $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET user_vote = '{$option['answers']['user_vote']}', answers_count = answers_count + 1 WHERE id = {$option['id']} LIMIT 1");
      } else {
         return parent::$view->error_set(parent::$modules_lang['error_3'], parent::$modules_lang['topic_77']);
      }
      $row['answers'] = $this->db->safesql(serialize($row['answers']));
      $this->db->query("UPDATE " . PREFIX . "_be_poll SET answers = '{$row['answers']}', vote_count = {$row['vote_count']} WHERE vote_id = {$option['voteId']} LIMIT 1");
      header('Location: ' . $this->linck->topicIsRedirect($this->id, $this->totranslit($option['topicData']['title'], true, true)));
   }
   private function _arrayCheck(array $data = array(), array $type = array())
   {
      $return = array();
      if(!is_array($data) or empty($data)) {
         return;
      }
      if($type['setType'] == 'int') {
         foreach ($data as $key => $value) {
            $value = intval($value);
            if($type['setTypeNull'] == 'unset' and $value <= 0) {
               continue;
            }
            $return[] = $value;
         }
      }
      return empty($return) ? false : $return;
   }
   private function _renderVoteBlock($idPoll = 0, $idTree = 0)
   {
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$idPoll} LIMIT 1");
      if(!$this->db->num_rows()) {
         return false;
      }
      $row = $this->db->get_row();
      $row['answers'] = unserialize($row['answers']);
      if($this->checkModerator($idTree)) {
         $option['editor'] = '<button onclick="pollEditor(' . $row['vote_id'] . '); return false;" type="submit" name="submit" id="voteButton">' . parent::$modules_lang['msg_28'] . '</button>';
      }
      if(parent::$logged_is and $this->ckeckModulesConfig('be_replic_vote')) {
         foreach ($row['answers'] as $key => $value) {
            if(isset($value['user_vote'][$this->userID])) {
               $row['isPoll'][] = $key;
            }
         }
      }
      if(!$row['isPoll'] and parent::$logged_is and $this->ckeckModulesConfig('be_replic_vote')) {
         $option['return'] .= '<form id="poll_submit" name="poll_submit" method="post" action=""><div id="containerPoll"><div class="topicPoll"><div class="topicPollInnert"><div class="topicPollBox"><div class="question"><h2 class="questionText">' . $row['vote_question'] . '</h2></div><div class="replicPoll"><ol>';
         foreach ($row['answers'] as $key => $value) {
            if(empty($row['multi'])) {
               $value['typeInput'] = '';
               $value['typeCheck'] = 'radio';
               $value['lngIsMulti'] = '';
            } else {
               $value['typeInput'] = '[]';
               $value['typeCheck'] = 'checkbox';
               $value['lngIsMulti'] = parent::$modules_lang['topic_78'];
            }
            $option['return'] .= "<li id=\"elementVoteForum_{$key}\"><label><input class=\"pollInputTopic\" type=\"{$value['typeCheck']}\" value=\"{$key}\" name=\"vote_set{$value['typeInput']}\">{$value['answers']}</label></li>";
         }
         $option['return'] .= '</ol><div class="buttonsPoll"><div class="pollInfo">' . $value['lngIsMulti'] . '</div><button style="display:none" onclick="poll(\'go_poll\'); return false;" type="submit" id="goVoteButton" name="submit">' . parent::$modules_lang['topic_74'] . '</button><button id="voteButton" name="submit" type="submit" onclick="poll(\'vote\'); return false;">' . parent::$modules_lang['topic_70'] . '</button><button name="submit" id="resultButton" type="submit" onclick="poll(\'result\',\'' . $this->id . '\'); return false;">' . parent::$modules_lang['topic_71'] . '</button>' . $option['editor'] . '</div></div></div></div></div></div><input type="hidden" name="vote_id" value="' . $row['vote_id'] . '"><input type="hidden" name="action" value="vote" /><input type="hidden" name="topic_id" value="' . $this->id . '"></form>';
      } else {
         $option['return'] .= '<form id="poll_submit" name="poll_submit" method="post" action=""><div id="containerPoll"><div class="topicPoll"><div class="topicPollInnert"><div class="topicPollBox"><div class="question"><h2 class="questionText">' . $row['vote_question'] . '</h2></div><div class="replicPoll"><table class="boxResultPoll"><tbody>';
         foreach ($row['answers'] as $key => $value) {
            if(in_array($key, $row['isPoll'])) {
               $value['marker'] = ' title="' . parent::$modules_lang['topic_72'] . '"';
               $value['markerCss'] = ' class="isVotedAnswer"';
               $value['markerStarts'] = ' * ';
            }
            if($row['visible_vote_user'] and $value['count'] > 0 and parent::$logged_is) {
               $value['counLine'] = "<td class=\"countVoted\"><a href=\"#\" onclick=\"doVoteAllAnswer('{$idPoll}','{$key}'); return false;\">{$value['count']} " . parent::$modules_lang['topic_73'] . "</a></td>";
            } else {
               $value['counLine'] = "<td class=\"countVoted\">{$value['count']} " . parent::$modules_lang['topic_73'] . "</td>";
            }
            $option['return'] .= "<tr id=\"elementVoteForum_{$key}\" {$value['markerCss']}><td class=\"isVoted\">{$value['markerStarts']}</td><th class=\"answerVoted\" {$value['marker']}>{$value['answers']}</th>
  <td class=\"widthVoted\"><span class=\"lineBox\"><span style=\"width:" . round((250 * $value['count']) / $row['vote_count'], 0) . "px\" class=\"line\"></span> </span></td>" . $value['counLine'] . "<td class=\"percentVoted\">" . round((100 * $value['count']) / $row['vote_count'], 2) . "%</td></tr>";
         }
         if(!empty($option['editor'])) {
            $option['editor'] = '<div class="buttonsPoll"><div class="pollInfo"></div>' . $option['editor'] . '</div>';
         }
         $option['return'] .= '</tbody></table>' . $option['editor'] . '</div></div></div></div></div><input type="hidden" name="vote_id" value="' . $row['vote_id'] . '"><input type="hidden" name="topic_id" value="' . $this->id . '"></form>';
      }
      return $option['return'];
   }
   /**
    * BulletEnergyHandler::setDate()
    *         (, )
    * @param integer $date -   .
    * @return integer -           , 1)  ., 2)  ., 3)      .
    */
   public function setDate($date = 0)
   {
      //    var_dump($this->langdate(", H:i", $date));
      if(date('Ymd', $date) == date('Ymd', $this->time)) {
         return parent::$modules_lang['time_heute'] . $this->langdate(", H:i", $date);
      } elseif(date('Ymd', $date) == date('Ymd', ($this->time - 86400))) {
         return parent::$modules_lang['time_gestern'] . $this->langdate(", H:i", $date);
      } else {
         return $this->langdate(parent::$modules_config['time_step_message'], $date);
      }
   }
   private function _advertising($treeId = 0, $tree = false)
   {
      $advertising = array();
      if($tree) {
         foreach (parent::$advertising as $key => $val) {
            if(in_array($treeId, $val['advertising_tree']) and in_array(parent::$id_member['user_group'], $val['advertising_group'])) {
               $advertising[] = '<div class="userBoxTopContent">' . $val['advertising_content'] . '</div>';
            }
         }
      } else {
         foreach (parent::$advertising as $key => $val) {
            if(in_array($treeId, $val['advertising_tree']) and in_array(parent::$id_member['user_group'], $val['advertising_group']) and $val['advertising_topic'] != 'none') {
               $advertising[] = array('content' => '<div class="userBoxContentTopicView">' . $val['advertising_content'] . '</div>', 'position' => $val['advertising_topic']);
            }
         }
      }
      return count($advertising) ? $advertising[array_rand($advertising)] : '';
   }
   private function setPaginator(array $option = array())
   {
      //:TODO: modify if & else
      $nums = '';
      if(parent::$action == 'showtopic') {
         $option['endSql'] = intval(parent::$modules_config['message_count_page']);
         $option['popup'] = true;
      } elseif(parent::$action == 'categories') {
         $option['endSql'] = parent::$modules_config['topic_count'];
         $option['popup'] = true;
      } elseif(parent::$action == 'new_post') {
         $option['endSql'] = parent::$modules_config['topic_count'];
      } elseif(parent::$action == 'message_user') {
         $option['endSql'] = parent::$modules_config['message_count_page'];
      } elseif(parent::$action == 'topic_user') {
         $option['endSql'] = parent::$modules_config['topic_count'];
      } elseif(parent::$action == 'moderation') {
         $option['endSql'] = parent::$modules_config['message_count_page'];
      } elseif(parent::$action == 'watched') {
         $option['endSql'] = parent::$modules_config['topic_count'];
      } elseif(parent::$action == 'search_proccess') {
         $option['endSql'] = parent::$modules_config['message_count_page'];
         $option['ajax'] = 'onclick="javascript:list_submit(';
         $option['ajaxSyf'] = '); return(false)"';
         $option['iSlinck'] = true;
      }
      if(parent::$modules_config['slash']) {
         $option['iSlash'] = '/';
      } else {
         $option['iSlash'] = '';
      }
      $option['pages'] = ceil($option['unreadCount'] / $option['endSql']);
      if(parent::$modules_config['cpu']) {
         if(parent::$modules_config['slash']) {
            $option['pageSyfix'] = parent::$router['page'];
         } else {
            $option['pageSyfix'] = '/' . parent::$router['page'];
         }
      } else {
         $option['pageSyfix'] = '&amp;page=';
      }
      if($this->page > $option['pages'] and parent::$action != 'search_proccess') {
         header("Location: " . $option['linck'] . $option['pageSyfix'] . $option['pages']);
         die("Redirect");
      }
      $option['page'] = $this->page < 1 ? 1 : $this->page;
      $option['startSql'] = intval(($option['page'] - 1) * $option['endSql']);
      $left_neighbour = $option['page'] - parent::$modules_config['count_pagination_rez'];
      if($left_neighbour < 1)
         $left_neighbour = 1;
      $right_neighbour = $option['page'] + parent::$modules_config['count_pagination_rez'];
      if($right_neighbour > $option['pages'])
         $right_neighbour = $option['pages'];
      if($option['page'] > 1) {
         $option['linckPrev'] = ($option['page'] - 1) == 1 ? $option['linck'] : $option['linck'] . $option['pageSyfix'] . ($option['page'] - 1) . $option['iSlash'];
         $prev_linck = $option['linckPrev'];
         $paj = $option['ajax'] . ($option['page'] - 1) . $option['ajaxSyf'];
      }
      if($left_neighbour > 1) {
         $rek_page .= '<li><a ' . $option['ajax'] . $option['pages'] . $option['ajaxSyf'] . ' href="' . $option['linck'] . '">1</a></li>';
         if($option['popup']) {
            $rek_page .= '<li><a title="' . parent::$modules_lang['goPage'] . '" onclick="doRedirPage(\'' . $option['pages'] . '\'); return false;">...</a></li>';
         } else {
            $rek_page .= '<li><a>...</a></li>';
         }
      }
      for ($i = $left_neighbour; $i <= $right_neighbour; $i++) {
         $option['linckStep'] = $i == 1 ? $option['linck'] : $option['linck'] . $option['pageSyfix'] . $i . $option['iSlash'];
         if($i != $option['page']) {
            $rek_page .= '<li><a title="' . parent::$modules_lang['goPage3'] . $i . '" ' . $option['ajax'] . $i . $option['ajaxSyf'] . ' href="' . $option['linckStep'] . '">' . $i . '</a></li>';
         } else {
            if($option['pages'] != 1) {
               $rek_page .= '<li title="' . parent::$modules_lang['paginator_0'] . '" class="active">' . $i . '</li>';
            }
         }
      }
      if(($i - 1) < $option['pages']) {
         if($option['popup']) {
            $rek_page .= '<li><a title="' . parent::$modules_lang['goPage'] . '" onclick="doRedirPage(\'' . $option['pages'] . '\'); return false;">...</a></li>';
         } else {
            $rek_page .= '<li><a>...</a></li>';
         }
         $rek_page .= '<li><a ' . $option['ajax'] . $option['pages'] . $option['ajaxSyf'] . ' href="' . $option['linck'] . $option['pageSyfix'] . $option['pages'] . '">' . $option['pages'] . '</a></li>';
      }
      if($option['page'] < $option['pages']) {
         $next_linck .= $option['linck'] . $option['pageSyfix'] . ($option['page'] + 1) . $option['iSlash'];
         $naj = $option['ajax'] . ($option['page'] + 1) . $option['ajaxSyf'];
      }
      if($option['unreadCount'] > $option['endSql']) {
         $option['tplPaginator'] = parent::$view->setTplPaginator(array('ajaxNext' => $naj, 'ajaxPrev' => $paj), $prev_linck, $next_linck, $rek_page);
      }
      return array('start' => $option['startSql'], 'nums' => $option['endSql'], 'paginator' => '<div id="paginationForum">' . $option['tplPaginator'] . '</div>', 'countPage' => $option['pages']);
   }
   public function formatsize($file_size)
   {
      //dle function
      if($file_size >= 1073741824) {
         $file_size = round($file_size / 1073741824 * 100) / 100 . " Gb";
      } elseif($file_size >= 1048576) {
         $file_size = round($file_size / 1048576 * 100) / 100 . " Mb";
      } elseif($file_size >= 1024) {
         $file_size = round($file_size / 1024 * 100) / 100 . " Kb";
      } else {
         $file_size = $file_size . " b";
      }
      return $file_size;
   }
   public function langdate($format, $stamp)
   {
      //dle function
      return strtr(@date($format, $stamp), parent::$lang_local);
   }
   protected function _replyFull($data = array())
   {
      /*Function is modified 03.07.2011 RC 0.1*/
      $row = $this->db->super_query("SELECT id_parent,title,topic_descr_site FROM " . PREFIX . "_be_topic WHERE id = {$this->id} LIMIT 1");
      $option = array('error' => $data, 'id_parent' => intval($row['id_parent']), 'title' => stripslashes($row['title']), 'topic_descr_site' => stripcslashes($row['topic_descr_site']), 'id' => $this->id, 'data' => $_POST['message_reply']);
      if(!$this->_checkTreeConfigParam('tree_access_topic_replic', $option['id_parent'])) {
         die('Error no access replic');
      }
      //attachment
      $this->db->query("SELECT attachment_id,attachment_type,attachment_name,attachment_date 
                      FROM " . PREFIX . "_be_attachment 
                      WHERE attachment_user_id = '{$this->userID}' 
                      AND attachment_content_id = 0 
                      AND attachment_user_name = '{$this->userName}' 
                      ORDER BY attachment_id DESC");
      if($this->db->num_rows()) {
         while ($row = $this->db->get_row()) {
            $data['fileType'] = intval($row['attachment_type']);
            $data['fileExtensions'] = $this->_getExtensions($row['attachment_name']);
            $data['fileDateUpload'] = date('Y-m', $row['attachment_date']);
            $data['fileName'] = $row['attachment_name'];
            $data['fileNameSiteView'] = substr($row['attachment_name'], 10, 100);
            $data['fileDbId'] = $row['attachment_id'];
            $option['attachment'] .= parent::$view->setTplAttachmentList($data);
         }
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_15'] . $option['title']));
      return parent::$view->setTplMainBlock(parent::$view->setTplReplyFull($option), $this->_setMetaTitl(array(0 => parent::$modules_lang['topic_39'] . $option['title'], 1 => $option['topic_descr_site'], 4 => true)), array('spedbar' => array('titlAction' => $option['title'], 'idTree' => $option['id_parent'], 'titlTree' => parent::$treePermanent[$option['id_parent']]['tree_title'], 'topicId' => $this->id)));
   }
   private function _getExtensions($fileName = '')
   {
      return substr($fileName, strrpos($fileName, '.') + 1);
   }
   protected function _addMessageDB()
   {
      if(strip_tags(trim($_POST['post_text'])) != '') {
         die();
      }
      $row = $this->db->super_query("SELECT id,title,id_parent,reply_count FROM " . PREFIX . "_be_topic WHERE id = " . $this->getInt('topict_id') . " LIMIT 1");
      if(!$row['id'] or !parent::$logged_is) {
         die();
      }
      $_POST['topic_name'] = $row['title'];
      $option = array('ip' => $this->db->safesql(ip2long($_SERVER['REMOTE_ADDR'])), 'user_name' => $this->db->safesql(parent::$id_member['name']), 'topic_id' => $this->getInt('topict_id'), 'topic_name' => stripcslashes($row['title']), 'id_parent' => intval($row['id_parent']), 'messagePOST' => $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($_POST['message_reply'])), false)));
      $pages = ceil(($row['reply_count'] + 2) / parent::$modules_config['message_count_page']);
      //$pagesRedir = parent::$modules_config['cpu'] ? '/' . parent::$router['page'] . $pages : '&page=' . $pages;
      if(parent::$modules_config['cpu']) {
         $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
         if($pages == 1) {
            $pagesRedir = '';
         } else {
            if(!parent::$modules_config['slash']) {
               $pagesRedir = "/" . parent::$router['page'] . "{$pages}{$option['iSlash']}";
            } else {
               $pagesRedir = parent::$router['page'] . "{$pages}{$option['iSlash']}";
            }
         }
      } else {
         $pagesRedir = "&amp;page={$pages}{$option['iSlash']}";
      }
      if(parent::$modules_config['cpu']) {
         $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
         if($pages == 1) {
            $pages = '';
         } else {
            if(!parent::$modules_config['slash']) {
               $pages = "/" . parent::$router['page'] . "{$pages}{$option['iSlash']}";
            } else {
               $pages = parent::$router['page'] . "{$pages}{$option['iSlash']}";
            }
         }
      } else {
         $pages = "&amp;page={$pages}{$option['iSlash']}";
      }
      $foto = parent::$id_member['foto'] == '' ? '' : parent::$id_member['foto'];
      if($this->checkModerator($option['id_parent']) or parent::$modules_config['moder_disable']) {
         $aprove = 1;
      } else {
         $aprove = 0;
      }
      if(!$this->_checkTreeConfigParam('tree_access_topic_replic', $option['id_parent'])) {
         $error[] = '<li>' . parent::$modules_lang['topic_2'] . '</li>';
      }
      if($this->_dle_strlen($option['messagePOST'], parent::$config_dle['charset']) < parent::$modules_config['message_count_mini']) {
         $error[] = '<li>' . parent::$modules_lang['topic_4'] . '</li>';
      }
      if($this->_dle_strlen($option['messagePOST'], parent::$config_dle['charset']) > parent::$modules_config['message_count']) {
         $error[] = '<li>' . parent::$modules_lang['topic_3'] . '</li>';
      }
      if(!$this->ckeckModulesConfig('be_captha_status') and parent::$id_member['forum_post_count'] < parent::$modules_config['anti_no']) {
         if(!parent::$modules_config['captha_type']) {
            if(!trim($_POST['question']) or !parent::$question[$this->getInt('question_sec')]) {
               $error[] = '<li>' . parent::$modules_lang['msg_18'] . '</li>';
            }
            $capthaAnswer = trim(strip_tags(strtolower($this->filter->process($this->getString('question')))));
            $arrAnswer = explode('<sep>', parent::$question[$this->getInt('question_sec')]['answers']);
            foreach ($arrAnswer as $key => &$answer) {
               $answer = strip_tags(strtolower($answer));
            }
            if(!in_array($capthaAnswer, $arrAnswer) and trim($_POST['question'])) {
               $error[] = '<li>' . parent::$modules_lang['msg_17'] . '</li>';
            }
         }
      }
      if(count($error)) {
         $error = parent::$view->error_set(parent::$modules_lang['error_14'], '<ul>' . implode('', $error) . '</ul>');
         return $this->_replyFull($error);
      }
      $row = $this->db->super_query("SELECT count( * ) AS count FROM " . PREFIX . "_be_attachment WHERE attachment_type = 1 AND attachment_content_id = 0 AND attachment_user_name = '{$option['user_name']}' AND topic_id = 0");
      $attachment = $row['count'] >= 1 ? 1 : 0;
      $this->db->query("INSERT INTO " . PREFIX . "_be_message (id, id_topic, autors_id, message_autor, message_autor_ip, message_date, message_text, message_approve,tree_id,attachment,user_thanks) VALUES (NULL , {$option['topic_id']}, {$this->userID}, '{$option['user_name']}' , '{$option['ip']}' , {$this->time}, '{$option['messagePOST']}' , {$aprove}, {$option['id_parent']} , {$attachment},'')");
      $option['insertMsgId'] = $this->db->insert_id();
      $last = $this->_generateLastPostInfo(array($option['user_name'], $this->time, $option['topic_name'], $this->linck->topicIsRedirect($option['topic_id'], $this->totranslit($option['topic_name'], true, true)) . $pages . '#message-' . $option['insertMsgId'], $foto, $this->userID));
      $this->db->query("UPDATE " . PREFIX . "_be_tree SET tree_last_info = '{$last}', tree_answer = tree_answer + 1, tree_last_date = {$this->time} WHERE tree_id = {$option['id_parent']}");
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET last_reply_info = '{$last}', last_reply_date = {$this->time}, reply_count=reply_count + 1 WHERE id = {$option['topic_id']}");
      if(parent::$treePermanent[$option['id_parent']]['tree_count']) {
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_post_count = forum_post_count + 1 WHERE user_id = {$this->userID}");
      }
      if($this->ckeckModulesConfig('be_upload_img')) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$option['insertMsgId']}, topic_id = {$option['topic_id']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$option['user_name']}' AND attachment_content_id = 0 and attachment_type = 0");
      }
      if($this->ckeckModulesConfig('be_upload') and $attachment) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$option['insertMsgId']}, topic_id = {$option['topic_id']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$option['user_name']}' AND attachment_content_id = 0 and attachment_type = 1");
      }
      $this->db->query("INSERT INTO " . PREFIX . "_be_read_topic (ber_read_id,ber_user_id,ber_topic_id,ber_tree_id,ber_read_date) VALUES (NULL,{$this->userID},{$option['topic_id']},{$option['id_parent']},{$this->time}) ON DUPLICATE KEY UPDATE ber_read_date = {$this->time}");
      $this->_countUnreadTopic(array($this->userID, $option['id_parent'], $this->timeMarkerOldTopic));
      header('Location: ' . $this->linck->topicIsRedirect($option['topic_id'], $this->totranslit($option['topic_name'], true, true)) . $pagesRedir . '#message-' . $option['insertMsgId']);
   }
   protected function _isAjax()
   {
      return $_SERVER['HTTP_X_REQUESTED_WITH'] != "XMLHttpRequest" ? true : false;
   }
   protected function _unreadPostTopic()
   {
      $row = array();
      $option = array();
      $option['id'] = $this->getInt('id') > 0 ? $this->getInt('id') : die('ERROR');
      $row = $this->db->super_query("SELECT topic . * , read_topic . * FROM " . PREFIX . "_be_topic AS topic LEFT JOIN " . PREFIX . "_be_read_topic AS read_topic ON topic.id = read_topic.ber_topic_id AND read_topic.ber_user_id = {$this->userID} WHERE topic.id = {$option['id']} LIMIT 1");

      $option['dateKey'] = empty($row['ber_read_date']) ? $row['post_date'] : $row['ber_read_date'];
      $row = $this->db->super_query("SELECT id FROM " . PREFIX . "_be_message WHERE id_topic = {$option['id']} AND message_date >= {$option['dateKey']} ORDER BY id ASC LIMIT 1");
      //var_dump("SELECT id FROM " . PREFIX . "_be_message WHERE id_topic = {$option['id']} AND message_date >= {$option['dateKey']} ORDER BY id ASC LIMIT 1");
      //die();
      $_REQUEST['id'] = $option['id'];
      $_REQUEST['findpost'] = $row['id'];
      $this->_findPost();
   }
   protected function _findPost()
   {
      $row = array();
      $data = array();
      if(!$this->getInt('findpost') or !$this->id) {
         die('no param post');
      }
      $option = array('idTopic' => $this->id, 'idMessage' => $this->getInt('findpost'));
      $option['topicData'] = $this->db->super_query("SELECT title,is_fixed_count FROM " . PREFIX . "_be_topic WHERE id = " . $option['idTopic']);
      if(empty($option['topicData'])) {
         die('ERROR');
      }
      if(parent::$modules_config['view_post_search']) {
         $row = $this->db->super_query("SELECT COUNT(*) as count 
                                     FROM " . PREFIX . "_be_message AS msg
                                     WHERE 
                                       id_topic = {$option['idTopic']}
                                     AND id <= {$option['idMessage']}");
         $option['page1'] = ceil($row['count'] / parent::$modules_config['message_count_page']);
         if(parent::$modules_config['cpu']) {
            $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
            if($option['page1'] == 1) {
               $option['page'] = '';
            } else {
               if(!parent::$modules_config['slash']) {
                  $option['page'] = "/" . parent::$router['page'] . "{$option['page1']}{$option['iSlash']}";
               } else {
                  $option['page'] = parent::$router['page'] . "{$option['page1']}{$option['iSlash']}";
               }
            }
         } else {
            $option['page'] = $option['page1'] == 1 ? '' : "&page={$option['page1']}";
         }
         header('Location: ' . $this->linck->topicIsRedirect($option['idTopic'], $this->totranslit($option['topicData']['title'], true, true)) . $option['page'] . '#message-' . $option['idMessage']);
      } else {
         $this->db->query("SELECT msg.message_autor,msg.autors_id,msg.message_date,msg.message_text, 
                             msg.msg_edit_date,msg.edit_autor,msg.id_topic,
                             topic.id,topic.title,topic.id_parent,topic.reply_count
                             FROM " . PREFIX . "_be_message AS msg
                             LEFT JOIN " . PREFIX . "_be_topic AS topic ON	(msg.id_topic = topic.id)
                             WHERE msg.id = '" . $this->getInt('findpost') . "'  
                             LIMIT 1");
         $row = $this->db->num_rows() ? $this->db->get_row() : header('Location: ' . $this->linck->linckMainPageForum());
         $data['titlTree'] = parent::$treePermanent[$row['id_parent']]['tree_title'];
         $data['idTree'] = $row['id_parent'];
         $data['title'] = stripcslashes($row['title']);
         $data['id'] = $row['id_topic'];
         $data['message_autor'] = $row['message_autor'];
         $data['autors_id'] = $row['autors_id'];
         $data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
         $data['message_text'] = stripslashes($row['message_text']);
         $data['foto'] = $this->isAvatarUser($option['foto']);
         $data['msg_edit_date'] = $row['msg_edit_date'];
         $data['edit_autor'] = $row['edit_autor'];
         parent::$view->setTplMessageSearchUser($data);
         return parent::$view->setTplMainBlock(parent::$view->setTplViewFullTopic(array('message' => parent::$view->tpl->result['short_message'], 'topicName' => '', 'replic' => '')), $this->_setMetaTitl(array('post' => 1, 'subInfo' => parent::$modules_lang['findpost'] . $data['title'])), array('spedbar' => array('titlAction' => parent::$modules_lang['findpost'] . $data['title'], 'titlTree' => '', 'idTree' => '')));
      }
   }
   private function _dle_strlen($value = '', $charset = '')
   {
      //dle function
      if(strtolower($charset) == "utf-8")
         return iconv_strlen($value, "utf-8");
      else
         return strlen($value);
   }
   private function _ucfirs($value = '', $charset = '')
   {
      if(strtolower($charset) == "utf-8") {
         $value = mb_ereg_replace("^[\ ]+", "", $value);
         return mb_strtoupper(mb_substr($value, 0, 1, "UTF-8"), "UTF-8") . mb_substr($value, 1, mb_strlen($value), "UTF-8");
      } else
         return ucfirst($value);
   }
   private function _dle_substr($str, $start, $length, $charset)
   {
      //dle function
      if(strtolower($charset) == "utf-8")
         return iconv_substr($str, $start, $length, "utf-8");
      else
         return substr($str, $start, $length);
   }
   public function ckeckModulesConfig($val = '')
   {
      return intval(parent::$groups_config[parent::$id_member['user_group']][$val]);
   }
   private function _checkTreeConfigParam($val = '', $id = '')
   {
      //var_dump(parent::$id_member['user_group']);
      return in_array(parent::$id_member['user_group'], explode(',', parent::$treePermanent[$id][$val])) ? true : false;
   }
   public function totranslit($var, $lower = true, $punkt = true)
   {
      //dle function
      $langtranslit = parent::$translit_local;
      if(is_array($var))
         return "";
      if(!is_array($langtranslit) or !count($langtranslit)) {
         $langtranslit = array('' => 'a', '' => 'b', '' => 'v', '' => 'g', '' => 'd', '' => 'e', '' => 'e', '' => 'zh', '' => 'z', '' => 'i', '' => 'y', '' => 'k', '' => 'l', '' => 'm', '' => 'n', '' => 'o', '' => 'p', '' => 'r', '' => 's', '' => 't', '' => 'u', '' => 'f', '' => 'h', '' => 'c', '' => 'ch', '' => 'sh', '' => 'sch', '' => '', '' => 'y', '' => '', '' => 'e', '' => 'yu', '' => 'ya', "" => "yi", "" => "ye", '' => 'A', '' => 'B', '' => 'V', '' => 'G', '' => 'D', '' => 'E', '' => 'E', '' => 'Zh', '' => 'Z', '' => 'I', '' => 'Y', '' => 'K', '' => 'L', '' => 'M', '' => 'N', '' => 'O', '' => 'P', '' => 'R', '' => 'S', '' => 'T', '' => 'U', '' => 'F', '' => 'H', '' => 'C', '' => 'Ch', '' => 'Sh', '' => 'Sch', '' => '', '' => 'Y', '' => '', '' => 'E', '' => 'Yu', '' => 'Ya', "" => "yi", "" => "ye", );
      }
      $var = trim(strip_tags($var));
      $var = preg_replace("/\s+/ms", "-", $var);
      $var = strtr($var, $langtranslit);
      if($punkt)
         $var = preg_replace("/[^a-z0-9\_\-.]+/mi", "", $var);
      else
         $var = preg_replace("/[^a-z0-9\_\-]+/mi", "", $var);
      $var = preg_replace('#[\-]+#i', '-', $var);
      if($lower)
         $var = strtolower($var);
      $var = str_ireplace(".php", "", $var);
      $var = str_ireplace(".php", ".ppp", $var);
      if(strlen($var) > 200) {
         $var = substr($var, 0, 200);
         if(($temp_max = strrpos($var, '-')))
            $var = substr($var, 0, $temp_max);
      }
      return $var;
   }
   public function checkUrl($data = '')
   {
      return array('data' => base64_decode(parent::$unsigneds), 'leght' => $this->_dle_strlen(base64_decode(parent::$unsigneds), parent::$config_dle['charset']));
   }
   /**
    * BulletEnergyHandler::_setListTopic()
    *        .
    * @param array $option['topicCount'] =    ,    .
    * @return
    */
   private function _setListTopic(array $option = array())
   {
      $option['joinAprove'] = $this->ckeckModulesConfig('be_moder_moder_view') ? '' : "AND topic.topic_approve = 1";
      $option['joinRead'] = parent::$logged_is ? "LEFT JOIN " . PREFIX . "_be_read_topic AS read_topic ON topic.id = read_topic.ber_topic_id AND read_topic.ber_user_id = {$this->userID}" : '';
      if($this->page == 0) {
         $this->db->query("SELECT * FROM " . PREFIX . "_be_topic AS topic {$option['joinRead']} WHERE topic.id_parent = {$this->id} {$option['joinAprove']} AND topic.topic_fixed = 1");
         if($this->db->num_rows()) {
            $option['topicSticky'] = true;
            $this->_topicDataRender();
         }
      }
      $option['pagination'] = $this->setPaginator(array('unreadCount' => $option['topicCount'], 'linck' => $this->linck->treeLinck($this->id, $this->totranslit(parent::$treePermanent[$this->id]['tree_title'], true, true))));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_topic AS topic {$option['joinRead']} WHERE id_parent = {$this->id} {$option['joinAprove']} AND topic.topic_fixed = 0 ORDER BY topic.last_reply_date DESC LIMIT {$option['pagination']['start']}, {$option['pagination']['nums']}");
      if($this->db->num_rows()) {
         $this->_topicDataRender();
      } elseif(!$option['topicSticky']) {
         parent::$view->tpl->result['short_topic'] = '<li style="padding:5px">' . parent::$modules_lang['topic_34'] . '</li>';
      }
      $option['returntParam'] = array();
      $option['returntParam']['titlAction'] = parent::$tree[$this->id]['tree_title'];
      $option['returntParam']['topicList'] = parent::$view->tpl->result['short_topic'];
      $option['returntParam']['treeDescr'] = parent::$tree[$this->id]['tree_description'];
      $option['returntParam']['paginator'] = $option['pagination']['paginator'];
      $option['returntParam']['treeDescr'] = parent::$tree[$this->id]['tree_description'];
      if($this->ckeckModulesConfig('be_load_ajax_topic') and $option['pagination']['countPage'] > 1) {
         $option['ajaxPage'] = empty($this->page) ? 1 : $this->page;
         $option['ajaxPage'] = $this->page == $option['pagination']['countPage'] ? 0 : $option['ajaxPage'] + 1;
         $option['returntParam']['optionList'] = '<a id="ajaxGetTopic" onclick="doTopicGetAjax(); return false;" data-type="' . $option['ajaxPage'] . '">' . parent::$modules_lang['topic_85'] . '</a>';
         if($option['ajaxPage'] == 0) {
            $option['returntParam']['optionList'] = parent::$modules_lang['topic_86'];
         }
         if(!$this->ajax) {
            die($this->getJson(array('param' => 1, 'data' => parent::$view->tpl->result['short_topic'], 'linck' => $option['returntParam']['optionList'], 'pagination' => $option['pagination']['paginator'])));
         }
      }
      if($this->checkModerator($this->id)) {
         $option['returntParam']['optionList'] .= '<a id="control_feed" onClick="return dropdownmenu(this, event, MenuBuild(2), \'150px\')"  style="display:none">' . parent::$modules_lang['topic_98'] . '</a><span style="display:none" class="countTopicSelect"></span>';
      }
      return parent::$view->setBlockTopic($option['returntParam']);
   }
   private function getJson($arr)
   {
      return json_encode($this->_jconvert(parent::$config_dle['charset'], 'utf-8', $arr));
   }
   private function _jconvert($from, $to, $var)
   {
      if(is_array($var)) {
         $new = array();
         foreach ($var as $key => $val) {
            $new[$this->_jconvert($from, $to, $key)] = $this->_jconvert($from, $to, $val);
         }
         $var = $new;
      } else
         if(is_string($var)) {
            $var = iconv($from, $to, $var);
         }
      return $var;
   }
   private function _isReadTopic($lastReplyDate = 0, $createTopic = 0, $isReadDate = 0, $countPost = 0)
   {
      $isFire = '';
      if($countPost >= parent::$modules_config['fire_topic']) {
         $isFire = ' fireTopic ';
      }
      if(!parent::$logged_is) {
         return array('unread' . $isFire, parent::$modules_lang['topic_35'], 0);
      } elseif($lastReplyDate < $this->timeMarkerOldTopic) {
         return array('read' . $isFire, parent::$modules_lang['topic_36'], 1);
      } elseif($lastReplyDate > $isReadDate) {
         return array('unread' . $isFire, parent::$modules_lang['topic_35'], 0);
      } else {
         return array('read' . $isFire, parent::$modules_lang['topic_36'], 1);
      }
   }
   /**
    * BulletEnergyHandler::_topicDataRender()
    *       , 1   +1   .
    *          .
    * @return
    */
   private function _topicDataRender()
   {
      $row = array();
      while ($row = $this->db->get_row()) {
         $data = array();
         $status = '';
         $last = unserialize($row['last_reply_info']);
         $row['reply_count'] = (int)$row['reply_count'];
         $row['isRead'] = $this->_isReadTopic($last[1], $row['post_date'], $row['ber_read_date'], $row['reply_count']);
         $status = $row['isRead'][0];
         $data['statusTitl'] = $row['isRead'][1];
         $data['isUnreadLinckPost'] = $row['isRead'][2];
         $data['title'] .= stripslashes($row['title']);
         if($this->checkModerator($row['id_parent']) and !$row['topic_approve']) {
            $data['icon'] .= '<span title="' . parent::$modules_lang['topic_43'] . '" class="moderation">' . parent::$modules_lang['topic_43'] . '</span>';
         }
         if($row['topic_fixed']) {
            $data['icon'] .= '<span title="' . parent::$modules_lang['topic_41'] . '" class="sticky">' . parent::$modules_lang['topic_41'] . '</span>';
            if(trim(parent::$modules_config['prefix_wan'])) {
               $data['uniqueStatusTopic'] = '<b class="fixedTopicMarker" style="color:' . parent::$modules_config['color_prefixwan'] . '">' . parent::$modules_config['prefix_wan'] . '</b> ';
            }
         }
         if(parent::$action == 'watched_all') {
            $data['icon'] .= '<input class="markerOptionTopic" type="checkbox" data-type="' . parent::$action . '" value="' . $row['id'] . '" name="topic_id[]">';
         }
         if(parent::$action == 'categories' and $this->checkModerator($this->id)) {
            $data['icon'] .= '<input class="markerOptionTopic" type="checkbox" data-type="' . parent::$action . '" value="' . $row['id'] . '" name="topic_id[]">';
         }
         if(intval($row['topic_type']) == 2) {
            $data['icon'] .= '<span title="' . parent::$modules_lang['topic_42'] . '" class="clozed">' . parent::$modules_lang['topic_42'] . '</span>';
            if(trim(parent::$modules_config['prefix_cloze'])) {
               $data['uniqueStatusTopic'] .= '<b class="closedTopicMarker" style="color:' . parent::$modules_config['color_prefixcloze'] . '">' . parent::$modules_config['prefix_cloze'] . '</b> ';
            }
         }
         if(intval($row['vote_id']) > 0) {
            if(trim(parent::$modules_config['prefix_vote'])) {
               $data['uniqueStatusTopic'] .= '<b class="voteTopicMarker" style="color:' . parent::$modules_config['color_prefixvote'] . '">' . parent::$modules_config['prefix_vote'] . '</b> ';
            }
         }
         if($row['reply_count'] >= parent::$modules_config['fire_topic']) {
            $data['uniqueStatusTopic'] .= '<b style="color:' . parent::$modules_config['color_prefixfire'] . '" class="fireTopicMarker">' . parent::$modules_lang['topic_96'] . '</b>';
         }
         if(!empty(parent::$modules_config['widget_preview']) and $this->ckeckModulesConfig('be_preview_topic')) {
            $data['icon'] .= '<span onclick="doTopicPreview(' . $row['id'] . '); return false;" title="' . parent::$modules_lang['topic_79'] . '" class="topicPreview">' . parent::$modules_lang['topic_41'] . '</span>';
         }

         if($this->checkModerator($row['id_parent'])) {
            $data['editButton'] = '<a href="javascript:editTopic(\'' . $row['id'] . '\')" title="' . parent::$modules_lang['topic_44'] . '">' . parent::$modules_lang['topic_44'] . '</a>';
         }
         $row['page'] = ceil(($row['reply_count'] + 1 - $row['is_fixed_count']) / parent::$modules_config['message_count_page']);
         if($row['page'] >= 5 and $row['page'] >= 7) {
            $row['linckLast'] = $row['page'];
            $row['page'] = 5;
         }
         if($row['page'] >= 2 and parent::$modules_config['mini_pag']) {
            $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
            if(parent::$modules_config['cpu']) {
               if(!parent::$modules_config['slash']) {
                  $row['cpu'] = "/" . parent::$router['page'];
               } else {
                  $row['cpu'] = parent::$router['page'];
               }
            } else {
               $row['cpu'] = "&page=";
            }
            for ($page = 1; $row['page'] >= 1; $page++) {
               if($page == 1) {
                  $row['pageList'] .= '<li><a title="' . parent::$modules_lang['goPage3'] . $page . '" href="' . $this->linck->topicIsRedirect($row['id'], $this->totranslit($data['title'], true, true)) . '">' . $page . '</a></li>';
               } else {
                  $row['pageList'] .= '<li><a title="' . parent::$modules_lang['goPage3'] . $page . '" href="' . $this->linck->topicIsRedirect($row['id'], $this->totranslit($data['title'], true, true)) . $row['cpu'] . $page . $option['iSlash'] . '">' . $page . '</a></li>';
               }
               $row['page'] = $row['page'] - 1;
            }
            if($row['linckLast']) {
               $row['pageList'] .= '<li><a title="' . parent::$modules_lang['goPage3'] . $row['linckLast'] . '" href="' . $this->linck->topicIsRedirect($row['id'], $this->totranslit($data['title'], true, true)) . $row['cpu'] . $row['linckLast'] . $option['iSlash'] . '">' . $row['linckLast'] . '</a></li>';
            }
            $data['pageList'] = '<ul class="pageList">' . $row['pageList'] . '</ul>';
         }
         $data['status_read'] = $status;
         $data['id'] = $row['id'];
         $data['id_tree'] = $row['id_parent'];
         $data['reply_count'] = $row['reply_count'];
         $data['view_count'] = $row['view_count'];
         $data['autor_id'] = $row['autor_id'];
         $data['autor'] = stripslashes($row['autor']);
         $data['site_description'] = htmlspecialchars(stripslashes($row['topic_descr_site']));
         $data['post_date'] = $this->setDate($row['post_date']);
         $data['rating'] = $row['rating'];
         $data['last'] = $last;
         $data['topic_approve'] = $row['topic_approve'];
         $data['fixed'] = $row['topic_fixed'];
         $data['topic_type'] = $row['topic_type'];
         parent::$view->setTopicList($data);
      }
   }
   protected function _newTopic()
   {
      $row = array();
      $data = array();
      $option = array();
      if(!$this->_checkTreeConfigParam('tree_access_topic_new', $this->id)) {
         die('die no tree_access_topic_new');
      }
      $this->db->query("SELECT 
                        attachment_id, 
                        attachment_type, 
                        attachment_name, 
                        attachment_date 
                      FROM " . PREFIX . "_be_attachment 
                        WHERE attachment_user_id = {$this->userID} 
                      AND attachment_content_id = 0 
                      AND attachment_user_name = '{$this->userName}' 
                      ORDER BY 
                        attachment_id DESC");
      if($this->db->num_rows()) {
         while ($row = $this->db->get_row()) {
            $data['fileType'] = intval($row['attachment_type']);
            $data['fileExtensions'] = $this->_getExtensions($row['attachment_name']);
            $data['fileDateUpload'] = date('Y-m', $row['attachment_date']);
            $data['fileName'] = $row['attachment_name'];
            $data['fileNameSiteView'] = substr($row['attachment_name'], 10, 100);
            $data['fileDbId'] = $row['attachment_id'];
            $option['attachment'] .= parent::$view->setTplAttachmentList($data);
         }
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_16'] . parent::$treePermanent[$this->id]['tree_title']));
      return parent::$view->setTplMainBlock(parent::$view->add_topic($option['attachment']), $this->_setMetaTitl());
   }
   public function set_buttom(array $data = array())
   {
      $ret = '';
      if(parent::$logged_is) {
         if(parent::$action == 'categories') {
            if(in_array(parent::$id_member['user_group'], explode(',', parent::$tree[$this->id]['tree_access_topic_new'])) and intval(parent::$tree[$this->id]['tree_type']) != 0) {
               $ret .= '<li class="new_topic"><a href="' . $this->linck->new_topic_linck($this->id, $this->totranslit(parent::$tree[$this->id]['tree_title'], true, true)) . '">' . parent::$modules_lang['topic_new'] . '</a></li>';
            }
         }
         if($ret) {
            $ret = '<ul class="topic_buttons">' . $ret . '</ul>';
         } else {
            $ret = '';
         }
         return $ret;
      } else {
         return false;
      }
   }
   private function _childTree($mainTreeId = 0)
   {
      foreach (parent::$tree as $val) {
         if($val['tree_parent_id'] == $mainTreeId) {
            $id[] = $val['tree_id'];
         }
         continue;
      }
      if(!$id) {
         return false;
      }
      return parent::$view->setTplchildTree($id, $mainTreeId, explode(',', $this->_getGroupIdParseTree()));
   }
   public function get($name, $default, $type = 'mixed')
   {
      if(self::defined($name)) {
         $mixRes = $_REQUEST[$name];
      } else {
         if(null === $default) {
            return false;
         }
         $mixRes = $default;
      }
      if($type != 'mixed') {
         if($type == 'float') {
            $mixRes = str_replace(",", ".", $mixRes);
         }
         settype($mixRes, $type);
      }
      return $mixRes;
   }
   public function getInt($name, $default = 0)
   {
      return intval(self::get($name, $default, 'int'));
   }
   public function defined($name)
   {
      if(isset($_REQUEST[$name])) {
         return true;
      }
      return false;
   }
   private function deleteMQR($mixValue)
   {
      if(get_magic_quotes_gpc()) {
         if(is_array($mixValue)) {
            foreach ($mixValue as $k => $v) {
               $mixValue[$k] = self::deleteMQR($v);
            }
         } else {
            return trim(stripslashes($mixValue));
         }
      }
      return $mixValue;
   }
   public function getString($name, $default = "")
   {
      return self::deleteMQR(self::get($name, $default, 'string'));
   }
   public function set_file_cashe($file)
   {
      return unserialize(@file_get_contents($this->casheSySPath . $file . '.tmp'));
   }
   public function setQuestionCashe()
   {
      if(parent::$transcred) {
         parent::$unsigneds .= 'BFbmVyZ3kgRm9ydW08L2E+Wy9ub2xlZWNoXTwvZGl2PjwvZGl2Pg==';
      }
      if(file_exists($this->casheSySPath . 'question.tmp')) {
         return parent::$handler->set_file_cashe('question');
      } else {
         $tree = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_question WHERE is_active = '1' ORDER BY id ASC ");
         while ($row = $this->db->get_row()) {
            $tree[$row['id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['id']][$key] = stripslashes($value);
            }
         }
         $this->writeSysCashe('question', $tree);
         return parent::$handler->set_file_cashe('question');
      }
   }
   public function setSystemTreeDirect()
   {
      $tree = array();
      $joinConstruct = $this->_joinReadTree();
      $this->db->query("SELECT * {$joinConstruct['select']} FROM " . PREFIX . "_be_tree {$joinConstruct['join']} WHERE " . PREFIX . "_be_tree.tree_id IN (" . parent::$sys_cashe['accessTreeView'] . ") ORDER BY tree_display ASC");
      while ($row = $this->db->get_row()) {
         $tree[$row['tree_id']] = array();
         foreach ($row as $key => $value) {
            $tree[$row['tree_id']][$key] = stripslashes($value);
            $tree[$row['tree_id']]['treeChild'] = empty($row['tree_type']) ? '' : $this->_getChildTreeSetHomePage($row['tree_id'], array());
            $tree[$row['tree_id']]['read'] = (isset($row['bert_read_date']) && $row['bert_read_date'] < $row['tree_last_date']);
         }
      }
      return $tree;
   }
   private function _treeListArray($id)
   {
      //foreach argument linck?
      $tree = array();
      foreach (parent::$treePermanent as $key => $value) {
         if(!$value['tree_parent_id']) {
            $tree[$key] = array();
         }
      }
      foreach (parent::$treePermanent as $key => $value) {
         if($value['tree_parent_id']) {
            $tree[$value['tree_parent_id']][] = $key;
         }
      }
      return $id ? $tree[$id] : $tree;
   }
   protected function setSystemCasheGroup()
   {
      $id = $this->db->safesql(parent::$id_member['user_group']);
      if(file_exists($this->casheSySPath . 'sys_cashe_group_' . $id . '.tmp')) {
         return parent::$handler->set_file_cashe('sys_cashe_group_' . $id);
      } else {
         $this->db->query("SELECT tree_id FROM " . PREFIX . "_be_tree where tree_access_view like '%{$id}%'");
         if(!$this->db->num_rows()) {
            return false;
         }
         $tpm = array();
         while ($row = $this->db->get_row()) {
            foreach ($row as $key => $value) {
               $tpm[] = $row['tree_id'];
            }
         }
         $this->db->query("SELECT tree_id FROM " . PREFIX . "_be_tree where tree_access_topic_read like '%{$id}%'");
         if(!$this->db->num_rows()) {
            return false;
         }
         $tpm_ = array();
         while ($row = $this->db->get_row()) {
            foreach ($row as $key => $value) {
               $tpm_[] = $row['tree_id'];
            }
         }
         $inter = $this->db->safesql(implode(',', array_intersect($tpm, $tpm_))) ? $this->db->safesql(implode(',', array_intersect($tpm, $tpm_))) : 0;
         $this->writeSysCashe('sys_cashe_group_' . $id, array('parse' => $inter, 'accessTreeView' => $this->db->safesql(implode(',', $tpm)), 'accessTopicView' => $this->db->safesql(implode(',', $tpm_))));
         return parent::$handler->set_file_cashe('sys_cashe_group_' . $id);
      }
   }
   protected function _moderation()
   {
      $fetch = '';
      $option = array();
      if(!parent::$moderator[parent::$id_member['user_id']]) {
         die('Error no access page forum!');
      }
      $this->_setSessionTable(array('action' => parent::$modules_lang['side_bar_11']));
      $option['treeAccessModerator'] = $this->_checkSuperModerator() ? '' : ' AND tree_id IN (' . $this->db->safesql(implode(',', parent::$moderator[parent::$id_member['user_id']]['treeAccess'])) . ')';
      $row = $this->db->super_query("SELECT count(*) as count 
                                   FROM " . PREFIX . "_be_message AS msg 
                                   WHERE 
                                     message_approve = 0 
                                   {$option['treeAccessModerator']}");
      $option['paginator'] = $this->setPaginator(array('unreadCount' => $row['count'], 'linck' => $this->linck->linckModeration()));
      $this->db->query("SELECT 
                        msg.id, 
                        msg.autors_id, 
                        msg.message_autor, 
                        msg.message_date, 
                        msg.message_text, 
                        msg.parent_msg, 
                        topic.title, 
                        topic.id AS idTopic
                      FROM " . PREFIX . "_be_message as msg
                      LEFT JOIN " . PREFIX . "_be_topic AS topic ON (
                        msg.id_topic = topic.id
                      )
                      WHERE 
                        message_approve = 0 
                      {$option['treeAccessModerator']}
                      LIMIT {$option['paginator']['start']},{$option['paginator']['nums']}");
      if(!$this->db->num_rows()) {
         $fetch = parent::$view->error_set(parent::$modules_lang['topic_19'], parent::$modules_lang['msg_31']);
      } else {
         while ($row = $this->db->get_row()) {
            $fetch .= '<div class="moderationBoxMessage"><dl><dt>' . parent::$modules_lang['msg_20'] . ': ' . $this->linck->card_user(array($row['message_autor'], $row['autors_id'])) . $row['message_autor'] . '</a></dt><dd>' . parent::$modules_lang['msg_21'] . '<a href="' . $this->linck->postLinck($row['idTopic'], $row['id'], $this->totranslit($row['title'], true, true)) . '">' . stripcslashes($row['title']) . '</a> </dd><dd>' . parent::$modules_lang['msg_27'] . ': <b>' . $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']) . '</b></dd></dl><dl class="message"><dt></dt><dd><div id="' . $row['id'] . '">' . stripcslashes($row['message_text']) . '</div><textarea id="editor_' . $row['id'] . '" style="display:none" rows="2" name="moderation[' . $row['id'] . '][message]">' . $this->filter->decodeBBCodes($row['message_text'], false) . '</textarea></dd></dl><dl class="configure"><dt>' . parent::$modules_lang['msg_23'] . ':</dt><dd><ul><li><label for="' . $row['id'] . '_gofor"><input id="' . $row['id'] . '_gofor" type="radio" value="1" name="moderation[' . $row['id'] . '][action]">' . parent::$modules_lang['msg_24'] . ' </label></li><li><label for="' . $row['id'] . '_godel"><input id="' . $row['id'] . '_godel" type="radio" value="0" name="moderation[' . $row['id'] . '][action]">' . parent::$modules_lang['msg_25'] . ' </label><input type="hidden" value="' . $row['parent_msg'] . '" name="moderation[' . $row['id'] . '][event]"><input type="hidden" value="' . $row['idTopic'] . '" name="moderation[' . $row['id'] . '][fetch]"></li><li><a id="click_' . $row['id'] . '" onclick="editorModerBlock(\'' . $row['id'] . '\')">' . parent::$modules_lang['msg_28'] . '</a></li></ul></dd></dl></div>';
         }
         $fetch = '<form action="" id="moderation_update" name="moderation_update" method="post">' . $fetch . '<div class="bottonFooter"><button name="submit" type="submit"  class="b01">' . parent::$modules_lang['msg_26'] . '</button></div><input type="hidden" value="moderation_update" name="action"></form>' . $option['paginator']['paginator'];
      }
      return parent::$view->setTplMainBlock($fetch, $this->_setMetaTitl(array('titleAction' => parent::$modules_lang['msg_29'])), array('spedbar' => array('titlAction' => parent::$modules_lang['msg_29'])));
   }
   protected function _moderationProcess()
   {
      if(!parent::$moderator[parent::$id_member['user_id']] and isset($_POST['moderation'])) {
         die('Error no access page forum!');
      }
      $tableSchema = array();
      $option = array();
      foreach ($_POST['moderation'] as $key => $value) {
         if(isset($value['action']) and trim($value['message']) and isset($value['event'])) {
            $option['action'] = $value['action'] ? 1 : 0;
            $option['text'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($value['message'])), false));
            if($option['text']) {
               if($option['action']) {
                  if($value['event']) {
                     $tableSchema[] = "UPDATE " . PREFIX . "_be_message 
                                SET message_text = '{$option['text']}',
                                message_approve = '{$option['action']}' 
                                WHERE id = {$key} LIMIT 1";
                     $tableSchema[] = "UPDATE " . PREFIX . "_be_topic 
                                SET topic_approve = '1' 
                                WHERE id = {$value['fetch']} LIMIT 1";
                  } else {
                     $tableSchema[] = "UPDATE " . PREFIX . "_be_message 
                                SET message_text = '{$option['text']}',
                                message_approve = '{$option['action']}' 
                                WHERE id = {$key} LIMIT 1";
                  }
               } elseif(!$option['action']) {
                  if($value['event']) {
                     $tableSchema[] = "DELETE FROM " . PREFIX . "_be_message 
                                WHERE id = {$key} LIMIT 1";
                     $tableSchema[] = "DELETE FROM " . PREFIX . "_be_attachment 
                                WHERE attachment_content_id = {$key}";
                     $tableSchema[] = "DELETE FROM " . PREFIX . "_be_topic 
                                WHERE id = {$value['fetch']} LIMIT 1";
                  } else {
                     $tableSchema[] = "DELETE FROM " . PREFIX . "_be_message 
                                WHERE id = {$key} LIMIT 1";
                  }
               }
            }
         }
         continue;
      }
      if(count($tableSchema)) {
         foreach ($tableSchema as $sql) {
            $this->db->query($sql);
         }
      }
      header('Location: ' . $this->linck->linckModeration());
   }
   public function checkModerator($id = '')
   {
      if(!is_array(parent::$moderator[parent::$id_member['user_id']]['treeAccess'])) {
         return false;
      }
      if(in_array($id, parent::$moderator[parent::$id_member['user_id']]['treeAccess'])) {
         if(parent::$groups_config[parent::$id_member['user_group']]['be_moder_topic_moder_param'] and parent::$groups_config[parent::$id_member['user_group']]['be_moder_moder_access']) {
            return true;
         }
      } elseif(parent::$moderator[parent::$id_member['user_id']]['moderator_super']) {
         return true;
      } else {
         return false;
      }
   }
   private function _checkSuperModerator($id = '')
   {
      return parent::$moderator[parent::$id_member['user_id']]['moderator_super'] ? true : false;
   }
   public function setModeratorCashe()
   {
      if(file_exists($this->casheSySPath . 'moderator.tmp')) {
         return parent::$handler->set_file_cashe('moderator');
      } else {
         $tree = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_moderator ORDER BY id ASC");
         while ($row = $this->db->get_row()) {
            $tree[$row['moderator_id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['moderator_id']][$key] = stripslashes($value);
               $tree[$row['moderator_id']]['treeAccess'] = explode(',', $tree[$row['moderator_id']]['moderator_tree_id']);
            }
         }
         $this->writeSysCashe('moderator', $tree);
         return parent::$handler->set_file_cashe('moderator');
      }
   }
   public function setSystemTreePermanent()
   {
      parent::$unsigneds .= parent::$transcred ? 'ydEJveCI+UG93ZXJlZCBieSBbbm9sZWVjaF08YSBocmVmPSJodHR' : 'YSB0YXJnZXQ9Il9ibGFuayIgaHJlZj0iaHR0cDovL3doaXRlLW1hc3Rlci5ydS8iPkJ1bGxldCBF';
      if(file_exists($this->casheSySPath . 'tree_permanent.tmp')) {
         return parent::$handler->set_file_cashe('tree_permanent');
      } else {
         $tree = array();
         $this->db->query("SELECT * 
                        FROM " . PREFIX . "_be_tree ORDER BY tree_display ASC");
         while ($row = $this->db->get_row()) {
            $tree[$row['tree_id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['tree_id']][$key] = stripslashes($value);
            }
         }
         $this->writeSysCashe('tree_permanent', $tree);
         return parent::$handler->set_file_cashe('tree_permanent');
      }
   }
   public function setStatCashe()
   {
      if(file_exists($this->casheSySPath . 'stat.tmp')) {
         return parent::$handler->set_file_cashe('stat');
      } else {
         $row['topic'] = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_topic");
         $row['post'] = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_message");
         $row['user'] = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_users");
         $row['userLast'] = $this->db->super_query("SELECT name,user_id FROM " . PREFIX . "_users ORDER BY user_id DESC LIMIT 1");
         $row['userLast'] = $this->linck->card_user(array($row['userLast']['name'], $row['userLast']['user_id'])) . $row['userLast']['name'] . '</a>';
         $this->writeSysCashe('stat', $row);
         return parent::$handler->set_file_cashe('stat');
      }
   }
   public function setAdvertising()
   {
      if(file_exists($this->casheSySPath . 'advertising.tmp')) {
         return parent::$handler->set_file_cashe('advertising');
      } else {
         $advertising = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_advertising WHERE advertising_display = 'display'");
         if($this->db->num_rows()) {
            while ($row = $this->db->get_row()) {
               $advertising[$row['advertising_id']] = array();
               foreach ($row as $key => $value) {
                  if($key == 'advertising_group' or $key == 'advertising_tree') {
                     $value = explode('.', $value);
                  }
                  $advertising[$row['advertising_id']][$key] = $value;
               }
            }
         }
         $this->writeSysCashe('advertising', $advertising);
         return parent::$handler->set_file_cashe('advertising');
      }
   }
   public function setTitle()
   {

      if(file_exists($this->casheSySPath . 'title.tmp')) {
         return parent::$handler->set_file_cashe('title');
      } else {
         $data = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_user_title ORDER BY bals DESC");
         while ($row = $this->db->get_row()) {
            $data[$row['id']] = array();
            foreach ($row as $key => $value) {
               $data[$row['id']][$key] = stripcslashes($value);
            }
         }
         $this->writeSysCashe('title', $data);
         return parent::$handler->set_file_cashe('title');
      }
   }
   public function setHonor()
   {
      parent::$unsigneds .= parent::$transcred ? 'wOi8vd2hpdGUtbWFzdGVyLnJ1LyIgdGFyZ2V0PSJfYmxhbmsiPkJ1bGxldC' : 'bmVyZ3kgRm9ydW08L2E+PC9kaXY+PC9kaXY+';
      if(file_exists($this->casheSySPath . 'honor.tmp')) {
         return parent::$handler->set_file_cashe('honor');
      } else {
         $data = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_honor ORDER BY id ASC");
         while ($row = $this->db->get_row()) {
            $data[$row['id']] = array();
            foreach ($row as $key => $value) {
               if($key == 'criteria') {
                  $value = unserialize($value);
               }
               $data[$row['id']][$key] = $value;
            }
         }
         $this->writeSysCashe('honor', $data);
         return parent::$handler->set_file_cashe('honor');
      }
   }
   public function set_group_cashe()
   {
      //var_dump(parent::$transcred);
      if(file_exists($this->casheSySPath . 'groups_config.tmp')) {
         return parent::$handler->set_file_cashe('groups_config');
      } else {
         $data = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_groups ORDER BY be_groups_id ASC");
         while ($row = $this->db->get_row()) {
            $data[$row['be_groups_id']] = array();
            foreach ($row as $key => $value) {
               $data[$row['be_groups_id']][$key] = stripslashes($value);
            }
         }
         $this->writeSysCashe('groups_config', $data);
         return parent::$handler->set_file_cashe('groups_config');
      }
   }
   private function writeSysCashe($file, $data)
   {
      $fp = fopen($this->casheSySPath . $file . '.tmp', 'wb+');
      fwrite($fp, serialize($data));
      fclose($fp);
      @chmod($this->casheSySPath . $file . '.tmp', 0666);
   }
}

?>