<?php

/*
=================================================================
Bullet Energy - by White-Master 
-----------------------------------------------------------------
http://white-master.ru/
-----------------------------------------------------------------
Copyright (c) 2011 White-Master
=================================================================
    
=================================================================
: ajax_handler.class.php
=================================================================
*/
class BulletAjaxHandler extends BulletAjax
{
   private $casheSysDir = '';
   private $db = null;
   private $filter = null;
   private $userID = '';
   private $userName = '';
   public $time = 0;
   private $viewer = null;
   private $timeMarkerOldTopic = 0;
   private $id = 0;
   public function __construct()
   {
      require_once (ENGINE_DIR . '/bullet_energy/classes/filter.class.php');
      require_once (ENGINE_DIR . '/bullet_energy/classes/ajax_viewer.class.php');
      if(!class_exists('db')) {
         require_once ENGINE_DIR . '/classes/mysql.class.php';
      }
      $this->db = new db;
      $this->filter = new BulletFilter;
      $this->filter->allow_url = parent::$group_user[parent::$id_member['user_group']]['allow_url'];
      $this->filter->allow_image = parent::$group_user[parent::$id_member['user_group']]['allow_image'];
      $this->viewer = new BulletAjaxViewer;
      $this->casheSysDir = ENGINE_DIR . '/bullet_energy/cache/system/';
      $this->userID = $this->db->safesql(parent::$id_member['user_id']);
      $this->userName = $this->db->safesql(parent::$id_member['name']);
      $this->time = time() + (parent::$dle_config['date_adjust'] * 60);
      $this->timeMarkerOldTopic = $this->time - parent::$modules_config['topic_day'] * 86400;
      $this->id = $this->getInt('id');
   }

   public function massConfigure()
   {
      $option = array();
      $option['action'] = $this->getString('action_type');
      $option['action'] = empty($option['action']) ? die($this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0)) : $option['action'];
      $option['arrayAction'] = array('clozed', 'open', 'pin', 'unpin', 'move', 'merge');
      if(!in_array($option['action'], $option['arrayAction'])) {
         $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
      }
      $option['arrayIdTopic'] = $this->_arrayCheck($_REQUEST['arrUnFeed'], array('setType' => 'int', 'setTypeNull' => 'unset'));
      if(empty($option['arrayIdTopic'])) {
         $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
      }
      $option['arrayCount'] = $option['arrayIdTopic'];
      $option['arrayIdTopic'] = implode(',', $option['arrayIdTopic']);
      $this->db->query("SELECT id,id_parent,title FROM " . PREFIX . "_be_topic WHERE id IN ({$option['arrayIdTopic']})");
      while ($option['row'] = $this->db->get_row()) {
         if(!$this->checkModerator($option['row']['id_parent'])) {
            return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
         }
         $option['getTree'] = (int)$option['row']['id_parent'];
         $option['row']['title'] = stripcslashes($option['row']['title']);
         $option['buffer'] .= '<tr><td>' . $option['row']['title'] . '</td></tr>';
         $option['bufferSelect'] .= '<option value="' . $option['row']['id'] . '">' . $option['row']['title'] . '</option>';
      }
      switch ($option['action']) {
         case 'clozed':
            $this->db->query("UPDATE " . PREFIX . "_be_topic SET topic_type = 2 WHERE id IN ({$option['arrayIdTopic']})");
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_99'], 1);
            break;
         case 'merge_complit':
            $option['newName'] = $this->getInt('new_name');
            $option['newName'] = empty($option['newName']) ? die($this->_setDefaultJsonInfo('', 0)):
            $option['newName'];
            $option['newName'] = $this->db->super_query("SELECT id,title FROM " . PREFIX . "_be_topic WHERE id = {$option['newName']} LIMIT 1");
            if(empty($option['newName'])) {
               return $this->_setDefaultJsonInfo('', 0);
            }
            unset($option['arrayCount'][array_search($option['newName']['id'], $option['arrayCount'])]);
            if(!empty($option['arrayCount'])) {
               $option['arrayCount'] = implode(',', $option['arrayCount']);
            } else {
               return $this->_setDefaultJsonInfo('', 0);
            }
            $this->db->query("UPDATE " . PREFIX . "_be_message SET id_topic = {$option['newName']['id']} WHERE id_topic IN ({$option['arrayCount']})");
            $this->db->query("DELETE FROM " . PREFIX . "_be_topic WHERE id IN({$option['arrayCount']})");
            //
            $postData = $this->db->super_query("SELECT message.message_autor as name, message.id AS post_id, message.autors_id, message.message_date,  user.foto FROM " . PREFIX . "_be_message AS message LEFT JOIN " . PREFIX . "_users AS user ON message.autors_id = user.user_id WHERE message.id_topic = {$option['newName']['id']} ORDER BY message.message_date DESC LIMIT 1");
            $postData['counts'] = $this->db->super_query("SELECT COUNT(*) as countPage FROM " . PREFIX . "_be_message AS msg WHERE id_topic = {$option['newName']['id']} AND id <= {$postData['post_id']}");
            $postData['countsPostTopic'] = $this->db->super_query("SELECT COUNT(*) as countPT FROM " . PREFIX . "_be_message AS msg WHERE id_topic = {$option['newName']['id']}");
            $postData['countsPostTopic'] = $postData['countsPostTopic']['countPT'] - 1;
            $postData['page'] = ceil($postData['counts']['countPage'] / parent::$modules_config['message_count_page']);
            if(parent::$modules_config['cpu']) {
               $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
               if($postData['page'] == 1) {
                  $postData['page'] = '';
               } else {
                  if(!parent::$modules_config['slash']) {
                     $postData['page'] = "/" . parent::$router['page'] . "{$postData['page']}{$option['iSlash']}";
                  } else {
                     $postData['page'] = parent::$router['page'] . "{$postData['page']}{$option['iSlash']}";
                  }
               }
            } else {
               $postData['page'] = "&page={$postData['page']}{$option['iSlash']}";
            }
            // $postData['page'] = $postData['page'] == 1 ? '': "/" . parent::$router['page'] . "{$postData['page']}";
            $postData['page'] = parent::$linck->topicIsRedirect($option['newName']['id'], $this->totranslit($option['newName']['title'], true, true)) . $postData['page'] . '#message-' . $postData['post_id'];
            $postData['last'] = $this->_generateLastPostInfo(array($postData['name'], $postData['message_date'], $option['newName']['title'], $postData['page'], $postData['foto'], $postData['autors_id']));
            $this->db->query("UPDATE " . PREFIX . "_be_topic set reply_count={$postData['countsPostTopic']},last_reply_info = '{$postData['last']}' where id ='{$option['newName']['id']}'");
            $this->_updateTopicParam();
            return $this->getJson(array('param' => '1', 'data' => parent::$modules_lang['topic_110'], 'newId' => $option['newName']['id']));
            break;
         case 'open':
            $this->db->query("UPDATE " . PREFIX . "_be_topic SET topic_type = 0 WHERE id IN ({$option['arrayIdTopic']})");
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_100'], 1);
            break;
         case 'pin':
            $this->db->query("UPDATE " . PREFIX . "_be_topic SET topic_fixed = 1 WHERE id IN ({$option['arrayIdTopic']})");
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_102'], 1);
            break;
         case 'unpin':
            $this->db->query("UPDATE " . PREFIX . "_be_topic SET topic_fixed = 0 WHERE id IN ({$option['arrayIdTopic']})");
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_103'], 1);
            break;
         case 'merge':
            if(count($option['arrayCount']) < 2) {
               return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_108'], 0);
            }
            $option['bufferSelect'] = parent::$modules_lang['topic_109'] . '<div><select class="dialogForm" id="new_name" name="new_name">' . $option['bufferSelect'] . '</select></div>';
            return $this->_setDefaultJsonInfo($option['bufferSelect'], 1);

            break;
         case 'delete':
            $this->db->query("DELETE FROM " . PREFIX . "_be_topic WHERE id IN ({$option['arrayIdTopic']})");
            $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE id_topic IN ({$option['arrayIdTopic']})");
            $this->_updateTopicParam();
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_107'], 1);
            break;
         case 'move_complit':
            $option['new_tree'] = $this->getInt('new_tree');
            $option['new_tree'] = empty($option['new_tree']) ? die($this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0)):
            $option['new_tree'];
            $this->db->query("UPDATE " . PREFIX . "_be_topic SET id_parent = {$option['new_tree']} WHERE id IN(" . $option['arrayIdTopic'] . ")");
            $this->db->query("UPDATE " . PREFIX . "_be_message SET tree_id = {$option['new_tree']} WHERE id_topic IN(" . $option['arrayIdTopic'] . ")");
            $this->_updateTopicParam();
            return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_106'], 1);
            break;
         case 'move':
            $option['buffer'] = '<div id="tablePopupMax"><table class="popupTableForum"><tbody><tr><th class="w250" scope="col">' . parent::$modules_lang['topic_105'] . '</th></tr>' . $option['buffer'] . '</tbody></table></div>';
            $option['buffer'] = $option['buffer'] . '<div class="paramBox moveTopic"><p>' . parent::$modules_lang['topic_104'] . '</p><select name="new_tree" id="new_tree">' . $this->_setSelectTree($option['getTree'], 0, false, '', '', '') . '</select></div>';
            return $this->_setDefaultJsonInfo($option['buffer'], 1);
            break;
         default:
            $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
            break;
      }
   }
   public function shareUpdatePosition()
   {
      if(!$this->_checkAdmin()) {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
      }
      $option = array();
      $option['element'] = $this->getString('element');
      $option['element'] = empty($option['element']) ? $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0) : $option['element'];
      $option['position'] = $this->getInt('position');
      $option['position'] = empty($option['position']) ? $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0) : $option['position'];
      $option['positionOld'] = $this->getInt('position_old');
      $option['positionOld'] = empty($option['positionOld']) ? $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0) : $option['positionOld'];
      $option['listArray'] = empty($_REQUEST['list']) ? $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0) : $_REQUEST['list'];
      if(!array_key_exists($option['element'], parent::$share)) {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_64'], 0);
      }
      foreach ($option['listArray'] as $key => $value) {
         if(!isset(parent::$share[$value])) {
            continue;
         }
         parent::$share[$value]['position'] = $key;
      }
      $this->saveArray(parent::$share, ENGINE_DIR . '/bullet_energy/data/forum_share.php', 0, '$share');
      return $this->_setDefaultJsonInfo('', 1);
   }
   public function share()
   {
      if(!$this->_checkAdmin()) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['action'] = $this->getString('action');
      $option['action'] = empty($option['action']) ? $this->_setDefaultJsonInfo('', 0) : $option['action'];
      $option['name'] = $this->getString('name');
      $option['name'] = empty($option['name']) ? $this->_setDefaultJsonInfo('', 0) : $option['name'];
      if(!array_key_exists($option['name'], parent::$share)) {
         return $this->_setDefaultJsonInfo('', 0);
      }

      if($option['action'] == 'enable') {
         parent::$share[$option['name']]['type'] = "1";
         $option['return'] = $this->_setDefaultJsonInfo('<a id="' . $option['name'] . '" title="' . parent::$modules_lang['setting_426'] . '" onclick="doShare(\'' . $option['name'] . '\',\'disabled\'); return false;" class="deleteElementA"><b>' . parent::$modules_lang['setting_426'] . '</b></a>', 1);
      } elseif($option['action'] == 'disabled') {
         parent::$share[$option['name']]['type'] = "0";
         $option['return'] = $this->_setDefaultJsonInfo('<a id="' . $option['name'] . '" title="' . parent::$modules_lang['setting_427'] . '" onclick="doShare(\'' . $option['name'] . '\',\'enable\'); return false;" class="enableElementA"><b>' . parent::$modules_lang['setting_427'] . '</b></a>', 1);
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $this->saveArray(parent::$share, ENGINE_DIR . '/bullet_energy/data/forum_share.php', 0, '$share');
      return $option['return'];
   }
   private function saveArray($array, $filename = 0, $file = 0, $name = '')
   {
      $find[] = "'\r'";
      $replace[] = "";
      $find[] = "'\n'";
      $replace[] = "";
      $level = 1;
      if($file == 0) {
         $level = 0;
         $file = fopen($filename, "w");
         if(!$file) {
            return false;
         }
         fwrite($file, "<?PHP \n {$name} = ");
      }
      $cnt = count($array);
      $i = 0;
      fwrite($file, "\narray(\n");
      foreach ($array as $key => $value) {
         $value = trim(stripslashes($value));
         $value = htmlspecialchars($value, ENT_QUOTES);
         $value = preg_replace($find, $replace, $value);
         $key = trim(stripslashes($key));
         $key = htmlspecialchars($key, ENT_QUOTES);
         $name = preg_replace($find, $replace, $key);
         $value = str_replace("$", "&#036;", $value);
         $value = str_replace("{", "&#123;", $value);
         $value = str_replace("}", "&#125;", $value);
         $key = str_replace("$", "&#036;", $key);
         $key = str_replace("{", "&#123;", $key);
         $key = str_replace("}", "&#125;", $key);

         if($i++ != 0) {
            fwrite($file, ",\n");
         }
         if(is_array($array[$key])) {
            fwrite($file, "'$key' => ");
            $this->saveArray($array[$key], 0, $file, $name);
         } else {

            fwrite($file, str_repeat(' ', ($level + 1) * 2) . "'$key' => '$value'");
         }
      }
      fwrite($file, ")");
      if($level == 0) {
         fwrite($file, ";\n?" . ">");
         fclose($file);
         return true;
      }
   }
   private function _arrayCheck($data = array(), array $type = array())
   {
      $return = array();
      if(!is_array($data) or empty($data)) {
         return false;
      }
      if($type['setType'] == 'int') {
         foreach ($data as $key => $value) {
            $value = abs(intval($value));
            if($type['setTypeNull'] == 'unset' and $value <= 0) {
               continue;
            }
            $return[] = $value;
         }
      } elseif($type['setType'] == 'string') {
         foreach ($data as $key => $value) {
            $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', '&nbsp;' => ' ');
            $value = trim(strtr(strip_tags($value), $chars));
            if($type['setTypeNull'] == 'unset' and $value == '') {
               continue;
            }
            $return[] = $value;
         }
      }
      return empty($return) ? false : $return;
   }
   public function deleteVote()
   {
      if(!parent::$logged_is) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id_poll');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      $option['poll'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $option['poll']['answers'] = unserialize($option['poll']['answers']);
      $this->db->query("SELECT id_parent,autor_id,post_date,topic_type FROM " . PREFIX . "_be_topic WHERE id = {$option['poll']['vote_topic_id']} LIMIT 1");
      $option['topic'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      if($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_access_edit_my_post') and $option['topic']['post_date'] + (parent::$modules_config['edit_time_post'] * 60) > $this->time and $option['topic']['topic_type'] != 2) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_moder_edit_message_user') and $this->checkModerator($option['topic']['id_parent'])) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->checkModerator($option['topic']['id_parent']) and $this->ckeckModulesConfigGroup('be_access_edit_my_post')) {
         $data['editCommentAccess'] = true;
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      $this->db->query("DELETE FROM " . PREFIX . "_be_poll_answers WHERE vote_id = {$option['id']}");
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET vote_id = 0 WHERE id = {$option['poll']['vote_topic_id']} LIMIT 1");
      return $this->_setDefaultJsonInfo('ok', 1);
   }
   public function updateVote()
   {
      if(!parent::$logged_is) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id_poll');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      $option['poll'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $option['poll']['answers'] = unserialize($option['poll']['answers']);
      $this->db->query("SELECT id_parent,autor_id,post_date,topic_type FROM " . PREFIX . "_be_topic WHERE id = {$option['poll']['vote_topic_id']} LIMIT 1");
      $option['topic'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      if($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_access_edit_my_post') and $option['topic']['post_date'] + (parent::$modules_config['edit_time_post'] * 60) > $this->time and $option['topic']['topic_type'] != 2) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_moder_edit_message_user') and $this->checkModerator($option['topic']['id_parent'])) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->checkModerator($option['topic']['id_parent']) and $this->ckeckModulesConfigGroup('be_access_edit_my_post')) {
         $data['editCommentAccess'] = true;
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['titleVote'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($this->convert_unicode($_REQUEST['vote_titl']))), false));
      $option['newAnswer'] = $this->_arrayCheck($_REQUEST['new_vote_replic'], array('setType' => 'string', 'setTypeNull' => 'unset'));
      foreach ($_REQUEST['vote_replic'] as $key => $value) {
         if(!isset($option['poll']['answers'][$key])) {
            continue;
         }
         $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', '&nbsp;' => ' ');
         $value = $this->convert_unicode($value);
         $value = strtr($value, $chars);
         $value = trim($this->filter->process($value));
         if($value == '') {
            unset($_REQUEST['vote_replic'][$key]);
            if(empty($_REQUEST['vote_replic']) and empty($option['newAnswer'])) {
               return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_95'], 0);
            }
            continue;
         }
         $value = $this->db->safesql($value);
         $option['poll']['answers'][$key]['answers'] = $value;
         $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET answers = '{$value}' WHERE id = {$key} LIMIT 1");
      }
      foreach ($option['newAnswer'] as $key => $value) {
         $chars = array("\r" => '', "\n" => '', "\0" => '', "\xC2\xA0" => ' ', "\x22" => '', "\x60" => '', "\t" => '', '&nbsp;' => ' ');
         $value = $this->convert_unicode($value);
         $value = strtr($value, $chars);
         $value = trim($this->filter->process($value));
         if($value == '') {
            unset($option['newAnswer'][$key]);
            if(empty($option['newAnswer'])) {
               break;
            }
            continue;
         }
         $value = $this->db->safesql($value);
         $this->db->query("INSERT INTO " . PREFIX . "_be_poll_answers (id, vote_id, answers, answers_count, user_vote) VALUES (NULL, {$option['id']}, '{$value}', 0, '')");
         $key = $this->db->insert_id();
         $option['poll']['answers'][$key] = array('answers' => $value, 'count' => 0, 'user_vote' => false);
      }
      if(empty($_REQUEST['vote_replic']) and empty($option['newAnswer'])) {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_95'], 0);
      }
      $option['poll']['answers'] = $this->db->safesql(serialize($option['poll']['answers']));
      $option['visible_votes'] = $this->getInt('vote_visible_poll') > 0 ? 1 : 0;
      $option['multi_votes'] = $this->getInt('vote_multi') > 0 ? 1 : 0;
      $this->db->query("UPDATE " . PREFIX . "_be_poll SET answers = '{$option['poll']['answers']}', vote_question ='{$option['titleVote']}', multi={$option['multi_votes']}, visible_vote_user = {$option['visible_votes']} WHERE vote_id = {$option['id']} LIMIT 1");
      return $this->_setDefaultJsonInfo('ok', 1);
   }
   public function deleteAnswerVote()
   {
      if(!parent::$logged_is) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll_answers WHERE id = {$option['id']} LIMIT 1");
      $option['pollAnswers'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['pollAnswers']['vote_id']} LIMIT 1");
      $option['poll'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $option['poll']['answers'] = unserialize($option['poll']['answers']);
      $this->db->query("SELECT id_parent,autor_id,post_date,topic_type FROM " . PREFIX . "_be_topic WHERE id = {$option['poll']['vote_topic_id']} LIMIT 1");
      if($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_access_edit_my_post') and $option['topic']['post_date'] + (parent::$modules_config['edit_time_post'] * 60) > $this->time and $option['topic']['topic_type'] != 2) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_moder_edit_message_user') and $this->checkModerator($option['topic']['id_parent'])) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->checkModerator($option['topic']['id_parent']) and $this->ckeckModulesConfigGroup('be_access_edit_my_post')) {
         $data['editCommentAccess'] = true;
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      if(isset($option['poll']['answers'][$option['id']])) {
         unset($option['poll']['answers'][$option['id']]);
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_poll_answers WHERE id = {$option['id']} LIMIT 1");
      $option['poll']['answers'] = $this->db->safesql(serialize($option['poll']['answers']));
      $this->db->query("UPDATE " . PREFIX . "_be_poll SET answers = '{$option['poll']['answers']}', vote_count = vote_count - {$option['pollAnswers']['answers_count']} WHERE vote_id = {$option['poll']['vote_id']} LIMIT 1");
      $this->db->query("DELETE FROM " . PREFIX . "_be_poll_log WHERE answers_id = {$option['id']}");
      return $this->_setDefaultJsonInfo('ok', 1);
   }
   public function getEditorVote()
   {
      if(!parent::$logged_is) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      $option['poll'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $option['poll']['answers'] = unserialize($option['poll']['answers']);
      $this->db->query("SELECT id_parent,autor_id,post_date,topic_type FROM " . PREFIX . "_be_topic WHERE id = {$option['poll']['vote_topic_id']} LIMIT 1");
      if($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_access_edit_my_post') and $option['topic']['post_date'] + (parent::$modules_config['edit_time_post'] * 60) > $this->time and $option['topic']['topic_type'] != 2) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] != parent::$id_member['user_id'] and $this->ckeckModulesConfigGroup('be_moder_edit_message_user') and $this->checkModerator($option['topic']['id_parent'])) {
         $data['editCommentAccess'] = true;
      } elseif($option['topic']['autors_id'] == parent::$id_member['user_id'] and $this->checkModerator($option['topic']['id_parent']) and $this->ckeckModulesConfigGroup('be_access_edit_my_post')) {
         $data['editCommentAccess'] = true;
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['topic'] = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll_answers WHERE vote_id = {$option['id']} ORDER BY id ASC");
      if(!$this->db->num_rows()) {
         die($this->_setDefaultJsonInfo('', 0));
      }
      if($option['poll']['multi']) {
         $option['isMulti'] = ' checked="checked" ';
      }
      if($option['poll']['visible_vote_user']) {
         $option['isViewUserVoted'] = ' checked="checked" ';
      }
      while ($row = $this->db->get_row()) {
         $option['return'] .= '<tr class="listBoxAnswer" id="' . $row['id'] . '"><td><a class="deleteAnswerVote" href="#" onclick="deleteAnswerVote(' . $row['id'] . ',1); return false;">' . parent::$modules_lang['msg_25'] . '</a></td><td><input type="text" class="forum_input PopupElementInput" style="width:250px !important" maxlength="100" size="50" value="' . stripcslashes($row['answers']) . '" name="vote_replic[' . $row['id'] . ']" autocomplete="off"></td></tr>';
      }
      $option['return'] = '<form action="" id="vote_editor" name="vote_editor" method="post"><table class="popupTableForum"><tbody><tr><th class="w15" scope="col">&nbsp;</th><th scope="col">' . parent::$modules_lang['topic_116'] . '</th></tr><tr><td style="border-bottom:none">&nbsp;</td><td style="border-bottom:none"><input type="text" class="forum_input PopupElementInput" style="width:250px !important" maxlength="200" size="50" value="' . stripcslashes($option['poll']['vote_question']) . '" id="vote_titl" name="vote_titl" autocomplete="off"></td></tr></tbody></table><table class="popupTableForum"><tbody><tr><th class="w15" scope="col">&nbsp;</th><th scope="col">' . parent::$modules_lang['topic_91'] . '</th></tr>' . $option['return'] . '<tr><tr id="insert"> </tr><td style="border-bottom:none">&nbsp;</td><td style="border-bottom:none"><a onclick="addReplicVotePopup(); return false;" href="#">' . parent::$modules_lang['topic_92'] . '</a></td></tr></tbody></table><table class="popupTableForum"><tbody><tr><th scope="col" class="w15">&nbsp;</th><th scope="col">&nbsp;</th><th scope="col">&nbsp;</th></tr><tr><td>&nbsp;</td><td><label><input type="checkbox" ' . $option['isViewUserVoted'] . ' name="vote_visible_poll" id="news_fixed" value="1">' . parent::$modules_lang['topic_94'] . '</label></td><td><label><input type="checkbox" ' . $option['isMulti'] . ' name="vote_multi" id="news_fixed" value="1">' . parent::$modules_lang['topic_93'] . '</label></td></tr></tbody></table><input type="hidden" name="id_poll" value="' . $option['id'] . '"></form>';
      return $this->getJson(array('param' => '1', 'data' => $option['return']));
   }
   public function deleteWarning()
   {
      if(!$this->ckeckModulesConfigGroup('be_warning_delete') or !parent::$modules_config['widget_warning']) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $option['row'] = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_user_warning WHERE id = {$option['id']} LIMIT 1");
      if(empty($option['row']['post_id'])) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['user'] = $this->db->super_query("SELECT forum_warning,user_id FROM " . PREFIX . "_users WHERE user_id = {$option['row']['id_user']} LIMIT 1");
      if(empty($option['user']['user_id'])) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['user']['forum_warning'] = (int)$option['user']['forum_warning'];
      if($option['row']['action'] == 'up' and $option['row']['date'] <= $this->time) {
         $option['user']['forum_warning'] = $option['user']['forum_warning'] - $option['row']['ball'];
      } elseif($option['row']['action'] == 'down' and $option['row']['date'] <= $this->time) {
         $option['user']['forum_warning'] = $option['user']['forum_warning'] + $option['row']['ball'];
      }
      if($option['user']['forum_warning'] > parent::$modules_config['widget_warning_count']) {
         $option['user']['forum_warning'] = parent::$modules_config['widget_warning_count'];
      } elseif($option['user']['forum_warning'] < 0) {
         $option['user']['forum_warning'] = 0;
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_user_warning WHERE id = {$option['row']['id']} LIMIT 1");
      $this->db->query("UPDATE " . PREFIX . "_users SET forum_warning = {$option['user']['forum_warning']} WHERE user_id = {$option['row']['id_user']} LIMIT 1");
      $this->db->query("UPDATE " . PREFIX . "_be_message SET is_warning_id = 0 WHERE id = {$option['row']['post_id']} LIMIT 1");
      $this->_checkBallWarning($option['row']['id_user']);
      $this->_userBanned($option['row']['id_user']);
   }
   private function _setDefaultJsonInfo($errorInfo = '', $type = 0)
   {
      if(empty($type)) {
         if(empty($errorInfo)) {
            $errorInfo = parent::$modules_lang['msg_59'];
         }
         return $this->getJson(array('param' => '0', 'data' => $errorInfo));
      } else {
         return $this->getJson(array('param' => '1', 'data' => $errorInfo));
      }
   }
   public function setWarning()
   {
      if(!$this->ckeckModulesConfigGroup('be_warning') or !parent::$modules_config['widget_warning']) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option = array();
      $option['id'] = $this->getInt('id');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die($this->_setDefaultJsonInfo('', 0));
      $option['action'] = strtolower($this->getString('action'));
      $option['action'] = $option['action'] == 'up' ? $option['action'] : 'down';
      $option['ball'] = $this->getInt('ball');
      $option['ball'] = $option['ball'] > parent::$modules_config['widget_warning_count'] ? parent::$modules_config['widget_warning_count'] : $option['ball'];
      $option['ball'] = abs($option['ball']);
      if(empty($option['ball']) and $option['action'] == 'up') {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_90'], 0);
      }
      $option['row'] = $this->db->super_query("SELECT autors_id FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
      if(empty($option['row'])) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['row'] = $this->db->super_query("SELECT forum_warning,user_id FROM " . PREFIX . "_users WHERE user_id = {$option['row']['autors_id']} LIMIT 1");
      $option['row']['forum_warning'] = (int)$option['row']['forum_warning'];
      if($option['row']['forum_warning'] == parent::$modules_config['widget_warning_count'] and $option['action'] == 'up') {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_60'], 0);
      }
      if($option['row']['forum_warning'] < 0 and $option['action'] == 'down') {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_61'], 0);
      }
      if($option['row']['forum_warning'] + $option['ball'] > parent::$modules_config['widget_warning_count'] and $option['action'] == 'up') {
         $option['ballRow'] = $option['row']['forum_warning'] + $option['ball'] - parent::$modules_config['widget_warning_count'];
         $option['ball'] = $option['ball'] - $option['ballRow'];
      }
      if($option['row']['forum_warning'] - $option['ball'] < 0 and $option['action'] == 'down') {
         $option['ball'] = parent::$modules_config['widget_warning_count'] - (max($option['ball'], $option['row']['forum_warning']) - min($option['ball'], $option['row']['forum_warning']));
      }
      $option['textWarning'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim(strip_tags($this->convert_unicode($_POST['response'], parent::$dle_config['charset'])))), false));
      if($option['action'] == 'up') {
         $this->db->query("INSERT INTO " . PREFIX . "_be_user_warning (id, moderator_id, post_id, date, description, id_user, date_out, ball, action) VALUES (NULL, {$this->userID}, {$option['id']}, {$this->time}, '{$option['textWarning']}', {$option['row']['user_id']}, 0, {$option['ball']}, '{$option['action']}')");
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_warning = forum_warning + {$option['ball']} WHERE user_id = {$option['row']['user_id']} LIMIT 1");
      } else {
         $this->db->query("INSERT INTO " . PREFIX . "_be_user_warning (id, moderator_id, post_id, date, description, id_user, date_out, ball, action) VALUES (NULL, {$this->userID}, {$option['id']}, {$this->time}, '{$option['textWarning']}', {$option['row']['user_id']}, 0, {$option['ball']}, '{$option['action']}')");
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_warning = forum_warning - {$option['ball']} WHERE user_id = {$option['row']['user_id']} LIMIT 1");
      }
      $this->_checkBallWarning($option['row']['user_id']);
      $this->_userBanned($option['row']['user_id']);
      return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_62'], 1);
   }
   private function _userBanned($userID = 0)
   {
      $option = array();
      if(empty(parent::$modules_config['widget_warning_bann'])) {
         $option['time'] = 0;
      } else {
         $option['time'] = $this->time + (intval(parent::$modules_config['widget_warning_bann']) * 86400);
      }
      $option['row'] = $this->db->super_query("SELECT forum_warning,user_id FROM " . PREFIX . "_users WHERE user_id = {$userID} LIMIT 1");
      if($option['row']['forum_warning'] >= parent::$modules_config['widget_warning_count']) {
         $this->db->query("SELECT * FROM " . PREFIX . "_banned WHERE users_id = {$userID} LIMIT 1");
         if($this->db->num_rows()) {
            return false;
         }
         $this->db->query("UPDATE " . PREFIX . "_users SET banned = 'yes' WHERE user_id = {$userID} LIMIT 1");
         $this->db->query("INSERT " . PREFIX . "_banned (id, users_id, descr, date, days, ip) VALUES (NULL, {$userID}, '" . parent::$modules_lang['msg_58'] . "', {$option['time']}, " . parent::$modules_config['widget_warning_bann'] . ", '')");
      } else {
         $this->db->query("DELETE FROM " . PREFIX . "_banned WHERE users_id = {$userID} LIMIT 1");
         $this->db->query("UPDATE " . PREFIX . "_users SET banned = '' WHERE user_id = {$userID} LIMIT 1");
      }
      @unlink(ENGINE_DIR . '/cache/system/banned.php');
   }
   private function _checkBallWarning($userID = 0)
   {
      if(empty($userID)) {
         return false;
      }
      $option = array();
      $userID = (int)$userID;
      $option['row'] = $this->db->super_query("SELECT forum_warning,user_id FROM " . PREFIX . "_users WHERE user_id = {$userID} LIMIT 1");
      $this->db->query("SELECT * FROM " . PREFIX . "_be_user_warning AS wn WHERE wn.id_user = {$option['row']['user_id']}");
      $option['userBall'] = 0;
      //var_dump($option);
      if($this->db->num_rows()) {

         while ($row = $this->db->get_row()) {
            if($row['action'] == 'up') {
               $option['userBall'] = $option['userBall'] + $row['ball'];
            } else {
               $option['userBall'] = $option['userBall'] - $row['ball'];
            }
         }
         if($option['userBall'] > parent::$modules_config['widget_warning_count']) {
            $option['userBall'] = parent::$modules_config['widget_warning_count'];
         } elseif($option['userBall'] < 0) {
            $option['userBall'] = 0;
         }
         if($option['userBall'] != $option['row']['forum_warning']) {
            $this->db->query("UPDATE " . PREFIX . "_users SET forum_warning = {$option['userBall']} WHERE user_id = {$option['row']['user_id']} LIMIT 1");
         } else {
            return false;
         }
      } else {
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_warning = 0 WHERE user_id = {$option['row']['user_id']} LIMIT 1");
      }
   }
   public function warning()
   {
      $option = array();
      $option['action'] = strtolower($this->getString('action'));
      if($option['action'] == 'post') {
         $option['id'] = $this->getInt('id') > 0 ? $this->getInt('id') : die($this->_setDefaultJsonInfo('', 0));
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['type'] = $this->getInt('log_warn');
      $option['type'] = $option['type'] > 0 ? 1 : 0;
      if(!parent::$modules_config['widget_warning']) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['row'] = $this->db->super_query("SELECT is_warning_id,id_topic,message_autor,autors_id FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
      if(empty($option['row']['id_topic'])) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      if(!empty($option['row']['is_warning_id'])) {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['topic_89'], 0);
      }
      if($option['type'] == 0 and $this->userID != $option['row']['autors_id']) {
         return $this->_setDefaultJsonInfo('', 0);
      } elseif($option['type'] == 1 and !$this->ckeckModulesConfigGroup('be_warning')) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $this->_checkBallWarning($option['row']['autors_id']);
      $option['userDb'] = $this->db->super_query("SELECT forum_warning,user_id FROM " . PREFIX . "_users WHERE user_id = {$option['row']['autors_id']} LIMIT 1");
      $this->_checkBallWarning($option['userDb']['user_id']);
      $this->_userBanned($option['userDb']['user_id']);
      $this->db->query("SELECT wn.*,user.name FROM " . PREFIX . "_be_user_warning AS wn LEFT JOIN " . PREFIX . "_users as user ON(wn.moderator_id=user.user_id) WHERE id_user = {$option['row']['autors_id']}");
      if(!$this->db->num_rows()) {
         $option['data'] = parent::$modules_lang['msg_46'];
      } else {
         $option['countWarning'] = $this->db->num_rows();
         $option['data'] = '<div id="tablePopupMax"><table class="popupTableForum"><tbody><tr><th scope="col" class="w90">' . parent::$modules_lang['msg_47'] . '</th><th scope="col" class="w250">' . parent::$modules_lang['msg_48'] . '</th><th scope="col">' . parent::$modules_lang['msg_49'] . '</th> <th scope="col">' . parent::$modules_lang['msg_51'] . '</th><th scope="col" class="unsetWarning">&nbsp;</th></tr>';
         while ($row = $this->db->get_row()) {
            if($row['action'] == 'up' and $row['ball'] > 0) {
               $row['lng'] = '<i style="color:red;font-style:normal">' . parent::$modules_lang['msg_52'] . '</i>';
            } elseif($row['action'] == 'down' and $row['ball'] > 0) {
               $row['lng'] = '<i style="color:green;font-style:normal">' . parent::$modules_lang['msg_53'] . '</i>';
            } else {
               $row['lng'] = '<i style="color:green;font-style:normal">' . parent::$modules_lang['msg_57'] . '</i>';
            }
            if($row['moderator_id'] == $this->userID and $this->ckeckModulesConfigGroup('be_warning_delete')) {
               $row['unset'] = '<a onclick="doWarningDelete(' . $row['id'] . '); return false;" class="unsetWarningLinck" href="#" title="' . parent::$modules_lang['msg_54'] . '">' . parent::$modules_lang['msg_25'] . '</a>';
            }
            $option['data'] .= '<tr><td>' . parent::$linck->card_user(array($row['name'], $row['moderator_id'])) . $row['name'] . '</a>' . '</td><td>' . stripcslashes($row['description']) . '</td><td>' . $row['ball'] . '</td><td>' . $row['lng'] . '</td><td>' . $row['unset'] . '</td></tr>';
         }
         $option['data'] .= '</tbody></table></div><div style="margin-top:5px;overflow:hidden">' . parent::$modules_lang['topic_88'] . $option['userDb']['forum_warning'] . '</div>';
      }
      return $this->getJson(array('param' => '1', 'title' => parent::$modules_lang['msg_45'] . $option['row']['message_autor'], 'data' => $option['data'], 'user' => $option['row']['message_autor'], 'ball_user' => $option['userDb']['forum_warning']));
   }
   public function getPreview()
   {
      $option = array();
      $option['id'] = $this->getInt('id') > 0 ? $this->getInt('id') : die('ERROR1');
      $option['rowTopic'] = $this->db->super_query("SELECT id_parent, title, reply_count FROM " . PREFIX . "_be_topic WHERE id = {$option['id']} LIMIT 1");
      if(empty($option['rowTopic']['id_parent'])) {
         die('ERROR2');
      }
      if(!$this->_checkTreeConfigParam('tree_access_topic_read', $option['rowTopic']['id_parent'])) {
         die('ERROR3');
      }
      $this->db->query("SELECT post.id, post.id_topic, post.autors_id, post.message_autor, post.message_date, post.message_text, post.tree_id, user.foto FROM " . PREFIX . "_be_message AS post LEFT JOIN " . PREFIX . "_users AS user ON post.autors_id = user.user_id WHERE id_topic = {$option['id']} ORDER BY id ASC LIMIT 1");
      $this->_renderPreviewContent(parent::$modules_lang['topic_81'], $option['rowTopic']['title']);
      if(!empty($option['rowTopic']['reply_count'])) {
         $this->db->query("SELECT post.id, post.id_topic, post.autors_id, post.message_autor, post.message_date, post.message_text, post.tree_id, user.foto FROM " . PREFIX . "_be_message AS post LEFT JOIN " . PREFIX . "_users AS user ON post.autors_id = user.user_id WHERE id_topic = {$option['id']} ORDER BY id DESC LIMIT 1");
         $this->_renderPreviewContent(parent::$modules_lang['topic_82'], $option['rowTopic']['title']);
      }
      return $this->getJson(array('param' => '1', 'data' => '<ol style="display:none" id="topicPreview">' . $this->viewer->tpl->result['preview_topic'] . '</ol>'));
   }
   private function _renderPreviewContent($lng = '', $nameTopic = '')
   {
      $row = array();
      $row = $this->db->get_row();
      if(empty($row)) {
         return false;
      }
      $row['foto'] = $this->_isAvatar($row['foto']);
      $row['lng'] = $lng;
      $row['message_date'] = $this->_setData($row['message_date']);
      $row['nameTopic'] = $this->totranslit($nameTopic, true, true);
      $this->viewer->setTplPreviewTopic($row);
   }
   private function _setData($data = 0)
   {
      $data = (int)$data;
      if(date('Ymd', $data) == date('Ymd', $this->time)) {
         return parent::$modules_lang['time_heute'] . $this->langdate(", H:i", $data);
      } elseif(date('Ymd', $data) == date('Ymd', ($this->time - 86400))) {
         return parent::$modules_lang['time_gestern'] . $this->langdate(", H:i", $data);
      } else {
         return $this->langdate('j F  H:i', $data);
      }
   }
   private function _isAvatar($img = '')
   {
      return empty($img) ? parent::$dle_config['http_home_url'] . 'templates/' . parent::$dle_config['skin'] . '/bullet_energy/images/noavatar.png' : parent::$dle_config['http_home_url'] . 'uploads/fotos/' . $img;
   }
   public function voteResult()
   {
      if(!parent::$logged_is) {
         die('ERROR CODE 1');
      }
      $option = array();
      $option['id'] = $this->getInt('vote_id') ? $this->getInt('vote_id') : die('ERROR CODE 2');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      if(!$this->db->num_rows()) {
         die('ERROR CODE 3');
      }
      $row = $this->db->get_row();
      $row['answers'] = unserialize($row['answers']);
      if(parent::$logged_is and $this->ckeckModulesConfigGroup('be_replic_vote')) {
         foreach ($row['answers'] as $key => $value) {
            if(isset($value['user_vote'][$this->userID])) {
               $row['isPoll'][] = $key;
            }
         }
      }
      $option['return'] .= '<div class="resultAjax"><table class="boxResultPoll"><tbody>';
      foreach ($row['answers'] as $key => $value) {
         if(in_array($key, $row['isPoll'])) {
            $value['marker'] = ' title="' . parent::$modules_lang['topic_72'] . '"';
            $value['markerCss'] = ' class="isVotedAnswer"';
            $value['markerStarts'] = ' * ';
         }
         if($row['visible_vote_user'] and $value['count'] > 0 and parent::$logged_is) {
            $value['counLine'] = "<td class=\"countVoted\"><a href=\"#\" onclick=\"doVoteAllAnswer('{$option['id']}','{$key}'); return false;\">{$value['count']} " . parent::$modules_lang['topic_73'] . "</a></td>";
         } else {
            $value['counLine'] = "<td class=\"countVoted\">{$value['count']} " . parent::$modules_lang['topic_73'] . "</td>";
         }
         $option['return'] .= "<tr {$value['markerCss']}><td class=\"isVoted\">{$value['markerStarts']}</td><th class=\"answerVoted\" {$value['marker']}>{$value['answers']}</th>
  <td class=\"widthVoted\"><span class=\"lineBox\"><span style=\"width:" . round((250 * $value['count']) / $row['vote_count'], 0) . "px\" class=\"line\"></span> </span></td>
  <td class=\"countVoted\">{$value['counLine']}</td>
  <td class=\"percentVoted\">" . round((100 * $value['count']) / $row['vote_count'], 2) . "%</td></tr>";
      }
      $option['return'] .= '</tbody></table></div>';
      return $this->getJson(array('param' => '1', 'data' => $option['return']));
   }
   public function voteAll()
   {
      if(!parent::$logged_is) {
         die('die');
      }
      $row = array();
      $option = array();
      $option['id'] = $this->getInt('id') ? $this->getInt('id') : die('die');
      $option['idAnswer'] = $this->getInt('id_answer') ? $this->getInt('id_answer') : die('die');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['id']} LIMIT 1");
      if(!$this->db->num_rows()) {
         return false;
      }
      $row = $this->db->get_row();
      $row['answers'] = unserialize($row['answers']);
      if(empty($row['answers'][$option['idAnswer']]) or empty($row['answers'][$option['idAnswer']]['user_vote'])) {
         die('0');
      }
      $option['return'][] = '<li class="infoUserTrophies infoBall">' . parent::$modules_lang['topic_76'] . $row['answers'][$option['idAnswer']]['answers'] . '</li>';
      foreach ($row['answers'][$option['idAnswer']]['user_vote'] as $value) {
         $option['return'][] = '<li>' . parent::$linck->setLinckCardUser(array($value['userName'], $value['userId'])) . $value['userName'] . '</a>' . '</li>';
      }
      $option['return'] = '<ol style="height:100px" class="likeAllContent">' . implode('', $option['return']) . '</ol>';
      return $this->getJson(array('param' => '1', 'data' => $option['return'], 'titl' => parent::$modules_lang['topic_75'] . stripcslashes($row['vote_question'])));
   }
   public function vote()
   {
      if(!parent::$logged_is or !$this->ckeckModulesConfigGroup('be_replic_vote')) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $option['voteId'] = $this->getInt('vote_id');
      $option['voteId'] = $option['voteId'] > 0 ? $option['voteId'] : 0;
      if(empty($option['voteId'])) {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $this->db->query("SELECT * FROM " . PREFIX . "_be_poll WHERE vote_id = {$option['voteId']} LIMIT 1");
      $row = $this->db->num_rows() ? $this->db->get_row() : die($this->_setDefaultJsonInfo('', 0));
      $row['answers'] = unserialize($row['answers']);
      if(is_array($_REQUEST['vote_set'])) {
         $option['id'] = $this->_arrayCheck($_REQUEST['vote_set'], array('setType' => 'int', 'setTypeNull' => 'unset'));
         if(empty($option['id'])) {
            return $this->_setDefaultJsonInfo('', 0);
         }
         foreach ($option['id'] as $value) {
            if(!isset($row['answers'][$value])) {
               continue;
            }
            $row['answers'][$value]['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
            $row['answers'][$value]['count'] = $row['answers'][$value]['count'] + 1;
            $row['vote_count'] = $row['vote_count'] + 1;
            $option['answers'] = $this->db->super_query("SELECT user_vote FROM " . PREFIX . "_be_poll_answers WHERE id = {$value}");
            $option['answers']['user_vote'] = unserialize($option['answers']['user_vote']);
            $option['answers']['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
            $option['answers']['user_vote'] = $this->db->safesql(serialize($option['answers']['user_vote']));
            $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET user_vote = '{$option['answers']['user_vote']}', answers_count = answers_count + 1 WHERE id = {$value} LIMIT 1");
            $this->db->query("INSERT INTO " . PREFIX . "_be_poll_log (user_id, answers_id, vote_id, vote_date) VALUES ({$this->userID}, {$value}, {$option['voteId']}, {$this->time}) ON DUPLICATE KEY UPDATE vote_date = {$this->time}");
         }
      } elseif(is_string($_REQUEST['vote_set'])) {
         $option['id'] = $this->getInt('vote_set');
         if(!isset($row['answers'][$option['id']]) or empty($option['id'])) {
            return $this->_setDefaultJsonInfo('', 0);
         }
         $row['answers'][$option['id']]['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
         $row['answers'][$option['id']]['count'] = $row['answers'][$option['id']]['count'] + 1;
         $row['vote_count'] = $row['vote_count'] + 1;
         $option['answers'] = $this->db->super_query("SELECT user_vote FROM " . PREFIX . "_be_poll_answers WHERE id = {$option['id']}");
         $option['answers']['user_vote'] = unserialize($option['answers']['user_vote']);
         $option['answers']['user_vote'][$this->userID] = array('userId' => $this->userID, 'userName' => $this->userName, 'time' => $this->time);
         $option['answers']['user_vote'] = $this->db->safesql(serialize($option['answers']['user_vote']));
         $this->db->query("UPDATE " . PREFIX . "_be_poll_answers SET user_vote = '{$option['answers']['user_vote']}', answers_count = answers_count + 1 WHERE id = {$option['id']} LIMIT 1");
         $this->db->query("INSERT INTO " . PREFIX . "_be_poll_log (user_id, answers_id, vote_id, vote_date) VALUES ({$this->userID}, {$option['id']}, {$option['voteId']}, {$this->time}) ON DUPLICATE KEY UPDATE vote_date = {$this->time}");
      } else {
         return $this->_setDefaultJsonInfo('', 0);
      }
      $row['answers'] = $this->db->safesql(serialize($row['answers']));
      $this->db->query("UPDATE " . PREFIX . "_be_poll SET answers = '{$row['answers']}', vote_count = {$row['vote_count']} WHERE vote_id = {$option['voteId']} LIMIT 1");
      return $this->voteResult();
   }
   public function unLockMessage()
   {
      $option = array();
      $option['idPost'] = $this->getInt('id') > 0 ? $this->getInt('id') : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_38'])));
      $this->db->query("SELECT id_topic,fixap_msg FROM " . PREFIX . "_be_message WHERE id = {$option['idPost']} LIMIT 1");
      $option['row'] = $this->db->num_rows() ? $this->db->get_row() : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_37'])));
      if(empty($option['row']['id_topic'])) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_37'])));
      }
      $this->db->query("SELECT is_fixed_count,id_parent FROM " . PREFIX . "_be_topic WHERE id = {$option['row']['id_topic']} LIMIT 1");
      $option['rowTopic'] = $this->db->num_rows() ? $this->db->get_row() : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_36'])));
      if(empty($option['rowTopic']['id_parent'])) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_36'])));
      }
      if(!$this->checkModerator($option['rowTopic']['id_parent']) or !$this->ckeckModulesConfigGroup('be_fix')) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_41'])));
      }
      $this->db->query("UPDATE " . PREFIX . "_be_message SET fixap_msg = 0 WHERE id = {$option['idPost']} LIMIT 1");
      $option['countFix'] = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_message WHERE fixap_msg = 1 AND id_topic = {$option['row']['id_topic']}");
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET is_fixed_count = {$option['countFix']['count']} WHERE id = {$option['row']['id_topic']} LIMIT 1");
      return $this->getJson(array('param' => '1', 'data' => parent::$modules_lang['msg_40'], 'linck' => '<a id="lockPost-' . $option['idPost'] . '" onclick="lockPost(\'' . $option['idPost'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_34'] . '</a>'));
   }
   public function lockMessage()
   {
      $option = array();
      $option['idPost'] = $this->getInt('id') > 0 ? $this->getInt('id') : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_38'])));
      $this->db->query("SELECT id_topic,fixap_msg FROM " . PREFIX . "_be_message WHERE id = {$option['idPost']} LIMIT 1");
      $option['row'] = $this->db->num_rows() ? $this->db->get_row() : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_37'])));
      if(empty($option['row']['id_topic'])) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_37'])));
      }
      $this->db->query("SELECT is_fixed_count,id_parent FROM " . PREFIX . "_be_topic WHERE id = {$option['row']['id_topic']} LIMIT 1");
      $option['rowTopic'] = $this->db->num_rows() ? $this->db->get_row() : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_36'])));
      if(empty($option['rowTopic']['id_parent'])) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_36'])));
      }
      if(!$this->checkModerator($option['rowTopic']['id_parent']) or !$this->ckeckModulesConfigGroup('be_fix')) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_41'])));
      }
      $this->db->query("UPDATE " . PREFIX . "_be_message SET fixap_msg = 1 WHERE id = {$option['idPost']} LIMIT 1");
      $option['countFix'] = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_message WHERE fixap_msg = 1 AND id_topic = {$option['row']['id_topic']}");
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET is_fixed_count = {$option['countFix']['count']} WHERE id = {$option['row']['id_topic']} LIMIT 1");
      return $this->getJson(array('param' => '1', 'data' => parent::$modules_lang['msg_39'], 'linck' => '<a id="lockPost-' . $option['idPost'] . '" onclick="UnLockPost(\'' . $option['idPost'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_35'] . '</a>'));
   }
   public function unFeed()
   {
      $option = array('idTopic' => $this->get('arrUnFeed', array(), 'array'));
      if(!parent::$logged_is or empty($option)) {
         die($this->getJson(array('param' => '0', 'data' => 'ERROR')));
      }
      $option['idTopic'] = $this->_arrayCheck($option['idTopic'], array('setType' => 'int', 'setTypeNull' => 'unset'));
      if(empty($option['idTopic'])) {
         die($this->getJson(array('param' => '0', 'data' => 'ERROR')));
      }
      $option['blockDelete'] = '#topic_item-' . implode(', #topic_item-', $option['idTopic']);
      $option['idTopic'] = implode(', ', $option['idTopic']);
      $this->db->query("DELETE FROM " . PREFIX . "_be_feed WHERE id_topic IN ({$option['idTopic']}) AND id_user = " . parent::$id_member['user_id']);
      $row = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_feed WHERE id_user = " . parent::$id_member['user_id']);
      if(empty($row['count'])) {
         return $this->getJson(array('param' => '2', 'data' => '<li class="noAnswerTopic">' . parent::$modules_lang['topicFeedNo'] . '</li>'));
      } else {
         return $this->getJson(array('param' => '1', 'data' => $option['blockDelete']));
      }
   }
   public function recountUser()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option = array('start' => $this->getInt('startfrom'), 'buffer' => '', 'step' => 0);
      $row = array();
      $data = array();
      $this->db->query("SELECT user_id
                      FROM " . PREFIX . "_users
                      LIMIT {$option['start']} , 30");
      while ($row = $this->db->get_row()) {
         $data[$row['user_id']] = array();
         foreach ($row as $key => $value) {
            $data[$row['user_id']][$key] = intval($value);
         }
         $option['step']++;
      }
      foreach ($data as $key => $value) {
         $data[$key]['post'] = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_message WHERE autors_id = {$value['user_id']}");
         $data[$key]['topic'] = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_topic WHERE autor_id = {$value['user_id']}");
         $data[$key]['like'] = $this->db->super_query("SELECT COUNT(*) AS count FROM " . PREFIX . "_be_thanks WHERE thanks_msg_id_user = {$value['user_id']}");
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_post_count = {$data[$key]['post']['count']}, forum_topic_count = {$data[$key]['topic']['count']}, forum_thanks_count = {$data[$key]['like']['count']} WHERE user_id = {$value['user_id']} LIMIT 1");
      }
      $option['countSql'] = $option['start'] + $option['step'];
      return "{\"status\": \"ok\",\"limitcount\": {$option['countSql']}}";
   }
   public function userTrophiesAll()
   {
      $option = array();
      $option['id'] = $this->getInt('id_user') ? $this->getInt('id_user') : die('0');
      $this->db->query("SELECT name, forum_inseption FROM " . PREFIX . "_users WHERE user_id = {$option['id']} LIMIT 1");
      $option['row'] = $this->db->num_rows() ? $this->db->get_row() : die('1');
      $option['row']['forum_inseption'] = unserialize($option['row']['forum_inseption']);
      //
      //bals
      foreach ($option['row']['forum_inseption']['honor'] as $value) {
         $option['return'] .= '<li class="infoUserTrophies"><h3>' . parent::$honor[$value]['criteria']['name'] . '</h3><div class="infoTrophies">' . parent::$honor[$value]['criteria']['desc'] . '</div><div title="' . parent::$modules_lang['trophies_8'] . parent::$honor[$value]['bals'] . parent::$modules_lang['trophies_7'] . '" class="balsTrophies">' . parent::$honor[$value]['bals'] . '</div></li>';
      }
      $option['return'] .= '<li class="infoUserTrophies infoBall">' . parent::$modules_lang['trophies_5'] . count($option['row']['forum_inseption']['honor']) . parent::$modules_lang['trophies_6'] . $option['row']['forum_inseption']['bals'] . parent::$modules_lang['trophies_7'] . '</li>';
      $option['return'] = $this->getJson('<ol class="boxUserTrophies">' . $option['return'] . '</ol>');
      return '{"param": "1","data": ' . $option['return'] . ',"titl": "' . parent::$modules_lang['trophies_4'] . $option['row']['name'] . '"}';
   }
   public function redirect()
   {
      $syfixPage = parent::$modules_config['cpu'] ? parent::$router['page'] : 'page=';
      $syfixPageGo = parent::$modules_config['cpu'] ? '/' : '&';
      $page = $this->getInt('go_page') > 0 ? $this->getInt('go_page') : 1;
      $localIsPage = intval(end(explode($syfixPage, $this->getString('local'))));
      $localIsPage = $localIsPage ? $localIsPage : 1;
      $locationForum = explode('/', $this->getString('local'));
      $locationForumId = intval(end(explode('-', $locationForum[2])));
      $locationForum = reset(explode('-', $locationForum[2])); //cat || topic
      if($localIsPage == $page) {
         return $this->getJson(array('param' => '0', 'data' => parent::$modules_lang['goPage1']));
      }
      switch ($locationForum) {
         case 'categories':
            if($page > 1) {
               $result = parent::$linck->treeLinck($locationForumId, $this->totranslit(parent::$treePermanent[$locationForumId]['tree_title'], true, true)) . $syfixPageGo . $syfixPage . $page;
            } else {
               $result = parent::$linck->treeLinck($locationForumId, $this->totranslit(parent::$treePermanent[$locationForumId]['tree_title'], true, true));
            }
            break;
         case 'showtopic':
            if(empty($locationForumId)) {
               return $this->getJson(array('param' => '0', 'data' => $result));
            }
            $option['title'] = $this->db->super_query("SELECT title FROM " . PREFIX . "_be_topic where id = {$locationForumId}");
            if(empty($option['title'])) {
               return $this->getJson(array('param' => '0', 'data' => $result));
            }
            $option['title'] = $this->totranslit($option['title'], true, true);
            if($page > 1) {
               $result = parent::$linck->topicIsRedirect($locationForumId, $option['title']) . $syfixPageGo . $syfixPage . $page;
            } else {
               $result = parent::$linck->topicIsRedirect($locationForumId, $option['title']);
            }
            break;
         default:
            return $this->getJson(array('param' => '0', 'data' => parent::$modules_lang['goPage2']));
            break;
      }
      return $this->getJson(array('param' => '1', 'data' => $result));
   }
   public function totranslit($var, $lower = true, $punkt = true)
   {
      //dle function
      $langtranslit = parent::$translit_local;
      if(is_array($var))
         return "";
      if(!is_array($langtranslit) or !count($langtranslit)) {
         $langtranslit = array('' => 'a', '' => 'b', '' => 'v', '' => 'g', '' => 'd', '' => 'e', '' => 'e', '' => 'zh', '' => 'z', '' => 'i', '' => 'y', '' => 'k', '' => 'l', '' => 'm', '' => 'n', '' => 'o', '' => 'p', '' => 'r', '' => 's', '' => 't', '' => 'u', '' => 'f', '' => 'h', '' => 'c', '' => 'ch', '' => 'sh', '' => 'sch', '' => '', '' => 'y', '' => '', '' => 'e', '' => 'yu', '' => 'ya', "" => "yi", "" => "ye", '' => 'A', '' => 'B', '' => 'V', '' => 'G', '' => 'D', '' => 'E', '' => 'E', '' => 'Zh', '' => 'Z', '' => 'I', '' => 'Y', '' => 'K', '' => 'L', '' => 'M', '' => 'N', '' => 'O', '' => 'P', '' => 'R', '' => 'S', '' => 'T', '' => 'U', '' => 'F', '' => 'H', '' => 'C', '' => 'Ch', '' => 'Sh', '' => 'Sch', '' => '', '' => 'Y', '' => '', '' => 'E', '' => 'Yu', '' => 'Ya', "" => "yi", "" => "ye", );
      }
      $var = trim(strip_tags($var));
      $var = preg_replace("/\s+/ms", "-", $var);
      $var = strtr($var, $langtranslit);
      if($punkt)
         $var = preg_replace("/[^a-z0-9\_\-.]+/mi", "", $var);
      else
         $var = preg_replace("/[^a-z0-9\_\-]+/mi", "", $var);
      $var = preg_replace('#[\-]+#i', '-', $var);
      if($lower)
         $var = strtolower($var);
      $var = str_ireplace(".php", "", $var);
      $var = str_ireplace(".php", ".ppp", $var);
      if(strlen($var) > 200) {
         $var = substr($var, 0, 200);
         if(($temp_max = strrpos($var, '-')))
            $var = substr($var, 0, $temp_max);
      }
      return $var;
   }
   public function deleteTree()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $option['idRemoveContent'] = $this->getInt('id_remove');
      $this->db->query("SELECT tree_topic,tree_parent_id FROM " . PREFIX . "_be_tree WHERE tree_id = {$option['id']}");
      $row = $this->db->num_rows() ? $this->db->get_row() : die('die');
      // $option['whereUpdate'] = count($this->_getChildTree($option['id'])) > 0 ? 'IN(' . implode(',', $this->_getChildTree($option['id'])) . ')' : '=' . $option['id'];
      if(count($this->_getChildTree($option['id']))) {
         $option['whereUpdate'] = 'IN(' . implode(',', $this->_getChildTree($option['id'])) . ',' . $option['id'] . ')';
      } else {
         $option['whereUpdate'] = '=' . $option['id'];
      }
      if($option['idRemoveContent'] > 0) {
         $this->db->query("UPDATE " . PREFIX . "_be_topic SET id_parent = {$option['idRemoveContent']} WHERE id_parent {$option['whereUpdate']}");
         $this->db->query("UPDATE " . PREFIX . "_be_message SET tree_id = {$option['idRemoveContent']} WHERE tree_id {$option['whereUpdate']}");
         $this->db->query("UPDATE " . PREFIX . "_be_feed SET id_tree = {$option['idRemoveContent']} WHERE id_tree {$option['whereUpdate']}");
      } else {
         $this->db->query("DELETE FROM " . PREFIX . "_be_topic WHERE id_parent {$option['whereUpdate']}");
         $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE tree_id {$option['whereUpdate']}");
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_tree WHERE tree_id {$option['whereUpdate']}");
      $this->_cacheDeleteAll();
      return 'ok';
   }
   private function _getChildTree($id = 0, array $arrTree = array())
   {
      foreach (parent::$treePermanent as $child) {
         if($child['tree_parent_id'] == $id) {
            $arrTree[] = intval($child['tree_id']);
            $arrTree = $this->_getChildTree($child['tree_id'], $arrTree);
         }
      }
      return $arrTree;
   }
   private function _checkTreeConfigParam($val = '', $id = '')
   {
      return in_array(parent::$id_member['user_group'], explode(',', parent::$treePermanent[$id][$val])) ? true : false;
   }
   public function deleteCache()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $this->_cacheDeleteAll();
      return 'ok';
   }
   public function deleteComplain()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $this->db->query("DELETE FROM " . PREFIX . "_be_complaint WHERE ct_id = {$option['id']} LIMIT 1");
      return 'ok';
   }
   public function deleteTrophies()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_honor WHERE id = {$option['id']}");
      if(!$this->db->num_rows()) {
         die('die');
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_honor WHERE id = {$option['id']} LIMIT 1");
      return 'ok';
   }
   public function deleteRank()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_user_title WHERE id = {$option['id']}");
      if(!$this->db->num_rows()) {
         die('die');
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_user_title WHERE id = {$option['id']} LIMIT 1");
      return 'ok';
   }
   public function deleteMessageOnlyAdmin()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $this->db->query("SELECT parent_msg,id_topic FROM " . PREFIX . "_be_message WHERE id = {$option['id']}");
      if(!$this->db->num_rows()) {
         die('die');
      }
      $row = $this->db->get_row();
      if($row['parent_msg']) {
         $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
         $this->db->query("DELETE FROM " . PREFIX . "_be_topic WHERE id = {$row['id_topic']} LIMIT 1");
         $this->db->query("SELECT * FROM " . PREFIX . "_be_complaint WHERE ct_msg_id = {$option['id']}");
         while ($row = $this->db->get_row()) {
            $option['idCompline'][] = $row['ct_id'];
         }
         $this->db->query("DELETE FROM " . PREFIX . "_be_complaint WHERE ct_id = " . implode(',', $option['idCompline']) . " LIMIT 1");
      } else {
         $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
         $this->db->query("SELECT * FROM " . PREFIX . "_be_complaint WHERE ct_msg_id = {$option['id']}");
         while ($row = $this->db->get_row()) {
            $option['idCompline'][] = $row['ct_id'];
         }
         $this->db->query("DELETE FROM " . PREFIX . "_be_complaint WHERE ct_id = " . implode(',', $option['idCompline']) . " LIMIT 1");
      }
      return 'ok';
   }
   public function feed()
   {
      $option = array();
      $row = array();
      $option['id'] = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['topic_57']))); //topic.id_parent
      //feed.id_user
      //topic.id_parent
      $this->db->query("SELECT topic.*, feed.*, feed.id as feedId
                      FROM " . PREFIX . "_be_topic AS topic
                      LEFT JOIN " . PREFIX . "_be_feed AS feed
                      ON (topic.id = feed.id_topic)
                      AND topic.id_parent = feed.id_tree
                      AND feed.id_user = {$this->userID}
                      WHERE topic.id = {$option['id']}
                      LIMIT 1");
      $row = $this->db->num_rows() ? $this->db->get_row() : die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['topic_57']))); //var_dump($row);
      if(!in_array($row['id_parent'], explode(',', $this->_getGroupIdParseTree()))) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['topic_56'])));
      }
      if($row['id_user'] == null) {
         $this->db->query("INSERT INTO " . PREFIX . "_be_feed 
      (id, id_user, id_topic, id_tree, date, is_mail) VALUES (NULL, '{$this->userID}', '{$option['id']}', '{$row['id_parent']}', '{$this->time}', 'no')");
         return $this->getJson(array('param' => '1', 'data' => '<a id="feedClick" href="#" class="optionTopic" onclick="topicFeed(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['topic_55'] . '</a>', 'sub' => parent::$modules_lang['topic_58'] . stripcslashes($row['title']) . '.' . parent::$modules_lang['topic_60']));
      } elseif($row['feedId']) {
         $this->db->query("DELETE FROM " . PREFIX . "_be_feed WHERE id = {$row['feedId']} LIMIT 1");
         return $this->getJson(array('param' => '1', 'data' => '<a id="feedClick" href="#" class="optionTopic" onclick="topicFeed(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['topic_54'] . '</a>', 'sub' => parent::$modules_lang['topic_59'] . stripcslashes($row['title'])));
      }
   }
   private function _getGroupIdParseTree()
   {
      return count(array_intersect(explode(',', parent::$sys_cashe['accessTreeView']), explode(',', parent::$sys_cashe['accessTopicView']))) ? $this->db->safesql(implode(',', array_intersect(explode(',', parent::$sys_cashe['accessTreeView']), explode(',', parent::$sys_cashe['accessTopicView'])))) : 0;
   }
   public function likeAll()
   {
      $option = array();
      $row = array();
      $option['id'] = $this->getInt('id') ? $this->getInt('id') : die('die');
      $this->db->query("SELECT msg.id, topic.title, topic.id as topId
                      FROM " . PREFIX . "_be_message AS msg
                      LEFT JOIN " . PREFIX . "_be_topic AS topic 
                      ON ( msg.id_topic = topic.id )
                      WHERE msg.id = {$option['id']}");
      $option = $this->db->num_rows() ? $this->db->get_row() : die('die');
      $option['countPostPosition'] = $this->db->super_query("SELECT COUNT(*) as count 
                                   FROM " . PREFIX . "_be_message AS msg
                                   WHERE id_topic = '{$option['topId']}'
                                   AND id <= {$option['id']}");
      $this->db->query("SELECT likes.thanks_date,user.name,user.foto,user.forum_post_count,user.forum_topic_count, 
                             user.forum_thanks_count,user.user_id,user.user_group
                             FROM " . PREFIX . "_be_thanks AS likes
                             LEFT JOIN " . PREFIX . "_users AS user
                             ON likes.thanks_id_user = user.user_id
                             WHERE likes.thanks_msg_id = '{$option['id']}'");
      while ($row = $this->db->get_row()) {
         $row['userLinck'] = parent::$linck->setLinckCardUser(array($row['name'], $row['user_id'])) . $row['name'] . '</a>';
         $row['avatar'] = trim($row['foto']) ? parent::$dle_config['http_home_url'] . 'uploads/fotos/' . $row['foto'] : parent::$dle_config['http_home_url'] . 'templates/' . parent::$dle_config['skin'] . '/bullet_energy/images/noavatar.png';
         $option['return'][] = '<li>' . parent::$linck->setLinckCardUser(array($row['name'], $row['user_id'])) . '<img src="' . $row['avatar'] . '" alt="" /></a><div class="memberInfo"><h3>' . $row['name'] . '</h3><div class="groupUser">' . parent::$group_user[$row['user_group']]['group_name'] . '</div><div><dl><dt>' . parent::$modules_lang['user_10'] . '</dt><dd>' . $row['forum_post_count'] . '</dd><dt>' . parent::$modules_lang['user_11'] . '</dt><dd>' . $row['forum_topic_count'] . '</dd><dt>' . parent::$modules_lang['user_12'] . '</dt><dd>' . $row['forum_thanks_count'] . '</dd></dl></div></div></li>';
      }
      $option['return'] = $this->getJson('<ol class="likeAllContent">' . implode('', $option['return']) . '</ol>');
      return '{"param": "1","data": ' . $option['return'] . ',"titl": "' . parent::$modules_lang['user_13'] . $option['countPostPosition']['count'] . '"}';
   }
   public function like()
   {
      $option = array();
      $option['id'] = $this->getInt('id') ? $this->getInt('id') : die('die');
      $this->db->query("SELECT msg.user_thanks, msg.autors_id, msg.thanks, likes.thanks_id
                      FROM " . PREFIX . "_be_message AS msg
                      LEFT JOIN " . PREFIX . "_be_thanks AS likes
                      ON likes.thanks_msg_id = msg.id
                      AND likes.thanks_id_user = {$this->userID}
                      WHERE msg.id = {$option['id']}");
      $row = $this->db->num_rows() ? $this->db->get_row() : die('die');
      if(!$row['thanks_id']) {
         $this->db->query("INSERT INTO " . PREFIX . "_be_thanks
      (thanks_id, thanks_msg_id, thanks_id_user, thanks_date, thanks_msg_id_user) 
      VALUES (NULL, '{$option['id']}', '{$this->userID}', '{$this->time}', '{$row['autors_id']}')");
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_thanks_count = forum_thanks_count + 1 WHERE user_id = {$row['autors_id']} LIMIT 1");
         if($row['thanks'] == 0) {
            $option['updateArrayLike'] = $this->db->safesql(serialize(array(array($this->userName, $this->userID))));
            $option['likeBlock'] = '<div class="likeBox-' . $option['id'] . '"><div>' . $this->viewer->card_user(array($this->userName, $this->userID)) . $this->userName . '</a>' . parent::$modules_lang['like_2'] . '</div></div>';
            $this->db->query("UPDATE " . PREFIX . "_be_message SET user_thanks = '{$option['updateArrayLike']}', thanks = thanks + 1 WHERE id = {$option['id']} LIMIT 1");
            return $this->getJson(array('param' => '1', 'linck' => '<a class="likeContent" href="#" onclick="like(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_1'] . '</a>', 'likeBlock' => $option['likeBlock']));
         } else {
            $row['user_thanks'] = unserialize($row['user_thanks']);
            if(count($row['user_thanks']) < 3) {
               array_push($row['user_thanks'], array($this->userName, $this->userID));
               foreach ($row['user_thanks'] as $key => $value) {
                  $option['fetchLike'][] = $this->viewer->card_user(array($value[0], $value[1])) . $value[0] . '</a>';
               }
               if(($row['thanks'] - 3) > 0) {
                  $option['sorseAll'] = $row['thanks'] - 3;
                  $option['likeUserAll'] = parent::$modules_lang['like_3'] . $option['sorseAll'];
               }
               $option['likeBlock'] = '<div class="likeBox-' . $option['id'] . '"><div>' . implode(', ', $option['fetchLike']) . $option['likeUserAll'] . parent::$modules_lang['like_2'] . '</div></div>';
               $option['updateArrayLike'] = $this->db->safesql(serialize($row['user_thanks']));
               $this->db->query("UPDATE " . PREFIX . "_be_message SET user_thanks = '{$option['updateArrayLike']}', thanks = thanks + 1 WHERE id = {$option['id']} LIMIT 1");
               return $this->getJson(array('param' => '1', 'linck' => '<a class="likeContent" href="#" onclick="like(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_1'] . '</a>', 'likeBlock' => $option['likeBlock']));
            } else {
               //$row['user_thanks'] = unserialize($row['user_thanks']);
               foreach ($row['user_thanks'] as $key => $value) {
                  $option['fetchLike'][] = $this->viewer->card_user(array($value[0], $value[1])) . $value[0] . '</a>';
               }
               $option['sorseAll'] = ($row['thanks'] + 1) - 3;
               $option['likeUserAll'] = parent::$modules_lang['like_4'] . '<a href="#" onclick="getAllLike(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_3'] . $option['sorseAll'] . '</a>';
               $option['likeBlock'] = '<div class="likeBox-' . $option['id'] . '"><div>' . implode(', ', $option['fetchLike']) . $option['likeUserAll'] . parent::$modules_lang['like_2'] . '</div></div>';
               $this->db->query("UPDATE " . PREFIX . "_be_message SET thanks = thanks + 1 WHERE id = {$option['id']} LIMIT 1");
               return $this->getJson(array('param' => '1', 'linck' => '<a class="likeContent" href="#" onclick="like(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_1'] . '</a>', 'likeBlock' => $option['likeBlock']));
            }
         }
         //forum_thanks_count
      } else {
         $option['unsetIs'] = false;
         $row['user_thanks'] = unserialize($row['user_thanks']);
         foreach ($row['user_thanks'] as $key => $value) {
            $option['sqlUpdate'][] = ' AND likes.thanks_id_user != ' . $value[1];
            if($value[1] == $this->userID) {
               unset($row['user_thanks'][$key]);
               $option['unsetIs'] = true;
            }
         }
         if($option['unsetIs']) {
            $this->db->query("SELECT * FROM " . PREFIX . "_be_thanks as likes
                                             LEFT JOIN " . PREFIX . "_users as user
                                             ON (likes.thanks_id_user = user.user_id)
                                             WHERE likes.thanks_msg_id = {$option['id']}" . implode(' ', $option['sqlUpdate']) . ' LIMIT 1');
            if($this->db->num_rows()) {
               $rowUpdate = $this->db->get_row();
               array_push($row['user_thanks'], array($rowUpdate['name'], $rowUpdate['user_id']));
            }
         }
         if(($row['thanks'] - 1) > 0) {
            foreach ($row['user_thanks'] as $key => $value) {
               $option['fetchLike'][] = $this->viewer->card_user(array($value[0], $value[1])) . $value[0] . '</a>';
            }
            if(($row['thanks'] - 4) > 0) {
               $option['sorseAll'] = $row['thanks'] - 4;
               $option['likeUserAll'] = parent::$modules_lang['like_4'] . '<a href="#" onclick="getAllLike(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_3'] . $option['sorseAll'] . '</a>';
            }
            $option['likeBlock'] = '<div class="likeBox-' . $option['id'] . '"><div>' . implode(', ', $option['fetchLike']) . $option['likeUserAll'] . parent::$modules_lang['like_2'] . '</div></div>';
         } else {
            $option['likeBlock'] = '<div class="likeBox-' . $option['id'] . '"></div>';
         }
         $row['user_thanks'] = ($row['thanks'] - 1) > 0 ? $this->db->safesql(serialize($row['user_thanks'])) : '';
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_thanks_count = IF(forum_thanks_count > 1, forum_thanks_count - 1, 0) WHERE user_id = {$row['autors_id']} LIMIT 1");
         $this->db->query("UPDATE " . PREFIX . "_be_message 
                        SET user_thanks = '{$row['user_thanks']}',
                        thanks = IF(thanks > 1, thanks - 1, 0) 
                        WHERE id = {$option['id']} LIMIT 1");
         $this->db->query("DELETE FROM " . PREFIX . "_be_thanks 
                        WHERE thanks_id = {$row['thanks_id']} LIMIT 1");
         return $this->getJson(array('param' => '1', 'linck' => '<a class="likeContent" href="#" onclick="like(\'' . $option['id'] . '\'); return false;">' . parent::$modules_lang['like_0'] . '</a>', 'likeBlock' => $option['likeBlock']));
      }
   }
   public function topicOptionEdit()
   {
      $option = array();
      $option['id'] = $this->getInt('id') ? $this->getInt('id') : die('die');
      $this->db->query("SELECT * FROM " . PREFIX . "_be_topic WHERE id = {$option['id']}");
      $row = $this->db->num_rows() ? $this->db->get_row() : die('die');
      $option['title'] = htmlspecialchars(stripcslashes($row['title']));
      $option['fixed'] = intval($row['topic_fixed']) ? 'checked' : '';
      $option['type'] = intval($row['topic_type']) == 0 ? 'checked' : '';
      if($this->ckeckModulesConfigGroup('be_moder_top_rename')) {
         $option['return']['rename'] = '<div class="paramBox"><p>' . parent::$modules_lang['topic_12'] . '</p><input type="text" maxlength="255"   value="' . $option['title'] . '" name="titl"></div>';
      }
      if($this->ckeckModulesConfigGroup('be_moder_topic_wanted')) {
         $option['return']['wanted'] = '<li><label title="' . parent::$modules_lang['topic_14'] . '"><input type="checkbox" ' . $option['fixed'] . ' name="fixed">' . parent::$modules_lang['topic_13'] . '</label></li>';
      }
      if($this->ckeckModulesConfigGroup('be_moder_close_to_open_topic')) {
         $option['return']['open'] = '<li><label title="' . $lang['topic_15'] . '"><input type="checkbox" ' . $option['type'] . ' name="status">' . parent::$modules_lang['topic_15'] . '</label></li>';
      }
      if($this->ckeckModulesConfigGroup('be_moder_del_user_topic')) {
         $option['return']['delete'] = '<option value="0">' . parent::$modules_lang['topic_52'] . '</option>';
      }
      if($this->ckeckModulesConfigGroup('be_moder_moder_access') and !parent::$modules_config['moder_disable']) {
         if($row['topic_approve']) {
            $option['isAprove'] = 'selected="selected"';
         } else {
            $option['isNoAprove'] = 'selected="selected"';
         }
         $option['return']['visible'] = "<option {$option['isNoAprove']} value=\"2\">" . parent::$modules_lang['topic_50'] . "</option><option {$option['isAprove']} value=\"1\">" . parent::$modules_lang['topic_51'] . "</option>";
      }
      if(parent::$modules_config['moder_disable']) {
         $option['return']['visible'] = '<option selected="selected" value="10">---</option>';
      }
      if($option['return']['delete'] or $option['return']['visible']) {
         $option['return']['statusTopic'] = "<select id=\"visible_param\" name=\"visible_param\">{$option['return']['visible']}{$option['return']['delete']}</select>";
      }
      if($option['return']['open'] or $option['return']['wanted'] or $option['return']['statusTopic']) {
         $option['return']['ul'] = '<div class="paramBox"><ul class="topicEdit">' . $option['return']['open'] . $option['return']['wanted'] . $option['return']['statusTopic'] . '</ul></div>';
      }
      $option['sels'] = '<div class="paramBox"><p>' . parent::$modules_lang['topic_64'] . '</p><select name="new_tree" id="new_tree">' . $this->_setSelectTree($row['id_parent'], 0, false, '', '', '') . '</select></div>';
      $option['return']['desc'] = '<div class="paramBox"><p>' . parent::$modules_lang['topic_97'] . '</p><textarea id="option_topic" name="option_topic" cols="" class="option_topic_popup" rows="9">' . stripcslashes($row['topic_descr_site']) . '</textarea></div>';
      if(count($option['return'])) {
         return '<div class="inertOptionPopup">' . $option['return']['rename'] . $option['sels'] . $option['return']['ul'] . $option['return']['desc'] . '<input type="hidden" value="' . $row['id'] . '" name="idTopic"></div>';
      }
   }
   private function _setSelectTree($categoryid = 0, $parentid = 0, $nocat = true, $sublevelmarker = '', $returnstring = '', $deflang = '')
   {
      $root_category = array();
      if($parentid == 0) {
         if($nocat)
            $returnstring .= '<option disabled value="0">' . $deflang . '</option>';
      } else {
         $sublevelmarker .= '&nbsp;&nbsp;&nbsp;';
      }
      if(count(parent::$treePermanent)) {
         foreach (parent::$treePermanent as $cats) {
            if($cats['tree_parent_id'] == $parentid)
               $root_category[] = $cats['tree_id'];
         }
         if(count($root_category)) {
            foreach ($root_category as $id) {
               $sels = parent::$treePermanent[$id]['tree_type'] == '0' ? 'disabled' : '';
               $returnstring .= "<option {$sels} value=\"" . $id . '" ';
               if(is_array($categoryid)) {
                  foreach ($categoryid as $element) {
                     if($element == $id)
                        $returnstring .= 'SELECTED';
                  }
               } elseif($categoryid == $id)
                  $returnstring .= 'SELECTED';
               $returnstring .= '>' . $sublevelmarker . parent::$treePermanent[$id]['tree_title'] . '</option>';
               $returnstring = $this->_setSelectTree($categoryid, $id, $nocat, $sublevelmarker, $returnstring);
            }
         }
      }
      return $returnstring;
   }
   /**
    * BulletAjaxHandler::recountTree()
    *        .
    * @return
    */
   public function recountTree()
   {
      $option = array();
      foreach (parent::$treePermanent as $key => $value) {
         $row = $this->db->super_query("SELECT COUNT(*) as countTopic FROM " . PREFIX . "_be_topic WHERE id_parent = {$key} LIMIT 1");
         $option['countTopic'] = intval($row['countTopic']);
         $row = $this->db->super_query("SELECT COUNT(*) as countMessage FROM " . PREFIX . "_be_message WHERE tree_id = {$key} LIMIT 1");
         $option['countMessage'] = intval($row['countMessage']);
         $this->db->query("UPDATE " . PREFIX . "_be_tree  SET tree_topic = {$option['countTopic']}, tree_answer = {$option['countMessage']}  WHERE tree_id = {$key} LIMIT 1");
      }
      $this->_cacheDeleteAll();
      return 'ok';
   }
   /**
    * BulletAjaxHandler::recountTopicLast()
    *        .
    * @return void
    */
   public function recountTopicLast()
   {
      if(!$this->_checkAdmin()) {
         die('die');
      }
      $option = array('start' => $this->getInt('startfrom'), 'buffer' => '', 'step' => 0);
      $row = array();
      $this->db->query("SELECT id, title, last_reply_date FROM " . PREFIX . "_be_topic LIMIT {$option['start']} , 10");
      while ($row = $this->db->get_row()) {
         $data[$row['id']] = array();
         foreach ($row as $key => $value) {
            $data[$row['id']][$key] = stripcslashes($value);
         }
         $option['step']++;
      }
      $postData = array();
      foreach ($data as $key => $value) {
         $postData[$key] = $this->db->super_query("SELECT message.message_autor as name, 
                                            message.id AS post_id, 
                                            message.autors_id, 
                                            user.foto 
                                     FROM " . PREFIX . "_be_message AS message
                                     LEFT JOIN " . PREFIX . "_users AS user 
                                     ON message.autors_id = user.user_id
                                     WHERE message.id_topic = {$key}
                                     ORDER BY message.message_date DESC
                                     LIMIT 1");
         if(!$postData[$key]['post_id']) {
            continue;
         }
         $data[$key]['counts'] = $this->db->super_query("SELECT COUNT(*) AS countPage
                                                     FROM " . PREFIX . "_be_message AS msg
                                                     WHERE id_topic = {$key}
                                                     AND id <= {$postData[$key]['post_id']}");
         $data[$key] = array_merge($postData[$key], $data[$key]);
      }
      $updateSql = array();
      foreach ($data as $keyData => $valueData) {
         if(!$valueData['id'] or !$valueData['post_id']) {
            continue;
         }
         $valueData['counts'] = $this->db->super_query("SELECT COUNT(*) as countPage
                                                     FROM " . PREFIX . "_be_message AS msg
                                                     WHERE id_topic = '{$valueData['id']}'
                                                     AND id <= {$valueData['post_id']}");
         $valueData['page'] = ceil($valueData['counts']['countPage'] / parent::$modules_config['message_count_page']);
         $valueData['page'] = $valueData['page'] == 1 ? '' : "/" . parent::$router['page'] . "{$valueData['page']}";
         $valueData['page'] = parent::$linck->topicIsRedirect($valueData['id'], $this->totranslit($valueData['title'])) . $valueData['page'] . '#message-' . $valueData['post_id'];
         $valueData['last'] = $this->_generateLastPostInfo(array($valueData['name'], $valueData['last_reply_date'], $valueData['title'], $valueData['page'], $valueData['foto'], $valueData['autors_id']));
         $updateSql[] = "UPDATE " . PREFIX . "_be_topic SET last_reply_info = '{$valueData['last']}' WHERE id = {$valueData['id']} LIMIT 1";
      }
      if(count($updateSql)) {
         foreach ($updateSql as $sql) {
            $this->db->query($sql);
         }
      }
      $option['countSql'] = $option['start'] + $option['step'];
      $buffer = "{\"status\": \"ok\",\"limitcount\": {$option['countSql']}}";
      die($buffer);
   }
   /**
    * BulletAjaxHandler::recountTreeLast()
    *        .
    * @return
    */
   public function recountTreeLast()
   {
      $row = array();
      $option = array();
      $this->db->query("SELECT tree_id FROM " . PREFIX . "_be_tree WHERE tree_answer > 0");
      if(!$this->db->num_rows()) {
         return 'die';
      }
      $tpm_ = array();
      while ($row = $this->db->get_row()) {
         foreach ($row as $key => $value) {
            $tpm_[] = $row['tree_id'];
         }
      }
      foreach ($tpm_ as $key => $value) {
         $row = $this->db->super_query("SELECT user.foto, 
                                            topic.title, 
                                            message.autors_id,
                                            message.id as post_id, 
                                            topic.id as topic_id, 
                                            message.message_autor as name,
                                            message.tree_id,
                                            message.message_date   
                                     FROM " . PREFIX . "_be_message AS message
                                     LEFT JOIN " . PREFIX . "_users AS user ON (
                                       message.autors_id = user.user_id
                                     )
                                     LEFT JOIN " . PREFIX . "_be_topic AS topic ON (
                                       message.id_topic = topic.id
                                     )
                                     WHERE 
                                       tree_id = {$value} 
                                     ORDER BY message.message_date  DESC
                                     LIMIT 1");
         $option[$row['tree_id']] = array();
         foreach ($row as $key => $value) {
            $option[$row['tree_id']][$key] = stripslashes($value);
         }
      }
      $updateSql = array();
      foreach ($option as $keyData => $valueData) {
         $valueData['counts'] = $this->db->super_query("SELECT COUNT(*) as countPage
                                                     FROM " . PREFIX . "_be_message AS msg
                                                     WHERE id_topic = '{$valueData['topic_id']}'
                                                     AND id <= {$valueData['post_id']}");
         $valueData['page'] = ceil($valueData['counts']['countPage'] / parent::$modules_config['message_count_page']);
         $valueData['page'] = $valueData['page'] == 1 ? '' : "/" . parent::$router['page'] . "{$valueData['page']}";
         $valueData['page'] = parent::$linck->topicIsRedirect($valueData['topic_id'], $this->totranslit($valueData['title'], true, true)) . $valueData['page'] . '#message-' . $valueData['post_id'];
         $valueData['last'] = $this->_generateLastPostInfo(array($valueData['name'], $valueData['message_date'], $valueData['title'], $valueData['page'], $valueData['foto'], $valueData['autors_id']));
         $updateSql[] = "UPDATE " . PREFIX . "_be_tree SET tree_last_info = '{$valueData['last']}' WHERE tree_id = {$valueData['tree_id']} LIMIT 1";
      }
      if(count($updateSql)) {
         $this->db->query("UPDATE " . PREFIX . "_be_tree SET tree_last_info = ''");
         foreach ($updateSql as $sql) {
            $this->db->query($sql);
         }
      }
      return 'ok';
   }
   /**
    * BulletAjaxHandler::moderatorDelete()
    *         (admin only)
    * @return
    */
   public function moderatorDelete()
   {
      $id = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $row = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_moderator WHERE id = {$id} LIMIT 1");
      if(!$this->_checkAdmin() or !$row['count']) {
         die('die');
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_moderator WHERE id = {$id} LIMIT 1");
      $this->_cacheDeleteAll();
      return 'ok';
   }
   /**
    * BulletAjaxHandler::advertisingDelete()
    *         (admin only)
    * @return
    */
   public function advertisingDelete()
   {
      $id = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $row = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_advertising WHERE advertising_id = {$id} LIMIT 1");
      if(!$this->_checkAdmin() or !$row['count']) {
         die('die');
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_advertising WHERE advertising_id = {$id} LIMIT 1");
      $this->_cacheDeleteAll();
      return 'ok';
   }
   /**
    * BulletAjaxHandler::questionsDelete()
    *   /     (admin only)
    * @return
    */
   public function questionsDelete()
   {
      $id = $this->getInt('id') ? $this->db->safesql($this->getInt('id')) : die('die');
      $row = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_question WHERE id = {$id} LIMIT 1");
      if(!$this->_checkAdmin() or !$row['count']) {
         die('die');
      }
      $this->db->query("DELETE FROM " . PREFIX . "_be_question WHERE id = {$id} LIMIT 1");
      $this->_cacheDeleteAll();
      return 'ok';
   }
   /**
    * BulletAjaxHandler::_cacheDeleteAll()
    *     ,        .
    * @return void
    */
   private function _cacheDeleteAll()
   {
      if(file_exists($this->casheSysDir . 'groups_config.tmp')) {
         @unlink($this->casheSysDir . 'groups_config.tmp');
      }
      if(file_exists($this->casheSysDir . 'question.tmp')) {
         @unlink($this->casheSysDir . 'question.tmp');
      }
      if(file_exists($this->casheSysDir . 'moderator.tmp')) {
         @unlink($this->casheSysDir . 'moderator.tmp');
      }
      if(file_exists($this->casheSysDir . 'tree_permanent.tmp')) {
         @unlink($this->casheSysDir . 'tree_permanent.tmp');
      }
      if(file_exists($this->casheSysDir . 'advertising.tmp')) {
         @unlink($this->casheSysDir . 'advertising.tmp');
      }
      $this->db->query("SELECT be_groups_id FROM " . PREFIX . "_be_groups ORDER BY be_groups_id ASC");
      while ($row = $this->db->get_row()) {
         if(file_exists($this->casheSysDir . 'sys_cashe_group_' . $row['be_groups_id'] . '.tmp')) {
            @unlink($this->casheSysDir . 'sys_cashe_group_' . $row['be_groups_id'] . '.tmp');
         }
      }
   }
   /**
    * BulletAjaxHandler::_checkAdmin()
    *      ,   ,   1   .
    * @return
    */
   private function _checkAdmin()
   {
      if(strip_tags($_POST['hash']) != parent::$login_hash) {
         die('die');
      }
      return intval(parent::$id_member['user_group']) == 1 ? true : false;
   }
   public function msgEditAjaxProcess()
   {
      if(!parent::$logged_is or strip_tags($_GET['hash']) != parent::$login_hash) {
         die($this->getJson(array('param' => '0', 'data' => 'die')));
      }
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_message WHERE id = {$this->id} LIMIT 1");
      if(!$row['id']) {
         die($this->getJson(array('param' => '0', 'data' => 'die')));
      }
      $edit = false; //:TODO is null time:
      if($row['autors_id'] == $this->userID and parent::$group_config[parent::$id_member['user_group']]['be_access_edit_my_post']) {
         $edit = true;
      } elseif($row['autors_id'] != $this->userID and parent::$group_config[parent::$id_member['user_group']]['be_moder_edit_message_user']) {
         $edit = true;
      } else {
         $edit = false;
      }
      if(!$edit) {
         die($this->getJson(array('param' => '0', 'data' => 'die')));
      }
      if($this->ckeckModulesConfigGroup('be_upload_img') or $this->ckeckModulesConfigGroup('be_upload')) {
         $this->db->query("SELECT attachment_id,attachment_type,attachment_name,attachment_date 
                        FROM " . PREFIX . "_be_attachment  
                        WHERE (attachment_user_id = {$row['autors_id']} OR attachment_user_id ={$this->userID})
                        AND (attachment_content_id = {$row['id']} OR attachment_content_id =0)
                        AND (attachment_user_name = '{$row['message_autor']}' OR attachment_user_name = '{$this->userName}')
                        ORDER BY attachment_id DESC");
         if($this->db->num_rows()) {
            while ($rows = $this->db->get_row()) {
               $data['fileType'] = intval($rows['attachment_type']);
               $data['fileExtensions'] = $this->_getExtensions($rows['attachment_name']);
               $data['fileDateUpload'] = date('Y-m', $rows['attachment_date']);
               $data['fileName'] = $rows['attachment_name'];
               $data['fileNameSiteView'] = substr($rows['attachment_name'], 10, 100);
               $data['fileDbId'] = $rows['attachment_id'];
               $cash .= $this->viewer->setTplAttachmentList($data);
            }
         }
         if($cash) {
            $isData = '';
         } else {
            $isData = 'style="display:none"';
         }
         if($this->ckeckModulesConfigGroup('be_upload')) {
            $ext .= parent::$modules_config['upload_file_type'];
         }
         if($this->ckeckModulesConfigGroup('be_upload_img')) {
            $ext .= ', gif, jpg, png, jpe, jpeg';
         }
         $bullet_energy_config = parent::$modules_config;
         $config = parent::$dle_config;
         $libraryForum = '/engine/bullet_energy/library';
         $arrayLoad[] = '<link media="screen" href="' . $libraryForum . '/colorpicker/colorpicker.css" type="text/css" rel="stylesheet" />';
         $arrayLoad[] = '<link media="screen" href="' . $libraryForum . '/upload/upload.css" type="text/css" rel="stylesheet" />';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/colorpicker/colorpicker.js"></script>';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/colorpicker/eye.js"></script>';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/colorpicker/utils.js"></script>';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/bbcode/bbcodes.js"></script>';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/upload/upload.js"></script>';
         $arrayLoad[] = '<script type="text/javascript" src="' . $libraryForum . '/upload/swfobject.js"></script>';
         $optionLoad = array('session' => session_id(), 'extWindow' => implode(', .', explode(',', $bullet_energy_config['upload_file_type'])) . ', .gif, .jpg, .png, .jpe, .jpeg', 'extLoad' => '*.' . implode(';*.', explode(',', $bullet_energy_config['upload_file_type'])) . ';*.gif;*.jpg;*.png;*.jpe;*.jpeg', 'sizeLimit' => intval($bullet_energy_config['upload_max_size']) * 1024);
         if($bullet_energy_config['mass_upload'] == '1') {
            $optionLoad['mass'] = "'multi' : true,";
            $optionLoad['massCount'] = "'queueSizeLimit' :" . intval($bullet_energy_config['upload_count_file']) . ",";
         } else {
            $optionLoad['mass'] = '';
            $optionLoad['massCount'] = '';
         }
         $staticJS = implode("\n", $arrayLoad);
         $staticJS .= <<< HTML
\n<script language="javascript" type="text/javascript">
var imageAlign = '{$bullet_energy_config['float_img']}';
var form = document.getElementById('message_edit_form');
$(document).ready(function(){
   $('#file_upload').uploadify({
    'uploader'  : '{$config['http_home_url']}engine/bullet_energy/library/upload/uploadify.swf',
    'script'    : '{$config['http_home_url']}engine/bullet_energy/ajax/upload.php',
    'cancelImg' : '{$config['http_home_url']}engine/bullet_energy/library/upload/images/cancel.png',
    'buttonImg' : '{$config['http_home_url']}engine/bullet_energy/library/upload/images/buttom.png',
    {$optionLoad['mass']}
    {$optionLoad['massCount']}
    'fileExt'   : '{$optionLoad['extLoad']}',
    'fileDesc'  : 'Files ({$optionLoad['extWindow']})', 
    'width'     : 102,
    'height'    : 25,
    'scriptData': { 'session': '{$optionLoad['session']}'},
    'folder'    : '/uploads/forum/',
    'auto'      : true,
    'onSWFReady'  : function() {
      $(".AjaxFileUpload").show()
    },
    'sizeLimit'   : {$optionLoad['sizeLimit']},
    'onAllComplete' : function(event,data) {
       $.post("{$config['http_home_url']}engine/bullet_energy/ajax/site.php", {be_action:'refresh_list_do_upload',post:form.msg_id.value}, function(data) {
		$("#block_files").fadeOut(500, function() {
			$(this).html(data);
			$(this).fadeIn(500);
			});}); 
   }
});
$('#colorSelector').ColorPicker({
			color: '#0000ff',
			onShow: function (colpkr) {
				$(colpkr).fadeIn(50);
				return false;
			},
			onHide: function (colpkr) {
				$(colpkr).fadeOut(50);
				return false;
			},
           onSubmit: function(hsb, hex, rgb, el) {
            setColor(hex);
            $(".colorpicker").fadeOut(50);
        	},
			onChange: function (hsb, hex, rgb) {
				$('#colorSelector div').css('backgroundColor', '#' + hex);
  }
});  
});
</script>
HTML;
         $cash = $staticJS . '<div style="display:none" class="uploaderMessageFull AjaxFileUpload"><div id="upload_file_block"><div class="InnertMainBoxUpload"><div class="bottom_upload"><div class="innert_buttm"><input id="file_upload" name="file_upload" type="file" /><span class="access_upload"><ul><li><strong>' . parent::$modules_lang['upload_0'] . '</strong>:' . $ext . '</li><li><strong>' . parent::$modules_lang['upload_1'] . '</strong>: ' . $this->formatsize(parent::$modules_config['upload_max_size'] * 1024) . '</li></ul></span></div></div><ol ' . $isData . ' id="block_files">' . $cash . '</ol></div></div></div>';
      }
      /**/
      $text = $this->CreateEdirBlock($this->filter->decodeBBCodes($row['message_text'], false), $row['id_topic'], $row['id'], $cash);
      return $this->getJson(array('param' => '1', 'data' => $text));
   }
   public function formatsize($file_size)
   {
      //dle function
      if($file_size >= 1073741824) {
         $file_size = round($file_size / 1073741824 * 100) / 100 . " Gb";
      } elseif($file_size >= 1048576) {
         $file_size = round($file_size / 1048576 * 100) / 100 . " Mb";
      } elseif($file_size >= 1024) {
         $file_size = round($file_size / 1024 * 100) / 100 . " Kb";
      } else {
         $file_size = $file_size . " b";
      }
      return $file_size;
   }
   public function readTreeProcess()
   {
      $id = $this->db->safesql($this->getInt('id'));
      $time = time() + (parent::$dle_config['date_adjust'] * 60);
      $topicUnreadCheck = $this->db->safesql(parent::$modules_config['topic_count'] * 3);
      $userID = $this->db->safesql(parent::$id_member['user_id']);
      if(!$id or !parent::$logged_is) {
         die('die');
      }
      $row = $this->db->super_query("SELECT tree_id FROM " . PREFIX . "_be_tree WHERE tree_id = {$id}");
      if(!$row) {
         die('die');
      }
      $this->db->query("INSERT INTO " . PREFIX . "_be_read_tree (bert_read_id,bert_user_id,bert_tree_id,bert_read_date) VALUES (NULL,'{$userID}','{$id}','{$time}') ON DUPLICATE KEY UPDATE bert_read_date = {$time}");
      $this->db->query("SELECT id FROM " . PREFIX . "_be_topic WHERE id_parent = {$id} ORDER BY last_reply_date DESC LIMIT 0 , {$topicUnreadCheck}");
      while ($row = $this->db->get_row()) {
         $tableSchema[] = "INSERT INTO " . PREFIX . "_be_read_topic (ber_read_id,ber_user_id,ber_topic_id,ber_tree_id,ber_read_date) VALUES (NULL,'{$userID}','{$row['id']}','{$id}','{$time}') ON DUPLICATE KEY UPDATE ber_read_date = {$time}";
      }
      foreach ($tableSchema as $table) {
         $this->db->query($table);
      }
      return 'ok';
   }
   public function ckeckModulesConfigGroup($val = '')
   {
      return intval(parent::$group_config[parent::$id_member['user_group']][$val]);
   }
   private function CreateEdirBlock($data = '', $idTopic = '', $idMsg = '', $listFile = '')
   {
      $i = 0;
      $smiles = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\"><tr>";
      $smilies = explode(",", parent::$dle_config['smilies']);
      foreach ($smilies as $smile) {
         $i++;
         $smile = trim($smile);
         $smiles .= "<td style=\"padding:2px;\" align=\"center\"><a href=\"#\" onClick=\"dle_smiley(':$smile:'); return false;\"><img style=\"border: none;\" alt=\"$smile\" src=\"" . parent::$dle_config['http_home_url'] . "engine/data/emoticons/$smile.gif\" /></a></td>";
         if($i % 4 == 0)
            $smiles .= "</tr><tr>";
      }
      $smiles .= "</tr></table>";
      $lang = parent::$modules_lang;
      if(parent::$group_user[parent::$id_member['user_group']]['allow_url']) {
         $option['url'] = '<li><span title="' . $lang['bbTitl_10'] . '" onclick="tag_url()" id="b_tag_url"></span></li><li><span title="' . $lang['bbTitl_11'] . '" onclick="tag_leech()" id="b_tag_leech"></span></li>';
      }
      if(parent::$group_user[parent::$id_member['user_group']]['allow_image']) {
         $option['images'] = '<li><span title="' . $lang['bbTitl_12'] . '" onclick="tag_image()" id="b_img"></span></li>';
      }
      $option['fullBB'] = '<li class="b_code"><span title="' . $lang['bbTitl_18'] . '" onclick="simpletag(\'code\')" id="b_code"></span></li><li class="separator"></li><li><span title="' . $lang['bbTitl_16'] . '" onclick="tag_list(\'ol\')" id="b_ol"></span></li><li><span title="' . $lang['bbTitl_17'] . '" onclick="tag_list(\'list\')" id="b_list"></span></li><li class="separator"></li><li class="b_youtube"><span title="' . $lang['bbTitl_15'] . '" onclick="tag_youtube()" id="b_youtube"></span></li><li class="b_tag_video"><span title="' . $lang['bbTitl_20'] . '" onclick="tag_video()" id="b_tag_video"></span></li><li class="b_tag_audio"><span title="' . $lang['bbTitl_19'] . '" onclick="tag_audio()" id="b_tag_audio"></span></li><li title="' . $lang['bbTitl_21'] . '" class="color_swith"><div id="colorSelector">&nbsp;<div></div></div></li>';
      $ret = <<< HTML
    <form action="" id="message_edit_form" name="message_edit_form" method="post">
    <div class="BoxEditMsg">
<script type="text/javascript" language="javascript">
var selField  = "editmsgform";
var fombj    = document.forms['message_edit_form'];
</script>
<div id="bbcode_bullet">
    <ol class="bbcode_forum">
   <li><span title="{$lang['bbTitl_2']}" onclick="simpletag('b')" id="b_b"></span></li>
    <li><span title="{$lang['bbTitl_3']}" onclick="simpletag('i')" id="b_i"></span></li>
    <li><span title="{$lang['bbTitl_4']}" onclick="simpletag('u')" id="b_u"></span></li>
    <li><span title="{$lang['bbTitl_5']}" onclick="simpletag('s')" id="b_s"></span></li> 
    <li class="separator"></li>
    <li><span title="{$lang['bbTitl_7']}" onclick="simpletag('left')" id="b_left"></span></li>
    <li><span title="{$lang['bbTitl_8']}" onclick="simpletag('center')" id="b_center"></span></li>
    <li><span title="{$lang['bbTitl_9']}" onclick="simpletag('right')" id="b_right"></span></li>
    <li class="separator"></li>
    <li><span title="{$lang['bbTitl_6']}" onclick="ins_emo(this);" id="b_emo"></span></li>
    {$option['url']}{$option['images']} 
    <li class="separator"></li>
    <li class="b_hide"><span title="{$lang['bbTitl_13']}" onclick="simpletag('hide')" id="b_hide"></span></li>
    <li><span title="{$lang['bbTitl_14']}" onclick="simpletag('quote')" id="b_quote"></span></li>
    <li><span title="{$lang['bbTitl_1']}" onclick="simpletag('spoiler')" id="b_spoiler"></span></li>
    {$option['fullBB']}
  </ol>
  <div id="bullet_energy_emos" style="display: none;">
    <div style="overflow: auto;">{$smiles}</div>
  </div>
</div>
<textarea rows="8" class="editmsgform" name="editmsgform" id="editmsgform">{$data}</textarea></div>{$listFile}
<div class="EditControl"><a href="javascript:;" onclick="MsgEditSave(); return false;" title="{$lang['msg_9']}">{$lang['msg_10']}</a> <a href="javascript:;" onclick="MsgEditCancel('{$idMsg}'); return false;" title="{$lang['msg_8']}">{$lang['msg_7']}</a></div>
<input type="hidden" value="{$idTopic}" id="topict_id" name="topict_id">
<input type="hidden" value="{$idMsg}" id="msg_id" name="msg_id">
</form>
HTML;
      return $ret;
   }
   public function EditSaveMsgProcess()
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      $option = array('topic_id' => $this->db->safesql($this->getInt('topic_id')), 'msg_id' => $this->db->safesql($this->getInt('msg_id')), 'aprove' => parent::$id_member['user_group'] == 1 ? 1 : 0, );
      if(!$option['topic_id'] or !$option['msg_id']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $row = $this->db->super_query("SELECT title,topic_approve,id_parent FROM " . PREFIX . "_be_topic WHERE id = {$option['topic_id']} LIMIT 1");
      if(!$row['id_parent']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $_POST['topic_name'] = $row['title'];
      $option['topicName'] = $row['title'];
      $option['message'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($this->convert_unicode($_REQUEST['text_msg']))), false));
      $option['id_parent'] = $row['id_parent'];
      if(!$option['message']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_message WHERE id = {$option['msg_id']} LIMIT 1");
      if($row['tree_id'] != $option['id_parent'] or $row['id_topic'] != $option['topic_id']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $edit = false;
      if(in_array(parent::$id_member['user_group'], explode(',', parent::$treePermanent[$row['tree_id']]['tree_access_topic_replic']))) {
         $edit = true;
      }
      if($row['autors_id'] == parent::$id_member['user_id'] and parent::$group_config[parent::$id_member['user_group']]['be_access_edit_my_post'] and $edit) {
         $edit = true;
      } elseif($row['autors_id'] != parent::$id_member['user_id'] and parent::$group_config[parent::$id_member['user_group']]['be_moder_edit_message_user'] and $edit) {
         $edit = true;
      } else {
         $edit = false;
      }
      if($this->_valueStrlen($option['message'], parent::$dle_config['charset']) > parent::$modules_config['message_count'] and $edit) {
         $edit = false;
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_1'])));
      }
      if(!$edit) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $row1 = $this->db->super_query("SELECT count( * ) AS count FROM " . PREFIX . "_be_attachment WHERE attachment_type = 1 AND attachment_user_name = '{$this->userName}' AND attachment_user_id = {$this->userID} AND attachment_content_id = 0");
      $option['messageAttachmentCount'] = $row1['count'] > 0 ? 1 : 0;
      if($this->ckeckModulesConfigGroup('be_upload_img')) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$row['id']}, topic_id = {$option['topic_id']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$this->userName}' AND attachment_content_id = 0 AND attachment_type = 0");
      }
      if($this->ckeckModulesConfigGroup('be_upload') and $option['messageAttachmentCount']) {
         $this->db->query("UPDATE " . PREFIX . "_be_attachment SET attachment_content_id = {$row['id']}, topic_id = {$option['topic_id']} WHERE attachment_user_id = {$this->userID} AND attachment_user_name = '{$this->userName}' AND attachment_content_id = 0 AND attachment_type = 1");
      }
      $this->db->query("UPDATE " . PREFIX . "_be_message SET message_text ='{$option['message']}', message_approve={$option['aprove']}, msg_edit_date={$this->time},  edit_autor='{$this->userName}', attachment  =  {$option['messageAttachmentCount']} WHERE id = {$row['id']} LIMIT 1");
      return $this->getJson(array('param' => '1', 'id' => $row['id'], 'data' => $this->_getMsg($row['id'], $option['topic_id'], $this->totranslit($option['topicName'], true, true))));
   }
   public function refreshAttachmentListProcess()
   {
      $this->db->query("SELECT attachment_id,attachment_type,attachment_name,attachment_date 
                      FROM " . PREFIX . "_be_attachment 
                      WHERE attachment_user_id = '{$this->userID}' 
                      AND attachment_content_id = 0 
                      AND attachment_user_name = '{$this->userName}' 
                      ORDER BY attachment_id DESC");
      if($this->db->num_rows()) {
         while ($row = $this->db->get_row()) {
            $data['fileType'] = intval($row['attachment_type']);
            $data['fileExtensions'] = $this->_getExtensions($row['attachment_name']);
            $data['fileDateUpload'] = date('Y-m', $row['attachment_date']);
            $data['fileName'] = $row['attachment_name'];
            $data['fileNameSiteView'] = substr($row['attachment_name'], 10, 100);
            $data['fileDbId'] = $row['attachment_id'];
            $cash .= $this->viewer->setTplAttachmentList($data);
         }
         return $cash;
      } else {
         return parent::$modules_lang['error_15'];
      }
   }
   public function refreshAttachmentListEditorProcess()
   {
      if(!parent::$logged_is) {
         die('ERROR');
      }
      $option = array();
      $option['id'] = $this->getInt('post');
      $option['id'] = $option['id'] > 0 ? $option['id'] : die('ERROR');
      $this->db->query("SELECT attachment_id,attachment_type,attachment_name,attachment_date 
                      FROM " . PREFIX . "_be_attachment 
                     WHERE attachment_content_id = 0 OR attachment_content_id = {$option['id']}
                      ORDER BY attachment_id DESC");
      if($this->db->num_rows()) {
         while ($row = $this->db->get_row()) {
            $data['fileType'] = intval($row['attachment_type']);
            $data['fileExtensions'] = $this->_getExtensions($row['attachment_name']);
            $data['fileDateUpload'] = date('Y-m', $row['attachment_date']);
            $data['fileName'] = $row['attachment_name'];
            $data['fileNameSiteView'] = substr($row['attachment_name'], 10, 100);
            $data['fileDbId'] = $row['attachment_id'];
            $cash .= $this->viewer->setTplAttachmentList($data);
         }
         return $cash;
      } else {
         return parent::$modules_lang['error_15'];
      }
   }
   private function _getExtensions($fileName = '')
   {
      return substr($fileName, strrpos($fileName, '.') + 1);
   }
   public function TopicEditProcess()
   {
      $id = $this->db->safesql(intval($this->getInt('id')));
      if(!$id) {
         die("die");
      }
      if(!parent::$group_config[parent::$id_member['user_group']]['be_moder_topic_moder_param']) {
         die('die');
      }
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_topic WHERE id = {$id} LIMIT 1");
      if(!$row) {
         die("die");
      }
      $titl = htmlspecialchars(stripcslashes($row['title']));
      $lang = parent::$modules_lang;
      $rename = '';
      $fixed = '';
      $wanted = '';
      $open = '';
      $type = '';
      $visibl = '';
      $del = '';
      $ap = '';
      $noap = '';
      $status = '';
      if(intval($row['topic_fixed'])) {
         $fixed = "checked";
      }
      if(intval($row['topic_type']) == 0) {
         $type = "checked";
      }
      if(parent::$group_config[parent::$id_member['user_group']]['be_moder_top_rename']) {
         $rename = '<div class="boxEditParam"><label>' . $lang['topic_12'] . ': <input type="text" maxlength="255" class="forum_input" value="' . $titl . '" name="titl"></label></div>';
      }
      if(parent::$group_config[parent::$id_member['user_group']]['be_moder_topic_wanted']) {
         $wanted = '<li><label title="' . $lang['topic_14'] . '"><input type="checkbox" ' . $fixed . ' name="fixed">' . $lang['topic_13'] . '</label></li>';
      }
      if(parent::$group_config[parent::$id_member['user_group']]['be_moder_close_to_open_topic']) {
         $open = '<li><label title="' . $lang['topic_15'] . '"><input type="checkbox" ' . $type . ' name="status">' . $lang['topic_15'] . '</label></li>';
      }
      if(parent::$group_config[parent::$id_member['user_group']]['be_moder_del_user_topic']) {
         $del = '<option value="0">' . $lang['topic_114'] . '</option>';
      }
      if(parent::$group_config[parent::$id_member['user_group']]['be_moder_moder_access'] and !parent::$modules_config['moder_disable']) {
         if($row['topic_approve']) {
            $ap = 'selected="selected"';
         } else {
            $noap = 'selected="selected"';
         }
         $visibl = "<option {$noap} value=\"2\">{$lang['topic_113']}</option><option {$ap} value=\"1\"></option>";
      }
      if(parent::$modules_config['moder_disable']) {
         $visibl = '<option selected="selected" value="10">---</option>';
      }
      if($del or $visibl) {
         $status = "<div class=\"boxEditParam\"><label>" . $lang['topic_115'] . "<select id=\"visible_param\" class=\"select_forum\" name=\"visible_param\">{$visibl}{$del}</select></label></div>";
      }
      if($open != '' or $wanted != '') {
         $ul = '<div class="boxEditParam"><ul class="topicEdit">' . $open . $wanted . '</ul></div>';
      }

      $option['sels'] = '<div class="boxEditParam"><label>&nbsp;<select style="width:135px" class="select_forum" name="new_tree" id="new_tree">' . $this->_setSelectTree($row['id_parent'], 0, false, '', '', '') . '</select></label></div>';
      $ret = <<< HTML
<li class="editTopic" id="topic_item_edit-{$row['id']}"><div class="inertBox">{$rename}{$ul}{$option['sels']}{$status}<div class="boxEditParam Bottom"><a href="javascript:;" onclick="saveEditTopic('{$row['id']}'); return false;" class="blackBotton">{$lang['topic_112']}</a><a href="javascript:saveCloze('{$row['id']}')" class="blackBotton">{$lang['topic_111']}</a></div></div></li>
HTML;
      //var_dump($row);
      return $ret;
   }
   private function _userTitle()
   {
      if(!isset(parent::$id_member['forum_inseption']['bals'])) {
         return false;
      }
      $title = 0;
      foreach (parent::$title as $key => $value) {
         if(parent::$id_member['forum_inseption']['bals'] < $value['bals']) {
            continue;
         }
         if(parent::$id_member['forum_inseption']['title'] == $key) {
            return false;
         }
         $title = $key;
         break;
      }
      return $title ? $title : false;
   }
   public function activate()
   {
      if(getenv('REMOTE_ADDR') == '127.0.0.1') {
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_67'], 0);
      }
      $query = "site=" . getenv('HTTP_HOST') . "&key=" . strip_tags($_POST['key']) . "&article=1&time=" . time();
      $post = "POST /activate.php HTTP/1.1\r\n";
      $post .= "Host: white-master.ru\r\n";
      $post .= "Content-type: application/x-www-form-urlencoded\r\n";
      $post .= "User-Agent: Mozilla 4.0\r\n";
      $post .= 'Content-length: ' . strlen($query) . "\r\n";
      $post .= "Connection: close\r\n\r\n$query";
      $connect = fsockopen('white-master.ru', 80, $errno, $errstr, 30);
      if(!$connect) {
         $result = file_get_contents('http://white-master.ru/activate.php?' . $query);
      } else {
         fwrite($connect, $post);
         while (!feof($connect)) {
            $result .= fgets($connect, 1024);
         }
         fclose($connect);
      }
      if(!$connect and !$result) {
         @unlink(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp');
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_68'], 0);
      }
      $result = end(explode('status:', $result));
      if($result == 'ok') {
         $handler = fopen(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp', "w");
         $writes['key'] = strip_tags($_POST['key']);
         $writes['time'] = time();
         $writes['time_marker'] = time() + 432000;
         fwrite($handler, "<?PHP \n\n\$types = array (\n\n");
         foreach ($writes as $name => $value) {
            fwrite($handler, "'{$name}' => \"{$value}\",\n\n");
         }
         fwrite($handler, ");\n\n?>");
         fclose($handler);
         return $this->_setDefaultJsonInfo('refresh', 1);
      } else {
         @unlink(ENGINE_DIR . '/bullet_energy/cache/system/types.tmp');
         return $this->_setDefaultJsonInfo(parent::$modules_lang['msg_65'], 0);
      }
   }
   private function _userTrophies()
   {
      if(count(parent::$honor) == 0) {
         return false;
      }
      $honor = array();
      parent::$id_member['forum_inseption'] = unserialize(parent::$id_member['forum_inseption']);
      foreach (parent::$honor as $key => $value) {
         if(in_array($key, parent::$id_member['forum_inseption']['honor'])) {
            continue;
         }
         if(isset($value['criteria']['day'])) {
            if(floor(($this->time - parent::$id_member['reg_date']) / 86400) < $value['criteria']['day']) {
               continue;
            }
         }
         if(isset($value['criteria']['post'])) {
            if(parent::$id_member['forum_post_count'] < $value['criteria']['post']) {
               continue;
            }
         }
         if(isset($value['criteria']['like'])) {
            if(parent::$id_member['forum_thanks_count'] < $value['criteria']['like']) {
               continue;
            }
         }
         if(!in_array(parent::$id_member['user_group'], $value['criteria']['group'])) {
            continue;
         }
         $honor[] = intval($key);
      }
      return count($honor) > 0 ? $honor : false;
   }
   public function messageAddAjaxProcess()
   {
      $row = $this->db->super_query("SELECT id,title,topic_type,reply_count,topic_approve,id_parent,topic_private_user FROM " . PREFIX . "_be_topic WHERE id = '" . $this->getInt('topic_id') . "' LIMIT 1");
      if(!$row['id']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'])));
      }
      $option = array('topicId' => $this->getInt('topic_id'), 'ipUser' => ip2long($_SERVER['REMOTE_ADDR']), 'idUser' => parent::$id_member['user_id'], 'userName' => parent::$id_member['name'], 'time' => $this->time, 'topicName' => $row['title'], 'topicType' => $row['topic_type'], 'topicReplyCount' => $row['reply_count'], 'topicAprove' => $row['topic_approve'], 'id_parent' => $row['id_parent'], 'topicUserIsPrivate' => $row['topic_private_user'], 'postMsg' => $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($this->convert_unicode($_POST['text_msg']))), false)));
      if(parent::$modules_config['message_count_mini'] and $this->_valueStrlen(str_replace(" ", "", strip_tags($option['postMsg'])), parent::$dle_config['charset']) < parent::$modules_config['message_count_mini']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_0'])));
      }
      if($this->_valueStrlen($option['postMsg'], parent::$dle_config['charset']) > parent::$modules_config['message_count']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_1'])));
      }
      if(!parent::$group_config[parent::$id_member['user_group']]['be_captha_status'] and parent::$id_member['forum_post_count'] < parent::$modules_config['anti_no']) {
         if(parent::$modules_config['captha_type']) {
            $option['jaRefresh'] = '<script type="text/javascript"language="javascript">if(document.getElementById(\'recaptcha_response_field\')){Recaptcha.reload();}</script>';
            if(!trim($_REQUEST['recaptcha_response_field'])) {
               die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_14'] . $option['jaRefresh'])));
            }
            require_once ENGINE_DIR . '/bullet_energy/modules/security.php';
            if($_REQUEST['recaptcha_response_field'] and $_REQUEST['recaptcha_challenge_field']) {
               $resp = recaptcha_check_answer(parent::$modules_config['reprivate'], $_SERVER['REMOTE_ADDR'], $_REQUEST['recaptcha_challenge_field'], $_REQUEST['recaptcha_response_field']);
               if(!$resp->is_valid) {
                  die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_14'] . $option['jaRefresh'])));
               }
            }
         } else {
            $option['jaRefresh'] = '<script type="text/javascript"language="javascript">if(document.getElementById(\'question\')){document.getElementById(\'question\').value=" ...";}</script>';
            if(!trim($_REQUEST['recaptcha_response_field'])) {
               die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_18'] . $option['jaRefresh'])));
            }
            if(!parent::$question[$this->getInt('recaptcha_challenge_field')]) {
               die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_4'] . $option['jaRefresh'])));
            }
            $capthaAnswer = trim(strip_tags(strtolower($this->filter->process($this->convert_unicode($this->getString('recaptcha_response_field'))))));
            $arrAnswer = explode('<sep>', parent::$question[$this->getInt('recaptcha_challenge_field')]['answers']);
            foreach ($arrAnswer as $key => &$answer) {
               $answer = strip_tags(strtolower($answer));
            }
            if(!in_array($capthaAnswer, $arrAnswer)) {
               die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_17'] . $option['jaRefresh'])));
            }
         }
      }
      $pages = ceil(($option['topicReplyCount'] + 2) / parent::$modules_config['message_count_page']);
      //$option['pageSyfix'] = parent::$modules_config['cpu'] ? '/' . parent::$router['page'] . $pages : '&amp;page=' . $pages;
      if(parent::$modules_config['cpu']) {
         $option['iSlash'] = parent::$modules_config['slash'] ? '/' : '';
         if($pages == 1) {
            $option['pageSyfix'] = '';
         } else {
            if(!parent::$modules_config['slash']) {
               $option['pageSyfix'] = "/" . parent::$router['page'] . "{$pages}{$option['iSlash']}";
            } else {
               $option['pageSyfix'] = parent::$router['page'] . "{$pages}{$option['iSlash']}";
            }
         }
      } else {
         $option['pageSyfix'] = "&page={$pages}{$option['iSlash']}";
      }
      $pages = $option['pageSyfix'];
      if(!in_array(parent::$id_member['user_group'], explode(',', parent::$treePermanent[$option['id_parent']]['tree_access_topic_replic']))) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_2'])));
      }
      if($option['topicType'] == 1 and !in_array(parent::$id_member['name'], explode(',', $option['topicUserIsPrivate']))) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_3'])));
      }
      if($option['topicType'] == 2 and !$this->ckeckModulesConfigGroup('be_replic_is_cloze')) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_3'])));
      }
      $row = $this->db->super_query("SELECT message_date FROM " . PREFIX . "_be_message WHERE autors_id = '{$option['idUser']}' ORDER BY id DESC LIMIT 1");
      if(parent::$group_config[parent::$id_member['user_group']]['be_time_step_msg'] and $this->time - intval($row['message_date']) < parent::$group_config[parent::$id_member['user_group']]['be_time_step_msg']) {
         die($this->getJson(array('param' => '0', 'data' => parent::$modules_lang['msg_5'])));
      }
      $option['userTrophies'] = $this->_userTrophies();
      if($option['userTrophies']) {
         foreach ($option['userTrophies'] as $value) {
            $option['textPm'] = parent::$modules_lang['trophies_0'] . parent::$linck->userTrophies(parent::$id_member['name'], parent::$id_member['autors_id'], false, parent::$modules_lang['trophies_3']) . parent::$honor[$value]['criteria']['name'] . '</a>';
            $option['adminName'] = $this->db->super_query("SELECT name FROM " . PREFIX . "_users WHERE user_id = 1");
            $option['adminName']['name'] = $option['adminName']['name'] ? $this->db->safesql($option['adminName']['name']) : 'admin';
            $this->db->query("INSERT INTO " . PREFIX . "_pm (subj, text, user, user_from, date, pm_read, folder) values ('" . parent::$modules_lang['trophies_1'] . "', '{$option['textPm']}', '{$option['idUser']}', '{$option['adminName']['name']}', '{$this->time}', 'no', 'inbox')");
            if(empty(parent::$id_member['forum_inseption']['honor'])) {
               parent::$id_member['forum_inseption']['honor'] = array($value);
            } else {
               array_push(parent::$id_member['forum_inseption']['honor'], $value);
            }
            if(empty(parent::$id_member['forum_inseption']['bals'])) {
               parent::$id_member['forum_inseption']['bals'] = parent::$honor[$value]['criteria']['bals'];
            } else {
               parent::$id_member['forum_inseption']['bals'] = parent::$id_member['forum_inseption']['bals'] + parent::$honor[$value]['criteria']['bals'];
            }
            $option['updateIns'] = $this->db->safesql(serialize(parent::$id_member['forum_inseption']));
            $this->db->query("UPDATE " . PREFIX . "_users SET pm_all = pm_all + 1, pm_unread=pm_unread + 1, forum_inseption = '{$option['updateIns']}' WHERE user_id='{$option['idUser']}'");
         }
      }
      $option['userTitl'] = $this->_userTitle();
      if($option['userTitl']) {
         parent::$id_member['forum_inseption']['title'] = $option['userTitl'];
         $option['updateIns'] = $this->db->safesql(serialize(parent::$id_member['forum_inseption']));
         $this->db->query("UPDATE " . PREFIX . "_users SET forum_inseption = '{$option['updateIns']}' WHERE user_id='{$option['idUser']}'");
      }
      if(intval(parent::$modules_config['wrap_count_msg'])) {
         if(parent::$dle_config['charset'] == "utf-8")
            $utf_pref = "u";
         else
            $utf_pref = "";
         $option['postMsg'] = preg_split('((>)|(<))', $option['postMsg'], -1, PREG_SPLIT_DELIM_CAPTURE);
         $n = count($msg);
         for ($i = 0; $i < $n; $i++) {
            if($option['postMsg'][$i] == "<") {
               $i++;
               continue;
            }
            $option['postMsg'][$i] = preg_replace("#([^\s\n\r]{" . intval(parent::$modules_config['wrap_count_msg']) . "})#{$utf_pref}i", "\\1<br />", $option['postMsg'][$i]);
         }
         $option['postMsg'] = join("", $option['postMsg']);
      }
      $combine = false;
      if(parent::$modules_config['msg_combine']) {
         $row = $this->db->super_query("SELECT id,id_topic,autors_id,message_autor,message_date,message_text FROM " . PREFIX . "_be_message where id_topic = '{$option['topicId']}' ORDER BY id DESC LIMIT 1");
         if($row['autors_id'] == $option['idUser']) {
            $combine = true;
         }
         if(parent::$group_config[parent::$id_member['user_group']]['be_time_step_msg'] and (($row['message_date'] + (parent::$group_config[parent::$id_member['user_group']]['be_time_step_msg'] * 60)) < $this->time)) {
            $combine = false;
         }
         if(date("Y-m-d", $row['message_date']) != date("Y-m-d", $this->time)) {
            $combine = false;
         }
         if((($this->_valueStrlen($row['message_text'], parent::$dle_config['charset']) + $this->_valueStrlen($option['postMsg'], parent::$dle_config['charset'])) > parent::$modules_config['message_count']) and $combine) {
            $combine = false;
         }
      }
      $option['foto'] = parent::$id_member['foto'] == '' ? '' : parent::$id_member['foto'];
      if($this->checkModerator($option['id_parent']) or parent::$modules_config['moder_disable']) {
         $option['avprove'] = 1;
      } else {
         $option['avprove'] = 0;
      }
      @unlink(ENGINE_DIR . '/bullet_energy/cache/system/feed_1_' . $option['topicId'] . '.tmp');
      @unlink(ENGINE_DIR . '/bullet_energy/cache/system/feed_0_' . $option['id_parent'] . '.tmp');
      if($combine) {
         $option['postMsg'] = $this->db->safesql($row['message_text']) . '<br /><br />' . $option['postMsg'];
         $this->db->query("UPDATE " . PREFIX . "_be_message 
                        SET message_approve='{$option['avprove']}', 
                        message_text='{$option['postMsg']}', 
                        msg_edit_date= '{$this->time}', 
                        edit_autor='{$option['userName']}' 
                        WHERE id='{$row['id']}'");
         $last = $this->_generateLastPostInfo(array($option['userName'], $this->time, $option['topicName'], parent::$linck->topicLinck($option['topicId'], $this->totranslit($option['topicName'], true, true)) . $pages . '#message-' . $row['id'], $option['foto'], $option['idUser']));
         $this->db->query("UPDATE " . PREFIX . "_be_tree 
                        SET tree_last_info = '{$last}', 
                        tree_last_date = {$this->time} 
                        WHERE tree_id = {$option['id_parent']}");
         $this->db->query("UPDATE " . PREFIX . "_be_topic 
                        SET last_reply_info='{$last}', 
                        last_reply_date='{$this->time}' 
                        WHERE id = {$option['topicId']}");
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_topic 
                        (ber_read_id,ber_user_id,ber_topic_id,ber_tree_id,ber_read_date) VALUES (NULL,'{$this->userID}','{$option['topicId']}','{$option['id_parent']}','{$this->time}') 
                        ON DUPLICATE KEY UPDATE ber_read_date={$this->time}");
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_tree (bert_read_id,bert_user_id,bert_tree_id,bert_read_date) VALUES (NULL,'{$this->userID}','{$option['id_parent']}','{$this->time}') ON DUPLICATE KEY UPDATE bert_read_date = {$this->time}");
         return $this->getJson(array('param' => '1', 'id' => $row['id'], 'data' => $this->_getMsg($row['id'], $option['topicId'], $this->totranslit($option['topicName'], true, true)) . $option['jaRefresh']));
      } else {
         $this->db->query("INSERT INTO " . PREFIX . "_be_message 
                        (id,id_topic,autors_id,message_autor,message_autor_ip,message_date,message_text,message_approve,tree_id,parent_msg,user_thanks) 
                        VALUES (NULL,'{$option['topicId']}','{$option['idUser']}','{$option['userName']}','{$option['ipUser']}','{$this->time}','{$option['postMsg']}','{$option['avprove']}',{$option['id_parent']},'0','')");
         $option['insertId'] = $this->db->insert_id();
         $last = $this->_generateLastPostInfo(array($option['userName'], $this->time, $option['topicName'], parent::$linck->topicLinck($option['topicId'], $this->totranslit($option['topicName'], true, true)) . $pages . '#message-' . $option['insertId'], $option['foto'], $option['idUser']));
         if(parent::$treePermanent[$option['id_parent']]['tree_count'] == 1) {
            $this->db->query("UPDATE " . PREFIX . "_users SET forum_post_count = forum_post_count + 1 WHERE user_id = {$option['idUser']}");
         }
         $this->db->query("UPDATE " . PREFIX . "_be_tree SET tree_last_info = '{$last}', tree_answer = tree_answer + 1, tree_last_date = {$this->time} WHERE tree_id = {$option['id_parent']}");
         $this->db->query("UPDATE " . PREFIX . "_be_topic SET last_reply_info = '{$last}', reply_count=reply_count + 1, last_reply_date = {$this->time} WHERE id = {$option['topicId']}");
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_topic (ber_read_id,ber_user_id,ber_topic_id,ber_tree_id,ber_read_date) VALUES (NULL,{$this->userID},{$option['topicId']},{$option['id_parent']},{$this->time}) ON DUPLICATE KEY UPDATE ber_read_date={$this->time}");
         $this->db->query("INSERT INTO " . PREFIX . "_be_read_tree (bert_read_id,bert_user_id,bert_tree_id,bert_read_date) VALUES (NULL,'{$this->userID}','{$option['id_parent']}','{$this->time}') ON DUPLICATE KEY UPDATE bert_read_date = {$this->time}");
         return $this->getJson(array('param' => '2', 'id' => $option['insertId'], 'data' => $this->_getMsg($option['insertId'], $option['topicId'], $this->totranslit($option['topicName'], true, true)) . $option['jaRefresh']));
      }
   }
   private function getJson($arr)
   {
      return json_encode($this->_jconvert(parent::$dle_config['charset'], 'utf-8', $arr));
   }
   private function _jconvert($from, $to, $var)
   {
      if(is_array($var)) {
         $new = array();
         foreach ($var as $key => $val) {
            $new[$this->_jconvert($from, $to, $key)] = $this->_jconvert($from, $to, $val);
         }
         $var = $new;
      } else
         if(is_string($var)) {
            $var = iconv($from, $to, $var);
         }
      return $var;
   }
   private function convertToCp($arr)
   {
      return $this->_jconvert('utf-8', 'cp1251', $arr);
   }
   private function _getMsg($id = '', $idTopic = '', $topicName = '')
   {
      $row = $this->db->super_query("SELECT COUNT(*) as count 
                                   FROM " . PREFIX . "_be_message AS msg
                                   WHERE id_topic = '{$idTopic}'
                                   AND id <= {$id}");
      $option = array('idPostPage' => $row['count']);
      $option['dataIsOnline'] = $this->time - parent::$modules_config['session_time'] * 60;
      if(parent::$modules_config['session_check'] and parent::$modules_config['online']) {
         $option['joinStatus'] = array('table' => "LEFT JOIN " . PREFIX . "_be_session AS session 
                                                ON ( msg.autors_id = session.user_id )", 'select' => ', session.session_id', 'where' => "AND session.date > {$option['dataIsOnline']}");
      }
      if(parent::$modules_config['is_like'] and parent::$logged_is) {
         $option['joinThanks'] = array('colums' => ',thanks.thanks_id');
         $option['joinThanks']['join'] = "LEFT JOIN " . PREFIX . "_be_thanks as thanks ON (thanks.thanks_msg_id = msg.id) 
                                       and thanks.thanks_id_user = " . $this->userID;
      }
      $row = $this->db->super_query("SELECT msg.*, user.* {$option['joinStatus']['select']}
                                   FROM " . PREFIX . "_be_message AS msg
                                   LEFT JOIN " . PREFIX . "_users AS user
                                   ON (msg.autors_id = user.user_id) 
                                   {$option['joinStatus']['table']} 
                                   {$option['joinStatus']['where']}
                                   {$option['joinThanks']['join']}
                                   WHERE id = {$id} LIMIT 1");
      if($this->checkModerator($row['tree_id']) and $this->ckeckModulesConfigGroup('be_moder_ip_view')) {
         $data['message_autor_ip'] = long2ip($row['message_autor_ip']);
      }
      $data['one_message'] = $row['parent_msg'];
      $data['idPostPage'] = $option['idPostPage'];
      $data['message_autor'] = $row['message_autor'];
      $data['autors_id'] = $row['autors_id'];
      $data['topicName'] = $topicName;
      //$data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
      if(date('Ymd', $row['message_date']) == date('Ymd', $this->time)) {
         $data['message_date'] = parent::$modules_lang['time_heute'] . $this->langdate(", H:i", $row['message_date']);
      } elseif(date('Ymd', $row['message_date']) == date('Ymd', ($this->time - 86400))) {
         $data['message_date'] = parent::$modules_lang['time_gestern'] . $this->langdate(", H:i", $row['message_date']);
      } else {
         $data['message_date'] = $this->langdate(parent::$modules_config['time_step_message'], $row['message_date']);
      }
      if($this->ckeckModulesConfigGroup('be_access_thanks') and parent::$modules_config['is_like'] and !$row['thanks_id'] and $this->userID != $row['autors_id']) {
         $data['like'] = '<a class="likeContent" onclick="like(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['like_0'] . '</a>'; //like
      } elseif($this->ckeckModulesConfigGroup('be_access_thanks') and parent::$modules_config['is_like'] and $row['thanks_id'] and $this->userID != $row['autors_id']) {
         $data['like'] = '<a class="likeContent" onclick="like(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['like_1'] . '</a>'; //unlike
      } else {
         $data['like'] = false;
      }
      if(parent::$modules_config['is_like']) {
         $row['user_thanks'] = unserialize($row['user_thanks']);
         if($row['user_thanks']) {
            foreach ($row['user_thanks'] as $key => $value) {
               $data['fetchLike'][] = parent::$linck->setLinckCardUser(array($value[0], $value[1], parent::$modules_lang['card_user'])) . $value[0] . '</a>';
            }
         }
         if(($row['thanks'] - 3) > 0) {
            $data['sorseAll'] = $row['thanks'] - 3;
            $data['likeUserAll'] = parent::$modules_lang['like_4'] . '<a href="#" onclick="getAllLike(\'' . $row['id'] . '\'); return false;">' . parent::$modules_lang['like_3'] . $data['sorseAll'] . '</a>';
         }
         $data['msgUserLike'] = count($data['fetchLike']) ? '<div class="likeBox-' . $row['id'] . '"><div>' . implode(', ', $data['fetchLike']) . $data['likeUserAll'] . parent::$modules_lang['like_2'] . '</div></div>' : '<div class="likeBox-' . $row['id'] . '"></div>';
      }
      if($this->ckeckModulesConfigGroup('be_warning') and parent::$modules_config['widget_warning']) {
         $data['warning'] = true;
         $data['countWarning'] = '<a href="#" onclick="doWarning(\'' . $row['id'] . '\',\'post\',\'1\'); return false;"  title="' . parent::$modules_lang['msg_43'] . '">' . $row['forum_warning'] . '</a>';
      } elseif($this->userID == $row['autors_id'] and $this->ckeckModulesConfigGroup('be_view_warning_log') and parent::$modules_config['widget_warning'] and $row['forum_warning'] > 0) {
         $data['warning'] = true;
         $data['countWarning'] = '<a href="#" onclick="doWarning(\'' . $row['id'] . '\',\'post\',\'0\'); return false;"  title="' . parent::$modules_lang['msg_43'] . '">' . $row['forum_warning'] . '</a>';
      } else {
         $data['warning'] = false;
      }
      if($this->ckeckModulesConfigGroup('be_fix') and $this->checkModerator($row['tree_id'])) {
         $data['lock'] = empty($row['fixap_msg']) ? '<a id="lockPost-' . $row['id'] . '" onclick="lockPost(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_34'] . '</a>' : '<a id="lockPost-' . $row['id'] . '" onclick="UnLockPost(\'' . $row['id'] . '\'); return false;" href="#">' . parent::$modules_lang['msg_35'] . '</a>';
      }
      $data['isOnline'] = empty($row['session_id']) ? false : true;
      $data['message_text'] = stripslashes($row['message_text']) . $data['msgUserLike'];
      $data['msg_edit_date'] = $row['msg_edit_date'];
      $data['edit_autor'] = $row['edit_autor'];
      $data['news_num'] = $row['news_num'];
      $data['likeCountUser'] = $row['forum_thanks_count'];
      $data['comm_num'] = $row['comm_num'];
      $data['forum_topic_count'] = $row['forum_topic_count'];
      $data['forum_post_count'] = $row['forum_post_count'];
      $data['id_topic'] = $row['id_topic'];
      $data['user_group'] = parent::$group_user[$row['user_group']]['group_name'];
      $data['css_name'] = parent::$group_config[$row['user_group']]['be_style_name_css'];
      $data['css_group'] = parent::$group_config[$row['user_group']]['be_style_group_css']; //var_dump(parent::$group_config[$row['user_group']]);
      $data['reg_date'] = $this->langdate(parent::$modules_config['time_step_autor'], $row['reg_date']);
      $data['foto'] = $row['foto'] ? parent::$dle_config['http_home_url'] . 'uploads/fotos/' . $row['foto'] : parent::$dle_config['http_home_url'] . 'templates/' . parent::$dle_config['skin'] . '/bullet_energy/images/noavatar.png';
      $data['signature'] = stripcslashes($row['signature']);
      $data['icq'] = stripcslashes($row['icq']);
      $data['mesage_id'] = $row['id'];
      $row['forum_inseption'] = unserialize($row['forum_inseption']);
      $data['titleUser'] = parent::$title[$row['forum_inseption']['title']]['title'] ? parent::$title[$row['forum_inseption']['title']]['title'] : '';
      $data['countTrophies'] = count($row['forum_inseption']['honor']);
      $data['countTrophiesLinck'] = $data['countTrophies'] > 0 ? parent::$linck->userTrophies($data['message_autor'], $data['autors_id'], true, parent::$modules_lang['trophies_3']) : '';
      $data['countTrophiesLinckOut'] = $data['countTrophies'] > 0 ? '</a>' : '';
      return $this->viewer->setTplMessage($data);
   }
   public function checkModerator($id = '')
   {
      /*Function is modified 03.07.2011 RC 0.1*/
      if(in_array($id, parent::$moderator[parent::$id_member['user_id']]['treeAccess'])) {
         if(parent::$group_config[parent::$id_member['user_group']]['be_moder_topic_moder_param'] and parent::$group_config[parent::$id_member['user_group']]['be_moder_moder_access']) {
            return true;
         }
      } elseif(parent::$moderator[parent::$id_member['user_id']]['moderator_super']) {
         return true;
      } else {
         return false;
      }
   }
   private function _generateLastPostInfo($data = array())
   {
      foreach ($data as $key => $val) {
         $ret[] = stripcslashes(stripcslashes($val));
      }
      if(!$ret) {
         return false;
      }
      return $this->db->safesql(serialize($ret));
   }
   private function _valueStrlen($value = '', $charset = '')
   {
      return strtolower($charset) == "utf-8" ? iconv_strlen($value, "utf-8") : strlen($value);
   }
   public function TopicUpdateProcess()
   {
      $option = array('newTree' => $this->getInt('topic_tree_new'));
      $id = $this->getInt('topic_id');
      $fixed = $this->getInt('topic_fixed');
      $status = $this->getInt('topic_status');
      $visible = $this->getInt('topic_visible');
      if(!$status > 1 and !$fixed > 1) {
         die("die");
      }
      if($status == 0) {
         $status = 2;
      } elseif($status == 1) {
         $status = 0;
      }
      $name = $this->db->safesql($this->convert_unicode($this->filter->process(trim(strip_tags($_POST['topic_name'])))));
      if(parent::$modules_config['title_case']) {
         $name = ucfirst($name);
      }
      if(!$id) {
         die("die");
      }

      if(!parent::$group_config[parent::$id_member['user_group']]['be_moder_topic_moder_param']) {
         die('die');
      }
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_topic WHERE id = {$id} LIMIT 1");
      if(!$row) {
         die("die");
      }
      if($name != stripcslashes($row['title']) and parent::$group_config[parent::$id_member['user_group']]['be_moder_top_rename']) {
         $update[] = "title = '{$name}'";
      }
      if($fixed != intval($row['topic_fixed']) and parent::$group_config[parent::$id_member['user_group']]['be_moder_topic_wanted']) {
         $update[] = "topic_fixed = '{$fixed}'";
      }
      if($status != intval($row['topic_type']) and parent::$group_config[parent::$id_member['user_group']]['be_moder_close_to_open_topic']) {
         $update[] = "topic_type = '{$status}'";
      }

      if($this->getString('topic_decription')) {
         $option['topicDescription'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($this->convert_unicode($_REQUEST['topic_decription']))), false));
         $update[] = "topic_descr_site = '{$option['topicDescription']}'";
      } else {
         $update[] = "topic_descr_site = ''";
      }
      if($option['newTree'] != $row['id_parent']) {
         $option['positionTree'] = array($option['newTree'], intval($row['id_parent']));
         $update[] = "id_parent = '{$option['newTree']}'";
         $this->db->query("UPDATE " . PREFIX . "_be_message SET tree_id = {$option['newTree']} WHERE id_topic = {$id}");
      }
      if($visible == 1 or $visible == 2 and parent::$group_config[parent::$id_member['user_group']]['be_moder_moder_access']) {
         if($visible == 2) {
            $visible = 0;
         }
         if($visible != intval($row['topic_approve'])) {
            $update[] = "topic_approve = '{$visible}'";
         }
      } elseif($visible == 0 and parent::$group_config[parent::$id_member['user_group']]['be_moder_del_user_topic']) {
         $count = $this->db->super_query("SELECT COUNT(*) as count FROM " . PREFIX . "_be_message WHERE id_topic = {$id}");
         $this->db->query("DELETE FROM " . PREFIX . "_be_topic WHERE id = {$id} LIMIT 1");
         $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE id_topic = {$id}");
         $this->db->query("UPDATE " . PREFIX . "_be_tree set tree_last_info = '', tree_topic=tree_topic-1,tree_answer=tree_answer-{$count['count']} WHERE tree_id={$row['id_parent']}");
         $this->db->query("UPDATE " . PREFIX . "_users set forum_post_count = forum_post_count-1,forum_topic_count = forum_topic_count-1 WHERE user_id = {$row['autor_id']} LIMIT 1");
         $this->_updateTopicParam();
         return '<li class="topicList deleteTopic">' . parent::$modules_lang['topic_16'] . '</li>';
         die();
      }
      if(!$update) {
         die("no_edit");
      }
      if($visible == 1) {
         $this->db->query("UPDATE " . PREFIX . "_be_message SET message_approve = '1' WHERE id_topic = {$id}");
      } elseif($visible == 0) {
         $this->db->query("UPDATE " . PREFIX . "_be_message SET message_approve = '0' WHERE id_topic = {$id}");
      }
      $row['topic_meta'] = unserialize($row['topic_meta']);
      $row['topic_meta']['Titl'] = $name;
      $row['topic_meta']['Description'] = $option['topicDescription'];
      $update[] = 'topic_meta = \'' . serialize($row['topic_meta']) . '\'';
      $update = implode(', ', $update);
      $this->db->query("UPDATE " . PREFIX . "_be_topic SET {$update} WHERE id = {$id} LIMIT 1");
      $this->_updateTopicParam();
      if(count($option['positionTree'])) {
         die('<li class="topicList deleteTopic">' . parent::$modules_lang['topic_65'] . '</li>');
      }
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_topic
                                            LEFT JOIN " . PREFIX . "_be_read_topic 
                                            ON " . PREFIX . "_be_topic.id=" . PREFIX . "_be_read_topic.ber_topic_id 
                                            AND '{$this->userID}' = " . PREFIX . "_be_read_topic.ber_user_id 
                                            WHERE id = {$id} 
                                            LIMIT 1");
      $last = unserialize($row['last_reply_info']);
      if($row['post_date'] < $this->timeMarkerOldTopic) {
         $data['status_read'] = 'read';
         $data['statusTitl'] = parent::$modules_lang['topic_36'];
      } else {
         if(!$row['ber_read_date']) {
            $row['ber_read_date'] = 0;
         }
         if($last[1] > $row['ber_read_date']) {
            $data['status_read'] = 'unread';
            $data['statusTitl'] = parent::$modules_lang['topic_35'];
         } else {
            $data['status_read'] = 'read';
            $data['statusTitl'] = parent::$modules_lang['topic_36'];
         }
      }
      $data['id'] = $row['id'];
      $data['id_parent'] = $row['id_parent'];
      $data['title'] = stripslashes($row['title']);
      $data['reply_count'] = $row['reply_count'];
      $data['view_count'] = $row['view_count'];
      $data['autor'] = stripslashes($row['autor']);
      $data['site_description'] = stripslashes($row['topic_descr_site']);
      $data['post_date'] = $row['post_date'];
      $data['last'] = $last;
      $data['topic_approve'] = $row['topic_approve'];
      $data['fixed'] = $row['topic_fixed'];
      $data['topic_type'] = $row['topic_type'];
      $data['titleTopic'] = $this->totranslit($data['title'], true, true);
      return $this->viewer->setTplTopicShort($data);
   }
   private function _updateTopicParam()
   {
      $this->recountTree();
      $this->recountTreeLast();
   }
   public function deleteMsgTopicProcess()
   {
      $option = array('id' => $this->getInt('id'), 'fetch' => false);
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
      $option['topicTitle'] = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_topic WHERE id = {$row['id_topic']} LIMIT 1");
      if(!$row['tree_id']) {
         die('die');
      }
      if($_POST['hash'] != '' and $_POST['hash'] == parent::$login_hash) {
         if(parent::$id_member['user_id'] == $row['autors_id'] and parent::$group_config[parent::$id_member['user_group']]['be_access_del_my_post'] or parent::$id_member['user_group'] == '1') {
            $option['fetch'] = true;
         } elseif(parent::$id_member['user_id'] != $row['autors_id'] and parent::$group_config[parent::$id_member['user_group']]['be_moder_del_message_user'] or parent::$id_member['user_group'] == '1') {
            $option['fetch'] = true;
         } else {
            die('die');
         }
      } else {
         die('die');
      }
      if($option['fetch']) {
         $this->db->query("DELETE FROM " . PREFIX . "_be_message WHERE id = {$option['id']} LIMIT 1");
         $this->_delAttachmentMessage($option['id']);
         if(parent::$treePermanent[$row['tree_id']]['tree_count']) {
            $this->db->query("UPDATE " . PREFIX . "_users set forum_post_count=forum_post_count-1 where user_id ='{$row['autors_id']}'");
         }
         $postData = $this->db->super_query("SELECT message.message_autor as name, message.id AS post_id, message.autors_id, message.message_date,  user.foto FROM " . PREFIX . "_be_message AS message LEFT JOIN " . PREFIX . "_users AS user ON message.autors_id = user.user_id WHERE message.id_topic = {$row['id_topic']} ORDER BY message.message_date DESC LIMIT 1");
         $postData['counts'] = $this->db->super_query("SELECT COUNT(*) as countPage FROM " . PREFIX . "_be_message AS msg WHERE id_topic = {$row['id_topic']} AND id <= {$postData['post_id']}");
         $postData['page'] = ceil($postData['counts']['countPage'] / parent::$modules_config['message_count_page']);
         $postData['page'] = $postData['page'] == 1 ? '' : "/" . parent::$router['page'] . "{$postData['page']}";
         $postData['page'] = parent::$linck->topicIsRedirect($row['id_topic'], $this->totranslit($option['topicTitle']['title'], true, true)) . $postData['page'] . '#message-' . $postData['post_id'];
         $postData['last'] = $this->_generateLastPostInfo(array($postData['name'], $postData['message_date'], $option['topicTitle']['title'], $postData['page'], $postData['foto'], $postData['autors_id']));
         $this->db->query("UPDATE " . PREFIX . "_be_topic set reply_count=reply_count-1,last_reply_info = '{$postData['last']}' where id ='{$row['id_topic']}'");
         $this->db->query("UPDATE " . PREFIX . "_be_tree set tree_answer=tree_answer-1, tree_last_info  ='{$postData['last']}' where tree_id={$row['tree_id']}");
         $this->_updateTopicParam();
         die('ok');
      }
   }
   private function _delAttachmentMessage($idMessage = '')
   {
      $this->db->query("SELECT * FROM " . PREFIX . "_be_attachment WHERE attachment_content_id = {$idMessage}");
      if($this->db->num_rows()) {
         while ($row = $this->db->get_row()) {
            if($row['attachment_type'] == 0) {
               if(file_exists(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/thumbs/' . $row['attachment_name'])) {
                  @unlink(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/thumbs/' . $row['attachment_name']);
               }
               if(file_exists(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/' . $row['attachment_name'])) {
                  @unlink(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/' . $row['attachment_name']);
               }
            } else {
               if(file_exists(ROOT_DIR . '/uploads/forum/files/' . $row['attachment_name'])) {
                  @unlink(ROOT_DIR . '/uploads/forum/files/' . $row['attachment_name']);
               }
            }
         }
      }
      return false;
   }
   public function ComplaintPostProcess()
   {
      /*Function is modified 04.07.2011 RC 0.1*/
      $option['textComplaint'] = $this->db->safesql($this->filter->BB_Parse($this->filter->process(trim($this->convert_unicode($_POST['text'], parent::$dle_config['charset']))), false));
      $row = $this->db->super_query("SELECT * FROM " . PREFIX . "_be_message WHERE id = {$this->id} LIMIT 1");
      if(!$row['tree_id'] or !$option['textComplaint']) {
         die("die");
      }
      if($row['message_autor'] == $this->userName) {
         return parent::$modules_lang['complaint_0'];
      }
      $this->db->query("SELECT ct_msg_id FROM " . PREFIX . "_be_complaint WHERE ct_msg_id='{$this->id}' AND ct_from='{$this->userName}'");
      if($this->db->num_rows()) {
         return parent::$modules_lang['complaint_1'];
      }
      $this->db->query("INSERT INTO " . PREFIX . "_be_complaint (ct_id,ct_msg_id,ct_date,ct_text,ct_from) VALUES (NULL,'{$this->id}','{$this->time}','{$option['textComplaint']}','{$this->userName}')");
      return 'ok';
   }
   public function deleteAttachmentProcess()
   {
      /*Function is modified 04.07.2011 RC 0.1*/
      if($_POST['hash'] != parent::$login_hash or !$this->getInt('id')) {
         die('die');
      }
      $this->db->query("SELECT * FROM " . PREFIX . "_be_attachment 
                      WHERE attachment_id = '{$this->id}' 
                      LIMIT 1");
      $row = $this->db->get_row();
      if(($row['attachment_user_name'] != $this->userName or $row['attachment_user_id'] != $this->userID) and !$this->ckeckModulesConfigGroup('be_moder_edit_message_user')) {
         return die('die');
      } else {
         $this->db->query("DELETE FROM " . PREFIX . "_be_attachment WHERE attachment_id = '{$this->id}' LIMIT 1");
         if(intval($row['attachment_type']) == 1) {
            @unlink(ROOT_DIR . '/uploads/forum/files/' . $row['attachment_name']);
            $row1 = $this->db->super_query("SELECT count( * ) AS count FROM " . PREFIX . "_be_attachment WHERE attachment_type = 1 AND attachment_user_name = '{$row['attachment_user_name']}' AND attachment_user_id = {$row['attachment_user_id']} AND attachment_content_id = {$row['attachment_content_id']}");
            $option['messageAttachmentCount'] = $row1['count'] > 0 ? 1 : 0;
            if(empty($option['messageAttachmentCount'])) {
               $this->db->query("UPDATE " . PREFIX . "_be_message SET attachment = 0 WHERE id = {$row['attachment_content_id']} LIMIT 1");
            }
         } elseif(intval($row['attachment_type']) == 0) {
            @unlink(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/' . $row['attachment_name']);
            @unlink(ROOT_DIR . '/uploads/forum/images/' . date('Y-m', $row['attachment_date']) . '/thumbs/' . $row['attachment_name']);
         }
         return 'ok';
      }
   }
   private function convert_unicode($t, $to = 'windows-1251')
   {
      $to = strtolower($to);
      if($to == 'utf-8') {
         return $t;
      } else {
         if(function_exists('iconv'))
            $t = iconv("UTF-8", $to . "//IGNORE", $t);
         else
            $t = "The library iconv is not supported by your server";
      }
      return $t;
   }
   public function getProfileCardProcess()
   {
      if(parent::$modules_config['session_check'] and parent::$modules_config['online']) {
         $option['dataIsOnline'] = $this->time - (parent::$modules_config['session_time'] * 60);
         $option['joinStatus'] = array('table' => "LEFT JOIN " . PREFIX . "_be_session AS session 
                                                ON ( user.user_id = session.user_id )", 'select' => ', session.session_id', 'where' => "AND session.date > {$option['dataIsOnline']}");
      }
      $row = $this->db->super_query("SELECT user.* {$option['joinStatus']['select']} FROM " . PREFIX . "_users as user
                                            {$option['joinStatus']['table']}
                                            {$option['joinStatus']['where']}
                                            WHERE user.user_id = {$this->id} 
                                            LIMIT 1");
      if(!$row['user_id']) {
         die("die");
      }
      if($row['session_id']) {
         $data['isOnline'] = true;
      } else {
         $data['isOnline'] = false;
      }
      $data['foto'] = $row['foto'] ? parent::$dle_config['http_home_url'] . "uploads/fotos/" . $row['foto'] : parent::$dle_config['http_home_url'] . 'templates/' . parent::$dle_config['skin'] . '/bullet_energy/images/noavatar.png';
      $data['reg_date'] = $this->langdate("j F Y H:i", $row['reg_date']);
      $data['lastdate'] = $this->langdate("j F Y H:i", $row['lastdate']);
      $data['fullname'] = stripslashes($row['fullname']);
      $data['comm_num'] = $row['comm_num'];
      $data['news_num'] = $row['news_num'];
      if($row['banned']) {
         $data['user_group'] = parent::$modules_lang['msg_63'];
      } else {
         $data['user_group'] = parent::$group_user[$row['user_group']]['group_name'];
      }
      $data['icq'] = stripslashes($row['icq']);
      $data['land'] = stripslashes($row['land']);
      $data['info'] = stripslashes($row['info']);
      $data['name'] = stripslashes($row['name']);
      $data['forum_post_count'] = $row['forum_post_count'];
      $data['like'] = $row['forum_thanks_count'];
      $data['forum_topic_count'] = $row['forum_topic_count'];
      $data['linckMsg'] = $row['forum_post_count'] ? $this->viewer->user_message_pages($row['name']) : '';
      $data['linckTopic'] = $row['forum_topic_count'] ? $this->viewer->user_topic_pages($row['name']) : '';
      $data['icon_group'] = parent::$group_user[$row['user_group']]['icon'] ? "<img src=\"" . parent::$group_user[$row['user_group']]['icon'] . "\" border=\"0\" />" : '';
      $data['signature'] = $row['signature'] && parent::$group_user[$row['user_group']]['allow_signature'] ? stripslashes($row['signature']) : '';
      $data['linck_news'] = $row['news_num'] ? $this->viewer->setLinckNews($row['name']) : '';
      $data['linck_comments'] = $row['comm_num'] ? $this->viewer->setLinckComment($row['user_id']) : '';
      $row['forum_inseption'] = unserialize($row['forum_inseption']);
      $data['titleUser'] = parent::$title[$row['forum_inseption']['title']]['title'] ? parent::$title[$row['forum_inseption']['title']]['title'] : '';
      $data['countTrophies'] = count($row['forum_inseption']['honor']);
      $data['countTrophiesLinck'] = $data['countTrophies'] > 0 ? parent::$linck->userTrophies($data['name'], $row['user_id'], true, parent::$modules_lang['trophies_3']) : '';
      $data['countTrophiesLinckOut'] = $data['countTrophies'] > 0 ? '</a>' : '';
      if($this->ckeckModulesConfigGroup('1')) {
      }
      return $this->viewer->setTpluserCard($data);
   }
   public function langdate($format, $stamp)
   {
      return strtr(@date($format, $stamp), parent::$lang_local);
   }
   public function get($name, $default, $type = 'mixed')
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      if(self::defined($name)) {
         $mixRes = $_REQUEST[$name];
      } else {
         if(null === $default) {
            return false;
         }
         $mixRes = $default;
      }
      if($type != 'mixed') {
         if($type == 'float') {
            $mixRes = str_replace(",", ".", $mixRes);
         }
         settype($mixRes, $type);
      }
      return $mixRes;
   }
   public function getInt($name, $default = 0)
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      return intval(self::get($name, $default, 'int'));
   }
   public function defined($name)
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      if(isset($_REQUEST[$name])) {
         return true;
      }
      return false;
   }
   private function _deleteMQR($mixValue)
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      if(get_magic_quotes_gpc()) {
         if(is_array($mixValue)) {
            foreach ($mixValue as $k => $v) {
               $mixValue[$k] = self::_deleteMQR($v);
            }
         } else {
            return stripslashes($mixValue);
         }
      }
      return $mixValue;
   }
   public function getString($name, $default = "")
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      return $this->db->safesql(trim(strip_tags(self::_deleteMQR(self::get($name, $default, 'string')))));
   }
   public function setGroupConfig()
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      if(file_exists($this->casheSysDir . 'groups_config.tmp')) {
         return $this->_retSysCashe('groups_config.tmp');
      } else {
         $data = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_groups ORDER BY be_groups_id ASC");
         while ($row = $this->db->get_row()) {
            $data[$row['be_groups_id']] = array();
            foreach ($row as $key => $value) {
               $data[$row['be_groups_id']][$key] = stripslashes($value);
            }
         }
         $this->_writeSysCashe('groups_config.tmp', $data);
         return $this->_retSysCashe('groups_config.tmp');
      }
   }
   public function setQuestionConfig()
   {
      if(file_exists($this->casheSysDir . 'question.tmp')) {
         return $this->_retSysCashe('question.tmp');
      } else {
         $tree = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_question WHERE is_active = 1 ORDER BY id ASC ");
         while ($row = $this->db->get_row()) {
            $tree[$row['id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['id']][$key] = stripslashes($value);
            }
         }
         $this->_writeSysCashe('question.tmp', $tree);
         return $this->_retSysCashe('question.tmp');
      }
   }
   public function setTitle()
   {
      if(file_exists($this->casheSysDir . 'title.tmp')) {
         return $this->_retSysCashe('title.tmp');
      } else {
         $tree = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_user_title ORDER BY bals DESC");
         while ($row = $this->db->get_row()) {
            $tree[$row['id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['id']][$key] = stripcslashes($value);
            }
         }
         $this->_writeSysCashe('title.tmp', $tree);
         return $this->_retSysCashe('title.tmp');
      }
   }
   public function setSystemHonor()
   {
      if(file_exists($this->casheSysDir . 'honor.tmp')) {
         return $this->_retSysCashe('honor.tmp');
      } else {
         $tree = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_honor ORDER BY id ASC");
         while ($row = $this->db->get_row()) {
            $tree[$row['id']] = array();
            foreach ($row as $key => $value) {
               if($key == 'criteria') {
                  $value = unserialize($value);
               }
               $tree[$row['id']][$key] = $value;
            }
         }
         $this->_writeSysCashe('honor.tmp', $tree);
         return $this->_retSysCashe('honor.tmp');
      }
   }
   public function setTreePermanentConfig()
   {
      if(file_exists($this->casheSysDir . 'tree_permanent.tmp')) {
         return $this->_retSysCashe('tree_permanent.tmp');
      } else {
         $tree = array();
         $this->db->query("SELECT tree_id,tree_parent_id,tree_type,tree_title,tree_approve,tree_count,tree_description,tree_access_topic_new,tree_access_topic_read,tree_access_topic_replic,tree_access_view FROM " . PREFIX . "_be_tree ORDER BY tree_id ASC");
         while ($row = $this->db->get_row()) {
            $tree[$row['tree_id']] = array();
            foreach ($row as $key => $value) {
               $tree[$row['tree_id']][$key] = stripslashes($value);
            }
         }
         $this->_writeSysCashe('tree_permanent.tmp', $tree);
         return $this->_retSysCashe('tree_permanent.tmp');
      }
   }
   public function setModerConfig()
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      if(file_exists($this->casheSysDir . 'moderator.tmp')) {
         return $this->_retSysCashe('moderator.tmp');
      } else {
         $data = array();
         $this->db->query("SELECT * FROM " . PREFIX . "_be_moderator ORDER BY id ASC");
         while ($row = $this->db->get_row()) {
            $data[$row['moderator_id']] = array();
            foreach ($row as $key => $value) {
               $data[$row['moderator_id']][$key] = stripslashes($value);
               $data[$row['moderator_id']]['treeAccess'] = explode(',', $data[$row['moderator_id']]['moderator_tree_id']);
            }
         }
         $this->_writeSysCashe('moderator.tmp', $data);
         return $this->_retSysCashe('moderator.tmp');
      }
   }
   protected function setSystemCasheGroup()
   {
      $id = $this->db->safesql(parent::$id_member['user_group']);
      if(file_exists($this->casheSysDir . 'sys_cashe_group_' . $id . '.tmp')) {
         return $this->_retSysCashe('sys_cashe_group_' . $id . '.tmp');
      } else {
         $this->db->query("SELECT tree_id FROM " . PREFIX . "_be_tree where tree_access_view like '%{$id}%'");
         if(!$this->db->num_rows()) {
            return false;
         }
         $tpm = array();
         while ($row = $this->db->get_row()) {
            foreach ($row as $key => $value) {
               $tpm[] = $row['tree_id'];
            }
         }
         $this->db->query("SELECT tree_id FROM " . PREFIX . "_be_tree where tree_access_topic_read like '%{$id}%'");
         if(!$this->db->num_rows()) {
            return false;
         }
         $tpm_ = array();
         while ($row = $this->db->get_row()) {
            foreach ($row as $key => $value) {
               $tpm_[] = $row['tree_id'];
            }
         }
         $this->_writeSysCashe('sys_cashe_group_' . $id . '.tmp', array('accessTreeView' => $this->db->safesql(implode(',', $tpm)), 'accessTopicView' => $this->db->safesql(implode(',', $tpm_))));
         return $this->_retSysCashe('sys_cashe_group_' . $id . '.tmp');
      }
   }
   private function _retSysCashe($file = '')
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      return unserialize(@file_get_contents($this->casheSysDir . $file));
   }
   private function _writeSysCashe($file = '', $data = array())
   {
      /*Function is modified 05.07.2011 RC 0.1*/
      $fp = fopen($this->casheSysDir . $file, 'wb+');
      fwrite($fp, serialize($data));
      fclose($fp);
      @chmod($this->casheSysDir . $file, 0666);
   }
}

?>