<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.2.3
 * HTML Email template
 * Last Updated: $Date: 2011-05-05 12:03:47 +0100 (Thu, 05 May 2011) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www.invisionpower.com
 * @since		3.0
 * @version		$Revision: 8644 $
 *
 */
 
class ipsEmailWrapper
{
	/**
	* Constructor
	*
	* @access	public
	* @return	@e void
	*/	
	public function __construct()
	{
		$registry = ipsRegistry::instance();
		
		/* Make registry objects */
		$this->registry		=  $registry;
		$this->DB			=  $this->registry->DB();
		$this->settings		=& $this->registry->fetchSettings();
		$this->request		=& $this->registry->fetchRequest();
		$this->lang			=  $this->registry->getClass('class_localization');
		$this->member		=  $this->registry->member();
		$this->memberData	=& $this->registry->member()->fetchMemberData();
		$this->cache		=  $this->registry->cache();
		$this->caches		=& $this->registry->cache()->fetchCaches();
	}
	
	/**
	* return the HTML email wrapper
	*
	* @access	public
	* @return	string	html
	*/	
	public function getTemplate( $content )
	{
		return <<<EOF
<!DOCTYPE html>
	<html xml:lang="en" lang="en" xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html; charset={$this->settings['gb_char_set']}" />
		<title><#subject#></title>
		<style type="text/css">
			body,div,dl,dt,dd,ul,ol,li,h1,h2,h3,h4,h5,h6,pre,form,fieldset,input,textarea,p,blockquote,th,td { margin:0; padding:0; } 
			table {	border-collapse:collapse; border-spacing:0; }
			fieldset,img { border:0; }
			address,caption,cite,code,dfn,th,var { font-style:normal; font-weight:normal; }
			ol,ul { list-style:none; }
			caption,th { text-align:left; }
			h1,h2,h3,h4,h5,h6 { font-size:100%;	font-weight:normal; }
			q:before,q:after { content:''; }
			abbr,acronym { border:0; }
			address{ display: inline; }
			
			html, body {
				background-color: #d8dde8;
				color: #5a5a5a;
			}

			body {
				font: normal 13px helvetica, arial, sans-serif;
				position: relative;
			}
			
			h3, strong { font-weight: bold; }
			em { font-style: italic; }
			img, .input_check, .input_radio { vertical-align: middle; }
			legend { display: none; }
			table { width: 100%; }
			td { padding: 3px; }
			
			a {
				color: #225985;
				text-decoration: none;
			}
			
			a:hover { color: #328586; }
			
			div.outer { margin: 0 auto; padding: 14px; }
			
			table.wrap { max-width: 800px; margin: 0 auto; }
			
			td.logo {
				background-color: #0f3854;
				padding: 8px;
			}
			
			td.content {
				background-color: #fff;
				font-size: 14px !important;
				color: black !important;
				line-height: 150% !important;
				padding: 8px;
			}

		</style>
	</head>
	<body>
	<div class='outer'>
	<table class='wrap'>
		<tr>
			<td class='logo'><img src="{$this->settings['img_url']}/logo_transparent.png" /></td>
		</tr>
		<tr>
			<td class='content'>{$content}</td>
		</tr>
	</table>
	</div>
	</body>
</html>
EOF;
	}
}