<?php
/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */

/**
 * Method to add menu's item.
 *
 * @return boolean true on success false on failure.
 */
function addMenuItems()
{
	$db		= JFactory::getDBO();
	
	// Get new component id.
	$component		= JComponentHelper::getComponent('com_community');
	$component_id	= 0;
	if (is_object($component) && isset($component->id)){
		$component_id 	= $component->id;
	}
	
	$column_name	= JOOMLA_MENU_NAME;
	$column_cid		= JOOMLA_MENU_COMPONENT_ID;
	
	// Get the default menu type
	// 2 Joomla bugs occur in /Administrator mode
	// Bug 1: JFactory::getApplication('site') failed. It always return id = 'administrator'.
	// Bug 2: JMenu::getDefault('*') failed. JAdministrator::getLanguageFilter() doesn't exist.
	// If these 2 bugs are fixed, we can call the following syntax:
	// $defaultMenuType	= JFactory::getApplication('sites')->getMenu()->getDefault()->menutype;
	jimport('joomla.application.application');
	$defaultMenuType	= JApplication::getInstance('site')->getMenu()->getDefault('workaround_joomla_bug')->menutype;
	
	$query 	= 'SELECT ' . $db->nameQuote( 'ordering' ) . ' '
			. 'FROM ' . $db->nameQuote( '#__menu' ) . ' '
			. 'ORDER BY ' . $db->nameQuote( 'ordering' ) . ' DESC LIMIT 1';
	$db->setQuery( $query );
	$order 	= $db->loadResult() + 1;
		
	// Update the existing menu items.
	$row		= JTable::getInstance ( 'menu', 'JTable' );
	
	$row->menutype = $defaultMenuType;
	$row->$column_name = 'JomSocial';
	$row->alias = 'JomSocial';
	$row->link = 'index.php?option=com_community&view=frontpage';
	$row->type = 'component';
	$row->published = '1';
	$row->$column_cid = $component_id;
	$row->ordering = $order;
	$row->id = null; //new item
	
	if (!JOOMLA_LEGACY_VERSION)
	{
		$row->language	= '*';
	}
	
	$row->check();
	
	if(!$row->store())
	{
		// $row->getError()
		return false;
	}
	
	//for version 1.6 only. The parent_id is not updated correctly via JTable
	if (!JOOMLA_LEGACY_VERSION)
	{
		$query = 'UPDATE '. $db->nameQuote( '#__menu' ) 
				 . ' SET `parent_id` = ' .$db->quote(1)
				 . ', `level` = ' . $db->quote(1) 
				 . ' WHERE `id` = ' . $db->quote($row->id) ;
		$db->setQuery( $query );
		$db->query();
		if($db->getErrorNum())
		{
			return false;
		}
	}
	
	if (!addDefaultToolbarMenus())
	{
		return false;
	}
	
	// update memu items with component id
	if (!updateMenuItems())
	{
		return false;
	}
	
	return true;
}

function addDefaultCustomFields()
{
	$db		=& JFactory::getDBO();
	$query	= 'INSERT INTO ' . $db->nameQuote('#__community_fields') . ' (' . $db->nameQuote('id') . ', ' . $db->nameQuote('type') . ', ' . $db->nameQuote('ordering') . ', ' . $db->nameQuote('published') . ', ' . $db->nameQuote('min') . ', ' . $db->nameQuote('max') . ', ' . $db->nameQuote('name') . ', ' . $db->nameQuote('tips') . ', ' . $db->nameQuote('visible') . ', ' . $db->nameQuote('required') . ', ' . $db->nameQuote('searchable') . ', ' . $db->nameQuote('options') . ', ' . $db->nameQuote('fieldcode') . ') VALUES '.
				'(' . $db->Quote('1') . ', ' . $db->Quote('group') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Общая информация') . ', ' . $db->Quote('Общая информация о пользователе') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('') . '),' .
				'(' . $db->Quote('2') . ', ' . $db->Quote('select') . ', ' . $db->Quote('2') . ', ' . $db->Quote('1') .', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Пол') . ', ' . $db->Quote('Укажите Ваш пол') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('Мужчина'."\n".'Женщина') . ', ' . $db->Quote('FIELD_GENDER') . '),' .
				'(' . $db->Quote('3') . ', ' . $db->Quote('birthdate') .', ' . $db->Quote('3') .', ' . $db->Quote('1') .', ' . $db->Quote('10') .', ' . $db->Quote('100') .', ' . $db->Quote('Дата рождения') .', ' . $db->Quote('Укажите дату рождения, чтобы другие пользователи могли Вас поздравить. ') .', ' . $db->Quote('1') .', ' . $db->Quote('0') .', ' . $db->Quote('1') .', ' . $db->Quote('') .', ' . $db->Quote('FIELD_BIRTHDATE') .'),' .
				'(' . $db->Quote('4') . ', ' . $db->Quote('textarea') . ', ' . $db->Quote('4') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('800') . ', ' . $db->Quote('Обо мне') . ', ' . $db->Quote('Расскажите подробнее о себе') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('FIELD_ABOUTME') . '),' .
				'(' . $db->Quote('5') . ', ' . $db->Quote('group') . ', ' . $db->Quote('5') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Контактная информация') . ', ' . $db->Quote('Контактная информация') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('') . '),' .
				'(' . $db->Quote('6') . ', ' . $db->Quote('text') . ', ' . $db->Quote('6') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Моб.телефон') .', ' . $db->Quote('Укажите мобильный телефон, если желаете, чтобы другие пользователи могли связаться с Вами.') . ', ' . $db->Quote('1') . ', ' . $db->Quote('0') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('FIELD_MOBILE') . '),' .
				'(' . $db->Quote('7') . ', ' . $db->Quote('text') . ', ' . $db->Quote('7') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Стац.телефон') . ', ' . $db->Quote('Укажите Ваш домашний или рабочий телефон, если желаете, чтобы другие пользователи могли связаться с Вами.') . ', ' . $db->Quote('1') . ', ' . $db->Quote('0') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('FIELD_LANDPHONE') . '),' .
				'(' . $db->Quote('8') . ', ' . $db->Quote('textarea') . ', ' . $db->Quote('8') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Адрес') .', ' . $db->Quote('Улица, дом') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('FIELD_ADDRESS') . '),' .
				'(' . $db->Quote('9') . ', ' . $db->Quote('text') . ', ' . $db->Quote('9') . ', ' . $db->Quote('1') . ', ' . $db->Quote('10') . ', ' . $db->Quote('100') . ', ' . $db->Quote('Регион') . ', ' . $db->Quote('Регион проживания') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('1') . ', ' . $db->Quote('') . ', ' . $db->Quote('FIELD_STATE') . '),' .
				'(' . $db->Quote('10') . ', ' . $db->Quote('text') . ', ' . $db->Quote('10') .', ' . $db->Quote('1') .', ' . $db->Quote('10') .', ' . $db->Quote('100') .', ' . $db->Quote('Город') .', ' . $db->Quote('Укажите населенный пункт в котором Вы живёте') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('') .', ' . $db->Quote('FIELD_CITY') . '),' .
				'(' . $db->Quote('11') . ', ' . $db->Quote('country') .', ' . $db->Quote('11') .', ' . $db->Quote('1') .', ' . $db->Quote('10') .', ' . $db->Quote('100') .', ' . $db->Quote('Страна') .', ' . $db->Quote('Страна проживания') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('Австралия'."\n".'Австрия'."\n".'Азербайджан'."\n".'Аландские острова'."\n".'Албания'."\n".'Алжир'."\n".'Американские острова Самоа'."\n".'Ангилья'."\n".'Ангола'."\n".'Андорра'."\n".'Антарктика'."\n".'Антигуа и Барбуда'."\n".'Аргентина'."\n".'Армения'."\n".'Аруба'."\n".'Афганистан'."\n".'Багамы'."\n".'Бангладеш'."\n".'Барбадос'."\n".'Бахрейн'."\n".'Беларусь'."\n".'Белиз'."\n".'Бельгия'."\n".'Бенин'."\n".'Бермуды'."\n".'Болгария'."\n".'Боливия'."\n".'Босния и Герцеговина'."\n".'Ботсвана'."\n".'Бразилия'."\n".'Британская территория в Индийском океане'."\n".'Бруней-Даруссалам'."\n".'Буве, остров'."\n".'Буркина Фасо'."\n".'Бурунди'."\n".'Бутан'."\n".'Вануату'."\n".'Ватикан'."\n".'Великобритания'."\n".'Венгрия'."\n".'Венесуэла'."\n".'Виргинские острова, Британия'."\n".'Виргинские острова, США'."\n".'Внешние малые острова (США)'."\n".'Вьетнам'."\n".'Габон'."\n".'Гайана'."\n".'Гаити'."\n".'Гамбия'."\n".'Гана'."\n".'Гваделупа'."\n".'Гватемала'."\n".'Гвинея'."\n".'Гвинея-Бисау'."\n".'Германия'."\n".'Гернси'."\n".'Гибралтар'."\n".'Гондурас'."\n".'Гонконг'."\n".'Гренада'."\n".'Гренландия'."\n".'Греция'."\n".'Грузия'."\n".'Гуам'."\n".'Дания'."\n".'Джерси'."\n".'Джибути'."\n".'Доминика'."\n".'Доминиканская Республика'."\n".'Египет'."\n".'Замбия'."\n".'Западная Сахара'."\n".'Зимбабве'."\n".'Йемен'."\n".'Израиль'."\n".'Индия'."\n".'Индонезия'."\n".'Иордания'."\n".'Ирак'."\n".'Иран, Исламская Республика'."\n".'Ирландия'."\n".'Исландия'."\n".'Испания'."\n".'Италия'."\n".'Кабо Верде'."\n".'Казахстан'."\n".'Каймановы острова'."\n".'Камбоджа'."\n".'Камерун'."\n".'Канада'."\n".'Катар'."\n".'Кения'."\n".'Кипр'."\n".'Киргизия'."\n".'Кирибати'."\n".'Китай'."\n".'КНДР'."\n".'Кокосовые острова'."\n".'Колумбия'."\n".'Коморские острова'."\n".'Конго'."\n".'Конго, Демократ.Республика'."\n".'Корея, Республика'."\n".'Коста Рика'."\n".'Кот-д-Ивуар'."\n".'Куба'."\n".'Кувейт'."\n".'Лаос'."\n".'Латвия'."\n".'Лесото'."\n".'Либерия'."\n".'Ливан'."\n".'Ливия'."\n".'Литва'."\n".'Лихтенштейн'."\n".'Люксембург'."\n".'Маврикий'."\n".'Мавритания'."\n".'Мадагаскар'."\n".'Майотта'."\n".'Макао'."\n".'Македония'."\n".'Малави'."\n".'Малайзия'."\n".'Мали'."\n".'Мальдивы'."\n".'Мальта'."\n".'Мартиника'."\n".'Маршалловы острова'."\n".'Мексика'."\n".'Микронезия'."\n".'Мозамбик'."\n".'Молдова'."\n".'Монако'."\n".'Монголия'."\n".'Монтенегро'."\n".'Монтсеррат'."\n".'Морокко'."\n".'Мьянмы'."\n".'Намибия'."\n".'Науру'."\n".'Непал'."\n".'Нигер'."\n".'Нигерия'."\n".'Нидерландские Антильские острова'."\n".'Нидерланды'."\n".'Никарагуа'."\n".'Ниуэ'."\n".'Новая Зеландия'."\n".'Новая Каледония'."\n".'Норвегия'."\n".'Объединенные Арабские Эмираты'."\n".'Оман'."\n".'Остров Мэн'."\n".'Остров Норфолк'."\n".'Остров Рождества'."\n".'Остров Святой Елены'."\n".'Острова Кука'."\n".'Острова Теркс и Кайкос'."\n".'Пакистан'."\n".'Палау'."\n".'Палестина'."\n".'Панама'."\n".'Папуа-Новая Гвинея'."\n".'Парагвай'."\n".'Перу'."\n".'Питкэрн'."\n".'Польша'."\n".'Португалия'."\n".'Пуэрто-Рико'."\n".'Реюньон'."\n".'Российская Федерация'."\n".'Руанда'."\n".'Румыния'."\n".'Сальвадор'."\n".'Самоа'."\n".'Сан-Марино'."\n".'Сан-Томе и Принсипи'."\n".'Саудовская Аравия'."\n".'Свазиленд'."\n".'Северные Марианские острова'."\n".'Сейшельские острова'."\n".'Сенегал'."\n".'Сен-Мартен'."\n".'Сен-Пьер и Микелон'."\n".'Сент-Бартелеми'."\n".'Сент-Винсент и Гренадины'."\n".'Сент-Китс и Невис'."\n".'Сент-Люсия'."\n".'Сербия'."\n".'Сингапур'."\n".'Сирия'."\n".'Словакия'."\n".'Словения'."\n".'Соломоновы Острова'."\n".'Сомали'."\n".'Судан'."\n".'Суринам'."\n".'США'."\n".'Сьерра-Леоне'."\n".'Таджикистан'."\n".'Тайвань'."\n".'Тайланд'."\n".'Танзания'."\n".'Тимор-Лешти'."\n".'Того'."\n".'Токелау'."\n".'Тонга'."\n".'Тринидад и Тобаго'."\n".'Тувалу'."\n".'Тунис'."\n".'Туркменистан'."\n".'Турция'."\n".'Уганда'."\n".'Узбекистан'."\n".'Украина'."\n".'Уоллис и Футуна'."\n".'Уругвай'."\n".'Фарерские острова'."\n".'Фиджи'."\n".'Филиппины'."\n".'Финляндия'."\n".'Фолклендские (Мальвинские) острова'."\n".'Франция'."\n".'Французская Гвиана'."\n".'Французская Полинезия'."\n".'Французские Южные Территории'."\n".'Херд и Макдональд'."\n".'Хорватия'."\n".'Центрально-Африканская Республика'."\n".'Чад'."\n".'Чехия'."\n".'Чили'."\n".'Швейцария'."\n".'Швеция'."\n".'Шпицберген и Ян-Майен'."\n".'Шри Ланка'."\n".'Эквадор'."\n".'Экваториальная Гвинея'."\n".'Эритрея'."\n".'Эстония'."\n".'Эфиопия'."\n".'Южная Африка'."\n".'Южная Георгия и Южные Сандвичевы острова'."\n".'Ямайка'."\n".'Япония') .', ' . $db->Quote('FIELD_COUNTRY'). '),' .
				'(' . $db->Quote('12') . ', ' . $db->Quote('url') . ', ' . $db->Quote('12') .', ' . $db->Quote('1') .', ' . $db->Quote('10') .', ' . $db->Quote('100') .', ' . $db->Quote('Сайт') .', ' . $db->Quote('Ваш сайт') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('') .', ' . $db->Quote('FIELD_WEBSITE') . '),' .
				'(' . $db->Quote('13') . ', ' . $db->Quote('group') . ', ' . $db->Quote('13') .', ' . $db->Quote('1') . ', ' . $db->Quote('10') .', ' . $db->Quote('100') .', ' . $db->Quote('Образование') .', ' . $db->Quote('Образование') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('') . ', ' . $db->Quote('') .'),' .
				'(' . $db->Quote('14') . ', ' . $db->Quote('text') .', ' . $db->Quote('14') .', ' . $db->Quote('1') .', ' . $db->Quote('10') .', ' . $db->Quote('200') .', ' . $db->Quote('Учебное заведение') .', ' . $db->Quote('Укажите учебное заведение в котором Вы учились') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('') .', ' . $db->Quote('FIELD_COLLEGE') . '),' .
				'(' . $db->Quote('15') . ', ' . $db->Quote('text') . ', ' . $db->Quote('15') .', ' . $db->Quote('1') .', ' . $db->Quote('5') .', ' . $db->Quote('100') .', ' . $db->Quote('Год окончания') .', ' . $db->Quote('Год окончания учебного заведения') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('1') .', ' . $db->Quote('') .', ' . $db->Quote('FIELD_GRADUATION') .')';

	$db->setQuery( $query );
	$db->query();
	
	if($db->getErrorNum())
	{
		return false;
	}	
	return true;
}

function addDefaultGroupCategories()
{
	$db 	=& JFactory::getDBO();
	
	$query 	= 'INSERT INTO ' . $db->nameQuote('#__community_groups_category') . ' (' . $db->nameQuote('id') .', ' . $db->nameQuote('name') .', ' . $db->nameQuote('description') .') VALUES ' .
				'(' . $db->Quote('1') .', ' . $db->Quote('Общая категория') .', ' . $db->Quote('Общая категория групп.') .'),'.
				'(' . $db->Quote('2') .', ' . $db->Quote('Интернет') .', ' . $db->Quote('Категория групп, связанных с ресурсами сети интернет.') . '),'.
				'(' . $db->Quote('3') .', ' . $db->Quote('Бизнес') .', ' . $db->Quote('Категория групп бизнес-интересов') .'),'.
				'(' . $db->Quote('4') .', ' . $db->Quote('Авто и мото') .', ' . $db->Quote('Категория групп авто/мото любителей') .'),'.
				'(' . $db->Quote('5') .', ' . $db->Quote('Музыка') .', ' . $db->Quote('Категория групп музыкальной направленности') .')';
	
	$db->setQuery( $query );
	
	$db->query();
	
	if($db->getErrorNum())
	{
		return false;
	}	
	return true;
}

function addDefaultVideosCategories()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'INSERT INTO '.$db->nameQuote('#__community_videos_category') .'(' . $db->nameQuote('id') .', ' . $db->nameQuote('name') .', ' . $db->nameQuote('description') .', ' . $db->nameQuote('published') .' )'.
				' VALUES ( NULL , ' . $db->Quote('Общая категория') .', ' . $db->Quote('Общий канал видео') .', ' . $db->Quote('1') .')';
	
	$db->setQuery( $query );
	
	$db->query();
	
	if($db->getErrorNum())
	{
		return false;
	}	
	return true;
}

function addDefaultEventsCategories()
{
	$db		=& JFactory::getDBO();

	$query	= 'INSERT INTO '.$db->nameQuote("#__community_events_category").'(' . $db->nameQuote('name') .', ' . $db->nameQuote('description') .' ) VALUES ' .
				'( ' . $db->Quote('Общая категория') .', ' . $db->Quote('Общая категория мероприятий') .'),'.
				'( ' . $db->Quote('Празднование') .', ' . $db->Quote('Мероприятия празднований дней рождения, юбилеев') .'),'.
				'( ' . $db->Quote('Встречи/вечеринки') .', ' . $db->Quote('Категория мероприятий для совместного отдыха') .')';

	$db->setQuery( $query );

	$db->query();

	if($db->getErrorNum())
	{
		return false;
	}
	return true;
}

function addDefaultUserPoints()
{
	$db 	=& JFactory::getDBO();

	$query = "INSERT INTO `#__community_userpoints` (`rule_name`, `rule_description`, `rule_plugin`, `action_string`, `component`, `access`, `points`, `published`, `system`) VALUES
				('Добавление приложения', 'Увеличение баллов при добавлении приложения пользователем.', 'com_community', 'application.add', '', 1, 0, 0, 1),
				('Удаление приложения', 'Уменьшение баллов при удалении приложения пользователем.', 'com_community', 'application.remove', '', 1, 0, 0, 1),
				('Загрузка фото', 'Увеличение баллов при загрузке фото пользователем.', 'com_community', 'photo.upload', '', 1, 0, 1, 1),
				('Создание группы', 'Увеличение баллов при создании группы.', 'com_community', 'group.create', '', 1, 3, 1, 1),
				('Создание обсуждения в группе', 'Увеличение баллов при создании обсуждения в группе.', 'com_community', 'group.discussion.create', '', 1, 2, 1, 1),
				('Выход из группы', 'Уменьшение баллов при выходе из группы участника.', 'com_community', 'group.leave', '', 1, -1, 1, 1),
				('Заключение дружбы', 'Увеличение баллов при заключении дружбы.', 'com_community', 'friends.request.approve', '', 1, 1, 1, 1),
				('Добавление фотоальбома', 'Увеличение баллов при создании фотоальбома.', 'com_community', 'album.create', '', 1, 1, 1, 1),
				('Соробщение на стене в группе', 'Увеличение баллов при создании сообщения на стене группы.', 'com_community', 'group.wall.create', '', 1, 1, 1, 1),
				('Присоединение к группе', 'Увеличение баллов при присоединении пользователя к группе.', 'com_community', 'group.join', '', 1, 1, 1, 1),
				('Ответ в обсуждении группы', 'Увеличение баллов при создании сообщения в обсуждении группы .', 'com_community', 'group.discussion.reply', '', 1, 1, 1, 1),
				('Сообщение на стене', 'Увеличение баллов при создании сообщения на стене профиля.', 'com_community', 'profile.wall.create', '', 1, 1, 1, 1),
				('Обновление статуса профиля', 'Увеличение баллов при обновлении статуса.', 'com_community', 'profile.status.update', '', 1, 1, 1, 1),
				('Обновление профиля', 'Увеличение баллов при обновлении профиля.', 'com_community', 'profile.save', '', 1, 1, 1, 1),
				('Обновление группы', 'Увеличение баллов при обновлении в группе.', 'com_community', 'group.updated', '', 1, 1, 1, 1),
				('Загрузка логотипа группы', 'Увеличение баллов при загрузке логотипа для группы.', 'com_community', 'group.avatar.upload', '', 1, 0, 1, 1),
				('Публикация новости в группе', 'Увеличение баллов при создании новости в группе.', 'com_community', 'group.news.create', '', 1, 1, 1, 1),
				('Комментарий на стене фото', 'Увеличение баллов при создании комментария к фото.', 'com_community', 'photos.wall.create', '', 1, 1, 1, 1),
				('Удаление друга', 'Уменьшение баллов при удалении друга.', 'com_community', 'friends.remove', '', 1, 0, 1, 1),
				('Загрузка аватара', 'Увеличение баллов при загрузке аватара.', 'com_community', 'profile.avatar.upload', '', 1, 0, 1, 1),
				('Обновление приватности', 'Увеличение баллов при обновлении приватности.', 'com_community', 'profile.privacy.update', '', 1, 0, 1, 1),
				('Ответ на сообщение', 'Увеличение баллов при ответе на личное сообщение.', 'com_community', 'inbox.message.reply', '', 1, 0, 1, 1),
				('Отправка сообщения', 'Увеличение баллов при создании личного сообщения.', 'com_community', 'inbox.message.send', '', 1, 0, 1, 1),
				('Удаление участника группы', 'Уменьшение баллов при удалении участника из группы.', 'com_community', 'group.member.remove', '', 1, 0, 1, 1),
				('Удаление новостей', 'Уменьшение баллов при удалении новости.', 'com_community', 'group.news.remove', '', 1, 0, 1, 1),
				('Удаление стены', 'Уменьшение баллов при удалении стены.', 'com_community', 'wall.remove', '', 1, 0, 1, 1),
				('Удаление фотоальбома', 'Уменьшение баллов при удалении фотоальбома.', 'com_community', 'album.remove', '', 1, 0, 1, 1),
				('Удаление фото', 'Уменьшение баллов при удалении фото.', 'com_community', 'photo.remove', '', 1, 0, 1, 1),
                                ('Обновление мероприятия', 'Увеличение баллов при обновлении информации о мероприятиии.', 'com_community', 'events.update', '', 1, 1, 1, 1)";

	$db->setQuery( $query );
	$db->query();
	
	if($db->getErrorNum())
	{
		return false;
	}	
	return true;
}

function menuExist()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__menu' ) . ' '
			. 'WHERE ' . $db->nameQuote( 'link' ) . ' LIKE ' .  $db->Quote( '%option=com_community%') . ' '
			. 'AND ' . $db->nameQuote('menutype') . ' != ' . $db->Quote('main');

	$db->setQuery( $query );
	
	$needUpdate	= ( $db->loadResult() >= 1 ) ? true : false;
	
	return $needUpdate;
}

function menuTypesExist()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__menu_types' ) . ' '
			. 'WHERE ' . $db->nameQuote( 'menutype' ) . ' = ' .  $db->Quote( 'jomsocial') . ' '
			. 'AND ' . $db->nameQuote('title') . ' = ' . $db->Quote('JomSocial toolbar');

	$db->setQuery( $query );
	
	$needUpdate	= ( $db->loadResult() >= 1 ) ? true : false;
	
	return $needUpdate;
}

/**
 * Method to update menu's component id.
 *
 * @return boolean true on success false on failure.
 */
function updateMenuItems()
{
	// Get new component id.
	$component		= JComponentHelper::getComponent('com_community');
	$component_id	= 0;
	if (is_object($component) && isset($component->id)){
		$component_id 	= $component->id;
	}
	
	if ($component_id > 0)
	{
		// Update the existing menu items.
		$db 	= JFactory::getDBO();
		
		$query 	= 'UPDATE ' . $db->nameQuote( '#__menu' ) . ' '
				. 'SET '.$db->nameQuote(JOOMLA_MENU_COMPONENT_ID).'=' . $db->Quote( $component_id ) . ' '
				. 'WHERE ' . $db->nameQuote('link') .' LIKE ' . $db->Quote('%option=com_community%');
	
		$db->setQuery( $query );
		$db->query();
		
		if($db->getErrorNum())
		{
			return false;
		}
	}
	return true;
}

function needsDefaultCustomFields()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__community_fields' );
	$db->setQuery( $query );

	$needUpdate	= ( $db->loadResult() > 0 ) ? false : true;
	
	return $needUpdate;
}

function needsDefaultGroupCategories()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__community_groups_category' );
	$db->setQuery( $query );

	$needUpdate	= ( $db->loadResult() > 0 ) ? false : true;
	
	return $needUpdate;
}

function needsDefaultVideosCategories()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__community_videos_category' );
	$db->setQuery( $query );

	$needUpdate	= ( $db->loadResult() > 0 ) ? false : true;
	
	return $needUpdate;
}

function needsDefaultEventsCategories()
{
	$db		=& JFactory::getDBO();

	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__community_events_category' );
	$db->setQuery( $query );

	$needUpdate	= ( $db->loadResult() > 0 ) ? false : true;

	return $needUpdate;
}

function needsDefaultUserPoints()
{
	$db		=& JFactory::getDBO();
	
	$query	= 'SELECT COUNT(*) FROM ' . $db->nameQuote( '#__community_userpoints' );
	$query	.= ' WHERE ' . $db->nameQuote('system') .' = 1';
	$db->setQuery( $query );

	$needUpdate	= ( $db->loadResult() > 0 ) ? false : true;
	
	return $needUpdate;
}

function addDefaultToolbarMenus()
{
	$db		= JFactory::getDBO();
	$file	= JPATH_ROOT . DS . 'administrator' .  DS . 'components' . DS . 'com_community' . DS . 'toolbar.xml';
	$menu_name = JOOMLA_MENU_NAME;
	$menu_parent = JOOMLA_MENU_PARENT;
	$menu_level = JOOMLA_MENU_LEVEL;
	$parser =& JFactory::getXMLParser('Simple');
	$parser->loadFile( $file );
	
	$items	= $parser->document->getElementByPath( 'items' );

	$i	= 1;
	foreach( $items->children() as $item )
	{
		$obj		= new stdClass();

		// Retrieve the menu name
		$element	= $item->getElementByPath( 'name' );
		$obj->$menu_name	= !empty( $element ) ? $element->data() : '';

		// Retrieve the menu alias
		$element	= $item->getElementByPath( 'alias' );
		$obj->alias	= !empty( $element ) ? $element->data() : '';

		// Retrieve the menu link
		$element	= $item->getElementByPath( 'link' );
		$obj->link	= !empty( $element ) ? $element->data() : '';
		
		$obj->menutype	= 'jomsocial';
		$obj->type		= 'component';
		$obj->published	= 1;
		$obj->$menu_parent	= JOOMLA_MENU_ROOT_PARENT;
		$obj->$menu_level	= JOOMLA_MENU_LEVEL_PARENT;
		$obj->ordering	= $i;
		

		$childs			= $item->getElementByPath( 'childs' );
		
		if (!JOOMLA_LEGACY_VERSION)
		{
			$obj->language	= '*';

			//J1.6: menu item ordering follow lft and rgt
			$query 	= 'SELECT ' . $db->nameQuote( 'rgt' ) . ' '
					. 'FROM ' . $db->nameQuote( '#__menu' ) . ' '
					. 'ORDER BY ' . $db->nameQuote( 'rgt' ) . ' DESC LIMIT 1';
			$db->setQuery( $query );
			$obj->lft 	= $db->loadResult() + 1;
			$totalchild = $childs?count($childs->children()):0;
			$obj->rgt	= $obj->lft + $totalchild * 2 + 1;
		}
			
		$db->insertObject( '#__menu' , $obj );
		if ($db->getErrorNum()) {
			return false;
		}
		$parentId		= $db->insertid();
		
		if( $childs )
		{	
			$x	= 1;
			
			foreach( $childs->children() as $child )
			{
				$childObj		= new stdClass();
				
				// Retrieve the menu name
				$element	= $child->getElementByPath( 'name' );
				$childObj->$menu_name	= !empty( $element ) ? $element->data() : '';

				// Retrieve the menu alias
				$element	= $child->getElementByPath( 'alias' );
				$childObj->alias	= !empty( $element ) ? $element->data() : '';
		
				// Retrieve the menu link
				$element	= $child->getElementByPath( 'link' );
				$childObj->link	= !empty( $element ) ? $element->data() : '';
				
				$childObj->menutype	= 'jomsocial';
				$childObj->type		= 'component';
				$childObj->published	= 1;
				$childObj->$menu_parent	= $parentId;
				$childObj->$menu_level	= JOOMLA_MENU_LEVEL_PARENT + 1;
				$childObj->ordering	= $x;
				
				if (!JOOMLA_LEGACY_VERSION)
				{
					$childObj->language	= '*';
					//J1.6: menu item ordering follow lft and rgt
					$childObj->lft 	= $obj->lft + ($x - 1)* 2 + 1;
					$childObj->rgt	= $childObj->lft + 1;
				}

				$db->insertObject( '#__menu' , $childObj );
				if ($db->getErrorNum()) {
					return false;
				}
				
				$x++;
			}
		}
		$i++;
	}
	return true;
}

function addDefaultMenuTypes()
{
	$db		= JFactory::getDBO();
	$query	= 'INSERT INTO ' . $db->nameQuote( '#__menu_types' ) . ' (' . $db->nameQuote('menutype') .',' . $db->nameQuote('title') .',' . $db->nameQuote('description') .') VALUES '
	    			. '( ' . $db->Quote( 'jomsocial' ) . ',' . $db->Quote( 'JomSocial toolbar' ) . ',' . $db->Quote( 'Панель меню компонента JomSocial') . ')';
	$db->setQuery( $query );
	$db->Query();
	if ($db->getErrorNum())
	{
		return false;
	}
	return true;
}
