/****************************************************************
  *                                                              *
  *  CurvyCorners                                                *
  *  ------------                                                *
  *                                                              *
  *  This script generates rounded corners for your boxes.       *
  *                                                              *
  *  Version 2.1                                             *
  *  Copyright (c) 2010 Cameron Cooke                            *
  *  Contributors: Tim Hutchison, CPK Smithies, Terry Riegel,    *
  *                Sim� Albert.                                  *
  *                                                              *
  *  Website: http://www.curvycorners.net                        *
  *  SVN:     http://curvycorners.googlecode.com/                *
  *  Email:   cameron@curvycorners.net                           *
  *  Discuss: http://groups.google.com/group/curvycorners        *
  *                                                              *
  *  Please consult the SVN for a list of changes since the last *
  *  revision.                                                   *
  *                                                              *
  *  This library is free software; you can redistribute         *
  *  it and/or modify it under the terms of the GNU              *
  *  Lesser General Public License as published by the           *
  *  Free Software Foundation; either version 2.1 of the         *
  *  License, or (at your option) any later version.             *
  *                                                              *
  *  This library is distributed in the hope that it will        *
  *  be useful, but WITHOUT ANY WARRANTY; without even the       *
  *  implied warranty of MERCHANTABILITY or FITNESS FOR A        *
  *  PARTICULAR PURPOSE. See the GNU Lesser General Public       *
  *  License for more details.                                   *
  *                                                              *
  *  You should have received a copy of the GNU Lesser           *
  *  General Public License along with this library;             *
  *  Inc., 59 Temple Place, Suite 330, Boston,                   *
  *  MA 02111-1307 USA                                           *
  *  BB: put this into a closure so that it doesn't conflict     *
  *  BB: fixed first of two curvyCornersVerbose check see BB     *
  ****************************************************************//*
Version 2.x now autoMagically applies borders via CSS rules.

Opera and Chrome support rounded corners via

border-radius

Safari and Mozilla support rounded borders via

-webkit-border-radius, -moz-border-radius

We let these browsers render their borders natively.
Firefox for Windows renders non-antialiased
borders so they look a bit ugly. Google's Chrome will render its "ugly"
borders as well. So if we let FireFox, Safari, Opera and Chrome render
their borders natively, then we only have to support IE
for rounded borders. Fortunately IE reads CSS properties
that it doesn't understand (Opera, Firefox and Safari discard them);
so for IE we find and apply -moz-border-radius and friends.

So to make curvycorners work with any major browser simply add the
following CSS declarations and it should be good to go...

.round {
  border-radius: 3ex;
  -webkit-border-radius: 3ex;
  -moz-border-radius: 3ex;
}
*/function browserdetect(){var a=navigator.userAgent.toLowerCase();this.isIE=a.indexOf("msie")>-1;if(this.isIE)this.ieVer=/msie\s(\d\.\d)/.exec(a)[1],this.quirksMode=!document.compatMode||document.compatMode.indexOf("BackCompat")>-1,this.get_style=function(a,b){if(!(b in a.currentStyle))return"";var c=/^([\d.]+)(\w*)/.exec(a.currentStyle[b]);if(!c)return a.currentStyle[b];if(c[1]==0)return"0";if(c[2]&&c[2]!=="px"){var d=a.style.left,e=a.runtimeStyle.left;a.runtimeStyle.left=a.currentStyle.left,a.style.left=c[1]+c[2],c[0]=a.style.pixelLeft,a.style.left=d,a.runtimeStyle.left=e}return c[0]},this.supportsCorners=!1;else{this.ieVer=this.quirksMode=0,this.get_style=function(a,b){b=b.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();return document.defaultView.getComputedStyle(a,"").getPropertyValue(b)},this.isSafari=a.indexOf("safari")!=-1,this.isWebKit=a.indexOf("webkit")!=-1,this.isOp="opera"in window;if(this.isOp)this.supportsCorners=(this.isOp=window.opera.version())>=10.5;else{if(!this.isWebkit)if(!(this.isMoz=a.indexOf("firefox")!==-1))for(var b=document.childNodes.length;--b>=0;)if("style"in document.childNodes[b]){this.isMoz="MozBorderRadius"in document.childNodes[b].style;break}this.supportsCorners=this.isWebKit||this.isMoz}}}var curvyBrowser=new browserdetect;if(curvyBrowser.isIE)try{document.execCommand("BackgroundImageCache",!1,!0)}catch(e){}function curvyCnrSpec(a){this.selectorText=a,this.tlR=this.trR=this.blR=this.brR=0,this.tlu=this.tru=this.blu=this.bru="",this.antiAlias=!0}curvyCnrSpec.prototype.setcorner=function(a,b,c,d){if(a){var e=a.charAt(0)+b.charAt(0);this[e+"R"]=parseInt(c),this[e+"u"]=d}else this.tlR=this.trR=this.blR=this.brR=parseInt(c),this.tlu=this.tru=this.blu=this.bru=d},curvyCnrSpec.prototype.get=function(a){if(/^(t|b)(l|r)(R|u)$/.test(a))return this[a];if(/^(t|b)(l|r)Ru$/.test(a)){var b=a.charAt(0)+a.charAt(1);return this[b+"R"]+this[b+"u"]}if(/^(t|b)Ru?$/.test(a)){var c=a.charAt(0);c+=this[c+"lR"]>this[c+"rR"]?"l":"r";var d=this[c+"R"];a.length===3&&a.charAt(2)==="u"&&(d+=this[c="u"]);return d}throw new Error("Don't recognize property "+a)},curvyCnrSpec.prototype.radiusdiff=function(a){if(a!=="t"&&a!=="b")throw new Error("Param must be 't' or 'b'");return Math.abs(this[a+"lR"]-this[a+"rR"])},curvyCnrSpec.prototype.setfrom=function(a){this.tlu=this.tru=this.blu=this.bru="px","tl"in a&&(this.tlR=a.tl.radius),"tr"in a&&(this.trR=a.tr.radius),"bl"in a&&(this.blR=a.bl.radius),"br"in a&&(this.brR=a.br.radius),"antiAlias"in a&&(this.antiAlias=a.antiAlias)},curvyCnrSpec.prototype.cloneOn=function(a){var b=["tl","tr","bl","br"],c=0,d,e;for(d in b)if(!isNaN(d)){e=this[b[d]+"u"];if(e!==""&&e!=="px"){c=new curvyCnrSpec;break}}if(c){var f,g,h=curvyBrowser.get_style(a,"left");for(d in b)if(!isNaN(d)){f=b[d],e=this[f+"u"],g=this[f+"R"];if(e!=="px"){var i=a.style.left;a.style.left=g+e,g=a.style.pixelLeft,a.style.left=i}c[f+"R"]=g,c[f+"u"]="px"}a.style.left=h}else c=this;return c},curvyCnrSpec.prototype.radiusSum=function(a){if(a!=="t"&&a!=="b")throw new Error("Param must be 't' or 'b'");return this[a+"lR"]+this[a+"rR"]},curvyCnrSpec.prototype.radiusCount=function(a){var b=0;this[a+"lR"]&&++b,this[a+"rR"]&&++b;return b},curvyCnrSpec.prototype.cornerNames=function(){var a=[];this.tlR&&a.push("tl"),this.trR&&a.push("tr"),this.blR&&a.push("bl"),this.brR&&a.push("br");return a};function operasheet(a){var b=document.styleSheets.item(a).ownerNode.text;b=b.replace(/\/\*(\n|\r|.)*?\*\//g,"");var c=new RegExp("^\\s*([\\w.#][-\\w.#, ]+)[\\n\\s]*\\{([^}]+border-((top|bottom)-(left|right)-)?radius[^}]*)\\}","mg"),d;this.rules=[];while((d=c.exec(b))!==null){var e=new RegExp("(..)border-((top|bottom)-(left|right)-)?radius:\\s*([\\d.]+)(in|em|px|ex|pt)","g"),f,g=new curvyCnrSpec(d[1]);while((f=e.exec(d[2]))!==null)f[1]!=="z-"&&g.setcorner(f[3],f[4],f[5],f[6]);this.rules.push(g)}}operasheet.contains_border_radius=function(a){return/border-((top|bottom)-(left|right)-)?radius/.test(document.styleSheets.item(a).ownerNode.text)};function curvyCorners(){var a,b,c,d,e;if(typeof arguments[0]!=="object")throw curvyCorners.newError("First parameter of curvyCorners() must be an object.");if(arguments[0]instanceof curvyCnrSpec)d=arguments[0],!d.selectorText&&typeof arguments[1]==="string"&&(d.selectorText=arguments[1]);else{if(typeof arguments[1]!=="object"&&typeof arguments[1]!=="string")throw curvyCorners.newError("Second parameter of curvyCorners() must be an object or a class name.");b=arguments[1],typeof b!=="string"&&(b=""),b!==""&&b.charAt(0)!=="."&&"autoPad"in arguments[0]&&(b="."+b),d=new curvyCnrSpec(b),d.setfrom(arguments[0])}if(d.selectorText){e=0;var f=d.selectorText.replace(/\s+$/,"").split(/,\s*/);c=[];for(a=0;a<f.length;++a)(b=f[a].lastIndexOf("#"))!==-1&&(f[a]=f[a].substr(b)),c=c.concat(curvyCorners.getElementsBySelector(f[a].split(/\s+/)))}else e=1,c=arguments;for(a=e,b=c.length;a<b;++a){var g=c[a],h=!1;g.className?(h=g.className.indexOf("curvyIgnore")!==-1,h||(g.className+=" curvyIgnore")):g.className="curvyIgnore";if(!h){g.className.indexOf("curvyRedraw")!==-1&&(typeof curvyCorners.redrawList==="undefined"&&(curvyCorners.redrawList=[]),curvyCorners.redrawList.push({node:g,spec:d,copy:g.cloneNode(!1)}));var i=new curvyObject(d,g);i.applyCorners()}}}curvyCorners.prototype.applyCornersToAll=function(){throw curvyCorners.newError("This function is now redundant. Just call curvyCorners(). See documentation.")},curvyCorners.redraw=function(){if(!curvyBrowser.supportsCorners){if(!curvyCorners.redrawList)throw curvyCorners.newError("curvyCorners.redraw() has nothing to redraw.");var a=curvyCorners.block_redraw;curvyCorners.block_redraw=!0;for(var b in curvyCorners.redrawList){if(isNaN(b))continue;var c=curvyCorners.redrawList[b];if(!c.node.clientWidth)continue;var d=c.copy.cloneNode(!1);for(var e=c.node.firstChild;e!==null;e=e.nextSibling)if(e.className.indexOf("autoPadDiv")!==-1)break;if(!e){curvyCorners.alert("Couldn't find autoPad DIV");break}c.node.parentNode.replaceChild(d,c.node);var f=e.getElementsByTagName("script");for(var g=f.length-1;g>=0;--g)f[g].parentNode.removeChild(f[g]);while(e.firstChild)d.appendChild(e.removeChild(e.firstChild));c=new curvyObject(c.spec,c.node=d),c.applyCorners()}curvyCorners.block_redraw=a}},curvyCorners.adjust=function(obj,prop,newval){if(!curvyBrowser.supportsCorners){if(!curvyCorners.redrawList)throw curvyCorners.newError("curvyCorners.adjust() has nothing to adjust.");var i,j=curvyCorners.redrawList.length;for(i=0;i<j;++i)if(curvyCorners.redrawList[i].node===obj)break;if(i===j)throw curvyCorners.newError("Object not redrawable");obj=curvyCorners.redrawList[i].copy}prop.indexOf(".")===-1?obj[prop]=newval:eval("obj."+prop+"='"+newval+"'")},curvyCorners.handleWinResize=function(){curvyCorners.block_redraw||curvyCorners.redraw()},curvyCorners.setWinResize=function(a){curvyCorners.block_redraw=!a},curvyCorners.newError=function(a){return new Error("curvyCorners Error:\n"+a)},curvyCorners.alert=function(a){typeof curvyCornersVerbose!=="undefined"&&curvyCornersVerbose&&alert(a)};function curvyObject(){var a;this.box=arguments[1],this.settings=arguments[0],this.topContainer=this.bottomContainer=this.shell=a=null;var b=this.box.clientWidth;if("canHaveChildren"in this.box&&!this.box.canHaveChildren||this.box.tagName==="TABLE")throw new Error(this.errmsg("You cannot apply corners to "+this.box.tagName+" elements.","Error"));!b&&curvyBrowser.isIE&&(this.box.style.zoom=1,b=this.box.clientWidth),!b&&curvyBrowser.get_style(this.box,"display")==="inline"&&(this.box.style.display="inline-block",curvyCorners.alert(this.errmsg("Converting inline element to inline-block","warning")),b=this.box.clientWidth);if(!b){if(!this.box.parentNode)throw this.newError("box has no parent!");for(a=this.box;;a=a.parentNode){if(!a||a.tagName==="BODY"){this.applyCorners=function(){},curvyCorners.alert(this.errmsg("zero-width box with no accountable parent","warning"));return}if(curvyBrowser.get_style(a,"display")==="none")break}var c=a.style.display;a.style.display="block",b=this.box.clientWidth}if(b){arguments[0]instanceof curvyCnrSpec?this.spec=arguments[0].cloneOn(this.box):(this.spec=new curvyCnrSpec(""),this.spec.setfrom(this.settings));var d=curvyBrowser.get_style(this.box,"borderTopWidth"),e=curvyBrowser.get_style(this.box,"borderBottomWidth"),f=curvyBrowser.get_style(this.box,"borderLeftWidth"),g=curvyBrowser.get_style(this.box,"borderRightWidth"),h=curvyBrowser.get_style(this.box,"borderTopColor"),i=curvyBrowser.get_style(this.box,"borderBottomColor"),j=curvyBrowser.get_style(this.box,"borderLeftColor"),k=curvyBrowser.get_style(this.box,"borderRightColor"),l=curvyBrowser.get_style(this.box,"borderTopStyle"),m=curvyBrowser.get_style(this.box,"borderBottomStyle"),n=curvyBrowser.get_style(this.box,"borderLeftStyle"),o=curvyBrowser.get_style(this.box,"borderRightStyle"),p=curvyBrowser.get_style(this.box,"backgroundColor"),q=curvyBrowser.get_style(this.box,"backgroundImage"),r=curvyBrowser.get_style(this.box,"backgroundRepeat"),s,t;this.box.currentStyle&&this.box.currentStyle.backgroundPositionX?(s=curvyBrowser.get_style(this.box,"backgroundPositionX"),t=curvyBrowser.get_style(this.box,"backgroundPositionY")):(s=curvyBrowser.get_style(this.box,"backgroundPosition"),s=s.split(" "),t=s.length===2?s[1]:0,s=s[0]);var u=curvyBrowser.get_style(this.box,"position"),v=curvyBrowser.get_style(this.box,"paddingTop"),w=curvyBrowser.get_style(this.box,"paddingBottom"),x=curvyBrowser.get_style(this.box,"paddingLeft"),y=curvyBrowser.get_style(this.box,"paddingRight"),z=curvyBrowser.ieVer>7?curvyBrowser.get_style(this.box,"filter"):null,A=this.spec.get("tR"),B=this.spec.get("bR"),C=function(a){if(typeof a==="number")return a;if(typeof a!=="string")throw new Error("unexpected styleToNPx type "+typeof a);var b=/^[-\d.]([a-z]+)$/.exec(a);if(b&&b[1]!="px")throw new Error("Unexpected unit "+b[1]);isNaN(a=parseInt(a))&&(a=0);return a},D=function(a){return a<=0?"0":a+"px"};try{this.borderWidth=C(d),this.borderWidthB=C(e),this.borderWidthL=C(f),this.borderWidthR=C(g),this.boxColour=curvyObject.format_colour(p),this.topPadding=C(v),this.bottomPadding=C(w),this.leftPadding=C(x),this.rightPadding=C(y),this.boxWidth=b,this.boxHeight=this.box.clientHeight,this.borderColour=curvyObject.format_colour(h),this.borderColourB=curvyObject.format_colour(i),this.borderColourL=curvyObject.format_colour(j),this.borderColourR=curvyObject.format_colour(k),this.borderString=this.borderWidth+"px "+l+" "+this.borderColour,this.borderStringB=this.borderWidthB+"px "+m+" "+this.borderColourB,this.borderStringL=this.borderWidthL+"px "+n+" "+this.borderColourL,this.borderStringR=this.borderWidthR+"px "+o+" "+this.borderColourR,this.backgroundImage=q!="none"?q:"",this.backgroundRepeat=r}catch(E){throw this.newError(E.message)}var F=this.boxHeight,G=b;if(curvyBrowser.isOp){var H;s=C(s),t=C(t),s&&(H=G+this.borderWidthL+this.borderWidthR,s>H&&(s=H),s=H/s*100+"%"),t&&(H=F+this.borderWidth+this.borderWidthB,t>H&&(t=H),t=H/t*100+"%")}curvyBrowser.quirksMode||(this.boxWidth-=this.leftPadding+this.rightPadding,this.boxHeight-=this.topPadding+this.bottomPadding),this.contentContainer=document.createElement("div"),z&&(this.contentContainer.style.filter=z);while(this.box.firstChild)this.contentContainer.appendChild(this.box.removeChild(this.box.firstChild));u!="absolute"&&(this.box.style.position="relative"),this.box.style.padding="0",this.box.style.border=this.box.style.backgroundImage="none",this.box.style.backgroundColor="transparent",this.box.style.width=G+this.borderWidthL+this.borderWidthR+"px",this.box.style.height=F+this.borderWidth+this.borderWidthB+"px";var I=document.createElement("div");I.style.position="absolute",z&&(I.style.filter=z),curvyBrowser.quirksMode?I.style.width=G+this.borderWidthL+this.borderWidthR+"px":I.style.width=G+"px",I.style.height=D(F+this.borderWidth+this.borderWidthB-A-B),I.style.padding="0",I.style.top=A+"px",I.style.left="0",this.borderWidthL&&(I.style.borderLeft=this.borderStringL),this.borderWidth&&!A&&(I.style.borderTop=this.borderString),this.borderWidthR&&(I.style.borderRight=this.borderStringR),this.borderWidthB&&!B&&(I.style.borderBottom=this.borderStringB),I.style.backgroundColor=p,I.style.backgroundImage=this.backgroundImage,I.style.backgroundRepeat=this.backgroundRepeat,I.style.direction="ltr",this.shell=this.box.appendChild(I),b=curvyBrowser.get_style(this.shell,"width");if(b===""||b==="auto"||b.indexOf("%")!==-1)throw this.newError("Shell width is "+b);this.boxWidth=b!==""&&b!="auto"&&b.indexOf("%")==-1?parseInt(b):this.shell.clientWidth,this.applyCorners=function(){this.backgroundPosX=this.backgroundPosY=0;if(this.backgroundObject){var b=function(a,b,c){if(a===0)return 0;if(a==="right"||a==="bottom")return c-b;if(a==="center")return(c-b)/2;if(a.indexOf("%")>0)return(c-b)*100/parseInt(a);return C(a)};this.backgroundPosX=b(s,this.backgroundObject.width,G),this.backgroundPosY=b(t,this.backgroundObject.height,F)}else this.backgroundImage&&(this.backgroundPosX=C(s),this.backgroundPosY=C(t));A&&(I=document.createElement("div"),I.style.width=this.boxWidth+"px",I.style.fontSize="1px",I.style.overflow="hidden",I.style.position="absolute",I.style.paddingLeft=this.borderWidth+"px",I.style.paddingRight=this.borderWidth+"px",I.style.height=A+"px",I.style.top=-A+"px",I.style.left=-this.borderWidthL+"px",this.topContainer=this.shell.appendChild(I)),B&&(I=document.createElement("div"),I.style.width=this.boxWidth+"px",I.style.fontSize="1px",I.style.overflow="hidden",I.style.position="absolute",I.style.paddingLeft=this.borderWidthB+"px",I.style.paddingRight=this.borderWidthB+"px",I.style.height=B+"px",I.style.bottom=-B+"px",I.style.left=-this.borderWidthL+"px",this.bottomContainer=this.shell.appendChild(I));var d=this.spec.cornerNames();for(var e in d)if(!isNaN(e)){var f=d[e],g=this.spec[f+"R"],h,i,j,k;f=="tr"||f=="tl"?(h=this.borderWidth,i=this.borderColour,k=this.borderWidth):(h=this.borderWidthB,i=this.borderColourB,k=this.borderWidthB),j=g-k;var l=document.createElement("div");l.style.height=this.spec.get(f+"Ru"),l.style.width=this.spec.get(f+"Ru"),l.style.position="absolute",l.style.fontSize="1px",l.style.overflow="hidden";var m,n,o,p=z?parseInt(/alpha\(opacity.(\d+)\)/.exec(z)[1]):100;for(m=0;m<g;++m){var q=m+1>=j?-1:Math.floor(Math.sqrt(Math.pow(j,2)-Math.pow(m+1,2)))-1;if(j!=g)var r=m>=j?-1:Math.ceil(Math.sqrt(Math.pow(j,2)-Math.pow(m,2))),u=m+1>=g?-1:Math.floor(Math.sqrt(Math.pow(g,2)-Math.pow(m+1,2)))-1;var v=m>=g?-1:Math.ceil(Math.sqrt(Math.pow(g,2)-Math.pow(m,2)));q>-1&&this.drawPixel(m,0,this.boxColour,p,q+1,l,!0,g);if(j!=g)if(this.spec.antiAlias){for(n=q+1;n<r;++n)if(this.backgroundImage!==""){var w=curvyObject.pixelFraction(m,n,j)*100;this.drawPixel(m,n,i,p,1,l,w>=30,g)}else if(this.boxColour!=="transparent"){var x=curvyObject.BlendColour(this.boxColour,i,curvyObject.pixelFraction(m,n,j));this.drawPixel(m,n,x,p,1,l,!1,g)}else this.drawPixel(m,n,i,p>>1,1,l,!1,g);u>=r&&(r==-1&&(r=0),this.drawPixel(m,r,i,p,u-r+1,l,!1,0)),o=i,n=u}else u>q&&this.drawPixel(m,q+1,i,p,u-q,l,!1,0);else o=this.boxColour,n=q;if(this.spec.antiAlias&&this.boxColour!=="transparent")while(++n<v)this.drawPixel(m,n,o,curvyObject.pixelFraction(m,n,g)*p,1,l,k<=0,g)}var y;for(H=0,y=l.childNodes.length;H<y;++H){var D=l.childNodes[H],E=parseInt(D.style.top),J=parseInt(D.style.left),K=parseInt(D.style.height);if(f=="tl"||f=="bl")D.style.left=g-J-1+"px";if(f=="tr"||f=="tl")D.style.top=g-K-E+"px";D.style.backgroundRepeat=this.backgroundRepeat;if(this.backgroundImage)switch(f){case"tr":D.style.backgroundPosition=this.backgroundPosX-this.borderWidthL+g-G-J+"px "+(this.backgroundPosY+K+E+this.borderWidth-g)+"px";break;case"tl":D.style.backgroundPosition=this.backgroundPosX-g+J+1+this.borderWidthL+"px "+(this.backgroundPosY-g+K+E+this.borderWidth)+"px";break;case"bl":D.style.backgroundPosition=this.backgroundPosX-g+J+1+this.borderWidthL+"px "+(this.backgroundPosY-F-this.borderWidth+(curvyBrowser.quirksMode?E:-E)+g)+"px";break;case"br":curvyBrowser.quirksMode?D.style.backgroundPosition=this.backgroundPosX-this.borderWidthL-G+g-J+"px "+(this.backgroundPosY-F-this.borderWidth+E+g)+"px":D.style.backgroundPosition=this.backgroundPosX-this.borderWidthL-G+g-J+"px "+(this.backgroundPosY-F-this.borderWidth+g-E)+"px"}}switch(f){case"tl":l.style.top=l.style.left="0",this.topContainer.appendChild(l);break;case"tr":l.style.top=l.style.right="0",this.topContainer.appendChild(l);break;case"bl":l.style.bottom=l.style.left="0",this.bottomContainer.appendChild(l);break;case"br":l.style.bottom=l.style.right="0",this.bottomContainer.appendChild(l)}}var L={t:this.spec.radiusdiff("t"),b:this.spec.radiusdiff("b")};for(var M in L){if(typeof M==="function")continue;if(!this.spec.get(M+"R"))continue;if(L[M]){var N=this.spec[M+"lR"]<this.spec[M+"rR"]?M+"l":M+"r",O=document.createElement("div");O.style.height=L[M]+"px",O.style.width=this.spec.get(N+"Ru"),O.style.position="absolute",O.style.fontSize="1px",O.style.overflow="hidden",O.style.backgroundColor=this.boxColour,z&&(O.style.filter=z),O.style.backgroundImage=this.backgroundImage,O.style.backgroundRepeat=this.backgroundRepeat;switch(N){case"tl":O.style.bottom=O.style.left="0",O.style.borderLeft=this.borderStringL,O.style.backgroundPosition=this.backgroundPosX+"px "+(this.borderWidth+this.backgroundPosY-this.spec.tlR)+"px",this.topContainer.appendChild(O);break;case"tr":O.style.bottom=O.style.right="0",O.style.borderRight=this.borderStringR,O.style.backgroundPosition=this.backgroundPosX-this.boxWidth+this.spec.trR+"px "+(this.borderWidth+this.backgroundPosY-this.spec.trR)+"px",this.topContainer.appendChild(O);break;case"bl":O.style.top=O.style.left="0",O.style.borderLeft=this.borderStringL,O.style.backgroundPosition=this.backgroundPosX+"px "+(this.backgroundPosY-this.borderWidth-this.boxHeight+L[M]+this.spec.blR)+"px",this.bottomContainer.appendChild(O);break;case"br":O.style.top=O.style.right="0",O.style.borderRight=this.borderStringR,O.style.backgroundPosition=this.borderWidthL+this.backgroundPosX-this.boxWidth+this.spec.brR+"px "+(this.backgroundPosY-this.borderWidth-this.boxHeight+L[M]+this.spec.brR)+"px",this.bottomContainer.appendChild(O)}}var P=document.createElement("div");z&&(P.style.filter=z),P.style.position="relative",P.style.fontSize="1px",P.style.overflow="hidden",P.style.width=this.fillerWidth(M),P.style.backgroundColor=this.boxColour,P.style.backgroundImage=this.backgroundImage,P.style.backgroundRepeat=this.backgroundRepeat;switch(M){case"t":if(this.topContainer){curvyBrowser.quirksMode?P.style.height=100+A+"px":P.style.height=100+A-this.borderWidth+"px",P.style.marginLeft=this.spec.tlR?this.spec.tlR-this.borderWidthL+"px":"0",P.style.borderTop=this.borderString;if(this.backgroundImage){var Q=this.spec.tlR?this.borderWidthL+this.backgroundPosX-this.spec.tlR+"px ":this.backgroundPosX+"px ";P.style.backgroundPosition=Q+this.backgroundPosY+"px",this.shell.style.backgroundPosition=this.backgroundPosX+"px "+(this.backgroundPosY-A+this.borderWidthL)+"px"}this.topContainer.appendChild(P)}break;case"b":if(this.bottomContainer){curvyBrowser.quirksMode?P.style.height=B+"px":P.style.height=B-this.borderWidthB+"px",P.style.marginLeft=this.spec.blR?this.spec.blR-this.borderWidthL+"px":"0",P.style.borderBottom=this.borderStringB;if(this.backgroundImage){var Q=this.spec.blR?this.backgroundPosX+this.borderWidthL-this.spec.blR+"px ":this.backgroundPosX+"px ";P.style.backgroundPosition=Q+(this.backgroundPosY-F-this.borderWidth+B)+"px"}this.bottomContainer.appendChild(P)}}}this.contentContainer.style.position="absolute",this.contentContainer.className="autoPadDiv",this.contentContainer.style.left=this.borderWidthL+"px",this.contentContainer.style.paddingTop=this.topPadding+"px",this.contentContainer.style.top=this.borderWidth+"px",this.contentContainer.style.paddingLeft=this.leftPadding+"px",this.contentContainer.style.paddingRight=this.rightPadding+"px",M=G,curvyBrowser.quirksMode||(M-=this.leftPadding+this.rightPadding),this.contentContainer.style.width=M+"px",this.contentContainer.style.textAlign=curvyBrowser.get_style(this.box,"textAlign"),this.box.style.textAlign="left",this.box.appendChild(this.contentContainer),a&&(a.style.display=c)},this.backgroundImage&&(s=this.backgroundCheck(s),t=this.backgroundCheck(t),this.backgroundObject&&(this.backgroundObject.holdingElement=this,this.dispatch=this.applyCorners,this.applyCorners=function(){this.backgroundObject.complete?this.dispatch():this.backgroundObject.onload=new Function("curvyObject.dispatch(this.holdingElement);")}))}else curvyCorners.alert(this.errmsg("zero-width box, cannot display","error")),this.applyCorners=function(){}}curvyObject.prototype.backgroundCheck=function(a){if(a==="top"||a==="left"||parseInt(a)===0)return 0;if(!/^[-\d.]+px$/.test(a)&&!this.backgroundObject){this.backgroundObject=new Image;var b=function(a){var b=/url\("?([^'"]+)"?\)/.exec(a);return b?b[1]:a};this.backgroundObject.src=b(this.backgroundImage)}return a},curvyObject.dispatch=function(a){if("dispatch"in a)a.dispatch();else throw a.newError("No dispatch function")},curvyObject.prototype.drawPixel=function(a,b,c,d,e,f,g,h){var i=document.createElement("div");i.style.height=e+"px",i.style.width="1px",i.style.position="absolute",i.style.fontSize="1px",i.style.overflow="hidden";var j=this.spec.get("tR");i.style.backgroundColor=c,g&&this.backgroundImage!==""&&(i.style.backgroundImage=this.backgroundImage,i.style.backgroundPosition="-"+(this.boxWidth-(h-a)+this.borderWidth)+"px -"+(this.boxHeight+j+b-this.borderWidth)+"px"),d!=100&&curvyObject.setOpacity(i,d),i.style.top=b+"px",i.style.left=a+"px",f.appendChild(i)},curvyObject.prototype.fillerWidth=function(a){var b,c;b=curvyBrowser.quirksMode?0:this.spec.radiusCount(a)*this.borderWidthL;if((c=this.boxWidth-this.spec.radiusSum(a)+b)<0)throw this.newError("Radius exceeds box width");return c+"px"},curvyObject.prototype.errmsg=function(a,b){var c="\ntag: "+this.box.tagName;this.box.id&&(c+="\nid: "+this.box.id),this.box.className&&(c+="\nclass: "+this.box.className);var d;(d=this.box.parentNode)===null?c+="\n(box has no parent)":(c+="\nParent tag: "+d.tagName,d.id&&(c+="\nParent ID: "+d.id),d.className&&(c+="\nParent class: "+d.className)),b===undefined&&(b="warning");return"curvyObject "+b+":\n"+a+c},curvyObject.prototype.newError=function(a){return new Error(this.errmsg(a,"exception"))},curvyObject.IntToHex=function(a){var b=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"];return b[a>>>4]+""+b[a&15]},curvyObject.BlendColour=function(a,b,c){if(a==="transparent"||b==="transparent")throw this.newError("Cannot blend with transparent");a.charAt(0)!=="#"&&(a=curvyObject.format_colour(a)),b.charAt(0)!=="#"&&(b=curvyObject.format_colour(b));var d=parseInt(a.substr(1,2),16),e=parseInt(a.substr(3,2),16),f=parseInt(a.substr(5,2),16),g=parseInt(b.substr(1,2),16),h=parseInt(b.substr(3,2),16),i=parseInt(b.substr(5,2),16);if(c>1||c<0)c=1;var j=Math.round(d*c+g*(1-c));j>255&&(j=255),j<0&&(j=0);var k=Math.round(e*c+h*(1-c));k>255&&(k=255),k<0&&(k=0);var l=Math.round(f*c+i*(1-c));l>255&&(l=255),l<0&&(l=0);return"#"+curvyObject.IntToHex(j)+curvyObject.IntToHex(k)+curvyObject.IntToHex(l)},curvyObject.pixelFraction=function(a,b,c){var d,e=c*c,f=Array(2),g=Array(2),h=0,i="",j=Math.sqrt(e-Math.pow(a,2));j>=b&&j<b+1&&(i="Left",f[h]=0,g[h]=j-b,++h),j=Math.sqrt(e-Math.pow(b+1,2)),j>=a&&j<a+1&&(i+="Top",f[h]=j-a,g[h]=1,++h),j=Math.sqrt(e-Math.pow(a+1,2)),j>=b&&j<b+1&&(i+="Right",f[h]=1,g[h]=j-b,++h),j=Math.sqrt(e-Math.pow(b,2)),j>=a&&j<a+1&&(i+="Bottom",f[h]=j-a,g[h]=0);switch(i){case"LeftRight":d=Math.min(g[0],g[1])+(Math.max(g[0],g[1])-Math.min(g[0],g[1]))/2;break;case"TopRight":d=1-(1-f[0])*(1-g[1])/2;break;case"TopBottom":d=Math.min(f[0],f[1])+(Math.max(f[0],f[1])-Math.min(f[0],f[1]))/2;break;case"LeftBottom":d=g[0]*f[1]/2;break;default:d=1}return d},curvyObject.rgb2Array=function(a){var b=a.substring(4,a.indexOf(")"));return b.split(/,\s*/)},curvyObject.rgb2Hex=function(a){try{var b=curvyObject.rgb2Array(a),c=parseInt(b[0]),d=parseInt(b[1]),e=parseInt(b[2]),f="#"+curvyObject.IntToHex(c)+curvyObject.IntToHex(d)+curvyObject.IntToHex(e)}catch(g){var h="getMessage"in g?g.getMessage():g.message;throw new Error("Error ("+h+") converting RGB value to Hex in rgb2Hex")}return f},curvyObject.setOpacity=function(a,b){b=b==100?99.999:b;if(curvyBrowser.isSafari&&a.tagName!="IFRAME"){var c=curvyObject.rgb2Array(a.style.backgroundColor),d=parseInt(c[0]),e=parseInt(c[1]),f=parseInt(c[2]);a.style.backgroundColor="rgba("+d+", "+e+", "+f+", "+b/100+")"}else typeof a.style.opacity!=="undefined"?a.style.opacity=b/100:typeof a.style.MozOpacity!=="undefined"?a.style.MozOpacity=b/100:typeof a.style.filter!=="undefined"?a.style.filter="alpha(opacity="+b+")":typeof a.style.KHTMLOpacity!=="undefined"&&(a.style.KHTMLOpacity=b/100)},curvyCorners.addEvent=function(a,b,c,d){if(a.addEventListener){a.addEventListener(b,c,d);return!0}if(a.attachEvent)return a.attachEvent("on"+b,c);a["on"+b]=c;return!1},typeof addEvent==="undefined"&&(addEvent=curvyCorners.addEvent),curvyObject.getComputedColour=function(a){var b=document.createElement("DIV");b.style.backgroundColor=a,document.body.appendChild(b);if(window.getComputedStyle){var c=document.defaultView.getComputedStyle(b,null).getPropertyValue("background-color");b.parentNode.removeChild(b),c.substr(0,3)==="rgb"&&(c=curvyObject.rgb2Hex(c));return c}var d=document.body.createTextRange();d.moveToElementText(b),d.execCommand("ForeColor",!1,a);var e=d.queryCommandValue("ForeColor"),f="rgb("+(e&255)+", "+((e&65280)>>8)+", "+((e&16711680)>>16)+")";b.parentNode.removeChild(b),d=null;return curvyObject.rgb2Hex(f)},curvyObject.format_colour=function(a){a!==""&&a!=="transparent"&&(a.substr(0,3)==="rgb"?a=curvyObject.rgb2Hex(a):a.charAt(0)!=="#"?a=curvyObject.getComputedColour(a):a.length===4&&(a="#"+a.charAt(1)+a.charAt(1)+a.charAt(2)+a.charAt(2)+a.charAt(3)+a.charAt(3)));return a},curvyCorners.getElementsByClass=function(a,b){var c=[];b===undefined&&(b=document),a=a.split(".");var d="*";a.length===1?(d=a[0],a=!1):(a[0]&&(d=a[0]),a=a[1]);var e,f,g;if(d.charAt(0)==="#")f=document.getElementById(d.substr(1)),f&&c.push(f);else{f=b.getElementsByTagName(d),g=f.length;if(a){var h=new RegExp("(^|\\s)"+a+"(\\s|$)");for(e=0;e<g;++e)h.test(f[e].className)&&c.push(f[e])}else for(e=0;e<g;++e)c.push(f[e])}return c},curvyCorners.getElementsBySelector=function(a,b){var c,d=a[0];b===undefined&&(b=document);if(d.indexOf("#")===-1)c=curvyCorners.getElementsByClass(d,b);else{var e=b.getElementById(d.substr(1));if(!e)return[];c=[e]}if(a.length>1){var f=[];for(var g=c.length;--g>=0;)f=f.concat(curvyCorners.getElementsBySelector(a.slice(1),c[g]));c=f}return c};if(curvyBrowser.supportsCorners){var curvyCornersNoAutoScan=!0;curvyCorners.init=function(){}}else curvyCorners.scanStyles=function(){function a(a){if(!parseInt(a))return"px";var b=/^[\d.]+(\w+)$/.exec(a);return b[1]}var b,c,d;if(curvyBrowser.isIE){function e(b){var c=b.style,d,e,f,g,h;curvyBrowser.ieVer>6?(d=c["-moz-border-radius"]||0,e=c["-moz-border-radius-topright"]||0,f=c["-moz-border-radius-topleft"]||0,g=c["-moz-border-radius-bottomright"]||0,h=c["-moz-border-radius-bottomleft"]||0):(d=c["moz-border-radius"]||0,e=c["moz-border-radius-topright"]||0,f=c["moz-border-radius-topleft"]||0,g=c["moz-border-radius-bottomright"]||0,h=c["moz-border-radius-bottomleft"]||0);if(d){var i=d.split("/");i=i[0].split(/\s+/),i[i.length-1]===""&&i.pop();switch(i.length){case 3:f=i[0],e=h=i[1],g=i[2],d=!1;break;case 2:f=g=i[0],e=h=i[1],d=!1;case 1:break;case 4:f=i[0],e=i[1],g=i[2],h=i[3],d=!1;break;default:curvyCorners.alert("Illegal corners specification: "+d)}}if(d||f||e||g||h){var j=new curvyCnrSpec(b.selectorText);d?j.setcorner(null,null,parseInt(d),a(d)):(e&&j.setcorner("t","r",parseInt(e),a(e)),f&&j.setcorner("t","l",parseInt(f),a(f)),h&&j.setcorner("b","l",parseInt(h),a(h)),g&&j.setcorner("b","r",parseInt(g),a(g))),curvyCorners(j)}}for(b=0;b<document.styleSheets.length;++b)try{if(document.styleSheets[b].imports)for(c=0;c<document.styleSheets[b].imports.length;++c)for(d=0;d<document.styleSheets[b].imports[c].rules.length;++d)e(document.styleSheets[b].imports[c].rules[d]);for(c=0;c<document.styleSheets[b].rules.length;++c)e(document.styleSheets[b].rules[c])}catch(f){typeof curvyCornersVerbose!=="undefined"&&curvyCornersVerbose&&alert(f.message+" - ignored")}}else if(curvyBrowser.isOp){for(b=0;b<document.styleSheets.length;++b)if(operasheet.contains_border_radius(b)){d=new operasheet(b);for(c in d.rules)isNaN(c)||curvyCorners(d.rules[c])}}else curvyCorners.alert("Scanstyles does nothing in Webkit/Firefox/Opera")},curvyCorners.init=function(){arguments.callee.done||(arguments.callee.done=!0,curvyBrowser.isWebKit&&curvyCorners.init.timer&&(clearInterval(curvyCorners.init.timer),curvyCorners.init.timer=null),curvyCorners.scanStyles())};if(typeof curvyCornersNoAutoScan==="undefined"||curvyCornersNoAutoScan===!1)curvyBrowser.isOp?document.addEventListener("DOMContentLoaded",curvyCorners.init,!1):curvyCorners.addEvent(window,"load",curvyCorners.init,!1)