/**
 * jQuery Plugin FlyDOM v3.1.1
 *
 * Create DOM elements on the fly and automatically append or prepend them to another DOM object.
 * There are also template functions (tplAppend and tplPrepend) that can take a simple HTML structure
 * and apply a JSON object to it to make creating layouts MUCH easier.
 *
 * This plugin was inspired by "Oslow" [http://mg.to/2006/02/27/easy-dom-creation-for-jquery-and-prototype#comment-176],
 * and since I could not get his code to work, I decided I write my own plugin. My hope is that this
 * version will be easier to understand and maintain with future versions of jQuery.
 *
 * Copyright (c) 2007 Ken Stanley [dohpaz at gmail dot com]
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * @version     $Id: jquery.flydom-3.1.0.js 9 2007-09-12 22:20:23Z dohpaz $
 *
 * @author      Ken Stanley [dohpaz at gmail dot com]
 * @copyright   (C) 2007. All rights reserved.
 *
 * @license     http://www.opensource.org/licenses/mit-license.php
 * @license     http://www.opensource.org/licenses/gpl-license.php
 *
 * @package     jQuery Plugins
 * @subpackage  FlyDOM
 *
 * @todo        Cache basic elements that are created, and if an already existing basic element is
 *              asked to be created an additional time, use a copy of the cached element to build from.
 *//**
 * Create DOM elements on the fly and automatically append them to the current DOM obejct
 *
 * @uses    jQuery
 * @uses    function convertCamel()
 *
 * @param   string  element - The name of the DOM element to create (i.e., img, table, a, etc)
 * @param   object  attrs   - An optional object of attributes to apply to the element
 * @param   array   content - An optional array of content (or element children) to append to element
 *
 * @return  jQuery  element - The jQuery object representing the new element
 *
 * @since   1.0
 */jQuery.fn.createAppend=function(a,b,c){if(b==undefined&&a.constructor==Array){for(var d=0;d<a.length;d+=3)jQuery(this).createAppend(a[d],a[d+1]||{},a[d+2]||[]);return this}var e=this[0];if(jQuery.browser.msie&&a=="input"&&b.type)var a=document.createElement("<"+a+' type="'+b.type+'" />');else var a=document.createElement(a);if(e.nodeName.toLowerCase()=="table"&&a.nodeName.toLowerCase()=="tr"){if(e&&e.getElementsByTagName("tbody")[0])var f=e.getElementsByTagName("tbody")[0];else var f=e.appendChild(document.createElement("tbody"));var a=f.appendChild(a)}else var a=e.appendChild(a);a=__FlyDOM_parseAttrs(a,b);if(typeof c=="object"&&c!=null)for(var d=0;d<c.length;d=d+3)jQuery(a).createAppend(c[d],c[d+1]||{},c[d+2]||[]);else c!=null&&(a=__FlyDOM_setText(a,c));return jQuery(a)},jQuery.fn.createPrepend=function(a,b,c){if(b==undefined&&a.constructor==Array){for(var d=0;d<a.length;d+=3)jQuery(this).createPrepend(a[d],a[d+1]||{},a[d+2]||[]);return this}var a=document.createElement(a);if(this[0].hasChildNodes()==!1)var a=this[0].appendChild(a);a=__FlyDOM_parseAttrs(a,b);if(typeof c=="object"&&c!=null)for(var d=0;d<c.length;d=d+3)jQuery(a).createAppend(c[d],c[d+1]||{},c[d+2]||[]);else c!=null&&(a=__FlyDOM_setText(a,c));if(this[0].hasChildNodes()==!0)var a=this[0].insertBefore(a,this[0].firstChild);return jQuery(a)},jQuery.fn.tplAppend=function(a,b){a.constructor!=Array&&(a=[a]);if(a.length==0)return!1;for(var c=0;c<a.length;c++){var d=b.apply(a[c]);for(var e=0;e<d.length;e=e+3)jQuery(this).createAppend(d[e],d[e+1],d[e+2])}return this},jQuery.fn.tplPrepend=function(a,b){var c=this[0];a.constructor!=Array&&(a=[a]);if(a.length==0)return!1;var d=document.createElement("div");for(var e=0;e<a.length;e++){var f=b.apply(a[e]);for(var g=0;g<f.length;g=g+3)jQuery(d).createAppend(f[g],f[g+1],f[g+2])}for(e=d.childNodes.length-1;e>=0;e--)if(jQuery.browser.msie&&c.nodeName.toLowerCase()=="table"&&d.childNodes[e].nodeName.toLowerCase()=="tr")if(c.getElementsByTagName("tbody")[0]){var h=c.getElementsByTagName("tbody")[0];h.insertBefore(d.childNodes[e],h.firstChild)}else{var h=c.insertBefore(document.createElement("tbody"),c.firstChild);h.appendChild(h.appendChild(d.childNodes[e]))}else c.insertBefore(d.childNodes[e],c.firstChild);return this},String.prototype.toCamelCase=function(){var a=this,b={"class":"className",colspan:"colSpan",rowspan:"rowSpan","for":"htmlFor",httpequiv:"httpEquiv",alink:"aLink",vlink:"vLink",bgcolor:"bgColor",acceptcharset:"acceptCharset",selectedindex:"selectedIndex",tabindex:"tabIndex",selected:"defaultSelected",checked:"defaultChecked",value:"defaultValue",accesskey:"accessKey",noshade:"noShade",datetime:"dateTime",usemap:"useMap",lowsrc:"lowSrc",longdesc:"longDesc",ismap:"isMap",codebase:"codeBase",codetype:"codeType",valuetype:"valueType",nohref:"noHref",thead:"tHead",tfoot:"tFoot",cellpadding:"cellPadding",cellspacing:"cellSpacing",charoff:"chOff",valign:"vAlign",frameborder:"frameBorder",marginheight:"marginHeight",marginwidth:"marginWidth",noresize:"noResize"};if(b[a]!=""&&typeof b[a]!="undefined")return b[a];if(a.indexOf("-")>0){var c=a.split("-");a=c[0];for(i=1;i<c.length;i++)a+=c[i].substr(0,1).toUpperCase()+c[i].substr(1).toLowerCase()}return a},String.prototype.trim=function(){return this.replace(/^\s+|\s+$/g,"")},__FlyDOM_parseAttrs=function(element,attrs){for(attr in attrs){var attrName=attr,attrValue=attrs[attr];switch(attrName){case"style":if(typeof attrValue=="string"){var params=attrValue.split(";");for(var i=0;i<params.length;i++)if(params[i].trim()!=""){var styleName=params[i].split(":")[0].trim(),styleValue=params[i].split(":")[1].trim();styleName=styleName.toCamelCase(),styleName!=""&&(element.style[styleName]=styleValue)}}else if(typeof attrValue=="object")for(styleName in attrValue){var styleNameCamel=styleName.toCamelCase();styleName.trim()!=""&&(element.style[styleNameCamel]=attrValue[styleName])}break;default:if(attrName.substr(0,2)=="on"){var event=attrName.substr(2);attrValue=typeof attrValue!="function"?eval("f = function() { "+attrValue+"}"):attrValue,jQuery(element).bind(event,attrValue)}else element[attrName.toCamelCase()]=attrValue}}return element},__FlyDOM_setText=function(a,b){var c=/(<\S[^><]*>)|(&.+;)/g;if(b.match(c)!=null&&a.tagName.toUpperCase()!="TEXTAREA")a.innerHTML=b;else{var d=document.createTextNode(b);a.appendChild(d)}return a}