<?php

@error_reporting ( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set ( 'display_errors', true );
@ini_set ( 'html_errors', false );
@ini_set ( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

@session_start();

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', '../' );
define( 'ENGINE_DIR', '../engine' );

require_once ENGINE_DIR . '/classes/mysql.php';
require_once ENGINE_DIR . '/data/dbconfig.php';
require_once ENGINE_DIR . '/data/config.php';
require_once ENGINE_DIR . '/modules/functions.php';
require_once ENGINE_DIR . '/modules/sitelogin.php';





$step = trim($_REQUEST['step']);
if(! is_numeric($step)) exit("Step error!");


if($step == 1) {
if($member_id['user_group'] == 1) {
echo <<<HTML
<script type="text/javascript">
$(function(){
$("#mainProgress span").animate({width:"25%"}, 500);
});
buttons_lock('next', 'unlock');
</script>
<h2>Установить uTop</h2>
Добро пожаловать в мастер установки "uTop v4.0". Данный мастер проверит совместимось модуля с вашим движком и выполнит установку/обновление модуля.
<br /><br />
Для продолжения нажмите кнопку "Далее".
HTML;

} else {
echo <<<HTML
<h2 class="error">Ошибка безопасности</h2>
В целях защиты от несанкционированной установки модуля необходимо войти на сайт как администратор. Это можно сделать через сайт или админпанель. После входа обновите эту страницу.
<br /><br />
<center><span class="button" onclick="loadStep('1'); return false;">Обновить страницу</span></center>
HTML;
}
}

if(($member_id['user_group'] != 1) and ($step != 1)) exit("Для того, чтобы установить модуль, войдите на сайт как администратор.");


if($step == 2) {

$utop_dir = "/engine/modules/utop";

$uTop_files = array(
'1' => array(
	'file' => "{$utop_dir}/ajax.php",
	'important' => true,
	'writable' => false,
),
'2' => array(
	'file' => "{$utop_dir}/block.php",
	'important' => true,
	'writable' => false,
),
'3' => array(
	'file' => "{$utop_dir}/cache.txt",
	'important' => true,
	'writable' => true,
),
'4' => array(
	'file' => "{$utop_dir}/config.txt",
	'important' => true,
	'writable' => true,
),
'6' => array(
	'file' => "{$utop_dir}/utop.class.php",
	'important' => true,
	'writable' => false,
),
'7' => array(
	'file' => "/templates/{$config['skin']}/utop.tpl",
	'important' => true,
	'writable' => false,
),
'8' => array(
	'file' => "{$utop_dir}/admin/panel.php",
	'important' => true,
	'writable' => false,
),
'9' => array(
	'file' => "{$utop_dir}/hidden_users.txt",
	'important' => true,
	'writable' => true,
),
);

$check_error = false;

$check_result = <<<HTML
<table class="styledTable" border="0" cellpadding="0" cellspacing="0">
<thead>
<th>Файл</th>
<th>CHMOD</th>
<th>Проверка</th>
</thead>
<tbody>
HTML;

// приоритеты ошибок
$fatal_error = false;
$warning = false;

foreach ($uTop_files as $file) {
$server_path = ROOT_DIR . "/" . $file['file'];

if(file_exists($server_path)) {
$file_exists = '<font color="green">Существует</font>';
} else {
$warning = true;
if($file['important']) {
$file_exists = '<font color="red">Отсутствует</font>';
$fatal_error = true;
} else {
$file_exists = '<font color="orange">Отсутствует</font>';
}
}

$chmod_value = @decoct(@fileperms($server_path)) % 1000;

if($file['writable']) {
if(is_writable($server_path)) {} else {
$file_exists .= ", <font color=red>Не доступен для записи</font>";
$fatal_error = true;
}
}

$check_result .= <<<HTML
<tr>
<td>{$file['file']}</td>
<td>{$chmod_value}</td>
<td>{$file_exists}</td>
</tr>
HTML;
}



$check_result .= "</tbody></table>";

if(!ini_get('short_open_tag')) {
$warning = true;
$php_message = "При проверке конфигурации PHP обнаружены проблемы. Это означает, что теги \"&lt;?=\" в шаблоне не будут работать. Обратитесь к вашему хостинг-провайдеру или в нашу техподдержку.<br />";
}

$php_short_tag = ini_get('short_open_tag') ? "<font color=\"green\">Включено</font>" : "<font color=\"red\">Выключно</font>";

$check_result .= "<b>Проверка конфигурации PHP:</b> short_open_tag - {$php_short_tag}<br />{$php_message}";



$page_title = $warning ? '<h2 class="error">Есть незничительные проблемы</h2>' : '<h2 class="green">Проверка прошла успешно</h2>';
$page_title = $fatal_error ? '<h2 class="error">Были обнаружены следующие проблемы</h2>' : $page_title;

$unlock_next = $fatal_error ? "" : "buttons_lock('next', 'unlock');";

$page_text = $warning ? "При проверке файлов были обнаружены незначительные проблемы. Вы можете продолжить установку модуля, но мы не можем гарантировать вам его стабильную работу.<center><span class=\"button\" onclick=\"loadStep('2'); return false;\" style=\"margin:4px;\">Проверить ещё раз</span></center>" : "Никаких проблем при проверке не обнаружено.";
$page_text = $fatal_error ? "Обнаружены критические проблемы из-за которых модуль не сможет работать. Вы должны их устранить, чтобы установить модуль.<center><span class=\"button\" onclick=\"loadStep('2'); return false;\" style=\"margin:4px;\">Проверить ещё раз</span></center>" : $page_text;


echo <<<HTML
<script type="text/javascript">
$(function(){
$("#mainProgress span").animate({width:"50%"}, 500);
});
buttons_lock('back', 'unlock');
{$unlock_next}
</script>
{$page_title}
{$check_result}
{$page_text}
HTML;
}

if($step == 3) {
echo <<<HTML
<script type="text/javascript">
$(function(){
$("#mainProgress span").animate({width:"75%"}, 500);
});
buttons_lock('back', 'unlock');
</script>
HTML;

echo "<h2>Всё готово к установке</h2>";


echo <<<HTML
<div class="box" style="height:24px;">
<center><span class="button image" id="utopInstallBtn" onclick="install_utop(); return false;" style="float:right;"><img src="install-button.png" /></span></center>
Все этапы пройдены. Нажите "Установить", чтобы установить uTop.
</div>
HTML;

}

if($step == 4) {

$db->query("DELETE FROM ".PREFIX."_admin_sections WHERE name = 'utop'");
$db->query("INSERT INTO ".PREFIX."_admin_sections (id, name, title, descr, icon, allow_groups) VALUES (NULL, 'utop', 'uTop 4.0', 'Настройка блока активных пользователей', 'utop.png', '1')");

$utop_conf = array(
'online' => "1",
'max_user' => "12",
'show_groups' => array("1", "2", "3", "4"),
'show_banned' => "0",
'regdate_format' => "j F Y H:i",
'lastdate_format' => "j F Y H:i",
'offest_date_format' => "1",
'sort_order' => "DESC",
'allow_sort' => "1",
'sort_type' => "news_num",
'sort_list' => "news_num=По новостям\ncomm_num=По комментариям\nreg_date=По регистрации\nlastdate=По дате последнего посещения",
'sql_rows' => "*",
'sql_join' => "",
'cache' => "1",
'cache_max_time' => "60",
'nick_format_mode' => "color",
'group1_color' => "#FF0000",
'group2_color' => "#0000FF",
'group3_color' => "#008000",
'group4_color' => "",
);

$config_file = ENGINE_DIR . '/modules/utop/config.txt'; // файл конфигрурации модуля
$config_data = serialize($utop_conf);
$utop_cfg_file = fopen($config_file, "w+" );
fwrite($utop_cfg_file, $config_data);
fclose($utop_cfg_file);

echo <<<HTML
<h2>Готово</h2>
Поздравляем! uTop установлен. Теперь можете приступать к настройке модуля и тестирования новых возможностей :)<br />
Если у вас возникли вопросы вы можете обратиться на наш форум с вопросом по модулю.<br />
Теперь удалите папку <b>utop_install</b>.
HTML;

}

?>