<?php
/*
####################################################
@author 		Andrey™
@copyright		(c) 2012 Zagruzka-Plus Technologies
@module			uTop
@version		4.0
@link			http://zagruzka-plus.ws/
####################################################
*/	

if(! defined( 'DATALIFEENGINE' )) exit("Отказано в доступе");

$config_file = ROOT_DIR . '/engine/modules/utop/config.txt'; // файл конфигрурации модуля
$cache_file_path = ROOT_DIR . '/engine/modules/utop/cache.txt'; // файл кеша
$hidden_users_file = ROOT_DIR . '/engine/modules/utop/hidden_users.txt'; // скрытые пользователи
// Сохранение настроек
if($_POST['save'] == "yes") {
$config_data = serialize($_POST['utop']);
$utop_cfg_file = fopen($config_file, "w+" );
fwrite($utop_cfg_file, $config_data);
fclose($utop_cfg_file);

$save_message = <<<HTML
$(function(){
ShowInfo('Настройки сохранены');
});
HTML;
}


// Очистка кеша
if($_POST['mode'] == "clearcache") {
$cache_file = fopen($cache_file_path, "w+" );
fwrite($cache_filee, "");
fclose($cache_file);
exit("Кеш очищен");
}


$h_users = file_get_contents($hidden_users_file);
$h_users = (array)explode(",", $h_users);

if(($_POST['mode'] == "addhiddenuser") and ($_POST['username'] != "")) {
$username = convert_unicode(trim($_POST['username']), $config['charset']);
$username = $db->safesql($username);
$row = $db->super_query("SELECT user_id, name FROM " . PREFIX . "_users WHERE name = '{$username}' LIMIT 1");
if($row['user_id'] != "") {
$h_users[] = $row['user_id'];
$fdata = implode(",", $h_users);
$tmp = fopen($hidden_users_file, "w+" );
fwrite($tmp, $fdata);
fclose($tmp);
unset($tmp);
echo "<script type=\"text/javascript\"> ShowInfo('Пользователь добавлен'); </script>";
} else {
echo "<script type=\"text/javascript\"> dlg_alert('Пользователь не найден', function() {addHiddenUser();}); </script>";
}
}

if(($_POST['mode'] == "delhiddenuser") and is_numeric(trim($_POST['userid'])) ) {
foreach ($h_users as $key=>$value) {
if($value == trim($_POST['userid'])) {
unset($h_users[$key]);
break;
}
}
$fdata = implode(",", $h_users);
$tmp = fopen($hidden_users_file, "w+" );
fwrite($tmp, $fdata);
fclose($tmp);
unset($tmp);
}

if(count($h_users) > 1) {

foreach ($h_users as $user_id) {
$sql_users_where .= "user_id = '{$user_id}' OR ";
}
$sql_users_where = substr($sql_users_where, 0, -3);
$db->query("SELECT name, user_id, user_group FROM " . PREFIX . "_users WHERE {$sql_users_where}");
while($row = $db->get_row()) {
$hidden_users_list .= <<<HTML
<div class="list_item">
<span class="deleteBtn" onclick="delHiddenUser('{$row['user_id']}', '{$row['name']}'); return false;"></span>
<b>{$row['name']}</b> (ID: {$row['user_id']})<br />
{$user_group[$row['user_group']]['group_name']}
</div>
HTML;
}

} else {
$hidden_users_list = '<div style="color:#aaaaaa; text-align:center; padding:8px; font-size:12px;">Нет скрытых пользователей</div>';
}

if(($_POST['mode'] == "addhiddenuser") and ($_POST['username'] != "")) {
echo $hidden_users_list;
exit();
}

if($_POST['mode'] == "delhiddenuser") {
echo $hidden_users_list;
exit();
}



// Элементы управления
class uTop {
	public $uconfig = array();

	public function loadConfig($config_file) {
		$data = file_get_contents($config_file);
		$data = (array)unserialize($data);
		$this->uconfig = $data;
	}
	
	public function getInput($input_name) {
		$input = "<input class=\"styled big\" name=\"utop[{$input_name}]\" value=\"{$this->uconfig[$input_name]}\" />";
		return $input;
	}
	
	public function getSmallInput($input_name) {
		$input = "<input class=\"styled small numeric\" autocomplete=\"Off\" name=\"utop[{$input_name}]\" value=\"{$this->uconfig[$input_name]}\" />";
		return $input;
	}
	
	public function getTextarea($name) {
		$textarea = "<textarea name=\"utop[{$name}]\" class=\"styled\">{$this->uconfig[$name]}</textarea>";
		return $textarea;
	}
	
	public function getSwitcher($name) {
		if ($this->uconfig[$name] == "1") {
			$checked_yes = 'checked="checked"';
		} else {
			$checked_no = 'checked="checked"';
		}
		$radio = "<div class=\"switcherBox\"><span class=\"switcherYes\"><label><input type=\"radio\" name=\"utop[{$name}]\" {$checked_yes} value=\"1\"> Да </label></span><span class=\"switcherNo\"><label><input type=\"radio\" name=\"utop[{$name}]\" {$checked_no} value=\"0\"> Нет </label></span></div>";
		return $radio;
	}
	
	public function getSelect($options=array(), $name) {
		foreach ($options as $key=>$title) {
			if($this->uconfig[$name] == $key) {$selected = 'selected="selected"';} else {$selected = "";}
			$select .= "<option {$selected} value=\"{$key}\">{$title}</option>";
		}
		$select = "<select class=\"selector\" name=\"utop[{$name}]\">{$select}</select>";
		return $select;
	}
	
	public function getMultipleSelect($options=array(), $name) {
		foreach ($options as $key=>$title) {
			$selected = "";
			foreach ($this->uconfig[$name] as $id=>$value) {
				if($key == $value) {
					$selected = 'selected="selected"';
					break;
				}
			}
			$select_options .= "<option {$selected} value=\"{$key}\">{$title}</option>";
		}
		$select = "<select class=\"multipleSelect\" multiple=\"multiple\" size=\"6\" name=\"utop[{$name}][]\">{$select_options}</select>";
		return $select;
	}
	
	public function getSortOptions() {
		$options_list = (array)explode("\n", $this->uconfig['sort_list']);
		$options_result = array();
		foreach ($options_list as $str) {
			$str = trim($str);
			$arr = (array)explode("=", $str);
			$option_title = trim($arr[1]);
			$option_value = trim($arr[0]);
			if($option_title and $option_value) {
				$options_result[$option_value] = $option_title;
			}
		}
		return $options_result;
	}
}

$uTop = new uTop;
$uTop->loadConfig($config_file);



function showRow($title = "", $description = "", $field = ""){
$row_html = <<<HTML
<tr>
<td class="option">{$title}<br /><div class="descr">{$description}</div></td>
<td class="optionSetting">{$field}</td>
</tr>
HTML;
return $row_html;
}
function showSep($title = "") {
$html = "<tr><th colspan=\"2\" class=\"tdSep\">{$title}</th></tr>";
return $html;
}


$html .= <<<HTML
<html>
<head>
<title>Админцентр uTop</title>
<link rel="stylesheet" type="text/css" media='screen' href="{$config['http_home_url']}engine/modules/utop/admin/styles.css" />
<link rel="shortcut icon" href="{$config['http_home_url']}engine/modules/utop/admin/favicon.ico" />
<script type="text/javascript" src="{$config['http_home_url']}engine/classes/js/jquery.js"></script>
<script type="text/javascript" src="{$config['http_home_url']}engine/modules/utop/admin/utop.js"></script>
<script type="text/javascript" src="{$config['http_home_url']}engine/modules/utop/admin/jquery-ui.js"></script>
<script type="text/javascript">
var admin_path = "{$PHP_SELF}";
{$save_message}
</script>
</head>
<body>
<div class="topPanel">
<div class="uTopLoader"></div>
<div class="wrapper">
<ul class="navLinks" style="float:right;">
<li><a href="#" onclick="return false;" style="cursor:default;">Вошли как {$member_id['name']}</a></li>
<li><a href="{$config['http_home_url']}" target="_blank">Перейти на сайт</a></li>
<li><a href="{$PHP_SELF}?action=logout" onclick="if(!confirm('Ты уверен, что хочешь выйти?')) {return false;}">Выход</a></li>
</ul>

<div class="logo"></div>
<ul class="navLinks">
<li><a href="{$PHP_SELF}?mod=main">&laquo; Назад в панель DataLife Engine</a></li>
</ul>
</div>
</div>
<div class="topPanelContainer"></div>
<div class="wrapper">
<div class="mainContainer">
<div class="lcol block navigationLinks" style="padding:6px 0px;">
<div class="zpMenu">
<span class="tab" rel="usettings">Настройки</span>
<span class="tab" rel="uhidden"><img id="husersloader" src="{$config['http_home_url']}engine/modules/utop/admin/white-loader.gif" style="float:right; margin-top:10px; display:none;" />Скрытые пользователи</span>
<span onclick="utopClearCache(); return false;"><img id="clrcacheloader" src="{$config['http_home_url']}engine/modules/utop/admin/loader.gif" style="float:right; margin-top:10px; display:none;" />Очистить кеш</span>
</div>
</div>
<div class="rcol block">
HTML;

$sort_options = $uTop->getSortOptions();

$user_groups = array();
foreach ($user_group as $group) {
$user_groups[$group['id']] = $group['group_name'];
}


$html .= '<form action="" method="post" id="utopForm"><div class="utopPages" id="usettings">
<div class="boxInformation">
<h2>Настройки</h2>
</div>
<table border="0" cellpadding="0" cellspacing="0" class="settingsTable">';
$html .= showSep("Основное");
$html .= showRow("Включить uTop?", "Отключение модуля скрывает блок", $uTop->getSwitcher("online") );
$html .= showRow("Количество пользователей", "Сколько пользователей отображать в блоке?", $uTop->getSmallInput("max_user"));

$html .= showSep("Фильтры");
$html .= showRow("Какие группы пользователей отображать в блоке?", "Для выбора нескольких групп удерживайте клавишу CTRL", $uTop->getMultipleSelect($user_groups, "show_groups") );
$html .= showRow("Показывать забаненых пользователей?", "Вы можете скрыть из списка забаненых пользователей", $uTop->getSwitcher("show_banned") );

$html .= showSep("Формат дат");
$html .= showRow("Формат даты регистрации", "<a href=\"#\" onclick=\"dateHelp(); return false;\">Справка по формату даты в PHP</a>", $uTop->getInput("regdate_format"));
$html .= showRow("Формат даты последнего посещения", "<a href=\"#\" onclick=\"dateHelp(); return false;\">Справка по формату даты в PHP</a>", $uTop->getInput("lastdate_format"));
$html .= showRow("Включить относительные даты?", "При включении этой опции сегодняшняя дата будет заменена на \"Сегодня\" а вчерашняя на \"Вчера\"", $uTop->getSwitcher("offest_date_format") );

$sort_order_options = array(
'ASC' => "По возрастанию (0-9)",
'DESC' => "По убыванию (9-0)",
);

$html .= showSep("Сортировка");
$html .= showRow("Порядок сортировки", "", $uTop->getSelect($sort_order_options, "sort_order"));
$html .= showRow("Разрешить пользователям выбирать вариант сортировки?", "Позволяет пользователям переключать вариант сортировки через меню сортировки в блоке", $uTop->getSwitcher("allow_sort") );
$html .= showRow("Сортировка по-умолчанию", "Выберите вариант сортировки, который будет использоваться при выводе блока. (Варианты сортировки настраиваются ниже.)", $uTop->getSelect($sort_options, "sort_type"));
$html .= showRow("Варианты сортировки", "Здесь вы можете настроить варианты сортировки. Каждый вариант пишется с новой строки в формате:<br /><b>поле_таблицы=Название варианта сортировки</b><br /><br /><b>Замечание:</b> эти варианты появятся в списке выше только после сохранения настроек", $uTop->getTextarea("sort_list"));
$html .= showRow("Используемые поля таблиц (SQL)", "Введите через запятую, какие поля будут выбираться из таблицы пользователей и подключённых таблиц (если есть). Для выборки всех полей введите: <b>*</b>", $uTop->getInput("sql_rows"));
$html .= showRow("Подключение дополнительных таблиц (SQL)", "Вы можете подключить дополнительные таблицы со статистикой активности пользователей. Для этого в этом поле надо прописать запрос на подключение таблиц.", $uTop->getInput("sql_join"));

$html .= showSep("Кеширование");

$html .= showRow("Включить кеширование?", "Включение кеширования снижает нагрузку на MySQL", $uTop->getSwitcher("cache") );
$html .= showRow("Время жизни кеша (в минутах)", "Укажите через какое время будет обновляться кеш модуля.", $uTop->getSmallInput("cache_max_time"));

$html .= showSep("Ники пользователей");

$nick_format_mode_options = array(
'none' => "Отключено",
'color' => "Выделение цветом",
'group_settings' => "Использовать префиксы и суффиксы групп",
);

$html .= showRow("Режим выделения ников цветом", "Здесь вы можете включить функцию выделения ников пользователей в зависимости от их группы.<br />Приведённые ниже настройки будут использоваться только при выборе варианта \"{$nick_format_mode_options['color']}\"", $uTop->getSelect($nick_format_mode_options, "nick_format_mode"));

foreach ($user_group as $group) {
if($group['id'] == 5) continue; // не выводить группу гостей
$html .= showRow("Цвет группы \"{$group['group_name']}\"", "Цвет может быть указан в любом удобном для вас формнате. Например: <b>#000000</b>, <b>rgb(0,0,0)</b> или <b>black</b>", $uTop->getInput("group{$group['id']}_color") );
}
$html .= '</tbody></table>
<div class="buttonPane"><input type="submit" class="fbutton utopSaveButton" value="Сохранить настройки" /></div>
</div>
<input type="hidden" name="save" value="yes" />
</form>';

$html .= <<<HTML
<div class="utopPages" style="display:none;" id="uhidden">
<div class="boxInformation">
<h2>Скрытые пользователи</h2>Здесь вы можете настроить какие пользователи не будут выводится в блоке. Для этого всего лишь нужно добавить пользователя в этот список. Для вступления изменений в силу может потребоваться очистка кеша.
</div>
<div align="right" style="padding:0px 10px;">
<input type="button" class="fbutton" value="Добавить пользователя" onclick="addHiddenUser(); return false;" />
</div>
<br />
<div id="hiddenUsersBox" class="hidden_users_box">{$hidden_users_list}</div><br />
</div>
</div>
<div class="footer"><a href="http://talk.zagruzka-plus.ws/index.php?showforum=48" target="_blank"><img src="{$config['http_home_url']}engine/modules/utop/admin/copyright.png" alt="uTop v4.0 by Zagruzka-Plus Technologies" /></a></div>
<div class="clr"></div>
</div>
</div>
<div id="phpdateformathelp" style="display:none;">
<div style="font-size:11px;">
<b>a</b> - "am" или "pm"<br />
<b>A</b> - "AM" или "PM"<br />
<b>B</b> - время Swatch Internet <br />
<b>d</b> - день (число) месяца, 2 цифры с ведущим нулём, если необходимо; т. е. от "01" до "31" <br />
<b>D</b> - день недели, буквенный, 3 буквы; например, "Fri"<br />
<br />
<b>F</b> - месяц, буквенный, long; например, "January" <br />
<b>g</b> - час, 12-часовой формат без ведущих нулей; т.е. от "1" до "12" <br />
<b>G</b> - час, 24-часовой формат без ведущих нулей; т.е. от "0" до "23" <br />
<b>h</b> - час, 12-часовой формат; т.е. от "01" до "12"<br />
<b>H</b> - час, 24-часовой формат; т.е. от "00" до "23" <br />
<b>i</b> - минуты; т.е. от "00" до "59"<br />
<br />
<b>I</b> (заглавная i) - "1", если Daylight Savings Time, "0" - в противном случае.<br />
<b>j</b> - день (число) месяца без ведущих нулей; т.е. от "1" до "31" <br />
<b>l</b> ('L' в нижнем регистре) - день недели, буквенный, long; например, "Friday" <br />
<b>L</b> - boolean, указывающее, високосный ли год; т.е. "0" или "1" <br />
<b>m</b> - месяц; т.е. от "01" до "12"<br />
<b>M</b> - месяц, буквенный, 3 буквы; например, "Jan" <br />
<br />
<b>n</b> - месяц без ведущих нулей; т.е. от "1" до "12" <br />
<b>O</b> - Разница с временем по Гринвичу, в часах; например, "+0200" <br />
<b>r</b> - RFC 822 формат даты; например, "Thu, 21 Dec 2000 16:01:07 +0200" (введён в PHP 4.0.4) <br />
<b>s</b> - секунды; т.е. от "00" до "59"<br />
<b>S</b> - простой английский суффикс для дня (числа) месяца, 2 символа; т.е. "st", "nd", "rd" или "th"<br />
<b>t</b> - количество дней в данном месяце; т.е. от "28" до "31" <br />
<br />
<b>T</b> - установка Timezone/Часовой пояс на данной машине; например, "EST" или <br />
"MDT" <br />
<b>U</b> - секунды эпохи Unix Epoch (начиная с January 1 1970 00:00:00 GMT) <br />
<b>w</b> - день недели, числовой, т.е. от "0" (Sunday) до "6" (Saturday) <br />
<b>W</b> - ISO-8601 номер недели в году, недели начинаются с понедельника/Monday <br />
(введено в PHP 4.1.0) <br />
<b>Y</b> - год, 4 цифры; например, "1999"<br />
<b>y</b> - год, 2 цифры; например, "99" <br />
<br />
<b>z</b> - день года; т.е. от "0" до "365"<br />
<b>Z</b> - смещение часового пояса, в секундах (т.е. от "-43200" до "43200"). <br />
Смещение часовых поясов к западу от UTC всегда отрицательное, а для поясов к <br />
востоку от UTC - всегда положительное.
</div>
</div>
</body>
</html>
HTML;

echo $html;

?>