<?php
/*
####################################################
@author 		Andrey™
@copyright		(c) 2012 Zagruzka-Plus Technologies
@module			uTop
@version		4.0
@link			http://zagruzka-plus.ws/
####################################################
*/		

if(!defined('DATALIFEENGINE')) {
	die("Hacking attempt!");
}


class uTop {
	
	private $cachefile = null;
	private $hiddenUsers = array();
	public $config = array(); // конфиг uTop
	private $db = null;
	private $users_array = array();
	private $dle_config = array();
	
	// Инцилизируем класс
	function __construct() {
		global $db, $config;
		$this->db = $db;
		$this->dle_config = $config;
		$this->cachefile = ENGINE_DIR . "/modules/utop/cache.txt";
		
		$data = file_get_contents(ENGINE_DIR . "/modules/utop/config.txt");
		$data = (array)unserialize($data);
		$this->config = $data;
		
		$husersdata = file_get_contents(ENGINE_DIR . "/modules/utop/hidden_users.txt");
		$hiddenUsersArr = (array)explode(",", $husersdata);
		$this->hiddenUsers = $hiddenUsersArr;
	}
	
	public function getSortList() {
		$options_list = (array)explode("\n", $this->config['sort_list']);
		$options_result = array();
		foreach ($options_list as $str) {
			$str = trim($str);
			$arr = (array)explode("=", $str);
			$option_title = trim($arr[1]);
			$option_value = trim($arr[0]);
			if($option_title and $option_value) {
				$options_result[$option_value] = $option_title;
			}
		}
		return $options_result;
	}
	
	// Считываем кеш
	private function getCacheData() {
		if(file_exists($this->cachefile)) {
			$txt_data = file_get_contents($this->cachefile);
			$data = array();
			$data = unserialize($txt_data);
			return $data;
		} else {
			return false;
		}
	}
	
	
	public function parseXfields($xfields) {
		$xfields_list = explode("||", $xfields);
		$xfields_result = array();
		foreach ($xfields_list as $xfield) {
			$tmp = explode("|", $xfield);
			$xfields_result[$tmp[0]] = $tmp[1];
		}
		return $xfields_result;
	}
	
	private function sqlFilters() {
		$sql_filters = array();
		
		// фильтр по группам
		if(count($this->config['show_groups']) > 0) {
				foreach ($this->config['show_groups'] as $group_id) {
				$sql_where .= "user_group = '{$group_id}' OR ";
				}
			$sql_where = substr($sql_where, 0, -3);
			$sql_where = "( {$sql_where} )";
			$sql_filters[] = $sql_where;
		}
		
		// скрытые пользователи
		$hidden_count = 0;
		foreach ($this->hiddenUsers as $h_user_id) {
			if($h_user_id != "") {
				$hidden_count++;
				$sql_hidden .= "user_id != '{$h_user_id}' AND ";
			}
		}
		$sql_hidden = substr($sql_hidden, 0, -4);
		$sql_hidden = "( {$sql_hidden} )";
		if($hidden_count > 0) $sql_filters[] = $sql_hidden;
		
		// фильтр забаненых
		if($this->config['show_banned'] == "0") {
		$sql_filters[] = "banned != 'yes'";
		}
		
		$result_query = "";
		if(count($sql_filters) > 0) {
		$result_query = implode(" AND ", $sql_filters);
		$result_query = "WHERE " . $result_query;
		}
		return $result_query;
		
	}
	
	public function formatDate($date_format, $date) {
		$day_start = mktime('00', '00', '00', date("m"),  date("d"),  date("Y"));
		$day_end = mktime('23', '59', '59', date("m"),  date("d"),  date("Y"));
		$day_yesterday = $day_start - (3600 * 24);
		if(($date >= $day_start) AND ($date <= $day_end) AND ($this->config['offest_date_format'] == "1")) {
		$return = "Сегодня, " . langdate("H:i", $date);
		} elseif(($date >= $day_yesterday) AND ($this->config['offest_date_format'] == "1")) {
		$return = "Вчера, " . langdate("H:i", $date);
		} else {
		$return = langdate($date_format, $date);
		}
		return $return;
	}
	
	
	// Получаем отсортированный список пользователей из БД
	public function loadFromDB() {
		$sql_where = $this->sqlFilters();
		$u_array = array();
		$sorts = $this->getSortList();
		foreach ($sorts as $sort_type=>$sort_descr) {
			$this->db->query("SELECT {$this->config['sql_rows']} FROM ".PREFIX."_users AS users {$this->config['sql_join']} {$sql_where} ORDER BY {$sort_type} DESC LIMIT 0, {$this->config['max_user']}");
			while($row = $this->db->get_row()) {
			// Удаляем ненужную информацию о пользователе
			unset($row['password']);
			unset($row['allow_mail']);
			unset($row['hash']);
			unset($row['signature']);
			unset($row['logged_ip']);
			unset($row['favorites']);
			unset($row['pm_all']);
			unset($row['pm_unread']);
			unset($row['time_limit']);
			unset($row['allowed_ip']);
			unset($row['restricted_days']);
			unset($row['restricted_date']);
			$row['xfields'] = $this->parseXfields($row['xfields']);
			$u_array[$sort_type][] = $row;
			}
		}
		return $u_array;
	}
	
	// Создание кеша
	private function createCache($data_array) {
		$array = array();
		$array['time'] = time();
		$array['data'] = $data_array;
		$txt_users_array = serialize($array);
		$cache_file = fopen($this->cachefile,'w+');
		fwrite($cache_file, $txt_users_array);
		fclose($cache_file);
	}


	// Получение массива с пользователями из кеша/БД
	public function getData() {
		// Проверка кеширования
		if($this->config['cache'] == "1") {
			$cache_data = $this->getCacheData();
			if((( time() - $cache_data['time'] ) > ( $this->config['cache_max_time'] * 60 )) OR ($cache_data['time'] == "")) {
				// Обновляем кеш, если он старый
				$users_data = array();
				$users_data = $this->loadFromDB();
				$this->createCache($users_data);
				$return = $users_data;
			} else {
				$return = $cache_data['data'];
			}
		} else {
			$data = array();
			$data = $this->loadFromDB();
			$return = $data;
		}
		return $return;
	}
	
	public function getFormatedData() {
		global $user_group;
		$data = $this->getData();
		$new_data = array();
		
		foreach ($data as $sort_type=>$values) {
			foreach ($values as $num=>$userinfo) {
			
				// ссылка на аватар
				if(($userinfo['foto'] != "") AND (file_exists(ROOT_DIR . "/uploads/fotos/{$userinfo['foto']}"))) {
				$userinfo['foto'] = "{$this->dle_config['http_home_url']}uploads/fotos/{$userinfo['foto']}";
				} else {
				$userinfo['foto'] = "{$this->dle_config['http_home_url']}templates/{$this->dle_config['skin']}/images/noavatar.png";
				}
				
				// Конвертация и добавление инфы
				$userinfo['reg_date'] = $this->formatDate($this->config['regdate_format'], $userinfo['reg_date']);
				$userinfo['lastdate'] = $this->formatDate($this->config['lastdate_format'], $userinfo['lastdate']);
				$userinfo['group_id'] = $userinfo['user_group'];
				$userinfo['user_group'] = $user_group[$userinfo['group_id']]['group_name'];
				$userinfo['user_group_formated'] = $user_group[$userinfo['group_id']]['group_prefix'] . $user_group[$userinfo['group_id']]['group_name'] . $user_group[$userinfo['group_id']]['group_suffix'];
				$userinfo['url_name'] = urlencode($userinfo['name']);
				
				// ссылка на профиль
				if($this->dle_config['allow_alt_url'] == "yes") {
				$userinfo['profile_link'] = "{$this->dle_config['http_home_url']}user/{$userinfo['url_name']}/";
				} else {
				$userinfo['profile_link'] = "{$this->dle_config['http_home_url']}index.php?subaction=userinfo&user={$userinfo['url_name']}";
				}
				
				// форматирование ника пользователя
				switch($this->config['nick_format_mode']) {
					case "color" :
						if($this->config["group{$userinfo['group_id']}_color"] != "") {
							$userinfo['name_formated'] = "<span style=\"color:" . $this->config["group{$userinfo['group_id']}_color"] . "\">{$userinfo['name']}</span>";
						} else {
							$userinfo['name_formated'] = $userinfo['name'];
						}
					break;
					
					case "group_settings" :
						$userinfo['name_formated'] = $user_group[$userinfo['group_id']]['group_prefix'] . $userinfo['name'] . $user_group[$userinfo['group_id']]['group_suffix'];
					break;
					
					default :
						$userinfo['name_formated'] = $userinfo['name'];
					break;
				}
				
				$new_data[$sort_type][$num] = $userinfo;
			}
		}
		
		return $new_data;
	}



}

?>