<?php

/*
	DataLife Engine Photoalboms v.0.09
	Title for version: <'Brilliant'>
	Author: (c) RedRat, icq contact: 709-056
	E-mail: <support@admin-club.ru>
	Official site: http://admin-club.ru

	Name file: resize.php
	Description: resize images
	Data & time of updating: 22:39 18.12.2010

	(c) DataLife Engine
	http://dle-news.ru

*/

	if( !defined( 'DATALIFEENGINE' ) )
	{

		echo '[Datalife Engine PhotoAlbums] You tried to gain unauthorized access to the module, or system DataLife Engine is not licensed.';

		exit();

	}

	$gd_version = 2; // 1 or 2

	class thumbnail_photo
	{

		var $img;

	    var $watermark_image_light;
	    var $watermark_image_dark;

	    var $src;

	    var $file_size;

		var $type;

		var $cubeimg;

		var $heigh;
		var $width;

		var $width_thumb;

		var $height_thumb;

		var $quality;

		var $des;

		function load( $src )
		{

			if( !file_exists( $src ) )
			{

				echo 'No found file &laquo;' . $src . '&raquo;';

				exit();

			}

			$this->src = $src;

			$property = GetImageSize( $src );

	        $this->height_thumb = $this->height = $property[1];
	        $this->width_thumb = $this->width = $property[0];

		 	switch ($property[2])
		 	{

			 	case 1:

				 	$this->img = imagecreatefromgif ($src);

				 	$this->type = 'gif';

			 	break;

			 	case 2:

				 	$this->img = imagecreatefromjpeg ($src);

				 	$this->type = 'jpg';

		        break;

			 	case 3:

				 	$this->img = imagecreatefrompng ($src);

				 	$this->type = 'png';

		        break;

			 	default:

			 		echo $PHOTO_LAN['warning_54'];

			 		exit();

		        break;

		 	}

			$this->quality = 90;

		}

		function cube()
		{

			if ($this->width > $this->height)
			{

				$this->cubeimg = imageCreate( $this->height, $this->height );

		        $O = ceil ($this->width / 2);

		        $OA = ceil ($this->height / 2);

		        $LEFT = $O - $OA;

		        $RIGHT = $O + $OA;

		        $this->cubeimg = imagecreatetruecolor( $this->height, $this->height );

				imageCopy( $this->cubeimg, $this->img, 0, 0, $LEFT, 0, $this->height,$this->height );

			}

			if ($this->width < $this->height)
	        {

		        $this->cubeimg = imageCreate($this->width,$this->width);

		        $O = ceil ($this->height / 2);

		        $OA = ceil ($this->width / 2);

		        $LEFT = $O - $OA;

		        $RIGHT = $O + $OA;

		        $this->cubeimg = imagecreatetruecolor($this->width,$this->width);

				imageCopy( $this->cubeimg, $this->img, 0, 0,   0,  $LEFT,   $this->width,$this->width );

	        }

	        if ($this->width != $this->height)
	        {

	        	$this->img = $this->cubeimg;

	        }

		}

		function size_auto( $size=100, $site=0 )
		{

			global $gd_version;

			$site = intval( $site );

			if( $this->width <= $size and $this->height <= $size )
			{

				$this->width_thumb = $this->width;

				$this->height_thumb = $this->height;

				return 0;

			}

			switch( $site )
			{

				case 1:

					if( $this->width <= $size )
					{

						$this->width_thumb = $this->width;
						$this->height_thumb = $this->height;

						return;

					}else{

						$this->width_thumb = $size;
						$this->height_thumb = ($this->width_thumb/$this->width)*$this->height;

					}

				break;

				case 2:

					if( $this->height <= $size )
					{

						$this->width_thumb = $this->width;
						$this->height_thumb = $this->height;

						return;

					}else{

						$this->height_thumb = $size;
						$this->width_thumb = ($this->height_thumb/$this->height)*$this->width;

					}

				break;

				default:

					if( $this->width >= $this->height )
					{

						$this->width_thumb = $size;
						$this->height_thumb = ($this->width_thumb/$this->width)*$this->height;

					}else{

						$this->height_thumb = $size;
						$this->width_thumb = ($this->height_thumb/$this->height)*$this->width;

					}

				break;

			}

			if( $gd_version == 1 )
            {

				$this->des = imagecreate( $this->width_thumb, $this->height_thumb );

				imagecopyresized( $this->des, $this->img, 0, 0, 0, 0, $this->width_thumb, $this->height_thumb, $this->width, $this->height );

			}elseif( $gd_version == 2 ){

				$this->des = imagecreatetruecolor( $this->width_thumb, $this->height_thumb );

				imagecopyresampled ($this->des, $this->img, 0, 0, 0, 0, $this->width_thumb, $this->height_thumb, $this->width, $this->height );

			}

			$this->img = $this->des;

		}

		function save( $save = '' )
		{

			if( $this->type == 'jpg' or $this->type == 'jpeg' )
			{

				imagejpeg( $this->img, $save, $this->quality );

			}elseif( $this->type == 'png' ) {

				imagepng($this->img, $save );

			}elseif( $this->type == 'gif' ){

				imagegif( $this->img, $save );

			}

			imagedestroy( $this->img );

		}

		function show( $s = 0 )
		{

			header("Pragma: public");
		    header("Expires: 0");
		    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		    header("Cache-Control: public");

			if( $s )
			{

			    header("Content-Description: File Transfer");

		    }

			if( $this->type == "jpg" or $this->type == "jpeg" )
			{

				header ("Content-type: image/jpeg");

				if( $s )
				{

					header("Content-Disposition: attachment; filename=" . basename( $this->src ));
					header("Content-Transfer-Encoding: binary");
    				//header("Content-Length: " . $this->file_size );

				}

				imageJPEG( $this->img, "", $this->quality );

			}elseif( $this->type == "png" ) {

				header ("Content-type: image/png");

				if( $s )
				{

					header("Content-Disposition: attachment; filename=" . basename( $this->src ));
					header("Content-Transfer-Encoding: binary");
    				//header("Content-Length: " . $this->file_size );

				}

				imagePNG($this->img );

			}elseif( $this->type == "gif" ) {

				header ("Content-type: image/gif");

				if( $s )
				{

					header("Content-Disposition: attachment; filename=" . basename( $this->src ));
					header("Content-Transfer-Encoding: binary");
    				//header("Content-Length: " . $this->file_size );

				}

				imageGIF( $this->img );

			}

			imagedestroy( $this->img );

		}

		function insert_watermark( $min_image, $margin = 0 )
	    {

	    	global $config, $PHOTO_CONF;

	    	// margin watermark

	    	if( $margin ) $margin = $PHOTO_CONF['margin water mark'];

	    	// WaterMark for light photo Or dark photo?

	    	// watermark files

			$this->watermark_image_light = ROOT_DIR.'/engine/photo/styles/images/watermake_light.png';
			$this->watermark_image_dark = ROOT_DIR.'/engine/photo/styles/images/watermake_dark.png';

			// size of image, fresh

	        $image_width = imagesx($this->img);
	        $image_height = imagesy($this->img);

	        // size of watermark

	        list( $watermark_width, $watermark_height ) = getimagesize( $this->watermark_image_light );

	        // detect postion watermak

			$watermark_x = $image_width - $margin - $watermark_width;
			$watermark_y = $image_height - $margin - $watermark_height;
	        $watermark_x2 = $watermark_x + $watermark_width;
	        $watermark_y2 = $watermark_y + $watermark_height;

	        // return if image size < then size of watermark

	        if( $watermark_x < 0 or $watermark_y < 0 or $watermark_x2 > $image_width or $watermark_y2 > $image_height or $image_width < $min_image OR $image_height < $min_image)  return;

	        // creat test pixel

	        $test = imagecreatetruecolor(1, 1);

	        // copy in test pixel ALL image ! Warning ! memory

	        imagecopyresampled( $test, $this->img, 0, 0, $watermark_x, $watermark_y, 1, 1, $watermark_width, $watermark_height );

	        // detect rbg chanel

	        $rgb = imagecolorat($test, 0, 0);
	        $r = ($rgb >> 16) & 0xFF;
	        $g = ($rgb >> 8) & 0xFF;
	        $b = $rgb & 0xFF;

	        // min & max of R,G,B

	        $max = min($r, $g, $b);
	        $min = max($r, $g, $b);

	        // LightNess?

	        $lightness = (double)(($max + $min) / 510.0);

	        // Destroy Test image !

	        imagedestroy($test);

	        // Select WaterMark file

	        $watermark_image = ($lightness < 0.5) ? $this->watermark_image_light : $this->watermark_image_dark;

	        // Load file WM from PNG image

	        $watermark = imagecreatefrompng($watermark_image);

	        imagealphablending($this->img, TRUE);
	        imagealphablending($watermark, TRUE);
	        imagecopy( $this->img, $watermark, $watermark_x, $watermark_y, 0, 0,$watermark_width, $watermark_height);
	        imagedestroy( $watermark);
	    }

		function elf($a, $x, $y, $z, $n)
		{
			global $PHOTO_CONF;
			switch( $a )
			{
			    case "1": imagefilter( $this->img, IMG_FILTER_NEGATE); break;
			    case "2": imagefilter( $this->img, IMG_FILTER_GRAYSCALE);  break;
			    case "3": imagefilter( $this->img, IMG_FILTER_EDGEDETECT); break;
			    case "4": imagefilter( $this->img, IMG_FILTER_EMBOSS); break;
			    case "5": imagefilter( $this->img, IMG_FILTER_GAUSSIAN_BLUR);  break;
			    case "6": imagefilter( $this->img, IMG_FILTER_SELECTIVE_BLUR); break;
			    case "7": imagefilter( $this->img, IMG_FILTER_MEAN_REMOVAL); break;
			    case "8": imagefilter( $this->img, IMG_FILTER_SMOOTH, $x); break;
			    case "9":
			        if ($x<0 or $x>255) $x = 0;
			        if ($y<0 or $y>255) $y = 0;
			        if ($z<0 or $z>255) $z = 0;
			        imagefilter( $this->img, IMG_FILTER_COLORIZE, $x, $y, $z );
			    break;
			    case "10": imagefilter( $this->img, IMG_FILTER_BRIGHTNESS, $x); break;
			    case "11": imagefilter( $this->img, IMG_FILTER_CONTRAST, $x ); break;
			 	case "12":

		        	$n = trim ($n);
		        	$ns = explode ("\n", $n);

		        	for( $i = 0; $i < count ($ns); $i ++)
		        	{

						preg_match( "#(((.*?)=(.*?),(.*?),(.*?);)|((.*?);))#ies", $ns[$i],  $f );

						if( count ($f) == 7 )
						{
			                $elf = intval($f[3]);
			                $parametr_1 = intval($f[4]);
			                $parametr_2 = intval($f[5]);
			                $parametr_3 = intval($f[6]);
						}elseif( count ($f) == 9 ){
		                	$elf = intval($f[8]);
						}

						switch ($elf)
						{

						    case 1: imagefilter( $this->img, IMG_FILTER_NEGATE); break;
						    case 2: imagefilter( $this->img, IMG_FILTER_GRAYSCALE); break;
						    case 3: imagefilter( $this->img, IMG_FILTER_EDGEDETECT);  break;
						    case 4: imagefilter( $this->img, IMG_FILTER_EMBOSS); break;
						    case 5: imagefilter( $this->img, IMG_FILTER_GAUSSIAN_BLUR); break;
						    case 6: imagefilter( $this->img, IMG_FILTER_SELECTIVE_BLUR); break;
						    case 7: imagefilter( $this->img, IMG_FILTER_MEAN_REMOVAL); break;
						    case 8: imagefilter( $this->img, IMG_FILTER_SMOOTH, $parametr_1); break;
						    case 9:
						        if ($parametr_1<0 or $parametr_1>255) $parametr_1 = 0;
						        if ($parametr_2<0 or $parametr_2>255) $parametr_2 = 0;
						        if ($parametr_3<0 or $parametr_3>255) $parametr_3 = 0;
						        imagefilter( $this->img, IMG_FILTER_COLORIZE, $parametr_1, $parametr_2, $parametr_3 );
							break;
						    case 10: imagefilter( $this->img, IMG_FILTER_BRIGHTNESS, $parametr_1); break;
						    case 11: imagefilter( $this->img, IMG_FILTER_CONTRAST, $parametr_1); break;
					    }
		        	}
			 	break;
			}
		}
	}
?>