<?php
/**
*
* install [Russian]
*
* @package language
* @version $Id: install.php 10152 2009-09-16 13:02:13Z acydburn $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ADMIN_CONFIG'				=> 'Настройки администратора',
	'ADMIN_PASSWORD'			=> 'Пароль администратора',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Подтверждение пароля администратора',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Введите пароль длиной от 6 до 30 символов.',
	'ADMIN_TEST'				=> 'Проверка настроек администратора',
	'ADMIN_USERNAME'			=> 'Имя администратора',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Введите имя длиной от 3 до 20 символов.',
	'APP_MAGICK'				=> 'Поддержка Imagemagick [ вложения ]',
	'AUTHOR_NOTES'				=> 'Заметки автора<br />» %s',
	'AVAILABLE'					=> 'Доступно',
	'AVAILABLE_CONVERTORS'		=> 'Доступные конвертеры',

	'BEGIN_CONVERT'					=> 'Начать конвертирование',
	'BLANK_PREFIX_FOUND'			=> 'Просмотр ваших таблиц показал наличие подходящей конференции без префикса таблиц.',
	'BOARD_NOT_INSTALLED'			=> 'phpBB3 не установлен',
	'BOARD_NOT_INSTALLED_EXPLAIN'	=> 'Для работы единой системы конвертирования требуется установленная по умолчанию версия phpBB3, пожалуйста, <a href="%s">сначала перейдите к установке phpBB3</a>.',
	'BACKUP_NOTICE'					=> 'Создайте резервную копию конференции на случай возникновения проблем в процессе обновления.',

	'CATEGORY'					=> 'Категория',
	'CACHE_STORE'				=> 'Тип кэша',
	'CACHE_STORE_EXPLAIN'		=> 'Физическое расположение данных кэша, предпочтительная файловая система.',
	'CAT_CONVERT'				=> 'Конвертирование',
	'CAT_INSTALL'				=> 'Установка',
	'CAT_OVERVIEW'				=> 'Введение',
	'CAT_UPDATE'				=> 'Обновление',
	'CHANGE'					=> 'Изменить',
	'CHECK_TABLE_PREFIX'		=> 'Проверьте правильность префикса таблиц и попробуйте снова.',
	'CLEAN_VERIFY'				=> 'Очистка и проверка конечной структуры',
	'CLEANING_USERNAMES'		=> 'Очистка имён пользователей',
	'COLLIDING_CLEAN_USERNAME'	=> 'Очищенное имя <strong>%s</strong> соответствует именам пользователей:',
	'COLLIDING_USERNAMES_FOUND'	=> 'На вашей старой конференции найдены конфликтующие имена пользователей. Для завершения преобразования удалите или переименуйте этих пользователей так, чтобы каждому очищенному имени соответствовал только один пользователь старой конференции.',
	'COLLIDING_USER'			=> '» идентификатор пользователя: <strong>%d</strong> имя пользователя: <strong>%s</strong> (сообщений: %d)',
	'CONFIG_CONVERT'			=> 'Конвертирование конфигурации',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Не удалось записать конфигурационный файл. Другие методы создания этого файла указаны ниже.',
	'CONFIG_FILE_WRITTEN'		=> 'Конфигурационный файл записан. Теперь вы можете приступить к следующему этапу установки.',
	'CONFIG_PHPBB_EMPTY'		=> 'Переменная конфигурации phpBB3 для «%s» пуста.',
	'CONFIG_RETRY'				=> 'Повторить',
	'CONTACT_EMAIL_CONFIRM'		=> 'Подтверждение контактного адреса email',
	'CONTINUE_CONVERT'			=> 'Продолжить конвертирование',
	'CONTINUE_CONVERT_BODY'		=> 'Обнаружена предыдущая попытка конвертирования. Вы можете начать новое конвертирование или продолжить предыдущее',
	'CONTINUE_LAST'				=> 'Продолжить выполнение заключительных операций',
	'CONTINUE_OLD_CONVERSION'	=> 'Продолжить ранее начатое конвертирование',
	'CONVERT'					=> 'Конвертировать',
	'CONVERT_COMPLETE'			=> 'Конвертирование завершено',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Вы успешно сконвертировали вашу конференцию в формат phpBB 3.0. Вы можете <a href="../">войти на конференцию</a>. Убедитесь, что все настройки успешно перенесены, прежде чем запустите конференцию, удалив папку install. Помните, что вспомогательную информацию по использованию phpBB можно получить в интернете, изучив <a href="http://www.phpbb.com/support/documentation/3.0/">документацию</a>, а также на <a href="http://www.phpbb.com/phpBB/viewforum.php?f=46">форуме поддержки phpBB Group</a> и форуме официальной русской поддержки <a href="http://phpbbguru.net">phpBB Guru</a>.',
	'CONVERT_INTRO'				=> 'Вас приветствует система конвертирования phpBB',
	'CONVERT_INTRO_BODY'		=> 'Здесь вы имеете возможность импортировать данные из других (установленных) типов конференций. В списке ниже содержатся доступные в настоящее время модули для конвертирования. Если в нём отсутствует конференция, которую вы хотели бы конвертировать, пожалуйста, посетите наш веб-сайт, на котором могут быть доступны для скачивания дополнительные модули.',
	'CONVERT_NEW_CONVERSION'	=> 'Новое конвертирование',
	'CONVERT_NOT_EXIST'			=> 'Указанного конвертера не существует.',
	'CONVERT_OPTIONS'			=> 'Параметры',
	'CONVERT_SETTINGS_VERIFIED'	=> 'Проверка указанной вами информации завершена. Чтобы начать конвертирование, нажмите кнопку ниже.',
	'CONV_ERR_FATAL'					=> 'Критическая ошибка при конвертировании',

	'CONV_ERROR_ATTACH_FTP_DIR'			=> 'На старой конференции включена загрузка вложений по FTP. Отключите эту функцию и убедитесь в правильности указанной папки для загрузки, затем скопируйте все файлы вложений в эту новую папку, доступную через интернет. После этого перезапустите конвертер.',
	'CONV_ERROR_CONFIG_EMPTY'			=> 'Отсутствует доступная информация о конфигурации для конвертирования.',
	'CONV_ERROR_FORUM_ACCESS'			=> 'Не удалось получить информацию о локальных правах доступа.',
	'CONV_ERROR_GET_CATEGORIES'			=> 'Не удалось получить информацию о категориях.',
	'CONV_ERROR_GET_CONFIG'				=> 'Не удалось получить информацию о конфигурации конференции.',
	'CONV_ERROR_COULD_NOT_READ'			=> 'Не удалось получить доступ или прочесть «%s».',
	'CONV_ERROR_GROUP_ACCESS'			=> 'Не удалось получить информацию о правах групп.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Обнаружено нарушение целостности таблицы групп в add_bots(). Необходимо добавить все специальные группы вручную.',
	'CONV_ERROR_INSERT_BOT'				=> 'Не удалось добавить бота в таблицу пользователей.',
	'CONV_ERROR_INSERT_BOTGROUP'		=> 'Не удалось добавить бота в таблицу ботов.',
	'CONV_ERROR_INSERT_USER_GROUP'		=> 'Не удалось добавить пользователя в таблицу user_group.',
	'CONV_ERROR_MESSAGE_PARSER'			=> 'Ошибка обработки сообщения',
	'CONV_ERROR_NO_AVATAR_PATH'			=> 'Примечание разработчику: вы должны указать $convertor[\'avatar_path\'] для использования %s.',
	'CONV_ERROR_NO_FORUM_PATH'			=> 'Не указан относительный путь к исходной конференции.',
	'CONV_ERROR_NO_GALLERY_PATH'		=> 'Примечание разработчику: вы должны указать $convertor[\'avatar_gallery_path\'] для использования %s.',
	'CONV_ERROR_NO_GROUP'				=> 'Не удалось найти группу «%1$s» в %2$s.',
	'CONV_ERROR_NO_RANKS_PATH'			=> 'Примечание разработчику: вы должны указать $convertor[\'ranks_path\'] для использования %s.',
	'CONV_ERROR_NO_SMILIES_PATH'		=> 'Примечание разработчику: вы должны указать $convertor[\'smilies_path\'] для использования %s.',
	'CONV_ERROR_NO_UPLOAD_DIR'			=> 'Примечание разработчику: вы должны указать $convertor[\'upload_path\'] для использования %s.',
	'CONV_ERROR_PERM_SETTING'			=> 'Не удалось добавить/обновить настройки прав доступа.',
	'CONV_ERROR_PM_COUNT'				=> 'Не удалось отобрать количество личных сообщений в папке.',
	'CONV_ERROR_REPLACE_CATEGORY'		=> 'Не удалось добавить новый форум вместо старой категории.',
	'CONV_ERROR_REPLACE_FORUM'			=> 'Не удалось добавить новый форум вместо старого форума.',
	'CONV_ERROR_USER_ACCESS'			=> 'Не удалось получить данные аутентификации пользователя.',
	'CONV_ERROR_WRONG_GROUP'			=> 'Обнаружена неправильная группа «%1$s» в %2$s.',
	'CONV_OPTIONS_BODY'					=> 'На этой странице вам предлагается ввести данные, необходимые для доступа к исходной конференции. Укажите информацию о базе данных вашей старой конференции; конвертер не будет вносить в неё никаких изменений. Для обеспечения полноценной конвертации исходную конференцию следует отключить.',
	'CONV_SAVED_MESSAGES'				=> 'Сохранённые сообщения',

	'COULD_NOT_COPY'			=> 'Не удалось скопировать файл <strong>%1$s</strong> в <strong>%2$s</strong><br /><br />Проверьте, что конечная папка существует и что в неё может осуществляться запись.',
	'COULD_NOT_FIND_PATH'		=> 'Не удалось найти путь к старой конференции. Проверьте настройки и попробуйте снова.<br />» Путь %s был указан как исходный.',

	'DBMS'						=> 'Тип базы данных',
	'DB_CONFIG'					=> 'Конфигурация базы данных (БД)',
	'DB_CONNECTION'				=> 'Подключение к базе данных',
	'DB_ERR_INSERT'				=> 'Ошибка при обработке запроса <code>INSERT</code>.',
	'DB_ERR_LAST'				=> 'Ошибка при обработке <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'		=> 'Ошибка при выполнении <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Ошибка при выполнении <var>query_first</var>, %s («%s»).',
	'DB_ERR_SELECT'				=> 'Ошибка при обработке запроса <code>SELECT</code>.',
	'DB_HOST'					=> 'Имя сервера БД или DSN',
	'DB_HOST_EXPLAIN'			=> 'DSN — это имя источника данных и требуется только при установке с использованием ODBC.  В PostgreSQL используйте имя localhost для соединения с локальным сервером через сокет домена UNIX или адрес 127.0.0.1 для соединения через TCP. Для SQLite задайте полный путь к файлу базы данных.',
	'DB_NAME'					=> 'Название базы данных',
	'DB_PASSWORD'				=> 'Пароль к БД',
	'DB_PORT'					=> 'Порт сервера БД',
	'DB_PORT_EXPLAIN'			=> 'Оставьте поле пустым, если сервер использует порт по умолчанию.',
	'DB_UPDATE_NOT_SUPPORTED'	=> 'К сожалению, данный сценарий не поддерживает обновление с версий phpBB до «%1$s». Установленная вами версия — «%2$s». Обновите предыдущую версию перед выполнением этого сценария. Помощь по этой проблеме можно найти на форумах поддержки на сайте phpBB.com.',
	'DB_USERNAME'				=> 'Имя пользователя БД',
	'DB_TEST'					=> 'Проверка подключения',
	'DEFAULT_LANG'				=> 'Язык конференции по умолчанию',
	'DEFAULT_PREFIX_IS'			=> 'Конвертеру не удалось найти таблицы phpBB2 с указанным префиксом. Убедитесь, что вы ввели правильные данные о старой конференции. У таблиц конференции %1$s префикс <strong>%2$s</strong>.',
	'DEV_NO_TEST_FILE'			=> 'В конвертере не указано значение переменной test_file. Если вы пользователь этого конвертера, то сообщите об этой ошибке его автору, поскольку она не должна возникать. Если вы автор конвертера, то вы должны задать имя существующего файла конвертируемой конференции для проверки правильности пути к ней.',
	'DIRECTORIES_AND_FILES'		=> 'Настройка папок и файлов',
	'DISABLE_KEYS'				=> 'Отключение ключей',
	'DLL_FIREBIRD'				=> 'Firebird',
	'DLL_FTP'					=> 'Поддержка удалённого FTP [ установка ]',
	'DLL_GD'					=> 'Поддержка графической библиотеки GD [ визуальное подтверждение ]',
	'DLL_MBSTRING'				=> 'Поддержка многобайтных символов',
	'DLL_MSSQL'					=> 'MSSQL Server 2000+',
	'DLL_MSSQL_ODBC'			=> 'MSSQL Server 2000+ через ODBC',
	'DLL_MSSQLNATIVE'			=> 'MSSQL Server 2005+ [ Native ]',
	'DLL_MYSQL'					=> 'MySQL',
	'DLL_MYSQLI'				=> 'MySQL с расширением MySQLi',
	'DLL_ORACLE'				=> 'Oracle',
	'DLL_POSTGRES'				=> 'PostgreSQL',
	'DLL_SQLITE'				=> 'SQLite',
	'DLL_XML'					=> 'Поддержка XML [ Jabber ]',
	'DLL_ZLIB'					=> 'Поддержка сжатия zlib [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'					=> 'Скачать файл конфигурации',
	'DL_CONFIG_EXPLAIN'			=> 'Вы можете целиком скачать файл config.php к себе на компьютер. Затем вам будет нужно вручную закачать этот файл в корневую папку phpBB 3.0, заменив исходный config.php. Помните, что файл должен быть закачан на сервер в формате ASCII (если вы не знаете как этого добиться, обратитесь к документации вашего FTP-клиента). После того, как закачаете config.php, щелкните «Готово» для перехода к следующему шагу.',
	'DL_DOWNLOAD'				=> 'Скачать',
	'DONE'						=> 'Готово',

	'ENABLE_KEYS'				=> 'Восстановление ключей. Это действие может занять некоторое время.',

	'FILES_OPTIONAL'			=> 'Необязательные файлы и папки',
	'FILES_OPTIONAL_EXPLAIN'	=> 'Следующие файлы, папки или права доступа <strong>не являются обязательными</strong>. Программа установки попытается использовать различные методы для их создания, если они не существуют или если для них нет прав на запись. Тем не менее их наличие ускорит процесс установки.',
	'FILES_REQUIRED'			=> 'Файлы и папки',
	'FILES_REQUIRED_EXPLAIN'	=> 'Для правильной работы phpBB <strong>необходим</strong> доступ на чтение или запись определённых файлов и папок. Если вы увидите надпись «Не найден», то необходимо создать соответствующий файл или папку. А если увидите надпись «Нет прав на запись», то необходимо изменить права на файл или на папку, чтобы разрешить phpBB запись в них.',
	'FILLING_TABLE'				=> 'Заполнение таблицы <strong>%s</strong>',
	'FILLING_TABLES'			=> 'Заполнение таблиц',

	'FIREBIRD_DBMS_UPDATE_REQUIRED'		=> 'phpBB больше не поддерживает Firebird/Interbase до версии 2.1. Перед продолжением процесса обновления обновите Firebird, по крайней мере, до версии 2.1.0.',

	'FINAL_STEP'				=> 'Заключительный этап',
	'FORUM_ADDRESS'				=> 'Адрес конференции',
	'FORUM_ADDRESS_EXPLAIN'		=> 'URL старой конференции, например, <samp>http://www.example.com/phpBB2/</samp>. Если вы заполните это поле, то во всех сообщениях, ЛС и подписях этот адрес будет заменён на адрес новой конференции.',
	'FORUM_PATH'				=> 'Путь к конференции',
	'FORUM_PATH_EXPLAIN'		=> '<strong>Относительный</strong> путь к старой конференции от <strong>корневой папки установленного phpBB3</strong>.',
	'FOUND'						=> 'Найден',
	'FTP_CONFIG'				=> 'Перенести файл конфигурации по FTP',
	'FTP_CONFIG_EXPLAIN'		=> 'Обнаружено наличие модуля FTP на сервере. Вы можете попробовать установить файл config.php с помощью этого модуля. Вам понадобится ввести указанные ниже данные. Помните, что эти имя пользователя и пароль относятся к вашему серверу! Если вы не знаете их, то обратитесь за помощью к своему хостинг-провайдеру.',
	'FTP_PATH'					=> 'Путь FTP',
	'FTP_PATH_EXPLAIN'			=> 'Путь от корневой папки FTP до корневой папки phpBB, например, <samp>htdocs/phpBB3/</samp>',
	'FTP_UPLOAD'				=> 'Закачать',

	'GPL'						=> 'General Public License',

	'INITIAL_CONFIG'			=> 'Базовая конфигурация',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Программа установки определила, что phpBB может работать на вашем сервере, и теперь вам необходимо ввести некоторые данные. Если вы не знаете, как подключиться к вашей базе данных, то свяжитесь со своим провайдером (в первую очередь) или обратитесь за помощью на наши форумы поддержки. После ввода данных тщательно проверьте их перед отправкой.',
	'INSTALL_CONGRATS'			=> 'Поздравляем!',
	'INSTALL_CONGRATS_EXPLAIN'	=> '
		<p>Вы успешно установили phpBB %1$s. Теперь вы можете решить, что делать дальше с только что установленным phpBB3:</p>
		<h2>Сконвертировать имеющуюся конференцию в phpBB3</h2>
		<p>Единая система конвертирования phpBB поддерживает конвертирование из phpBB 2.0.x и других типов конференций в phpBB3. Если у вас есть конференция, которую вы желаете сконвертировать, то <a href="%2$s">перейдите в систему конвертирования</a>.</p>
		<h2>Начать использование phpBB3!</h2>
		<p>Нажав на кнопку ниже, вы попадёте на страницу отправки статистических данных phpBB в администраторском разделе (ACP). Мы будем вам очень признательны, если вы поможете нам, отправив немного статистической информации о вашем сервере и конфигурации phpBB. На основе этой информации мы будем принимать решения о функциональности будущего phpBB. Затем ознакомьтесь с имеющимися пунктами меню и настройками администраторского раздела. Освоение имеющихся возможностей phpBB3 может занять некоторое время. Помните о доступной в интернете <a href="http://www.phpbb.com/support/documentation/3.0/">документации</a>, <a href="%3$s">встроенном файле README</a> и <a href="http://www.phpbb.com/community/viewforum.php?f=46">форуме поддержки</a> (на английском), а также официальном форуме русскоязычной поддержки <a href="http://phpbbguru.net">phpBB Guru</a>.</p><p><strong>Удалите, переместите или переименуйте папку «install» перед использованием конференции. В противном случае будет доступен только администраторский раздел.</strong>',
	'INSTALL_INTRO'				=> 'Вас приветствует программа установки phpBB',

	'INSTALL_INTRO_BODY'		=> 'С помощью этой программы установки вы сможете установить phpBB3 на сервер.</p><p>Для этого вам необходимо знать реквизиты доступа к базе данных. Если вы не знаете их, то свяжитесь с компанией, предоставляющей вам услуги хостинга, и узнайте их у неё. Вы не сможете продолжить установку без этих данных. Также вам нужно знать следующее:</p>

	<ul>
		<li>Тип базы данных (БД) — той, которую вы будете использовать.</li>
		<li>Имя сервера БД или DSN — адрес сервера базы данных.</li>
		<li>Порт сервера БД — порт сервера базы данных (не нужно указывать в большинстве случаев).</li>
		<li>Название базы данных — имя базы данных на сервере.</li>
		<li>Имя пользователя БД и Пароль к БД — данные для доступа к базе данных.</li>
	</ul>

	<p><strong>Примечание:</strong> если вы выполняете установку с использованием SQLite, то вам необходимо ввести полный путь к файлу базы данных в поле «Имя сервера базы данных или DSN» и оставить пустыми поля имени пользователя и пароля. По соображениям безопасности, вам необходимо удостовериться в том, что этот файл недоступен через интернет.</p>

	<p>phpBB3 поддерживает следующие базы данных:</p>
	<ul>
		<li>MySQL 3.23 и выше (поддерживается MySQLi)</li>
		<li>PostgreSQL 7.3 и выше</li>
		<li>SQLite 2.8.2 и выше</li>
		<li>Firebird 2.1 и выше</li>
		<li>MS SQL Server 2000 и выше (напрямую или через ODBC)</li>
		<li>MS SQL Server 2005 и выше (native)</li>
		<li>Oracle</li>
	</ul>

	<p>В списке выбора типа базы данных будут отображаться лишь те, которые поддерживает ваш сервер.',
	'INSTALL_INTRO_NEXT'		=> 'Нажмите кнопку ниже, чтобы начать установку.',
	'INSTALL_LOGIN'				=> 'Вход',
	'INSTALL_NEXT'				=> 'Следующий этап',
	'INSTALL_NEXT_FAIL'			=> 'Часть проверок завершилась неудачно. Вам необходимо исправить найденные проблемы перед переходом к следующему этапу. В противном случае установка конференции будет неоконченной.',
	'INSTALL_NEXT_PASS'			=> 'Все основные проверки пройдены, и вы можете перейти к следующему этапу установки. Если вы изменили какие-либо права, модули, и т. п., то вы можете повторно пройти проверки, нажав соответствующую кнопку.',
	'INSTALL_PANEL'				=> 'Установка phpBB',
	'INSTALL_SEND_CONFIG'		=> 'К сожалению, не удалось записать конфигурацию phpBB напрямую в файл config.php. Возможно, файл не существует, или отсутствуют права на запись. Ниже представлен список вариантов, позволяющих завершить установку config.php.',
	'INSTALL_START'				=> 'Начать установку',
	'INSTALL_TEST'				=> 'Повторная проверка',
	'INST_ERR'					=> 'Ошибка при установке',
	'INST_ERR_DB_CONNECT'		=> 'Не удалось подключиться к базе данных. Ниже показан текст сообщения об ошибке.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Указанный файл базы данных находится в папке конференции. Необходимо переместить его в папку, недоступную из интернета.',
	'INST_ERR_DB_INVALID_PREFIX'=> 'Указан неправильный префикс. Он должен начинаться с буквы и может содержать только буквы, числа и знаки подчёркивания.',
	'INST_ERR_DB_NO_ERROR'		=> 'Нет сообщения об ошибке.',
	'INST_ERR_DB_NO_MYSQLI'		=> 'Установленная на сервере версия MySQL несовместима с выбранным вариантом «MySQL с расширением MySQLi». Вместо него попробуйте выбрать вариант «MySQL».',
	'INST_ERR_DB_NO_SQLITE'		=> 'У вас установлена устаревшая версия расширения SQLite. Её необходимо обновить хотя бы до версии 2.8.2.',
	'INST_ERR_DB_NO_ORACLE'		=> 'Для установленной на сервере версии Oracle необходимо установить значение параметра <var>NLS_CHARACTERSET</var> равным <var>UTF8</var>. Либо обновите базу данных до версии 9.2 или выше, либо измените значение параметра.',
	'INST_ERR_DB_NO_FIREBIRD'	=> 'Установленная на сервере версия Firebird старее 2.1. Обновите базу данных до новой версии.',
	'INST_ERR_DB_NO_FIREBIRD_PS'=> 'Выбранная база данных Firebird имеет размер страницы меньше 8192. Размер страницы должен быть не менее 8192.',
	'INST_ERR_DB_NO_POSTGRES'	=> 'Выбранная база данных создана не с кодировкой <var>UNICODE</var> или <var>UTF8</var>. Попробуйте установить конференцию в базу данных с кодировкой <var>UNICODE</var> или <var>UTF8</var>.',
	'INST_ERR_DB_NO_NAME'		=> 'Не указано название базы данных.',
	'INST_ERR_EMAIL_INVALID'	=> 'Введенный адрес email недопустим.',
	'INST_ERR_EMAIL_MISMATCH'	=> 'Введенные адреса email не совпадают.',
	'INST_ERR_FATAL'			=> 'Критическая ошибка при установке',
	'INST_ERR_FATAL_DB'			=> 'Произошла критическая ошибка при работе с базой данных. Установка прервана. Причиной может быть отсутствие необходимых прав на выполнение операций создания и добавления данных (<code>CREATE TABLES</code>, <code>INSERT</code> или аналогичных). Более подробная информация предоставлена ниже. Свяжитесь со своим провайдером или обратитесь на форумы поддержки phpBB за дополнительной информацией.',
	'INST_ERR_FTP_PATH'			=> 'Не удалось перейти в заданную папку. Убедитесь в правильности относительного пути.',
	'INST_ERR_FTP_LOGIN'		=> 'Не удалось войти на FTP-сервер. Проверьте правильность ввода имени пользователя и пароля.',
	'INST_ERR_MISSING_DATA'		=> 'На этой странице необходимо заполнить все поля.',
	'INST_ERR_NO_DB'			=> 'Не удалось загрузить модуль PHP для выбранного типа базы данных.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Введённые пароли не совпадают.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Введённый пароль слишком длинный. Длина пароля не должна превышать 30 символов.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Введённый пароль слишком короткий. Минимальная длина пароля — 6 символов.',
	'INST_ERR_PREFIX'			=> 'Таблицы с указанным префиксом уже существуют. Введите другой префикс.',
	'INST_ERR_PREFIX_INVALID'	=> 'Указанный префикс недопустим для вашей базы данных. Введите другой префикс без специальных символов типа дефиса.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Указанный префикс таблиц слишком длинный. Длина префикса не должна превышать %d символов.',
	'INST_ERR_USER_TOO_LONG'	=> 'Введённое имя пользователя слишком длинное. Длина имени пользователя не должна превышать 20 символов.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Введённое имя пользователя слишком короткое. Минимальная длина имени пользователя — 3 знака.',
	'INVALID_PRIMARY_KEY'		=> 'Недопустимый первичный ключ: %s',

	'LONG_SCRIPT_EXECUTION'		=> 'Выполнение может занять некоторое время… Пожалуйста, не останавливайте процесс.',

	// mbstring
	'MBSTRING_CHECK'						=> 'Проверка расширения <samp>mbstring</samp>',
	'MBSTRING_CHECK_EXPLAIN'				=> '<strong>Необходимо</strong>. <samp>mbstring</samp> — это расширение PHP, обеспечивающее работу многобайтных строковых функций. Некоторые возможности mbstring несовместимы с phpBB и должны быть отключены.',
	'MBSTRING_FUNC_OVERLOAD'				=> 'Перегрузка функции',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'		=> 'Значение <var>mbstring.func_overload</var> должно быть установлено в 0 или в 4.',
	'MBSTRING_ENCODING_TRANSLATION'			=> 'Прозрачное кодирование символов',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> 'Значение <var>mbstring.encoding_translation</var> должно быть установлено в 0.',
	'MBSTRING_HTTP_INPUT'					=> 'Кодировка входящих символов',
	'MBSTRING_HTTP_INPUT_EXPLAIN'			=> 'Значение <var>mbstring.http_input</var> должно быть установлено в <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'					=> 'Кодировка исходящих символов',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'			=> 'Значение <var>mbstring.http_output</var> должно быть установлено в <samp>pass</samp>.',

	'MAKE_FOLDER_WRITABLE'		=> 'Убедитесь, что эта папка существует и у сервера есть права на запись в неё, затем повторите попытку:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'		=> 'Убедитесь, что эти папки существуют и у сервера есть права на запись в них, затем повторите попытку:<br />»<strong>%s</strong>.',

	'MYSQL_SCHEMA_UPDATE_REQUIRED'	=> 'Схема вашей базы данных MySQL устарела. phpBB обнаружил, что используется схема для MySQL 3.x/4.x, но сервер работает на MySQL %2$s.<br /><strong>Перед началом процесса обновления вам необходимо произвести обновление схемы базы данных.</strong><br /><br />Прочтите в базе знаний <a href="http://www.phpbb.com/kb/article/doesnt-have-a-default-value-errors/">статью об обновлении базы данных MySQL</a>. При возникновении проблем обращайтесь на <a href="http://www.phpbbguru.net/community/">форумы официальной русской поддержки phpBB</a>.',

	'NAMING_CONFLICT'			=> 'Конфликт имён: оба имени %s и %s являются псевдонимами<br /><br />%s',
	'NEXT_STEP'					=> 'Следующий шаг',
	'NOT_FOUND'					=> 'Не найден',
	'NOT_UNDERSTAND'			=> 'Не удалось разобрать выражение %s #%d, таблица %s («%s»)',
	'NO_CONVERTORS'				=> 'Нет доступных для использования конвертеров.',
	'NO_CONVERT_SPECIFIED'		=> 'Не выбран конвертер.',
	'NO_LOCATION'				=> 'Не удалось найти приложение. Если вы знаете, что Imagemagick установлен, то вы можете указать путь к нему после установки конференции в администраторском разделе.',
	'NO_TABLES_FOUND'			=> 'Таблиц не найдено.',

	'OVERVIEW_BODY'					=> 'Добро пожаловать в phpBB3!<br /><br />phpBB™ является наиболее распространённым решением с открытым кодом для организации конференций в интернете. phpBB3 является новейшим продуктом в линейке начиная с 2000 года. Как и его предшественники, phpBB3 является функциональным, имеет дружественный интерфейс и полностью поддерживается phpBB Team. В phpBB3 существенно улучшены качества, сделавшие популярным phpBB2, добавлены наиболее необходимые функции, которые отсутствовали в предыдущих версиях. Надеемся, что это превзойдёт ваши ожидания.<br /><br />Эта система проведёт вас через процессы установки phpBB3, обновления предыдущих релизов до последней версии phpBB3, а также конвертирования в phpBB3 другого программного обеспечения для конференций (включая phpBB2). Для получения дополнительной информации мы предлагаем вам ознакомиться с <a href="../docs/INSTALL.html">руководством по установке</a>.<br /><br />Чтобы ознакомиться с лицензионными условиями phpBB3 или узнать о поддержке, выберите соответствующий пункт в боковом меню. Для продолжения выберите нужную закладку выше.',

	'PCRE_UTF_SUPPORT'				=> 'Поддержка UTF-8 в PCRE',
	'PCRE_UTF_SUPPORT_EXPLAIN'		=> 'phpBB <strong>не будет</strong> работать, если PHP собран без поддержки UTF-8 для расширения PCRE.',
	'PHP_GETIMAGESIZE_SUPPORT'			=> 'Функция PHP <var>getimagesize()</var> доступна',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Необходима</strong>. Для правильной работы phpBB необходимо наличие функции getimagesize.',
	'PHP_OPTIONAL_MODULE'			=> 'Необязательные модули',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> 'Эти модули и приложения <strong>не являются обязательными</strong>. Тем не менее они предоставляют расширенные возможности будущей конференции.',
	'PHP_SUPPORTED_DB'				=> 'Поддерживаемые базы данных',
	'PHP_SUPPORTED_DB_EXPLAIN'		=> 'Ваша версия PHP должна поддерживать <strong>не менее одной</strong> из перечисленных ниже баз данных. Если в списке не окажется поддерживаемых баз, то свяжитесь со своим провайдером или обратитесь к соответствующему разделу документации PHP.',
	'PHP_REGISTER_GLOBALS'			=> 'Параметр PHP <var>register_globals</var> отключён',
	'PHP_REGISTER_GLOBALS_EXPLAIN'	=> 'phpBB будет работать, даже если параметр register_globals включён. Но, по возможности, его рекомендуется отключить из соображений безопасности.',
	'PHP_SAFE_MODE'					=> 'Безопасный режим (Safe mode)',
	'PHP_SETTINGS'					=> 'Версия и настройки PHP',
	'PHP_SETTINGS_EXPLAIN'			=> 'Для установки phpBB <strong>требуется</strong> версия PHP не ниже 4.3.3. Если ниже написано <var>Безопасный режим (Safe mode)</var>, то PHP работает в этом режиме. Это наложит некоторые ограничения на удалённое администрирование и аналогичные функции.',
	'PHP_URL_FOPEN_SUPPORT'			=> 'Параметр PHP <var>allow_url_fopen</var> включён',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>Необязательно</strong>. Хотя этот параметр не является обязательным, некоторые функции phpBB, типа внешних аватар, не будут работать должным образом. ',
	'PHP_VERSION_REQD'				=> 'Версия PHP ≥ 4.3.3',
	'POST_ID'						=> 'Идентификатор сообщения',
	'PREFIX_FOUND'					=> 'Просмотр ваших таблиц показал наличие подходящей конференции с префиксом таблиц <strong>%s</strong>.',
	'PREPROCESS_STEP'				=> 'Выполнение предварительных функций/запросов',
	'PRE_CONVERT_COMPLETE'			=> 'Все этапы подготовки к конвертированию успешно завершены. Теперь вы можете начать процесс конвертирования. Учтите, что вам, возможно, придётся вручную произвести некоторые действия и настройки. После конвертирования обязательно проверьте назначенные права доступа, восстановите поисковый индекс, который не подлежал конвертированию, если необходимо, а также удостоверьтесь, что все файлы были успешно скопированы (например, аватары и смайлики).',
	'PROCESS_LAST'					=> 'Выполнение заключительных операций',

	'REFRESH_PAGE'				=> 'Обновлять страницу для продолжения конвертирования',
	'REFRESH_PAGE_EXPLAIN'		=> '«Да» означает, что конвертер будет автоматически перезагружать страницу, чтобы продолжить конвертирование после завершения очередного этапа. Если это ваша первая конвертация с целью тестирования и проверки на ошибки, мы советуем установить значение этого параметра в «Нет».',
	'REQUIREMENTS_TITLE'		=> 'Программная совместимость',
	'REQUIREMENTS_EXPLAIN'		=> 'Перед установкой phpBB3 будут проведены проверки файлов и конфигурации сервера, чтобы удостовериться в том, что phpBB3 можно установить и запустить. Внимательно ознакомьтесь с результатами и не переходите к следующему шагу установки до тех пор, пока необходимые проверки не будут пройдены. Если вам нужны какие-либо из дополнительных возможностей конференции, убедитесь, что соответствующие им тесты также успешно пройдены.',
	'RETRY_WRITE'				=> 'Повторить попытку записи конфигурации',
	'RETRY_WRITE_EXPLAIN'		=> 'При желании вы можете изменить права на файл config.php, чтобы разрешить phpBB запись в него. В этом случае нажмите на кнопку «Повторить» ниже. Не забудьте вернуть права на файл config.php после завершения установки.',

	'SCRIPT_PATH'				=> 'Путь к конференции',
	'SCRIPT_PATH_EXPLAIN'		=> 'Путь к папке, содержащей phpBB, относительно корня сайта. Например, <samp>/phpBB3</samp>.',
	'SELECT_LANG'				=> 'Выберите язык',
	'SERVER_CONFIG'				=> 'Конфигурация сервера',
	'SEARCH_INDEX_UNCONVERTED'	=> 'Поисковый индекс не был сконвертирован',
	'SEARCH_INDEX_UNCONVERTED_EXPLAIN'	=> 'Ваш старый поисковый индекс не был сконвертирован. Любой поисковый запрос вернёт пустой результат. Чтобы создать новый поисковый индекс, перейдите в администраторский раздел, выберите подраздел «Обслуживание» и в нём пункт «Поисковый индекс».',
	'SOFTWARE'					=> 'Тип конференции',
	'SPECIFY_OPTIONS'			=> 'Определение настроек конвертирования',
	'STAGE_ADMINISTRATOR'		=> 'Сведения об администраторе',
	'STAGE_ADVANCED'			=> 'Дополнительные параметры',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Изменять параметры на этой странице необходимо лишь в том случае, если вы знаете, что вам не подойдут настройки по умолчанию. Если вы не уверены, то пропустите эту страницу и смело переходите к следующему этапу установки — все эти настройки можно будет изменить позже в администраторском разделе.',
	'STAGE_CONFIG_FILE'			=> 'Файл конфигурации',
	'STAGE_CREATE_TABLE'		=> 'Создание таблиц базы данных',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Таблицы базы данных phpBB 3.0 созданы и заполнены начальными данными. Перейдите к следующему этапу для завершения установки phpBB.',
	'STAGE_DATABASE'			=> 'Настройки базы данных',
	'STAGE_FINAL'				=> 'Заключительный этап',
	'STAGE_INTRO'				=> 'Введение',
	'STAGE_IN_PROGRESS'			=> 'Конвертирование',
	'STAGE_REQUIREMENTS'		=> 'Требования',
	'STAGE_SETTINGS'			=> 'Параметры',
	'STARTING_CONVERT'			=> 'Начало конвертирования',
	'STEP_PERCENT_COMPLETED'	=> 'Этап <strong>%d</strong> из <strong>%d</strong>',
	'SUB_INTRO'					=> 'Введение',
	'SUB_LICENSE'				=> 'Лицензия',
	'SUB_SUPPORT'				=> 'Поддержка',
	'SUCCESSFUL_CONNECT'		=> 'Успешное подключение',
	'SUPPORT_BODY'				=> 'Полная поддержка предоставляется для последнего стабильного релиза phpBB3 бесплатно. Она включает:</p><ul><li>установку</li><li>конфигурацию</li><li>технические вопросы</li><li>проблемы, связанные с потенциальными ошибками программного обеспечения</li><li>обновление версий — кандидатов на релиз (RC) до последней стабильной версии</li><li>конвертирование phpBB 2.0.x в phpBB3</li><li>конвертирование в phpBB3 другого программного обеспечения для конференций (смотрите <a href="http://www.phpbb.com/community/viewforum.php?f=65">Convertors Forum</a>)</li></ul><p>Мы предлагаем пользователям, до сих пор использующим бета-версии phpBB3, заново установить последнюю версию. </p><h2>МОДы/Стили</h2><p>Вопросы, связанные с МОДами, обсуждаются в соответствующем форуме <a href="http://www.phpbb.com/community/viewforum.php?f=81">Modifications Forum</a>.<br />Вопросы, связанные со стилями, обсуждаются в соответствующем форуме <a href="http://www.phpbb.com/community/viewforum.php?f=80">Styles Forum</a>.<br /><br />Если ваш вопрос связан с конкретным продуктом, задавайте его в теме, посвящённой этому продукту.</p><h2>Получение поддержки</h2><p><a href="http://www.phpbb.com/community/viewtopic.php?f=14&amp;t=571070">С чего начать</a><br /><a href="http://www.phpbb.com/support/">Поддержка</a><br /><a href="http://www.phpbb.com/support/documentation/3.0/quickstart/">Краткое руководство</a><br /><br />Чтобы быть в курсе последних новостей и релизов, вы можете подписаться на <a href="http://www.phpbb.com/support/">нашу рассылку</a>.<br /><br />',
	'SYNC_FORUMS'				=> 'Синхронизация форумов',
	'SYNC_POST_COUNT'			=> 'Синхронизация количества сообщений',
	'SYNC_POST_COUNT_ID'		=> 'Синхронизация количества сообщений с <var>entry</var> от %1$s до %2$s',
	'SYNC_TOPICS'				=> 'Синхронизация тем',
	'SYNC_TOPIC_ID'				=> 'Синхронизация тем с <var>topic_id</var> от %1$s до %2$s.',

	'TABLES_MISSING'			=> 'Не удалось найти таблицы<br />» <strong>%s</strong>.',
	'TABLE_PREFIX'				=> 'Префикс для таблиц в базе данных',
	'TABLE_PREFIX_EXPLAIN'		=> 'Префикс должен начинаться с буквы и может содержать только буквы, числа и знаки подчёркивания.',
	'TABLE_PREFIX_SAME'			=> 'Префикс таблиц должен быть тем же, который используется конвертируемой конференцией.<br />» Указанный префикс — %s.',
	'TESTS_PASSED'				=> 'Проверки пройдены',
	'TESTS_FAILED'				=> 'Проверки не пройдены',

	'UNABLE_WRITE_LOCK'			=> 'Не удалось записать файл блокировки.',
	'UNAVAILABLE'				=> 'Недоступно',
	'UNWRITABLE'				=> 'нет прав на запись',
	'UPDATE_TOPICS_POSTED'		=> 'Создание списка тем, в которых писал пользователь',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Произошла ошибка при создание списка тем, в которых писал пользователь. Вы можете повторить попытку выполнить этот этап в администраторском разделе после завершения процесса преобразования.',
	'VERIFY_OPTIONS'			=> 'Проверка настроек конвертирования',
	'VERSION'					=> 'Версия',

	'WELCOME_INSTALL'			=> 'Вас приветствует программа установки phpBB3.',
	'WRITABLE'					=> 'допускает запись',
));

// Updater
$lang = array_merge($lang, array(
	'ALL_FILES_UP_TO_DATE'		=> 'Все файлы соответствуют самой последней версии phpBB. Теперь <a href="../ucp.php?mode=login">войдите на конференцию</a> и проверьте, что всё работает нормально. Не забудьте удалить, переименовать или переместить папку «install»! Пожалуйста, отправьте нам обновлённую информацию о вашем сервере и конфигурации конференции с помощью страницы <a href="../ucp.php?mode=login&amp;redirect=adm/index.php%3Fi=send_statistics%26mode=send_statistics">Статистические данные</a> в администраторском разделе.',
	'ARCHIVE_FILE'				=> 'Файл-источник в архиве',

	'BACK'				=> 'Назад',
	'BINARY_FILE'		=> 'Бинарный файл',
	'BOT'				=> 'Паук/Робот',

	'CHANGE_CLEAN_NAMES'			=> 'Метод, используемый для проверки на использование одного и того же имени несколькими пользователями, был изменён. Имеется несколько пользователей, имеющих одно и то же имя при сравнении новым методом. Для продолжения необходимо удалить или переименовать этих пользователей, чтобы удостовериться, что каждое имя используется только одним пользователем.',
	'CHECK_FILES'					=> 'Сравнить файлы',
	'CHECK_FILES_AGAIN'				=> 'Повторно сравнить файлы',
	'CHECK_FILES_EXPLAIN'			=> 'На следующем этапе все файлы будут сравнены с файлами обновления. Это действие может занять некоторое время, если сравнение файлов проводится впервые.',
	'CHECK_FILES_UP_TO_DATE'		=> 'Согласно информации, находящейся в базе данных, ваша версия phpBB самая новая. Вы можете приступить к сравнению файлов, чтобы убедиться в том, что все файлы действительно соответствуют самой последней версии phpBB.',
	'CHECK_UPDATE_DATABASE'			=> 'Продолжить обновление',
	'COLLECTED_INFORMATION'			=> 'Сведения о файлах',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'Список ниже демонстрирует сведения о файлах, нуждающихся в обновлении. Прочтите информацию, предшествующую блоку файлов каждого типа, чтобы понять их смысл и что требуется сделать для выполнения успешного обновления.',
	'COLLECTING_FILE_DIFFS'			=> 'Проверка различий в файлах',
	'COMPLETE_LOGIN_TO_BOARD'		=> '<a href="../ucp.php?mode=login">Войдите на конференцию</a> и проверьте, что всё работает нормально. Не забудьте удалить, переименовать или переместить папку install!',
	'CONTINUE_UPDATE_NOW'			=> 'Продолжайте процесс обновления',		// Shown within the database update script at the end if called from the updater
	'CONTINUE_UPDATE'				=> 'Продолжайте обновление',				// Shown after file upload to indicate the update process is not yet finished
	'CURRENT_FILE'					=> 'Начало конфликта — код исходного файла до обновления',
	'CURRENT_VERSION'				=> 'Текущая версия',

	'DATABASE_TYPE'						=> 'Тип базы данных',
	'DATABASE_UPDATE_INFO_OLD'			=> 'Файл обновления базы данных в папке install устарел. Убедитесь, что закачали исправную версию этого файла.',
	'DELETE_USER_REMOVE'				=> 'Удалить пользователя и его сообщения',
	'DELETE_USER_RETAIN'				=> 'Удалить пользователя, но оставить его сообщения',
	'DESTINATION'						=> 'Файл-получатель',
	'DIFF_INLINE'						=> 'Внутри текста',
	'DIFF_RAW'							=> 'Код объединённых различий',
	'DIFF_SEP_EXPLAIN'					=> 'Код, используемый в обновлённом файле',
	'DIFF_SIDE_BY_SIDE'					=> 'Параллельно',
	'DIFF_UNIFIED'						=> 'Объединённые различия',
	'DO_NOT_UPDATE'						=> 'Не обновлять этот файл',
	'DONE'								=> 'Готово',
	'DOWNLOAD'							=> 'Скачать',
	'DOWNLOAD_AS'						=> 'Скачать в формате',
	'DOWNLOAD_UPDATE_METHOD_BUTTON'		=> 'Скачать архив с модифицированными файлами (рекомендуется)',
	'DOWNLOAD_CONFLICTS'				=> 'Скачать конфликтные места для этого файла',
	'DOWNLOAD_CONFLICTS_EXPLAIN'		=> 'Искать &lt;&lt;&lt; для выявления конфликтов',
	'DOWNLOAD_UPDATE_METHOD'			=> 'Скачать архив с модифицированными файлами',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Скачав архив, распакуйте его. В нём вы найдёте измененные файлы, которые нужно закачать в корень phpBB, при этом каждый файл должен оказаться в соответствующей ему папке. После этого снова проведите сравнение файлов, нажав отвечающую за это кнопку ниже.',

	'ERROR'			=> 'Ошибка',
	'EDIT_USERNAME'	=> 'Изменить имя пользователя',

	'FILE_ALREADY_UP_TO_DATE'		=> 'Файл уже соответствует новой версии.',
	'FILE_DIFF_NOT_ALLOWED'			=> 'Нет прав на выполнение команды diff для этого файла.',
	'FILE_USED'						=> 'Информация из файла',			// Single file
	'FILES_CONFLICT'				=> 'Конфликтующие файлы',
	'FILES_CONFLICT_EXPLAIN'		=> 'Следующие файлы модифицированы и не соответствуют оригинальным файлам старой версии. phpBB определил, что эти файлы будут создавать конфликт при объединении их с новыми версиями. Изучите конфликтные места и попытайтесь исправить их вручную, либо продолжите обновление, выбрав подходящий тип объединения файлов. Если вы будете разрешать конфликты вручную, то снова проведите сравнение файлов после внесения в них изменений. Для каждого файла в отдельности вы можете выбрать предпочтительный метод объединения с новой версией. Результатом работы первого метода будет файл, в котором отброшены конфликтующие строки из вашего старого файла, во втором методе будут отброшены конфликтующие строки из новой версии.',
	'FILES_MODIFIED'				=> 'Изменённые файлы',
	'FILES_MODIFIED_EXPLAIN'		=> 'Следующие файлы модифицированы и не соответствуют оригинальным файлам старой версии. Обновлённый файл будет результатом объединения вашего модифицированного и нового файла.',
	'FILES_NEW'						=> 'Новые файлы',
	'FILES_NEW_EXPLAIN'				=> 'Следующих файлов нет в вашей версии phpBB. Эти файлы будут добавлены.',
	'FILES_NEW_CONFLICT'			=> 'Новые конфликтующие файлы',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Следующие файлы появились лишь в последней версии. Но файл с таким же именем и в том же месте уже существует. Этот файл будет перезаписан файлом из новой версии.',
	'FILES_NOT_MODIFIED'			=> 'Неизменённые файлы',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Следующие файлы не были изменены и представляют собой оригинальные файлы phpBB той версии, которую вы хотите обновить.',
	'FILES_UP_TO_DATE'				=> 'Уже обновлённые файлы',
	'FILES_UP_TO_DATE_EXPLAIN'		=> 'Следующие файлы уже соответствуют файлам новой версии и не нуждаются в обновлении.',
	'FTP_SETTINGS'					=> 'Настройки FTP',
	'FTP_UPDATE_METHOD'				=> 'Закачать по FTP',

	'INCOMPATIBLE_UPDATE_FILES'		=> 'Найденные файлы обновления не подходят для установленной версии phpBB. Ваша версия — %1$s, а файл обновления предназначен для перехода с версии %2$s к версии %3$s.',
	'INCOMPLETE_UPDATE_FILES'		=> 'Неполный набор файлов обновления.',
	'INLINE_UPDATE_SUCCESSFUL'		=> 'Обновление базы данных успешно завершено. Теперь необходимо продолжить процесс обновления.',

	'KEEP_OLD_NAME'		=> 'Оставить прежнее имя',

	'LATEST_VERSION'		=> 'Последняя версия',
	'LINE'					=> 'Строка',
	'LINE_ADDED'			=> 'Добавлено',
	'LINE_MODIFIED'			=> 'Изменено',
	'LINE_REMOVED'			=> 'Удалено',
	'LINE_UNMODIFIED'		=> 'Не изменено',
	'LOGIN_UPDATE_EXPLAIN'	=> 'Для того, чтобы обновить версию phpBB, сперва необходимо войти на конференцию.',

	'MAPPING_FILE_STRUCTURE'	=> 'Для облегчения закачки файлов здесь указаны соответствия расположений файлов в архиве и в вашей версии phpBB.',

	'MERGE_MODIFICATIONS_OPTION'	=> 'Объединить изменения',

	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Не объединять — использовать новый файл',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'Не объединять — использовать имеющийся файл',
	'MERGE_MOD_FILE_OPTION'		=> 'Объединить изменения (удалить новый код в конфликтном месте)',
	'MERGE_NEW_FILE_OPTION'		=> 'Объединить изменения (удалить изменённый код в конфликтном месте)',
	'MERGE_SELECT_ERROR'		=> 'Неверно выбраны способы объединения конфликтного файла с новой версией.',
	'MERGING_FILES'				=> 'Объединение различий',
	'MERGING_FILES_EXPLAIN'		=> 'Сейчас производится окончательное изменение файлов.<br /><br />Дождитесь окончания всех операций по изменению файлов.',

	'NEW_FILE'						=> 'Конец конфликтного места',
	'NEW_USERNAME'					=> 'Новое имя',
	'NO_AUTH_UPDATE'				=> 'У вас нет прав на выполнение обновления phpBB',
	'NO_ERRORS'						=> 'Без ошибок',
	'NO_UPDATE_FILES'				=> 'Следующие файлы не будут обновлены',
	'NO_UPDATE_FILES_EXPLAIN'		=> 'Следующие файлы появились или были изменены в последней версии, но папка, в которой они должны находиться, не найдена в текущей версии phpBB. Присутствие в списке файлов, не относящихся к папке языков (language/) или стилей (styles/), может означать, что вы изменили структуру папок и обновление будет неполным.',
	'NO_UPDATE_FILES_OUTDATED'		=> 'Не найдена папка с обновлениями, убедитесь, что вы закачали соответствующие файлы.<br /><br />Ваша версия phpBB %1$s <strong>не</strong> самая последняя, для неё доступны обновления. Зайдите на страницу <a href="http://www.phpbb.com/downloads/" rel="external">http://www.phpbb.com/downloads/</a>, чтобы скачать нужный вам пакет обновления с версии %2$s до версии %3$s.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Ваша версия phpBB самая последняя. Нет необходимости запускать программу обновления. Если вы хотите провести проверку целостности файлов, удостоверьтесь, что закачали подходящие файлы обновления.',
	'NO_UPDATE_INFO'				=> 'Не найдены данные файла обновления.',
	'NO_UPDATES_REQUIRED'			=> 'Обновление не требуется',
	'NO_VISIBLE_CHANGES'			=> 'Нет видимых изменений',
	'NOTICE'						=> 'Уведомление',
	'NUM_CONFLICTS'					=> 'Число конфликтных мест',
	'NUMBER_OF_FILES_COLLECTED'	=> 'Проверены различия в %1$d файлах из %2$d.<br />Дождитесь полной проверки всех файлов.',

	'OLD_UPDATE_FILES'		=> 'Имеющиеся файлы обновления phpBB устарели. Они предназначены для обновления с версии %1$s до версии %2$s, но последняя версия phpBB — %3$s.',

	'PACKAGE_UPDATES_TO'				=> 'Текущий пакет обновляет до версии',
	'PERFORM_DATABASE_UPDATE'			=> 'Обновление базы данных',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Ниже вы найдёте кнопку обновления базы данных. Обновление может занять некоторое время, поэтому не прерывайте процесс его выполнения, если вам покажется, что он завис. После завершения следуйте инструкциям для продолжения процесса обновления.',
	'PREVIOUS_VERSION'					=> 'Предыдущая версия',
	'PROGRESS'							=> 'Ход выполнения',

	'RESULT'					=> 'Результат',
	'RUN_DATABASE_SCRIPT'		=> 'Обновить базу данных',

	'SELECT_DIFF_MODE'			=> 'Выберите режим diff',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Выберите формат архива для скачивания',
	'SELECT_FTP_SETTINGS'		=> 'Установка настроек FTP',
	'SHOW_DIFF_CONFLICT'		=> 'Различия/конфликтные места',
	'SHOW_DIFF_FINAL'			=> 'Итоговый файл',
	'SHOW_DIFF_MODIFIED'		=> 'Различия с объединённым файлом',
	'SHOW_DIFF_NEW'				=> 'Содержимое файла',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Различия в файлах',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Различия в файлах',
	'SOME_QUERIES_FAILED'		=> 'Выполнение некоторых запросов завершилось неудачей, тексты запросов и ошибок приведены ниже.',
	'SQL'						=> 'SQL-запрос',
	'SQL_FAILURE_EXPLAIN'		=> 'Скорее всего, волноваться не о чем, процесс обновления будет продолжен. Если он не будет завершён, то поищите справку на наших форумах поддержки. Для получения сведений о получении поддержки смотрите файл <a href="../docs/README.html">README</a>.',
	'STAGE_FILE_CHECK'			=> 'Проверка файлов',
	'STAGE_UPDATE_DB'			=> 'Обновление базы данных',
	'STAGE_UPDATE_FILES'		=> 'Обновление файлов',
	'STAGE_VERSION_CHECK'		=> 'Проверка версии',
	'STATUS_CONFLICT'			=> 'Изменённый файл, создающий конфликты',
	'STATUS_MODIFIED'			=> 'Изменённый файл',
	'STATUS_NEW'				=> 'Новый файл',
	'STATUS_NEW_CONFLICT'		=> 'Конфликтующий новый файл',
	'STATUS_NOT_MODIFIED'		=> 'Неизменённый файл',
	'STATUS_UP_TO_DATE'			=> 'Уже обновлённый файл',

	'TOGGLE_DISPLAY'			=> 'Показать/скрыть список файлов',
	'TRY_DOWNLOAD_METHOD'		=> 'Вы можете попробовать загрузить изменённые файлы.<br />Этот метод наиболее надёжен и является рекомендуемым способом обновления.',
	'TRY_DOWNLOAD_METHOD_BUTTON'=> 'Попробовать этот метод',

	'UPDATE_COMPLETED'				=> 'Обновление завершено',
	'UPDATE_DATABASE'				=> 'Обновить базу данных',
	'UPDATE_DATABASE_EXPLAIN'		=> 'На следующем этапе будут внесены необходимые изменения в базу данных.',
	'UPDATE_DATABASE_SCHEMA'		=> 'Обновление структуры базы данных',
	'UPDATE_FILES'					=> 'Обновить файлы',
	'UPDATE_FILES_NOTICE'			=> 'Убедитесь в том, что вы также обновили файлы конференции. Этот файл обновляет только базу данных.',
	'UPDATE_INSTALLATION'			=> 'Обновление версии phpBB',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Здесь вы можете обновить вашу версию phpBB до последней.<br />Во время этого процесса все ваши файлы будут проверены на целостность. Вы сможете просмотреть файлы и вносимые в них изменения перед обновлением.<br /><br />Само обновление может быть выполнено двумя способами.</p><h2>Обновление вручную</h2><p>Этот способ заключается в том, что вы скачиваете индивидуальный набор обновлённых файлов, чтобы не потерять сделанные вами изменения в имеющихся файлах. Скачав этот архив, вы должны вручную закачать файлы из него в соответствующие им местоположения относительно корневой папки phpBB. После этого вам будет дана возможность провести проверку, что все файлы занимают полагающиеся им места.</p><h2>Автоматическое обновление по FTP</h2><p>Этот способ похож на первый, но без необходимости скачивать обновлённые файлы и закачивать их на сервер самостоятельно, это будет сделано за вас. Чтобы воспользоваться этим способом, вам нужно знать запрашиваемые программой обновления данные о вашем FTP-сервере. По окончании вы будете направлены на повторное сравнение файлов с целью удостовериться, что обновление прошло успешно.<br /><br />',
	'UPDATE_INSTRUCTIONS'			=> '

		<h1>Объявление о выходе новой версии</h1>

		<p>Прежде чем продолжить процесс обновления, прочтите <a href="%1$s" title="%1$s"><strong>объявление о выпуске последней версии</strong></a>, оно может содержать полезную для вас информацию. Кроме того, в нём присутствуют ссылки на скачивание новой версии, обновлений, а также перечень изменений.</p>

		<br />

		<h1>Как обновить свою версию phpBB с помощью пакета автоматического обновления</h1>

		<p>Рекомендованный здесь способ обновления phpBB пригоден только для пакета автоматического обновления. Вы также можете произвести обновление, используя методы, указанные в документе INSTALL.html. Для автоматического обновления нужно выполнить следующие шаги:</p>

		<ul style="margin-left: 20px; font-size: 1.1em;">
			<li>Перейти на <a href="http://www.phpbb.com/downloads/" title="http://www.phpbb.com/downloads/">страницу файлов phpBB.com</a> и скачать архив с пакетом автоматического обновления («Automatic Update Package»).<br /><br /></li>
			<li>Распаковать архив.<br /><br /></li>
			<li>Закачать разархивированную папку install в корень phpBB (туда, где находится файл config.php).<br /><br /></li>
		</ul>

		<p>После этого конференция станет недоступна для обычных пользователей, из-за того, что теперь присутствует закачанная вами папка install.<br /><br />
		<strong><a href="%2$s" title="%2$s">Теперь вы можете начать процесс обновления, перейдя в папку install</a>.</strong><br />
		<br />
		Вам будут даны указания в ходе процесса обновления, а по его окончании вам сообщат об этом.
		</p>
	',
	'UPDATE_INSTRUCTIONS_INCOMPLETE'	=> '

		<h1>Незавершённое автоматическое обновление</h1>

		<p>Обнаружено, что предыдущее автоматическое обновление не было завершено. Убедитесь в том, что все шаги автоматического обновления были выполнены. Перейдите по ссылке ниже или непосредственно в папку установки.</p>
	',
	'UPDATE_METHOD'					=> 'Способ обновления',
	'UPDATE_METHOD_EXPLAIN'			=> 'Сейчас вы можете выбрать удобный для вас способ закачки файлов. Если вы предпочтёте закачку по FTP, вам будет предложено заполнить форму данных об учётной записи вашего FTP-сервера. Этот способ обеспечивает автоматическое перемещение файлов в новые местоположения и создание резервных копий их старых версий с добавлением .bak к имени файла. Если вы выберите скачивание архива с модифицированными файлами, то сможете распаковать его и закачать файлы в соответствующие им местоположения вручную.',
	'UPDATE_REQUIRES_FILE'			=> 'Для обновления необходимо наличие следующего файла: %s',
	'UPDATE_SUCCESS'				=> 'Обновление успешно завершено',
	'UPDATE_SUCCESS_EXPLAIN'		=> 'Все файлы успешно обновлены. Следующий шаг включает в себя повторную проверку соответствия файлов последней версии phpBB.',
	'UPDATE_VERSION_OPTIMIZE'		=> 'Обновление версии и оптимизация таблиц',
	'UPDATING_DATA'					=> 'Обновление данных',
	'UPDATING_TO_LATEST_STABLE'		=> 'Обновление базы данных до последней стабильной версии',
	'UPDATED_VERSION'				=> 'Обновлённая версия',
	'UPGRADE_INSTRUCTIONS'			=> 'Доступна новая версия: <strong>%1$s</strong>. Прочтите <a href="%2$s" title="%2$s"><strong>объявление о выходе новой версии</strong></a>, чтобы получить информацию о нововведениях и способах обновления.',
	'UPLOAD_METHOD'					=> 'Способ закачки',

	'UPDATE_DB_SUCCESS'				=> 'База данных успешно обновлена.',
	'USER_ACTIVE'					=> 'Активированный пользователь',
	'USER_INACTIVE'					=> 'Неактивированный пользователь',

	'VERSION_CHECK'					=> 'Проверка версии',
	'VERSION_CHECK_EXPLAIN'			=> 'Проверяет, что текущая версия phpBB самая последняя.',
	'VERSION_NOT_UP_TO_DATE'		=> 'Ваша версия phpBB не самая последняя. Продолжайте процесс обновления.',
	'VERSION_NOT_UP_TO_DATE_ACP'	=> 'Ваша версия phpBB не самая последняя.<br />Ниже вы найдёте ссылку на объявление о выпуске последней версии, которое содержит дополнительную информацию, а также инструкции по обновлению phpBB.',
	'VERSION_NOT_UP_TO_DATE_TITLE'	=> 'Ваша версия phpBB не самая последняя.',
	'VERSION_UP_TO_DATE'			=> 'Ваша версия phpBB самая последняя. На данный момент для неё нет обновлений. Тем не менее вы можете перейти к проверке файлов на соответствие последней версии.',
	'VERSION_UP_TO_DATE_ACP'		=> 'Ваша версия phpBB самая последняя. На данный момент для неё нет обновлений.',
	'VIEWING_FILE_CONTENTS'			=> 'Просмотр содержимого файла',
	'VIEWING_FILE_DIFF'				=> 'Просмотр различий в файлах',

	'WRONG_INFO_FILE_FORMAT'	=> 'Ошибочный формат файла сведений об обновлении',
));

// Default database schema entries…
$lang = array_merge($lang, array(
	'CONFIG_BOARD_EMAIL_SIG'		=> 'Спасибо, Администрация',
	'CONFIG_SITE_DESC'				=> 'Краткое описание вашей конференции',
	'CONFIG_SITENAME'				=> 'ваш_домен.ru',

	'DEFAULT_INSTALL_POST'			=> 'Это пример сообщения на вашей конференции phpBB3. Всё работает правильно. Вы можете удалить это сообщение и продолжить настройку вашей конференции. В процессе установки вашей первой категории и первому форуму были заданы подходящие права доступа для предустановленных групп администраторов, супермодераторов, гостей, зарегистрированных пользователей и зарегистрированных в соответствии с COPPA пользователей. Если вы решите удалить вашу первую категорию и первый форум, не забудьте установить права доступа для всех новых категорий и форумов, которые вы создаёте. Рекомендуем переименовать вашу первую категорию и первый форум и копировать права доступа с них вновь создаваемым категориям и форумам. Удачи!',

	'FORUMS_FIRST_CATEGORY'			=> 'Ваша первая категория',
	'FORUMS_TEST_FORUM_DESC'		=> 'Описание вашего первого форума.',
	'FORUMS_TEST_FORUM_TITLE'		=> 'Ваш первый форум',

	'RANKS_SITE_ADMIN_TITLE'		=> 'Администратор',
	'REPORT_WAREZ'					=> 'Сообщение содержит ссылки на незаконные или пиратские программы.',
	'REPORT_SPAM'					=> 'Сообщение имеет единственной целью рекламу сайтов, программ или других продуктов, товаров, услуг и пр.',
	'REPORT_OFF_TOPIC'				=> 'Сообщение не относится к обсуждаемой теме.',
	'REPORT_OTHER'					=> 'Причина обжалования не относится ни к одной из перечисленных, используйте поле дополнительной информации.',

	'SMILIES_ARROW'					=> 'Стрелка',
	'SMILIES_CONFUSED'				=> 'Озадачен',
	'SMILIES_COOL'					=> 'Всё путём',
	'SMILIES_CRYING'				=> 'Плачет или сильно расстроен',
	'SMILIES_EMARRASSED'			=> 'Смущён',
	'SMILIES_EVIL'					=> 'Злой или очень раздражён',
	'SMILIES_EXCLAMATION'			=> 'Восклицание',
	'SMILIES_GEEK'					=> 'Ботан',
	'SMILIES_IDEA'					=> 'Идея',
	'SMILIES_LAUGHING'				=> 'Смеётся',
	'SMILIES_MAD'					=> 'Раздражён',
	'SMILIES_MR_GREEN'				=> 'Зелёный',
	'SMILIES_NEUTRAL'				=> 'Нейтральный',
	'SMILIES_QUESTION'				=> 'Вопрос',
	'SMILIES_RAZZ'					=> 'Дразнится',
	'SMILIES_ROLLING_EYES'			=> 'Закатывает глаза',
	'SMILIES_SAD'					=> 'Грустный',
	'SMILIES_SHOCKED'				=> 'В шоке',
	'SMILIES_SMILE'					=> 'Улыбается',
	'SMILIES_SURPRISED'				=> 'Удивлён',
	'SMILIES_TWISTED_EVIL'			=> 'Очень зол',
	'SMILIES_UBER_GEEK'				=> 'Мегаботан',
	'SMILIES_VERY_HAPPY'			=> 'Очень доволен',
	'SMILIES_WINK'					=> 'Подмигивает',

	'TOPICS_TOPIC_TITLE'			=> 'Добро пожаловать в phpBB3',
));

?>