#!/usr/local/bin/php
<?php

/**
 * Invision Power Services
 * IP.Board v3.0.5
 * Main public executable wrapper.
 * Set-up and load module to run
 * Last Updated: $Date: 2009-02-04 20:03:59 +0000 (Wed, 04 Feb 2009) $
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		Invision Power Board
 * @link		http://www.invisionpower.com
 * @version		$Rev: 3887 $
 *
 */

define( 'IPS_IS_SHELL', TRUE );
define( 'IPB_THIS_SCRIPT', 'admin' );

if ( file_exists( './initdata.php' ) )
{
	require_once( './initdata.php' );
}
else
{
	require_once( '../initdata.php' );
}

require_once( IPS_ROOT_PATH . 'sources/base/ipsRegistry.php' );
require_once( IPS_ROOT_PATH . 'sources/base/ipsController.php' );

$reg = ipsRegistry::instance();
$reg->init();

$moo = new moo( $reg );

class moo
{
	function __construct( ipsRegistry $registry )
	{
		$this->registry   =  $registry;
		$this->DB         =  $this->registry->DB();
		$this->settings   =& $this->registry->fetchSettings();
		$this->request    =& $this->registry->fetchRequest();
		$this->cache      =  $this->registry->cache();
		$this->caches     =& $this->registry->cache()->fetchCaches();
		$this->stdin      =  fopen('php://stdin', 'r');
		
		$this->_print( "--------------------------------------------\nWelcome to the IP.Board Shell Get Stuff Ready For Release Tool\n--------------------------------------------\n" );
		$this->_print( "What do you wish to do? [l=Rebuild and Export Lang, s=Rebuild and Export Skins, a=Both]\nEnter: " );

		$option = $this->_fetchOption();

		switch( $option )
		{
			case 'l':
				$this->_doLang();
			break;
			case 's':
				$this->_doSkins();
			break;
			case 'a':
				$this->_doLang();
				$this->_doSkins();
			break;
			default:
				$this->_print( "\nIncorrect option" );
				exit();
			break;
		}
	}
	
	/**
	 * Rebuild langs
	 */
	private function _doSkins()
	{
		/* INIT */
		$start    = time();
		$messages = array();
		$errors   = array();
		
		/* Grab class */
		require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinFunctions.php' );
		require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinCaching.php' );
		require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinImportExport.php' );
		
		$this->skinFunctions = new skinImportExport( $this->registry );
		
		/* This is which skins we want to export for default installations */
		$skinIDs = array_values( $this->skinFunctions->remapData['export'] );
		
		//-----------------------------------------
		// Can do .. stuff?
		//-----------------------------------------
		
		if ( ! is_writable( DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins' ) )
		{
			$this->_print( 'Cannot write to /resources/skins' );
			exit();
		}
		
		//-----------------------------------------
		// Rebuild stuff
		//-----------------------------------------
		
		foreach( $skinIDs as $id )
		{
			$msg        = $this->skinFunctions->rebuildMasterCSS( $id );
			$messages[] = "<strong>CSS Rebuilt for $id</strong>";
			$messages   = array_merge( $messages, $msg, $this->skinFunctions->fetchMessages( TRUE ) );
			$errors     = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
			
			$msg        = $this->skinFunctions->rebuildMasterFromPHP( $id );
			$messages[] = "<strong>HTML Rebuilt for $id</strong>";
			$messages   = array_merge( $messages, $msg, $this->skinFunctions->fetchMessages( TRUE ) );
			$errors     = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
		}
		
		$this->skinFunctions->rebuildMasterReplacements();
		$messages[] = "<strong>Replacements Rebuilt</strong>";
		$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
		$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
		
		/* Got any errors? */
		if ( count( $errors ) )
		{
			$this->_print( 'ERROR: ' . implode( "\n *", $errors ) );
			exit();
		}
		
		$this->skinFunctions->rebuildTreeInformation();
		$this->skinFunctions->rebuildSkinSetsCache();
		
		//-----------------------------------------
		// Rebuild skin caches
		//-----------------------------------------
		
		foreach( $skinIDs as $id )
		{
			$setData = $this->skinFunctions->fetchSkinData( $id );
			
			$key = $setData['set_key'];
			
			if ( $id > 0 )
			{
				$this->skinFunctions->rebuildPHPTemplates( $id );
				$messages[] = "<strong>PHP Templates Recached for $key</strong>";
				$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
				$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
			
				$this->skinFunctions->rebuildCSS( $id );
				$messages[] = "<strong>CSS Recached for $key</strong>";
				$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
				$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
			}
		
			$this->skinFunctions->rebuildReplacementsCache( $id );
			$messages[] = "{$this->lang->words['to_replacerecached']} $key";
			$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
			$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
			
			/* Build and write XML files for replacements and CSS */
			$replacementsXML = $this->skinFunctions->generateReplacementsXML( $id, $_thisOnly );
			
			@unlink( DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/replacements_' . $key . '.xml', $replacementsXML );
			
			if ( ! @file_put_contents( DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/replacements_' . $key . '.xml', $replacementsXML ) )
			{
				$errors[] = "Cannot write: " . DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/replacements_' . $key . '.xml';
			}
			else
			{
				$messages[] = "Written: " . DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/replacements_' . $key . '.xml';
			}
			
			/* Export all CSS - Function loops through all skin sets */
			$this->skinFunctions->exportAllAppCSS( $id );
			$messages[] = "<strong>App CSS Written For $key</strong>";
			$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
			$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );

			/* Export all CSS - Function loops through all skin sets */
			$this->skinFunctions->exportAllAppTemplates( $id );
			$messages[] = "<strong>App XML Written For $key</strong>";
			$messages = array_merge( $messages, $this->skinFunctions->fetchMessages( TRUE ) );
			$errors   = array_merge( $errors  , $this->skinFunctions->fetchErrorMessages( TRUE ) );
			
			/* Got any errors? */
			if ( count( $errors ) )
			{
				$this->_print( 'ERROR: ' . implode( "\n *", $errors ) );
				exit();
			}
		}
		
		/* Generate skin sets XML */
		$skinSetXML = $this->skinFunctions->generateMasterSkinSetXML( $skinIDs );
		
		@unlink( DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/setsData.xml' );
		
		if ( ! @file_put_contents( DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/setsData.xml', $skinSetXML ) )
		{
			$errors[] = "Cannot write:: " . DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/setsData.xml';
		}
		else
		{
			$messages[] = "Written:  " . DOC_IPS_ROOT_PATH . PUBLIC_DIRECTORY . '/resources/skins/setsData.xml';
		}
		
		$this->_print( implode( "\n", $messages ) );
		
		$end = time();
		$tkn = ( $end - $start) / 60;
		
		$this->_print( "COMPLETE. Took " . $tkn . "m\n" );
	}
	
	/**
	 * Rebuild langs
	 */
	private function _doLang()
	{
		/* Grab class */
		require_once( IPS_ROOT_PATH . 'applications/core/modules_admin/languages/manage_languages.php' );
		$lang = new admin_core_languages_manage_languages( $this->registry );
		$lang->makeRegistryShortcuts( $this->registry );
		
		$start = time();
		
		foreach( ipsRegistry::$applications as $app => $app_data )
		{
			$this->_print("\nStarting App: " . $app_data['app_title'] );
			$_start = time();
			
			/* Stuff the post array */
			$_POST['apps'] = array( $app => $app );
			$msgs = $lang->importFromCacheFiles( FALSE );
			
			$_end = time();
			$_tkn = ( $_end - $_start) / 60;
			
			$this->_print( "\nDone. Took " . $_tkn . "m\n" . implode( "\n", $msgs ) );
		}
		
		$this->_print( "\nAll languages imported" );
		
		foreach( ipsRegistry::$applications as $app_dir => $app_data )
		{
			$this->_print("\Exporting XML for App: " . $app_data['app_title'] );
				
			$this->request['app_dir']	= $app_dir;
			
			$this->request['type']	= 'admin';
			$lang->languageExportToXML( 1, 1 );
			
			$this->request['type']	= 'public';
			$lang->languageExportToXML( 1, 1 );
		}
		
		$end = time();
		$tkn = ( $end - $start) / 60;
		
		$this->_print( "\COMPLETE. Took " . $tkn . "m\n" );
	}
	
	
	/**
	 * Out to stdout
	 */
	private function _print( $message, $newline="\n" )
	{
		$stdout = fopen('php://stdout', 'w');
		fwrite( $stdout, $message . $newline );
		fclose( $stdout );
	}
	
	/* Fetch option
	 *
	 */
	private function _fetchOption()
	{
		return trim( fgets( $this->stdin ) );
	}
}

exit();                 



?>