<!DOCTYPE html 
	     PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xml:lang="en" lang="en" xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
	<title>IP.Board 3.0 - Requirements Checker</title>
	<style type='text/css'>
		.pass {
			color: green;
			font-weight: bold;
		}
		
		.fail {
			color: red;
			font-weight: bold;
		}
		
		.what-you-should-do {
			color: grey;
			font-size: 12px;
			font-style: italic;
			padding-left: 15px;
		}
		
		h1 {
			border-bottom: 1px solid black;
		}
		
		p {
			margin: 2px;
			padding: 4px;
			border-bottom: 1px dotted grey;
			font-size: 15px;
			font-family: "Arial, Verdana";
		}
		
		p.final {
			border-bottom: 0px;
			padding-top: 20px;
		}
	
	</style>
	
</head>
<body>

	<h1>IP.Board 3.0 Requirements Checker</h1>

<?php

$extensions	= get_loaded_extensions();
$version	= phpversion();
$minVersion	= '5.2.1';

//-----------------------------------------
// Checking against required version
//-----------------------------------------

$checkRequiredVersion	= version_compare( $minVersion, $version, '<=' );
flushOutput( "Checking minimum version ({$minVersion})...", $checkRequiredVersion, "You must be running PHP v{$minVersion} or greater to use IP.Board 3.0.  You are currently running version {$version}.  Please ask your host to move you to a server running PHP v{$minVersion} or greater." );

//-----------------------------------------
// Checking for SPL
//-----------------------------------------

$splExists	= in_array( 'SPL', $extensions );
flushOutput( "Checking for SPL...", $splExists, "The PHP SPL extension is required for IP.Board 3.0.  Please ask your host to install the <a href='http://www.php.net/manual/en/spl.setup.php'>SPL library</a>." );

//-----------------------------------------
// Checking for DOM XML
//-----------------------------------------

$domXML	= in_array( 'dom', $extensions );
flushOutput( "Checking for DOM XML Handling...", $domXML, "The DOM XML Handling extension is required for IP.Board 3.0.  Please ask your host to install the <a href='http://www.php.net/manual/en/dom.setup.php'>libxml2 library</a>." );

//-----------------------------------------
// Check for GD2
//-----------------------------------------

$gd2	= in_array( 'gd', $extensions );
flushOutput( "Checking for GD library...", $gd2, "The GD2 library is required for IP.Board 3.0.  Please ask your host to install the <a href='http://us.php.net/manual/en/image.setup.php'>libgd library</a>." );

if( function_exists( 'gd_info' ) )
{
	$gdInfo	= gd_info();
	$fail	= true;
	
	if( $gdInfo["GD Version"] )
	{
		preg_match( "/.*?([\d\.]+).*?/", $gdInfo["GD Version"], $matches );
		
		if( $matches[1] )
		{
			$compareVersions	= version_compare( '2.0', $matches[1], '<=' );
			
			if( !$compareVersions )
			{
				$fail = false;
			}
		}
	}

	flushOutput( "Checking for GD2...", $fail, "While the GD library is installed, GD library version 2 is required for IP.Board 3.0.  The version reported (if at all) by your server is '{$gdInfo['GD Version']}'.  Please verify you are running GD version 2, and upgrade the <a href='http://us.php.net/manual/en/image.setup.php'>libgd library</a> if necessary." );
}

//-----------------------------------------
// Checking for mysql extension
//-----------------------------------------

$mysql	= in_array( 'mysql', $extensions );
$mysqli	= in_array( 'mysqli', $extensions );
flushOutput( "Checking for mysql support...", ( $mysql OR $mysqli ), "Your server does not appear to have a mysql library available.  If you are utilizing another database driver (such as MSSQL) you can ignore this message.  Otherwise, please ask your host to install the <a href='http://us.php.net/manual/en/mysqli.setup.php'>mysqli extension</a>." );

if( $mysql AND !$mysqli )
{
	flushOutput( "Checking for mysqli support...", false, "The mysqli extension is preferred over the original mysql extension.  If you are utilizing another database driver (such as MSSQL) you can ignore this message.  This is not a requirement, but if possible we recommend you to install the <a href='http://us.php.net/manual/en/mysqli.setup.php'>mysqli extension</a> for better performance." );
}


//-----------------------------------------
// Checking for JSON
//-----------------------------------------

$json	= in_array( 'json', $extensions );
flushOutput( "Checking for JSON...", $json, "While not required, the PHP JSON extension is recommended.  The JSON extensions provides for improved efficiency in handling some functionality in IP.Board.  If possible, we recommend you to install the <a href='http://us.php.net/manual/en/json.setup.php'>json extension</a>." );


//-----------------------------------------
// Flush output function
//-----------------------------------------

function flushOutput( $checking, $result, $errorText )
{
	print "<p>" . $checking;
	
	if( !$result )
	{
		print "<span class='fail'>FAIL</span><br /><span class='what-you-should-do'>{$errorText}</span>";
	}
	else
	{
		print "<span class='pass'>Pass</span>";
	}
	
	print "</p>";
	
	flush();
	ob_flush();
	
	return true;
}

?>

	<p class='final'>Please also remember that MySQL 4.1 or higher (MySQL 5.0 or higher preferred) is required for IP.Board 3.0.  Ask your server administrator to check the version of MySQL on your server if you are unsure.</p>
</body>
</html>