<?php

/**
 * Invision Power Services
 * IP.Board v3.0.5
 * Blog API file
 * Last Updated: $Date: 2009-02-04 15:03:59 -0500 (Wed, 04 Feb 2009) $
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		Invision Power Board
 * @subpackage	IP.Gallery
 * @link		http://www.invisionpower.com
 * @version		$Rev: 3887 $
 * @since		2.2.0
 *
 */

if ( ! class_exists( 'apiCore' ) )
{
	require_once( IPS_ROOT_PATH . 'api/api_core.php' );
}

class apiBlog extends apiCore
{
	/**
	 * Constructor.  Calls parent init() method
	 *
	 * @access	public
	 * @return	void
	 */
	public function __construct()
	{
		$this->init();
		
		if( ! ipsRegistry::isClassLoaded( 'blogFunctions' ) )
		{
			/* Load the Blog functions library */
			require_once( IPSLib::getAppDir( 'blog' ) . '/sources/classes/blogFunctions.php' );
			$this->registry->setClass( 'blogFunctions', new blogFunctions( $this->registry ) );
		}
	}
	
	/**
	* Retrieve the Blog ID of a member
	* THIS IS DEPRECATED - use fetchBlogIds
	*
	* @param	int		Member ID
	* @return 	int		Blog ID ( 0 if no Blog found )
	*/
	public function getBlogID( $member_id=0 )
	{
		$member_id = intval( $member_id );

		//-----------------------------------------
		// We entered here on member id, find blog_id and redirect them to here
		//-----------------------------------------
		$blog = $this->DB->buildAndFetch( array( 
												'select'	=> 'blog_id, blog_name',
												'from'		=> 'blog_blogs',
												'where'		=> "member_id={$member_id}" 
										)	);
		if( ! $blog['blog_id'] or ! $blog['blog_name'] )
		{
			return 0;
   		}
		else
		{
			return $blog['blog_id'];
		}
	}
	
	/**
	 * Retrieve blog IDs this member can author in
	 *
	 * @access	public
	 * @param	int		Member ID
	 * @return	array	array of ids with basic information, like: array( blog_id => array( 'blog_name', 'blog_seo_name' )
	 */
	public function fetchBlogIds( $member_id=0 )
	{
		$return    = array();
		$member_id = intval( $member_id );
		$data      = $this->registry->getClass('blogFunctions')->fetchMyBlogs( IPSMember::load( $member_id ) );
		
		if ( is_array( $data ) AND count( $data ) )
		{
			foreach( $data as $id => $blog )
			{
				if ( $blog['_canPostIn'] )
				{
					$return[ $id ] = $blog;
				}
			}
		}
		
		return $return;
	}
	
	/**
	* Retrieve the Blog ID of a member
	*
	* @param	int		Blog ID
	* @return 	string	Blog URL
	*/
	public function getBlogUrl( $blog_id=0 )
	{
		$blog_id = intval( $blog_id );

		//-----------------------------------------
		// We entered here on member id, find blog_id and redirect them to here
		//-----------------------------------------
		$blog = $this->DB->buildAndFetch( array ( 
												'select'	=> 'blog_id, blog_name, blog_seo_name',
												'from'		=> 'blog_blogs',
												'where'		=> "blog_id={$blog_id}" 
										)	);
		if( ! $blog['blog_id'] or ! $blog['blog_name'] )
		{
			return '';
   		}
		else
		{
			return $this->registry->output->buildSEOUrl( 'app=blog&amp;blogid=' . $blog_id, 'public', $blog['blog_seo_name'], 'showblog' );
		}
	}

	/**
	* Retrieve the last x entries of a Blog
	* Only public publishes entries are returned
	*
	* @param	string	Either 'member' or 'blog'
	* @param	int		Blog ID or Member ID
	* @param	int		Number of entries (to return)
	* @return 	array	Array of last X entries
	*/
	public function lastXEntries( $type, $id, $number_of_entries=10 )
	{
		/* INIT */
		$id           = intval( $id );
		$return_array = array();
		$extra 		  = "";
		$allowguests  = "";
		
        /* Build permissions */
		$this->registry->blogFunctions->buildPerms();

		/* Got permission to view blog entries? */
		if ( $this->memberData['g_blog_settings']['g_blog_allowview'] )
		{
			/* Private club? */
			if( ! $this->memberData['member_id'] )
			{
				$allowguests .= " AND b.blog_allowguests = 1";
			}
			
			if( ! $this->memberData['_blogmod']['moderate_can_view_private'] )
			{
				$extra = " AND ( ( ( b.blog_owner_only=1 AND b.member_id={$this->memberData['member_id']} ) OR b.blog_owner_only=0 ) AND ( b.blog_authorized_users LIKE '%,{$this->memberData['member_id']},%' OR b.blog_authorized_users IS NULL ) ) ";
			}
			
			$qtype = $type == 'member' ? "b.member_id={$id}" : "b.blog_id={$id}";

			$this->DB->build( array( 'select'	=> "e.*",
							         'from'		=> array('blog_entries' => 'e'),
							         'where'    => "{$qtype} AND b.blog_type='local' AND e.entry_status='published'".$allowguests.$extra,
									 'order'	=> 'e.entry_date DESC',
									 'limit'	=> array( 0, intval( $number_of_entries ) ),
						             'add_join' => array( array( 'select' => 'b.blog_name, b.blog_seo_name',
																'from'   => array( 'blog_blogs' => 'b' ),
																'where'  => "e.blog_id=b.blog_id",
																'type'   => 'left' ) ) ) );
							 
			$outer = $this->DB->execute();
			
			while( $entry = $this->DB->fetch($outer) )
			{
				$entry['blog_url']  = $this->registry->blogFunctions->getBlogUrl( $entry['blog_id'] );
				$entry['entry_url'] = $entry['blog_url'] . 'showentry='.$entry['entry_id'];
				
				$return_array[] = $entry;
			}
			return $return_array;
	  	}
		else
		{
			return array();
		}
	}

}

?>