<?php
/**
 * Invision Power Services
 * IP.Board v3.0.5
 * Hooks export skin file
 * Last Updated: $Date: 2009-03-29 22:18:15 -0400 (Sun, 29 Mar 2009) $
 *
 * @author 		$Author: rikki $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		Invision Power Board
 * @subpackage	Core
 * @link		http://www.invisionpower.com
 * @since		Friday 19th May 2006 17:33
 * @version		$Revision: 4343 $
 */
 
class cp_skin_hooks_export extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}


/**
 * Inline settings dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @return	string		HTML
 */
public function inline_settings( $hook, $form=array() )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__settings'] = {};
	acp.hooks.fields['MF__settings']['fields'] = $A(['setting_groups', 'settings']);
	acp.hooks.fields['MF__settings']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=settings&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__settings']['callback'] = function( t, json ){
		$('MF__settings').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__settings'), { pulses: 3 } );
	}
</script>

<div class='acp-box'>
	<h3>Добавление настроек</h3>
	<ul class='acp-form'>
		<li>
			Выберите одну или несколько групп настроек для экспорта. Все настройки этих групп будут полностью сохранены
		</li>
		<li style='padding-left: 15px'>
			{$form['groups']}
		</li>
		<li>
			Выберите индивидуальную настройку для экспорта. Все необходимые значения настройки будут сохранены
		</li>
		<li style='padding-left: 15px'>
			{$form['settings']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<input type='submit' value=' Сохранить ' class='realbutton' id='MF__settings_save' />
	</div>
</div>

EOF;

return $IPBHTML;
}

/**
 * Inline modules dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @return	string		HTML
 */
public function inline_modules( $hook, $form=array() )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__modules'] = {};
	acp.hooks.fields['MF__modules']['fields'] = $A(['modules']);
	acp.hooks.fields['MF__modules']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=modules&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__modules']['callback'] = function( t, json ){
		$('MF__modules').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__modules'), { pulses: 3 } );
	}
</script>

<div class='acp-box'>
	<h3>Добавление модулей</h3>
	<ul class='acp-form'>
		<li>
			Выберите один или несколько модулей для экспорта
		</li>
		<li style='padding-left: 15px'>
			{$form['modules']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<input type='submit' value=' Сохранить ' class='realbutton' id='MF__modules_save' />
	</div>
</div>

EOF;

return $IPBHTML;
}

/**
 * Inline custom script dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @return	string		HTML
 */
public function inline_custom( $hook, $form=array() )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__custom'] = {};
	acp.hooks.fields['MF__custom']['fields'] = $A(['custom']);
	acp.hooks.fields['MF__custom']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=custom&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__custom']['callback'] = function( t, json ){
		$('MF__custom').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__custom'), { pulses: 3 } );
	}
</script>

<div class='acp-box'>
	<h3>Добавление установочных скриптов</h3>
	<ul class='acp-form'>
		<li>
			Введите имя файла, содержащего скрипт установки/удаления. Файл должен иметь префикс "install_" в имени и находится в директории hooks/. Префикс перед именем файла вы можете не указывать
		</li>
		<li style='padding-left: 15px'>
			install_ {$form['custom']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<input type='submit' value=' Сохранить ' class='realbutton' id='MF__custom_save' />
	</div>
</div>
EOF;

return $IPBHTML;
}

/**
 * Inline help files dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @return	string		HTML
 */
public function inline_help( $hook, $form=array() )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__help'] = {};
	acp.hooks.fields['MF__help']['fields'] = $A(['help']);
	acp.hooks.fields['MF__help']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=help&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__help']['callback'] = function( t, json ){
		$('MF__help').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__help'), { pulses: 3 } );
	}
</script>

<div class='acp-box'>
	<h3>Добавление разделов помощи</h3>
	<ul class='acp-form'>
		<li>
			Выберите один или несколько разделов помощи для экспорта
		</li>
		<li style='padding-left: 15px'>
			{$form['help']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<input type='submit' value=' Сохранить ' class='realbutton' id='MF__help_save' />
	</div>
</div>
EOF;

return $IPBHTML;
}

/**
 * Inline tasks dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @return	string		HTML
 */
public function inline_tasks( $hook, $form=array() )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__tasks'] = {};
	acp.hooks.fields['MF__tasks']['fields'] = $A(['tasks']);
	acp.hooks.fields['MF__tasks']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=tasks&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__tasks']['callback'] = function( t, json ){
		$('MF__tasks').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__tasks'), { pulses: 3 } );
	}
</script>

<div class='acp-box'>
	<h3>Добавление задач</h3>
	<ul class='acp-form'>
		<li>
			Выберите одну или несколько задач для экспорта (не забудьте приложить PHP файлы задач к модификации)
		</li>
		<li style='padding-left: 15px'>
			{$form['tasks']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<input type='submit' value=' Сохранить ' class='realbutton' id='MF__tasks_save' />
	</div>
</div>

EOF;

return $IPBHTML;
}

/**
 * Inline language bits dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @param	int			Current index
 * @return	string		HTML
 */
public function inline_languages( $hook, $form=array(), $i=0 )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__language'] = {};
	acp.hooks.fields['MF__language']['fields'] = $A([]);
	acp.hooks.fields['MF__language']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=language&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__language']['callback'] = function( t, json ){
		$('MF__language').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__language'), { pulses: 3 } );
	}
	
	ipb.templates['lang_row'] = new Template("<li><table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width: 30%; vertical-align: top;'>#{control}<br /><span class='desctext langdesc' id='container_desc_#{containerid}' style='display: none'>Выберите языковые строки для добавления &rarr;</span></td><td style='vertical-align: top;'><div id='container_#{containerid}' style='display: none'></div></td></tr></table></li>");
	
	acp.hooks.languageMax = $i;
</script>
<style type='text/css'>
	.langdesc {
		font-size: 13px;
		padding: 5px;
	}
</style>

<div class='acp-box'>
	<h3>Добавление языковых конструкций</h3>
	<div style='max-height: 350px; overflow: auto'>
	<ul class='acp-form alternate_rows sep_rows' id='language_wrap'>
EOF;
	if( $i )
	{
		for( $k=1; $k<$i; $k++ )
		{
			$IPBHTML .= <<<EOF
			<li>
				<table width='100%' cellpadding='0' cellspacing='0'>
					<tr>
						<td style='width: 30%; vertical-align: top;'>
							{$form['language_file_' . $k ]}<br />
							<span class='desctext langdesc' id='container_desc_{$k}'>Выберите языковые строки для добавления &rarr;</span>
						</td>
						<td style='vertical-align: top;'>
							<div id='container_{$k}'>
								{$form['language_strings_' . $k ]}
								<script type='text/javascript'>
									acp.hooks.fields['MF__language']['fields'].push("language_{$k}");
									acp.hooks.fields['MF__language']['fields'].push("strings_{$k}");
								</script>
							</div>
						</td>
					</tr>
				</table>
			</li>
EOF;
		}
	}
	
	$IPBHTML .= <<<EOF
		<li>
			<table width='100%' cellpadding='0' cellspacing='0'>
				<tr>
					<td style='width: 30%; vertical-align: top;'>
						{$form['language_file_' . $i ]}<br />
						<span class='desctext langdesc' id='container_desc_{$i}' style='display: none'>Выберите языковые строки для добавления&rarr;</span>
					</td>
					<td style='vertical-align: top;'>
						<div id='container_{$i}' style='display: none'>
							{$form['language_strings_' . $i ]}
							<script type='text/javascript'>
								acp.hooks.fields['MF__language']['fields'].push("language_{$i}");
								acp.hooks.fields['MF__language']['fields'].push("strings_{$i}");
							</script>
						</div>
					</td>
				</tr>
			</table>
		</li>
	</ul>
	</div>
	<div class='acp-actionbar'>
		<input type='submit' value='Добавить еще' class='realbutton' id='addLanguage' /> <input type='submit' value=' Сохранить ' class='realbutton' id='MF__language_save' />
		<script type='text/javascript'>
			$('addLanguage').observe('click', acp.hooks.addAnotherLanguage);
		</script>
	</div>
</div>
EOF;

return $IPBHTML;
}

/**
 * Inline skin bits dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @param	int			Current index
 * @return	string		HTML
 */
public function inline_skins( $hook, $form=array(), $i=0 )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__templates'] = {};
	acp.hooks.fields['MF__templates']['fields'] = $A([]);
	acp.hooks.fields['MF__templates']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=skins&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__templates']['callback'] = function( t, json ){
		$('MF__templates').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__templates'), { pulses: 3 } );
	}
	
	ipb.templates['skin_row'] = new Template("<li><table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width: 35%; vertical-align: top;'>#{control}<br /><span class='desctext skindesc' id='s_container_desc_#{containerid}' style='display: none'>Выберите шаблоны для добавления &rarr;</span></td><td style='vertical-align: top;'><div id='s_container_#{containerid}' style='display: none'></div></td></tr></table></li>");
	
	acp.hooks.skinMax = $i;
</script>
<style type='text/css'>
	.skindesc {
		font-size: 13px;
		padding: 5px;
	}
</style>

<div class='acp-box'>
	<h3>Добавление шаблонов</h3>
	<div style='max-height: 350px; overflow: auto'>
	<ul class='acp-form alternate_rows sep_rows' id='skin_wrap'>
EOF;

if( $i )
{
	for( $k=1; $k<$i; $k++ )
	{
		$IPBHTML .= <<<EOF
		<li>
			<table width='100%' cellpadding='0' cellspacing='0'>
				<tr>
					<td style='width: 35%; vertical-align: top;'>
						{$form['skin_file_' . $k ]}<br />
						<span class='desctext skindesc' id='s_container_desc_{$k}'>Выберите шаблоны для добавления &rarr;</span>
					</td>
					<td style='vertical-align: top;'>
						<div id='s_container_{$k}'>
							{$form['skin_method_' . $k ]}
							<script type='text/javascript'>
								acp.hooks.fields['MF__templates']['fields'].push("templates_{$k}");
								acp.hooks.fields['MF__templates']['fields'].push("skin_{$k}");
							</script>
						</div>
					</td>
				</tr>
			</table>
		</li>
		
EOF;
	}
}
	$IPBHTML .= <<<EOF
		<li>
			<table width='100%' cellpadding='0' cellspacing='0'>
				<tr>
					<td style='width: 35%; vertical-align: top;'>
						{$form['skin_file_' . $i ]}<br />
						<span class='desctext skindesc' id='s_container_desc_{$i}' style='display: none'>Выберите шаблоны для добавления &rarr;</span>
					</td>
					<td style='vertical-align: top;'>
						<div id='s_container_{$i}' style='display: none'>
							{$form['language_strings_' . $i ]}
							<script type='text/javascript'>
								acp.hooks.fields['MF__templates']['fields'].push("templates_{$i}");
								acp.hooks.fields['MF__templates']['fields'].push("skin_{$i}");
							</script>
						</div>
					</td>
				</tr>
			</table>
		</li>
	</ul>
	</div>
	<div class='acp-actionbar'>
		<input type='submit' value='Добавить еще' class='realbutton' id='addTemplates' /> <input type='submit' value=' Сохранить
		 ' class='realbutton' id='MF__templates_save' />
		<script type='text/javascript'>
			$('addTemplates').observe('click', acp.hooks.addAnotherTemplate);
		</script>
	</div>
</div>
EOF;

return $IPBHTML;
}

/**
 * Inline database changes dhtml box
 *
 * @access	public
 * @param	array 		Hook data
 * @param	array 		Form elements
 * @param	int			Current index
 * @return	string		HTML
 */
public function inline_database( $hook, $form=array(), $i=0 )
{
$IPBHTML = "";
													
$IPBHTML .= <<<EOF
<script type='text/javascript'>
	acp.hooks.fields['MF__database'] = {};
	acp.hooks.fields['MF__database']['fields'] = $A([]);
	acp.hooks.fields['MF__database']['url']	 = "app=core&amp;module=ajax&amp;section=hooks&amp;do=save&amp;name=database&amp;id={$hook['hook_id']}";
	acp.hooks.fields['MF__database']['callback'] = function( t, json ){
		$('MF__database').innerHTML = json['message'];
		new Effect.Pulsate( $('MF__database'), { pulses: 3 } );
	}
	
	ipb.templates['db_row'] = new Template("<li><table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width: 35%; vertical-align: top;'><select name='type_#{id}' onchange='acp.hooks.generateFields(#{id});' id='type_#{id}' class='dropdown'><option value='0'>Выберите</option><option value='create'>Создать таблицу</option><option value='alter'>Изменить таблицу</option><option value='update'>Обновить данные</option><option value='insert'>Добавить данные</option></select><br /><span class='desctext dbdesc' id='d_container_desc_#{id}' style='display: none'>Выберите строчки для добавления &rarr;</span></td><td style='vertical-align: top;'><div id='d_container_#{id}' style='display: none' class='dbcontainer'></div></td></tr></table></li>");
	
	ipb.templates['db_create'] = new Template("Укажите имя таблицы (без префикса)<br /><input name='name_#{id}' id='name_#{id}' type='input' /><br /><br />Укажите индексы таблицы, так же как они идут в SQL запросе для создания таблицы<br /><textarea name='fields_#{id}' id='fields_#{id}'></textarea><br /><br />Укажите тип таблицы (напр-р, myisam или innodb)<br /><input name='tabletype_#{id}' id='tabletype_#{id}' type='input' />");
	
	ipb.templates['db_alter'] = new Template("Укажите тип изменения таблицы<br /><select name='altertype_#{id}' id='altertype_#{id}'><option value='add'>Добавление поля</option><option value='change'>Изменение поля</option><option value='remove'>Удаление поля</option></select><br /><br />Укажите имя таблицы (без префикса)<br /><input name='table_#{id}' id='table_#{id}' type='text' /><br /><br />Укажите имя поля<br /><input name='field_#{id}' id='field_#{id}' type='text'><br /><br />(Только для изменения поля) укажите новое имя поля<br /><input name='newfield_#{id}' id='newfield_#{id}' type='text'><br /><br />Укажите тип поля (напр-р, varchar(255))<br /><input name='fieldtype_#{id}' id='fieldtype_#{id}' type='text'><br /><br />Укажите значение по-умолчанию<br /><input name='default_#{id}' id='default_#{id}' type='text' />");
	
	ipb.templates['db_update'] = new Template("Укажите имя таблицы (без префикса)<br /><input name='table_#{id}' id='table_#{id}' type='text'><br /><br />Укажите имя поля<br /><input name='field_#{id}' id='field_#{id}' type='text'><br /><br />Укажите новое значение<br /><input name='newvalue_#{id}' id='newvalue_#{id}' type='text'><br /><br />Укажите старое значени (полезно для операции удаления модификации)<br /><input name='oldvalue_#{id}' id='oldvalue_#{id}' type='text'><br /><br />Укажите дополнительное значение для WHERE<br /><input name='where_#{id}' id='where_#{id}' type='text'>");
	
	ipb.templates['db_insert'] = new Template("Укажите имя таблицы (без префикса)<br /><input name='table_#{id}' id='table_#{id}' type='text' /><br /><br />Укажите данные для добавления в формате column=value, column=value<br /><textarea name='updates_#{id}' id='updates_#{id}'></textarea><br /><br />Укажите пару column=value для совпадения при удалении<br /><input name='fordelete_#{id}' id='fordelete_#{id}' type='text' />");
	
	acp.hooks.dbMax = $i;
</script>

<style type='text/css'>
	.dbdesc {
		font-size: 13px;
		padding: 5px;
	}
	
	.dbcontainer input,
	.dbcontainer select,
	.dbcontainer textarea {
		margin: 4px 0px 4px 10px;
	}
</style>


<div class='acp-box'>
	<h3>Добавление изменений БД</h3>
	<div style='max-height: 350px; overflow: auto'>
	<ul class='acp-form alternate_rows sep_rows' id='database_wrap'>
EOF;

if( $i )
{
	for( $k=1; $k<$i; $k++ )
	{	
		$IPBHTML .= <<<EOF
		<li>
			<table width='100%' cellpadding='0' cellspacing='0'>
				<tr>
					<td style='width: 35%; vertical-align: top;'>
						{$form['type_' . $k ]}<br />
						<span class='desctext dbdesc' id='d_container_desc_{$k}'>Укажите параметры &rarr;</span>
					</td>
					<td style='vertical-align: top;'>
						<div id='d_container_{$k}' class='dbcontainer'>
EOF;
						if( $form['field_1_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_1_' . $k ]}<br />
							{$form['field_1_' . $k ]}<br /><br />
EOF;
						}
						
						if( $form['field_2_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_2_' . $k ]}<br />
							{$form['field_2_' . $k ]}<br /><br />
EOF;
						}
						
						if( $form['field_3_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_3_' . $k ]}<br />
							{$form['field_3_' . $k ]}<br /><br />
EOF;
						}
						
						if( $form['field_4_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_4_' . $k ]}<br />
							{$form['field_4_' . $k ]}<br /><br />
EOF;
						}
						
						if( $form['field_5_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_5_' . $k ]}<br />
							{$form['field_5_' . $k ]}<br /><br />
EOF;
						}
						
						if( $form['field_6_' . $k ] )
						{
							$IPBHTML .= <<<EOF
							{$form['description_6_' . $k ]}<br />
							{$form['field_6_' . $k ]}<br /><br />
EOF;
						}
						
						$IPBHTML .= <<<EOF
							<script type='text/javascript'>
								 acp.hooks.fields['MF__database']['fields'].push( "type_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "name_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "fields_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "tabletype_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "altertype_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "table_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "field_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "newfield_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "fieldtype_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "default_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "where_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "newvalue_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "oldvalue_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "updates_{$k}" );
								 acp.hooks.fields['MF__database']['fields'].push( "fordelete_{$k}" );
								
								acp.hooks.dbMax = {$k};
							</script>
						</div>
					</td>
				</tr>
			</table>
		</li>
EOF;
	}
}
$IPBHTML .= <<<EOF
		<li>
			<table width='100%' cellpadding='0' cellspacing='0'>
				<tr>
					<td style='width: 35%; vertical-align: top;'>
						{$form['type_' . $i ]}<br />
						<span class='desctext dbdesc' id='d_container_desc_{$i}' style='display: none'>Укажите параметры &rarr;</span>
					</td>
					<td style='vertical-align: top;'>
						<div id='d_container_{$i}' style='display: none' class='dbcontainer'>
							{$form['language_strings_' . $i ]}
							<script type='text/javascript'>
								acp.hooks.fields['MF__database']['fields'].push("type_{$i}");
							</script>
						</div>
					</td>
				</tr>
			</table>
		</li>
	</ul>
	</div>
	<div class='acp-actionbar'>
		<input type='submit' value='Добавить еще' class='realbutton' id='addDB' /> <input type='submit' value=' Сохранить ' class='realbutton' id='MF__database_save' />
		<script type='text/javascript'>
			$('addDB').observe('click', acp.hooks.addAnotherDB);
		</script>
	</div>
</div>


EOF;

return $IPBHTML;
}

}