<?php

/**
 * Invision Power Services
 * IP.Board v3.0.5
 * Template Pluging: URL
 * Last Updated: $Date: 2009-09-21 16:09:44 -0400 (Mon, 21 Sep 2009) $
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		Invision Power Board
 * @link		http://www.invisionpower.com
 * @version		$Rev: 5134 $
 */

/**
* Main loader class
*/
class tp_url extends output implements interfaceTemplatePlugins
{
	
	/**
	 * Prevent our main destructor being called by this class
	 *
	 * @access	public
	 * @return	void
	 */
	public function __destruct()
	{
	}
	
	/**
	 * Run the plug-in
	 *
	 * @access	public
	 * @author	Matt Mecham
	 * @param	string	The initial data from the tag
	 * @param	array	Array of options
	 * @return	string	Processed HTML
	 */
	public function runPlugin( $data, $options )
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------

		$return              = '';
		$base                = str_replace( '"', '\\"', $options['base'] );
		$seotitle            = isset( $options['seotitle'] ) ? str_replace( '"', '\\"', $options['seotitle'] ) : '';
		$template            = isset( $options['template'] ) ? str_replace( '"', '\\"', $options['template'] ) : '';
		$options['httpauth'] = isset( $options['httpauth'] ) ? $options['httpauth'] : '';

		$return = '$this->registry->getClass(\'output\')->formatUrl( $this->registry->getClass(\'output\')->buildUrl( "' . $data . '", "' . $base . '",\'' . $options['httpauth'] . '\' ), "' . $seotitle . '", "' . $template . '" )';

		return '" . ' . $return . ' . "';		
	}
	
	/**
	 * Return information about this modifier
	 *
	 * It MUST contain an array  of available options in 'options'. If there are no allowed options, then use an empty array.
	 * Failure to keep this up to date will most likely break your template tag.
	 *
	 * @access	public
	 * @author	Matt Mecham
	 * @return	array
	 */
	public function getPluginInfo()
	{
		//-----------------------------------------
		// Return the data, it's that simple...
		//-----------------------------------------
		
		return array( 'name'    => 'url',
					  'author'  => 'IPS, Inc.',
					  'usage'   => '{parse url="this=that" base="public"}',
					  'options' => array( 'base', 'seotitle', 'template', 'httpauth' ) );
	}
}