<?php
/**
* @package Article Manager Factory
* @version 1.7.6
* @copyright www.thefactory.ro
* @license: commercial
*/
defined( '_JEXEC' ) or die( 'Restricted access' );
	
require_once(JPATH_SITE.DS.'components'.DS.'com_articleman'.DS.'class'.DS.'mainclass.php');

	class articleman_front extends articleman_ancestor {
        function articleman_engine() {
            //nothing
        }
        
        function validArticle(&$row,$resourcebox) {
			$database = &JFactory::getDBO();
			$error = array();

if(_ART_SET_content_style==0) {
			if($row->introtext=='' && _ART_SET_required_intro!="0" && _ART_SET_showintro=="1"){	$error[]=JText::_('AMAN_ERR_EMPTY_INTRO'); }
			if (_ART_SET_required_main=='1' && _ART_SET_showmain=="1" && $row->fulltext==''){ $error[]=JText::_('AMAN_ERR_EMPTY_TEXT');	}

} elseif (_ART_SET_content_style==1) {
			if($row->introtext.$row->fulltext=='' && _ART_SET_art_text_required=="1") $error[]=JText::_('AMAN_ERR_EMPTY_TEXT');
}
			
			if ($row->title=='') $error[] = JText::_('AMAN_ERR_EMPTY_TITLE');
			if ($row->sectionid<=0) $error[] = JText::_('AMAN_ERR_EMPTY_SECTION');
			if ($row->catid<=0) $error[] = JText::_('AMAN_ERR_EMPTY_CATEGORY');

			if ($row->catid && $row->sectionid){
				$database->setQuery("select count(*) from #__categories where section='$row->sectionid' and id='$row->catid'");
				if(!$database->loadResult()) $error[]=JText::_('AMAN_ERR_EMPTY_CATEGORY');
			}

			$stripped_string = strip_tags($row->introtext.$row->fulltext);
		
		if( ( _ART_SET_content_style ==0 && ( _ART_SET_required_intro + _ART_SET_required_main >= 1) ) || ( _ART_SET_content_style ==1 && ( _ART_SET_art_text_required >= 1) ) )
			if(trim(_ART_SET_limit_minim_chars)!="")
				if(strlen($stripped_string) < _ART_SET_limit_minim_chars) $error[] = JText::_('AMAN_ERR_TOO_LITLE_CHARS');
			
			if(trim(_ART_SET_limit_maxim_chars)!="")
				if(strlen($stripped_string) > _ART_SET_limit_maxim_chars) $error[] = JText::_('AMAN_ERR_TOO_MANY_CHARS');

			$match_array = preg_split('/href/i',$row->introtext.$row->fulltext);
			$nrLinks = count($match_array)-1;

			$match_array = preg_split('/<img/i',$row->introtext.$row->fulltext);
			$nrImages = count($match_array)-1;
			
			$match_array =preg_split("/href/i",$resourcebox);
			$nrLinks_res = count($match_array)-1;
            if(_ART_SET_nrlinks)
				if ($nrLinks > _ART_SET_nrlinks) $error[] = JText::_('AMAN_ERR_TOO_MANY_LINKS');
            if(_ART_SET_nrimages)
				if ($nrImages > _ART_SET_nrimages) $error[] = JText::_('AMAN_ERR_TOO_MANY_IMAGES');
			if (_ART_SET_nrlinks_resourcebox)
			     if ($nrLinks_res > _ART_SET_nrlinks_resourcebox) $error[] = JText::_('AMAN_ERR_TOO_MANY_LINKS_RESBOX');
			return implode(',',$error);
		}
		
		
		/**
		 * saveArticle
		 *  
		 * @modified: 16.05.2008 concats or not the maintext with the resourcebox text  ( _ART_SET_concat_resourcebox =1 ? concat; else not) 
		*/  	
        function saveArticle()
        {
            global $mainframe;
			
            $user 		= &JFactory::getUser(); 
            $acl 		= &JFactory::getACL();
			$database 	= &JFactory::getDBO(); 
			$my 		= &JFactory::getUser();
			$Itemid     = JRequest::getVar('Itemid');
			$option     = JRequest::getVar('option');
			$artACL 	= &articleACL::getInstance($database);
			$artRef		= new articleRef($database);
			
			$post_article = $this->processArticleFromPost();
			
			$row = & JTable::getInstance('content');
			$row->id=$post_article['id'];
			$isNew = $row->id < 1;

			/** start check category restrictions */
			require(JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php');
			if(isset($groupRestrictions[$my->gid])){
				if(in_array($post_article['categorie'],$groupRestrictions[$my->gid])){
					$mainframe->redirect(JROUTE::_('index.php?option='.$option),'You are not authorized to publish in the selected category!');
				}
			}
			/** end check category restrictions */
			
            if($isNew){
            	$row->created = date( 'Y-m-d H:i:s' ); $row->created_by = $user->id; $row->created_by_alias	= "";
				$row->images= ''; $row->urls= ''; $row->attribs= ''; $row->version= 1; $row->parentid= 0;
				$row->ordering	= 0;$row->access= 0; $row->hits= 0;

			}
			else{
            	if (!$this->isMyArticle($post_article["id"])) return;
				$row->load($post_article["id"]);
				$row->version++;
            }
            
            $row->title = $post_article["title"]; $row->title_alias=$post_article["title"];
            if(_ART_SET_allowalias)
            	$row->created_by_alias = $post_article['created_by_alias'];
            	
            $row->introtext = preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article['intro']);
            $row->fulltext = preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article['main']);
            $row->sectionid = $post_article['sectiune'];
            $row->catid	= $post_article['categorie'];

			$this->setArticleDates($row, $post_article["start_date"], $post_article["end_date"]);

            if (_ART_SET_allowmetdata){
            	$row->metakey=$post_article["metakey"];
            	$row->metadesc=$post_article["metadesc"];
            }
            
            
            //===> test if current user s group is allowed to publish directly
            $row->state = 0;
			$state = "pending";
			if($artACL->isAuthorizedPublisher()){
				$state = "normal"; $row->state = 1;
			}
			
            $row->check();
	        $err=$this->validArticle($row, $post_article["resourcebox"]);

            if($err){
		        $lists=array();
                $this->HTML_section_cat_pick($row->sectionid,$row->catid,$lists);
                $database->setQuery("select text from #__art_resourcebox where authorId='$user->id'");
                $lists['resourcebox']=$database->loadResult();
                $lists['errors']=$err;
                HTML_articleman::editArticle($row,$lists);
                return;
            }

			$this->atachResourceBox($row, $post_article["resourcebox"]);
			$row->store();
			$row->reorder("catid = " . (int) $row->catid);

			//  if set in config to publish on front
            if(_ART_SET_publish_on_frontpage == "1"){
    			
    			$database->setQuery("SELECT COUNT(*) FROM `#__content_frontpage` WHERE `content_id`='$row->id'");
    			
    			require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_frontpage'.DS.'tables'.DS.'frontpage.php');
				$fp = new TableFrontPage($database);
    			
				if(!$database->loadResult()){
	            	$fp->content_id = $row->id;
    			}
    			else{
    				$fp->load($row->id);
    			}

            	$fp->ordering = $isNew ? 1 : 0;
           		$fp->store();
    			$fp->reorder();
            }

            /* MISC Article Man Fields */
            $database->setQuery("select state from #__art_articles_ref where articleid='$row->id'");
            if($oldstate=$database->loadResult()){
				$database->setQuery("update #__art_articles_ref set state='{$state}' where articleid='$row->id'");
            }else{
				$database->setQuery("insert into #__art_articles_ref set articleid='$row->id',state='{$state}'");
            }
            $database->query();

            if(_ART_SET_ticketpreapproval)
	            $this->setArticleApprover($row, $post_article["approver"]);
            /* MISC Article Man Fields */
            
			$artRef->triggerMails($row, $oldstate,$state);

			
			if($state=="pending")
				$mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=listArticles&Itemid={$Itemid}") , JText::_('AMAN_ARTICLE_SAVED_AND_PENDING'), "message");
			elseif($state=="normal")
				$mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=listArticles&Itemid={$Itemid}") , JText::_('AMAN_ARTICLE_PUBLISHED'), "message");
            
        }//end saveArticle
		
        /**
		 * saveDraft
		 *  
		 * @modified: 16.05.2008 concats or not the maintext with the resourcebox text  ( _ART_SET_concat_resourcebox =1 ? concat; else not) 
		*/  	
        function saveDraft()
        {
            global $mainframe;
            
			$database = &JFactory::getDBO();
			$user = &JFactory::getUser();
			
			$Itemid  	= JRequest::getVar("Itemid");
			$option  	= JRequest::getVar("option");
			$id     	= JRequest::getVar("articleid");
			$title     	= stripslashes(JRequest::getVar("title"));
			$date      	= JRequest::getVar("date");
			$sectiune  	= JRequest::getVar("sectionid");
			$categorie 	= JRequest::getVar("catid");
			$metakey 	= JRequest::getVar("metakey");
			$metadesc 	= JRequest::getVar("metadesc");
			if(_ART_SET_content_style==0){
				$intro  = stripslashes(JArrayHelper::getValue($_REQUEST,"introtext", ""));
				$main   = stripslashes(JArrayHelper::getValue($_REQUEST,"maintext", ""));
			}elseif(_ART_SET_content_style == 1){
				$text 	= stripslashes(JArrayHelper::getValue($_REQUEST,"article_text", ""));
				$text	= str_replace('<br>', '<br />', $text);
				$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
				$tagPos	= preg_match($pattern, $text);
				if ($tagPos == 0) {
					$intro	= $text;
				} else {
					list($intro, $main) = preg_split($pattern, $text, 2);
				}
            }

			$resourcebox=JRequest::getVar('resourcebox');
            $resourcebox= strip_tags($resourcebox,'<br><a>');
    		$order   = array("\r\n", "\n", "\r");
            $replace = '<br />';
            // Processes \r\n's first so they aren't converted twice.
            $resourcebox = str_replace($order, $replace, $resourcebox);

			$row = & JTable::getInstance('content');
        	$row->id=$id;
        	$isNew = $row->id < 1;
        	
            if($isNew){
                $row->created 			= date( 'Y-m-d H:i:s' );
	          	$row->created_by 		= $user->id;
                $row->publish_up		= date( 'Y-m-d H:i:s' ,strtotime($date));
                $row->created_by_alias	= "";
                $row->publish_down		= $database->getNullDate();
                $row->images			= '';
                $row->urls				= '';
                $row->attribs			= '';
                $row->version			= 1;
                $row->parentid			= 0;
                $row->ordering			= 0;
                $row->access			= 0;
                $row->hits				= 0;

            }else{
                if (!$this->isMyArticle($id)) return;
                $row->load($id);
                $row->version++;
            }
            $row->title=$title;
            $row->title_alias=$title;
            
            // intro, maintext manipulation
if(_ART_SET_content_style==0){
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$order   = array("\r\n", "\n", "\r"); $replace = '<br />';
				$intro = str_replace($order, $replace, $intro);
				$intro = strip_tags($intro,'<br />');
			}
}elseif(_ART_SET_content_style == 1){
			if ((!_ART_SET_art_text_html)){
				$order   = array("\r\n", "\n", "\r"); $replace = '<br />';
				$intro   = str_replace($order, $replace, $intro);
				$intro	 = strip_tags($intro,'<br />');
				$main	 = str_replace($order, $replace, $main);
				$main	 = strip_tags($main,'<br />');
			}
}
			if(_ART_SET_allowed_tags){
			    $intro=strip_tags($intro,_ART_SET_allowed_tags);
			    $main=strip_tags($main,_ART_SET_allowed_tags);
			}

            $row->introtext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$intro);
            $row->fulltext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$main);

            $row->state=0;
            $row->sectionid=$sectiune;
            $row->catid=$categorie;

            $row->modified=date( 'Y-m-d H:i:s' );
            $row->modified_by=$my->id;
            $row->checked_out=0;
            $row->checked_out_time=$database->getNullDate();
            if (_ART_SET_allowmetdata){
				$row->metakey=$metakey;
				$row->metadesc=$metadesc;
            }

			$state = "draft";
            $row->check();

			// ==>  if set in config to concatante resource box text
            if(_ART_SET_concat_resourcebox == "1")
				$row->fulltext.="<br />".$resourcebox;
			// <==

            $row->store();
			$row->reorder("catid = " . (int) $row->catid);
			
            $database->setQuery("select state from #__art_articles_ref where articleid='$row->id'");
            if($oldstate=$database->loadResult()){
				$database->setQuery("update #__art_articles_ref set state='{$state}' where articleid='$row->id'");
            }else{
                $database->setQuery("insert into #__art_articles_ref set articleid='$row->id',state='{$state}'");
            }
			$database->query();
            $mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=listArticles&Itemid={$Itemid}") , JText::_('AMAN_ARTICLE_SAVED_AS_DRAFT'), "message");
        }
        
		function newArticle() {

			$user = &JFactory::getUser();
			$database = & JFactory::getDBO();

			$row = & JTable::getInstance('content');
		    $lists=array();
			
			$lists['sectionid'] = articleman_front_helper::generateSectionCategoryPicker($row);
            //$this->HTML_section_cat_pick($row->sectionid, $row->catid,$lists);

            $resourceBx = $this->_getResourceBox($user->id);
            if(isset($resourceBx->text))
            	$lists['resourcebox']=$resourceBx->text;
            else
            	$lists['resourcebox']="";
            if(isset($resourceBx->file))
            	$lists['resourcebox_file']=$resourceBx->file;
            else
            	$lists['resourcebox_file']="";
            	
			if(!isset($resourceBx->file_params))
				$lists['resourcebox_file_params']="left";
			else
				$lists['resourcebox_file_params']=$resourceBx->file_params;
			
			$defaultPublishingPeriod = (int) _ART_SET_default_publishing_period;
			$end_publish_date = mktime(0,0,0,date("m"),date("d")+$defaultPublishingPeriod,date("Y"));
			$row->publish_down = date("Y-m-d", $end_publish_date);

			if(_ART_SET_ticketpreapproval)
				$lists['users']=$this->getUsers("approver", null, NULL);

			HTML_articleman::editArticle($row,$lists);

		}
		
		function editArticle()
		{
			require(JPATH_COMPONENT_SITE.DS.'articleman.xajax.php');
			$adminXajax = new JArticlemanXajax;
			$xMethods =& $adminXajax->getXajaxMethods();
			
			$user = &JFactory::getUser();
		    $database = & JFactory::getDBO();
			$id = JRequest::getVar("id");
			$row=& JTable::getInstance("content");
			$art_ref = new articleRef($database);
			$artACL = &articleACL::getInstance($database);
			
			if (!$row->load($id)) 
			{
				echo JText::_('AMAN_ERR_ARTICLE_NOT_EXISTS');
				return;
			}
			$art_ref->load($row->id);
			
			if(!$artACL->isMyArticle($row->id))
			{
				JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
			    return ;
			}
			
			if(_ART_SET_usecheckin){
				if($row->checked_out>0){
					$tmpUser = &JTable::getInstance("user");
					$tmpUser->load($row->checked_out);
					$row->checked_out_username = $tmpUser->name;
					unset($tmpUser);
					if( $row->checked_out != $user->id ){
						$row->checked_out_info = JText::_('AMAN_CHECKED_OUT')." ".$row->checked_out_username." - ".$row->checked_out_time." !";
					}
				}
				
				$this->checkout($id);
			}
			
		    $lists=array();

            $lists['sectionid'] = articleman_front_helper::generateSectionCategoryPicker($row);
			//$this->HTML_section_cat_pick($row->sectionid, $row->catid,$lists);

            $lists['ref_state'] = $art_ref->state;

            // Select List: Category Ordering
			$query = 'SELECT ordering AS value, title AS text FROM #__content WHERE catid = '.(int) $row->catid.' AND state > ' .(int) "-1" . ' ORDER BY ordering';
			$lists['ordering'] = JHTML::_('list.specificordering', $row, $row->id, $query, 1);
			
			if(_ART_SET_ticketpreapproval)
				$lists['users']=$this->getUsers("approver", null, $art_ref->approver_id);

            HTML_articleman::editArticle($row,$lists);

		}
		
		/**
		 *  Test article permissions
		 * deprecated , use articleACL isMyArticle
		 *
		 * @param article id $id
		 * @return boolean
		 * @modified 16/12/2008 
		 */
		function isMyArticle($id) {
			$user = &JFactory::getUser();
		    $database = & JFactory::getDBO();
			// admin or allowed to approve?
			if ($user->usertype=="Super Administrator" || strpos(_ART_SET_allowed_to_aprouve_groups, $user->gid)!==false )
            	return true;
            else{
            //check if it's mine
			$query = "select count(*) from #__content where id='$id' and created_by='$user->id'";
			$database->setQuery($query);
			if (!$database->loadResult()) return false;
			else return true;
            }

		}
		
        function delArticle() {
            global $Itemid, $mainframe;
            
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
            
			$id  = JArrayHelper::getValue($_REQUEST,"id");
            if (!_ART_SET_canDelete) return;
            if ($this->isMyArticle($id))
				$this->deleteArticle($id);
            $mainframe->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
        }
        
        function unpublishArticle() {
            global $mainframe, $Itemid;
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
            
            if (!_ART_SET_canUnpublish) return;
			$id   = JArrayHelper::getValue($_REQUEST,"id");
			$article =& JTable::getInstance('content');
			$article->load($id);
			
            if ($this->isMyArticle($id) && $article->state==1){
            	$this->changeState(array($id),0,true);
            	$this->sendMail($article,'unpublish');
            }
			$mainframe->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
        }
        
        function publishArticle() {
            global $mainframe, $Itemid;
			
            $my = &JFactory::getUser();
			$database = &JFactory::getDBO();
			
			$id    = JArrayHelper::getValue($_REQUEST,"id");
			$article =& JTable::getInstance('content');
			$article->load($id);
            if ($this->isMyArticle($id) && $article->state==0) {
				//check if it is unpublished
				$database->setQuery("SELECT state from #__art_articles_ref WHERE articleid='$article->id'");
				$state=$database->loadResult();
				
				if (!$this->testUserAccess()) {
					if ($state)
						$database->setQuery("UPDATE #__art_articles_ref SET state='pending' WHERE articleid='$article->id'");
					else
						$database->setQuery("INSERT INTO #__art_articles_ref SET state='pending' , articleid='$article->id'");

                    $database->query();
                    if (_ART_SET_pendingAuthor=='1' && $oldstate!='pending'){
						$this->sendMail($article,'pendingAuthor');
                    }
                    if (_ART_SET_pendingAdmin=='1' && $oldstate!='pending'){
						$this->sendMail($article,'pendingAdmin',1);
					}
                } elseif($this->testUserAccess()) {
                	if ($state) {
						$database->setQuery("UPDATE #__art_articles_ref SET state='normal' WHERE articleid='$article->id'");
					} else {
						$database->setQuery("INSERT INTO #__art_articles_ref SET state='normal' , articleid='$article->id'");
					}
					$database->query();
					$database->setQuery("UPDATE #__content SET state='1' WHERE id='$article->id'");
					$database->query();
					$this->sendMail($article,'publish');
                }
            }
			$mainframe->redirect(JRoute::_(JURI::base().'index.php?option=com_articleman&task=articlesList&Itemid='.$Itemid));
        }
        
		function listArticles() {
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
			$jconfig = new JConfig;
			$session = &JFactory::getSession();
			$artACL = &articleACL::getInstance($database);

			$limit = $jconfig->list_limit;
			
			$sess_sort_field = $session->get("sort_field");
			$sess_sort_ord = $session->get("sort_ord");
			if($sess_sort_field=="") {
				$sess_sort_field = "modified";
				$sess_sort_ord = "DESC";
				$session->set("sort_field", $sess_sort_field);
				$session->set("sort_ord", "DESC");
				
			}	

			$limit 			  = ($session->get("limit")!="")?$session->get("limit"):$limit;
			
			$state_default = null;
			if($this->testUserAccess())
				$state_default = "1";
			$filter_state     = ($session->get("filter_state")!="")?$session->get("filter_state"):$state_default;
			$filter_catid  	  = $session->get("filter_catid");
			$filter_sectionid = $session->get("filter_sectionid");
			
			$searchString     = $session->get("searchString");
			// other Advanced search requests
			$users     		  = $session->get("users");
			$start_date   	  = $session->get("start_date");
			$end_date   	  = $session->get("end_date");
			$m_start_date     = $session->get("m_start_date");
			$m_end_date   	  = $session->get("m_end_date");
			
			
			$limitstart		  = JArrayHelper::getValue($_REQUEST,"limitstart", 0);
	        $limit 			  = JArrayHelper::getValue($_REQUEST,"limit",$limit);
		    $sortField 	  	  = JArrayHelper::getValue($_REQUEST,"sort");

			$reset  	  	  = JArrayHelper::getValue($_REQUEST,"reset","");
			if($reset==""){
				$filter_state 	  = JArrayHelper::getValue($_REQUEST,"filter_state", $filter_state);
				$filter_catid 	  = JArrayHelper::getValue($_REQUEST,"filter_catid", $filter_catid);
				$filter_sectionid = JArrayHelper::getValue($_REQUEST,"filter_sectionid", $filter_sectionid);
				
				$searchString 	  = JArrayHelper::getValue($_REQUEST,"searchstring",$searchString);
				// other Advanced search requests
				//$users	 	 	  = JArrayHelper::getValue($_REQUEST,"users",$users);
				$start_date	 	  = JArrayHelper::getValue($_REQUEST,"start_date",$start_date);
				$end_date 	 	  = JArrayHelper::getValue($_REQUEST,"end_date",$end_date);
				$m_start_date 	  = JArrayHelper::getValue($_REQUEST,"m_start_date",$m_start_date);
				$m_end_date  	  = JArrayHelper::getValue($_REQUEST,"m_end_date",$m_end_date);
			}else{
				$filter_state	  = "";
				$filter_catid	  = "";
				$filter_sectionid = "";
				$searchString	  = "";
				$start_date	 	  = "";
				$end_date 	 	  = "";
				$m_start_date 	  = "";
				$m_end_date  	  = "";
			}

			
			$filters = array();
			
			if($start_date!="")
				$filters[JText::_("AMAN_CREATION_DATE")] = JText::_("AMAN_FROM")." ".$start_date;
			if($end_date!="")
				if(isset($filters[JText::_("AMAN_CREATION_DATE")]))
					$filters[JText::_("AMAN_CREATION_DATE")] .= " ".JText::_("AMAN_TO")." ".$end_date;
				else 
					$filters[JText::_("AMAN_CREATION_DATE")] = JText::_("AMAN_TO")." ".$end_date;
				
			if($m_start_date!="")
				$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] = JText::_("AMAN_FROM")." ".$m_start_date;
			if($m_end_date!="")
				if(isset($filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')]))
					$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] .= " ".JText::_("AMAN_TO")." ".$m_end_date;
				else 
					$filters[JText::_('AMAN_ARTICLE_LAST_UPDATE')] = JText::_("AMAN_TO")." ".$m_end_date;
					
			HTML_articleman::showFilters($filters);
			
			if($sortField!="")
			{
				if( $sess_sort_field == $sortField )
				{
					$session->set("sort_field", $sortField);
					
					if($sess_sort_ord == "ASC")
					{
						$session->set("sort_ord", "DESC");
						$sess_sort_ord = "DESC";
					}
					else
					{ 
						$session->set("sort_ord", "ASC");
						$sess_sort_ord = "ASC";
					}
				}else{
					$session->set("sort_field", $sortField);
					$session->set("sort_ord", "ASC");
					$sess_sort_ord = "ASC";
				}
			}

			$order = " order by {$sess_sort_field} {$sess_sort_ord}";

			$session->set("limitstart", $limitstart);
			$session->set("limit", $limit);
			$session->set("filter_state", $filter_state);
			$session->set("filter_catid", $filter_catid);
			$session->set("filter_sectionid", $filter_sectionid);
			
			$session->set("searchString", $searchString);
			$session->set("users", $users);
			$session->set("start_date", $start_date);
			$session->set("end_date", $end_date);
			$session->set("m_start_date", $m_start_date);
			$session->set("m_end_date", $m_end_date);

			
			// all filters
			if($artACL->hasEditorAccess())
				$where=array();
			else
				$where=array("created_by='$user->id'");
    			
    		if ($searchString)
    		{
    			$where[]= " (a.title like '%$searchString%' or a.introtext like '%$searchString%' or a.fulltext like '%$searchString%')";
    		}
    		
        	if($start_date)
                $where[]= "a.created >= '".$start_date."'";
                
        	if($end_date)
                $where[]= "a.created <= '".$end_date."'";
    		
        	if($m_start_date)
                $where[]= "a.modified >= '".$m_start_date."'";
                
        	if($m_end_date)
                $where[]= "a.modified <= '".$m_end_date."'";
    		
        	if($filter_catid)
                $where[]= "a.catid='".(int)$filter_catid."'";
                
    		if($filter_sectionid)
                $where[]= "a.sectionid='".(int)$filter_sectionid."'";

    		switch ($filter_state)
    		{
    			case 1://pending
    				$where[]= "a.state=0 and (coalesce(b.state,'pending')='pending')";
    				break;
    			case 2://published
    				$where[]= "a.state=1";
    				break;
    			case 3://unpublished
    				$where[] = "a.state=0 and b.state='normal'";
    				break;
    			case 4://rejected
    				$where[] = "a.state=0 and b.state='rejected'";
    				break;
    			case 5://draft
    				$where[] = "a.state=0 and b.state='draft'";
    				break;
    		}


    		 $query_c= "select count(*)
    		          from  #__content AS a
    		          left join #__art_articles_ref as b on a.id = b.articleid "
    		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
            $database->setQuery($query_c);
            $total=$database->loadResult();

    		$query = "SELECT a.id AS id,a.sectionid,a.catid,a.created, 
    		           a.title,a.created_by,a.publish_up,
    		           a.modified,a.checked_out , us.name as checked_out_username ,a.checked_out_time, 
    		           a.state,b.state AS rstate, b.reason, 
    		           c.title AS categoryname,
    		           s.title AS sectionname,
    		           u.name AS username
    		          FROM  #__content AS a 
    		          LEFT JOIN #__art_articles_ref as b on a.id = b.articleid 
    		          LEFT JOIN #__categories as c on c.id = a.catid 
    		          LEFT JOIN #__sections as s on s.id = a.sectionid 
    		          LEFT JOIN #__users as u on u.id = a.created_by 
    		          LEFT JOIN #__users as us on us.id = a.checked_out 
    		          "
    		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
    		. $order;

            $database->setQuery($query,$limitstart, $limit);
            $rows=$database->loadObjectList();
            
			$lists['state'] = $this->HTML_Status_list($filter_state);
			$lists['catid'] = $this->HTML_cat_list($filter_sectionid,$filter_catid);
			$lists['sectionid'] = $this->HTML_section_list($filter_sectionid);
			$lists['searchString']=$searchString;


        	require_once( JPATH_LIBRARIES.DS.'joomla'.DS.'html'.DS.'pagination.php' );
        	$pageNav = new JPagination( $total, $limitstart, $limit );
        	
        	HTML_articleman::artList($rows,$pageNav,$lists);
		}
		
		/**
		 * delete AF ResourceBox Image
		 * 
		 * @version 1.7.0
		 */
		function deleteResourceBoxImage() {
			global $mainframe;
			jimport('joomla.filesystem.file');
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
			
			$database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
			$resbox=null;
			$resbox = $database->loadAssoc();
			
			$fileName = JPATH_BASE.DS."components".DS."com_articleman".DS."files".DS.$user->id.".".JFile::getExt($resbox["file"]);
			if(file_exists($fileName)) {
				JFile::delete($fileName);
				$database->setQuery("UPDATE #__art_resourcebox SET file = '' WHERE authorId='$user->id'");
				$database->query();
				$mainframe->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox") ,JText::_('AMAN_RESOURCEBOX_DELETED'));
			}
		}
		
		function resourceBox() {
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
			
			
			$database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
			$resbox=null;
			$resbox = $database->loadAssoc();

			HTML_articleman::resourceBoxForm($resbox);
		}
		
		function saveResourceBox() {
			global $Itemid, $mainframe;
			jimport('joomla.filesystem.file');
			
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
			
			if(is_uploaded_file($_FILES["profile_image"]["tmp_name"])) {
				if( strpos(_ART_SET_allowed_extensions , strtolower(JFile::getExt($_FILES["profile_image"]["name"])) ) !== false) {
					$fileName = JPATH_BASE.DS."components".DS."com_articleman".DS."files".DS.$user->id.".".JFile::getExt($_FILES["profile_image"]["name"]);
					if(JFile::upload($_FILES["profile_image"]["tmp_name"], $fileName)) {
						$size = $_FILES["profile_image"]["size"]/1024;
						// file too big!! return from here
						if($size>_ART_SET_max_size)
							$mainframe->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_ERR_IMAGE_TOO_BIG'));
						$file = $_FILES["profile_image"]["name"];
					}
				}else
					$mainframe->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_ERR_NOT_ALLOWED_EXTENSION'));
				
			}
			
			$text = JArrayHelper::getValue($_REQUEST, "resourcebox");
			$alignment = JArrayHelper::getValue($_REQUEST, "alignment");
			
			$file_sql = "";
			if($file!="")
				$file_sql = " , file='$file' ";

            //$text= strip_tags($text,'<a>');
			$ifExistRs = "select count(*) from #__art_resourcebox where authorId = $user->id";
			$database->setQuery($ifExistRs);
			if ($database->LoadResult()) {
				$database->setQuery( "update #__art_resourcebox set text='$text' {$file_sql} , file_params ='$alignment' where authorId = '$user->id'");
				$database->query();
    		} else {
				$database->setQuery( "insert into #__art_resourcebox set text='$text' {$file_sql}, file_params ='$alignment', authorId = '$user->id'");
				$database->query();
			}
 
			$mainframe->redirect(JRoute::_(JURI::base()."index.php?option=com_articleman&Itemid=$Itemid&task=rsBox"),JText::_('AMAN_RESOURCEBOX_SAVED'));
		}

		function previewArticle()
		{
			global $mainframe;
			$editor		= & JFactory::getEditor();
			$id			= JRequest::getVar('articleid');

			$document	=& JFactory::getDocument();
			$document->setLink(JURI::root());
	
			ob_clean();
			JHTML::_('behavior.caption');
	
			?>
			<script>
			var form = window.top.document.adminForm
			var title = form.title.value;

<?php if(_ART_SET_content_style==0) { ?>
			introtext = window.top.getIntroText();
			maintext = window.top.getMainText();
<?php } elseif (_ART_SET_content_style==1){ ?>
			introtext = '';
			maintext = window.top.getArticleText();
<?php } ?>
			alltext = introtext + "<br />" + maintext;
				
			</script>
			<?php
			$template= JURI::base() . 'templates' . "/" . $mainframe->getTemplate();
			
			echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
			echo "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-gb\" lang=\"en-gb\" ><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />";
			echo "<title><script>document.write(title);</script></title><link href='$template/css/template.css' rel='stylesheet' type='text/css'></head>";
			echo "<body><table class='contentpaneopen' width='100%'><tbody><tr><td class='contentheading' width='100%'><script>document.write(title);</script></td></tr></tbody></table>";
			echo "<table class='contentpaneopen' width='100%'><tbody><tr><td colspan='2' valign='top'>";
			echo "<script>document.write(alltext);</script></td></tr></tbody></table>";
			echo "</body></html>";
			exit;
			
		}
        function list_previewArticle() {
        	
			$database = &JFactory::getDBO();
            $id    	  = JRequest::getVar('articleid');
            $title 	  = urldecode(JRequest::getVar('title_encoded'));
			
			if(_ART_SET_content_style==0) {
				$intro  = JArrayHelper::getValue($_POST,'introtext');
				$main 	= JArrayHelper::getValue($_POST, 'maintext');
				$intro = stripcslashes($intro);
				$main = stripcslashes($main);
			} elseif(_ART_SET_content_style == 1) {
				$text 	= JArrayHelper::getValue($_POST,'maintext');
				$text	= str_replace('<br>', '<br />', $text);
				$text = stripcslashes($text);
				$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
				$tagPos	= preg_match($pattern, $text);
				if ($tagPos == 0) {
					$intro	= $text;
				} else {
					list($intro, $main) = preg_split($pattern, $text, 2);
				}
            }
            
            
            if ($id && !$this->isMyArticle($id)) {
            	JError::raiseError( 404, JText::_('ALERTNOTAUTH'));
                return;
            }
        	$this->previewArt($id,$title,$intro,$main);
        	
        }
        
		function search() {
			$user = &JFactory::getUser();
			$database = &JFactory::getDBO();
			$session = &JFactory::getSession();
			$users = array();
			$query = 'SELECT id AS value, name AS text'
			. ' FROM #__users'
			. ' WHERE block = 0'
			;
			$database->setQuery( $query );
			if ( isset($nouser) ) {
				$users[] = JHTML::_('select.option',  '0', '- '. JText::_( 'No User' ) .' -' );
				$users = array_merge( $users, $database->loadObjectList() );
			}else {
				$users = $database->loadObjectList();
			}
			$lists["users"] = JHTML::_('select.genericlist', $users, "users", 'class="inputbox" style="width:250px;" multiple="multiple" ', 'value', 'text' );
			
        	HTML_articleman::showSearchForm($lists);
        }
        
		/**
		 * Approve Article task
		 *
		 */
		function aprouveArticle(){
            global $mainframe;
            
			$user = &JFactory::getUser();
			$acl = & JFactory::getACL();
			$database = &JFactory::getDBO();
			$my = &JFactory::getUser();
			$Itemid     = JRequest::getVar("Itemid");
			$option     = JRequest::getVar("option");
			
			$post_article = $this->processArticleFromPost();

			$row = & JTable::getInstance('content');
			
			$row->id=$post_article["id"];
			$isNew = $row->id < 1;
			
            $row->load($id);
            $row->version++;
            $row->title=$post_article["title"]; $row->title_alias=$post_article["title"];
            $row->introtext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article["intro"]);
            $row->fulltext=preg_replace('/<script[^>]*?>.*?<\/script>/si','',$post_article["main"]);
            $row->sectionid = $post_article["sectiune"];
            $row->catid	=$post_article["categorie"];

            $row->state=1;
            
            $this->setArticleDates($row, $post_article["start_date"], $post_article["end_date"]);

            if (_ART_SET_allowmetdata){
            	$row->metakey=$post_article["metakey"];
            	$row->metadesc=$post_article["metadesc"];
            }
            
			$state = "normal";
            $row->check();
            
	        $err=$this->validArticle($row,$resourcebox);

            if($err){
		        $lists=array();
				$lists['sectionid'] = articleman_front_helper::generateSectionCategoryPicker($row);
                //$this->HTML_section_cat_pick($row->sectionid,$row->catid,$lists);
                $database->setQuery("select text from #__art_resourcebox where authorId='$user->id'");
                $lists['resourcebox']=$database->loadResult();
                $lists['errors']=$err;
                HTML_articleman::aprouveArticle($row,$lists);
                return;
            }

            $row->store();

			//  if set in config to publish on front
            if(_ART_SET_publish_on_frontpage == "1"){
    			$query = "INSERT INTO #__content_frontpage VALUES ( {$row->id}, 1 )";
    			$database->setQuery( $query );$database->query();
            }
            
	    	$database->setQuery("select state from #__art_articles_ref where articleid='$row->id'");
	        if($oldstate=$database->loadResult()){
				$database->setQuery("update #__art_articles_ref set state='{$new_state}' where articleid='$row->id'");
	        }else{
				$database->setQuery("insert into #__art_articles_ref set articleid='$row->id',state='{$new_state}'");
	        }
	        
            // New
			if(!isset($oldstate)){
				switch ($state){
					case "pending":
			        	if (_ART_SET_pendingAuthor=='1'){
			            	$this->sendMail($row,'pendingAuthor');
			            }
			        	if (_ART_SET_pendingAdmin=='1'){
			            	$this->sendMail($row,'pendingAdmin',1);
			        	}
					break;
					case "normal":
			        	if (_ART_SET_acceptAuthorEmail=='1'){
			            	$this->sendMail($row,'publish');
			            }
					break;
				}
			}else
				if($oldstate!="pending"){
		        	if (_ART_SET_pendingAuthor=='1'){
		            	$this->sendMail($row,'pendingAuthor');
		            }
		        	if (_ART_SET_pendingAdmin=='1'){
		            	$this->sendMail($row,'pendingAdmin',1);
		        	}
				}
				
            $mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&task=aprouve&Itemid={$Itemid}") , JText::_('AMAN_ARTICLE_PUBLISHED'), "message");
		}
		
        function reject_article() {
        	global $mainframe, $option, $Itemid;
        	
			if(!$this->testUserAccess()) {
				JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
				$mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&Itemid={$Itemid}"));
			}
	            
			$cid = JRequest::getVar('cid');
			if(is_array($cid)) $id = $cid[0];
			if(isset($cid[1])) $getnextpending = $cid[1];
			$reason=addslashes(JRequest::getVar('reason'));
	
		    if( $id ) {
				$msg = $this->rejectArticle($id,$reason);
				if($getnextpending) $mainframe->redirect("index.php?option=$option&task=aprouve&Itemid=$Itemid&id=$getnextpending",$msg);
				else $mainframe->redirect("index.php?option=$option",$msg);
		    }
        }
        
        function aprouve(){
        	global $mainframe, $option, $Itemid;
			$user = &JFactory::getUser();
		    $database = & JFactory::getDBO();
			$artACL 	= &articleACL::getInstance($database);
        	
		    $lists=array();
		    
			if(!$artACL->isUserApproverGroup() && !$artACL->userHasApprove()){
				JError::raiseWarning(0, JText::_("ALERTNOTAUTH") );
				$mainframe->redirect( JRoute::_( JURI::base()."index.php?option={$option}&Itemid={$Itemid}"));
			}
			
			$id=JRequest::getVar('id',"");
			if(!$id){
				if($artACL->isUserApproverGroup())
					$lists['cid'] = $this->getUnpublishedArticles();
				if($artACL->userHasApprove())
					$lists['cid'] = $this->getPreApprovalArticles();
				$id = $lists['cid'][0]->id;
			}
	        $lists['left_count'] = count($lists['cid']);
			$row=& JTABLE::getInstance("content");
			if (!$row->load($id)) {
				echo JText::_('AMAN_ERR_NO_MORE_ARTICLES'); return;
			}
			
			$user	= & JTable::getInstance("user");
			$user->load($row->created_by);
			
			$row->user = $user;
			$row->word_banned = $this->checkArticleForBannedWords($row);

            $lists['sectionid'] = articleman_front_helper::generateSectionCategoryPicker($row);
			//$this->HTML_section_cat_pick($row->sectionid, $row->catid,$lists);

			// Select List: Category Ordering
			$query = 'SELECT ordering AS value, title AS text FROM #__content WHERE catid = '.(int) $row->catid.' ORDER BY ordering';
			$lists['ordering'] = JHTML::_('list.specificordering', $row, $row->id, $query, 1);
			
            $database->setQuery("select * from #__art_resourcebox where authorId='$user->id'");
            $resourceBx = $database->loadObject();
            $lists['resourcebox']=$resourceBx->text;
            
			$this->GetRejectReasons($lists);
            $lists["word_count_intro"] = $this->word_count($row->introtext);
            $lists["word_count_full"] = $this->word_count($row->fulltext);
            $lists["char_count_intro"] = $this->countChars($row->introtext);
            $lists["char_count_full"] = $this->countChars($row->fulltext);
            
            $database->setQuery("select state from #__art_articles_ref where articleid='$id'");
            $lists['ref_state'] = $database->loadResult();
            
            HTML_articleman::aprouveArticle($row,$lists);
        }
	}
	
	class articleman_front_helper{
		
		function generateSectionCategoryPicker(& $row){

			static $xajax=null;
			if(!$xMethods){
				require_once(JPATH_COMPONENT_SITE.DS.'articleman.xajax.php');
				$xajax = new JArticlemanXajax;
				$xMethods =& $xajax->getXajaxMethods();
			}
			$database =& JFactory::getDBO();

			$aSections = array();
			$aSections[] = JHTML::_('select.option',0,'Select section...');
			$database->setQuery("SELECT `id` AS value,`title` AS text FROM `#__sections` ORDER BY `ordering`");
			$aSections = array_merge($aSections,$database->loadAssocList());

			$xMethods['retrievecategories']->setParameter(0,XAJAX_JS_VALUE,'document.getElementById(\'sectionid\').value');
			$xMethods['retrievecategories']->setParameter(1,XAJAX_QUOTED_VALUE,$row->catid);

			//trigger the xajax category request
			$document =& JFactory::getDocument();
			$js = 'window.addEvent(\'domready\', function() {'.$xMethods['retrievecategories']->getScript().'});';
			$document->addScriptDeclaration($js);
			

			return JHTML::_('select.genericlist',$aSections,'sectionid','onchange="'.$xMethods['retrievecategories']->getScript().'" ','value','text',$row->sectionid);
		}
		
	}
	
	
?>