<?php
/**
* @package Article Manager Factory
* @version 1.7.6
* @copyright www.thefactory.ro
* @license: commercial
*/

class articleRef extends JTable {
	var $articleid 		= null;
	var $state 	  		= null;
	var $reason 		= null;
	var $approver_id	= null;

	function __construct( &$db ) {
		parent::__construct( '#__art_articles_ref', 'articleid', $db );
	}
	
	function triggerMails(&$row,$oldstate,$state){
		
		if(!isset($oldstate)){
			switch ($state){
				case "pending":
		        	if (_ART_SET_pendingAuthor=='1'){
		            	articleman_ancestor::sendMail($row,'pendingAuthor');
		            }
		        	if (_ART_SET_pendingAdmin=='1'){
		            	articleman_ancestor::sendMail($row,'pendingAdmin',1);
		        	}
				break;
				case "normal":
		        	if (_ART_SET_acceptAuthorEmail=='1'){
		            	articleman_ancestor::sendMail($row,'publish');
		            }
				break;
			}
		}else
			if($oldstate!="pending"){
	        	if (_ART_SET_pendingAuthor=='1'){
	            	articleman_ancestor::sendMail($row,'pendingAuthor');
	            }
	        	if (_ART_SET_pendingAdmin=='1'){
	            	articleman_ancestor::sendMail($row,'pendingAdmin',1);
	        	}
			}
	}
	
}

class articleACL {
	var $_my = null;
	var $_db = null;
	
	function articleACL( &$db){
		$this->_db = $db;
		$my =&JFactory::getUser();
		if(isset($my))
			$this->_my = $my;
			
	}

    function &getInstance($db=null)
    {
        static $instance;

        if (!isset ($instance))
        {
            $database = &JFactory::getDBO();
            if (!$db) $db=$database;

            $instance=new articleACL($database);
        }
        return $instance;
    }
    
    function hasEditorAccess(){
    	$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);
		if( ( $this->_my->gid==25 || (_ART_SET_onesuperadminonly==1 && in_array($this->_my->gid,$aApprovingGroups)!==false ) ) ){
			return true;
	    }
	    return false;
    }
	
	function isUserSuperAdmin(){
		if ($this->_my->gid==25 ){
			return true;
		}
		return false;
	}
	
	function isAuthorizedPublisher(){
		$gid = $this->_my->gid;

		$aPublishingGroups = explode(',',_ART_SET_allowed_groups);
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);

		if(in_array($gid,$aPublishingGroups)!==false || (_ART_SET_onesuperadminonly==1 && in_array($gid,$aApprovingGroups)!==false)){
			return true;
		}
		return false;

	}
	
	function isUserApproverGroup(){
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);
		if(in_array($this->_my->gid,$aApprovingGroups)!==false){
			return true;
		}
		return false;
	}
	
	function userHasApprove(){
		$sql = "SELECT count(*) FROM #__art_articles_ref WHERE approver_id = '{$this->_my->id}' ";
		$this->_db->setQuery($sql);
		if (!$this->_db->loadResult()) return false;
		else return true;
	}
	
	function isMyArticle($id) {
		// admin or allowed to approve?
		$aApprovingGroups = explode(',',_ART_SET_allowed_to_aprouve_groups);
		if ($this->_my->gid==25 || (_ART_SET_onesuperadminonly==1 && in_array($this->_my->gid,$aApprovingGroups)!==false) )
			return true;
		else{
			//check if it's mine
			$query = "SELECT count(*) FROM #__content WHERE id='$id' AND created_by='{$this->_my->id}'";
			$this->_db->setQuery($query);
			if (!$this->_db->loadResult()) return false;
			else return true;
		}
	}
}

/**
 * Articleman Ancestral Class
 *
 */
class articleman_ancestor{
	
	function HTML_Status_list($filter, $draft_free = 0 ){
		$state[] = JHTML::_('select.option', '0', JText::_("AMAN_STATE") );
		$state[] = JHTML::_('select.option', '1', JText::_("AMAN_PENDING") );
		$state[] = JHTML::_('select.option', '2', JText::_("AMAN_PUBLISHED") );
		$state[] = JHTML::_('select.option', '3', JText::_("AMAN_UNPUBLISHED") );
		$state[] = JHTML::_('select.option', '4', JText::_("AMAN_REJECTED") );
		
		if($draft_free != "1"){
			$state[] = JHTML::_('select.option', '5', JText::_("AMAN_DRAFT") );
		}
		
		return  JHTML::_('select.genericList', $state, 'filter_state', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $filter );
	}
	
	function HTML_cat_list($filter_sectionid,$filter_catid ) {
		$database = &JFactory::getDBO();
		$user = &JFactory::getUser();
		$acl = & JFactory::getACL();
		
		$gid = $acl->get_group_id($user->usertype);
		
		$restrictedGroups = _ART_SET_restricted_group;
		$rgArray = explode(";", _ART_SET_restricted_group);
		
		$groupCount = "";
		foreach ($rgArray as $key => $group){
			if($gid == $group){$groupCount = $key;break;}
		}
		
    	$sectioncategories 			= array();
		$restrictedCategories = _ART_SET_restricted_categories;
		$rcArray = explode(";", $restrictedCategories);
		
    	$where = array();
		if($groupCount !== ""){
			$thisGroupRestrictedCategories = $rcArray[$groupCount];
			if($thisGroupRestrictedCategories!="")
				$where[] = " cc.id NOT IN (".$thisGroupRestrictedCategories.")";
		}
		
		if ($filter_sectionid)
			$where[]  = " cc.section = '" . (int) $filter_sectionid . "' ";
	
		$whereSql = "";
		if(count($where))
			$whereSql = "WHERE ".implode("AND",$where);
			
	   	$query = "SELECT cc.id AS value, cc.title AS text, section"
			. "\n FROM #__categories AS cc"
			. "\n INNER JOIN #__sections AS s ON s.id = cc.section "
			. $whereSql
			. "\n ORDER BY s.ordering, cc.ordering";
			
		$categories[] = JHTML::_('select.option', '0', JText::_("AMAN_SEL_CATEGORY"));
		$database->setQuery( $query );
		//echo $database->_sql;exit;
		$categories = array_merge( $categories, $database->loadObjectList() );
		return JHTML::_('select.genericList', $categories, 'filter_catid', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $filter_catid );
	}
        
	function HTML_section_list($filter ){
		$database =& JFactory::getDBO();
		$user = &JFactory::getUser();
		$acl = & JFactory::getACL();
		
		$javascript = 'class="inputbox" size="1" onchange="document.adminForm.submit();"';
			
		$gid = $acl->get_group_id($user->usertype);
		$where = "";
		
		$restrictedGroups = _ART_SET_restricted_group;
		$rgArray = explode(";", _ART_SET_restricted_group);
		
		$groupCount = "";
		foreach ($rgArray as $key => $group){
			if($gid == $group){$groupCount = $key;break;}
		}
		
		$restrictedSections = _ART_SET_restricted_sections;
		$rsArray = explode(";", $restrictedSections);
		
		if($groupCount !== ""){
			$thisGroupRestrictedSections = $rsArray[$groupCount];
			if( strlen($thisGroupRestrictedSections)>0 ){
				$where = " AND id NOT IN (".$thisGroupRestrictedSections.") ";
			}
		}
		$categories[] = JHTML::_('select.option',  '0', JText::_("AMAN_SEL_SECTION") );
		$query = 'SELECT id AS value, title AS text'
		. ' FROM #__sections'
		. ' WHERE published = 1'
		. $where
		. ' ORDER BY ordering '
		;
		$database->setQuery( $query );
		//echo $database->_sql;exit;
		$sections = array_merge( $categories, $database->loadObjectList() );
	
		return JHTML::_('select.genericlist',  $sections, 'filter_sectionid', 'class="inputbox" size="1" '. $javascript, 'value', 'text', $filter );
	}

    function HTML_section_cat_pick($_section,$_cat,&$lists ){

    	$database = &JFactory::getDBO();
    	$acl =& JFactory::getACL(); 
    	$user = & JFactory::getUser();
    	
	    $javascript = "onchange=\"changeDynaList( 'catid', sectioncategories, document.adminForm.sectionid.options[document.adminForm.sectionid.selectedIndex].value, 0, 0);\"";
		
		$gid = $acl->get_group_id($user->usertype);
		$where = "";
		
		$restrictedGroups = _ART_SET_restricted_group;
		$rgArray = explode(";", _ART_SET_restricted_group);
		
		$groupCount = "";
		foreach ($rgArray as $key => $group){
			if($gid == $group){$groupCount = $key;break;}
		}
		
		$restrictedSections = _ART_SET_restricted_sections;
		$rsArray = explode(";", $restrictedSections);
		
		
		if($groupCount !== ""){
			$thisGroupRestrictedSections = $rsArray[$groupCount];
			if( strlen($thisGroupRestrictedSections)>0 ){
				$where = "AND s.id NOT IN (".$thisGroupRestrictedSections.")";
			}
		}
		
    	$query = "SELECT s.id, s.title"
    	. "\n FROM #__sections AS s"
    	. "\n WHERE 1 {$where} "
    	. "\n ORDER BY s.ordering";
    	$database->setQuery( $query );
   		$sections = $database->loadObjectList();
   		$lists['sectionid'] = JHTML::_('select.genericList', $sections, 'sectionid', 'class="inputbox" size="1" '. $javascript, 'id', 'title', intval( $_section ) );

    	$sectioncategories 			= array();
		$restrictedCategories = _ART_SET_restricted_categories;
		$rcArray = explode(";", $restrictedCategories);
		

    	$where = "";
		if($groupCount !== ""){
			$thisGroupRestrictedCategories = $rcArray[$groupCount];
			if($thisGroupRestrictedCategories!="")
			$where = "AND id NOT IN (".$thisGroupRestrictedCategories.")";
		}
    	$query = "SELECT id, title, section"
    	. "\n FROM #__categories"
    	. "\n WHERE 1 {$where} "
    	. "\n ORDER BY ordering"
    	;
    	$database->setQuery( $query );
    	$cat_list = $database->loadObjectList();

    	foreach($sections as $section1) {
    		$sectioncategories[$section1->id] = array();
    		$rows2 = array();
    		foreach($cat_list as $cat) {
    			if ($cat->section == $section1->id) {
    				$rows2[] = $cat;
    			}
    		}
    		foreach($rows2 as $row2) {
    			$sectioncategories[$section1->id][] = JHTML::_('select.option', $row2->id, $row2->title, 'id', 'name' );
    		}
    	}
        $lists['sectioncategories']=$sectioncategories;
		$categoriesA = array();

		if ( $_section == 0 ) {
			//$where = "\n WHERE section NOT LIKE '%com_%'";
			foreach($cat_list as $cat) {
				$categoriesA[] = $cat;
			}
		} else {
			//$where = "\n WHERE section = '$sectionid'";
			foreach($cat_list as $cat) {
				if ($cat->section == $_section) {$categoriesA[] = $cat;}
			}
		}

		$lists['catid'] = JHTML::_('select.genericlist', $categoriesA, 'catid', 'class="inputbox" size="1"', 'id', 'title', intval( $_cat ) );

	}
        
	function GetArticleState($id,&$lists){
		$database = &JFactory::getDBO();
		
		$database->setQuery("select * from #__art_articles_ref where articleid='$id'");
		$cur_state=null;
		$cur_state = $database->loadAssoc();

		$state=null;
		$database->setQuery("select state from #__content where id='$id'");
		$state = $database->loadAssoc();
		if(count($state)>0)
			$state = $state["state"];
		
		if ($cur_state["state"]=='rejected'){
			$lists['state']=JText::_('AMAN_REJECTED');
		    $lists['reason']=$cur_state["reason"];
		}elseif ($cur_state["state"]=='pending'){
		    $lists['state']=JText::_('AMAN_PENDING');
		    $chkfrontpage="checked";
		}elseif ($state=='1')
		   $lists['state']=JText::_('AMAN_PUBLISHED');
		else $lists['state']=JText::_('AMAN_UNPUBLISHED');
		return $lists['state'];
    }
        
    function GetRejectReasons(&$lists)
    {
		$database = &JFactory::getDBO();
		
		$database->setQuery("select * from #__art_reason order by title");
		$lists['reasons']=$database->loadObjectList();
		$reason_select[]=JHTML::_('select.option', '-1', ' - '.JText::_('AMAN_ARTICLE_CHOOSE_REASON').' - ', 'id', 'title' );
		$lists['reasonlist']=JHTML::_('select.genericList', array_merge($reason_select, $lists['reasons']), 'reason_list', 'class="inputbox" size="1" style="width:400px;" onchange="putReason(this)"', 'id', 'title', -1 );
    }
        
    function deleteArticle($id)
    {
		$database = &JFactory::getDBO();
		
		$query = "delete from #__content where id='$id'";
		$database->setQuery($query);
		$database->query();
		
		$query = "delete from #__art_articles_ref where articleid = '$id'";
		$database->setQuery($query);
		$database->query();
    }

	function changeState($chb,$publish,$nomessage=null)
	{
		$database = &JFactory::getDBO();
	
	
		for ($i=0;$i<count($chb);$i++)
		{
		    $cb=$chb[$i];
	
		    $articol = & JTable::getInstance('content');
		    if (!$articol->load($cb)) continue;
	
		    $articol->state=$publish;
		    $articol->store();
	
	        $database->setQuery("select count(*) from #__art_articles_ref where articleid='$id'");
	        if($database->loadResult()){
	  			$database->setQuery("update `#__art_articles_ref` set state='normal' where articleid='$cb' ");
	        }else{
	  			$database->setQuery("insert into `#__art_articles_ref` set state='normal' , articleid='$cb' ");
	         }
				$database->query();
	
				if (!$nomessage){
				   $msgtype=($publish)?"publish":"unpublish";
				   if (($publish && _ART_SET_acceptAuthorEmail)||(!$publish && _ART_SET_unpublishEmail))
				       $this->sendMail($articol,$msgtype);
			}
		}
	}
    	
	function rejectArticle($id,$reason){
		$database = &JFactory::getDBO();
		
		$content = & JTable::getInstance('content');
		
		$msg='';
		if (!$content->load($id)){
		    $msg=JText::_('AMAN_ERR_ARTICLE_NOT_EXISTS');
		}else{
		    $database->setQuery("select count(*) from #__art_articles_ref where articleid='$id'");
		    if($database->loadResult()){
		        $database->setQuery("update #__art_articles_ref set state='rejected',reason='$reason' where articleid='$id'");
		
		    }else{
		        $database->setQuery("insert into  #__art_articles_ref set  state='rejected',reason='$reason', articleid='$id'");
		     }
		    $database->query();
		    $database->setQuery("update #__content set state=0 where id='$id'");$database->query();
			$database->setQuery("delete from #__content_frontpage where content_id='$id'");$database->query();
			
		    $msg=JText::_('AMAN_ERR_ARTICLE_REJECTED');
		
			$content->reason=stripslashes($reason);
		    if(_ART_SET_rejectAuthorEmail)	$this->sendMail($content,'reject');
		}
		return $msg;
	}
    	
	function sendMail(&$article,$mailtype,$admin=null)
	{
		global $mainframe;
		$database = &JFactory::getDBO();
		
		$database->setQuery("select id,subject,template from `#__art_emailtmpl` where `type`='$mailtype'");
		$template=null;
		$template = $database->loadAssoc();
		
		$subject=$template["subject"];
		$body=$template["template"];
		$user	= & JTable::getInstance("user");
		$user->load($article->created_by);
		$link=JURI::root().'/index.php?option=com_content&task=view&id='.$article->id;
		$subject=str_replace('%name%',$user->name,$subject);
		$subject=str_replace('%username%',$user->username,$subject);
		$subject=str_replace('%date%',date( 'Y-m-d H:i:s' , $article->created ),$subject);
		$subject=str_replace('%url%',$link,$subject);
		$subject=str_replace('%title%',$article->title,$subject);
		$subject=str_replace('%reason%',$article->reason,$subject);
		
		$body=str_replace('%name%',$user->name,$body);
		$body=str_replace('%username%',$user->username,$body);
		$body=str_replace('%date%',date( 'Y-m-d H:i:s' , strtotime($article->created) ),$body);
		$body=str_replace('%url%',$link,$body);
		$body=str_replace('%title%',$article->title,$body);
		$body=str_replace('%reason%',$article->reason,$body);
		
		$email=$user->email;
		if ($admin){
			$email=$mainframe->getCfg('mailfrom');
		}
		
		$from_name  = _ART_SET_mail_from_name!=""?_ART_SET_mail_from_name:$mainframe->getCfg('sitename');
		$from_email = _ART_SET_mail_from_email!=""?_ART_SET_mail_from_email:$mainframe->getCfg('mailfrom');
		
		JUtility::sendMail($from_email, $from_name, $email, $subject, $body);
	}
    	
	function previewArt($id,$title=null,$intro=null,$main=null)
	{
		global $mainframe;
		
		ob_clean();
		$article = & JTable::getInstance('content');
		if($intro=="" && $main==""){
		    if($id){
				if (!$article->load($id)){ echo JText::_('AMAN_ERR_ARTICLE_NOT_EXISTS');exit();}
		    }
		    
		    if(!isset($title) || $title == null) $title = $article->title;
			if(!isset($intro) || $intro == null) $intro = $article->introtext;
		    if(!isset($main) || $main == null) $main = $article->fulltext;
				
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$order   = array("\r\n", "\n", "\r");
				$replace = '<br />';
		        $intro=str_replace($order, $replace, $intro);
			    $intro=strip_tags($intro,'<br>');
			}
			
			if(_ART_SET_allowed_tags){
				$intro=strip_tags($intro,_ART_SET_allowed_tags);
				$main=strip_tags($main,_ART_SET_allowed_tags);
			}
			
			$intro = $article->introtext;
			$main  = $article->fulltext;
		}
		$template= JURI::base() . 'templates' . "/" . $mainframe->getTemplate();
		
		echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-gb\" lang=\"en-gb\" ><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" /><title>$title</title><link href='$template/css/template.css' rel='stylesheet' type='text/css'></head>";
		echo "<body><table class='contentpaneopen' width='100%'><tbody><tr><td class='contentheading' width='100%'>$title</td></tr></tbody></table>";
		echo "<table class='contentpaneopen' width='100%'><tbody><tr><td colspan='2' valign='top'>$intro<br>$main</td></tr></tbody></table>";
		echo "</body></html>";
		exit;
	}

	function checkArticleForBannedWords($row){
		$text = strtolower(strip_tags($row->title." ".$row->introtext." ".$row->fulltext));
		$text = str_replace("-", " ", $text);
		$search   = array("\r\n", "\n", "\r"); $replace = ' ';
        $text = str_replace($search, $replace, $text);
		
        $found = array();
		$wordList = explode(",",_ART_SET_alert_words);
		
		foreach ($wordList as $wordKey => $wordValue){
			$patern = trim($wordValue);
			$patern = "\s".str_replace(" ", "(\s)*",$patern)."\s";
			$patern = '/'.$patern.'/';
			preg_match($patern,$text,$matches);
			if(count($matches)>0) $found[] = $wordValue;
    	}
    	if(count($found)>0) return $found;
    	else return false;
    }
    
    /**
     * Bind, strip, etc, posted article 
     *
     * @return article
     * @version 1.7.0
     */
    function processArticleFromPost(){
    	$article = array();
		
    	$article["id"] 			= JRequest::getVar("articleid");
		$article["title"]    	= stripslashes(JRequest::getVar("title"));
		if(_ART_SET_allowalias)
			$article["created_by_alias"]    	= stripslashes(JRequest::getVar("created_by_alias"));
		
		$article["start_date"]  = JRequest::getVar('date').' '.JRequest::getVar('date_hours','00').':'.JRequest::getVar('date_minutes','00').':00';
		$article["end_date"]  	= JRequest::getVar('end_date','00').' '.JRequest::getVar('end_date_hours','00').':'.JRequest::getVar('end_date_minutes','00').':00';
		$article["sectiune"] 	= JRequest::getVar("sectionid");
		$article["categorie"] 	= JRequest::getVar("catid");
		$article["metakey"] 	= JRequest::getVar("metakey");
		$article["metadesc"] 	= JRequest::getVar("metadesc");

		if(_ART_SET_content_style==0){
			$article["intro"]  = stripslashes(JArrayHelper::getValue($_REQUEST,"introtext", ""));
			$article["main"]   = stripslashes(JArrayHelper::getValue($_REQUEST,"maintext", ""));
		}elseif(_ART_SET_content_style == 1){
			$article["text"] 	= stripslashes(JArrayHelper::getValue($_REQUEST,"article_text", ""));
			$article["text"]	= str_replace('<br>', '<br />', $article["text"]);
			$pattern = '#<hr\s+id=("|\')system-readmore("|\')\s*\/*>#i';
			$tagPos	= preg_match($pattern, $article["text"]);
			if ($tagPos == 0) {
				$article["intro"]	= $article["text"];
			} else {
				list($article["intro"], $article["main"]) = preg_split($pattern, $article["text"], 2);
			}
        }
        
		$article["resourcebox"] = stripslashes(JArrayHelper::getValue($_REQUEST,'resourcebox', ""));
		$order   = array("\r\n", "\n", "\r");
        $replace = '<br />';
        // Processes \r\n's first so they aren't converted twice.
        $article["resourcebox"] = str_replace($order, $replace, $article["resourcebox"]);
        
            // intro, maintext manipulation
		if(_ART_SET_content_style==0){
			if ((!_ART_SET_allow_intro_html) && _ART_SET_intromain){
				$order   = array("\r\n", "\n", "\r"); $replace = '<br />';
				$article["intro"] = str_replace($order, $replace, $article["intro"]);
				$article["intro"] = strip_tags($article["intro"],'<br />');
			}
		}elseif(_ART_SET_content_style == 1){
			if ((!_ART_SET_art_text_html)){
				$order   = array("\r\n", "\n", "\r"); $replace = '<br />';
				$article["intro"]    = str_replace($order, $replace, $article["intro"]);
				$article["intro"]	 = strip_tags($article["intro"],'<br />');
				$article["main"]	 = str_replace($order, $replace, $article["main"]);
				$article["main"]	 = strip_tags($article["main"],'<br />');
			}
		}
		if(trim(_ART_SET_allowed_tags)!="")
			if(_ART_SET_allowed_tags){
				$article["intro"] = strip_tags($article["intro"],_ART_SET_allowed_tags);
				$article["main"] = strip_tags($article["main"],_ART_SET_allowed_tags);
			}
    	
    	if(_ART_SET_ticketpreapproval)
			$article["approver"] = JRequest::getVar("approver");
			
		return $article;
    }
    
    /**
     * Set article publish_up, publish_down, 
     *
     * @param $article
     * @param $start_date
     * @param $end_date
     * @version 1.7.0
     */
    function setArticleDates(&$article, $start_date, $end_date){
    	global $mainframe;
    	$my =& JFactory::getUser();
		$database =& JFactory::getDBO();

		$article->publish_up = $start_date;
		$date =& JFactory::getDate($article->publish_up, $mainframe->getCfg('offset'));
		$article->publish_up = $date->toMySQL();

		// Handle never unpublish date
		if (trim($end_date) == JText::_('Never') || trim( $end_date ) == '' || trim( $end_date ) == '00:00:00'){
			$article->publish_down = $database->getNullDate();
		}else{
			$article->publish_down = $end_date;
			$date =& JFactory::getDate($article->publish_down, $mainframe->getCfg('offset'));
			$article->publish_down = $date->toMySQL();
		}

        //$article->modified=date( 'Y-m-d H:i:s' );
        $date =& JFactory::getDate(date( 'Y-m-d H:i:s' ), $mainframe->getCfg('offset'));
        if(!$article->id){
        	$article->created = $date->toMySQL();
        }
		$article->modified=$date->toMySQL();

        $article->modified_by=$my->id;
        $article->checked_out=0;
        $article->checked_out_time=$database->getNullDate();
	}

    function setArticleApprover(&$article, $approver ){
    	
    	$database = & JFactory::getDBO();
        $database->setQuery("SELECT * FROM #__art_articles_ref WHERE articleid='$article->id'");
        if($exists=$database->loadResult()){
			$database->setQuery("UPDATE #__art_articles_ref SET approver_id='{$approver}' WHERE articleid='$article->id'");
        }else{
			$database->setQuery("INSERT INTO #__art_articles_ref SET articleid='$article->id',approver_id='{$approver}'");
        }
        $database->query();
    	
    }

    function atachResourceBox(&$row, $posted_resourceBox) {
    	
    	$user =& JFactory::getUser();
		$resbox = $this->_getResourceBox($user->id);
		if(_ART_SET_enable_resourcebox=="1"){
			if(!CB_DETECT) {
				if(_ART_SET_allow_author_image=="1" && $resbox->file!="") {
					jimport('joomla.filesystem.file');
					$file = "components/com_articleman/files/".$user->id.".".JFile::getExt($resbox->file);
					if($resbox->file_params=="left" || !isset($resbox->file_params))
						$signature = '<img src="'.$file.'" align="left">'.$posted_resourceBox;
					elseif($resbox->file_params=="right")
						$signature = $posted_resourceBox.'<img src="'.$file.'" align="right">';
				}else $signature = $posted_resourceBox;
				// Resource Box only added once (more specific at article created)
				if( ($row->id < 1) && _ART_SET_concat_resourcebox == "1") {
					echo $row->fulltext.="<br />".$signature;
				}
			}else {
				$file = "";
				if(_ART_SET_allow_author_image=="1" && $resbox->file!=""){
					$file = "images/comprofiler/".$resbox->file;
					if( strtolower($resbox->file_params)=="left" || !isset($resbox->file_params) )
						$signature = '<img src="'.$file.'" align="left">'.$resbox->text;
					elseif(strtolower($resbox->file_params)=="right")
						$signature = $posted_resourceBox.'<img src="'.$file.'" align="right">';
					$signature = '<img src="'.$file.'" align="left">'.$resbox->text;
				}else  $signature = $resbox->text;
				// Resource Box only added once (more specific at article created)
				if( ($row->id < 1) && _ART_SET_concat_resourcebox == "1") {
					echo $row->fulltext.="<br />".$signature;
				}
			}
		}
    }

    function _getResourceBox($user) {
	    global $cb_fieldmap;
	    
    	$database = & JFactory::getDBO();
		$resbox=null;
		if(!CB_DETECT){
			$database->setQuery("select * from #__art_resourcebox where authorId='$user'");
			$resbox = $database->loadObject();
		} else {
		
			$what = array();
			if($cb_fieldmap['avatar']) $what[] = $cb_fieldmap['avatar']." as file ";
			if($cb_fieldmap['text']) $what[] = $cb_fieldmap['text']." as text ";
			if($cb_fieldmap['file_params']) $what[] = $cb_fieldmap['file_params']." as file_params ";
			
			if(count($what)>0)
				$sql_what = implode(",", $what);
			else 
				$sql_what = " * ";
			$query="select $sql_what from #__comprofiler where user_id = ".$user;
			$database->setQuery($query);
			$resbox = $database->loadObject();
			if(isset($resbox->file_params))
				$resbox->file_params=strtolower($resbox->file_params);
		}
		return $resbox;
    }
    
    function word_count($html) {

	  # strip all html tags
	  $wc = strip_tags($html);
	
	  # remove 'words' that don't consist of alphanumerical characters or punctuation
	  $pattern = "#[^(\w|\d|\'|\"|\.|\!|\?|;|,|\\|\/|\-|:|\&|@)]+#";
	  $wc = trim(preg_replace($pattern, " ", $wc));
	
	  # remove one-letter 'words' that consist only of punctuation
	  $wc = trim(preg_replace("#\s*[(\'|\"|\.|\!|\?|;|,|\\|\/|\-|:|\&|@)]\s*#", " ", $wc));
	
	  # remove superfluous whitespace
	  $wc = preg_replace("/\s\s+/", " ", $wc);
	
	  # split string into an array of words
	  $wc = explode(" ", $wc);
	
	  # remove empty elements
	  $wc = array_filter($wc);
	
	  # return the number of words
	  return count($wc);
	
	}
	
	function countChars($html){
	  # strip all html tags
	  $wc = strip_tags($html);
	  $wc = str_replace(" ", "", $wc);
	  return strlen($wc);
	}
	
	function getUnpublishedArticles() {
		$database = JFactory::getDBO();
        $database->setQuery("SELECT id FROM #__content AS a LEFT JOIN #__art_articles_ref AS b ON articleid = id WHERE a.state=0 AND a.checked_out = 0 AND b.state = 'pending' ");
        return $database->loadObjectList();
	}
	
	function getPreApprovalArticles(){
		$user = &JFactory::getUser();
		$database = &JFactory::getDBO();
        $database->setQuery("SELECT id FROM #__content AS a LEFT JOIN #__art_articles_ref AS b ON articleid = id WHERE a.state=0 AND a.checked_out = 0 AND b.state = 'pending' AND b.approver_id = '{$user->id}' AND a.created_by <> '{$user->id}' ");
        return $database->loadObjectList();
	}
	
	function getNextArticle() {
		
	}
	
	/**
	 * Deprecated: user articleACL hasEditorAccess
	 *
	 * @return boolean
	 */
	function testUserAccess(){
		$user = &JFactory::getUser();
		if( ( $user->usertype=="Super Administrator" || strpos(_ART_SET_allowed_to_aprouve_groups, $user->gid)!==false ) ){
			return true;
	    }
	    return false;
	}
	
	/**
	 * Detect CB Integration
	 *
	 *
	 **/
    function _detectIntegration() {
    	$database = & JFactory::getDBO();
	    global $cb_fieldmap;
	    //detect CB
	    $database->setQuery("select count(*) from #__components where `option`='com_comprofiler'");
	    if($database->loadResult()>0){
	    	define('CB_DETECT',1);
	    	$database->setQuery("select field,cb_field from #__art_cbfields");
	    	$r=$database->loadAssocList();
	    	for($i=0;$i<count($r);$i++){
	    		$cb_fieldmap[$r[$i]['field']]=$r[$i]['cb_field'];
	    	}
	    }else {
			define('CB_DETECT',0);
	    }
    }
    
	function checkin($article_id) {
		if ($article_id) {
			$article = & JTable::getInstance('content');
			return $article->checkin($article_id);
		}
		return false;
	}

	function checkout($article_id,$uid = null) {
		if ($article_id) {
			if (is_null($uid)) {
				$user	=& JFactory::getUser();
				$uid	= $user->get('id');
			}
			$article = & JTable::getInstance('content');
			return $article->checkout($uid, $article_id);
		}
		return false;
	}
	
	function getUsers($name,$javascript,$active,$nouser=null){
    	$db = & JFactory::getDBO();
    	$my = & JFactory::getUser();
    	if($my)
    		$and = " AND id <> {$my->id} ";
		$query = 'SELECT id AS value, name AS text'
		. ' FROM #__users'
		. ' WHERE block = 0'
		. $and
		;
		$db->setQuery( $query );
		if ( $nouser ) {
			$users[] = JHTML::_('select.option',  '0', '- '. JText::_( 'No User' ) .' -' );
			$users = array_merge( $users, $db->loadObjectList() );
		} else {
			$users = $db->loadObjectList();
		}

		return JHTML::_('select.genericlist',   $users, $name, 'class="inputbox" size="1" '. $javascript, 'value', 'text', $active );
		
	}
    
}
?>