<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

require(JPATH_COMPONENT_ADMINISTRATOR.DS.'thefactory.xajax.php');

class JArticlemanAdminXajax extends JTheFactoryXajax{
	function JArticlemanAdminXajax(){
		$obj1 = new ArtAdminXajaxMethods;

		parent::__construct(array($obj1));
	}
}

class ArtAdminXajaxMethods{
	
	function retrieveCategories($sectionId){
		$objResponse = new xajaxResponse();
		$database =& JFactory::getDBO();

		$sectionId = (int) $sectionId;
		if(!$sectionId){
			$objResponse->clear('restrict_categories_container','innerHTML');
			return $objResponse;
		}

		$database->setQuery("SELECT `id` AS `value`, `title` AS text FROM `#__categories` WHERE `section`='".$database->getEscaped($sectionId)."'");
		$aCategories = $database->loadAssocList();

		$categorySelect = JHTML::_('select.genericlist',$aCategories,'restrict_categories','onchange="activateApplyButton();" multiple="" size='.count($aCategories),'value','text');
		$htmlData = $categorySelect;

		$objResponse->clear('restrict_categories_container','innerHTML');
		$objResponse->assign('restrict_categories_container','innerHTML',$htmlData);

		return $objResponse;
	}
	
	function saveRestriction($groupId,$categoryIds=array()){
		$objResponse = new xajaxResponse();
		
		$groupId = (int) $groupId;
		if(!$groupId){
			$objResponse->alert('No group selected!');
			return $objResponse;
		}
		if(!count($categoryIds)){
			$objResponse->alert('No category selected!');
			return $objResponse;
		}

		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		if(isset($groupRestrictions[$groupId])){
			foreach($categoryIds as $catId){
				if(!in_array($catId,$groupRestrictions[$groupId])){
					array_push($groupRestrictions[$groupId],$catId);
				}
			}
		}
		else{
			$groupRestrictions[$groupId]=$categoryIds;
		}

		_rewriteRestrictionsFile($groupRestrictions);

		$database =& JFactory::getDBO();
		$database->setQuery("SELECT `name` FROM `#__core_acl_aro_groups` WHERE `id`='".$database->getEscaped($groupId)."'");
		$objResponse->alert('Restriction saved for group "'.$database->loadResult().'"');

		return $this->listRestrictions($objResponse);
	}
	
	function listRestrictions($objResponse = null){
		if(!$objResponse)
			$objResponse = new xajaxResponse();
		
		$database =& JFactory::getDBO();

		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		if(!count($groupRestrictions)){
			
		}
		
		$htmlResponse = '';
		$restrictionRow =
			'<div id="group_{$gid}_container" style="width:100%; border: solid 1px #E7E7E7; font-weight:bold; padding:4px;">'.
				'<div style="width:25%;float:left;">{$groupName}&nbsp;'.
					'<a href="#" onclick="if(confirm(\'Remove restrictions for group &quot;{$groupName}&quot;?\')){theFactory_ArtAdminXajaxMethods.deleteRestriction({$gid})} return false;  "><img src="images/publish_x.png" /></a>'.
				'</div>'.
				'<div style="width:70%;float:left;">{$restrictedCategoriesLinks}</div>'.
				'<div style="clear:both"></div>'.
			'</div><br />';
		foreach($groupRestrictions as $gid=>$restrictedCategories){
			$database->setQuery("SELECT `name` FROM `#__core_acl_aro_groups` WHERE `id`='".$database->getEscaped($gid)."'");
			$groupName = $database->loadResult();

			$restrictedCategoriesIds = implode(',',$restrictedCategories);
			$database->setQuery("SELECT `id`,`title` FROM `#__categories` WHERE `id` IN (".$restrictedCategoriesIds.")");
			$aRestrictedCategoriesNames = $database->loadAssocList();
			$restrictedCategoriesLinks = '';
			foreach($aRestrictedCategoriesNames as $rc){
				$restrictedCategoriesLinks .= '<a href="#">'.$rc['title'].'</a>&nbsp;&nbsp;&nbsp;';
			}

			$patterns = array('#\{\$gid\}#','#\{\$groupName\}#','#\{\$restrictedCategoriesLinks\}#');
			$replacements = array($gid,$groupName,$restrictedCategoriesLinks);
			$htmlResponse .= preg_replace($patterns,$replacements,$restrictionRow);
		}

		$objResponse->assign('restrictions_container','innerHTML',$htmlResponse);

		return $objResponse;
	}
	
	function deleteRestriction($gid){
		$objResponse = new xajaxResponse;
		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		if(!isset($groupRestrictions)){
			$groupRestrictions = array();
		}
		unset($groupRestrictions[$gid]);
		_rewriteRestrictionsFile($groupRestrictions);
		
		$objResponse->remove('group_'.$gid.'_container');

		return $this->listRestrictions($objResponse);
	}
}

function _rewriteRestrictionsFile($varRestrictions){
		$file = JPATH_COMPONENT_SITE.DS.'config'.DS.'restrictions.php';
		require($file);
		$data='<?php'."\n".
			"defined('_JEXEC') or die('Restricted access.');\n".
			'$groupRestrictions='.var_export($varRestrictions,true).";\n".
			'?>';

		file_put_contents($file,$data);
		
		return true;
	}
?>