<?php
/**
* @package Article Manager Factory
* @version 1.7.6
* @copyright www.thefactory.ro
* @license: commercial
*/
defined( '_JEXEC' ) or die( 'Restricted access' );
require_once(JPATH_SITE . DS . 'components' . DS . 'com_articleman' . DS . 'class' . DS . 'mainclass.php');

class articleman_admin extends articleman_ancestor
{
	function listArticles()
	{

		$where = array();
		$database = &JFactory::getDBO();
		$jconfig = new JConfig;
		$list_limit = $jconfig->list_limit;
		
		if(!isset($_SESSION)) session_start();

        $limitstart= JArrayHelper::getValue($_SESSION,"limitstart",0);$limit = JArrayHelper::getValue($_SESSION,"limit",$list_limit);
        $searchString = JArrayHelper::getValue($_SESSION,"searchstring","");
		$filter_sectionid= JArrayHelper::getValue($_SESSION,"filter_sectionid",0);$filter_catid= JArrayHelper::getValue($_SESSION,"filter_catid",0);
		$filter_state= JArrayHelper::getValue($_SESSION,"filter_state",1);
		$filter_order= JArrayHelper::getValue($_SESSION,"filter_order",'');$filter_order_Dir= JArrayHelper::getValue($_SESSION,"filter_order_Dir",'');

		$limitstart= JArrayHelper::getValue($_REQUEST,"limitstart",$limitstart);$limit = JArrayHelper::getValue($_REQUEST,"limit",$limit);
        $searchString = JArrayHelper::getValue($_REQUEST,"searchstring",$searchString);
		$filter_sectionid= JArrayHelper::getValue($_REQUEST,"filter_sectionid",$filter_sectionid);$filter_catid= JArrayHelper::getValue($_REQUEST,"filter_catid",$filter_catid);
		$filter_state= JArrayHelper::getValue($_REQUEST,"filter_state",$filter_state);
		$filter_order= JArrayHelper::getValue($_REQUEST,"filter_order",$filter_order);$filter_order_Dir= JArrayHelper::getValue($_REQUEST,"filter_order_Dir",$filter_order_Dir);

		$_SESSION["limitstart"]=$limitstart;$_SESSION["limit"]=$limit;
		$_SESSION["searchstring"]=$searchString;
		$_SESSION["filter_sectionid"]=$filter_sectionid;$_SESSION["filter_catid"]=$filter_catid;
		$_SESSION["filter_state"]=$filter_state;
		$_SESSION["filter_order"]=$filter_order;$_SESSION["filter_order_Dir"]=$filter_order_Dir;

		//$where[] = "b.state <> 'draft'";
		if ($searchString)
		{
			$where[]= " (a.title like '%$searchString%' or a.introtext like '%$searchString%' or a.fulltext like '%$searchString%')";
		}
    	if($filter_catid)
            $where[]= "a.catid='".(int)$filter_catid."'";
		if($filter_sectionid)
            $where[]= "a.sectionid='".(int)$filter_sectionid."'";
		switch ($filter_state)
		{
			case 1://pending
				$where[]= "a.state=0 and (b.state='pending')";
				break;
			case 2://published
				$where[]= "a.state=1";
				break;
			case 3://unpublished
				$where[] = "a.state=0 and b.state='normal'";
				break;
			case 4://rejected
				$where[] = "a.state=0 and b.state='rejected'";
				break;
		}

		if($filter_order ==""){
			$orderBy = " a.id desc ";
		}
		else $orderBy = " ".$filter_order." ".$filter_order_Dir;

		 $query_c= "select count(*)
		          from  #__content AS a
		          left join #__art_articles_ref as b on a.id = b.articleid"
		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" );
        $database->setQuery($query_c);
        $total=$database->loadResult();

		$query = "select a.*,
				  b.state as rstate,r.reason, 
		          c.title as categoryname,
		          s.title as sectionname,
		          u.name as username
		          from  #__content AS a
		          left join #__art_articles_ref as b on a.id = b.articleid
		          left join #__categories as c on c.id = a.catid
		          left join #__art_reason as r on b.reason = r.id 
		          left join #__sections as s on s.id = a.sectionid
		          left join #__users as u on u.id = a.created_by
		          "
		.( count( $where ) ? "\n WHERE " . implode( ' AND ', $where ) : "" )
		." order by ".$orderBy;
        $database->setQuery($query,$limitstart,$limit);
		$rows=$database->loadObjectList();

    	$lists['state'] = $this->HTML_Status_list($filter_state, 1);
        $lists['catid'] = $this->HTML_cat_list($filter_sectionid,$filter_catid);
        $lists['sectionid']	=$this->HTML_section_list($filter_sectionid);
    	$lists['searchString']=$searchString;
    	$lists['order']=$filter_order;
    	$lists['order_Dir']=$filter_order_Dir;

    	$this->GetRejectReasons($lists);

    	//require_once( JPATH_SITE. DS . 'administrator' . DS . 'includes' . DS . 'pageNavigation.php' );
    	jimport('joomla.html.pagination');
    	$pageNav = new JPagination( $total, $limitstart, $limit );

		HTML_adminArticleman::showArticleList($rows,$pageNav,$lists);
	}

	function publishArticles()
	{
		global $option, $mainframe;

		$chb = JRequest::getVar("cid");
        $this->changeState($chb,1);
		$mainframe->redirect("index2.php?option=$option","");
	}

	function unpublishArticles()
	{
		global $option, $mainframe;

		$chb = JRequest::getVar("cid");
        $this->changeState($chb,0);
		$mainframe->redirect("index2.php?option=$option","");
	}

	function deleteArticles()
	{
		global $option, $mainframe;
		$database = &JFactory::getDBO();
		$chb = JRequest::getVar("cid");
		$id = JRequest::getVar("id");
		if (count($chb)==0 && $id) $chb[0]=$id;
		
		$getnextpending=JRequest::getVar("getnextpending");
		for ($i=0;$i<count($chb);$i++)
		{
		    $ch=$chb[$i];
            $this->deleteArticle($ch);
		}
        if($getnextpending){
            $database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
            $id=$database->loadResult();
            $mainframe->redirect("index2.php?option=$option&&task=editart&id=".$id);
        }else
		  $mainframe->redirect("index2.php?option=$option",JText::_('AMAN_ARTICLE_DELETED'));
	}
	
	function backButton()
	{
		global $option, $mainframe;
	    $mainframe->redirect("index2.php?option=$option");
	}
	
	function editArticle()
	{
		global $taks,$option, $mainframe;

		$database =& JFactory::getDBO();
		$user =&JFactory::getUser();
		
		$chb = JRequest::getVar("cid");
		$id = JRequest::getVar("id");
		
		if (count($chb)>0) $id=$chb[0];

		$row = & JTable::getInstance('content');
    	if (!$row->load( (int)$id ))
		{
    		$mainframe->redirect("index2.php?option=$option",JText::_('AMAN_ERR_EDIT'));
			exit;
    	}

		$row->checkout( $user->id );
//Several Date formatting

		$nullDate = $database->getNullDate();
		
		$row->created 		= JHTML::_('date', $row->created, "%Y-%m-%d %H:%M:%S" );
		$row->modified 		= $row->modified == $nullDate ? '' : JHTML::_('date', $row->modified, "%Y-%m-%d %H:%M:%S" );
		$row->publish_up 	= JHTML::_('date', $row->publish_up, "%Y-%m-%d %H:%M:%S" );
 		
		if (trim( $row->publish_down ) == $nullDate || trim( $row->publish_down ) == '' || trim( $row->publish_down ) == '-' ) {
			$row->publish_down = 'Never';
		}else{
			$row->publish_down 	= JHTML::_('date', $row->publish_down, "%Y-%m-%d %H:%M:%S" );
		}
		
//UserName
		$query = "SELECT name"
		. "\n FROM #__users"
		. "\n WHERE id = " . (int) $row->created_by
		;
		$database->setQuery( $query );
		$row->creator = $database->loadResult();

//Check if published on frontend
		$query = "SELECT content_id"
		. "\n FROM #__content_frontpage"
		. "\n WHERE content_id = " . (int) $row->id
		;
		$database->setQuery( $query );
		$row->frontpage = $database->loadResult();
		$row->word_banned = articleman_ancestor::checkArticleForBannedWords($row);

//Some lists
        $this->HTML_section_cat_pick($row->sectionid,$row->catid,$lists);
        $lists['created_by'] = JHTML::_('list.users', 'created_by', $row->created_by,0,null,'name',0 );
		$this->GetArticleState($row->id,$lists);
		
    	$database->setQuery("select * from #__art_articles_ref where articleid='$row->id'");
    	$cur_state=null;
      	$cur_state = $database->loadAssoc();
      	
      	$chkfrontpage= "";
		if ($row->frontpage && $row->state==1) { $chkfrontpage="checked";} 
		if(_ART_SET_publish_on_frontpage && $cur_state["state"]=="pending") { $chkfrontpage="checked";}
		if($cur_state["state"]=="rejected") { $chkfrontpage="";}
		
		//if($lists['state']==AMAN_pending && _ART_SET_publish_on_frontpage && $row->state==1) { $chkfrontpage="checked";}
		//if(($lists['state']==AMAN_pending || $lists['state']==AMAN_unpublish  || $lists['state']==AMAN_rejected) && $row->frontpage && $row->state!=1) { $chkfrontpage="";}
		
		$lists['frontpage'] ="<input name='frontpage' class='inputbox' type='checkbox' value='1' $chkfrontpage >";
		$this->GetRejectReasons($lists);
		
		if($row->checked_out>0){
			$tmpUser = &JTable::getInstance("user");
			$tmpUser->load($row->checked_out);
			$row->checked_out_username = $tmpUser->name;
			unset($tmpUser);
			$row->checked_out_info = JText::_('AMAN_CHECKED_OUT')." ".$row->checked_out_username." - ".$row->checked_out_time." !";
		}

		HTML_adminArticleman::editArticle($row,$lists);
	}
	
	function saveConfig()
    {
		global $option, $mainframe;

		$database = &JFactory::getDBO();
		$configFile = JPATH_SITE . DS . "components" . DS . "$option" . DS . "config" . DS . "config.php";
		if(!is_writable($configFile))
		if(!chmod ($configFile, 0777))
        	$mainframe->redirect("index2.php?option=$option&task=config",JText::_('AMAN_ERR_PERMISSIONS'));

		$fh = fopen($configFile, 'w') or die("can't open config file");

		$stringData  = "<?php\n";
		$stringData .= "define('_ART_SET_content_style','".JArrayHelper::getValue($_REQUEST,"content_style","1")."');\n";
		
		// ==> particular Joomla 1.0.x content article mode
		$stringData .= "define('_ART_SET_showintro','".JArrayHelper::getValue($_REQUEST,"showintro","1")."');\n";
		$stringData .= "define('_ART_SET_allow_intro_html','".JArrayHelper::getValue($_REQUEST,"allow_intro_html","1")."');\n";
		$stringData .= "define('_ART_SET_required_intro','".JArrayHelper::getValue($_REQUEST,"allow_required","1")."');\n";

		$stringData .= "define('_ART_SET_showmain','".JArrayHelper::getValue($_REQUEST,"showmain","1")."');\n";
		$stringData .= "define('_ART_SET_allow_main_html','".JArrayHelper::getValue($_REQUEST,"allow_main_html","1")."');\n";
		$stringData .= "define('_ART_SET_required_main','".JArrayHelper::getValue($_REQUEST,"allow_main","1")."');\n";
		// <== particular Joomla 1.0.x content article mode
		 
		// ==> particular Joomla 1.5.x content article mode
		$stringData .= "define('_ART_SET_art_text_html','".JArrayHelper::getValue($_REQUEST,"art_text_html","1")."');\n";
		$stringData .= "define('_ART_SET_art_text_required','".JArrayHelper::getValue($_REQUEST,"art_text_required","1")."');\n";
		// <== particular Joomla 1.5.x content article mode
		
		$stringData .= "define('_ART_SET_canDelete','".JArrayHelper::getValue($_REQUEST,"candelete","1")."');\n";
		$stringData .= "define('_ART_SET_canUnpublish','".JArrayHelper::getValue($_REQUEST,"canunpublish","1")."');\n";
		$stringData .= "define('_ART_SET_canEditDates','".JArrayHelper::getValue($_REQUEST,"caneditdates","1")."');\n";
		$stringData .= "define('_ART_SET_allow_set_hour','".JArrayHelper::getValue($_REQUEST,"allow_set_hour","1")."');\n";
		$stringData .= "define('_ART_SET_allow_set_enddate','".JArrayHelper::getValue($_REQUEST,"allow_set_enddate","1")."');\n";
		$stringData .= "define('_ART_SET_enable_ordering','".JArrayHelper::getValue($_REQUEST,"art_enable_ordering","1")."');\n";
		
		$stringData .= "define('_ART_SET_publish_on_frontpage','".JArrayHelper::getValue($_REQUEST,"publish_on_frontpage","1")."');\n";
		$stringData .= "define('_ART_SET_allowmetdata','".JArrayHelper::getValue($_REQUEST,"allowmetdata","1")."');\n";
		$stringData .= "define('_ART_SET_default_publishing_period','".JArrayHelper::getValue($_REQUEST,"default_publishing_period",365)."');\n";

		$stringData .= "define('_ART_SET_nrlinks','".JArrayHelper::getValue($_REQUEST,"nrlinks","4")."');\n";
		$stringData .= "define('_ART_SET_nrlinks_resourcebox','".JArrayHelper::getValue($_REQUEST,"nrlinks_res","2")."');\n";
		$stringData .= "define('_ART_SET_nrimages','".JArrayHelper::getValue($_REQUEST,"nrimages","")."');\n";
		$stringData .= "define('_ART_SET_concat_resourcebox','".JArrayHelper::getValue($_REQUEST,"concat_resourcebox","2")."');\n";
		$stringData .= "define('_ART_SET_enable_resourcebox','".JArrayHelper::getValue($_REQUEST,"enable_resourcebox","2")."');\n";
		$stringData .= "define('_ART_SET_allowed_tags','".JArrayHelper::getValue($_REQUEST,"allowed_tags","")."');\n";
		$stringData .= "define('_ART_SET_allowed_groups','".implode("," ,JArrayHelper::getValue($_REQUEST,"allowed_groups",""))."');\n";
		$stringData .= "define('_ART_SET_allowed_to_aprouve_groups','".implode("," ,JArrayHelper::getValue($_REQUEST,"allowed_to_aprouve_groups",""))."');\n";
		
		$stringData .= "define('_ART_SET_pendingAuthor','".JArrayHelper::getValue($_REQUEST,"pendingAuthor","1")."');\n";
		$stringData .= "define('_ART_SET_pendingAdmin','".JArrayHelper::getValue($_REQUEST,"pendingAdmin","1")."');\n";
		$stringData .= "define('_ART_SET_rejectAuthorEmail','".JArrayHelper::getValue($_REQUEST,"rejectAuthorEmail","1")."');\n";
		$stringData .= "define('_ART_SET_acceptAuthorEmail','".JArrayHelper::getValue($_REQUEST,"acceptAuthorEmail","1")."');\n";
		$stringData .= "define('_ART_SET_unpublishEmail','".JArrayHelper::getValue($_REQUEST,"unpublishEmail","1")."');\n";
		$stringData .= "define('_ART_SET_limit_minim_chars','".JArrayHelper::getValue($_REQUEST,"limit_minim_chars","")."');\n";
		$stringData .= "define('_ART_SET_limit_maxim_chars','".JArrayHelper::getValue($_REQUEST,"limit_maxim_chars","")."');\n";
		$stringData .= "define('_ART_SET_alert_words','".JArrayHelper::getValue($_REQUEST,"alert_words","")."');\n";
		$stringData .= "define('_ART_SET_mail_from_name','".JArrayHelper::getValue($_REQUEST,"art_mail_from_name","")."');\n";
		$stringData .= "define('_ART_SET_mail_from_email','".JArrayHelper::getValue($_REQUEST,"art_mail_from_email","")."');\n";
		$stringData .= "define('_ART_SET_allow_author_image','".JArrayHelper::getValue($_REQUEST,"art_allow_author_image","")."');\n";
		$stringData .= "define('_ART_SET_allowed_extensions','".JArrayHelper::getValue($_REQUEST,"art_author_image_extensions","")."');\n";
		$stringData .= "define('_ART_SET_max_size','".JArrayHelper::getValue($_REQUEST,"art_author_max_size","")."');\n";
		$stringData .= "define('_ART_SET_allowalias','".JArrayHelper::getValue($_REQUEST,"allowalias","")."');\n";
		$stringData .= "define('_ART_SET_usecheckin','".JArrayHelper::getValue($_REQUEST,"usecheckin","")."');\n";
		$stringData .= "define('_ART_SET_showcreationdate','".JArrayHelper::getValue($_REQUEST,"showcreationdate","")."');\n";
		$stringData .= "define('_ART_SET_ticketpreapproval','".JArrayHelper::getValue($_REQUEST,"ticketpreapproval","")."');\n";
		$stringData .= "define('_ART_SET_onesuperadminonly','".JArrayHelper::getValue($_REQUEST,"onesuperadminonly","")."');\n";

		$stringData .= "?>";
		fwrite($fh, $stringData);
		fclose($fh);

		$subj=JArrayHelper::getValue($_REQUEST,'reject_subject','');
		$templ=JArrayHelper::getValue($_REQUEST,'reject_body','',_MOS_ALLOWRAW);
		$database->setQuery("update #__art_emailtmpl set subject='$subj', template='$templ' where type='reject' ");
		$database->query();

		$subj=JArrayHelper::getValue($_REQUEST,'publish_subject','');
		$templ=JArrayHelper::getValue($_REQUEST,'publish_body','',_MOS_ALLOWRAW);
		$database->setQuery("update #__art_emailtmpl set subject='$subj', template='$templ' where type='publish' ");
		$database->query();

		$subj=JArrayHelper::getValue($_REQUEST,'pendingAuthor_subject','');
		$templ=JArrayHelper::getValue($_REQUEST,'pendingAuthor_body','',_MOS_ALLOWRAW);
		$database->setQuery("update #__art_emailtmpl set subject='$subj', template='$templ' where type='pendingAuthor' ");
		$database->query();

		$subj=JArrayHelper::getValue($_REQUEST,'pendingAdmin_subject','');
		$templ=JArrayHelper::getValue($_REQUEST,'pendingAdmin_body','',_MOS_ALLOWRAW);
		$database->setQuery("update #__art_emailtmpl set subject='$subj', template='$templ' where type='pendingAdmin' ");
		$database->query();

		$subj=JArrayHelper::getValue($_REQUEST,'unpublish_subject','');
		$templ=JArrayHelper::getValue($_REQUEST,'unpublish_body','',_MOS_ALLOWRAW);
		$database->setQuery("update #__art_emailtmpl set subject='$subj', template='$templ' where type='unpublish' ");
		$database->query();
		
		global $cb_fieldmap;
	
		$keys=array_keys($cb_fieldmap);
		for ($i=0; $i<count($keys); $i++ ){
	    	$fld=$keys[$i];
			$cb=$_REQUEST[$fld];
			$database->setQuery("update #__art_cbfields set cb_field='$cb' where field='$fld'");
			$database->query();
	    }

		
        $mainframe->redirect("index2.php?option=$option&task=config",JText::_('AMAN_CONFIGURATION_SAVED'));
    }
    
	function createConfigFile()
	{
		require(JPATH_COMPONENT_ADMINISTRATOR.DS.'admin.articleman.xajax.php');
		$adminXajax = new JArticlemanAdminXajax;
		$xMethods =& $adminXajax->getXajaxMethods();

		$database = &JFactory::getDBO();
		$acl	  =& JFactory::getACL();

	    $lists=array();
		$custom_mode_javascript = " onclick='articleman_JS_toggle_mode(this.value);'";
	    $lists['content_style']= JHTML::_('select.booleanlist','content_style',"class='inputbox' {$custom_mode_javascript} ", _ART_SET_content_style,"Joomla 1.5.x mode" , "Joomla 1.0.x mode");
		
	    // ==> mode Joomla 1.5.x particular settings
		$lists['art_text_required']=JHTML::_('select.booleanlist', 'art_text_required','class="inputbox"',_ART_SET_art_text_required);
		$lists['art_text_html']= JHTML::_('select.booleanlist', 'art_text_html','class="inputbox"',_ART_SET_art_text_html);
	    // <== mode Joomla 1.5.x particular settings
	    
	    // ==> mode Joomla 1.0.x particular settings
	    $lists['showintro']=JHTML::_('select.booleanlist', 'showintro','class="inputbox"', _ART_SET_showintro);
		$lists['allow_intro_html']=JHTML::_('select.booleanlist', 'allow_intro_html','class="inputbox"',_ART_SET_allow_intro_html);
		$lists['allow_required']=JHTML::_('select.booleanlist', 'allow_required','class="inputbox"',_ART_SET_required_intro);

	    $lists['showmain']=JHTML::_('select.booleanlist', 'showmain','class="inputbox"', _ART_SET_showmain);
		$lists['allow_main_html']=JHTML::_('select.booleanlist', 'allow_main_html','class="inputbox"',_ART_SET_allow_main_html);
		$lists['allow_main']=JHTML::_('select.booleanlist', 'allow_main','class="inputbox"',_ART_SET_required_main);
	    // <== mode Joomla 1.0.x particular settings
		
		$lists['publish_on_frontpage']=JHTML::_('select.booleanlist', 'publish_on_frontpage','class="inputbox"',_ART_SET_publish_on_frontpage);
	    $lists['candelete']=JHTML::_('select.booleanlist', 'candelete','class="inputbox"',_ART_SET_canDelete);
	    $lists['canunpublish']=JHTML::_('select.booleanlist', 'canunpublish','class="inputbox"',_ART_SET_canUnpublish);
	    $lists['caneditdates']=JHTML::_('select.booleanlist', 'caneditdates','class="inputbox"',_ART_SET_canEditDates);
		$lists['allow_set_enddate']=JHTML::_('select.booleanlist', 'allow_set_enddate','class="inputbox"',_ART_SET_allow_set_enddate);
		$lists['allow_set_hour'] = JHTML::_('select.booleanlist','allow_set_hour','class="inputbox"',_ART_SET_allow_set_hour);
	    $lists['allowmetdata']=JHTML::_('select.booleanlist', 'allowmetdata','class="inputbox"',_ART_SET_allowmetdata);
		$lists['enable_resourcebox']=JHTML::_('select.booleanlist', 'enable_resourcebox','class="inputbox"',_ART_SET_enable_resourcebox);
		$lists['concat_resourcebox']=JHTML::_('select.booleanlist', 'concat_resourcebox','class="inputbox"',_ART_SET_concat_resourcebox);
		$lists["allowed_groups"] = $acl->get_group_children_tree( null, 'USERS', false );
		$lists["allowed_groups_selected"] = _ART_SET_allowed_groups;
		
		$lists["allowed_to_aprouve_groups"] = $acl->get_group_children_tree( null, 'USERS', false );
		$lists["allowed_to_aprouve_groups_selected"] = _ART_SET_allowed_to_aprouve_groups;
		
		$lists['default_publishing_period'] = '<input type="text" name="default_publishing_period" value="'._ART_SET_default_publishing_period.'" /> days';
		
		// ==> since 1.5.6
		$lists["limit_minim_chars"] = _ART_SET_limit_minim_chars;
		$lists["limit_maxim_chars"] = _ART_SET_limit_maxim_chars;
		// <== since 1.5.6

		// ==> since 1.5.7
		$lists["art_mail_from_name"] = '<input type="text" name="art_mail_from_name" style="width:290px;" value="'._ART_SET_mail_from_name.'"> ';
		$lists["art_mail_from_email"] = '<input type="text" name="art_mail_from_email" style="width:290px;" value="'._ART_SET_mail_from_email.'"> ';

		$lists["art_allow_author_image"] = JHTML::_('select.booleanlist', 'art_allow_author_image','class="inputbox"',_ART_SET_allow_author_image);
		$lists["art_author_image_extensions"] = '<input type="text" name="art_author_image_extensions" style="width:290px;" value="'._ART_SET_allowed_extensions.'"> ';
		$lists["art_author_max_size"] = '<input type="text" name="art_author_max_size" style="width:290px;" value="'._ART_SET_max_size.'"> ';
		$lists['art_enable_ordering']=JHTML::_('select.booleanlist', 'art_enable_ordering','class="inputbox"',_ART_SET_enable_ordering);
		// <== since 1.5.7
		
		
		
		$aGroups=array();
		$aGroups = JHTML::_('select.option',0,'Select group...');
		$database->setQuery("SELECT `node`.`id` AS value, CONCAT( REPEAT('&nbsp;&nbsp;', COUNT(`parent`.`name`) - 1), `node`.`name`) AS text ".
							" FROM `#__core_acl_aro_groups` AS node, ".
							" `#__core_acl_aro_groups` AS parent ".
							" WHERE `node`.`lft` BETWEEN `parent`.`lft` AND `parent`.`rgt` ".
							//remove ROOT(id=17) and USERS(id=28) groups
							" AND `node`.`id` NOT IN (17,28) ".
							" GROUP BY `node`.`name` ".
							" ORDER BY `node`.`lft` ");
		$aGroups = $database->loadAssocList();
		$lists['restrict_groups'] = JHTML::_('select.genericlist',$aGroups,'restrict_group','size="'.count($aGroups).'" onchange="if(this.value){enableElement(\'restrict_section\')}else{disableElement(\'restrict_section\')}" ');
		
		
		$database->setQuery("SELECT `id` AS value,`title` AS text FROM `#__sections` ORDER BY `ordering`");
		$aSections = $database->loadAssocList();
		$xMethods['retrievecategories']->setParameter(0,XAJAX_JS_VALUE,'this.value');
		$lists['restrict_sections'] = JHTML::_('select.genericlist',$aSections,'restrict_section','disabled="" size="'.count($aSections).'" onchange="disableElement(\'apply_restriction\');'.$xMethods['retrievecategories']->getScript().'" ');
		
		$xMethods['saverestriction']->setParameter(0,XAJAX_JS_VALUE,'document.getElementById(\'restrict_group\').value');
		$xMethods['saverestriction']->setParameter(1,XAJAX_JS_VALUE,'getMultipleSelectValues(\'restrict_categories\')');
		
		
		//==> get sections
    	$query = "SELECT s.id, s.title"
    	. "\n FROM #__sections AS s"
    	. "\n ORDER BY s.ordering";
    	$database->setQuery( $query );
   		$sections = $database->loadObjectList();
       	$lists['sections'] = $sections;
       	//<== get sections

       	//==> get categories
    	$query = "SELECT id, title"
    	. "\n FROM #__categories"
    	. "\n ORDER BY ordering";
    	$database->setQuery( $query );
   		$categories = $database->loadObjectList();
       	$lists['categories'] = $categories;
       	//<== get categories
       	

       	$restrictedSections = explode(";", _ART_SET_restricted_sections);
       	$restrictedCategories = explode(";", _ART_SET_restricted_categories);
       	
       	//===> get category names for selected categories
       	$restrictedCategoriesNames = array();
       	foreach ($restrictedCategories as $k => $category)
       	{
       		$categoryLists = explode(",", $category);
       		$categoryNameLists = "";
       		foreach ($categoryLists as $ch => $categ)
       		{
		    	$query = "SELECT title"
		    	. "\n FROM #__categories WHERE id = '{$categ}'";
		    	$database->setQuery( $query );
		   		$category_obj = $database->loadAssoc();
			   		if($categoryNameLists !="")
			   			$categoryNameLists .= ",";
	       			$categoryNameLists .= $category_obj["title"];
       		}
       		$restrictedCategoriesNames[$k] = $categoryNameLists;
       	}
       	//<=== get category names for selected categories
       	
       	//===> get section names for selected sections
       	$restrictedSectionNames = array();
       	foreach ($restrictedSections as $k => $section)
       	{
       		$sectionLists = explode(",", $section);
       		$sectionNameLists = "";
       		foreach ($sectionLists as $ch => $sect)
       		{
		    	$query = "SELECT s.id, s.title"
		    	. "\n FROM #__sections AS s WHERE id = '{$sect}'";
		    	$database->setQuery( $query );
		   		$sect_obj = $database->loadAssoc();
		   		if($sectionNameLists !="")
		   			$sectionNameLists .= ",";
       			$sectionNameLists .= $sect_obj["title"];
       		}
       		$restrictedSectionNames[$k] = $sectionNameLists;
       	}
       	//<=== get category names for selected categories
       	
       	$restrictedGroups = explode(";", _ART_SET_restricted_group);
       	$restrictedGroupsList = array();
       	foreach ($restrictedGroups as $key => $value)
       	{
       		$restrictedGroupsList[] = $acl->get_group_name($value);
       	}
       	
       	$lists["restricted_sections_to_group"] = $restrictedSectionNames;
       	$lists["restricted_categories_to_group"] = $restrictedCategoriesNames;
		$lists["group_restricted"] = $restrictedGroups;
		$lists["group_restricted_names"] = $restrictedGroupsList;
		
       	if(count($restrictedGroups) > 1 || (count($restrictedGroups) == 1 && isset($restrictedGroups[0][0]) && $restrictedGroups[0][0]!=""))
			$lists["no_of_groups_restricted"] = count($restrictedGroups);
		else
			$lists["no_of_groups_restricted"] = 0;

		/* remove existing groups restricted */
		$groups = $acl->get_group_children_tree( null, 'USERS', false );
		foreach ($groups as $ki => $val){
			if(strpos(_ART_SET_restricted_group, $val->value) !==false)
			{
				unset($groups[$ki]);
			}
		}
		/* remove existing groups restricted */
		
		$lists["groups"] = $groups;
	    $lists['rejectAuthorEmail']=JHTML::_('select.booleanlist', 'rejectAuthorEmail','class="inputbox"',_ART_SET_rejectAuthorEmail);
	    $lists['acceptAuthorEmail']=JHTML::_('select.booleanlist', 'acceptAuthorEmail','class="inputbox"',_ART_SET_acceptAuthorEmail);
	    $lists['pendingAuthor']=JHTML::_('select.booleanlist', 'pendingAuthor','class="inputbox"',_ART_SET_pendingAuthor);
		$lists['pendingAdmin']=JHTML::_('select.booleanlist', 'pendingAdmin','class="inputbox"',_ART_SET_pendingAdmin);
		$lists['unpublishEmail']=JHTML::_('select.booleanlist', 'unpublishEmail','class="inputbox"',_ART_SET_unpublishEmail);
		
		$lists['alert_words']="<textarea id='alert_words' name='alert_words' style='height:100px; width:300px;'>"._ART_SET_alert_words."</textarea>";

	    $database->setQuery("select * from #__art_emailtmpl");
	    $templates=$database->loadObjectList();
	    
	    for ($i=0;$i<count($templates);$i++){
	        $lists[$templates[$i]->type.'_subject']=$templates[$i]->subject;
	        $lists[$templates[$i]->type.'_body']=$templates[$i]->template;
		}
		
		$fields = array();
		$database->setQuery("SELECT COUNT(*) FROM `#__components` WHERE `option`='com_comprofiler'");
		if($database->loadResult()){
			$query = "SELECT `name` as value,concat(`name`,concat(' - ',title)) as text FROM #__comprofiler_fields where sys=0 or type='image'";
		    $database->setQuery($query);
			$fields = $database->loadObjectList();
			$fields = array_merge(array(JHTML::_('select.option','','-'.JText::_("AMAN_SELECT_CBFIELD").'-')),$fields);
		}

	    $lists["fields"] = $fields;
		
	    // since 1.7.4
	    $lists['allowalias']=JHTML::_('select.booleanlist', 'allowalias','class="inputbox"',_ART_SET_allowalias);
	    $lists['usecheckin']=JHTML::_('select.booleanlist', 'usecheckin','class="inputbox"',_ART_SET_usecheckin);
	    $lists['showcreationdate']=JHTML::_('select.booleanlist', 'showcreationdate','class="inputbox"',_ART_SET_showcreationdate);
	    
	    // since 1.7.5
	    $lists['ticketpreapproval']=JHTML::_('select.booleanlist', 'ticketpreapproval','class="inputbox"',_ART_SET_ticketpreapproval);
	    $lists['onesuperadminonly']=JHTML::_('select.booleanlist', 'onesuperadminonly','class="inputbox"',_ART_SET_onesuperadminonly);
	    
	    $lists['xmethods'] =& $xMethods;
	    
		HTML_adminArticleman::configForm($lists);
	}
	
	function saveArticle()
	{
		global $option,$mainframe;

		$database = &JFactory::getDBO();
		$articol = & JTable::getInstance('content');
		
		$id=JArrayHelper::getValue($_REQUEST,"id",'');
		$getnextpending=JArrayHelper::getValue($_REQUEST,"getnextpending",0);

		if (!$id || !$articol->load($id)){
			mosRedirect("index2.php?option=$option",JText::_('AMAN_ERR_ARTICLE_REJECTED'));exit;
		}

		$articol->title = stripslashes(JArrayHelper::getValue($_REQUEST,"title",""));
		$articol->introtext = stripslashes(JArrayHelper::getValue($_REQUEST,"introtext",""));
		$articol->fulltext = stripslashes(JArrayHelper::getValue($_REQUEST,"maintext",""));
		$articol->sectionid = JArrayHelper::getValue($_REQUEST,"sectionid");
		$articol->catid = JArrayHelper::getValue($_REQUEST,"catid");
		$articol->created_by = JArrayHelper::getValue($_REQUEST,"created_by");
		$articol->created_by_alias = JArrayHelper::getValue($_REQUEST,"authoralias");

		$articol->metadesc= JArrayHelper::getValue($_REQUEST,"metadesc");
		$articol->metakey= JArrayHelper::getValue($_REQUEST,"metakey");
		
		$articol->created= JArrayHelper::getValue($_REQUEST,"created");
		$articol->publish_up= JArrayHelper::getValue($_REQUEST,"publish_up");
		$articol->publish_down= JArrayHelper::getValue($_REQUEST,"publish_down");
		
		$articol->state=1;

     	if (!$articol->check()) {
    		echo "<script> alert('".$articol->getError()."'); window.history.go(-1); </script>\n";
    		exit();
    	}
    	if (!$articol->store()) {
    		echo "<script> alert('".$articol->getError()."'); window.history.go(-1); </script>\n";
    		exit();
    	}

		$database->setQuery("select count(*) from #__art_articles_ref where articleid='$id'");
		if($database->loadResult()>0){
    		$database->setQuery("update #__art_articles_ref set state='normal',reason='' where articleid='$id'");

		}else{
    		$database->setQuery("insert into #__art_articles_ref set state='normal' , articleid='$id'");

		}
		$database->query();
        
		// manage frontpage items
		require_once(JPATH_ADMINISTRATOR. DS . 'components' . DS . 'com_frontpage' . DS . 'tables' . DS . 'frontpage.php' );
    	
    	$fp = new TableFrontPage( $database );
		//$fp = new JTable('#__content_frontpage', 'id', $database);

		if (intval( JArrayHelper::getValue( $_REQUEST, 'frontpage', 0 ) )) {
    		// toggles go to first place
    		if (!$fp->load( (int)$articol->id )) {
    			// new entry
    			$query = "INSERT INTO #__content_frontpage"
    			. "\n VALUES ( " . (int) $articol->id . ", 1 )"
    			;
    			$database->setQuery( $query );
    			if (!$database->query()) {
    				echo "<script> alert('".$database->stderr()."');</script>\n";
    				exit();
    			}
    			$fp->ordering = 1;
    		}
    	} else {
    		// no frontpage mask
    		if (!$fp->delete( (int)$articol->id )) {
    			$msg .= $fp->stderr();
    		}
    		$fp->ordering = 0;
    	}
    	$fp->reorder();

    	$articol->checkin();
        if (_ART_SET_acceptAuthorEmail)
      		$this->sendMail($articol,'publish');

        if($getnextpending){
			$database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
			
			$id=$database->loadResult();
			if($id){
				$mainframe->redirect("index2.php?option=$option&task=editart&id=".$id);
				return;
            }
        }
		$mainframe->redirect("index2.php?option=$option",JText::_('AMAN_ARTICLE_SAVED'));
	}

	function rejectArt()
    {
        global $option, $mainframe;

		$database = &JFactory::getDBO();
		
        $id=JRequest::getVar('id');
        $cid=JRequest::getVar('cid');
        
		$getnextpending=JRequest::getVar("getnextpending");
        $reason=addslashes(JRequest::getVar('reason'));

        $msg=$this->rejectArticle($id,$reason);
        if($id!="") {
			$getnextpending=JRequest::getVar("getnextpending");
	        $reason=addslashes(JRequest::getVar('reason'));
	        
            $database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
            $id=$database->loadResult();
            $mainframe->redirect("index2.php?option=$option&task=editart&id=".$id, $msg);
        }elseif (is_array($cid)) {
        	foreach($cid as $key => $id){
		
		        $msg=$this->rejectArticle($id,$reason);
		        if($getnextpending){
		            $database->setQuery("select articleid from #__art_articles_ref where state='pending' order by articleid");
		            $id=$database->loadResult();
		        }
        	}
		    $mainframe->redirect("index2.php?option=$option", $msg);
        }else
		  $mainframe->redirect("index2.php?option=$option",$msg);
    }
    
	function listReasons()
    {
		$database = &JFactory::getDBO();
        
        $database->setQuery("select * from #__art_reason order by title");
        $rows=$database->loadObjectList();

        HTML_adminArticleman::ListReasons($rows);
    }
    
	function editReason()
    {
		$database = &JFactory::getDBO();
        
        $id=JRequest::getVar('id');
        $database->setQuery("select * from #__art_reason where id='$id'");
        $row=null;
        $row = $database->loadObject();

        HTML_adminArticleman::EditReason($row);
    }
    
	function saveReason()
    {
    	global $mainframe;
		$database = &JFactory::getDBO();
        
        $id=JRequest::getVar('id');
        
        $title=JArrayHelper::getValue($_REQUEST, "title", "");
        $reason=JArrayHelper::getValue($_REQUEST, "reason", "");
        $toolbar=JRequest::getVar('toolbar');

        if($id){
			$database->setQuery("update #__art_reason set title='$title',reason='$reason', toolbar ='$toolbar' where id='$id'");
        }else{
        	$database->setQuery("insert into  #__art_reason set  title='$title',reason='$reason', toolbar ='$toolbar'");
        }
        $database->query();
        $mainframe->redirect("index2.php?option=com_articleman&task=listReasons",'');
    }
    
	function newReason()
    {
        $row=new stdClass();
        $row->title='';
        $row->reason='';
        $row->id='';
        HTML_adminArticleman::EditReason($row);
    }
    
	function deleteReason()
    {
    	global $mainframe;
		$database = &JFactory::getDBO();
		
        $cid=JRequest::getVar('cid');
        if (is_array($cid)){
            $id=implode(',',$cid);
        }else $id=$cid;
        $database->setQuery("delete from #__art_reason where id in ($id)");
        $database->query();

        $mainframe->redirect("index2.php?option=com_articleman&task=listReasons",'');
    }
    
	function AboutArticle()
    {
        global $option;
        require_once( JPATH_SITE. DS . "administrator" . DS . "components" . DS . "$option" . DS . "version_info.php");
        $version=new component_version_info($option);
    	HTML_adminArticleman::showAbout( $option,$version);
    }
    
    
}
?>