var aktiverKalender = null;

function makeKal(xElm){
	if(aktiverKalender != null)
	{
		aktiverKalender.delKal();
		aktiverKalender = null;
	}
	aktiverKalender = new MyKalender(xElm);
}

function MyKalender(xElm){
	
	var myKal = this;
	this.feld=xElm;
	this.icon = this.initIcon();
	this.bg = null;
	this.div = null;
	this.content = null;
	this.icon.onclick = function(ev)
	{
		myKal.initKal();
		myKal.bg.onclick = function(){
			myKal.closeKal();
		}
		myKal.buildContent();
	}
	
}

MyKalender.prototype.delKal = function(){
	if(this.icon){
		this.icon.parentNode.removeChild(this.icon);
	}
	if(this.bg){
		this.bg.parentNode.removeChild(this.bg);
	}
	if(this.div){
		this.div.parentNode.removeChild(this.div);
	}
}


MyKalender.prototype.buildContent = function(){
	var myKal = this;
	
	//Kreuz zum schlieen oben rechts erstellen.
	var closeIcon = document.createElement('img');	
	closeIcon.src = 'Images/icon/cancel.png';
	closeIcon.className = 'kalenderCloseIcon';
	var div1 = document.createElement('div');
	var span1 = document.createElement('span');
	var span2 = document.createElement('span');
	span1.innerHTML = 'Kalender';
	span1.className = 'kalenderTitelBarText1';
	span2.className = 'kalenderTitelBarText2';
	div1.className = 'kalenderTitelBar';
	this.div.appendChild(div1);
	div1.appendChild(span1);
	div1.appendChild(span2);
	span2.appendChild(closeIcon);
	
	
	//function fr schlieen
	closeIcon.onclick = function(){
		myKal.closeKal();
	}
	
	//bereich fr den Content erstellen
	var content = document.createElement('div');
	content.className = 'kalenderContent';
	this.div.appendChild(content);
	this.content = content;
	content.innerHTML = 'test';
	var datum = new Date();
	this.loadContent('11','2007');
	
}

MyKalender.prototype.loadContent = function(Monat,Jahr){
	var myKal = this;
	
	Monatsname = new Array("Januar", "Februar", "Mrz", "April", "Mai", "Juni", "Juli","August", "September", "Oktober", "November", "Dezember");
  	Tag = new Array("Mo", "Di", "Mi", "Do", "Fr", "Sa", "So");
	
	//vorhandenen Daten lschen
	this.content.innerHTML = '';
	
	//aktuellen Kalender ausgeben und dafr sorgen, das man rechts und links weiter zum nchsten klicken kann.
	//Auch muss dafr gesorgt werden, das wenn man auf ein Datum klickt, das dann der Content fr das Textfeld gesetzt wird.
	
	
	var Zeit = new Date(Jahr, Monat-1, 1);
  	var Start = Zeit.getDay();
	
	//anzahl der Tage fr den Monat ermitteln
	var Stop = 31;
	if (Monat == 4 || Monat == 6 || Monat == 9 || Monat == 11){
		--Stop;	
	}	    
	if(Monat == 2) {
		Stop = Stop - 3;
	    if (Jahr % 4 == 0){
	    	Stop++;	    	
	    }	      
	    if (Jahr % 100 == 0){
	    	Stop--;	    	
	    }	      
	    if (Jahr % 400 == 0){
	    	Stop++;	    	
	    }	      
	 }
	 //Anzahl der Wochen
	 var Wochen = Math.ceil(Stop/7);
	 
	 var Content = null;
	 var MonatsTag = 0;
	 var tmpDiv = null;
	 
	 //Header mit auswahlfunktion algen
	 var Header = document.createElement("div");
	 Header.className = 'kalenderContentDiv1';
	 var MonatName = document.createElement('div');
	 MonatName.appendChild(document.createTextNode(Monatsname[Monat-1] + " " + Jahr));
	 MonatName.className = 'kalenderMonatName';
	 var Last = document.createElement('div');
	 Last.className = 'kalenderLastMonth';
	 Last.appendChild(document.createTextNode('<'));
	 Last.onclick = function(){
	 	if(parseInt(Monat) == 1)
	 	{
	 		var lastMonat = 12;
	 		var lastJahr = parseInt(Jahr) - 1;
	 	}
	 	else
	 	{
	 		var lastMonat = parseInt(Monat)-1;
	 		var lastJahr = parseInt(Jahr);
	 	}
	 	myKal.loadContent(lastMonat,lastJahr);	
	 }
	 var Next = document.createElement('div');
	 Next.className = 'kalenderNextMonth';
	 Next.appendChild(document.createTextNode('>'));
	 Next.onclick = function(){
	 	if(parseInt(Monat) == 12)
	 	{
	 		var nextMonat = 1;
	 		var nextJahr = parseInt(Jahr) + 1;
	 	}
	 	else
	 	{
	 		var nextMonat = parseInt(Monat)+1;
	 		var nextJahr = parseInt(Jahr);
	 	}
	 	myKal.loadContent(nextMonat,nextJahr);	
	 }
	 Header.appendChild(Last);
	 Header.appendChild(MonatName);
	 Header.appendChild(Next);
	 this.content.appendChild(Header);
	 
	//Kalender befllen
	Content = document.createElement('div');
	
	//Beschriftung vn Mo - So
	tmpDiv = document.createElement("div");
	tmpDiv.className = 'kalenderContentDiv2';
	for(var u = 0; u < 7; u=u+1)
	{
		tmpDiv.appendChild(this.kalElmHead(Tag[u]));
 	}
	Content.appendChild(tmpDiv);
	
	//kalender befllen
	Tag = 0;	
	for(var i = 0; i < Wochen; i=i+1)
	{		
	 	tmpDiv = document.createElement("div");
	 	tmpDiv.className = 'kalenderContentDiv2';
	 	for(var o = 0; o < 7; o=o+1)
	 	{
	 		Tag = Tag + 1;
	 		if((Tag >= Start) && (MonatsTag <= Stop))
	 		{
	 			MonatsTag++;
	 			tmpDiv.appendChild(this.kalElm(MonatsTag,MonatsTag + "." + Monat + "." + Jahr));
	 		}
	 		else
	 		{
	 			tmpDiv.appendChild(this.kalElm());
	 		} 
	 	}
	 	Content.appendChild(tmpDiv);
	 }
	 this.content.appendChild(Content);
}

MyKalender.prototype.kalElm = function(zahl,datum){
	var myKal = this;
	
	var tmp = document.createElement("span");
	tmp.className = "kalenderElm";
	if(!isNaN(zahl))
	{
		var text = document.createTextNode(zahl);
		tmp.appendChild(text);
		tmp.className = 'kalenderElmMitDatum';
		tmp.onclick = function(){		
			myKal.feld.value =  datum;
			myKal.closeKal();
		}
	}
	
	return tmp;
}

MyKalender.prototype.kalElmHead = function(tag){
	var myKal = this;
	
	var tmp = document.createElement("span");
	tmp.className = "kalenderElmHead";
	var text = document.createTextNode(tag);
	tmp.appendChild(text);
		
	
	return tmp;
}

MyKalender.prototype.initIcon = function(){
	var feld = this.feld;
	var feldHeight = feld.offsetHeight;
	var feldWidth = feld.offsetWidth;
	var feldPosX = 0;
    var feldPosY = 0;
    var theElement = feld;
    if (!theElement) return;
    while(theElement != null){
    	feldPosX += theElement.offsetLeft;
      	feldPosY += theElement.offsetTop;
      	theElement = theElement.offsetParent;
    }
    
    if(feldHeight-20 > 0)
    {
    	var tmp_height = (feldHeight-20)/2;
    }
    else
    {
    	var tmp_height = 0;
    }
 	   
    var iconPosX = feldPosX+feldWidth-20;
    var iconPosY = feldPosY+tmp_height;
    
    var icon = document.createElement('img');
    icon.src = "Images/icon/kal.png";
    icon.className = "kalenderIcon";
    if(document.all)
    {
    	icon.style.top = iconPosY;
    	icon.style.left = iconPosX;	
    }
    else
    {
    	icon.style.top = iconPosY+"px";
    	icon.style.left = iconPosX+"px";	
    }
    document.getElementById('window').appendChild(icon);
    return icon;
}

MyKalender.prototype.initKal =  function(){
	var icon = this.icon;
	var feld = this.feld;
	var myKal = this;
	
	var background = document.createElement("div");
	background.className = "kalenderBG";
		
	var div = document.createElement('div');
	div.className = "kalenderDIV";
	
	
	
	var iconHeight = icon.offsetHeight;
	var iconWidth = icon.offsetWidth;
	var feldPosX = 0;
    var feldPosY = 0;
    var theElement = icon;
    if (!theElement) return;
    while(theElement != null){
    	feldPosX += theElement.offsetLeft;
      	feldPosY += theElement.offsetTop;
      	theElement = theElement.offsetParent;
    }
    
     	   
    var kalPosX = feldPosX;
    var kalPosY = feldPosY;
    
    if(document.all)
    {
    	div.style.top = kalPosY;
    	div.style.left = kalPosX;
    }
    else
    {
    	div.style.top = kalPosY+"px";
    	div.style.left = kalPosX+"px";	
    }
        
	document.getElementById('window').appendChild(background);
	document.getElementById('window').appendChild(div);
	this.div = div;
	this.bg = background;

}

MyKalender.prototype.closeKal = function(){
	this.bg.parentNode.removeChild(this.bg);
	this.bg = null;
	this.div.parentNode.removeChild(this.div);
	this.div = null;
}

