<?php
$bbcode_image_max_width = "400";
$bbcode_image_max_height = "600";
$bbcode_erlaubte_endungen = Array("jpg","jpeg","gif","png","bmp");
$bbcode_erlaubte_endungen_typ = Array("1","2","3","4");
$bbcode_autoresize = true;
$bbcode_image_security_level_1 = true; // Es wird �berpr�ft ob die Endung erlaubt ist
$bbcode_image_security_level_2 = false; // Sicherheitsstufe 1 muss aktiviert sein, und es wird dann �berpr�ft ob es sich um einen erlaubten Bildtypen handelt, anhand einer Typ bestimmung
$bbcode_phpcode_border = "#000000";
$bbcode_phpcode_bg1 = "#EEEEEE";

function ersatz_bbcode($string,$modul = "text,image,php,link")
{
	$module = split(",",$modul);
	if(in_array("text",$module))
	{
		$string = bbcode_text($string);
	}
	
	if(in_array("link",$module))
	{
		$string = bbcode_setze_link($string);
	}	
	echo $string = eregi_replace("\\[img=([^\\[]*)\\]","\\[img\\]\\1\\[/img\\]",$string);
	if(in_array("image",$module))
	{
		$string = bbcode_image_resize($string);
	}
	
	if(in_array("php",$module))
	{
		$string = bbcode_php($string);
	}
	
	return $string;
}

function bbcode_setze_link($text) 
{
	$p[] = '"(( |^|=)((ftp|http|https|irc|hlsw|){1}://)[-a-zA-Z0-9@:%_+.~#?&//=]+)"i';
  	$r[] = '<a href="\1" target="_blank">\1</a>';
  	$p[] = '"( |^)(www.[-a-zA-Z0-9@:%_+.~#?&//=]+)"i';
  	$r[] = '\1<a href="http://\2" target="_blank">\\2</a>';
  	$text = preg_replace($p, $r, $text);
  	return $text;
}
	
function bbcode_check_string($string) 
{                
    // erlaubte zeichen a-z,A-Z,0-9,-,_                
    if((preg_match('/^[a-zA-Z0-9\-\_\\]+$/',$string))) return true;                
    return false;            
} 

function replacement($content, $bbcode=true, $image=true, $url=true,$php=true) 
{
	$content = nl2br(htmlspecialchars($content));
	$content = str_replace("["," [",$content);
	$content = str_replace("]","] ",$content);
	$content = str_replace("[img] ","[img]",$content);
	$content = str_replace(" [/img]","[/img]",$content);
	$content = eregi_replace("\\[img=([^\\[]*)\\]","[img]\\1[/img]",$content);
	if($php)
	{
		$content = bbcode_php($content);
	}
	
	if($image)
	{
		$content = bbcode_image_resize($content);
	}
	else
	{
		$content = eregi_replace("\\[img\\]([^\\[]*)\\[/img\\]","<img align=\"left\" src=\"\\1\" border=\"0\">",$content);	
	}
	
	if($bbcode) 
	{		
		$content = preg_replace("#\[url\]http://(.*?)\[img\]http://(.*?)\[/img\]\[/url\]#si", "<a href=\"http://\\1\" target=\"_blank\"><img src=\"http://\\2\" border=\"0\"></a>", $content);
		$content = preg_replace("#\[url\]www.(.*?)\[img\]www.(.*?)\[/img\]\[/url\]#si", "<a href=\"http://www.\\1\" target=\"_blank\"><img src=\"http://www.\\2\" border=\"0\"></a>", $content);    
		$content = preg_replace("#\[url=http://(.*?)\]\[img\]http://(.*?)\[/img\]\[/url\]#si", "<a href=\"http://\\1\" target=\"_blank\"><img src=\"http://\\2\" border=\"0\"></a>", $content);
		$content = preg_replace("#\[url=www.(.*?)\]\[img\]www.(.*?)\[/img\]\[/url\]#si", "<a href=\"http://www.\\1\" target=\"_blank\"><img src=\"http://\\2\" border=\"0\"></a>", $content);
	  	$content = preg_replace("#\[url\]http://(.*?)\[/url\]#si", "<a href=\"http://\\1\" target=\"_blank\">\\1</a>", $content);            // [url]http://.......[/url]
		$content = preg_replace("#\[url\]www.(.*?)\[/url\]#si", "<a href=\"http://\\1\" target=\"_blank\">http://www.\\1</a>", $content);    // [url]www...........[/url]
		$content = preg_replace("#\[url=http://(.*?)\](.*?)\[/url\]#si", "<a href=\"http://\\1\" target=\"_blank\">\\2</a>", $content);      // [url=http://..]link[/url]
		$content = preg_replace("#\[url=www.(.*?)\](.*?)\[/url\]#si", "<a href=\"http://www.\\1\" target=\"_blank\">\\2</a>", $content);     // [url=www......]link[/url]
		$content = preg_replace("#\[url=(.*?)\](.*?)\[/url\]#si", "<a href=\"\\1\">\\2</a>", $content);      // relativer link
		$content = preg_replace("#\[url\](.*?)\[/url\]#si", "<a href=\"\\1\">\\1</a>", $content);      // relativer link
	}
	
	if($url)
	{
		$content = preg_replace("#(^|[^\"=]{1})(http://|https://|ftp://|mailto:|news:)([^\s<>]+)([\s\n<>]|$)#sm","\\1<a href=\"\\2\\3\" target=\"_blank\">\\3</a>\\4",$content);
	}
	
	if($bbcode) 
	{	
		$content = preg_replace("#\[email\](.*?)\[/email\]#si", "<a href=\"mailto:\\1\">\\1</a>", $content);
		$content = preg_replace("#\[email=(.*?)\](.*?)\[/email\]#si", "<a href=\"mailto:\\1\">\\2</a>", $content);
		$content = preg_replace("#\[size=(.*?)\](.*?)\[/size\]#si", "<font size=\"\\1\">\\2</font>", $content);
		$content = preg_replace("#\[color=(.*?)\](.*?)\[/color\]#si", "<font color=\"\\1\">\\2</font>", $content);
		$content = preg_replace("#\[font=(.*?)\](.*?)\[/font\]#si", "<font face=\"\\1\">\\2</font>", $content);
		$content = preg_replace("#\[align=(.*?)\](.*?)\[/align\]#si", "<div align=\"\\1\">\\2</div>", $content);
	  	$content = preg_replace("#\[b\](.*?)\[/b\]#si", "<b>\\1</b>",$content); 
	  	$content = preg_replace("#\[i\](.*?)\[/i\]#si", "<i>\\1</i>",$content); 
	  	$content = preg_replace("#\[u\](.*?)\[/u\]#si", "<u>\\1</u>",$content); 
	  	$content = preg_replace("#\[s\](.*?)\[/s\]#si", "<s>\\1</s>",$content); 
	  	$content = preg_replace("#\[pre\](.*?)\[/pre\]#si","<pre>\\1</pre>", $content);
	  	$content = preg_replace("#\[list\](.*?)\[/list\]#si", "<ul>\\1</ul>", $content); 
	  	$content = preg_replace("#\[list=1\](.*?)\[/list=1\]#si", "<ol>\\1</ol>", $content);
	  	$content = preg_replace("#\[list=a\](.*?)\[/list=a\]#si", "<ol type=\"a\">\\1</ol>", $content);
		$content = preg_replace("#\[\*\](.*?)\[/\*\]#si", "<li>\\1</li>", $content);
		$content = preg_replace("#\[br]#si", "<br>", $content);
		$content = preg_replace("#\[hr]#si", "<hr noshade color=\"$border\" size=\"1\">", $content);
		$content = preg_replace("#\[center]#si", "<center>", $content);
		$content = preg_replace("#\[/center]#si", "</center>", $content);
		$content = str_replace("[justify]","<b>",$content);
	    $content = str_replace("[/justify]","</b>",$content);
	    $content = str_replace("[u]","<u>",$content);
	    $content = str_replace("[/u]","</u>",$content);
	    $content = str_replace("[i]","<i>",$content);
	    $content = str_replace("[/i]","</i>",$content);
	    $content = str_replace("[B]","<b>",$content);
	    $content = str_replace("[/B]","</b>",$content);
	    $content = str_replace("[U]","<u>",$content);
	    $content = str_replace("[/U]","</u>",$content);
	    $content = str_replace("[I]","<i>",$content);
	    $content = str_replace("[/I]","</i>",$content);
	    $content = str_replace("[h1]","<h1>",$content);
	    $content = str_replace("[/h1]","</h1>",$content);
	    $content = str_replace("[h2]","<h2>",$content);
	    $content = str_replace("[/h2]","</h2>",$content);
	    $content = str_replace("[h3]","<h3>",$content);
	    $content = str_replace("[/h3]","</h3>",$content);
	    $content = str_replace("[h4]","<h4>",$content);
	    $content = str_replace("[/h4]","</h4>",$content);
	    $content = str_replace("[h5]","<h5>",$content);
	    $content = str_replace("[/h5]","</h5>",$content);
	    $content = str_replace("[h6]","<h6>",$content);
	    $content = str_replace("[/h6]","</h6>",$content);
	    $content = str_replace("[hr]","<hr />",$content);
	    $content = str_replace("[pre]","<pre>",$content);
	    $content = str_replace("[/pre]","</pre>",$content);
	    $content = str_replace("[adress]","<adress>",$content);
	    $content = str_replace("[/adress]","</adress>",$content);
	    $content = str_replace("[ul]","<ul>",$content);
	    $content = str_replace("[/ul]","</ul>",$content);
	    $content = str_replace("[ol]","<ol>",$content);
	    $content = str_replace("[/ol]","</ol>",$content);
	    $content = str_replace("[li]","<li>",$content);
	    $content = str_replace("[/li]","</li>",$content);
	    $content = str_replace("[blockquote]","<blockquote>",$content);
	    $content = str_replace("[/blockquote]","</blockquote>",$content);
	    $content = str_replace("[sup]","<sup>",$content);
	    $content = str_replace("[/sup]","</sup>",$content);
	    $content = str_replace("[sub]","<sub>",$content);
	    $content = str_replace("[/sub]","</sub>",$content);
	    $content = str_replace("[center]", "<center>",$content);
	    $content = str_replace("[/center]", "</center>",$content);
	    $content = str_replace("[strike]", "<strike>",$content);
	    $content = str_replace("[/strike]", "</strike>",$content);
	    $content = str_replace("[left]", "<div align=\"left\">", $content);
	    $content = str_replace("[/left]", "</div>", $content);
	    $content = str_replace("[right]", "<div align=\"right\">", $content);
	    $content = str_replace("[/right]", "</div>", $content);
	    $content = str_replace("[quote]","<div align=\"left\" class=\"quotetop\">Quote:</div><blockquote class=\"quotemain\">",$content);
	    $content = str_replace("[/quote]","</blockquote>",$content);
	    //$content = eregi_replace("\\[url\\]([^\\[]*)\\[/url\\]","<a href=\\1 target=_blank>\\1</a>", $content);
	    $content = eregi_replace("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" target=\"_blank\">\\2</a>",$content);
	    //$content = eregi_replace("\\[img=([^\\[]*)\\]","<img align=\"left\" src=\"\\1\" border=\"0\">",$content);
	    //$content = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<font color=\\1>\\2</font>",$content);
	    $content = eregi_replace("\\[bgcolor=([^\\[]*)\\]([^\\[]*)\\[/bgcolor\\]","<span style=\"background-color:\\1;\">\\2</span>",$content);
	    $content = eregi_replace("\\[farbe=([^\\[]*)\\]([^\\[]*)\\[/farbe\\]","<font color=\"\\1\">\\2</font>",$content);
	    $content = eregi_replace("\[email\]([^\[]*)\[/email\]","<a href='mailto:\\1'>\\1</a>", $content);
	    $content = eregi_replace("\\[font=([^\\[]*)\\]([^\\[]*)\\[/font\\]","<font face=\"\\1\">\\2</font>",$content);
	    $content = str_replace("[c]","<code>",$content);
	    $content = str_replace("[/c]","</code>",$content);
	    $content = str_replace("[small]","<small>",$content);
	    $content = str_replace("[/small]","</small>",$content);
	    $content = str_replace("[large]","<font size=\"2\">",$content);
	    $content = str_replace("[/large]","</font>",$content);
		$content = eregi_replace("\\[farbe=([^\\[]*)\\]","<font color=\"\\1\">",$content);
		$content = eregi_replace("\\[/farbe\\]","</font>",$content);	
	}
	$content = str_replace("&amp;","&",$content);
	$content = smilie($content);
	$content = bbcode_land($content);
	
	return $content;
}

function bbcode_text($string)
{            
    $string = nl2br(htmlspecialchars($string));
    //$string = str_replace("&lt;","<",$string);
    //$string = str_replace("&gt;",">",$string);
    $string = str_replace("&#039;","'",$string);
    $string = str_replace("&quot;","\"",$string);
    $string = str_replace("[b]","<b>",$string);
    $string = str_replace("[/b]","</b>",$string);
    $string = str_replace("[u]","<u>",$string);
    $string = str_replace("[/u]","</u>",$string);
    $string = str_replace("[i]","<i>",$string);
    $string = str_replace("[/i]","</i>",$string);
    $string = str_replace("[B]","<b>",$string);
    $string = str_replace("[/B]","</b>",$string);
    $string = str_replace("[U]","<u>",$string);
    $string = str_replace("[/U]","</u>",$string);
    $string = str_replace("[I]","<i>",$string);
    $string = str_replace("[/I]","</i>",$string);
    $string = str_replace("[h1]","<h1>",$string);
    $string = str_replace("[/h1]","</h1>",$string);
    $string = str_replace("[h2]","<h2>",$string);
    $string = str_replace("[/h2]","</h2>",$string);
    $string = str_replace("[h3]","<h3>",$string);
    $string = str_replace("[/h3]","</h3>",$string);
    $string = str_replace("[h4]","<h4>",$string);
    $string = str_replace("[/h4]","</h4>",$string);
    $string = str_replace("[h5]","<h5>",$string);
    $string = str_replace("[/h5]","</h5>",$string);
    $string = str_replace("[h6]","<h6>",$string);
    $string = str_replace("[/h6]","</h6>",$string);
    $string = str_replace("[hr]","<hr />",$string);
    $string = str_replace("[pre]","<pre>",$string);
    $string = str_replace("[/pre]","</pre>",$string);
    $string = str_replace("[adress]","<adress>",$string);
    $string = str_replace("[/adress]","</adress>",$string);
    $string = str_replace("[ul]","<ul>",$string);
    $string = str_replace("[/ul]","</ul>",$string);
    $string = str_replace("[ol]","<ol>",$string);
    $string = str_replace("[/ol]","</ol>",$string);
    $string = str_replace("[li]","<li>",$string);
    $string = str_replace("[/li]","</li>",$string);
    $string = str_replace("[blockquote]","<blockquote>",$string);
    $string = str_replace("[/blockquote]","</blockquote>",$string);
    $string = str_replace("[sup]","<sup>",$string);
    $string = str_replace("[/sup]","</sup>",$string);
    $string = str_replace("[sub]","<sub>",$string);
    $string = str_replace("[/sub]","</sub>",$string);
    $string = str_replace("[center]", "<center>",$string);
    $string = str_replace("[/center]", "</center>",$string);
    $string = str_replace("[strike]", "<strike>",$string);
    $string = str_replace("[/strike]", "</strike>",$string);
    $string = str_replace("[left]", "<div align=\"left\">", $string);
    $string = str_replace("[/left]", "</div>", $string);
    $string = str_replace("[right]", "<div align=\"right\">", $string);
    $string = str_replace("[/right]", "</div>", $string);
    $string = str_replace("[quote]","<div align=\"left\" class=\"quotetop\">Quote:</div><blockquote class=\"quotemain\">",$string);
    $string = str_replace("[/quote]","</blockquote>",$string);
    //$string = eregi_replace("\\[url\\]([^\\[]*)\\[/url\\]","<a href=\\1 target=_blank>\\1</a>", $string);
    $string = eregi_replace("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" target=\"_blank\">\\2</a>",$string);
    //$string = eregi_replace("\\[img=([^\\[]*)\\]","<img align=\"left\" src=\"\\1\" border=\"0\">",$string);
    //$string = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<font color=\\1>\\2</font>",$string);
    $string = eregi_replace("\\[bgcolor=([^\\[]*)\\]([^\\[]*)\\[/bgcolor\\]","<span style=\"background-color:\\1;\">\\2</span>",$string);
    $string = eregi_replace("\\[farbe=([^\\[]*)\\]([^\\[]*)\\[/farbe\\]","<font color=\"\\1\">\\2</font>",$string);
    $string = eregi_replace("\[email\]([^\[]*)\[/email\]","<a href='mailto:\\1'>\\1</a>", $string);
    $string = eregi_replace("\\[font=([^\\[]*)\\]([^\\[]*)\\[/font\\]","<font face=\"\\1\">\\2</font>",$string);
    $string = str_replace("[c]","<code>",$string);
    $string = str_replace("[/c]","</code>",$string);
    $string = str_replace("[small]","<small>",$string);
    $string = str_replace("[/small]","</small>",$string);
    $string = str_replace("[large]","<font size=\"2\">",$string);
    $string = str_replace("[/large]","</font>",$string);
    return $string;
}

function bbcode_image_resize($string) 
{
	global $lhl;	
	global $bbcode_image_max_width;
	global $bbcode_image_max_width;
	global $bbcode_image_max_height;
	global $bbcode_erlaubte_endungen;
	global $bbcode_erlaubte_endungen_typ ;
	global $bbcode_autoresize;
	global $bbcode_image_security_level_1; // Es wird �berpr�ft ob die Endung erlaubt ist
	global $bbcode_image_security_level_2; // Sicherheitsstufe 1 muss aktiviert sein, und es wird dann �berpr�ft ob es sich um einen erlaubten Bildtypen handelt, anhand einer Typ bestimmung
	
	
		  
	if($bbcode_autoresize==1) 
	{
	  	
	  	if(!$bbcode_image_max_height) $size_h = "600"; else $size_h=$bbcode_image_max_height;
	  	if(!$bbcode_image_max_width) $size_l = "500"; else $size_l=$bbcode_image_max_width;
	  	$string = str_replace('[IMG]', '[img]', $string);
		$string = str_replace('[/IMG]', '[/img]', $string);
		$array = explode("[img]",$string);
		foreach($array as $text)
		{
			if(strpos($text, "[/img]"))
			{
				$pos = strpos($text, "[/img]");
				$lang = strlen($text);
				$bild_string[] =  substr($text,0,$pos-$lang);
			}
		}
		if(@count($bild_string) > 0)
		{
			foreach($bild_string as $teil) 
			{
				
				
				$image_id = "espcms_bild_". srand ( (double)microtime () * 1000000 ) . rand (1, 100000);
				$bbcode_autoresize_id = "espcms_text_". srand ( (double)microtime () * 1000000 ) . rand (1, 100000);
				$array  = split("\.",$teil);
				$anzahl = count($array); // Z�hlt die Elemente eines Arrys um das letzt zu finden
				$endung =  $array[$anzahl-1]; //Endung wird gesetzt
				
				if($bbcode_image_security_level_1)
				{
					if(in_array(strtolower($endung),$bbcode_erlaubte_endungen)) // pr�ft ob der Pfad eine erlaubte Endung hat
				  	{
				  		if($bbcode_image_security_level_2)
				  		{
					  		
				  			if(in_array(exif_imagetype(trim($teil)),$bbcode_erlaubte_endungen_typ))  // Pr�ft, ob es ein erlaubter Bildtyp ist!
				  			{
				  				$string = str_replace('[img]'.trim($teil).'[/img]', '<table border="0" cellspancing="0" cellpadding="0"><tr><td ><div id="'. $bbcode_autoresize_id .'" style="display:none;padding:0px;background-color:#fff68c;border:1px solid #706707;border-bottom:0px solid #706707;" align="left" valign="middle"></div><a href="'.trim($teil) .'" target="_blank" alt="['.$lhl['config_img'].']" title="['.$lhl['config_img'].']"><img src="'.trim($teil).'" border="0" id="'. $image_id .'" onload="autosize(\''. $size_l .'\', \''. $size_h .'\', \''. $image_id .'\', \''. $bbcode_autoresize_id .'\')"></a></td></tr></table>', $string);
				  			}
				  			else
				  			{
								//Sicherheitsabfrage nicht �berlebt
							}
					  		
						}
						else
						{					
							$string = str_replace('[img]'.trim($teil).'[/img]', '<table border="0" cellspancing="0" cellpadding="0"><tr><td ><div id="'. $bbcode_autoresize_id .'" style="display:none;padding:0px;background-color:#fff68c;border:1px solid #706707;border-bottom:0px solid #706707;" align="left" valign="middle"></div><a href="'.trim($teil) .'" target="_blank" alt="['.$lhl['config_img'].']" title="['.$lhl['config_img'].']"><img src="'.trim($teil).'" border="0" id="'. $image_id .'" onload="autosize(\''. $size_l .'\', \''. $size_h .'\', \''. $image_id .'\', \''. $bbcode_autoresize_id .'\')"></a></td></tr></table>', $string);
						}
					}
					else
					{
						//Sicherheitsabfrage nicht �berlebt
					}
				}
				else
				{
					
					$string = str_replace('[img]'.$teil[2].'[/img]', '<table border="0" cellspancing="0" cellpadding="0"><tr><td ><div id="'. $bbcode_autoresize_id .'" style="display:none;padding:0px;background-color:#fff68c;border:1px solid #706707;border-bottom:0px solid #706707;" align="left" valign="middle"></div><a href="'.$teil[2].'" target="_blank" alt="[v]" title="['.$lhl['config_img'].']"><img src="'.$teil[2].'" border="0" id="'. $image_id .'" onload="autosize(\''. $size_l .'\', \''. $size_h .'\', \''. $image_id .'\', \''. $bbcode_autoresize_id .'\')"></a></td></tr></table>', $string);
				}
			} //Foreach
		}
	}	  
	else
	{
	 	$string = preg_replace("#\[img\](.*?)\[/img\]#si", "<img src=\"\\1\" border=\"0\">", $string);
	}	
	return $string;
}

function bbcode_php($string)
{
	return $string = preg_replace_callback ("#\[PHP\](.*?)\[/PHP\]#si","highlight",$string);
}

function highlight($string)
{
	global $bbcode_phpcode_border;
	global $bbcode_phpcode_bg1;
	

 	$string = htmlspecialchars_decode($string[1]);
 	$string = highlight_string($string, true);
 	$string = '<table width="100%" cellpadding="4" border="0" bgcolor="'.$bbcode_phpcode_border.'" cellspacing="1" align="center"><tr><td bgcolor="'.$bbcode_phpcode_bg1.'"><div style="overflow:scroll;font-family:courier;"><b>PHP Code:</b><hr noshade color="$border" size="1">'.$string.'</div></td></tr></table>';
 	return $string;
}

function bbcode_land($string)
{
	global $db;
	if($result = $db->queryObjectArray("SELECT * FROM espcms_land ORDER BY espcms_order asc"))
	{
		foreach($result as $row)
		{
			$string = str_replace($row->tag,"<img src=\"".$row->pfad."\" width=\"18\" height=\"12\" title=\"".$row->name."\" alt=\"".$row->name."\">",$string);
		}
	}
	return $string;
}


?>