<?php
// Expected data format:
// {
//	"orderhistory":
// 		[
//			{"id":"1","cdate":"2012-07-20 16:37:22","amount":"131.00"},
//	 		{"id":"13","cdate":"2012-07-26 17:31:47","amount":"142.50"}
// 		],
// 	"totalorders":2,
// 	"userdata":
//		{
//			"id":"42",
//			"age":"23",
//			"gender":"Male"
//		},
//	"ad_data":
//		{
//			"ad_id":"3",
//			"pay_type":"click",
//			"limit":"3",
//			"pim":"0.001",
//			"pcl":"0.10"
//		}
// }
// {"orderhistory":[{"id":"1","cdate":"2012-07-20 16:37:22","amount":"131.00"},{"id":"13","cdate":"2012-07-26 17:31:47","amount":"142.50"}],"totalorders":2,"userdata":{"id":"42","age":"23","gender":"Male"},"ad_data":{"ad_id":"3","pay_type":"click","limit":"3","pim":"0.001","pcl":"0.10"}}
// {"orderhistory":[{"id":"1","cdate":"2012-07-20 16:37:22","amount":"131.00"},{"id":"13","cdate":"2012-07-26 17:31:47","amount":"142.50"}],"totalorders":2,"userdata":{"id":"42","age":"23","gender":"Male"},"ad_data":{"ad_id":"3","pay_type":"click","limit":"3","pim":"0.001","pcl":"0.10"}}

function ComputeBid($maxValue)
{
	$minValue = $maxValue/2; /*hardcoded for now*/ 
	$intPowerTen=pow(10,2);

	$utility_num =  mt_rand($minValue*$intPowerTen,$maxValue*$intPowerTen)/$intPowerTen;	
	//$utility_num = round($utility_num,2); 
	$utility_num = number_format((float)$utility_num, 2, '.', '');

	return $utility_num;
}

function ComputeUtility($pim, $pcl)
{
	$pimMultiplier = rand(30,70)/100.0;
	$pclMultiplier = rand(30,70)/100.0;
	
	$pim_result = (IsNullOrEmptyString($pim)) ? .01 * $pimMultiplier : doubleval($pim) * $pimMultiplier;
	$pcl_result = (IsNullOrEmptyString($pcl)) ? .50 * $pclMultiplier : doubleval($pcl) * $pclMultiplier;
		
	return max($pim_result, $pcl_result);
}

function IsNullOrEmptyString($question){
    return (!isset($question) || trim($question)==='');
}

function App_ChooseAd()
{
	// Parse out the JSON Data
	$jsonData = json_decode($_REQUEST['json'], true);

	//print '<BR/>'.var_dump($jsonData["ad_data"]);
	$result = ComputeUtility($jsonData["ad_data"]["pim"], $jsonData["ad_data"]["pcl"]);

	// Log results to database
	if (false)
	{
		$now = $_SERVER['REQUEST_TIME'];
		mysql_query("INSERT INTO PricingLog (RawJsonRequest, CalculatedResult, CreatedOn) VALUES('{$_REQUEST['json']}', '$utility', '$now'");
	}
	
	return array("error" => "", "ad_id" => $jsonData["ad_data"]["ad_id"], "price" => $result );
}

function App_getAdbid()
{
	$jsonstring = stripslashes($_REQUEST['json']); /*srtip lashes from the json*/
	// Parse out the JSON Data
	$jsonData = json_decode($jsonstring,true);

	$result = ComputeBid($jsonData["ad_data"]["bid_value"]);

	// Log results to database
	if (false)
	{
		$now = $_SERVER['REQUEST_TIME'];
		mysql_query("INSERT INTO PricingLog (RawJsonRequest, CalculatedResult, CreatedOn) VALUES('{$_REQUEST['json']}', '$result', '$now'");
	}

	return array("error" => "", "ad_id" => $jsonData["ad_data"]["ad_id"], "price" => $result );
}

function App_Error ()
{
	return array('error' => 'Unable to process.  Error.  See server for details.');
}

function App_Ping ()
{
	return array('error' => '', 'alive' => '1');
}

header("Access-Control-Allow-Origin: *");
if (!isset($_REQUEST['cmd'])) $_REQUEST['cmd'] = "Error";

// Not using the database yet
if (false) {
	if (!mysql_connect(DB_HOST, DB_USER, DB_PASSWORD)) $_REQUEST['cmd'] = "Error";
	if (!mysql_select_db(DB_DATABASE)) $_REQUEST['cmd'] = "Error";
}

//process command
//echo $_REQUEST["cmd"];
switch ($_REQUEST["cmd"])
{
	case "ChooseAd": $json_out = App_ChooseAd(); break;
	case "Choosebid": $json_out = App_getAdbid(); break;	
	case "Ping": $json_out = App_Ping(); break;
	default: $json_out = App_Error(); break;
}
echo json_encode($json_out);
?>
