<?php
/*
Plugin Name: Soc-zakladka
Plugin URI: http://blogavod.ru
Description: Автоматически добавляет ссылки на пост, страницы и RSS фиды в Ваши любимые социальные закладки. 
Version: 0.1
Author: Blogavod
Author URI: http://blogavod.ru
*/

/* определение каталога */
$socpluginpath = WP_CONTENT_URL.'/plugins/'.plugin_basename(dirname(__FILE__)).'/';

/**
 * @global массив который содержит сайты используемые в плагине:
 * favicon - иконка сайта, 16x16px PNG, находится в каталоге images
 * url - URL сайта с автоматическим заполнением некоторых полей, содержит PERMALINK, TITLE
 * description - описание, alt для иконок и текст для текстовых ссылок
 */
$soc_known_sites = Array(

	'Korica' => Array(
		'favicon' => 'korica.png',
		'url' => 'http://korica.info/add_story.php?story_url=PERMALINK',
	),

	'Chipp' => Array(
		'favicon' => 'chipp.png',
		'url' => 'http://chipp.ru/submit.php?url=PERMALINK',
	),

	'Community-Seo' => Array(
		'favicon' => 'community-seo.png',
		'url' => 'http://community-seo.ru/submit.php?url=PERMALINK',
	),	

	'Rucity' => Array(
		'favicon' => 'rucity.png',
		'url' => 'http://www.rucity.com/bookmarks.php?action=add&address=PERMALINK&title=TITLE',
	),
	
/**	'Rumarkz' => Array(
		'favicon' => '.png',
		'url' => 'http://rumarkz.ru/bookmarks/?action=add&popup=1&address=PERMALINK&title=TITLE',
	),*/
	
	'Myweb2' => Array(
		'favicon' => 'yahoo.png',
		'url' => 'http://myweb2.search.yahoo.com/myresults/bookmarklet?u=PERMALINK&title=TITLE',
	),

	'Ma.gnolia' => Array(
		'favicon' => 'magnolia.png',
		'url' => 'http://ma.gnolia.com/beta/bookmarklet/add?url=PERMALINK&title=TITLE',
	),

	'100zakladok' => Array(
		'favicon' => '100zakladok.png',
		'url' => 'http://www.100zakladok.ru/save/?bmurl=PERMALINK&&bmtitle=TITLE',
	),

	'Linkstore' => Array(
		'favicon' => 'linkstore.png',
		'url' => 'http://www.linkstore.ru/servlet/LinkStore?a=add&url=PERMALINK&title=TITLE',
	),
	
	'WebDigg' => Array(
		'favicon' => 'webdigg.png',
		'url' => 'http://webdigg.ru/add.html?url=PERMALINK&title=TITLE',
	),
	
	'Baay!' => Array(
		'favicon' => 'vaau.png',
		'url' => 'http://www.vaau.ru/submit/?action=step2&url=PERMALINK',
	),
	
	'RuSpace' => Array(
		'favicon' => 'ruspace.png',
		'url' => 'http://www.ruspace.ru/index.php?link=bookmark&url=PERMALINK&title=TITLE',
	),
	
	'MyScoop' => Array(
		'favicon' => 'myscoop.png',
		'url' => 'http://myscoop.ru/add/?URL=PERMALINK&title=TITLE',
	),
	
	'Smi2' => Array(
		'favicon' => 'smi2.png',
		'url' => 'http://smi2.ru/add/?url=PERMALINK&precaption=TITLE',
	),
	
	'MisterWong' => Array(
		'favicon' => 'mister.png',
		'url' => 'http://www.mister-wong.ru/index.php?action=addurl&bm_url=PERMALINK&bm_description=TITLE',
	),
	
	'News2' => Array(
		'favicon' => 'news2.png',
		'url' => 'http://news2.ru/add_story.php?url=PERMALINK',
	),
	
	'Moemesto' => Array(
		'favicon' => 'mm.png',
		'url' => 'http://moemesto.ru/post.php?url=PERMALINK&title=TITLE',
	),
	
	'BobrDobr' => Array(
		'favicon' => 'bobrdobr.png',
		'url' => 'http://bobrdobr.ru/addext.html?url=PERMALINK&title=TITLE',
	),
	
	'Yandex' => Array(
		'favicon' => 'yandex.png',
		'url' => 'http://zakladki.yandex.ru/userarea/links/addfromfav.asp?bAddLink_x=1&lurl=PERMALINK&lname=TITLE',
	),
	
	'Grabr' => Array(
		'favicon' => 'grabr.png',
		'url' => 'http://grabr.ru/add?url=PERMALINK&title=TITLE',
	),
	
	'Memori' => Array(
		'favicon' => 'memori.png',
		'url' => 'http://memori.ru/link/?sm=1&u_data[url]=PERMALINK&u_data[name]=TITLE',
	),
	
	'BarraPunto' => Array(
		'favicon' => 'barrapunto.png',
		'url' => 'http://barrapunto.com/submit.pl?subj=TITLE&amp;story=PERMALINK',
	),
	
	'Bitacoras.com' => Array(
		'favicon' => 'bitacoras.png',
		'url' => 'http://bitacoras.com/anotaciones/PERMALINK',
	),
	
	'BlinkList' => Array(
		'favicon' => 'blinklist.png',
		'url' => 'http://www.blinklist.com/index.php?Action=Blink/addblink.php&amp;Url=PERMALINK&amp;Title=TITLE',
	),

	'blogmarks' => Array(
		'favicon' => 'blogmarks.png',
		'url' => 'http://blogmarks.net/my/new.php?mini=1&amp;simple=1&amp;url=PERMALINK&amp;title=TITLE',
	),

	'Blogosphere News' => Array(
		'favicon' => 'blogospherenews.png',
		'url' => 'http://www.blogospherenews.com/submit.php?url=PERMALINK&amp;title=TITLE',
	),

	'blogtercimlap' => Array(
		'favicon' => 'blogter.png',
		'url' => 'http://cimlap.blogter.hu/index.php?action=suggest_link&amp;title=TITLE&amp;url=PERMALINK',
	),

	'Faves' => Array(
		'favicon' => 'bluedot.png',
		'url' => 'http://faves.com/Authoring.aspx?u=PERMALINK&amp;title=TITLE',
	),

	'connotea' => Array(
		'favicon' => 'connotea.png',
		'url' => 'http://www.connotea.org/addpopup?continue=confirm&amp;uri=PERMALINK&amp;title=TITLE&amp;description=EXCERPT',
	),

	'Current' => Array(
		'favicon' => 'current.png',
		'url' => 'http://current.com/clipper.htm?url=PERMALINK&amp;title=TITLE',
	),
	
	'del.icio.us' => Array(
		'favicon' => 'delicious.png',
		'url' => 'http://delicious.com/post?url=PERMALINK&amp;title=TITLE&amp;notes=EXCERPT',
	),
	
	'Design Float' => Array(
		'favicon' => 'designfloat.png',
		'url' => 'http://www.designfloat.com/submit.php?url=PERMALINK&amp;title=TITLE',
	),
	
	'Digg' => Array(
		'favicon' => 'digg.png',
		'url' => 'http://digg.com/submit?phase=2&amp;url=PERMALINK&amp;title=TITLE&amp;bodytext=EXCERPT',
	),

	'Diigo' => Array(
		'favicon' => 'diigo.png',
		'url' => 'http://www.diigo.com/post?url=PERMALINK&amp;title=TITLE',
	),

	'DotNetKicks' => Array(
		'favicon' => 'dotnetkicks.png',
		'url' => 'http://www.dotnetkicks.com/kick/?url=PERMALINK&amp;title=TITLE',
	),

	'DZone' => Array(
		'favicon' => 'dzone.png',
		'url' => 'http://www.dzone.com/links/add.html?url=PERMALINK&amp;title=TITLE',

	),

	'eKudos' => Array(
		'favicon' => 'ekudos.png',
		'url' => 'http://www.ekudos.nl/artikel/nieuw?url=PERMALINK&amp;title=TITLE&amp;desc=EXCERPT',
	),

	'email' => Array(
		'favicon' => 'email_link.png',
		'url' => 'mailto:?subject=TITLE&amp;body=PERMALINK',
	),

	'Facebook' => Array(
		'favicon' => 'facebook.png',
		'url' => 'http://www.facebook.com/share.php?u=PERMALINK&amp;t=TITLE',
	),

	'Fark' => Array(
		'favicon' => 'fark.png',
		'url' => 'http://cgi.fark.com/cgi/fark/farkit.pl?h=TITLE&amp;u=PERMALINK',
	),

	'Fleck' => Array(
		'favicon' => 'fleck.png',
		'url' => 'http://beta3.fleck.com/bookmarklet.php?url=PERMALINK&amp;title=TITLE',
	),

	'FriendFeed' => Array(
		'favicon' => 'friendfeed.png',
		'url' => 'http://www.friendfeed.com/share?title=TITLE&amp;link=PERMALINK',
	),

	'FSDaily' => Array(
		'favicon' => 'fsdaily.png',
		'url' => 'http://www.fsdaily.com/submit?url=PERMALINK&amp;title=TITLE',
	),

	'Global Grind' => Array (
		'favicon' => 'globalgrind.png',
		'url' => 'http://globalgrind.com/submission/submit.aspx?url=PERMALINK&amp;type=Article&amp;title=TITLE',
	),
	
	'Google' => Array (
		'favicon' => 'google.png',
		'url' => 'http://www.google.com/bookmarks/mark?op=edit&amp;bkmk=PERMALINK&amp;title=TITLE&amp;annotation=EXCERPT',
		'description' => 'Google Bookmarks',
	),
	
	'Gwar' => Array(
		'favicon' => 'gwar.png',
		'url' => 'http://www.gwar.pl/DodajGwar.html?u=PERMALINK',
	),

	'HackerNews' => Array(
		'favicon' => 'hackernews.png',
		'url' => 'http://news.ycombinator.com/submitlink?u=PERMALINK&amp;t=TITLE',
	),

	'Haohao' => Array(
		'favicon' => 'haohao.png',
		'url' => 'http://www.haohaoreport.com/submit.php?url=PERMALINK&amp;title=TITLE',
	),

	'HealthRanker' => Array(
		'favicon' => 'healthranker.png',
		'url' => 'http://healthranker.com/submit.php?url=PERMALINK&amp;title=TITLE',
	),

	'HelloTxt' => Array(
        'favicon' => 'hellotxt.png',
        'url' => 'http://hellotxt.com/?status=TITLE+PERMALINK',
    ),

	'Hemidemi' => Array(
		'favicon' => 'hemidemi.png',
		'url' => 'http://www.hemidemi.com/user_bookmark/new?title=TITLE&amp;url=PERMALINK',
	),

	'Hyves' => Array(
		'favicon' => 'hyves.png',
		'url' => 'http://www.hyves.nl/profilemanage/add/tips/?name=TITLE&amp;text=EXCERPT+PERMALINK&amp;rating=5',
	),

	'Identi.ca' => Array(
		'favicon' => 'identica.png',
		'url' => 'http://identi.ca/notice/new?status_textarea=PERMALINK',
	),

	'IndianPad' => Array(
		'favicon' => 'indianpad.png',
		'url' => 'http://www.indianpad.com/submit.php?url=PERMALINK',
	),

	'Internetmedia' => Array(
		'favicon' => 'im.png',
		'url' => 'http://internetmedia.hu/submit.php?url=PERMALINK',
	),

	'Kirtsy' => Array(
		'favicon' => 'kirtsy.png',
		'url' => 'http://www.kirtsy.com/submit.php?url=PERMALINK&amp;title=TITLE',
	),

	'laaik.it' => Array(
		'favicon' => 'laaikit.png',
		'url' => 'http://laaik.it/NewStoryCompact.aspx?uri=PERMALINK&amp;headline=TITLE&amp;cat=5e082fcc-8a3b-47e2-acec-fdf64ff19d12',
	),

	'LinkArena' => Array(
		'favicon' => 'linkarena.png',
		'url' => 'http://linkarena.com/bookmarks/addlink/?url=PERMALINK&amp;title=TITLE',
	),
	
	'LinkaGoGo' => Array(
		'favicon' => 'linkagogo.png',
		'url' => 'http://www.linkagogo.com/go/AddNoPopup?url=PERMALINK&amp;title=TITLE',
	),

	'LinkedIn' => Array(
		'favicon' => 'linkedin.png',
		'url' => 'http://www.linkedin.com/shareArticle?mini=true&amp;url=PERMALINK&amp;title=TITLE&amp;source=BLOGNAME&amp;summary=EXCERPT',
	),

	'Linkter' => Array(
		'favicon' => 'linkter.png',
		'url' => 'http://www.linkter.hu/index.php?action=suggest_link&amp;url=PERMALINK&amp;title=TITLE',
	),
	
	'Live' => Array(
		'favicon' => 'live.png',
		'url' => 'https://favorites.live.com/quickadd.aspx?marklet=1&amp;url=PERMALINK&amp;title=TITLE',
	),

	'Meneame' => Array(
		'favicon' => 'meneame.png',
		'url' => 'http://meneame.net/submit.php?url=PERMALINK',
	),
	
	'Mixx' => Array(
		'favicon' => 'mixx.png',
		'url' => 'http://www.mixx.com/submit?page_url=PERMALINK&amp;title=TITLE',
	),
	
	'Muti' => Array(
		'favicon' => 'muti.png',
		'url' => 'http://www.muti.co.za/submit?url=PERMALINK&amp;title=TITLE',
	),
	
	'MyShare' => Array(
		'favicon' => 'myshare.png',
		'url' => 'http://myshare.url.com.tw/index.php?func=newurl&amp;url=PERMALINK&amp;desc=TITLE',
	),

	'MySpace' => Array(
		'favicon' => 'myspace.png',
		'url' => 'http://www.myspace.com/Modules/PostTo/Pages/?u=PERMALINK&amp;t=TITLE',
	),

	'MSNReporter' => Array(
		'favicon' => 'msnreporter.png',
		'url' => 'http://reporter.nl.msn.com/?fn=contribute&amp;Title=TITLE&amp;URL=PERMALINK&amp;cat_id=6&amp;tag_id=31&amp;Remark=EXCERPT',
		'description' => 'MSN Reporter',
	),
	
	'N4G' => Array(
		'favicon' => 'n4g.png',
		'url' => 'http://www.n4g.com/tips.aspx?url=PERMALINK&amp;title=TITLE',
	),
	
	'Netvibes' => Array(
		'favicon' => 'netvibes.png',
		'url' =>	'http://www.netvibes.com/share?title=TITLE&amp;url=PERMALINK',
	),
		
	'NewsVine' => Array(
		'favicon' => 'newsvine.png',
		'url' => 'http://www.newsvine.com/_tools/seed&amp;save?u=PERMALINK&amp;h=TITLE',
	),

	'Netvouz' => Array(
		'favicon' => 'netvouz.png',
		'url' => 'http://www.netvouz.com/action/submitBookmark?url=PERMALINK&amp;title=TITLE&amp;popup=no',
	),

	'NuJIJ' => Array(
		'favicon' => 'nujij.png',
		'url' => 'http://nujij.nl/jij.lynkx?t=TITLE&amp;u=PERMALINK&amp;b=EXCERPT',
	),
	
	'Ping.fm' => Array(
		'favicon' => 'ping.png',
		'url' => 'http://ping.fm/ref/?link=PERMALINK&amp;title=TITLE&amp;body=EXCERPT',
	),

	'Posterous' => Array(
		'favicon' => 'posterous.png',
		'url' => 'http://posterous.com/share?linkto=PERMALINK&amp;title=TITLE&amp;selection=EXCERPT',
	),
	
	'PDF' => Array(
		'favicon' => 'pdf.png',
		'url' => 'http://www.printfriendly.com/print?url=PERMALINK&amp;partner=sociable',
	),
	
	'Print' => Array(
		'favicon' => 'printfriendly.png',
		'url' => 'http://www.printfriendly.com/print?url=PERMALINK&amp;partner=sociable',
	),
	
	'Propeller' => Array(
		'favicon' => 'propeller.png',
		'url' => 'http://www.propeller.com/submit/?url=PERMALINK',
	),

	'Ratimarks' => Array(
		'favicon' => 'ratimarks.png',
		'url' => 'http://ratimarks.org/bookmarks.php/?action=add&address=PERMALINK&amp;title=TITLE',
	),

	'Rec6' => Array(
		'favicon' => 'rec6.png',
		'url' => 'http://rec6.via6.com/link.php?url=PERMALINK&amp;=TITLE',
	),

	'Reddit' => Array(
		'favicon' => 'reddit.png',
		'url' => 'http://reddit.com/submit?url=PERMALINK&amp;title=TITLE',
	),

	'RSS' => Array(
		'favicon' => 'rss.png',
		'url' => 'FEEDLINK',
	),
	
	'Scoopeo' => Array(
		'favicon' => 'scoopeo.png',
		'url' => 'http://www.scoopeo.com/scoop/new?newurl=PERMALINK&amp;title=TITLE',
	),	

	'Segnalo' => Array(
		'favicon' => 'segnalo.png',
		'url' => 'http://segnalo.alice.it/post.html.php?url=PERMALINK&amp;title=TITLE',
	),

	'Simpy' => Array(
		'favicon' => 'simpy.png',
		'url' => 'http://www.simpy.com/simpy/LinkAdd.do?href=PERMALINK&amp;title=TITLE',
	),

	'Slashdot' => Array(
		'favicon' => 'slashdot.png',
		'url' => 'http://slashdot.org/bookmark.pl?title=TITLE&amp;url=PERMALINK',
	),

	'Socialogs' => Array(
		'favicon' => 'socialogs.png',
		'url' => 'http://socialogs.com/add_story.php?story_url=PERMALINK&amp;story_title=TITLE',
	),
	
	'SphereIt' => Array(
		'favicon' => 'sphere.png',
		'url' => 'http://www.sphere.com/search?q=sphereit:PERMALINK&amp;title=TITLE',
	),

	'Sphinn' => Array(
		'favicon' => 'sphinn.png',
		'url' => 'http://sphinn.com/index.php?c=post&amp;m=submit&amp;link=PERMALINK',
	),

	'StumbleUpon' => Array(
		'favicon' => 'stumbleupon.png',
		'url' => 'http://www.stumbleupon.com/submit?url=PERMALINK&amp;title=TITLE',
	),

	'Techmeme' => Array( 
		'favicon' => 'techmeme.png',
		'url' => 'http://twitter.com/home/?status=tip%20@Techmeme%20PERMALINK%20TITLE', 
		'description' => 'Suggest to Techmeme via Twitter',
	), 

	'Technorati' => Array(
		'favicon' => 'technorati.png',
		'url' => 'http://technorati.com/faves?add=PERMALINK',
	),

	'ThisNext' => Array(
		'favicon' => 'thisnext.png',
		'url' => 'http://www.thisnext.com/pick/new/submit/sociable/?url=PERMALINK&amp;name=TITLE',
	),

	'Tipd' => Array(
		'favicon' => 'tipd.png',
		'url' => 'http://tipd.com/submit.php?url=PERMALINK',
	),
	
	'Tumblr' => Array(
		'favicon' => 'tumblr.png',
		'url' => 'http://www.tumblr.com/share?v=3&amp;u=PERMALINK&amp;t=TITLE&amp;s=EXCERPT',
	),
	
	'Twitter' => Array(
		'favicon' => 'twitter.png',
		'url' => 'http://twitter.com/home?status=TITLE%20-%20PERMALINK',
	),

	'Upnews' => Array(
		'favicon' => 'upnews.png',
		'url' => 'http://www.upnews.it/submit?url=PERMALINK&amp;title=TITLE',
	),
	
	'Webnews.de' => Array(
        'favicon' => 'webnews.png',
        'url' => 'http://www.webnews.de/einstellen?url=PERMALINK&amp;title=TITLE',
    ),

	'Webride' => Array(
		'favicon' => 'webride.png',
		'url' => 'http://webride.org/discuss/split.php?uri=PERMALINK&amp;title=TITLE',
	),

	'Wikio' => Array(
		'favicon' => 'wikio.png',
		'url' => 'http://www.wikio.com/vote?url=PERMALINK',
	),
	
	'Wists' => Array(
		'favicon' => 'wists.png',
		'url' => 'http://wists.com/s.php?c=&amp;r=PERMALINK&amp;title=TITLE',
	),

	'Wykop' => Array(
		'favicon' => 'wykop.png',
		'url' => 'http://www.wykop.pl/dodaj?url=PERMALINK',
	),

	'Xerpi' => Array(
		'favicon' => 'xerpi.png',
		'url' => 'http://www.xerpi.com/block/add_link_from_extension?url=PERMALINK&amp;title=TITLE',
	),

	'YahooBuzz' => Array(
		'favicon' => 'yahoobuzz.png',
		'url' => 'http://buzz.yahoo.com/submit/?submitUrl=PERMALINK&amp;submitHeadline=TITLE&amp;submitSummary=EXCERPT&amp;submitCategory=science&amp;submitAssetType=text',
		'description' => 'Yahoo! Buzz',
	),
	
	'Yahoo! Bookmarks' => Array(
		'favicon' => 'yahoomyweb.png',
		'url' => 'http://bookmarks.yahoo.com/toolbar/savebm?u=PERMALINK&amp;t=TITLE&opener=bm&amp;ei=UTF-8&amp;d=EXCERPT',
	),

	'Yigg' => Array(
		'favicon' => 'yiggit.png',
		'url' => 'http://yigg.de/neu?exturl=PERMALINK&amp;exttitle=TITLE',
	 ),
	 
	 'Add to favorites' => Array(
	 	'favicon' => 'addtofavorites.png',
	 	'url' => 'javascript:AddToFavorites();',
	 ),
	 
	 'Blogplay' => Array(
	 	'favicon' => 'blogplay.png',
	 	'url' => 'http://blogplay.com',
	 ),
	 
	'MOB' => Array(
        'favicon' => 'mob.png',
        'url' => 'http://www.mob.com/share.php?u=PERMALINK&t=TITLE',
        'description' => 'MOB',
    ), 
    
    'LaTafanera' => Array(
        'favicon' => 'latafanera.png',
        'url' => 'http://latafanera.cat/submit.php?url=PERMALINK',
    ),
    
    'SheToldMe' => Array(
        'favicon' => 'shetoldme.png',
        'url' => 'http://shetoldme.com/publish?url=PERMALINK&title=TITLE',
    ),

	'viadeo FR' => Array(
        'favicon' => 'viadeo.png',
        'url' => 'http://www.viadeo.com/shareit/share/?url=PERMALINK&title=TITLE&urllanguage=fr',
    ),
        
	'Diggita' => Array(
        'favicon' => 'diggita.png',
        'url' => 'http://www.diggita.it/submit.php?url=PERMALINK&title=TITLE',
        'description' => 'Diggita',
    ),   	 
    
);

function soc_html($display=array()) {
	global $soc_known_sites, $socpluginpath, $wp_query, $post; 

/*	if (get_post_meta($post->ID,'_SocZakladkaoff',true)) {
		return "";
	}*/

	$soc_known_sites = apply_filters('soc_known_sites',$soc_known_sites);
	$active_sites = get_option('soc_active_sites');

	// определение каталога с иконками
	$imagepath = get_option('soc_imagedir');
	if ($imagepath == "")
		$imagepath = $socpluginpath.'images/';		

	// вывод активных сайтов, если активных нет, то ничего не выодит
	if (empty($display) and $active_sites)
		$display = $active_sites;
	if (empty($display))
		return "";

	// Загрузка постов и данных блога
	$blogname 	= urlencode(get_bloginfo('name')." ".get_bloginfo('description'));
	$blogrss	= get_bloginfo('rss2_url'); 
	$post 		= $wp_query->post;
	
	// Захват короткого описание, если его нет то создается
	$excerpt	= urlencode(strip_tags(strip_shortcodes($post->post_excerpt)));
	if ($excerpt == "") {
		$excerpt = urlencode(substr(strip_tags(strip_shortcodes($post->post_content)),0,250));
	}
	$excerpt	= str_replace('+','%20',$excerpt);
	$permalink 	= urlencode(get_permalink($post->ID));
	$title 		= str_replace('+','%20',urlencode($post->post_title));
	$rss 		= urlencode(get_bloginfo('ref_url'));

	// Начало вывода
	$html = "\n<div class=\"soc\">\n";
	
	// Заголовок над иконками
	$tagline = get_option("soc_tagline");
	if ($tagline != "") {
		$html .= "<div class=\"soc_tagline\">\n";
		$html .= stripslashes($tagline);
		$html .= "\n</div><br/>";
	}
	
	/* Список сайтов */
	$html .= "\n<ul><noindex>\n";

	$i = 0;
	$totalsites = count($display);
	foreach($display as $sitename) {
		if (!in_array($sitename, $active_sites))
			continue;

		$site = $soc_known_sites[$sitename];

		$url = $site['url'];
		$url = str_replace('TITLE', $title, $url);
		$url = str_replace('RSS', $rss, $url);
		$url = str_replace('BLOGNAME', $blogname, $url);
		$url = str_replace('EXCERPT', $excerpt, $url);
		$url = str_replace('FEEDLINK', $blogrss, $url);
		
		if (isset($site['description']) && $site['description'] != "") {
			$description = $site['description'];
		} else {
			$description = $sitename;
		}

		$url = str_replace('PERMALINK', $permalink, $url);		
		
		/* Формирование каждого элемента списка */
		if ($i == 0) {
			$link = '<li class="socfirst">';
		} else if ($totalsites == ($i+1)) {
			$link = '<li class="soclast">';
		} else {
			$link = '<li>';
		}
		
		/* Формирование ссылок, добавление к ним атрибута nofollow и опционально добавление target=_blank для открытия ссылок в другом окне */
		$link .= '<a ';
		$link .= ($sitename=="Blogplay") ? '' : 'rel="nofollow" ';

			if(!($sitename=="Add to favorites")) {
				if (get_option('soc_usetargetblank')) {
					$link .= " target=\"_blank\"";
				}
				$link .= " href=\"".$url."\" title=\"$description\">";
			} else {
				$link .= " href=\"$url\" title=\"$description\">";			
			}
		
		/* Если опция вывода текстовых ссылок включена */
		if (get_option('soc_usetextlinks')) {
			$link .= $description;
		} else {
				if (strpos($site['favicon'], 'http') === 0) {
					$imgsrc = $site['favicon'];
				} else {
					$imgsrc = $imagepath.$site['favicon'];
				}
				$link .= "<img src=\"".$imgsrc."\" title=\"$description\" alt=\"$description\"";
				$link .= (!get_option('soc_disablealpha',false)) ? " class=\"soc-hovers" : "";

			if (isset($site['class']) && $site['class']) {
				$link .= (!get_option('soc_disablealpha',false)) ? " soc_{$site['class']}\"" : " class=\"soc_{$site['class']}\"";
			} else {
				$link .= (!get_option('soc_disablealpha',false)) ? "\"" : "";
			}
			$link .= " />";
		}
		$link .= "</a></li>";
		$html .= "\t".apply_filters('soc_link',$link)."\n";
		$i++;
	}

	$html .= "</noindex></ul>\n</div>\n"; //конец списка

	return $html;
}

$soc_contitionals = get_option('soc_conditionals');
if (is_array($soc_contitionals) and in_array(true, $soc_contitionals)) {
	add_filter('the_content', 'soc_display_hook');
	add_filter('the_excerpt', 'soc_display_hook');
	
	function soc_display_hook($content='') {
		$conditionals = get_option('soc_conditionals');
		if ((is_home()     and $conditionals['is_home']) or
		    (is_single()   and $conditionals['is_single']) or
		    (is_page()     and $conditionals['is_page']) or
		    (is_category() and $conditionals['is_category']) or
			(is_tag() 	   and $conditionals['is_tag']) or
		    (is_date()     and $conditionals['is_date']) or
			(is_author()   and $conditionals['is_author']) or
		    (is_search()   and $conditionals['is_search'])) {
			$content .= soc_html();
		} elseif ((is_feed() and $conditionals['is_feed'])) {
			$soc_html = soc_html();
			$soc_html = strip_tags($soc_html,"<a><img>");
			$content .= $soc_html . "<br/><br/>";
		}
		return $content;
	}
}

function soc_activation_hook() {
	global $wpdb;
	$wpdb->query("DELETE FROM $wpdb->postmeta WHERE meta_key = 'SocZakladkaoff'");
	return soc_restore_config(false);
}
register_activation_hook(__FILE__, 'soc_activation_hook');

function soc_restore_config($force=false) {
	global $soc_known_sites;

	if ($force or !is_array(get_option('soc_active_sites')))
		update_option('soc_active_sites', array(
			'Twitter',
			'Grabr',
			'WebDigg',
			'Community-Seo',
			'email',
			'Facebook',
			'FriendFeed',
			'Google',
			'Yandex',
			'Memori',
			'MisterWong',
			'BobrDobr',
			'Moemesto',
			'News2'
		));

	if ($force or !is_string(get_option('soc_tagline')))
		update_option('soc_tagline', "<strong>" . __("Сохранить в:", 'soc') . "</strong>");

	if ($force or !is_array(get_option('soc_conditionals')))
		update_option('soc_conditionals', array(
			'is_home' => False,
			'is_single' => True,
			'is_page' => True,
			'is_category' => False,
			'is_tag' => False,
			'is_date' => False,
			'is_search' => False,
			'is_author' => False,
			'is_feed' => False,
		));

	if ( $force OR !( get_option('soc_usecss') ) )
		update_option('soc_usecss', true);
		
	
	if ( $force or !( get_option('soc_disablealpha')))	{
		update_option('soc_disablealpha',false);
	}
	
	if ( $force or !( get_option('soc_disablewidget')) ) {
		update_option('soc_disablewidget',false);
	}
}

function soc_admin_menu() {
	add_options_page('Soc-Zakladka', 'Soc-Zakladka', 8, 'soc', 'soc_submenu');
}
add_action('admin_menu', 'soc_admin_menu');

function soc_admin_js() {
	if (isset($_GET['page']) && $_GET['page'] == 'soc') {
		global $socpluginpath;
		
		wp_enqueue_script('jquery'); 
		wp_enqueue_script('jquery-ui-core',false,array('jquery')); 
		wp_enqueue_script('jquery-ui-sortable',false,array('jquery','jquery-ui-core')); 
		wp_enqueue_script('soc-js',$socpluginpath.'soc-admin.js', array('jquery','jquery-ui-core','jquery-ui-sortable')); 
	}
}
add_action('admin_print_scripts', 'soc_admin_js');

function soc_admin_css() {
	global $socpluginpath;
	if (isset($_GET['page']) && $_GET['page'] == 'soc')
		wp_enqueue_style('soc-css',$socpluginpath.'soc-admin.css'); 
}
add_action('admin_print_styles', 'soc_admin_css');

function soc_js() {

	if (in_array('Add to favorites',get_option('soc_active_sites'))) {
		global $socpluginpath;
		wp_enqueue_script('soc-addtofavorites',$socpluginpath.'addtofavorites.js');
	}
}
add_action('wp_print_scripts', 'soc_js');

function soc_css() {
	if (get_option('soc_usecss') == true) {
		global $socpluginpath;
		wp_enqueue_style('soc-front-css',$socpluginpath.'soc.css'); 
	}
}
add_action('wp_print_styles', 'soc_css');

function soc_message($message) {
	echo "<div id=\"message\" class=\"updated fade\"><p>$message</p></div>\n";
}
/*
function soc_meta() {
	global $post;
	$SocZakladkaoff = false;
	if (get_post_meta($post->ID,'_SocZakladkaoff',true)) {
		$SocZakladkaoff = true;
	} 
	?>
	<input type="checkbox" id="SocZakladkaoff" name="SocZakladkaoff" <?php checked($SocZakladkaoff); ?>/> <label for="SocZakladkaoff"><?php _e('Отключить плагин?','soc') ?></label>
	<?php
}

function soc_meta_box() {
	add_meta_box('soc','Soc-Zakladka','soc_meta','post','side');
	add_meta_box('soc','Soc-Zakladka','soc_meta','page','side');
}
add_action('admin_menu', 'soc_meta_box');

function soc_insert_post($pID) {
	if (!isset($_POST['SocZakladkaoff'])) {
		if (!get_post_meta($post->ID,'_SocZakladkaoff',true))
			add_post_meta($pID, '_SocZakladkaoff', true, true);
	} else {
		if (get_post_meta($post->ID,'_SocZakladkaoff',true))
			delete_post_meta($pID, '_SocZakladkaoff');
	}
}
add_action('wp_insert_post', 'soc_insert_post');
*/
function soc_submenu() {
	global $soc_known_sites, $soc_date, $socpluginpath;

	$soc_known_sites = apply_filters('soc_known_sites',$soc_known_sites);
	
	if (isset($_REQUEST['restore']) && $_REQUEST['restore']) {
		check_admin_referer('soc-config');
		soc_restore_config(true);
		soc_message(__("Восстановлены настройки по умолчанию.", 'soc'));
	} else if (isset($_REQUEST['save']) && $_REQUEST['save']) {
		check_admin_referer('soc-config');
		$active_sites = Array();
		if (!$_REQUEST['active_sites'])
			$_REQUEST['active_sites'] = Array();
		foreach($_REQUEST['active_sites'] as $sitename=>$dummy)
			$active_sites[] = $sitename;
		update_option('soc_active_sites', $active_sites);
		delete_option('soc_active_sites', $active_sites);
		add_option('soc_active_sites', $active_sites);

		foreach ( array('usetargetblank', 'disablealpha', 'usecss', 'usetextlinks') as $val ) {
			if ( isset($_POST[$val]) && $_POST[$val] )
				update_option('soc_'.$val,true);
			else
				update_option('soc_'.$val,false);
		}
		
		foreach ( array('tagline') as $val ) {
			if ( !$_POST[$val] )
				update_option( 'soc_'.$val, '');
			else
				update_option( 'soc_'.$val, $_POST[$val] );
		}
		
		if (isset($_POST["imagedir"]) && !trim($_POST["imagedir"]) == "") {
			update_option('soc_disablesprite',true);
		}
		
		$conditionals = Array();
		if (!$_POST['conditionals'])
			$_POST['conditionals'] = Array();
		
		$curconditionals = get_option('soc_conditionals');
		if (!array_key_exists('is_feed',$curconditionals)) {
			$curconditionals['is_feed'] = false;
		}
		foreach($curconditionals as $condition=>$toggled)
			$conditionals[$condition] = array_key_exists($condition, $_POST['conditionals']);
			
		update_option('soc_conditionals', $conditionals);

		soc_message(__("Изменения сохранены.", 'soc'));
	}
	
	$active_sites = get_option('soc_active_sites');
	$active = Array(); 
	$disabled = $soc_known_sites;
	foreach( $active_sites as $sitename ) {
		$active[$sitename] = $disabled[$sitename];
		unset($disabled[$sitename]);
	}
	uksort($disabled, "strnatcasecmp");
?>
<form action="<?php echo attribute_escape( $_SERVER['REQUEST_URI'] ); ?>" method="post">
<?php
	if ( function_exists('wp_nonce_field') )
		wp_nonce_field('soc-config');
?>

<div class="wrap">
	<?php screen_icon(); ?>
	<h2><?php _e("Настройки плагина Soc-Zakladka", 'soc'); ?></h2>
	<table class="form-table">
		<tr>
		<th>
			<?php _e("Сайты", "sociable"); ?>:<br/>
			<small><?php _e("Отметьте сайты, которые Вы хотите использовать у себя. Можно переносить сайты чтобы выстроить их по нужному Вам порядку.", 'sociable'); ?></small>
		</th>
		<td>
			<div style="width: 100%; height: 100%">
			<ul id="sociable_site_list">
				<?php foreach (array_merge($active, $disabled) as $sitename=>$site) { ?>
					<li id="<?php echo $sitename; ?>"
						class="sociable_site <?php echo (in_array($sitename, $active_sites)) ? "active" : "inactive"; ?>">
						<input
							type="checkbox"
							id="cb_<?php echo $sitename; ?>"
							name="active_sites[<?php echo $sitename; ?>]"
							<?php echo (in_array($sitename, $active_sites)) ? ' checked="checked"' : ''; ?>
						/>
						<?php
						$imagepath = get_option('soc_imagedir');
						
						if ($imagepath == "") {
							$imagepath = $socpluginpath.'images/';
						} else {		
							$imagepath .= (substr($imagepath,strlen($imagepath)-1,1)=="/") ? "" : "/";
						}
						
						if (strpos($site['favicon'], 'http') === 0) {
								$imgsrc = $site['favicon'];
							} else {
								$imgsrc = $imagepath.$site['favicon'];
							}
							echo "<img src=\"$imgsrc\" width=\"16\" height=\"16\" />";
						
						echo $sitename; ?>
					</li>
				<?php } ?>
			</ul>
			</div>
			<input type="hidden" id="site_order" name="site_order" value="<?php echo join('|', array_keys($soc_known_sites)) ?>" />
		</td>
	</tr>
	<tr>
		<th scope="row" valign="top">
			<?php _e("Отключить засветление иконок?", "soc"); ?>
		</th>
		<td>
			<input type="checkbox" name="disablealpha" <?php checked( get_option('soc_disablealpha'), true ) ; ?> />
		</td>
	</tr>	
	<tr>
		<th scope="row" valign="top">
			<?php _e("Заголовок перед иконками", "soc"); ?>
		</th>
		<td>
			<?php _e("Для полной настройки нужно скопировать содержимое <em>soc.css</em> из каталога плагина и вставить в <em>style.css</em> в каталоге вашей темы. Ниже нужно будет отключить использование CSS.", 'soc'); ?><br/>
			<input size="80" type="text" name="tagline" value="<?php echo attribute_escape(stripslashes(get_option('soc_tagline'))); ?>" />
		</td>
	</tr>
	<tr>
		<th scope="row" valign="top">
			<?php _e("Местоположение:", "soc"); ?>
		</th>
		<td>
			<br/>
			<?php
			$conditionals 	= get_option('soc_conditionals');
			?>
			<input type="checkbox" name="conditionals[is_home]"<?php checked($conditionals['is_home']); ?> /> <?php _e("На первой странице блогаFront page of the blog", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_single]"<?php checked($conditionals['is_single']); ?> /> <?php _e("В каждой статье блога", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_page]"<?php checked($conditionals['is_page']); ?> /> <?php _e('В статических страницах блога', 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_category]"<?php checked($conditionals['is_category']); ?> /> <?php _e("В категориях", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_tag]"<?php checked($conditionals['is_tag']); ?> /> <?php _e("В тегах", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_date]"<?php checked($conditionals['is_date']); ?> /> <?php _e("В архивах", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_author]"<?php checked($conditionals['is_author']); ?> /> <?php _e("В архивах автора", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_search]"<?php checked($conditionals['is_search']); ?> /> <?php _e("В результатах поиска", 'soc'); ?><br/>
			<input type="checkbox" name="conditionals[is_feed]"<?php checked($conditionals['is_feed']); ?> /> <?php _e("В RSS фидах", 'soc'); ?><br/>
		</td>
	</tr>
	<tr>
		<th scope="row" valign="top">
			<?php _e("Использование CSS:", "soc"); ?>
		</th>
		<td>
			<input type="checkbox" name="usecss" <?php checked( get_option('soc_usecss'), true ); ?> /> <?php _e("Использовать стили плагина?", "soc"); ?>
		</td>
	</tr>
	<tr>
		<th scope="row" valign="top">
			<?php _e("Использовать текстовых ссылок:", "soc"); ?>
		</th>
		<td>
			<input type="checkbox" name="usetextlinks" <?php checked( get_option('soc_usetextlinks'), true ); ?> /> <?php _e("Использовать текстовые ссылки вместо иконок?", "soc"); ?>
		</td>
	</tr>
	<tr>
		<th scope="row" valign="top">
			<?php _e("Открывать в новом окне:", "soc"); ?>
		</th>
		<td>
			<input type="checkbox" name="usetargetblank" <?php checked( get_option('soc_usetargetblank'), true ); ?> /> <?php _e("Использовать <code>target=_blank</code> для ссылок? (Ссылки будут открываться в новом окне)", "soc"); ?>
		</td>		
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td>
			<span class="submit"><input name="save" value="<?php _e("Сохранить изменения", 'soc'); ?>" type="submit" /></span>
			<span class="submit"><input name="restore" value="<?php _e("Восстановить настройки по умолчанию", 'soc'); ?>" type="submit"/></span>
		</td>
	</tr>
</table>

</div>
</form>
<?php
}

function soc_add_ozh_adminmenu_icon( $hook ) {
	static $socicon;
	if (!$socicon) {
		$socicon = WP_CONTENT_URL . '/plugins/' . plugin_basename(dirname(__FILE__)). '/book_add.png';
	}
	if ($hook == 'soc') return $socicon;
	return $hook;
}
add_filter( 'ozh_adminmenu_icon', 'soc_add_ozh_adminmenu_icon' );				

function soc_filter_plugin_actions( $links, $file ){
	static $this_plugin;
	if ( ! $this_plugin ) $this_plugin = plugin_basename(__FILE__);
	
	if ( $file == $this_plugin ){
		$settings_link = '<a href="options-general.php?page=soc">' . __('Settings') . '</a>';
		array_unshift( $links, $settings_link );
	}
	return $links;
}
add_filter( 'plugin_action_links', 'soc_filter_plugin_actions', 10, 2 );

?>