<?php
/*******************************************
* Thank-o-matic
* Re-edited by Adk-Team
* www.smfpersonal.net
* 2009-2011
*******************************************/

if (!defined('SMF'))
	die('Hacking attempt...');

function ThankYou()
{
	global $txt, $scripturl, $topic, $modSettings, $board, $user_info;
	global $sc, $board_info, $context, $settings, $sourcedir;
	global $smcFunc;

	// Load some Languagefiles :)
	loadLanguage('Errors');

	// Okay Okay ;D Most importend!
	if (empty($_GET['msg']) || !is_numeric($_GET['msg']) || empty($topic))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// First look if the Thank You closed?
	ThankYouPostCheckClosed();

	// Spam Protection :)
	if (!empty($modSettings['thankYouPostSpamProtection']) && !empty($user_info['last_thank_you_time']))
		if ($user_info['last_thank_you_time'] + $modSettings['thankYouPostSpamProtection'] > time())
			$smcFunc['fatal_error'](str_replace('[SECONDS]', $modSettings['thankYouPostSpamProtection'], $txt['thx_spamprotectionactive']), false);

	// Okay Thank You allowed?
	if (!allowedTo('thank_you_post_post'))
		$smcFunc['redirectexit']();

	// Okay i can do it now :)
	// First look blindly if the user allready give one to the post :)
	$request = $smcFunc['db_query']('', '
		SELECT id_thx_post, thx_time
		FROM {db_prefix}thank_you_post
		WHERE id_msg = {int:id_msg} AND id_member = {int:id_member}
		LIMIT 1',
		array(
			'id_msg' => (int) $_GET['msg'],
			'id_member' => $user_info['id']
		)
	);

	list($id_thx_post, $thx_time) = $smcFunc['db_fetch_row']($request);
	$smcFunc['db_free_result']($request);

	if (!empty($id_thx_post))
	{
		$replaced = str_replace('[TIME]', timeformat($thx_time), $txt['allready_postet_thx']);
		$smcFunc['fatal_error']($replaced, false);
	}

	// Only allowed to post for the first post of the topic?
	if (!empty($modSettings['thankYouPostFirstPostOnly']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_first_msg
			FROM {db_prefix}topics
			WHERE id_topic = {int:topic}
			LIMIT 1',
			array(
				'topic' => $topic,
			)
		);

		list($id_first_msg) = $smcFunc['db_fetch_row']($request);
		$smcFunc['db_free_result']($request);

		if (empty($id_first_msg) || $id_first_msg != $_GET['msg'])
			$smcFunc['fatal_error']($txt['onlyFirstPost_thx'], false);
	}
	// Look if only on Thank per topic is allowed :)
	elseif (empty($modSettings['thankYouPostOnePerPost']))
	{
		$request = $smcFunc['db_query']('', '
			SELECT id_thx_post, thx_time
			FROM {db_prefix}thank_you_post
			WHERE id_topic = {int:topic} AND id_member = {int:id_member}
			LIMIT 1',
			array(
				'topic' => $topic,
				'id_member' => $user_info['id']
			)
		);

		list($id_thx_post, $thx_time) = $smcFunc['db_fetch_row']($request);
		$smcFunc['db_free_result']($request);

		if (!empty($id_thx_post))
		{
			$replaced = str_replace('[TIME]', timeformat($thx_time), $txt['allready_postetTopic_thx']);
			$smcFunc['fatal_error']($replaced, false);
		}
	}

	// Load the Post data :)
	$post = $smcFunc['db_query']('', '
		SELECT id_msg, id_member, thank_you_post, thank_you_post_counter
		FROM {db_prefix}messages
		WHERE id_topic = {int:topic} AND id_msg = {int:id_msg}
		LIMIT 1',
			array(
				'topic' => $topic,
				'id_msg' => (int) $_GET['msg'],
			)
		);

	list($id_msg, $ID_MEMBER_POST, $status, $count) = $smcFunc['db_fetch_row']($post);
	$smcFunc['db_free_result']($post);

	if (empty($id_msg))
		$smcFunc['fatal_error']($txt['WMidTopicSet'], false);
	elseif ($user_info['id'] == $ID_MEMBER_POST)
		$smcFunc['fatal_error']($txt['Thxtomyself'], false);
	elseif ($status > 1)
		$smcFunc['fatal_error']($txt['thxislocked'], false);

	if (empty($status))
	{
		$smcFunc['db_query']('', '
			UPDATE {db_prefix}messages
			SET thank_you_post = 1
			WHERE id_msg = {int:id_msg}
			LIMIT 1',
			array(
				'id_msg' => (int) $_GET['msg'],
			)
		);
	}

	// Okay store the current time :)
	$thx_time = (int) time();

	// So mow add the now thx :)
	$smcFunc['db_insert']('normal', '{db_prefix}thank_you_post',
		// Columns to insert.
		array(
			'id_msg' => 'int',
			'id_topic' => 'int',
			'id_board' => 'int',
			'id_member' => 'int',
			'member_name' => 'string',
			'thx_time' => 'int',
		),
		// Data to put in.
		array(
			'id_msg' => (int) $id_msg,
			'id_topic' => (int) $topic,
			'id_board' => (int) $board,
			'id_member' => (int) $user_info['id'],
			'member_name' => $user_info['name'],
			'thx_time' => (int) time(),
		),
		// We had better tell SMF about the key, even though I can't remember why? ;)
		array('id_thx_post')
	);
	$id_thx_post = $smcFunc['db_insert_id']('{db_prefix}thank_you_post');

	// Update Stats :)
	updateMemberData($user_info['id'], array('thank_you_post_made' => '+', 'last_thank_you_time' => $thx_time));
	if (!empty($ID_MEMBER_POST))
	{
		updateMemberData($ID_MEMBER_POST, array('thank_you_post_became' => '+'));
		// Change the Karma?
		if (!empty($modSettings['thankYouPostIncraseKarmaGood']) && !empty($modSettings['karmaMode']))
			updateMemberData($ID_MEMBER_POST, array('karma_good' => '+'));
	}

	// Okay Update the counter :)
	ThankYouPostCount($id_msg);

	// Store id, id_msg and time of the latest thank_you Post
	ThankYouPostUpdateLastThankYou(
		array(
			'id_thx_post' => $id_thx_post,
			'id_msg' => $id_msg,
			'thx_time' => $thx_time,
		)
	);

	// Okay all done now redirect exit :)
	if (!isset($_GET['list']))
		$smcFunc['redirectexit']('topic='.$topic.'.msg'.$id_msg.'#msg'.$id_msg);
	else
		$smcFunc['redirectexit']('action=thankyoupostlist;topic='.$topic.'.0;msg='.$id_msg);
}

function ThankYouPostDelete($msg_ids = array(), $is_topic_delete = false)
{
	global $txt, $topic, $user_info, $topic, $modSettings, $smcFunc;

	$session = true;
	$isAllowed = true;
	$is_topic_delete = (bool) $is_topic_delete;

	if (empty($msg_ids) && (empty($topic) || empty($_GET['msg']) || !is_numeric($_GET['msg'])))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);
	// Massdelete is could be only made if you delete a thread or anything like that :)
	elseif (!empty($msg_ids) && empty($_GET['msg']))
	{
		$session = false;
		$isAllowed = false;
		$msg_ids = !is_array($msg_ids) ? array($msg_ids) : $msg_ids;
	}
	else
	{
		$msg_ids = array($_GET['msg']);
		$topic_delete = false;
	}

	if ($session)
		checkSession('request');

	// Fix something
	$msg_ids = array_unique($msg_ids);

	// Load the Post data :)
	$post = $smcFunc['db_query']('', '
		SELECT id_msg, id_member
		FROM {db_prefix}messages
		WHERE id_msg IN ({array_int:id_msgs})
			AND thank_you_post != 0
		LIMIT {int:limit}',
		array(
			'limit' => count($msg_ids),
			'id_msgs' => $msg_ids,
		)
	);

	$msg_ids = array();
	$msg_poster = array();

	while ($row = $smcFunc['db_fetch_assoc']($post))
	{
		// Built the real msg_ids ;)
		$msg_ids[] = $row['id_msg'];
		if (!empty($row['id_member']))
			$msg_poster[$row['id_msg']] = $row['id_member'];
	}

	$smcFunc['db_free_result']($post);

	// At least nothing to do?
	if (empty($msg_ids))
		return;

	$msg_ids = array_unique($msg_ids);

	// So i look if i need to check some rights :)
	if ($isAllowed)
	{
		if (count($msg_ids) != 1)
			$smcFunc['fatal_error']($txt['thankyouposterrorinscript']);

		$ID_MEMBER_POST = !empty($msg_poster) ? current($msg_poster) : 0;

		// Okay mal rechte prfen :)
		if (!allowedTo('thank_you_post_delete_any') && !(allowedTo('thank_you_post_delete_own') && $user_info['id'] == $ID_MEMBER_POST))
			$smcFunc['fatal_error']($txt['thxdeletenor'], false);
	}

	// Load the THX Infomations :)
	$poster = array();
	$thx_delete = array();

	$thx = $smcFunc['db_query']('', '
		SELECT id_thx_post, id_member, id_msg
		FROM {db_prefix}thank_you_post
		WHERE id_msg IN ({array_int:id_msgs})',
		array(
			'id_msgs' => $msg_ids,
		)
	);

	while ($row = $smcFunc['db_fetch_assoc']($thx))
	{
		$poster[$row['id_msg']][] = $row['id_member'];
		$thx_delete[] = $row['id_thx_post'];
	}

	$smcFunc['db_free_result']($thx);

	// So i need to split between single or multi delete :)
	if (!empty($thx_delete))
			// Delete the Thank You Posts :)
			$smcFunc['db_query']('', '
				DELETE FROM {db_prefix}thank_you_post
				WHERE id_thx_post IN ({array_int:id_thx_posts})
				LIMIT {int:limit}',
				array(
					'limit' => count($thx_delete),
					'id_thx_posts' => $thx_delete
				)
			);

	// Okay set counter back to 0 and the status to 0 :)
	// Okay now correct member Settings *g*
	if (!empty($poster))
		foreach ($poster as $id_posters)
			updateMemberData($id_posters, array('thank_you_post_made' => '-'));
	// now the resived Thank You
	if (!empty($msg_poster))
		foreach ($msg_poster as $id_msg => $ID_MEMBER_POST)
		{
			if (isset($poster[$id_msg]))
			{
				updateMemberData($ID_MEMBER_POST, array('thank_you_post_became' => 'thank_you_post_became - '.count($poster[$id_msg])));
				if (!empty($modSettings['karmaMode']) && !empty($modSettings['thankYouPostIncraseKarmaGood']))
				{
					// Call his current Karma Points...
					global $user_profile;
					loadMemberData(array($ID_MEMBER_POST));
					if (!empty($user_profile[$ID_MEMBER_POST]))
					{
						$newKarma = $user_profile[$ID_MEMBER_POST]['karma_good'] - count($poster[$id_msg]);
						updateMemberData($ID_MEMBER_POST, array('karma_good' => (int) $newKarma));
					}
				}
			}
		}

	// Okay now reset the Stats :), i think i can do this blind ;D
	$smcFunc['db_query']('', '
		UPDATE {db_prefix}messages
		SET thank_you_post = 0, thank_you_post_counter = 0
		WHERE id_msg IN ({array_int:id_msgs})
		LIMIT {int:limit}',
		array(
			'limit' => count($msg_ids),
			'id_msgs' => $msg_ids,
		)
	);

	// Okay depent on what the reason for the delete i change the loging :) (This will only work if the moderation log is enabled!
	if (!$is_topic_delete && !empty($msg_ids) && !empty($modSettings['modlog_enabled']) && !empty($modSettings['thankYouPostModerationLog']))
	{
		// Okay a topic multiple delete :)
		foreach ($msg_ids as $id_msg)
			logAction(
				'delete',
				array(
					'message' => $id_msg,
					'member' => (!empty($msg_poster[$id_msg]) ? $msg_poster[$id_msg] : 0)
				)
			);
	}

	// Update Thank-O-Matic Stats...
	ThankYouPostUpdateLastThankYou();

	// Uff i'm finished now... hope it work all correct XD (still hoping after programming it) okay redirect, or not
	if (!empty($_GET['msg']) && !empty($topic) && $session)
		$smcFunc['redirectexit']('topic='.$topic.'.msg'.$_GET['msg'].'#msg'.$_GET['msg']);
	else
		return;
}

function ThankYouPostDeletePost()
{
	global $txt, $topic, $user_info, $modSettings, $smcFunc;

	checkSession('get');

	if (empty($topic) || empty($_GET['thxid']) || !is_numeric($_GET['thxid']))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// Load this thanks and look if the user allowed to it, or if the rights are ;)
	$thx = $smcFunc['db_query']('', '
		SELECT id_thx_post, id_member, id_msg
		FROM {db_prefix}thank_you_post
		WHERE id_thx_post = {int:id_thx_post}
			AND id_topic = {int:topic}
		LIMIT 1',
		array(
			'id_thx_post' => (int) $_GET['thxid'],
			'topic' => $topic,
		)
	);

	list($ID_THX, $ID_MEMBER_THX, $id_msg) = $smcFunc['db_fetch_row']($thx);
	$smcFunc['db_free_result']($thx);

	if (empty($ID_THX))
		$smcFunc['fatal_error']($txt['thxidnotfound'], false);

	// Okay let's look for the rights first :)
	if (!allowedTo('thank_you_post_delete_mem_any') && !(allowedTo('thank_you_post_delete_mem_own') && $user_info['id'] == $ID_MEMBER_THX))
		$smcFunc['fatal_error']($txt['thxdeletenormem'], false);

	// More than one poster? if not the rights a little bit diffrent ;P
	$thx = $smcFunc['db_query']('', '
		SELECT id_thx_post
		FROM {db_prefix}thank_you_post
		WHERE id_msg = {int:id_msg}
		LIMIT 2',
		array(
			'id_msg' => (int) $id_msg,
		)
	);

	$count = $smcFunc['db_num_rows']($thx);
	$smcFunc['db_free_result']($thx);

	// This is a delete of a the thank you post so this is not allowed to every one!
	if ($count != 2)
	{
		// I add now the msg so it look like a delete :D
		$_GET['msg'] = $id_msg;
		// Okay delete with the check of the rights ;D
		return ThankYouPostDelete();
	}
	else
	{
		// I need the poster to correct the stats ;)
		$post = $smcFunc['db_query']('', '
			SELECT id_member
			FROM {db_prefix}messages
			WHERE id_msg = {int:id_msg}
			LIMIT 1',
			array(
				'id_msg' => (int) $id_msg,
			)
		);

		list($ID_MEMBER_POST) = $smcFunc['db_fetch_row']($post);
		$smcFunc['db_free_result']($post);
	}

	// Okay here this is a normal delete :)
	$smcFunc['db_query']('', '
		DELETE FROM {db_prefix}thank_you_post
		WHERE id_thx_post = {int:id_thx}
		LIMIT 1',
		array(
			'id_thx' => (int) $ID_THX,
		)
	);

	// Okay Correct the stats ;D
	updateMemberData($ID_MEMBER_THX, array('thank_you_post_made' => '-'));
	if (!empty($ID_MEMBER_POST))
	{
		updateMemberData($ID_MEMBER_POST, array('thank_you_post_became' => '-'));
		// Reduce his Karma, too?
		if (!empty($modSettings['karmaMode']) && !empty($modSettings['thankYouPostIncraseKarmaGood']))
			updateMemberData($ID_MEMBER_POST, array('karmaGood' => '-'));
	}
	// Okay Update the counter :)
	ThankYouPostCount($id_msg, '-');

	// Update Thank-O-Matic Stats... Only if the current id = last id anything else does not need and update :D
	if($ID_THX == $modSettings['thank_you_post_last_id'])
		ThankYouPostUpdateLastThankYou();

	// Okay depent on what the reason for the delete i change the loging :) (This will only work if the moderation log is enabled!
	if (!empty($msg_ids) && !empty($modSettings['modlog_enabled']) && !empty($modSettings['thankYouPostModerationLog']))
				logAction(
					'delete',
					array(
						'topic' => $topic,
						'message' => $id_msg,
						'member' => (!empty($ID_MEMBER_POST) ? $ID_MEMBER_POST : 0)
					)
				);

	// redirectexit now :=)
	$smcFunc['redirectexit']('topic='.$topic.'.msg'.$id_msg.'#msg'.$id_msg);
}

// This Functions is used for the listing and for normal load in Display php :x

function ThankYouPostList($msg_ids = array(), $preview = false, $board_allowed = false)
{
	global $txt, $scripturl, $topic,  $modSettings, $board, $user_info;
	global $sc, $board_info, $context, $settings, $sourcedir, $color_profile;
	global $smcFunc;


	// The minimum Settings for this script ;)
	$modSettings += array(
		'thankYouPostColors' => 0,
		'thankYouPostPreview' => 0,
		'thankYouPostPreviewHM' => 0,
		'thankYouPostPreviewOrder' => 0,
		'thankYouPostFullOrder' => 0,
	);

	// I need to do nothing?
	if ($preview && empty($modSettings['thankYouPostPreview']))
		return;

	// Sometimes i need to checkup the board allowed extra
	if ($board_allowed)
	{
		$boardIDs = boardsAllowedTo('thank_you_post_show');
		$board_allowed = !(isset($boardIDs[0]) && $boardIDs[0] === 0); // This will only happen if he/she is allowed to everything :)
		// Not allowed to see any of this boards? Okay than i think i need to do nothing :)
		if (empty($boardIDs) && $board_allowed)
			return;
	}

	if (empty($msg_ids) && empty($_GET['msg']) && !is_numeric($_GET['msg']))
		return;
	elseif (!empty($_GET['msg']) && is_numeric($_GET['msg']))
		$msg_ids = $_GET['msg'];

	$msg_ids = !is_array($msg_ids) ? array($msg_ids) : $msg_ids;
	// First the where :D
	if (count($msg_ids) == 1)
		$where = "WHERE id_msg = ".current($msg_ids);
	else
	{
		$msg_ids = array_unique($msg_ids);
		$where = "WHERE id_msg IN (".implode(', ', $msg_ids).")";
	}

	// Some extra checkup?
	if ($board_allowed)
		$andBoard = "AND id_board IN(".implode(',', $boardIDs).")";
	else
		$andBoard = "";

	// Select Order Number between Prieview or Full Order :)
	$order = $preview ? $modSettings['thankYouPostPreviewOrder'] : $modSettings['thankYouPostFullOrder'];

	// Set the real Order now :)
	if ($order == 1)
		$sort = 'ORDER BY thx.id_thx_post DESC';
	elseif ($order == 2 && !$preview)
		$sort = 'ORDER BY mem.member_name';
	else
		$sort = 'ORDER BY thx.id_thx_post';

	// Limit for each list
	$limit = $preview && !empty($modSettings['thankYouPostPreviewHM']) ? $modSettings['thankYouPostPreviewHM'] : '0';

	// Okay Let's look and remove the not thank you posts :), also collect some datas :)
	// This is importend! I will only build list for thing where really a known post is!
	$andCondition = ' AND thank_you_post != 0';

	// Load the Post data :)
	$post = $smcFunc['db_query']('', "
		SELECT id_msg, id_member, poster_name, thank_you_post_counter, thank_you_post
		FROM {db_prefix}messages
		$where $andBoard $andCondition
		LIMIT ".count($msg_ids));

	$msg_ids = array();
	$msg_poster = array();
	$msg_poster_name = array();

	while ($row = $smcFunc['db_fetch_assoc']($post))
	{
		// Built the real msg_ids ;)
		$msg_ids[] = $row['id_msg'];
		if (!empty($row['id_member']))
			$msg_poster[$row['id_msg']] = $row['id_member'];
		// This is for guests :x
		$msg_poster_name[$row['id_msg']] = $row['poster_name'];

		// This are some additional Infos =)
		$context['thank_you_post_info'][$row['id_msg']] = array(
			'id_msg' => $row['id_msg'],
			'thank_you_post_counter' => $row['thank_you_post_counter'],
			'thank_you_post' => $row['thank_you_post'],
		);
	}

	$smcFunc['db_free_result']($post);

	// At least nothing to do? Post does not exist anymore .oO(deleted in the meantime of this call :P)
	if (empty($msg_ids))
		return;
	elseif (count($msg_ids) == 1)
	{
		$where = "WHERE id_msg = ".current($msg_ids);
		$id_msg = current($msg_ids);
	}
	else
	{
		$msg_ids = array_unique($msg_ids);
		$where = "WHERE id_msg IN (".implode(', ', $msg_ids).")";
	}

	// Okay i can set a real limit =D if only one id is searched :D
	if (!empty($limit) && count($msg_ids) == 1)
	{
		$speciallimit = 'LIMIT '.$modSettings['thankYouPostPreviewHM'];
		$limit = 0;
	}
	else
		$speciallimit = '';

	// Load the Memberdatas :) only if it not a preview :)
	if (!$preview)
		loadMemberData($msg_poster, 'minimal');

	$collecting_ids = array_values($msg_poster);

	// So i load a huge array okay depend on the thank who made xD... somehow i must find a better way for limit :x
	$thx = $smcFunc['db_query']('', "
		SELECT
			thx.id_thx_post AS ID_THX, thx.id_msg AS id_msg, thx.id_topic AS id_topic,
			thx.thx_time AS thx_time,
			IFNULL(mem.id_member, 0) AS id_member, IFNULL(mem.real_name, thx.member_name) AS member_name
		FROM {db_prefix}thank_you_post AS thx
			LEFT JOIN {db_prefix}members AS mem ON (thx.id_member = mem.id_member)
		$where
		$sort
		$speciallimit");

	while ($row = $smcFunc['db_fetch_assoc']($thx))
	{
		// Current Member has postet?
		if (!isset($context['thank_you_post'][$row['id_msg']]['user_postet']) || !$context['thank_you_post'][$row['id_msg']]['user_postet'])
			$context['thank_you_post'][$row['id_msg']]['user_postet'] = $user_info['id'] == $row['id_member'];

		// Show only a small amount of it?
		if (!empty($limit))
		{
			if (!isset($counter[$row['id_msg']]))
				$counter[$row['id_msg']] = 1;
			else
				$counter[$row['id_msg']]++;

			if ($counter[$row['id_msg']] > $limit)
				continue;
		}

		// Okay Start the Array :)
		$context['thank_you_post'][$row['id_msg']]['fulllist'][$row['ID_THX']] = array(
			'ID_THX' => $row['ID_THX'],
			'id_member' => $row['id_member'],
			'member_name' => $row['member_name'],
			'href' => !empty($row['id_member']) ? $scripturl . '?action=profile;u=' . $row['id_member'] : '',
			'link' => !empty($row['id_member']) ? '<a href="' . $scripturl . '?action=profile;u=' . $row['id_member'] . '" title="'. $txt['thank_you_post_thx_display'] .' '. $txt['thank_you_post_made_display'] . ': '.timeformat($row['thx_time'], false) . '">' . $row['member_name'] . '</a>' : $row['member_name'],
			'deletelink' => allowedTo('thank_you_post_delete_mem_any') || (allowedTo('thank_you_post_delete_mem_own') && $user_info['id'] == $row['id_member']) ? ' <a href="'.$scripturl.'?action=thankyoupostdm;thxid='.$row['ID_THX'].';topic='.$topic.';sesc='.$context['session_id'].'" onclick="return confirm(\''.$txt['remove_thank_you_post_mem'].'?\');"><span style="color:red">*</span></a>' : '',
			'thx_timestamp' => $row['thx_time'],
			'thx_time' => timeformat($row['thx_time']),
			'last' => false,
		);

		// Collect some id's if i need the colors ;)
		if (!empty($row['id_member']))
			$collecting_ids[] = $row['id_member'];
	}

	$smcFunc['db_free_result']($thx);

	if (empty($context['thank_you_post']))
	{
		// Fix empty and not existing thank you's hand deleted? Bug?
		if (!empty($_GET['msg']) && !empty($context['thank_you_post_info'][$_GET['msg']]['thank_you_post']))
		{
			$smcFunc['db_query']('', '
				UPDATE {db_prefix}messages
					SET	thank_you_post_counter = 0, thank_you_post = 0
				WHERE	id_msg = {int:id_msg}',
				array(
					'id_msg' => (int) $_GET['msg'],
				)
			);
		}
		return;
	}

	// Okay Fix the colors :)
	if (!empty($modSettings['thankYouPostColors']))
	{
		// Okay load the colors and add them :)
		thank_you_post_loadColors($collecting_ids);

		// Hoho let'a array_walk ;) okay its a way but i think faster for me is foreach xD
		foreach ($context['thank_you_post'] as $id_msg => $content)
		{
			if (!empty($content['fulllist']))
			{
				foreach ($content['fulllist'] as $ID_THX => $items)
				{
					// Okay Let's boogie woogie ;D
					$profile = $color_profile[$context['thank_you_post'][$id_msg]['fulllist'][$ID_THX]['id_member']];
					if (!empty($profile['member_group_color']) || !empty($profile['post_group_color']))
					{
						$time = timeformat($context['thank_you_post'][$id_msg]['fulllist'][$ID_THX]['thx_timestamp'], false);
						$context['thank_you_post'][$id_msg]['fulllist'][$ID_THX]['link'] = '<a href="' . $scripturl . '?action=profile;u=' . $profile['id_member'] . '" title="'. $txt['thank_you_post_thx_display'] .' '. $txt['thank_you_post_made_display'] . ': ' . $time . '"><span style="color:'.(!empty($profile['member_group_color']) ? $profile['member_group_color'] : $profile['post_group_color']).';">' . $profile['real_name'] . '</span></a>';
					}
				}
				// Hehe a way to find the last item ;D
				$context['thank_you_post'][$id_msg]['fulllist'][$ID_THX]['last'] = true;
			}
		}
	}
	// Okay no colors but i need to fix something else :X
	else
	{
			foreach ($msg_ids as $id_msg)
			{
				if (!empty($context['thank_you_post'][$id_msg]['fulllist']))
				{
					// Hehe look strange but work fine and fast :)
					end($context['thank_you_post'][$id_msg]['fulllist']);
					// Last key of the list ;)
					$key = key($context['thank_you_post'][$id_msg]['fulllist']);
					// Set it to the last one
					$context['thank_you_post'][$id_msg]['fulllist'][$key]['last'] = true;
					// do like i'm do nothing ;D
					reset($context['thank_you_post'][$id_msg]['fulllist']);
				}
			}
	}

	// If this information is avaible i load this ;).
	ThankYouPostListStandardSetup();

	return;
}

// A one time Function to load all needed data :)
function ThankYouPostListStandardSetup()
{
	global $context, $modSettings, $txt;

	if (!empty($context['thank_you_post_template']))
		return;

	// One time fix... possible never set at the moment :D
	if (!isset($modSettings['thankYouPostStartOutput']))
		$modSettings += array(
			'thankYouPostStartOutput' => 0,
			'thankYouPostCounterOutput' => 0,
			'thankYouPostStartOutputText' => '',
		);

	// Okay fill the values :D
	$context['thank_you_post_template'] = array(
		'disable_start_text' => $modSettings['thankYouPostStartOutput'] == 3,
		'disable_counter_text' => $modSettings['thankYouPostCounterOutput'] == 2,
		'disable_counter_link' => $modSettings['thankYouPostCounterOutput'] == 1,
		'start_text' => $txt['followgiveathank'],
	);

	// Change the start text of the thank o matic information
	if (!empty($modSettings['thankYouPostStartOutput']) && empty($modSettings['thankYouPostStartOutputText']))
		$context['thank_you_post_template']['start_text'] = '';
	elseif ($modSettings['thankYouPostStartOutput'] == 1)
		$context['thank_you_post_template']['start_text'] = parse_bbc($modSettings['thankYouPostStartOutputText']);
	elseif ($modSettings['thankYouPostStartOutput'] == 2)
	{
		if(!empty($txt[$modSettings['thankYouPostStartOutputText']]))
			$context['thank_you_post_template']['start_text'] = $txt[$modSettings['thankYouPostStartOutputText']];
		else
			$context['thank_you_post_template']['start_text'] = '';
	}
}

function ThankYouPostListShow()
{
	global $txt, $scripturl, $topic,  $modSettings, $board, $user_info;
	global $sc, $board_info, $context, $settings, $sourcedir, $memberContext;
	global $smcFunc;

	if (!allowedTo('thank_you_post_show'))
		$smcFunc['redirectexit']();

	// Load the list ;)
	ThankYouPostList();

	// Okay the thank you is allready deleted... go back to the thread or to the startpage :)
	if (empty($context['thank_you_post']))
	{
		if (!empty($topic))
		{
			if (!isset($_GET['msg']))
				$smcFunc['redirectexit']('topic='.$topic.'.msg'.$_GET['msg'].'#msg'.$_GET['msg']);
			else
				$smcFunc['redirectexit']('topic='.$topic.'.0');
		}
		else
			$smcFunc['redirectexit']();
	}

	// Template
	loadTemplate('ThankYouPost', 'forum');

	// Get all the important topic info.
	$request = $smcFunc['db_query']('', '
		SELECT
			t.num_replies, t.num_views, t.locked, ms.subject, t.is_sticky, t.id_poll,
			t.thank_you_post_locked,
			t.id_member_started, t.id_first_msg, t.id_last_msg, t.approved,
			' . ($user_info['is_guest'] ? '0' : 'IFNULL(lt.id_msg, -1) + 1') . ' AS new_from
		FROM {db_prefix}topics AS t
			INNER JOIN {db_prefix}messages AS ms ON (ms.id_msg = t.id_first_msg)' . ($user_info['is_guest'] ? '' : '
			LEFT JOIN {db_prefix}log_topics AS lt ON (lt.id_topic = {int:topic} AND lt.id_member = {int:id_member})') .'
		WHERE t.id_topic = {int:topic}
		LIMIT 1',
		array(
			'topic' => $topic,
			'id_member' => $user_info['id'],
		)
	);
	if ($smcFunc['db_num_rows']($request) == 0)
		fatal_lang_error('not_a_topic', false);
	$topicinfo = $smcFunc['db_fetch_assoc']($request);
	$smcFunc['db_free_result']($request);

	// Build the link tree.
	$context['linktree'][] = array(
		'url' => $scripturl . '?topic=' . $topic . '.0',
		'name' => $topicinfo['subject'],
		'extra_before' => $settings['linktree_inline'] ? $txt['topic'] . ': ' : ''
	);
	// Extend the thank you ;) to the link tree :D.
	$context['linktree'][] = array(
		'url' => $scripturl . '?action=thankyoupostlist;topic=' . $topic . '.0;msg='.$_GET['msg'],
		'name' => $txt['thankyoupostlist']
	);

	// Build a list of this board's moderators.
	$context['moderators'] = &$board_info['moderators'];
	$context['link_moderators'] = array();
	if (!empty($board_info['moderators']))
	{
		// Add a link for each moderator...
		foreach ($board_info['moderators'] as $mod)
			$context['link_moderators'][] = '<a href="' . $scripturl . '?action=profile;u=' . $mod['id'] . '" title="' . $txt['board_moderator'] . '">' . $mod['name'] . '</a>';

		// And show it after the board's name.
		$context['linktree'][count($context['linktree']) - 2]['extra_after'] = ' (' . (count($context['link_moderators']) == 1 ? $txt['moderator'] : $txt['moderators']) . ': ' . implode(', ', $context['link_moderators']) . ')';
	}

	// Did this user start the topic or not?
	$context['user']['started'] = $user_info['id'] == $topicinfo['id_member_started'] && !$user_info['is_guest'];
	$context['topic_starter_id'] = $topicinfo['id_member_started'];

	// Now set all the wonderful, wonderful permissions... like moderation ones...
	$common_permissions = array(
		'can_approve' => 'approve_posts',
		'can_ban' => 'manage_bans',
		'can_sticky' => 'make_sticky',
		'can_merge' => 'merge_any',
		'can_split' => 'split_any',
		'calendar_post' => 'calendar_post',
		'can_mark_notify' => 'mark_any_notify',
		'can_send_topic' => 'send_topic',
		'can_send_pm' => 'pm_send',
		'can_report_moderator' => 'report_any',
		'can_moderate_forum' => 'moderate_forum',
		'can_issue_warning' => 'issue_warning',
		'can_restore_topic' => 'move_any',
		'can_restore_msg' => 'move_any',
	);
	foreach ($common_permissions as $contextual => $perm)
		$context[$contextual] = allowedTo($perm);

	// Permissions with _any/_own versions.  $context[YYY] => ZZZ_any/_own.
	$anyown_permissions = array(
		'can_move' => 'move',
		'can_lock' => 'lock',
		'can_delete' => 'remove',
		'can_add_poll' => 'poll_add',
		'can_remove_poll' => 'poll_remove',
		'can_reply' => 'post_reply',
		'can_reply_unapproved' => 'post_unapproved_replies',
	);
	foreach ($anyown_permissions as $contextual => $perm)
		$context[$contextual] = allowedTo($perm . '_any') || ($context['user']['started'] && allowedTo($perm . '_own'));

	// Cleanup all the permissions with extra stuff...
	$context['can_mark_notify'] &= !$context['user']['is_guest'];
	$context['can_sticky'] &= !empty($modSettings['enableStickyTopics']);
	$context['calendar_post'] &= !empty($modSettings['cal_enabled']);
	$context['can_add_poll'] &= $modSettings['pollMode'] == '1' && $topicinfo['id_poll'] <= 0;
	$context['can_remove_poll'] &= $modSettings['pollMode'] == '1' && $topicinfo['id_poll'] > 0;
	$context['can_reply'] &= empty($topicinfo['locked']) || allowedTo('moderate_board');
	$context['can_reply_unapproved'] &= $modSettings['postmod_active'] && (empty($topicinfo['locked']) || allowedTo('moderate_board'));
	$context['can_issue_warning'] &= $modSettings['warning_settings'][0] == 1;
	// Handle approval flags...
	$context['can_reply_approved'] = $context['can_reply'];
	$context['can_reply'] |= $context['can_reply_unapproved'];
	$context['can_mark_unread'] = !$user_info['is_guest'] && $settings['show_mark_read'];

	$context['can_send_topic'] = (!$modSettings['postmod_active'] || $topicinfo['approved']) && allowedTo('send_topic');

	// Start this off for quick moderation - it will be or'd for each post.
	$context['can_remove_post'] = allowedTo('delete_any') || (allowedTo('delete_replies') && $context['user']['started']);

	// Can restore topic?  That's if the topic is in the recycle board and has a previous restore state.
	$context['can_restore_topic'] &= !empty($modSettings['recycle_enable']) && $modSettings['recycle_board'] == $board && !empty($topicinfo['id_previous_board']);
	$context['can_restore_msg'] &= !empty($modSettings['recycle_enable']) && $modSettings['recycle_board'] == $board && !empty($topicinfo['id_previous_topic']);

	// Information about the current topic...
	$context['is_locked'] = $topicinfo['locked'];
	$context['is_sticky'] = $topicinfo['is_sticky'];
	$context['is_very_hot'] = $topicinfo['num_replies'] >= $modSettings['hotTopicVeryPosts'];
	$context['is_hot'] = $topicinfo['num_replies'] >= $modSettings['hotTopicPosts'];
	$context['is_approved'] = $topicinfo['approved'];

	// Some Thank You things ;)
	$context['is_thank_you_post_locked'] = $topicinfo['thank_you_post_locked'];
	$context['thank_you_lock_allowed'] = !empty($board_info['thank_you_post_enable']) && !$user_info['is_guest'] && (allowedTo('thank_you_post_lock_all_any') || (allowedTo('thank_you_post_lock_all_own') && $user_info['id'] == $topicinfo['id_member_started']));
	$context['thank_you_post_enable'] = $board_info['thank_you_post_enable'];
	$context['thank_you_post_unlock_all'] = false;
	$context['can_send_pm'] = allowedTo('send_pm');

	// Check if spellchecking is both enabled and actually working. (for quick reply.)
	$context['show_spellchecking'] = !empty($modSettings['enableSpellChecking']) && function_exists('pspell_new');
	$context['verification_message'] = !$user_info['is_mod'] && !$user_info['is_admin'] && !empty($modSettings['posts_require_captcha']) && ($user_info['posts'] < $modSettings['posts_require_captcha'] || ($user_info['is_guest'] && $modSettings['posts_require_captcha'] == -1)) ? sprintf($txt['quick_reply_verification'], ($modSettings['posts_require_captcha'] == -1 ? $txt['quick_reply_verification_guests'] : sprintf($txt['quick_reply_verification_posts'], $modSettings['posts_require_captcha']))) : '';

	// Are we showing signatures - or disabled fields?
	$context['signature_enabled'] = substr($modSettings['signature_settings'], 0, 1) == 1;
	$context['disabled_fields'] = isset($modSettings['disabled_profile_fields']) ? array_flip(explode(',', $modSettings['disabled_profile_fields'])) : array();

	// We don't want to show the poll icon in the topic class here, so pretend it's not one.
	$context['is_poll'] = false;
	determineTopicClass($context);

	$context['user']['started'] = $user_info['id'] == $topicinfo['id_member_started'] && !$user_info['is_guest'];
	$context['topic_starter_id'] = $topicinfo['id_member_started'];

	// Set the topic's information for the template.
	$context['subject'] = $topicinfo['subject'];
	$context['num_views'] = $topicinfo['num_views'];
	$context['num_replies'] = $topicinfo['num_replies'];
	$context['topic_first_message'] = $topicinfo['id_first_msg'];

	$messages_request = false;
	$context['first_message'] = 0;
	$context['first_new_message'] = false;

	// Search the start? Okay i have it secret added *g*
	$context['start'] = $_REQUEST['start'];

	// Load the postinfomation :)
	$post = $smcFunc['db_query']('', '
		SELECT
			id_msg, icon, subject, poster_time, poster_ip, id_member, modified_time, modified_name, body,
			smileys_enabled, poster_name, poster_email, thank_you_post, thank_you_post_counter, approved
		FROM {db_prefix}messages
		WHERE id_msg = {int:id_msg}
		LIMIT 1',
		array(
			'id_msg' => (int) $_GET['msg'],
		)
	);

	$message = $smcFunc['db_fetch_assoc']($post);
	$smcFunc['db_free_result']($post);

	// Load Member Data of the Post
	if (!empty($message['id_member']))
		loadMemberData($message['id_member']);

	// If it couldn't load, or the user was a guest.... someday may be done with a guest table.
	if (!loadMemberContext($message['id_member']))
	{
		// Notice this information isn't used anywhere else....
		$memberContext[$message['id_member']]['name'] = $message['poster_name'];
		$memberContext[$message['id_member']]['id'] = 0;
		$memberContext[$message['id_member']]['group'] = $txt['guest_title'];
		$memberContext[$message['id_member']]['link'] = $message['poster_name'];
		$memberContext[$message['id_member']]['email'] = $message['poster_email'];
		$memberContext[$message['id_member']]['show_email'] = showEmailAddress(true, 0);
		$memberContext[$message['id_member']]['is_guest'] = true;
	}
	else
	{
		$memberContext[$message['id_member']]['can_view_profile'] = allowedTo('profile_view_any') || ($message['id_member'] == $user_info['id'] && allowedTo('profile_view_own'));
		$memberContext[$message['id_member']]['is_topic_starter'] = $message['id_member'] == $context['topic_starter_id'];
		$memberContext[$message['id_member']]['can_see_warning'] = !isset($context['disabled_fields']['warning_status']) && $memberContext[$message['id_member']]['warning_status'] && (($context['user']['can_mod'] || !empty($modSettings['warning_show'])) || ($memberContext[$message['id_member']]['id'] == $context['user']['id'] && !empty($modSettings['warning_show']) && $modSettings['warning_show'] == 1));
	}

	$memberContext[$message['id_member']]['ip'] = $message['poster_ip'];

	// $context['icon_sources'] says where each icon should come from - here we set up the ones which will always exist!
	if (empty($context['icon_sources']))
	{
		$stable_icons = array('xx', 'thumbup', 'thumbdown', 'exclamation', 'question', 'lamp', 'smiley', 'angry', 'cheesy', 'grin', 'sad', 'wink', 'moved', 'recycled', 'wireless', 'clip');
		$context['icon_sources'] = array();
		foreach ($stable_icons as $icon)
			$context['icon_sources'][$icon] = 'images_url';
	}

	// If you're a lazy bum, you probably didn't give a subject...
	$message['subject'] = $message['subject'] != '' ? $message['subject'] : $txt['no_subject'];

	// This Handels the Hidetag ;)...
	$context['user_post_avaible'] = 0;
	// This Thx can unhide itself?
	if (!$user_info['is_guest'])
	{
		if ((!empty($modSettings['thankYouPostThxUnhideAll']) || !empty($modSettings['thankYouPostUnhidePost'])) && $context['thank_you_post'][$message['id_msg']]['user_postet'])
			$context['user_post_avaible'] = 1;
		// Okay you postet somewhere a thx and can see this hidden conent?
		elseif (!empty($modSettings['thankYouPostThxUnhideAll']))
		{
			// Look for Thx post made in the Thread ;)
			$check = $smcFunc['db_query']('', '
				SELECT id_thx_post
				FROM {db_prefix}thank_you_post
				WHERE id_member = {int:id_member}
				AND id_topic = {int:topic}
				LIMIT 1',
				array(
					'topic' => $topic,
					'id_member' => $user_info['id'],
				)
			);

			list($ID_THX) = $smcFunc['db_fetch_row']($check);
			mysql_free_result;

			if (!empty($ID_THX))
				$context['user_post_avaible'] = 1;
		}

		// Okay Hide Standard is enabled, and i look if you postet here?
		if (empty($context['user_post_avaible']) && empty($modSettings['thankYouPostDisableUnhide']))
		{
			$request = $smcFunc['db_query']('', '
				SELECT id_msg, id_member
				FROM {db_prefix}messages
				WHERE id_topic = {int:topic} AND id_member = {int:id_member}
				LIMIT 1',
				array(
					'topic' => $topic,
					'id_member' => $user_info['id'],
				)
			);

			if ($smcFunc['db_num_rows']($request)) $context['user_post_avaible'] = 1;
			else $context['user_post_avaible'] = 0;
			$smcFunc['db_free_result']($request);
		}
	}
	else
		$context['user_post_avaible'] = 0;

	// Do the censor things.
	censorText($message['body']);
	censorText($message['subject']);

	// Run BBC interpreter on the message.
	$message['body'] = parse_bbc($message['body'], $message['smileys_enabled'], $message['id_msg']);

	// Remember which message this is.  (ie. reply #83)
	$counter = empty($options['view_newest_first']) ? $context['start'] : $context['total_visible_posts'] - $context['start'];
	$context['counter'] = $counter;

	// Are you allowed to remove at least a single reply?
	$context['can_remove_post'] |= allowedTo('delete_own') && (empty($modSettings['edit_disable_time']) || $message['poster_time'] + $modSettings['edit_disable_time'] * 60 >= time()) && $message['id_member'] == $user_info['id'];

	// Okay Build the post ;)
	$context['thank_you_post']['post'] = array(
		'id' => $message['id_msg'],
		'alternate' => 0,
		'href' => $scripturl . '?topic=' . $topic . '.msg' . $message['id_msg'] . '#msg' . $message['id_msg'],
		'link' => '<a href="' . $scripturl . '?topic=' . $topic . '.msg' . $message['id_msg'] . '#msg' . $message['id_msg'] . '">' . $message['subject'] . '</a>',
		'member' => &$memberContext[$message['id_member']],
		'icon' => $message['icon'],
		'icon_url' => $settings[$context['icon_sources'][$message['icon']]] . '/post/' . $message['icon'] . '.gif',
		'subject' => $message['subject'],
		'time' => timeformat($message['poster_time']),
		'timestamp' => forum_time(true, $message['poster_time']),
		'counter' => $counter,
		'modified' => array(
			'time' => timeformat($message['modified_time']),
			'timestamp' => forum_time(true, $message['modified_time']),
			'name' => $message['modified_name']
		),
		'body' => $message['body'],
		'new' => empty($message['is_read']),
		'approved' => $message['approved'],
		'first_new' => isset($context['start_from']) && $context['start_from'] == $counter,
		'can_approve' => !$message['approved'] && $context['can_approve'],
		'can_unapprove' => $message['approved'] && $context['can_approve'],
		'can_modify' => (!$context['is_locked'] || allowedTo('moderate_board')) && (allowedTo('modify_any') || (allowedTo('modify_replies') && $context['user']['started']) || (allowedTo('modify_own') && $message['id_member'] == $user_info['id'] && (empty($modSettings['edit_disable_time']) || !$message['approved'] || $message['poster_time'] + $modSettings['edit_disable_time'] * 60 > time()))),
		'can_remove' => allowedTo('delete_any') || (allowedTo('delete_replies') && $context['user']['started']) || (allowedTo('delete_own') && $message['id_member'] == $user_info['id'] && (empty($modSettings['edit_disable_time']) || $message['poster_time'] + $modSettings['edit_disable_time'] * 60 > time())),
		'can_see_ip' => allowedTo('moderate_forum') || ($message['id_member'] == $user_info['id'] && !empty($user_info['id'])),
		'thank_you_post' => array(
			'post' => !$context['thank_you_post'][$message['id_msg']]['user_postet'] && allowedTo('thank_you_post_post') && $user_info['id'] != $message['id_member'],
			'lock' => empty($context['is_thank_you_post_locked']) && (allowedTo('thank_you_post_lock_any') || (allowedTo('thank_you_post_lock_own') && $user_info['id'] == $message['id_member'])),
			'delete' => allowedTo('thank_you_post_delete_any') || (allowedTo('thank_you_post_delete_own') && $user_info['id'] == $message['id_member']),
			'counter' => !empty($message['thank_you_post_counter']) ? $message['thank_you_post_counter'] : '0',
			'locked' => !empty($message['thank_you_post']) && $message['thank_you_post'] > 1,
			'isThankYouPost' => !empty($message['thank_you_post']) && $message['thank_you_post'] >= 1,
			'href' => $scripturl . '?topic=' . $topic . '.msg' . $message['id_msg'] . '#msg' . $message['id_msg'],
		),
	);

	// Is this user the message author?
	$context['thank_you_post']['post']['is_message_author'] = $message['id_member'] == $user_info['id'];

	$context['page_title'] = $message['subject'];
}

function ThankYouPostLock()
{
	global $txt, $topic, $board, $user_info, $smcFunc;

	// Load some Languagefiles :)
	loadLanguage('Errors');

	// Okay Okay ;D Most importend!
	if (empty($_GET['msg']) || !is_numeric($_GET['msg']) || empty($topic))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// First look if the Thank You closed?
	ThankYouPostCheckClosed();

	// Load the Post data :)
	$post = $smcFunc['db_query']('', '
		SELECT id_msg, id_member, thank_you_post, thank_you_post_counter
		FROM {db_prefix}messages
		WHERE id_topic = {int:topic} AND id_msg = {int:id_msg}
		LIMIT 1',
		array(
			'topic' => $topic,
			'id_msg' => (int) $_GET['msg'],
		)
	);

	list($id_msg, $ID_MEMBER_POST, $status, $count) = $smcFunc['db_fetch_row']($post);
	$smcFunc['db_free_result']($post);

	if (empty($id_msg))
		$smcFunc['fatal_error']($txt['WMidTopicSet'], false);
	// Okay mal rechte prfen :)
	elseif (!allowedTo('thank_you_post_lock_any') && !(allowedTo('thank_you_post_lock_own') && $user_info['id'] == $ID_MEMBER_POST))
		$smcFunc['fatal_error']($txt['thxislockednor'], false);
	elseif (empty($status))
		$smcFunc['fatal_error']($txt['notathankyoupost'], false);

	// Hehe dann mal ndern :)
	$smcFunc['db_query']('', '
		UPDATE {db_prefix}messages
		SET thank_you_post = IF(thank_you_post = 1, 2, 1)
		WHERE id_msg = {int:id_msg}
		LIMIT 1',
		array(
			'id_msg' => (int) $id_msg,
		)
	);

	// Log the unlocking of all Thank You Post :D
	if (!empty($modSettings['modlog_enabled']) && !empty($modSettings['thankYouPostModerationLog']))
		logAction($status == 1 ? 'lock' : 'unlock',
			array(
				'message' => $id_msg,
				'topic' => $topic,
				'board' => $board,
				'member' => $ID_MEMBER_POST
			)
		);

	// Okay all done now Reddirect exit :)
	if (!isset($_GET['list']))
		$smcFunc['redirectexit']('topic='.$topic.'.msg'.$id_msg.'#msg'.$id_msg);
	else
		$smcFunc['redirectexit']('action=thankyoupostlist;topic='.$topic.'.0;msg='.$id_msg);
}

// This is  a small script to load colors for Thank You (a little bit faster... because sometime i need 100+ colors :x)
function thank_you_post_loadColors($users)
{
	global $color_profile, $modSettings, $smcFunc;

	// Redirect if Member Color Link is installed (Support more Options like ban and birthday color and als the other nice stuff)
	if (!empty($modSettings['MemberColorLinkInstalled']))
		return load_onlineColors($users, false);

	// Make something for sure :)
	if (!isset($color_profile))
		$color_profile = array();
	// Set a standard empty array for guest errors ;) (Deleted users, which are not resetet)
	if (!isset($color_profile[0]))
		$color_profile[0] = array('member_group_color' => '', 'post_group_color' => '');

	// Can't just look for no users :P.
	if (empty($users))
		return false;

	// Make sure it's an array.
	$users = !is_array($users) ? array($users) : array_unique($users);

	// Now i will use this as a chache, too
	$loaded_ids = array();
	$all_loaded_ids = array_keys($color_profile);
	// All the users that allready loaded
	$loaded_ids = array_intersect($all_loaded_ids, $users);
	// Now i need only the new users to load
	$users = array_diff($users, $all_loaded_ids);

	if (empty($users))
		return empty($loaded_ids) ? false : $loaded_ids;

	// Load the data.
	$request = $smcFunc['db_query']('', "
		SELECT
		mem.id_member AS id_member, mem.real_name AS real_name,
		mg.online_color AS member_group_color, IFNULL(mg.group_name, '') AS member_group,
		pg.online_color AS post_group_color, IFNULL(pg.group_name, '') AS post_group
		FROM {db_prefix}members AS mem
		LEFT JOIN {db_prefix}membergroups AS pg ON (pg.ID_GROUP = mem.ID_POST_GROUP)
		LEFT JOIN {db_prefix}membergroups AS mg ON (mg.ID_GROUP = mem.ID_GROUP)
		WHERE mem.id_member ".(count($users) == 1 ? " = '" . current($users) . "'" : " IN ('" . implode("', '", $users) . "')"));

	$loaded_ids = array();
	while ($row = $smcFunc['db_fetch_assoc']($request))
	{
		$loaded_ids[] = $row['id_member'];
		$color_profile[$row['id_member']] = $row;
	}
	$smcFunc['db_free_result']($request);

	return empty($loaded_ids) ? false : $loaded_ids;
}

function ThankYouPostCount($msg_ids = array(), $counter = '+')
{
	global $modSettings, $smcFunc;

	if (empty($msg_ids))
		return;

	if ($counter != '+' && $counter != '-' && $counter != 'reset' && !is_numeric($counter))
	{
		trigger_error("ThankYouPostCount(): Unkonwn 2. Paramter", E_USER_NOTICE);
		return;
	}

	$msg_ids = !is_array($msg_ids) ? array($msg_ids) : $msg_ids;

	if (count($msg_ids) == 1)
		$where = "WHERE id_msg = ".current($msg_ids);
	else
	{
		$msg_ids = array_unique($msg_ids);
		$where = "WHERE id_msg IN (".implode(', ', $msg_ids).")";
	}

	// Limit :)
	$limit = "
		LIMIT ".count($msg_ids);

	// Build the sets :)
	if ($counter == '+' || $counter == '-')
		$set = 'SET thank_you_post_counter = IF(thank_you_post_counter '.$counter.' 1 < 0, 0, thank_you_post_counter '.$counter.' 1)';
	elseif (is_numeric($counter))
	{
		$counter = (int) $counter;

		// Never go bellow 0 ;)
		if ($counter < 0)
			$counter = 0;

		$set = "SET thank_you_post_counter = $counter";
	}
	// Recalculate all Values :x, a lot of things to do <<
	else
	{
		// Theres a fast and long way :)
			$count = $smcFunc['db_query']('',"
				SELECT COUNT(*) as counter, id_msg
				FROM {db_prefix}thank_you_post
				$where
				GROUP BY id_msg");

		// The fast way :)
		if (count($msg_ids) == 1)
		{
			list($counter, $id_msg) = $smcFunc['db_fetch_row']($count);
			$smcFunc['db_free_result']($count);

			$counter = empty($counter) ? 0 : $counter;
			// Set the statment :)
			$set = "SET thank_you_post_counter = $counter";
		}
		// Long way...
		else
		{
			// Change all step by step :)
			while ($row = $smcFunc['db_fetch_assoc']($count))
				ThankYouPostCount($row['id_msg'], $row['counter']);

			$smcFunc['db_free_result']($count);
			// So after this i'm finished :)
			return;
		}
	}

	// Okay i will update it :) (But only if all is correct :X
	if (!empty($set) && !empty($where) && !empty($limit))
	{
		$smcFunc['db_query']('', "
			UPDATE {db_prefix}messages
			$set
			$where
			$limit");
	}
	else
		trigger_error("ThankYouPostCount(): Could not update counter", E_USER_NOTICE);

	return;
}

function ThankYouPostCheckClosed()
{
	global $topic, $txt, $smcFunc;

	// Missing language file?
	if (!isset($txt['NMidTopicSet']))

	if (empty($topic))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// Check if locked ;)
	$check = $smcFunc['db_query']('', '
		SELECT thank_you_post_locked
		FROM {db_prefix}topics
		WHERE id_topic = {int:topic}
		LIMIT 1',
		array(
			'topic' => $topic,
		)
	);

	$locked = $smcFunc['db_fetch_assoc']($check);
	$smcFunc['db_free_result']($check);

	if (empty($locked['thank_you_post_locked']) || $locked['thank_you_post_locked'] < 1)
		return true;
	else
		$smcFunc['fatal_error']($txt['thxislocked'], false);
}

function ThankYouPostCloseAll()
{
	global $txt, $topic, $board, $user_info, $smcFunc;

	// Load some Languagefiles :)
	loadLanguage('Errors');

	// Okay Okay ;D Most importend!
	if (empty($topic))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// Load the Topic Starter informations ;)
	$topicinfo = $smcFunc['db_query']('', '
		SELECT id_member_started
		FROM {db_prefix}topics
		WHERE id_topic = {int:topic}
		LIMIT 1',
		array(
			'topic' => $topic,
		)
	);

	list($id_member_started) = $smcFunc['db_fetch_row']($topicinfo);
	$smcFunc['db_free_result']($topicinfo);

	// Okay check the right
	if (!(allowedTo('thank_you_post_lock_all_own') && $user_info['id'] == $id_member_started) && !allowedTo('thank_you_post_lock_all_any'))
 		$smcFunc['fatal_error']($txt['thxislockednor'], false);

 	// Okay change it ;)
	$smcFunc['db_query']('', "
		UPDATE {db_prefix}topics
		SET thank_you_post_locked = IF(thank_you_post_locked = 0, 1, 0)
		WHERE id_topic = {int:topic}
		LIMIT 1",
		array(
			'topic' => $topic,
		)
	);

	// Moderation Log of the locking :D
	if (!empty($modSettings['modlog_enabled']) && !empty($modSettings['thankYouPostModerationLog']))
		logAction('lock', array('topic' => $topic, 'board' => $board));

	$smcFunc['redirectexit']('topic='.$topic);
}

function ThankYouPostRemoveTopics($topics = array())
{
	global $smcFunc;

	// Okay Let's do the work, no checks here because the user already allowed to remove topics,
	// so i will allow remove thank you from this topics :)!
	if (empty($topics))
		return;
	elseif (count($topics) == 1)
		$condition = 'id_topic = '.current($topics);
	else
		$condition = 'id_topic IN ('.implode(', ', $topics).')';

	// Okay now do the work, load all topic infomations and all the id_msg... and update all members... and so on...
	// now nothing can be stoped any more <<
	$posts = $smcFunc['db_query']('', "
		SELECT id_msg
		FROM {db_prefix}messages
		WHERE $condition
		AND thank_you_post != 0"
	);

	$msg_ids = array();

	while ($row = $smcFunc['db_fetch_assoc']($posts))
		$msg_ids[] = current($row);

	$smcFunc['db_free_result']($posts);

	// Nothing to do? Hope so... if not hope it take not to long :X Okay depent on the posts who made <<
	if (empty($msg_ids))
		return;
	else
		ThankYouPostDelete($msg_ids, true);

	return;
}

function ThankYouPostUnlockAllPosts()
{
	global $txt, $topic, $board, $smcFunc;

	loadLanguage('Errors');

	if (empty($topic))
		$smcFunc['fatal_error']($txt['NMidTopicSet'], false);

	// Allowed to do this?
	if (!allowedTo('thank_you_post_unlock_all'))
		$smcFunc['fatal_error']($txt['thank_you_post_unlock_all'], false);

	// Okay do it now ;)
	$smcFunc['db_query']('', '
		UPDATE {db_prefix}messages
		SET thank_you_post = IF(thank_you_post = 2, 1, thank_you_post)
		WHERE id_topic = {int:topic}',
		array(
			'topic' => $topic,
		)
	);

	// Log the unlocking of all Thank You Post :D
	if (!empty($modSettings['modlog_enabled']) && !empty($modSettings['thankYouPostModerationLog']))
		logAction('unlock', array('topic' => $topic, 'board' => $board));

	$smcFunc['redirectexit']('topic='.$topic);
}

// Handler for AJAX things ;).
function ThankYouPostAJAX()
{
	global $context, $txt, $user_info, $modSettings, $smcFunc, $topic, $scripturl;

	// Load some Languagefiles :)
	loadLanguage('Errors');
	ThankYouPostFunctionLoad(true);

	if (empty($modSettings['thankYouPostAJAX']))
		$smcFunc['fatal_error']($txt['thxajaxnotenabled']);

	if (empty($_REQUEST['msg']) || empty($topic) || !is_numeric($_REQUEST['msg']))
		$smcFunc['fatal_error']($txt['WMidTopicSet']);

	$sa_ajaxCheck = array(
		'thx',
		'list',
		'lock',
	);

	if (!isset($_REQUEST['sa']))
		$_REQUEST['sa'] = 'list';
	elseif (!in_array($_REQUEST['sa'], $sa_ajaxCheck))
		$smcFunc['fatal_error']($txt['thxajaxnotallowed']);

	if ($_REQUEST['sa'] == 'thx')
		ThankYou();
	elseif ($_REQUEST['sa'] == 'lock')
		ThankYouPostLock();

	if (!allowedTo('thank_you_post_show'))
		$smcFunc['fatal_error']($txt['thxajaxnotallowedtoview']);

	ThankYouPostList(array($_REQUEST['msg']), !isset($_REQUEST['complete']));

	if (empty($context['thank_you_post'][$_REQUEST['msg']]) && !empty($modSettings['thankYouPostPreview']))
		$smcFunc['fatal_error']($txt['notathankyoupost']);

	// Need some Datas for the Output :)
	$request = $smcFunc['db_query']('', "
		SELECT thank_you_post_counter, thank_you_post
		FROM {db_prefix}messages
		WHERE ID_MSG = $_REQUEST[msg]
		LIMIT 1");
	$message = $smcFunc['db_fetch_assoc']($request);
	$smcFunc['db_free_result']($request);

	$thank_you_post = array(
		'counter' => !empty($message['thank_you_post_counter']) ? $message['thank_you_post_counter'] : '0',
		'locked' => !empty($message['thank_you_post']) && $message['thank_you_post'] > 1,
		'href' => (isset($_REQUEST['complete']) ? $scripturl . '?topic=' . $topic . '.msg=' . $_REQUEST['msg'] . '#msg='.$_REQUEST['msg'] : $scripturl . '?action=thankyoupostlist;topic=' . $topic . '.0;msg=' . $_REQUEST['msg']),
	);

	// Mistake? Function not loaded oO.
	if (empty($context['call_thank_you_post_func']))
		loadThankYouTemplateFunctions();

	// Output a list ;D
	$context['call_thank_you_post_func']($thank_you_post, $_REQUEST['msg']);
	die();
}

// Output Thx Error for AJAX yeah *g*
function ThankYouPostAJAXError($error, $log = false)
{
	die('#ERROR#'.$error);
}

// End everything ;D and say null for nothing
function ThankYouPostAJAX_return($parm = null, $parm2 = null, $parm3 = null, $parm4 = null)
{
	return;
}

function ThankYouPostUpdateLastThankYou($values = array())
{
	global $smcFunc, $modSettings;
	// Renew it, example delete or anything like that :)
	if(empty($values))
	{
		// Load the latest item
		$request = $smcFunc['db_query']('', '
			SELECT id_msg, id_thx_post, thx_time
			FROM {db_prefix}thank_you_post
			ORDER BY id_thx_post DESC
			LIMIT 1', array()
		);
		$values = $smcFunc['db_fetch_assoc']($request);
		$smcFunc['db_free_result']($request);

		// Nothing insert ;)
		if (empty($values))
			$values = array(
				'id_thx_post' => 0,
				'id_msg' => 0,
				'thx_time' => 0,
			);

		// Reset? Nothing to do if allready set :D
		if ($values['id_thx_post'] == $modSettings['thank_you_post_last_id'])
			return true;
	}

	// Update :D
	updateSettings(
		array(
			'thank_you_post_last_id' => (int) $values['id_thx_post'],
			'thank_you_post_last_id_msg' => (int) $values['id_msg'],
			'thank_you_post_last_thx_time' => (int) $values['thx_time'],
		)
	);

	return true;
}

// Some Compatible Theme things... normal this part should be in the index.template.php ;)
// A Output for the Thank You list, it's used for the Single Preview and Display Template
// This is a backup function if the template_thank_you_post is missing! With this it work on near each theme!
function backup_template_thank_you_post($thankYouPost, $id_msg)
{
	global $txt, $context, $modSettings;

	if (!empty($context['thank_you_post'][$id_msg]))
	{
		if(empty($context['thank_you_post_template']['disable_start_text']))
			echo '
									<div class="smalltext" id="thank_you_start_text">', $context['thank_you_post_template']['start_text'] , '</div>';

		// Output the Thank You List...
		echo '
									<div class="smalltext" id="thank_you_list">';

		foreach ($context['thank_you_post'][$id_msg]['fulllist'] as $thx)
			echo $thx['link'] , (!empty($thx['deletelink']) ? $thx['deletelink'] : '').($thx['last'] ? '' : ', ');

		echo '
									</div>';
	}

	// Counter and Link to the direct or a link to the complete list :)
	if (empty($context['thank_you_post_template']['disable_counter_text']))
	{
		echo '
									<div class="smalltext" id="thank_you_list_link">';
		if (empty($context['thank_you_post_template']['disable_counter_link']))
			echo '
										<a href="', $thankYouPost['href'] ,'">';
		echo '
											', $txt['thank_you_link_beforecounter'], ' <strong>', $thankYouPost['counter'], '</strong> ', ($thankYouPost['counter'] == 1 ? $txt['thank_you_link_member'] : $txt['thank_you_link_members']).' '.($thankYouPost['counter'] == 1 ? $txt['thank_you_link_aftercounter'] : $txt['thank_you_link_aftercounters']);
		if (empty($context['thank_you_post_template']['disable_counter_link']))
			echo '
										</a>';
		echo '
									</div>';
	}

	// Show some information if the Thank-O-Matic Post is locked
	if ($thankYouPost['locked'])
		echo '
									<div class="smalltext" id="thank_you_lock_text">', $txt['thank_you_is_locked'], '</div>';
}

// Redirect some Function if ajax output is used :)
function ThankYouPostFunctionLoad($ajax = false)
{
	global $smcFunc;

	$smcFunc['redirectexit'] = 'redirectexit';
	$smcFunc['fatal_error'] = 'fatal_error';

	if ($ajax === true)
	{
		$smcFunc['redirectexit'] = 'ThankYouPostAJAX_return';
		$smcFunc['fatal_error'] = 'ThankYouPostAJAXError';
	}
}

// Initialize the functions :)
ThankYouPostFunctionLoad();
?>