<?php 

/*-----------------------------------------------*/
/* Automatic Video Thumbnail for Youtube & Vimeo */						
/*-----------------------------------------------*/

// This is for AJAX fetching of the auto thumbnail preview on the admin post add/edit screens
if(isset($_POST['wpzoom_autothumb']) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
  header('Content-type: text/plain');
  die(fetch_video_thumbnail_url(stripslashes($_POST['wpzoom_autothumb'])));
}
 

add_action('admin_head-post-new.php', 'wpz_newpost_head', 100);
add_action('admin_head-post.php', 'wpz_newpost_head', 100);
function wpz_newpost_head() {
  ?><style type="text/css">
    #wpzoom_autothumb_preview {
      display: none;
      margin: 0
    }

    #wpzoom_autothumb_preview img {
      display: block;
      margin-bottom: 5px
    }

    #wpzoom_autothumb_preview .howto {
      line-height: 1.4em
    }
  </style>
  <script type="text/javascript">
    jQuery(function($){
      $('<p id="wpzoom_autothumb_preview"><img src=""/><small class="howto"><?php _e('<strong>Automatic Thumbnail</strong><br/>This automatic thumbnail is used when you do not manually upload a Featured Image yourself.', 'wpzoom') ?></small></p>').insertAfter('#wpzoom_post_embed_code');

      $('#wpzoom_autothumb_preview img').load(function(){$('#wpzoom_autothumb_preview').animate({height: 'show', opacity: 'show'}, 500)});

      $('#wpzoom_post_embed_code').bind('input', function(){
        if('' != (val = $.trim($(this).val())))
          $.ajax({
            type: 'post',
            data: {wpzoom_autothumb:val},
            complete: function(xhr,status){
              if('' != (response = $.trim(xhr.responseText)))
                $('#wpzoom_autothumb_preview img').attr('src', '<?php bloginfo('stylesheet_directory') ?>/scripts/timthumb.php?src=' + encodeURIComponent(response) + '&w=255&zc=1');
              else
                $('#wpzoom_autothumb_preview').animate({height: 'hide', opacity: 'hide'}, 500, function(){$('#wpzoom_autothumb_preview img').removeAttr('src')});
            }
          });
        else
          $('#wpzoom_autothumb_preview').animate({height: 'hide', opacity: 'hide'}, 500, function(){$('#wpzoom_autothumb_preview img').removeAttr('src')});
      }).triggerHandler('input');
    });
  </script><?php
}


function fetch_video_thumbnail_url($input) {
  $input = htmlspecialchars_decode(trim((stripos($input, '<iframe') !== false || stripos($input, '<embed') !== false) && preg_match('#src="([^"]+)"#i', $input, $match) ? $match[1] : $input), ENT_QUOTES);
  $out = false;

  if(filter_var($input, FILTER_VALIDATE_URL, FILTER_FLAG_PATH_REQUIRED) !== false && false !== ($url_parts=parse_url($input)) && (stripos($url_parts['host'], 'youtube.com') !== false || stripos($url_parts['host'], 'youtu.be') !== false || stripos($url_parts['host'], 'vimeo.com') !== false)) {
    $url_query = array();if(isset($url_parts['query']))parse_str($url_parts['query'],$url_query);
    $id = isset($url_query['v']) ? $url_query['v'] : (isset($url_query['clip_id']) ? $url_query['clip_id'] : reset(explode('?', end(array_filter(explode('/', $input))))));

    if(stripos($url_parts['host'], 'youtube.com') !== false || stripos($url_parts['host'], 'youtu.be') !== false) {
      if(false !== ($contents = @file_get_contents("http://gdata.youtube.com/feeds/api/videos/$id?v=2&alt=jsonc"))) {
        $obj = json_decode($contents, true);
        $out = $obj['data']['thumbnail']['hqDefault'];
      }
    } elseif(stripos($url_parts['host'], 'vimeo.com') !== false) {
      if(false !== ($contents = @file_get_contents("http://vimeo.com/api/v2/video/$id.php"))) {
        $obj = unserialize($contents);
        $out = $obj[0]['thumbnail_large'];
      }
    }
  }

  return $out;
}

 
/*--------------------------------------------*/
/* Count post views						
/*--------------------------------------------*/

add_action( 'template_redirect', 'entry_views_load' );
add_action( 'wp_ajax_entry_views', 'entry_views_update_ajax' );
add_action( 'wp_ajax_nopriv_entry_views', 'entry_views_update_ajax' );

function entry_views_load() {
	global $wp_query, $entry_views;

 	if ( is_singular() ) {

 		$post = $wp_query->get_queried_object();
  			$entry_views->post_id = $post->ID;
  			wp_enqueue_script( 'jquery' );
  			add_action( 'wp_footer', 'entry_views_load_scripts' );
 	}
}

function entry_views_update( $post_id = '' ) {
	global $wp_query;

 	if ( !empty( $post_id ) ) {

 		$meta_key = apply_filters( 'entry_views_meta_key', 'Views' );
 		$old_views = get_post_meta( $post_id, $meta_key, true );
 		$new_views = absint( $old_views ) + 1;
 		update_post_meta( $post_id, $meta_key, $new_views, $old_views );
	}
}


function entry_views_get( $attr = '' ) {
	global $post;

 	$attr = shortcode_atts( array( 'before' => '', 'after' => '', 'post_id' => $post->ID ), $attr );
 	$meta_key = apply_filters( 'entry_views_meta_key', 'Views' );
 	$views = intval( get_post_meta( $attr['post_id'], $meta_key, true ) );
 	return $attr['before'] . number_format_i18n( $views ) . $attr['after'];
}

 
function entry_views_update_ajax() {

 	check_ajax_referer( 'entry_views_ajax' );

 	if ( isset( $_POST['post_id'] ) )
		$post_id = absint( $_POST['post_id'] );

 	if ( !empty( $post_id ) )
		entry_views_update( $post_id );
}


function entry_views_load_scripts() {
	global $entry_views;

 	$nonce = wp_create_nonce( 'entry_views_ajax' );

 	echo '<script type="text/javascript">/* <![CDATA[ */ jQuery(document).ready( function() { jQuery.post( "' . admin_url( 'admin-ajax.php' ) . '", { action : "entry_views", _ajax_nonce : "' . $nonce . '", post_id : ' . $entry_views->post_id . ' } ); } ); /* ]]> */</script>' . "\n";
}



/*--------------------------------------------*/
/* Show category ID						
/*--------------------------------------------*/

 // Prepend the new column to the columns array
function ssid_column($cols) {
	$cols['ssid'] = 'ID';
	return $cols;
}

// Echo the ID for the new column
function ssid_value($column_name, $id) {
	if ($column_name == 'ssid')
		echo $id;
}

function ssid_return_value($value, $column_name, $id) {
	if ($column_name == 'ssid')
		$value = $id;
	return $value;
}

// Output CSS for width of new column
function ssid_css() {
?>
<style type="text/css">
	#ssid { width: 50px; } /* Simply Show IDs */
</style>
<?php	
}

// Actions/Filters for various tables and the css output
function ssid_add() {
	add_action('admin_head', 'ssid_css');

 
	add_action('manage_edit-link-categories_columns', 'ssid_column');
	add_filter('manage_link_categories_custom_column', 'ssid_return_value', 10, 3);

	foreach ( get_taxonomies() as $taxonomy ) {
		add_action("manage_edit-${taxonomy}_columns", 'ssid_column');			
		add_filter("manage_${taxonomy}_custom_column", 'ssid_return_value', 10, 3);
	}

 
}

add_action('admin_init', 'ssid_add');



/*--------------------------------------------*/
/* "time ago" date format						
/*--------------------------------------------*/

function time_ago( $type = 'post' ) {
	$d = 'comment' == $type ? 'get_comment_time' : 'get_post_time';
	return human_time_diff($d('U'), current_time('timestamp')) . " " . __('ago', 'wpzoom');
}


 
/*--------------------------------------------*/
/* Comments Custom Template						
/*--------------------------------------------*/


function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	<div id="comment-<?php comment_ID(); ?>" class="commbody">
	<div class="commleft">
		  <div class="comment-author vcard">
			 <?php echo get_avatar($comment,$size='60' ); ?>

			 <?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
		  </div>
 
		  <div class="comment-meta commentmetadata">
			<?php _e('on', 'wpzoom'); ?> <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s <br/> '), get_comment_date('M d, Y'),  get_comment_time()) ?></a>
			<?php _e('at', 'wpzoom'); ?> <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%2$s'), get_comment_date(),  get_comment_time()) ?></a>
			
			
			<?php edit_comment_link(__('{Edit}'),'  ','') ?></div>
      </div>

      <?php comment_text() ?>
		 <?php if ($comment->comment_approved == '0') : ?>
			 <em><?php _e('Your comment is awaiting moderation.', 'wpzoom') ?></em>
			 <br />
		  <?php endif; ?>
      <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
      </div>
      <div class="clear"></div>
     </div>
<?php }




/*-----------------------------------------------------------------------------------*/
/* WPZOOM Custom Functions															 */
/*-----------------------------------------------------------------------------------*/

add_action('admin_head', 'myposttype_admin_css');

	function myposttype_admin_css() {

 		echo '<link type="text/css" rel="stylesheet" href="'.get_bloginfo( 'template_directory').'/functions/admin-style.css" media="screen" />';
 
}


function _remove_script_version( $src ){
	$parts = explode( '?', $src );
	return $parts[0];
}
add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );


/*--------------------------------------------*/
/* Reset [gallery] shortcode aditional styles						
/*--------------------------------------------*/

add_filter('gallery_style', create_function('$a', 'return "<div class=\'gallery\'>";'));



/*--------------------------------------------*/
/* Show thumbnails on attachement template						
/*--------------------------------------------*/

function show_all_thumbs() {

	global $post;
	
	$post = get_post($post);
	$images = &get_children( 'post_type=attachment&post_mime_type=image&output=ARRAY_N&orderby=menu_order&order=ASC&post_parent='.$post->post_parent);
	if($images) {
	foreach( $images as $imageID => $imagePost ){
	if($imageID==$post->ID){
	} else {
	unset($the_b_img);
	$the_b_img = wp_get_attachment_image($imageID, 'thumbnail', false);
	$thumblist .= '<a href="'.get_attachment_link($imageID).'">'.$the_b_img.'</a>';
	}
	}
	}
	return $thumblist;
}
/*--------------------------------------------*/
/* Add Support for Shortcodes in Excerpt						
/*--------------------------------------------*/

add_filter( 'the_excerpt', 'shortcode_unautop');
add_filter( 'the_excerpt', 'do_shortcode');

add_filter( 'widget_text', 'shortcode_unautop');
add_filter( 'widget_text', 'do_shortcode');

/*----------------------------------*/
/* Default Excerpt Lenght 			*/
/*----------------------------------*/

function new_excerpt_length($length) {
	return (int) get_option("wpzoom_excerpt") ? (int) get_option("wpzoom_excerpt") : 50;
}
add_filter('excerpt_length', 'new_excerpt_length');

 
/*----------------------------------*/
/* Custom Posts Options				*/
/*----------------------------------*/
add_action('admin_menu', 'wpzoom_options_box');

function wpzoom_options_box() {
  add_meta_box('wpzoom_post_embed', 'Post Options', 'wpzoom_post_embed_info', 'post', 'side', 'high');
}

function wpzoom_post_embed_info() {
	global $post;

	?>
	<fieldset>
		<div>
		
			<p class="wpz_border">
				<label for="wpzoom_post_template" ><strong>Choose the layout for this post:</strong></label><br />
				<select name="wpzoom_post_template" id="wpzoom_post_template">
					<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_template', true), 'Default' ); ?>>Default</option>
					<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_template', true), 'Sidebar on the left' ); ?>>Sidebar on the left</option>
					<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_template', true), 'Full Width (no sidebar)' ); ?>>Full Width (no sidebar)</option>
				</select>
			</p>
			
			
			<p class="wpz_border">
				<label for="wpzoom_post_embed_location" ><strong>Display video at the top?</strong></label><br />
				<select name="wpzoom_post_embed_location" id="wpzoom_post_embed_location">
					<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_location', true), 'No' ); ?>>No</option>
   					<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_location', true), 'Yes' ); ?>>Yes</option>
 				</select>
				<br />
			</p>

			<p class="wpz_border">
				<label for="wpzoom_post_embed_code" ><strong>Embed Code</strong> (video from a website):</label><br />
				<textarea style="height: 110px; width: 255px;" name="wpzoom_post_embed_code" id="wpzoom_post_embed_code"><?php echo get_post_meta($post->ID, 'wpzoom_post_embed_code', true); ?></textarea>
			</p>
			
			<div class="wpz_border">
				<p>
				<strong>Self-hosted video</strong><br/> 
				<ol class="wpz_list ">
					<li><a class="thickbox wpz_video" href="media-upload.php?post_id=9&type=video&TB_iframe=1">Upload video</a> to your website</li>
 					<li>Insert video URL here:<br/>
					
						<input class="form-input-tip wpz_self_input" name="wpzoom_post_embed_self" id="wpzoom_post_embed_self" value="<?php echo get_post_meta($post->ID, 'wpzoom_post_embed_self', true); ?>" />
					</li>
					<li>Optional <strong>HD</strong> video source:<br/>
					
						<input class="form-input-tip wpz_self_input" name="wpzoom_post_embed_hd" id="wpzoom_post_embed_hd" value="<?php echo get_post_meta($post->ID, 'wpzoom_post_embed_hd', true); ?>" />
					</li>
					<li>Select a skin for player:
						<select name="wpzoom_post_embed_skin" id="wpzoom_post_embed_skin">
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Five' ); ?>>Five</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Beelden' ); ?>>Beelden</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Bekle' ); ?>>Bekle</option>
 							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Glow' ); ?>>Glow</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Modieus' ); ?>>Modieus</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Nacht' ); ?>>Nacht</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Simple' ); ?>>Simple</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Stijl' ); ?>>Stijl</option>
							<option<?php selected( get_post_meta($post->ID, 'wpzoom_post_embed_skin', true), 'Stormtrooper' ); ?>>Stormtrooper</option>
 						</select>
					</li>
				</ol>
				</p>
 			</div>
 			
			<p>
				<em><strong>Tips:</strong></em><br/>
				<ol class="wpz_list">
					<li>Leave "Embed Code" field empty, if you want to embed a self-hosted video.</li>
					<li>Recommended video formats: <em>.flv, .mp4</em>. Read more about <a href="http://www.longtailvideo.com/support/jw-player/jw-player-for-flash-v5/12539/supported-video-and-audio-formats" target="_blank">supported formats</a>.
					
				</ol>
			</p>
 
		</div>
	</fieldset>
	<?php
}

add_action('save_post', 'custom_add_save');

function custom_add_save($postID){
// called after a post or page is saved
if($parent_id = wp_is_post_revision($postID))
{
  $postID = $parent_id;
}

if ($_POST['wpzoom_post_template']) {
  update_custom_meta($postID, $_POST['wpzoom_post_template'], 'wpzoom_post_template');
  update_custom_meta($postID, $_POST['wpzoom_post_embed_location'], 'wpzoom_post_embed_location');
  update_custom_meta($postID, $_POST['wpzoom_post_embed_code'], 'wpzoom_post_embed_code');
  update_custom_meta($postID, $_POST['wpzoom_post_embed_self'], 'wpzoom_post_embed_self');
  update_custom_meta($postID, $_POST['wpzoom_post_embed_hd'], 'wpzoom_post_embed_hd');
  update_custom_meta($postID, $_POST['wpzoom_post_embed_skin'], 'wpzoom_post_embed_skin');
}
}

function update_custom_meta($postID, $newvalue, $field_name) {
// To create new meta
if(!get_post_meta($postID, $field_name)){
add_post_meta($postID, $field_name, $newvalue);
}else{
// or to update existing meta
update_post_meta($postID, $field_name, $newvalue);
}
}


/*----------------------------------------------------------------------------------*/
/* Function that allows to display only exact count of comments, without trackbacks
/*----------------------------------------------------------------------------------*/
 function comment_count( $count ) {
	if ( ! is_admin() ) {
		global $id;
		$get_comments = get_comments('post_id=' . $id);
		$comments_by_type = &separate_comments($get_comments);
 		return count($comments_by_type['comment']);
	} else {
		return $count;
	}
}
add_filter('get_comments_number', 'comment_count', 0);


 
/*------------------------------------------------*/
/* Fix for timthumb thumbnails in WP Multisite
/*------------------------------------------------*/

function wpzoom_wpmu ($img) {
	global $blog_id;
  $imageParts = explode('/files/', $img);
	if (isset($imageParts[1])) {
		$img = '/blogs.dir/' . $blog_id . '/files/' . $imageParts[1];
	}
	return($img);
}


/*----------------------------------------------------*/
/* Custom function for displaying first image from 
/* post as thumbnail, if Featured Image is missing
/*----------------------------------------------------*/

function catch_that_image ($post_id=0, $width=60, $height=60, $img_script='') {
  global $wpdb;
	if($post_id > 0) {
    // check for an embed code to see if we can fetch an auto thumbnail
    $videocode = get_post_meta($post_id, 'wpzoom_post_embed_code', true);
    if(strlen($videocode) > 1 && false !== ($url = fetch_video_thumbnail_url($videocode))) {
      return $url;
    }
		 // select the post content from the db

		 $sql = 'SELECT post_content FROM ' . $wpdb->posts . ' WHERE id = ' . $wpdb->escape($post_id);
		 $row = $wpdb->get_row($sql);
		 $the_content = $row->post_content;
		 if(strlen($the_content)) {

			  // use regex to find the src of the image

			preg_match("/<img src\=('|\")(.*)('|\") .*( |)\/>/", $the_content, $matches);
			if(!$matches) {
				preg_match("/<img class\=\".*\" src\=('|\")(.*)('|\") .*( |)\/>/U", $the_content, $matches);
			}
      if(!$matches) {
				preg_match("/<img class\=\".*\" title\=\".*\" src\=('|\")(.*)('|\") .*( |)\/>/U", $the_content, $matches);
			}

			$the_image = '';
			$the_image_src = $matches[2];
			$frags = preg_split("/(\"|')/", $the_image_src);
			if(count($frags)) {
				$the_image_src = $frags[0];
			}

      // if an image isn't found yet
      if(!strlen($the_image_src))
      {
          $attachments = get_children( array( 'post_parent' => $post_id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID' ) );

          if (count($attachments) > 0)
          {
            $q = 0;
          	foreach ( $attachments as $id => $attachment ) {
          	$q++;
          		if ($q == 1) {
          			$thumbURL = wp_get_attachment_image_src( $id, $args['size'] );
          			$the_image_src = $thumbURL[0];
          			break;
          		} // if first image
          	} // foreach
          } // if there are attachments
      } // if no image found yet

		  // if src found, then create a new img tag

			  if(strlen($the_image_src)) {
				   if(strlen($img_script)) {

					    // if the src starts with http/https, then strip out server name

					    if(preg_match("/^(http(|s):\/\/)/", $the_image_src)) {
						     $the_image_src = preg_replace("/^(http(|s):\/\/)/", '', $the_image_src);
						     $frags = split("\/", $the_image_src);
						     array_shift($frags);
						     $the_image_src = '/' . join("/", $frags);
					    }
					    $the_image = '<img alt="" src="' . $img_script . $the_image_src . '" />';
				   }
				   else {
					    $the_image = '<img alt="" src="' . $the_image_src . '" width="' . $width . '" height="' . $height . '" />';
				   }
			  }
			  return $the_image_src;
		 }
	}
}


 
/*----------------------------------*/
/* Get Categories					*/
/*----------------------------------*/

function getCategories($parent) {

	global $wpdb, $table_prefix;

	$tb1 = "$table_prefix"."terms";
	$tb2 = "$table_prefix"."term_taxonomy";

	if ($parent == '1')
	{
	 $qqq = "AND $tb2".".parent = 0";
  }
  else
  {
    $qqq = "";
  }

	$q = "SELECT $tb1.term_id,$tb1.name,$tb1.slug FROM $tb1,$tb2 WHERE $tb1.term_id = $tb2.term_id AND $tb2.taxonomy = 'category' $qqq ORDER BY $tb1.name ASC";
	$q = $wpdb->get_results($q);

  foreach ($q as $cat) {
    	$categories[$cat->term_id] = $cat->name;
    } // foreach
  return($categories);
} // end func




/*----------------------------------*/
/* Get Pages						*/
/*----------------------------------*/

function getPages() {

	global $wpdb, $table_prefix;

	$tb1 = "$table_prefix"."posts";

	$q = "SELECT $tb1.ID,$tb1.post_title FROM $tb1 WHERE $tb1.post_type = 'page' AND $tb1.post_status = 'publish' ORDER BY $tb1.post_title ASC";
	$q = $wpdb->get_results($q);

  foreach ($q as $pag) {
    	$pages[$pag->ID] = $pag->post_title;
    } // foreach
  return($pages);
} // end func




/*---------------------------------------------------------------*/
/*  Limit Posts						
/*									
/*  Plugin URI: http://labitacora.net/comunBlog/limit-post.phps
/*	Usage: the_content_limit($max_charaters, $more_link)
/*
/*---------------------------------------------------------------*/
 
function the_content_limit($max_char, $more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
    $content = get_the_content($more_link_text, $stripteaser, $more_file);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    $content = strip_tags($content);

   if (strlen($_GET['p']) > 0 && $thisshouldnotapply) {
      echo $content;
   }
   else if ((strlen($content)>$max_char) && ($espacio = strpos($content, " ", $max_char ))) {
        $content = substr($content, 0, $espacio);
        $content = $content;
        echo $content;
        echo "";
   }
   else {
      echo $content;
   }
}



/*----------------------------------*/
/* Breadcrumbs						*/
/*----------------------------------*/

function wpzoom_breadcrumbs() {
 
  $delimiter = '&raquo;';
  $name = 'Home'; //text for the 'Home' link
  $currentBefore = '<span class="current">';
  $currentAfter = '</span>';
 
  if ( !is_home() && !is_front_page() || is_paged() ) {
 
     global $post;
    $home = get_bloginfo('url');
    echo '<a href="' . $home . '">' . $name . '</a> ' . $delimiter . ' ';
 
    if ( is_category() ) {
      global $wp_query;
      $cat_obj = $wp_query->get_queried_object();
      $thisCat = $cat_obj->term_id;
      $thisCat = get_category($thisCat);
      $parentCat = get_category($thisCat->parent);
      if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
      echo $currentBefore . '';
      single_cat_title();
      echo '' . $currentAfter;
 
    } elseif ( is_day() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('d') . $currentAfter;
 
    } elseif ( is_month() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('F') . $currentAfter;
 
    } elseif ( is_year() ) {
      echo $currentBefore . get_the_time('Y') . $currentAfter;
 
    } elseif ( is_single() ) {
      $cat = get_the_category(); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && !$post->post_parent ) {
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_search() ) {
      echo $currentBefore . 'Search results for &#39;' . get_search_query() . '&#39;' . $currentAfter;
 
    } elseif ( is_tag() ) {
      echo $currentBefore . 'Posts tagged &#39;';
      single_tag_title();
      echo '&#39;' . $currentAfter;
 
    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $currentBefore . 'Articles posted by ' . $userdata->display_name . $currentAfter;
 
    } elseif ( is_404() ) {
      echo $currentBefore . 'Error 404' . $currentAfter;
    }
 
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
  
  }
}

 
?>