<?php
/*
=======================================================================================
---  DLE ShortBar
---  V.1
---  http://e-div.com/blog/dle-shortbar.html
---------------------------------------------------------------------------------------
---  By Elegant Division
---  http://e-div.com
---  info@e-div.com
---------------------------------------------------------------------------------------
---  05.2013
=======================================================================================
*/

if( ! defined( 'DATALIFEENGINE' ) ) die( "Hacking attempt!" );

/* Get values from template */
			// value, type, default value
$menuid		= detectVal($menuid,	"int", 0);
$userid		= detectVal($userid,	"int", 0);
$group		= detectVal($group,		"int", 1);
$dleinfo	= detectVal($dleinfo,	"bol", true);
$search		= detectVal($search,	"bol", true);
$userinfo	= detectVal($userinfo,	"bol", true);
$edit		= detectVal($edit,		"bol", true);
$autohide	= detectVal($autohide,	"bol", true);
$minimize	= detectVal($minimize,	"bol", false);
$cache		= detectVal($cache,		"bol", true);
$lng 		= strtolower($lng);

$posibleLang = array("ru","en");
if( ! in_array($lng, $posibleLang)) $lng = "ru";

/* Start */
if( ! $smartphone_detected && $menuid > 0 && ( $userid > 0 && $userid == $member_id['user_id'] || $userid <= 0 ) && ( $group > 0 && $group == $member_id['user_group'] || $group == 0 )) {

	// language
	include_once ENGINE_DIR . "/modules/ed-shortbar/language/website_{$lng}.lng";

	// module folder
	$mod_dir = $config['http_home_url'] . "engine/modules/ed-shortbar/";

	// cache
	// ================================================================================================================
	$is_change = $linksEcho = false;
	if( $cache ) {
		if( $config['allow_cache'] != "yes") {
			$config['allow_cache'] = "yes";
			$is_change = true;
		}
		$linksEcho = dle_cache( "short_bar" );
	}

	// custom links (from BD)
	// ================================================================================================================
	if( ! $linksEcho ) {

		$linksParent = $linksChild = array();
		$menuFound = false;

		$db->query( "SELECT * FROM " . PREFIX . "_shortbar_links WHERE menu_id='{$menuid}' AND visible='1' ORDER BY position DESC");

		while ( $links = $db->get_row() ) {

			$menuFound = true;

			if($links['parent'] == 0) {

				$linksParent[$links['id']] = array(
					"id"		=> intval( $links['id'] ),
					"title" 	=> strip_tags( stripslashes( $links['title'] )),
					"link" 		=> strip_tags( stripslashes( $links['link'] )),
					"icon"		=> intval( $links['icon'] ),
					"parent"	=> intval( $links['parent'] ),
					"position"	=> intval( $links['position'] ),
					"target"	=> intval( $links['target'] )
				);

			} else {

				$linksChild[$links['id']] = array(
					"id"		=> intval( $links['id'] ),
					"title" 	=> strip_tags( stripslashes( $links['title'] )),
					"link" 		=> strip_tags( stripslashes( $links['link'] )),
					"icon"		=> intval( $links['icon'] ),
					"parent"	=> intval( $links['parent'] ),
					"position"	=> intval( $links['position'] ),
					"target"	=> intval( $links['target'] )
				);

			}
		}
		$db->free();

		if($menuFound === true) {

			$icon = $childLinks = "";

			usort($linksParent, build_sorter('position'));

			foreach ($linksParent as $pid => $pLink) {

				// child links
				$childLinks = "";
				if(count($linksChild)){

					usort($linksChild, build_sorter('position'));

					foreach ($linksChild as $cid => $cLink) {
						if($cLink["parent"] == $pLink["id"] && $cLink["link"] !== "") {
							$childLinks .= "\n\t\t<li><a href=\"{$cLink[link]}\"" . ($cLink["target"] == 1 ? " target=\"_blank\"" : "") . ($cLink["icon"] > 1 ? " class=\"ed-icon\" style=\"background-image: url({$mod_dir}media/icons/{$cLink[icon]}.png);\"" : "") . ">{$cLink[title]}</a></li>";
						}
					}
				}
				if($childLinks !== "") $childLinks = "<ul>" . $childLinks . "</ul>";

				// parent links
				$icon = ($pLink["icon"] > 1 ? " class=\"ed-icon\" style=\"background-image: url({$mod_dir}media/icons/{$pLink[icon]}.png);\"" : "");
				$linksEcho .= "\n\t\t<li" . ( $childLinks !== "" ? " class=\"ed-have-child-menu\"" : "") . ">" . ($pLink["link"] !== "" ? "<a href=\"{$pLink[link]}\"" . ($pLink["target"] == 1 ? " target=\"_blank\"" : "") . $icon . ">{$pLink[title]}</a>" : "<span{$icon}>{$pLink[title]}</span>") . $childLinks . "</li>";
			}

			$linksEcho = "\t<ul class=\"ed-links\">{$linksEcho}\n\t</ul>\n";

			// create cache
			if( $cache ) create_cache( "short_bar", $linksEcho );

		}
	}

	// autohide shortBar
	// ================================================================================================================
	$echo = "<div id=\"ed-shortbar\"" . ( $autohide ? " class=\"autohide\"" : "") . ">\n";

	// dle info
	// ================================================================================================================
	if( $dleinfo ) {
		$echo .= <<<HTML
	<ul class="ed-dle-info">
		<li class="ed-have-child-menu">
			<span>{$elang['dle_name']}</span>
			<ul>
				<li><a href="http://dle-news.ru/" rel="nofollow">{$elang['dle_site_name']}</a></li>
				<li><a href="http://dle-news.ru/release/" rel="nofollow" title="{$elang['dle_release_title']}">{$elang['dle_release']}</a></li>
				<li><a href="http://dle-news.ru/bags/" rel="nofollow" title="{$elang['dle_bugs_title']}">{$elang['dle_bugs']}</a></li>
				<li><a href="http://dle-news.ru/extras/online/index.html" rel="nofollow">{$elang['dle_docs']}</a></li>
				<li><a href="http://forum.dle-news.ru/" rel="nofollow">{$elang['dle_forum']}</a></li>
				<li><a href="http://dle-news.ru/index.php?do=feedback" rel="nofollow" title="{$elang['dle_feedback_title']}">{$elang['dle_feedback']}</a></li>
			</ul>
		</li>
	</ul>

HTML;
	}

	// custom links (from BD)
	// ================================================================================================================
	if( $linksEcho ) {
		$echo .= $linksEcho;
	}

	// user info
	// ================================================================================================================
	if( $userinfo && $is_logged ) {

		$avatar = ( $member_id['foto'] ? $config['http_home_url'] . "uploads/fotos/" . $member_id['foto'] : "{THEME}/dleimages/noavatar.png" );
		$countPM = ( $member_id['pm_unread'] > 0 ? " (" . intval($member_id['pm_unread']) . ")" : "" );
		$countFavs = ( $member_id['favorites'] ? count(explode(",", $member_id['favorites'])) : 0 );

		if ($config['allow_alt_url'] == "yes") {
			$profLink = $config['http_home_url'] . "user/" . urlencode($member_id['name']) . "/";
			$addNewsLink = $config['http_home_url'] . "addnews.html";
			$favLink = $config['http_home_url'] . "favorites/";
			$newPostsLink = $config['http_home_url'] . "newposts/";
		} else {
			$profLink = $config['http_home_url'] . "index.php?subaction=userinfo&amp;user=" . urlencode($member_id['name']);
			$addNewsLink = $config['http_home_url'] . "index.php?do=addnews";
			$favLink = $config['http_home_url'] . "index.php?do=favorites";
			$newPostsLink = $config['http_home_url'] . "index.php?subaction=newposts";
		}
		$pmLink = $config['http_home_url'] . "index.php?do=pm";

		
		$appendLinks = array();

		// admin CP
		if ( $user_group[$member_id['user_group']]['allow_admin'] )
			$appendLinks[] = "\n\t\t\t\t<li><a href=\"" . $config['http_home_url'] . $config['admin_path'] . "\">{$elang['ul_admincp']}</a></li>";

		// add news
		if ( $user_group[$member_id['user_group']]['allow_adds'] )
			$appendLinks[] = "\n\t\t\t\t<li><a href=\"" . $addNewsLink . "\">{$elang['ul_add_news']}</a></li>";

		// PM
		if ( $user_group[$member_id['user_group']]['allow_pm'] )
			$appendLinks[] = "\n\t\t\t\t<li><a href=\"" . $pmLink . "\" title=\"" . intval($member_id['pm_all']) . " {$elang['ul_count']}\">{$elang['ul_pm']}" . $countPM . "</a></li>";

		// bookmarks
		if ( $countFavs > 0 )
			$appendLinks[] = "\n\t\t\t\t<li><a href=\"" . $favLink . "\">{$elang['ul_favs']} (" . $countFavs . ")</a></li>";

		$appendLinks = implode("", $appendLinks);

		$echo .= <<<HTML
	<ul class="ed-user-info">
		<li class="ed-have-child-menu">
			<a href="{$profLink}"><img src="{$avatar}" alt="{$elang['ul_ava']}"/>{$member_id[name]}</a>
			<ul>{$appendLinks}
				<li><a href="{$newPostsLink}">{$elang['ul_unread']}</a></li>
				<li><a href="{$config['http_home_url']}?do=lastcomments">{$elang['ul_last_comments']}</a></li>
				<li><a href="{$config['http_home_url']}index.php?action=logout">{$elang['ul_exit']}</a></li>
			</ul>
		</li>
	</ul>

HTML;
	}

	// search
	// ================================================================================================================
	if( $search && $user_group[$member_id['user_group']]['allow_search'] ) {
		$echo .= <<<HTML
	<ul class="ed-search">
		<li>
			<form method="post" name="searchform" action="">
				<input type="hidden" value="search" name="do" />
				<input type="hidden" value="search" name="subaction" />
				<div class="ed-input">
					<input type="text" placeholder="{$elang['s_placeholder']}" name="story" />
				</div>
			</form>
		</li>
		<li><span id="ed-do-search" class="ed-icon" style="background-image: url({$mod_dir}media/icons/7.png);">&nbsp;</span></li>
	</ul>

HTML;
	}

	// edit
	// ================================================================================================================
	if( $edit && $is_logged && isset($dle_module) && $user_group[$member_id['user_group']]['allow_all_edit'] ) {

		$editLink = "";
		$iconStatic = " class=\"ed-icon\" style=\"background-image: url({$mod_dir}media/icons/59.png);\"";
		switch ($dle_module) {
			// edit userinfo
			case "userinfo":
				if( isset($_GET['user']) ){
					$user = @strip_tags(str_replace('/', '', urldecode($_GET['user'])));

					if ($config['charset'] == "windows-1251" AND $config['charset'] != detect_encoding($user)) {
						$user = iconv("UTF-8", "windows-1251//IGNORE", $user);
					}

					$user = $db->safesql($user);

					if ( !preg_match("/[\||\'|\<|\>|\"|\!|\?|\$|\@|\/|\\\|\&\~\*\+]/", $user)){
						$editLink = "<a href=\"#\" id=\"ed-edituserinfo\" data-user=\"{$user}\"{$iconStatic} title=\"{$elang['ed_user']}\">&nbsp;</a>";
					}
				}
			break;
			// edit news
			case "showfull":
				if( isset($_GET['newsid']) ) {
					$newsid = intval($_GET['newsid']);
					if($newsid > 0) $editLink = "<a href=\"" . $config['http_home_url'] . $config['admin_path'] . "?mod=editnews&amp;action=editnews&id={$newsid}\"{$iconStatic} title=\"{$elang['ed_news']}\">&nbsp;</a>";
				}
			break;
			// edit cats
			case "cat":
				if( isset($category_id) && $category_id > 0 ){
					$editLink = "<a href=\"" . $config['http_home_url'] . $config['admin_path'] . "?mod=categories&amp;action=edit&amp;catid={$category_id}\"{$iconStatic} title=\"{$elang['ed_cat']}\">&nbsp;</a>";
				}
			break;
			// static page
			case "static":
				if( isset($_GET['page']) ) {
					$pageName = @$db->safesql( trim( totranslit( $_GET['page'], true, false )));
					$static = $db->super_query("SELECT id FROM " . PREFIX . "_static WHERE name='$pageName'");
					if($static['id'] > 0) $editLink = "<a href=\"" . $config['http_home_url'] . $config['admin_path'] . "?mod=static&amp;action=doedit&amp;id={$static[id]}\"{$iconStatic} title=\"{$elang['ed_static']}\">&nbsp;</a>";
				}
			break;
		}

		if($editLink !== ""){
			$echo .= <<<HTML
	<ul class="ed-edit">
		<li>{$editLink}</li>
	</ul>

HTML;

		}
	}

	$echo .= "</div>\n";

	// minimize code
	// ================================================================================================================
	if( $minimize ) $echo = preg_replace("/^\s+|\n|\t|\r|\s+$/m", "", $echo);


	//final ^_^*
	// ================================================================================================================
	echo <<<HTML
<!-- DLE ShortBar by Elegant Division -->
{$echo}
<link type="text/css" rel="stylesheet" href="{$mod_dir}media/css/styles.css?v1" />
<script type="text/javascript" src="{$mod_dir}media/js/lab.js?v1"></script>
<!-- // DLE ShortBar by Elegant Division -->
HTML;

}

if( $is_change ) $config['allow_cache'] = false;

#######################################################################################
# Functions %)
#######################################################################################

// clean values
function detectVal($val, $type, $def) {
	global $db;
	if(isset($val)) {
		if($type == "int") {
			return (isset($val) && $val > 0 ? $db->safesql(intval($val)) : 0);
		} elseif($type == "bol") {
			return (isset($val) && $val === "true" ? true : false);
		}
	} else {
		return $def;
	}
}

// for correct sort
function build_sorter($key) {
	return function ($a, $b) use ($key) {
		return strnatcmp($a[$key], $b[$key]);
	};
}

?>