<?php

class ipb_member {
	public $member = array( );
	private $connect_method = "connect";
	private $config = array( );
	private $lang = array( );
	private $ipb_config = array( );
	private $db = NULL;
	private $connected = FALSE;
	private $useIpbDb = FALSE;

	public function __construct( $db )
	{
		if ( file_exists( ENGINE_DIR."/data/dle_ipb.php" ) ) {
			include( ENGINE_DIR."/data/dle_ipb.php" );
			$this->config = $dleIpb;
		} else {
			exit( "   !" );
		}
		
		if ( file_exists( dirname(__FILE__)."/data/conf_global.php" ) ) {
			include( dirname(__FILE__)."/data/conf_global.php" );
			$this->ipb_config = $INFO;
		} else {
			exit( "    conf_global.php" );
		}
		
		if ( !defined( "DLE_CHARSET" ) ) {
			define( "DLE_CHARSET", "UTF-8" );
		}
		
		if ( !defined( "COLLATE" ) ) {
			define( "COLLATE", "utf8" );
		}
		
		$this->db = $db;
		
		define("IPB_PREFIX", $this->IPBConfig("sql_tbl_prefix"));
		
		if ( $this->ipb_config['sql_host'] === DBHOST && $this->ipb_config['sql_user'] === DBUSER && $this->ipb_config['sql_pass'] === DBPASS )
		{
			if ( $this->ipb_config['sql_database'] === DBNAME ) {
				$this->connect_method = "none";
			} else {
				$this->connect_method = "use";
			}
		}
	}

	private function _db_connect( )
	{
		if ( $this->connected ) {
			return $this->db;
		}
		
		switch ( $this->connect_method ) {
			case "none":
			case "use":
				$this->db->query( "USE `".$this->ipb_config['sql_database']."`" );
			break;
			
			default:
				$this->db->connect( $this->ipb_config['sql_user'], $this->ipb_config['sql_pass'], $this->ipb_config['sql_database'], $this->ipb_config['sql_host'] );
			break;
		}
		
		if ( $this->ipb_config['sql_charset'] && $this->ipb_config['sql_charset'] != COLLATE ) {
			$this->db->query( "SET NAMES '".$this->ipb_config['sql_charset']."'" );
			$this->db->query( "SET CHARACTER SET '".$this->ipb_config['sql_charset']."'" );
		}
		
		$this->connected = TRUE;
		return $this->db;
	}

	private function _db_disconnect() {
		if ( $this->connected ) {
			switch ( $this->connect_method ) {
				case "none" :
				case "use" :
					$this->db->query( "USE `".DBNAME."`" );
				break;
				default :
					$this->db->connect( DBUSER, DBPASS, DBNAME, DBHOST );
				break;
			}
			if ( $this->ipb_config['sql_charset'] && $this->ipb_config['sql_charset'] != COLLATE ) {
				$this->db->query( "SET NAMES '".COLLATE."'" );
			}
			$this->connected = FALSE;
		}
	}

	public function IPBConfig( $tn )
	{
		if ( isset( $this->ipb_config[$tn] ) )
		{
			return $this->ipb_config[$tn];
		}
		
		if( function_exists('dle_cache') ){
			if ( !( $cache = dle_cache( "config_ipb" ) ) ) {
				$this->db->query("SELECT * FROM " . IPB_PREFIX . "core_sys_conf_settings");
				while ( $row = $this->db->get_row() ){
					$this->ipb_config[$row['conf_key']] = $row['conf_value'] != "" ? $row['conf_value'] : $row['conf_default'];
				}
				if ( function_exists( "create_cache" ) ) {
					create_cache( "config_ipb", serialize( $this->ipb_config ) );
				}
			} else {
				$this->ipb_config += unserialize( $cache );
			}
		}
		
		if ( isset( $this->ipb_config[$tn] ) ) {
			return $this->ipb_config[$tn];
		}
		
		return "";
	}

	private function UserAgents( )
	{
		if ( function_exists( "dle_cache" ) ) {
			$cache = dle_cache( "useragents" );
		}
		$this->_db_connect();
		if ( !$cache ) {
			$this->db->query("SELECT * FROM " . IPB_PREFIX . "core_uagents");
			$usAg = array();
			while ( $row = $this->db->get_row() ) {
				$usAg[] = $row;
			}
			if ( function_exists( "create_cache" ) ) {
				create_cache( "useragents", serialize( $usAg ) );
				return $usAg;
			}
		} else {
			$usAg = @unserialize( $cache );
		}
		
		$this->_db_disconnect();
		
		return $usAg;
	}

	private function ip( )
	{
		if ( !empty( $_SERVER['REMOTE_ADDR'] ) ) {
			return $_SERVER['REMOTE_ADDR'];
		}
		return "not detected";
	}

	private function findUserAgentID( $usName )
	{
		$return = array( "uagent_id" => 0, "uagent_key" => NULL, "uagent_name" => NULL, "uagent_type" => NULL, "uagent_version" => 0 );
		$UserAgents = $this->UserAgents( );
		foreach ( $UserAgents as $id => $v ) {
			$preg = str_replace( "#", "\\#", $v['uagent_regex'] );
			if ( preg_match( "#".$preg."#i", $usName, $match ) ){
				if ( $v['uagent_regex_capture'] ) {
					$ver = $match[$v['uagent_regex_capture']];
				} else {
					$ver = 0;
				}
				$return = array(
					"uagent_id" => $v['uagent_id'],
					"uagent_key" => $v['uagent_key'],
					"uagent_name" => $v['uagent_name'],
					"uagent_type" => $v['uagent_type'],
					"uagent_version" => intval( $ver )
				);
			}
			break;
		}
		return $return;
	}

	private function generatePasswordSalt( $len = 5 ) {
		$string = "";
		for ( $i = 0; $i < $len; ++$i )
		{
			$chr = mt_rand( 33, 126 );
			if ( $chr == "92" )
				$chr = 93;
			$string .= chr( $chr );
		}
		return $string;
	}

	private function GetForumDomain( ) {
	
		if ( $this->IPBConfig("cookie_domain") != "" ) {
			$domain = $this->IPBConfig( "cookie_domain" );
			return $domain;
		}
		
		$domain = ".".clean_url( $this->IPBConfig( "board_url" ) );
		return $domain;
	}

	public function login( $member )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_login'] )
			{
				return TRUE;
			}
			
			if ( empty( $member['user_id'] ) )
			{
				return TRUE;
			}
			
			if ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == "logout" )
			{
				return TRUE;
			}
			
			$this->_db_connect( );
			$TIME = time( );
			
			$domain = $this->GetForumDomain();
			
			if ( isset( $_COOKIE[$this->IPBConfig( "cookie_id" )."session_id"] ) )
			{
				$session_id = $this->db->safesql( $_COOKIE[$this->IPBConfig( "cookie_id" )."session_id"] );
			}
			elseif ( !empty( $_COOKIE['forum_session_id'] ) )
			{
				$session_id = $this->db->safesql( $_COOKIE['forum_session_id'] );
			}
			else
			{
				$session_id = "";
			}
			
			//	print_r( $this->member ); exit;

			if ( !$session_id || (( $row = $this->db->super_query("SELECT s.id, s.member_id, m.name FROM " . IPB_PREFIX . "sessions AS s LEFT OUTER JOIN " . IPB_PREFIX . "members AS m ON (s.member_id = m.member_id) WHERE s.id='{$session_id}' AND s.running_time>" .( $TIME - $this->IPBConfig( "session_expiration" ) )." LIMIT 1") ) && $row['member_id'] == 0 && isset( $member['user_id'] ) ) || $row['name'] != $member['name'] )
			{
				if ( empty( $this->member ) && isset( $member['name'] ) )
				{
					if ( DLE_CHARSET != "UTF-8" ) {
						$name = $this->db->safesql( iconv( "windows-1251", DLE_CHARSET, $member['name'] ) );
					} else {
						$name = $this->db->safesql( $member['name'] );
					}
					$this->member = $this->db->super_query( "SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$name}' LIMIT 1" );
					if ( empty( $this->member['member_id'] ) ) {
						if ( !empty( $_POST['login_password'] ) ) {
							$pass = $this->db->safesql( $_POST['login_password'] );
						} else if ( !empty( $_SESSION['dle_password'] ) ) {
							$pass = $this->db->safesql( $_SESSION['dle_password'] );
						} else if ( !empty( $_COOKIE['dle_password'] ) ) {
							$pass = $this->db->safesql( $_COOKIE['dle_password'] );
						}
						$this->CreateMember( $this->db->safesql( $member['name'] ), $pass, $this->db->safesql( $member['email'] ), $TIME, true );
					}
				}
				
				
				if ( empty( $this->member['member_id'] ) )
				{
					$this->member['member_id'] = 0;
					$this->member['name'] = "";
					$this->member['members_display_name'] = "";
					$this->member['members_seo_name'] = "";
					$this->member['member_group_id'] = 2;
				}
				
				if ( !$session_id )
				{
					$session_id = md5( microtime().md5( $member['password'] ) );
				}
				
				$uAgent = $this->findUserAgentID( $_SERVER['HTTP_USER_AGENT'] );
				
				$data = array(
					"id" => $session_id,
					"member_name" => $this->db->safesql( $this->member['members_display_name'] ),
					"seo_name" => $this->db->safesql( $this->member['members_seo_name'] ),
					"member_id" => intval( $this->member['member_id'] ),
					"member_group" => $this->member['member_group_id'],
					"login_type" => 0,
					"running_time" => $TIME,
					"ip_address" => $this->db->safesql( $this->ip( ) ),
					"browser" => $this->db->safesql( substr( $_SERVER['HTTP_USER_AGENT'], 0, 200 ) ),
					"in_error" => 0,
					"current_appcomponent" => "forums",
					"current_module" => "",
					"current_section" => "",
					"location_1_type" => "",
					"location_1_id" => 0,
					"location_2_type" => "",
					"location_2_id" => 0,
					"location_3_type" => "",
					"location_3_id" => 0,
					"uagent_key" => $uAgent['uagent_key'],
					"uagent_version" => $uAgent['uagent_version'],
					"uagent_type" => $uAgent['uagent_type'],
					"uagent_bypass" => intval( $uAgent['uagent_bypass'] )
				);
				
				if ( !$this->connected ) {
					$this->_db_connect();
				}
				
				$this->db->query( "REPLACE INTO " . IPB_PREFIX . "sessions (".implode( ",", array_keys( $data ) ).") VALUES ('".implode( "', '", $data )."')" );
				
				if ( !empty( $this->member['member_id'] ) || !$_COOKIE[$this->IPBConfig("cookie_id")."member_id"]) {
				//	setcookie( $this->IPBConfig( "cookie_id" )."member_id", $this->member['member_id'], time() + 31536000, $this->IPBConfig( "cookie_path" ), $domain );
				//	setcookie( $this->IPBConfig( "cookie_id" )."pass_hash", $this->member['member_login_key'], time() + 25200, $this->IPBConfig( "cookie_path" ), $domain );
				}
			}
			elseif( isset( $row['id'] ) && $session_id ) {
			
				if ( isset( $row['member_id'] ) ) {
				
					$this->member['member_id'] = $row['member_id'];
					/* if( $_COOKIE[$this->IPBConfig("cookie_id") . "member_id"] != $row['member_id'] ) {
						setcookie( $this->IPBConfig( "cookie_id" )."member_id", $row['member_id'], FALSE, $this->IPBConfig( "cookie_path" ), $domain );
					} */
					
				}
				$this->db->query( "UPDATE " . IPB_PREFIX . "sessions SET running_time='{$TIME}', ip_address='" . $this->db->safesql( $this->ip() ) . "', browser='" . $this->db->safesql( $_SERVER['HTTP_USER_AGENT'] ) . "' WHERE id='{$session_id}'");
			}
			
			// print_r( $row ); exit;
				
			if ( empty( $_COOKIE[$this->IPBConfig( "cookie_id" )."session_id"] ) )
			{
				setcookie( "forum_session_id", $session_id, FALSE, "/", ".".clean_url( $_SERVER['HTTP_HOST'] ) );
			}
			
			setcookie( $this->IPBConfig( "cookie_id" )."session_id", $session_id, FALSE, $this->IPBConfig( "cookie_path" ), $domain );
			
			$this->_db_disconnect( );
		}
	}

	public function logout( )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_logout'] )
			{
				return TRUE;
			}
			
			if ( !empty( $_SESSION['dle_name'] ) )
			{
				$dle_name = $_SESSION['dle_name'];
			}
			else if ( !empty( $_COOKIE['dle_name'] ) )
			{
				$dle_name = $_COOKIE['dle_name'];
			}
			else if ( !empty( $_SESSION['dle_user_id'] ) && !empty( $_COOKIE['dle_user_id'] ) )
			{
				$dle_user_id = empty( $_SESSION['dle_user_id'] ) ? intval( $_COOKIE['dle_user_id'] ) : intval( $_SESSION['dle_user_id'] );
				$dle_name = $this->db->super_query( "SELECT name FROM " . USERPREFIX . "_users WHERE user_id='{$dle_user_id}'");
				$dle_name = $dle_name['name'];
			}
			
			if ( !$dle_name )
			{
				return FALSE;
			}
			
			$this->_db_connect();
			
			if ( empty( $this->member['member_id'] ) )
			{
				if ( DLE_CHARSET != "UTF-8" ) {
					$dle_name = $this->db->safesql( iconv( "windows-1251", DLE_CHARSET, $dle_name ) );
				} else {
					$dle_name = $this->db->safesql( $dle_name );
				}
				$this->member = $this->db->super_query("SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$dle_name}' LIMIT 1");
			}
			
			if ( !empty( $this->member['member_id'] ) )
			{
				$this->db->query( "UPDATE " . IPB_PREFIX . "sessions SET member_name='', seo_name = '', member_id='0', running_time=" . time() . ", member_group=" . $this->IPBConfig( "guest_group" ) . " WHERE member_id=" . $this->member['member_id']);
				$this->db->query( "UPDATE " . IPB_PREFIX."members SET last_visit='" . time() . "', last_activity='" . time() . "' WHERE member_id=" . $this->member['member_id'] );
			}
			
			$domain = $this->GetForumDomain( );
			setcookie( $this->IPBConfig( "cookie_id" )."pass_hash", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			setcookie( $this->IPBConfig( "cookie_id" )."member_id", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			setcookie( $this->IPBConfig( "cookie_id" )."topicsread", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			setcookie( $this->IPBConfig( "cookie_id" )."anonlogin", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			setcookie( $this->IPBConfig( "cookie_id" )."forum_read", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			setcookie( $this->IPBConfig( "cookie_id" )."session_id", "", time( ) - 3600, $this->IPBConfig( "cookie_path" ), $domain );
			$this->_db_disconnect();
			return TRUE;
		}
	}

	public function CreateMember( $m_name, $m_pass, $m_email, $m_joined = "", $valid=true )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_reg'] )
			{
				return TRUE;
			}
			
			if( isset($_SESSION['_pass_temp']) && strlen($_SESSION['_pass_temp']) )
			{
				$m_pass = $_SESSION['_pass_temp'];
				if ( DLE_CHARSET != "UTF-8" ) {
					$m_pass = iconv( "WINDOWS-1251", DLE_CHARSET, $m_pass );
				}
				$m_pass = md5($m_pass);
				unset($_SESSION['_pass_temp']);
			}
			
			if ( DLE_CHARSET != "UTF-8" ) {
				$m_username = iconv( "WINDOWS-1251", DLE_CHARSET, strtolower( $m_name ) );
				$m_name = iconv( "WINDOWS-1251", DLE_CHARSET, $m_name );
			} else {
				$m_username = strtolower( $m_name );
			}
			
			if ( !$this->connected ) {
				$this->_db_connect();
			}
			
			if ( $this->db->super_query( "SELECT member_id FROM " . IPB_PREFIX . "members WHERE name='{$m_name}'") ) {
				if ( $this->useIpbDb ) {
					$this->_db_disconnect();
				}
				return TRUE;
			}
			
			$string = $this->generatePasswordSalt();
			
			if ( DLE_CHARSET != "UTF-8" ) {
				$string = iconv( "WINDOWS-1251", DLE_CHARSET, $string );
			}
			
			$m_pass_hash = md5( md5( $string ) . $m_pass );
			
			if ( function_exists( "dle_cache" ) )
			{
				$language = dle_cache( "default_language" );
			} else {
				$language = FALSE;
			}
			
			if ( !$m_joined )
			{
				$m_joined = time() + $GLOBALS['config']['date_adjust'] * 60;
			}
			
			if ( empty( $language ) ) {
				$query_lang_id = $this->db->super_query( "SELECT lang_id FROM " . IPB_PREFIX . "core_sys_lang WHERE lang_default=1 LIMIT 1" );
				$language = $query_lang_id['lang_id'];
				if ( function_exists( "create_cache" ) ) {
					create_cache( "default_language", $language );
				}
			}
			
			$ipbIns = array();
			$ipbIns['name'] = $m_name;
			$ipbIns['members_l_username'] = $m_username;
			$ipbIns['joined'] = $m_joined;
			$ipbIns['email'] = $m_email;
			$ipbIns['member_group_id'] = $valid ? $this->ipb_config['member_group'] : $this->ipb_config['auth_group'];
			// $ipbIns['member_group_id'] = $this->IPBConfig( "member_group" );
			$ipbIns['ip_address'] = $this->db->safesql( $this->ip( ) );
			$ipbIns['members_created_remote'] = 0;
			$ipbIns['member_login_key'] = md5( $this->generatePasswordSalt( 60 ) );
			$ipbIns['member_login_key_expire'] = $this->IPBConfig( "login_key_expire" ) ? time( ) + intval( $this->IPBConfig( "login_key_expire" ) ) * 86400 : 0;
			$ipbIns['view_sigs'] = 1;
			$ipbIns['view_img'] = 1;
			$ipbIns['restrict_post'] = 0;
			$ipbIns['allow_admin_mails'] = 1;
			$ipbIns['msg_count_total'] = 0;
			$ipbIns['msg_count_new'] = 0;
			$ipbIns['msg_show_notification'] = 1;
			$ipbIns['coppa_user'] = 0;
			$ipbIns['auto_track'] = 0;
			$ipbIns['members_auto_dst'] = 0;
			$ipbIns['dst_in_use'] = 0;
			$ipbIns['last_visit'] = $m_joined;
			$ipbIns['last_activity'] = $m_joined;
			$ipbIns['language'] = $language;
			// $ipbIns['members_editor_choice'] = $this->IPBConfig("ips_default_editor");
			$ipbIns['members_pass_salt'] = $this->db->safesql( $string );
			$ipbIns['members_pass_hash'] = $m_pass_hash;
			$ipbIns['members_display_name'] = $m_name;
			$ipbIns['members_l_display_name'] = $m_username;
			$ipbIns['fb_uid'] = 0;
			$ipbIns['time_offset'] = 0;
			$ipbIns['fb_emailhash'] = "";
			$ipbIns['members_seo_name'] = $m_name;
			
			// print_r($ipbIns);
			
			$this->db->query( "INSERT INTO " . IPB_PREFIX . "members (".implode( ",", array_keys( $ipbIns ) ).") VALUES ('".implode( "', '", $ipbIns )."')" );
			
			$user_id = $this->db->insert_id();
			
			$this->db->query( "INSERT INTO " . IPB_PREFIX . "pfields_content (member_id) VALUES ('{$user_id}')");
			$this->db->query( "INSERT INTO " . IPB_PREFIX . "profile_portal (pp_member_id, pp_setting_count_friends, pp_setting_count_comments) VALUES ('{$user_id}', 1, 1)");
			
			/* $cache_ipb = $this->db->super_query( "SELECT cs_value FROM " . IPB_PREFIX . "cache_store WHERE cs_key='stats'" );
			$cache_ipb = unserialize( $cache_ipb['cs_value'] );
			$cache_ipb_new = array(
				"total_replies" => $cache_ipb['total_replies'],
				"total_topics" => $cache_ipb['total_topics'],
				"mem_count" => $cache_ipb['mem_count'] + 1,
				"last_mem_name" => $m_name,
				"last_mem_id" => $user_id,
				"most_count" => $cache_ipb['most_count'],
				"most_date" => $cache_ipb['most_date']
			);
			$this->db->query( "REPLACE INTO ".IPB_PREFIX . "cache_store VALUES ('stats', '".$this->db->safesql( serialize( $cache_ipb_new ) )."', '', '1', ".time( ).")" ); */
			
			if ( $this->connected ) {
				$this->_db_disconnect( );
			}
			
			$this->member = $ipbIns;
			$this->member['member_id'] = $user_id;
			return TRUE;
		}
	}

	public function UpdateRegister( $m_name, $field_6, $field_4, $field_7 )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_reg'] )
			{
				return TRUE;
			}
			
			$this->_db_connect();
			
			if ( DLE_CHARSET != "UTF-8" ) {
				$m_name = iconv( "windows-1251", DLE_CHARSET, $m_name );
				$field_6 = iconv( "windows-1251", DLE_CHARSET, $field_6 );
				$field_4 = iconv( "windows-1251", DLE_CHARSET, $field_4 );
				$field_7 = iconv( "windows-1251", DLE_CHARSET, $field_7 );
			}
			
			if ( empty( $this->member['member_id'] ) )
			{
				$this->member = $this->db->super_query( "SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$m_name}' LIMIT 1");
			}
			
			if ( empty( $this->member['member_id'] ) )
			{
				return FALSE;
			}
			
			// exit( $this->ipb_config['member_group'] );
			
			$this->db->query("UPDATE " . IPB_PREFIX . "members SET member_group_id='{$this->ipb_config['member_group']}' WHERE member_id='{$this->member['member_id']}'");
			$this->db->query("UPDATE " . IPB_PREFIX . "pfields_content SET field_4='{$field_4}', field_6='{$field_6}', field_7='{$field_7}' WHERE member_id='{$this->member['member_id']}'");
			$this->_db_disconnect();
		}
		return TRUE;
	}

	public function UpdateProfile( $m_name, $m_email, $m_pass, $field_4, $field_6, $field_7, $userAsID = FALSE, $banned = FALSE )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_profile'] )
			{
				return TRUE;
			}
			
			if ( $userAsID ) {
				$rows = $this->db->super_query( "SELECT * FROM ".USERPREFIX."_users WHERE user_id=".$m_name );
				if ( empty( $rows['name'] ) ) {
					return FALSE;
				}
				$m_name = $this->db->safesql( $rows['name'] );
			}
			
			if ( DLE_CHARSET != "UTF-8" )
			{
				$m_name = iconv( "windows-1251", DLE_CHARSET, $m_name );
				$field_4 = iconv( "windows-1251", DLE_CHARSET, $field_4 ); // ICQ
				$field_7 = iconv( "windows-1251", DLE_CHARSET, $field_7 ); // Lang
				$field_6 = iconv( "windows-1251", DLE_CHARSET, $field_6 ); // Info
			}
			
			$this->_db_connect();
			
			if ( empty( $this->member['member_id'] ) )
			{
				$this->member = $this->db->super_query( "SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$m_name}' LIMIT 1");
			}
			
			if ( empty( $this->member['member_id'] ) )
			{
				$this->_db_disconnect();
				return FALSE;
			}
			
			if ( strlen( $m_pass ) > 0 )
			{
				$string = $this->generatePasswordSalt();
				
				if ( DLE_CHARSET != "UTF-8" )
				{
					$m_pass = iconv( "windows-1251", DLE_CHARSET, $m_pass );
					$string = iconv( "windows-1251", DLE_CHARSET, $string );
				}
				
				/* if ( $userAsID )
				{
					$m_pass = html_entity_decode( $m_pass, ENT_QUOTES );
					$chr1 = array( "&#33;", "&#036;", "&#092;" );
					$chr2 = array( "!", "\$", "\\" );
					$m_pass = str_replace( $chr1, $chr2, $m_pass );
				} */
				
				$m_pass_hash = md5( md5( $string ).md5( $m_pass ) );
				$pre_pass = ", members_pass_salt='" . $this->db->safesql( $string ) . "', members_pass_hash='".$m_pass_hash."'";
			}
			else
			{
				$pre_pass = "";
			}
			
			
			if( $banned ) {
				$ban = ", member_group_id='{$this->ipb_config['banned_group']}'";
			} else {
				$ban = '';
			}
			
			$this->db->query("UPDATE " . IPB_PREFIX . "members SET email='{$m_email}'{$pre_pass}{$ban} WHERE member_id={$this->member['member_id']}");
			$this->db->query("UPDATE " . IPB_PREFIX . "pfields_content SET field_4='{$field_4}', field_6='{$field_6}', field_7='{$field_7}' WHERE member_id='{$this->member['member_id']}'");
			$this->_db_disconnect();
			return TRUE;
		}
	}

	public function LostPassword( $m_name, $m_pass2 )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_lostpass'] )
			{
				return TRUE;
			}
			
			$this->_db_connect();
			
			if ( DLE_CHARSET != "UTF-8" ) {
				$m_name = iconv( "windows-1251", DLE_CHARSET, $m_name );
				$m_pass2 = iconv( "windows-1251", DLE_CHARSET, $m_pass2 );
			}
			
			$string = $this->generatePasswordSalt();
			$m_pass_hash = md5( md5( $string ).md5( $m_pass2 ) );
			$this->db->query("UPDATE " . IPB_PREFIX . "members SET members_pass_hash='{$m_pass_hash}', members_pass_salt='" . $this->db->safesql( $string ) . "' WHERE name='{$m_name}'");
			$this->_db_disconnect();
		}
	}

	public function ChangeUserName( $m_user_id, $m_new_name )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_admin'] )
			{
				return TRUE;
			}
			
			if ( empty( $this->member['name'] ) )
			{
				$rowz = $this->db->super_query( "SELECT name FROM ".USERPREFIX."_users WHERE user_id=".$m_user_id );
				if ( empty( $rowz['name'] ) )
				{
					return FALSE;
				}
				$dle_name = $this->db->safesql( $rowz['name'] );
			}
			else
			{
				$dle_name = $this->db->safesql( $this->member['name'] );
			}
			
			$this->_db_connect();
			
			if ( DLE_CHARSET != "UTF-8" ) {
				$dle_name = iconv( "windows-1251", DLE_CHARSET, $dle_name );
				$members_l_username = iconv( "windows-1251", DLE_CHARSET, strtolower( $m_new_name ) );
				$m_new_name = iconv( "windows-1251", DLE_CHARSET, $m_new_name );
			} else {
				$members_l_username = strtolower( $m_new_name );
			}
			
			if ( $this->db->super_query( "SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$m_new_name}' OR members_display_name='{$m_new_name}'" ) )
			{
				$this->_db_disconnect( );
				return FALSE;
			}
			
			$this->db->query( "UPDATE " . IPB_PREFIX . "members SET name='{$m_new_name}', members_l_username='{$members_l_username}', members_l_display_name='{$members_l_username}', members_display_name='{$m_new_name}', members_seo_name='{$m_new_name}' WHERE name='{$dle_name}'");
			$this->db->query( "UPDATE " . IPB_PREFIX . "moderators SET member_name='{$m_new_name}' WHERE member_name='{$dle_name}'");
			$this->db->query( "UPDATE " . IPB_PREFIX . "forums SET last_poster_name='{$m_new_name}', seo_last_name='{$m_new_name}' WHERE last_poster_name='{$dle_name}'");
			$this->db->query( "UPDATE " . IPB_PREFIX . "sessions SET member_name='{$m_new_name}', seo_name='{$m_new_name}' WHERE member_name='{$dle_name}'");
			$this->db->query( "UPDATE " . IPB_PREFIX . "topics SET starter_name='{$m_new_name}', seo_first_name='{$m_new_name}' WHERE starter_name='{$dle_name}'");
			$this->db->query( "UPDATE " . IPB_PREFIX . "topics SET last_poster_name='{$m_new_name}', seo_last_name='{$m_new_name}' WHERE last_poster_name='{$dle_name}'");
			$this->_db_disconnect();
		}
	}

	public function DeleteUser( $m_name )
	{
		if ( $this->config['allow_module'] )
		{
			if ( !$this->config['allow_admin'] )
			{
				return TRUE;
			}
			
			if ( DLE_CHARSET != "UTF-8" )
			{
				$m_name = iconv( "windows-1251", DLE_CHARSET, $m_name );
			}
			
			$m_name = $this->_db_connect()->safesql( $m_name );
			
			$rowz = $this->db->super_query("SELECT * FROM " . IPB_PREFIX . "members WHERE name='{$m_name}' LIMIT 1");
			
			if ( empty( $rowz['member_id'] ) )
			{
				$this->_db_disconnect( );
				return FALSE;
			}
			
			$files = array();
			
			$this->db->query("SELECT * FROM " . IPB_PREFIX . "profile_portal WHERE pp_member_id={$rowz['member_id']}");
			
			while ( $rw = $this->db->get_row() ) {
				if ( $rw['pp_main_photo'] ) {
					$files[] = $rw['pp_main_photo'];
				}
				
				if ( $rw['pp_thumb_photo'] ) {
					$files[] = $rw['pp_thumb_photo'];
				}
				
				if ( !( $rw['avatar_type'] == "upload" ) && !$rw['avatar_location'] ) {
					$files[] = $rw['avatar_location'];
				}
			}
			
			$this->db->query( "UPDATE " . IPB_PREFIX . "posts SET author_id=0 WHERE author_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "topics SET starter_id=0 WHERE starter_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "announcements SET announce_member_id=0 WHERE announce_member_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "attachments SET attach_member_id=0 WHERE attach_member_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "polls SET starter_id=0 WHERE starter_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "voters SET member_id=0 WHERE member_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "forums SET last_poster_name='' WHERE last_poster_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "forums SET seo_last_name='' WHERE last_poster_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "forums SET seo_last_name='' WHERE last_poster_id=".$rowz['member_id'] );
		//	$this->db->query( "UPDATE " . IPB_PREFIX . "profile_comments SET comment_by_member_id=0 WHERE comment_by_member_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "profile_ratings SET rating_by_member_id=0 WHERE rating_by_member_id=".$rowz['member_id'] );
		//	$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_comments WHERE comment_for_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_ratings WHERE rating_for_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_portal WHERE pp_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_portal_views WHERE views_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_friends WHERE friends_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "profile_friends WHERE friends_friend_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "dnames_change WHERE dname_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "pfields_content WHERE member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "members_partial WHERE partial_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "moderators WHERE member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "sessions WHERE member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "warn_logs WHERE wlog_mid=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "warn_logs SET wlog_addedby=0 WHERE wlog_addedby=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "admin_permission_rows WHERE row_id_type='member' AND row_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "core_sys_cp_sessions WHERE session_member_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "upgrade_history SET upgrade_mid=0 WHERE upgrade_mid=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "message_topic_user_map WHERE map_user_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "message_posts SET msg_author_id=0 WHERE msg_author_id=".$rowz['member_id'] );
			$this->db->query( "UPDATE " . IPB_PREFIX . "message_topics SET mt_starter_id=0 WHERE mt_starter_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "ignored_users WHERE ignore_owner_id=".$rowz['member_id']." or ignore_ignore_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "core_item_markers WHERE item_member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "validating WHERE member_id=".$rowz['member_id'] );
			$this->db->query( "DELETE FROM " . IPB_PREFIX . "members WHERE member_id=".$rowz['member_id'] );
			$this->_db_disconnect( );
			
			if ( count( $files ) )
			{
				foreach ( $files as $f )
				{
					@unlink( $this->IPBConfig( "upload_dir" ) . "/" . $f );
				}
			}
		}
	}
}

if ( !function_exists( "clean_url" ) ){
	function clean_url($url) {
		if( $url == '' ) return;
		$url = str_replace( "http://", "", strtolower( $url ) );
		$url = str_replace( "https://", "", $url );
		if( substr( $url, 0, 4 ) == 'www.' ) $url = substr( $url, 4 );
		$url = explode( '/', $url );
		$url = reset( $url );
		$url = explode( ':', $url );
		$url = reset( $url );
		return $url;
	}
}

$ipb = new ipb_member( $db );
?>
