<?php

class forumsMemberSync
{

	public $registry = NULL;
	private $connect_method = "connect";
	public $db = NULL;
	private static $dle_user = array( );

	public function __construct( )
	{
		if ( defined( "CONVERT" ) )
		{
			return TRUE;
		}
		
		$this->registry = ipsRegistry::instance( );
		
		require_once( dirname( __FILE__ )."/dbconfig.php" );
		require_once( dirname( __FILE__ )."/dle_config.php" );
		
		if ( !defined( "COLLATE" ) ) {
			define( "COLLATE", "utf8" );
		}
		
		if ( ipsRegistry::$settings['sql_host'] === DBHOST && ipsRegistry::$settings['sql_user'] === DBUSER && ipsRegistry::$settings['sql_pass'] === DBPASS )
		{
			if ( ipsRegistry::$settings['sql_database'] === DBNAME )
			{
				$this->connect_method = "none";
			}
			else
			{
				$this->connect_method = "use";
			}
			$this->db = ipsRegistry::db();
		}
		else
		{
			if ( !class_exists( "dbMain" ) )
			{
				require_once( IPS_KERNEL_PATH."classDb.php" );
				require_once( IPS_KERNEL_PATH."class_db_".ucwords( ipsRegistry::$settings['sql_driver'] ).".php" );
			}
			
			$classname = "db_driver_".ipsRegistry::$settings['sql_driver'];
			$this->db = new $classname( );
			$this->db->obj['sql_database'] = DBNAME;
			$this->db->obj['sql_user'] = DBUSER;
			$this->db->obj['sql_pass'] = DBPASS;
			$this->db->obj['sql_host'] = DBHOST;
			$this->db->obj['sql_port'] = "";
			$this->db->obj['sql_tbl_prefix'] = USERPREFIX;
			$this->db->obj['use_shutdown'] = 0;
			$this->db->obj['force_new_connection'] = 1;
		}
	}

	public function onLogOut( $member )
	{
		setcookie( "dle_user_id", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		setcookie( "dle_password", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		setcookie( "dle_name", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		setcookie( "dle_skin", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		setcookie( "dle_newpm", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		setcookie( "dle_hash", '', time( ) + 31536000, "/", ".".DLE_DOMAIN );
		@session_unset();
		@session_destroy(); 
	}
	
	public function onCreateAccount( $member )
	{
		if ( !DLE_REGISTER && defined( "CONVERT" ) )
		{
			return TRUE;
		}
		
		if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" ) {
			$member['name'] = iconv( "UTF-8", DLE_CHARSET, $member['name'] );
			$_real_pass = iconv( "UTF-8", DLE_CHARSET, $_REQUEST['PassWord'] );
		} else {
			$_real_pass = $_REQUEST['PassWord'];
		}
		
		$this->db_connect( );
		$member['name'] = $this->db->addSlashes( $member['name'] );
		
		self::$dle_user = $this->db->buildAndFetch( array("select" => "*","from" => "_users","where" => "name=\"{$member['name']}\" OR email='{$member['email']}'") );
		
		if ( !empty( $dle_user['user_id'] ) ) {
			$this->db_disconnect();
			return TRUE;
		}
		
		$pass_one = md5( $_real_pass );
		$pass_md5 = md5( $pass_one );
		
		self::$dle_user = array(
			"name" => $member['name'],
			"password" => $pass_md5,
			"email" => $member['email'],
			"reg_date" => $member['joined'],
			"lastdate" => $member['joined'],
			"user_group" => USER_GROUP,
			"logged_ip" => $this->db->addSlashes( $_SERVER['REMOTE_ADDR'] ),
			"info" => "",
			"signature" => "",
			"foto" => "",
			"fullname" => "",
			"land" => "",
			"icq" => "",
			"favorites" => "",
			"xfields" => "",
			"allowed_ip" => ""
		);
		
		$this->db->insert( "_users", self::$dle_user );
		
		$user_id = $this->db->getInsertId();
		self::$dle_user['user_id'] = $user_id;
		setcookie( "dle_user_id", $user_id, time( ) + 31536000, "/", "." . DLE_DOMAIN );
		setcookie( "dle_password", $pass_one, time( ) + 31536000, "/", "." . DLE_DOMAIN );
		$this->db_disconnect();
	}

	public function onRegisterForm( )
	{
	}

	public function onLogin( $member )
	{
		if ( !DLE_LOGIN && defined( "CONVERT" ) )
		{
			return TRUE;
		}
		
		if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" ) {
			$member['name'] = iconv( "UTF-8", DLE_CHARSET, $member['name'] );
			$_password = iconv( "UTF-8", DLE_CHARSET, $_REQUEST['ips_password'] );
		} else  {
			$_password = $_REQUEST['ips_password'];
		}
		
		$_password_hash = md5(md5( $_password ));
		
		$this->db_connect();
		
		if ( defined( "CONVERT_TO_DLE" ) && CONVERT_TO_DLE && empty( self::$dle_user['user_id'] ) )
		{
			$name = $this->db->addSlashes( $member['name'] );
			self::$dle_user = $this->db->buildAndFetch( array("select" => "*","from" => "_users","where" => "(name='{$name}' OR email='{$member['email']}') AND password='{$_password_hash}'") );
			
			if ( !self::$dle_user ) {
				self::$dle_user = array(
					"name" => $member['name'],
					"password" => $_password_hash,
					"email" => $member['email'],
					"reg_date" => $member['joined'],
					"lastdate" => $member['joined'],
					"user_group" => USER_GROUP,
					"logged_ip" => $this->db->addSlashes( $_SERVER['REMOTE_ADDR'] ),
					"info" => "",
					"signature" => "",
					"foto" => "",
					"fullname" => "",
					"land" => "",
					"icq" => "",
					"favorites" => "",
					"xfields" => "",
					"allowed_ip" => ""
				);
				$this->db->insert( "_users", self::$dle_user );
				self::$dle_user['user_id'] = $this->db->getInsertId( );
			}
		}
		
		if ( empty( self::$dle_user['user_id'] ) ) {
			$name = $this->db->addSlashes( $member['name'] );
			self::$dle_user = $this->db->buildAndFetch( array("select" => "*", "from" => "_users", "where" => "name='{$name}' AND password='{$_password_hash}'"));
			//echo $this->db->fetchSqlString();exit;
		}
		
		if ( isset( self::$dle_user['user_id'] ) )
		{
			setcookie( "dle_user_id", self::$dle_user['user_id'], time() + 31536000, "/", ".".DLE_DOMAIN );
			setcookie( "dle_password", md5( $_password ), time() + 31536000, "/", ".".DLE_DOMAIN );
		}
		
		$this->db_disconnect( );
	}

	public function onDelete( $mem )
	{
		/* $mems = explode(',', trim(str_replace(array('IN(',')'),'', trim( $mem ))));
		if(is_array($mems) && count($mems))
		{
			$Member = IPSMember::load( $mems );
			print_r( $member ); exit;
		} */
		// $this->db_connect();
		// $this->db_disconnect();	
	}

	public function onMerge( $member, $adf )
	{
	}

	public function onEmailChange( $member_id, $m_mail )
	{
		if ( !DLE_PROFILE ) {
			return TRUE;
		}
		
		$name = ips_MemberRegistry::getproperty("name");
		
		if ( ips_MemberRegistry::getproperty("member_id") != $member_id )
		{
			$Member = IPSMember::load( $member_id, "members", "id");
			$name = $Member['name'];
		}
		
		if ( $name )
		{
			if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" )
			{
				$name = iconv( "UTF-8", DLE_CHARSET, $name );
			}
			$this->db_connect()->update( "_users", array("email" => $this->db->addSlashes( $m_mail )), "name='{$name}'" );
			$this->db_disconnect();
		}
	}

	public function onPassChange( $member_id, $m_newPass )
	{
		if ( !DLE_PROFILE ) {
			return TRUE;
		}
		
		$name = ips_MemberRegistry::getproperty( "name" );
		if ( ips_MemberRegistry::getproperty( "member_id" ) != $member_id )
		{
			$Member = IPSMember::load( $member_id, "members", "id" );
			$name = $Member['name'];
		}
		
		if ( $name ) {
			if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" ) {
				$name = iconv( "UTF-8", DLE_CHARSET, $name );
				$m_newPass = iconv( "UTF-8", DLE_CHARSET, $m_newPass );
			}
			$this->db_connect()->update( "_users", array("password" => md5( md5( $m_newPass ) )), "name='{$name}'" );
			$this->db_disconnect();
			setcookie( "dle_password", md5( $m_newPass ), time( ) + 31536000, "/", ".".DLE_DOMAIN );
		}
	}

	public function onProfileUpdate( $member )
	{
		if ( !DLE_PROFILE )
		{
			return TRUE;
		}
		
		$_update = array( );
		if ( isset( $member['customFields']['field_6'] ) )
		{
			$_update['land'] = $member['customFields']['field_6'];
		}
		
		if ( isset( $member['customFields']['field_4'] ) )
		{
			$_update['icq'] = $member['customFields']['field_4'];
		}
		
		if ( isset( $member['customFields']['field_7'] ) )
		{
			$_update['info'] = $member['customFields']['field_7'];
		}
		
		$name = ips_MemberRegistry::getproperty( "name" );
		
		if ( $_update && $name )
		{
			if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" )
			{
				$name = iconv( "UTF-8", DLE_CHARSET, $name );
				foreach ( $_update as $v )
				{
					#	Do Not Work???
					#	$v = iconv( "UTF-8", DLE_CHARSET, $v );
					#	Do Not Work???
				}
			}
			$name = $this->db_connect()->addSlashes( $name );
			$this->db->update( "_users", $_update, "name='{$name}'" );
			$this->db_disconnect( );
		}
	}

	public function onGroupChange( $member_id, $onGroupChange )
	{
		$name = ips_MemberRegistry::getproperty( "name" );
		
		if ( ips_MemberRegistry::getproperty( "member_id" ) != $member_id )
		{
			$Member = IPSMember::load( $member_id, "members", "id" );
			$name = $Member['name'];
		}
		
		//print_r( $Member ); exit;

		if( $onGroupChange == ipsRegistry::$settings['banned_group'] ){
			if ( $name ) {
				$this->db_connect()->update("_users", array("banned" => 'yes'), "name='{$name}'");
				$this->db_disconnect();
			}
		}
	}

	public function onNameChange( $member_id, $onNameChange )
	{
		$email = ips_MemberRegistry::getproperty("email");
		if ( ips_MemberRegistry::getproperty("member_id") != $member_id ) {
			$Member = IPSMember::load( $member_id, "members", "id" );
			$email = $Member['email'];
		}
		if ( DLE_CHARSET != "" && DLE_CHARSET != "UTF-8" ) {
			$onNameChange = iconv( "UTF-8", DLE_CHARSET, $onNameChange );
		}
		if( $onNameChange ) {
			$this->db_connect();
			$email = $this->db->addSlashes( $email );
			$dle = $this->db->buildAndFetch(array("select" => "*","from" => "_users", "where" => "email='{$email}'"));
			$this->db->update( "_users", array("name" => $this->db->addSlashes($onNameChange)), "user_id='{$dle['user_id']}'" );
			$this->db_disconnect();
		}
	}

	public function db_connect( )
	{
		switch ( $this->connect_method )
		{
			case "none" :
				$this->db->prefix_changed = 0;
				$this->db->obj['sql_tbl_prefix'] = USERPREFIX;
			break;
			case "use" :
				$this->db->query( "USE `".DBNAME."`" );
				$this->db->prefix_changed = 0;
				$this->db->obj['sql_tbl_prefix'] = USERPREFIX;
			break;
			default :
				$this->db->connect();
			break;
		}
		if ( COLLATE != "" && ipsRegistry::$settings['sql_charset'] != COLLATE )
		{
			$this->db->query( "SET NAMES '".COLLATE."'" );
		}
		return $this->db;
	}

	public function db_disconnect( )
	{
		switch ( $this->connect_method )
		{
			case "none" :
				$this->db->prefix_changed = 1;
				$this->db->obj['sql_tbl_prefix'] = ipsRegistry::$settings['sql_tbl_prefix'];
				if ( !( COLLATE != "" ) )
				{
					break;
				}
				if ( !empty( $settings['sql_charset'] ) )
				{
					if ( !( ipsRegistry::$settings['sql_charset'] != COLLATE ) )
					{
						break;
					}
					$this->db->query( "SET NAMES '".ipsRegistry::$settings['sql_charset']."'" );
					$this->db->query( "SET CHARACTER SET '".ipsRegistry::$settings['sql_charset']."'" );
				}
			break;
			case "use" :
				$this->db->query( "USE `".ipsRegistry::$settings['sql_database']."`" );
				$this->db->prefix_changed = 1;
				$this->db->obj['sql_tbl_prefix'] = ipsRegistry::$settings['sql_tbl_prefix'];
				if ( !( COLLATE != "" ) )
				{
					break;
				}
				if ( !empty( $settings['sql_charset'] ) )
				{
					if ( !( ipsRegistry::$settings['sql_charset'] != COLLATE ) )
					{
						break;
					}
					$this->db->query( "SET NAMES '".ipsRegistry::$settings['sql_charset']."'" );
					$this->db->query( "SET CHARACTER SET '".ipsRegistry::$settings['sql_charset']."'" );
				}
			break;
			default :
				$this->db->disconnect();
			break;
		}
	}

}
?>
