<?php
/********************************************************
	powered by Script Developers Group (SD-Group)
	email: info@sd-group.org.ua
	url: http://sd-group.org.ua/
	Copyright 2009 (c) MDS-Job v2.0 (c) SD-Group
	All rights reserved
=========================================================
	 
********************************************************/

/*******       **********/
function CutForbiddenChars($str)
{
	//   $str   string
	$str = (string) $str;
	//   
	$forbidden_characters = array (
										"'" 		=> '',
										'"' 		=> '',
										"\\" 		=> '',
										"%00" 		=> '',
										"%0d" 		=> '',
										"%0a" 		=> '',
										"%22" 		=> '',
										"%27" 		=> '',
										"&quot;" 	=> '',
										"&lt;" 		=> '',
										"&gt;" 		=> '',
										"&#039;" 	=> '',
										"&#034;" 	=> '',
										"&#060;" 	=> '',
										"&#062;" 	=> '',
										"&#092;" 	=> '',
										"&#096;" 	=> '',
	                              );

	//   
	$str = strtr($str, $forbidden_characters);
	//   '+' ()      
	$first_pos_plus = strpos($str, '+');
	$last_pos_plus = strrpos($str, '+');

	if ($first_pos_plus && $last_pos_plus)
	{
		$str = substr($str, 0, $first_pos_plus) . substr($str, $last_pos_plus + 1);
	}

	//  '<iframe>...</iframe>'      
	do {
			$first_pos_iframe = strpos($str, '%3Ciframe');
			$last_pos_iframe = strpos($str, '/iframe%3E');

			if ($first_pos_iframe && $last_pos_iframe)
			{
				$doit = true;

				$str = substr($str, 0, $first_pos_iframe) . substr($str, $last_pos_iframe + 10);
			}
			else
			{
				$doit = false;
			}

	} while ($doit);

	return $str;
}

/*******          **********/
function ClearDataFromRequest()
{ 
	foreach($_REQUEST as $reqKey => $reqValue)
	{
		//   $reqValue   string
		$reqValue = (string) $reqValue;
		//      
		$reqValue = trim($reqValue);
		//  html-
		$reqValue = @strip_tags($reqValue);
		//  
		$reqValue = stripslashes($reqValue);
		$reqValue = stripslashes($reqValue);
		//  html-
		$reqValue = htmlspecialchars($reqValue);
		//   
		$reqValue = CutForbiddenChars($reqValue);

		$_REQUEST[$reqKey] = $reqValue;
	}
} 

/*******        **********/
function ClearDataFromForm($data)
{ 
	//   $data   string
	$data = (string) $data;
	//      
	$data = trim($data);
	//  html-
	$data = @strip_tags($data);
	//  
	$data = stripslashes($data);
	$data = stripslashes($data);
	//  html-
	$data = htmlspecialchars($data);
	//    
	$forbidden_characters = array (
										"'" 		=> '',
										'"' 		=> '',
										"\\" 		=> '',
										"%00" 		=> '',
										"%0d" 		=> '',
										"%0a" 		=> '',
										"%22" 		=> '',
										"%27" 		=> '',
	                              );

	//   
	$data = strtr($data, $forbidden_characters);

	return $data;
} 

/******            ********/
function UseHTMLTagsIn($data)
{
	//    
	$exch_characters = array (
										'<b>' 		=> '[b]',
										'</b>' 		=> '[/b]',
										'<i>' 		=> '[i]',
										'</i>' 		=> '[/i]',
										"\r\n" 		=> '[br /]'
	                         );

	//  
	$data = strtr($data, $exch_characters);

	return $data;
}

/******               ********/
function UseHTMLTagsOut($data)
{
	//    
	$exch_characters = array (
										'  ' 		=> '&nbsp;&nbsp;',
										'[b]' 		=> '<b>',
										'[/b]' 		=> '</b>',
										'[i]' 		=> '<i>',
										'[/i]' 		=> '</i>',
										'[br /]'	=> '<br />'
	                         );

	//  
	$data = strtr($data, $exch_characters);

	return $data;
}

/******             TextArea ********/
function UseHTMLTagsTextArea($data)
{
	//    
	$exch_characters = array (
										'[b]' 		=> '<b>',
										'[/b]' 		=> '</b>',
										'[i]' 		=> '<i>',
										'[/i]' 		=> '</i>',
										'[br /]'	=> "\r\n"
	                         );

	//  
	$data = strtr($data, $exch_characters);

	return $data;
}

?>