<?php
/********************************************************
	powered by Script Developers Group (SD-Group)
	email: info@sd-group.org.ua
	url: http://sd-group.org.ua/
	Copyright 2009 (c) MDS-Job v2.0 (c) SD-Group
	All rights reserved
=========================================================
	Функции безопасности
********************************************************/

/******* Функция удаления запрещенных символов из строк **********/
function CutForbiddenChars($str)
{
	// форсируем конвертацию $str в тип string
	$str = (string) $str;
	// массив запрещенных символов
	$forbidden_characters = array (
										"'" 		=> '',
										'"' 		=> '',
										"\\" 		=> '',
										"%00" 		=> '',
										"%0d" 		=> '',
										"%0a" 		=> '',
										"%22" 		=> '',
										"%27" 		=> '',
										"&quot;" 	=> '',
										"&lt;" 		=> '',
										"&gt;" 		=> '',
										"&#039;" 	=> '',
										"&#034;" 	=> '',
										"&#060;" 	=> '',
										"&#062;" 	=> '',
										"&#092;" 	=> '',
										"&#096;" 	=> '',
	                              );

	// вырезаем запрещенные символы
	$str = strtr($str, $forbidden_characters);
	// вырезаем знаки '+' (плюс) и все что находится между ними
	$first_pos_plus = strpos($str, '+');
	$last_pos_plus = strrpos($str, '+');

	if ($first_pos_plus && $last_pos_plus)
	{
		$str = substr($str, 0, $first_pos_plus) . substr($str, $last_pos_plus + 1);
	}

	// вырезаем '<iframe>...</iframe>' и все что находится между ними
	do {
			$first_pos_iframe = strpos($str, '%3Ciframe');
			$last_pos_iframe = strpos($str, '/iframe%3E');

			if ($first_pos_iframe && $last_pos_iframe)
			{
				$doit = true;

				$str = substr($str, 0, $first_pos_iframe) . substr($str, $last_pos_iframe + 10);
			}
			else
			{
				$doit = false;
			}

	} while ($doit);

	return $str;
}

/******* Функция удаления запрещенных символов из данных передаваемых от пользователя **********/
function ClearDataFromRequest()
{ 
	foreach($_REQUEST as $reqKey => $reqValue)
	{
		// форсируем конвертацию $reqValue в тип string
		$reqValue = (string) $reqValue;
		// вырезаем пробелы вначале и вконце строки
		$reqValue = trim($reqValue);
		// вырезаем html-теги
		$reqValue = @strip_tags($reqValue);
		// вырезаем слеши
		$reqValue = stripslashes($reqValue);
		$reqValue = stripslashes($reqValue);
		// заменяем html-символы
		$reqValue = htmlspecialchars($reqValue);
		// вырезаем запрещенные символы
		$reqValue = CutForbiddenChars($reqValue);

		$_REQUEST[$reqKey] = $reqValue;
	}
} 

/******* Функция удаления очистки данных передаваемых из форм **********/
function ClearDataFromForm($data)
{ 
	// форсируем конвертацию $data в тип string
	$data = (string) $data;
	// вырезаем пробелы вначале и вконце строки
	$data = trim($data);
	// вырезаем html-теги
	$data = @strip_tags($data);
	// вырезаем слеши
	$data = stripslashes($data);
	$data = stripslashes($data);
	// заменяем html-символы
	$data = htmlspecialchars($data);
	// определяем массив запрещенных символов
	$forbidden_characters = array (
										"'" 		=> '',
										'"' 		=> '',
										"\\" 		=> '',
										"%00" 		=> '',
										"%0d" 		=> '',
										"%0a" 		=> '',
										"%22" 		=> '',
										"%27" 		=> '',
	                              );

	// вырезаем запрещенные символы
	$data = strtr($data, $forbidden_characters);

	return $data;
} 

/****** функция заменяет разрешенные для использования теги при записи данных в БД ********/
function UseHTMLTagsIn($data)
{
	// определяем массив зазаменяемых тегов
	$exch_characters = array (
										'<b>' 		=> '[b]',
										'</b>' 		=> '[/b]',
										'<i>' 		=> '[i]',
										'</i>' 		=> '[/i]',
										"\r\n" 		=> '[br /]'
	                         );

	// заменяем теги
	$data = strtr($data, $exch_characters);

	return $data;
}

/****** функция заменяет разрешенные для использования теги при получении данных из БД на страницу сайта ********/
function UseHTMLTagsOut($data)
{
	// определяем массив зазаменяемых тегов
	$exch_characters = array (
										'  ' 		=> '&nbsp;&nbsp;',
										'[b]' 		=> '<b>',
										'[/b]' 		=> '</b>',
										'[i]' 		=> '<i>',
										'[/i]' 		=> '</i>',
										'[br /]'	=> '<br />'
	                         );

	// заменяем теги
	$data = strtr($data, $exch_characters);

	return $data;
}

/****** функция заменяет разрешенные для использования теги при получении данных из БД в TextArea ********/
function UseHTMLTagsTextArea($data)
{
	// определяем массив зазаменяемых тегов
	$exch_characters = array (
										'[b]' 		=> '<b>',
										'[/b]' 		=> '</b>',
										'[i]' 		=> '<i>',
										'[/i]' 		=> '</i>',
										'[br /]'	=> "\r\n"
	                         );

	// заменяем теги
	$data = strtr($data, $exch_characters);

	return $data;
}

?>