<?php
/********************************************************
	powered by Script Developers Group (SD-Group)
	email: info@sd-group.org.ua
	url: http://sd-group.org.ua/
	Copyright 2009 (c) SD-Group
	All rights reserved
=========================================================
	Класс работы со строками
********************************************************/

class strings
{
	/////////////////////////////////////////////////
	// VARS - свойства класса strings
	/////////////////////////////////////////////////

	/////////////////////////////////////////////////
	// METHODS - методы класса strings
	/////////////////////////////////////////////////

	/**
	 * Функция получает путь и приводит его к правильному формату
	 *
	 * @param (string) $path - путь
	 * 
	 * @return (string) путь
	 */	
	static function setPath($path)
	{
		return rtrim($path, '/').'/';
	}

	/**
	* UTF-8 -> Windows 1251
	* Функция преобразования кодировки текста из UTF-8 в Windows 1251
	* 
	* @param (string) $str - текст для преобразования
	* 
	* @return (stirng)
	*/
	static function Utf8ToWin($str)
	{
		$out = '';
		$c1 = '';
		$byte2 = false;

		for ($c = 0; $c < strlen($str); $c++)
		{
			$i = ord($str[$c]);

			if (127 > $i)
			{
				$out .= $str[$c];
			}

			if ($byte2)
			{
				$new_c2 = ($c1 & 3) * 64 + ($i & 63);
				$new_c1 = ($c1 >> 2) & 5;
				$new_i = (int) $new_c1 * 256 + $new_c2;

				if (1025 === $new_i)
				{
					$out_i = 168;
				}
				elseif (1105 === $new_i)
				{
					$out_i = 184;
				}
				else
				{
					$out_i = $new_i - 848;
				}

				$out .= chr($out_i);
				$byte2 = false;
			}

			if (6 === ($i >> 5))
			{
				$c1 = $i;
				$byte2 = true;
			}
		}

		return $out;
	}

	// Преобразование Windows 1251 -> UTF-8
	/**
	* Windows 1251 -> UTF-8
	* Функция преобразования кодировки текста из Windows 1251 в UTF-8
	* 
	* @param (string) $str - текст для преобразования
	* 
	* @return (stirng)
	*/
	static function WinToUtf8($str)
	{ 
		$out = '';
		$other[1025] = 'Ё';
   		$other[1105] = 'ё';
   		$other[1028] = 'Є';
   		$other[1108] = 'є';
   		$other[1030] = 'I';
   		$other[1110] = 'i';
   		$other[1031] = 'Ї';
   		$other[1111] = 'ї';

		for ($i = 0; $i < strlen($str); $i++)
		{
      		if (192 < ord($str{$i}))
      		{
         		$out .= '&#' . (ord($str{$i}) + 848) . ';';
      		}
      		else
      		{
         		if (!array_search($str{$i}, $other))
         		{
            		$out .= $str{$i};
         		}
         		else
         		{
            		$out .= '&#' . array_search($str{$i}, $other) . ';';
         		}
      		}
   		}

   		return $out;
	}

	/**
	* функция выводит страницы [предыдущая] 1 2 3 4 … [следующая]
	* 
	* @param (int) $a - количество элементов в массиве
	* @param (int) $offset - смещение в массиве([$offset ... $offset+$q])
	* @param (int) $q - количество элементов на странице
	* @param (string) $path - текущая ссылка ("index.php?do=news&")
	* 
	* @return (string) $out
	*/
	static function generatePage($a, $offset, $q, $path)
	{ 
		$out = '';
		if ($a > $q) // если общее кол-во страниц больше отображаемых в данный момент, тогда формируем страницы
		{
			if($offset % $q)
			{
				$offset = $q;
			}

			/***** Левая часть строки *****/
			// [prev]
			if ($offset > 0)
			{
				$out .= '<a href="' . $path . 'offset=' . ($offset - $q) . '" class="pages">&lt;&lt; prev</a> &nbsp;&nbsp;';
			}
			else
			{
				$out .= '';
			}

			// digital links
			$k = $offset / $q;

			// не более 4 страниц слева
			$min = $k - 5;

			if ($min < 0)
			{
				$min = 0;
			}
			else
			{
				if ($min >= 1) // ссылка 1-ой страницы
				{
					$out .= '<a href="' . $path . 'offset=0" class="pages">1</a> &nbsp;&nbsp;';

					if ($min != 1)
					{
						 $out .= '... &nbsp;';
					}
				}
			}

			for ($i = $min; $i < $k; $i++)
			{
				$m = $i * $q + $q;

				if ($m > $a)
				{
					$m = $a;
				}

				$out .= '<a href="' . $path . 'offset=' . ($i * $q) . '" class="pages">' . ($i + 1) . '</a> &nbsp;&nbsp;';
			}
			/*****************************************/

			/***** Текущая страница (центр строки) *****/
			if (strcmp($offset, 'show_all'))
			{
				$min = $offset + $q;
				if ($min > $a)
				{
					$min = $a;
				}

				$out .= '<b>' . ($k + 1) . '</b> &nbsp;&nbsp;';
			}
			else
			{
				$min = $q;
				if ($min > $a)
				{
					$min = $a;
				}

				$out .= '<a href="' . $path . 'offset=0" class="pages">1</a> &nbsp;&nbsp;';
			}
			/*****************************************/

			/***** Правая часть строки *****/
			// не более 5 странци справа
			$min = $k + 6;
			if ($min > $a / $q)
			{
				$min = $a/$q;
			}

			for ($i = $k + 1; $i < $min; $i++)
			{
				$m = $i * $q + $q;

				if ($m > $a)
				{
					$m = $a;
				}

				$out .= '<a href="' . $path . 'offset=' . ($i * $q) . '" class="pages">' . ($i + 1) . '</a> &nbsp;&nbsp;';
			}

			if ($min * $q < $a) // последняя ссылка
			{
				if ($min * $q < $a - $q)
				{
					$out .= ' ... &nbsp;&nbsp;';
				}

				$out .= '<a href="' . $path . 'offset=' . ($a - $a % $q) . '" class="pages">' . (floor($a / $q) + 1) . '</a> &nbsp;&nbsp;';
			}
			/*****************************************/

			//[next]
			if (strcmp($offset, 'show_all'))
			{
				if ($offset < $a - $q)
				{
					$out .= '<a href="' . $path . 'offset=' . ($offset + $q) . '" class="pages">next &gt;&gt;</a> ';
				}
				else
				{
					$out .= '';
				}
			}

			//[show all]
			/*
			if ($all)
			{
				if (strcmp($offset, 'show_all'))
				{
					$out .= ' |&nbsp; <a href="' . $path . 'offset=show_all">все</a>';
				}
				else
				{
					$out .= ' |&nbsp; <B>все</B>';
				}
			}
			*/
		}

		return $out;
	}

	/////////////////////////////////////////////////
	// END OF CLASS strings
	/////////////////////////////////////////////////
}

?>