<?php
/********************************************************
	powered by Script Developers Group (SD-Group)
	email: info@sd-group.org.ua
	url: http://sd-group.org.ua/
	Copyright 2009 (c) SD-Group
	All rights reserved
=========================================================
	Функции загрузки файлов
********************************************************/

// функция загрузки фото/логотипа
// $max_width - максимальная ширина файла
// $max_height - максимальная высота файла
// $type - тип лого/фото
function LoadFile($max_width, $max_height, $type) 
{
	$arrFileType = array ('image/jpeg', 'image/jpg', 'image/pjpeg', 'image/gif', 'image/png'); // массив допустимых типов
	$arrResult = array ( // возвращаемый массив по умолчанию
							'error'   => true,
							'message' => ERROR_MESSAGE_ERROR_LOAD_FILE
						);

	if (!@getimagesize($_FILES['photo_file']['tmp_name']))
	{
		$arrResult = array (
								'error'   => true,
								'message' => ERROR_MESSAGE_MIME_TYPE_LOAD_FILE
							);
		return $arrResult;
	}

	if (!in_array($_FILES['photo_file']['type'], $arrFileType)) // проверяем mime-type изображения
	{
		$arrResult = array (
								'error'   => true,
								'message' => ERROR_MESSAGE_MIME_TYPE_LOAD_FILE
							);
		return $arrResult;
	}
	
	$img_params = @getimagesize($_FILES['photo_file']['tmp_name']); // получаем параметры картинки (ширину, высоту)
	
	//определяем расширение изображения
	switch ($img_params[2])
	{
		case '1':
			$ext = 'gif';
			break;
		
		case '3':
			$ext = 'png';
			break;

		case '2':
		default:
			$ext = 'jpg';
			break;
	}

	$file_name = uniqid() . '.' . $ext; // генерируем уникальное имя файла

	if (@move_uploaded_file($_FILES['photo_file']['tmp_name'], 'uploads/' . $type . '/' . $file_name)) // перемещаем файл в нужную дирректорию
	{
        if ('photo' === $type)
        {
        	copy('uploads/' . $type . '/' . $file_name, 'uploads/' . $type . '/thumb_' . $file_name);
        	SetRightsToUploadedFile('uploads/' . $type . '/thumb_' . $file_name);
        	CreateImage('uploads/' . $type . '/thumb_' . $file_name, $max_width, $max_height, false, true);

        	// переменная определяет, изменять размер пропорционально
        	// или в точности с указанным в админке размером
        	// это нужно для того, чтобы логотипы загружались в соответствии
        	// с размером указанным в админке, а не пропорционально
        	$exact = false;
		}
		else
		{
			$exact = true;
		}
		
		SetRightsToUploadedFile('uploads/' . $type . '/' . $file_name);
		CreateImage('uploads/' . $type . '/' . $file_name, $max_width, $max_height, $exact, false);

		$arrResult = array (
								'error'     => false,
								'message'   => TEMPLATE_SERVICES_FILE_UPLOAD_SUCCESS,
								'file_name' => $file_name
							);
		return $arrResult;
	}

	return $arrResult;
}

// функция изменения размеров изображения
// $image = фото
// $max_width - максимальная ширина файла
// $max_height - максимальная высота файла
// $exact = точное соответствие указанным размерам
function CreateImage($image, $max_width, $max_height, $exact = false, $thumbs = false)
{
	if ($thumbs)
	{
		$max_width = 200;
		$max_height = 150;
	}
	
	$img_params = @getimagesize($image);

	//определяем тип изображения
	switch ($img_params[2])
	{
		case '1':
			$srcImage = ImageCreateFromGIF($image);
			break;
		
		case '3':
			$srcImage = ImageCreateFromPNG($image);
			break;

		case '2':
		default:
			$srcImage = ImageCreateFromJPEG($image);
			break;
	}

	$srcWidth  = ImageSX($srcImage); 
	$srcHeight = ImageSY($srcImage); 
        
	if(($max_width < $srcWidth) || ($max_height < $srcHeight) || $exact)
	{
		if($exact)
		{
			$destHeight = $max_height;
			$destWidth  = $max_width;
		}
		else
		{
			$ratioWidth  = $srcWidth/$max_width;
			$ratioHeight = $srcHeight/$max_height;

			if($ratioWidth < $ratioHeight)
			{
				$destWidth  = $srcWidth/$ratioHeight;
				$destHeight = $max_height;
			}
			else
			{
				$destWidth  = $max_width;
				$destHeight = $srcHeight/$ratioWidth;
			}
		}

		$resImage = ImageCreateTrueColor($destWidth, $destHeight);

		ImageCopyResampled($resImage, $srcImage, 0, 0, 0, 0, $destWidth, $destHeight, $srcWidth, $srcHeight);

		unlink($image);

		//определяем тип изображения
		switch ($img_params[2])
		{
			case '1':
				ImageGIF($resImage, $image);
				break;
			
			case '3':
				ImagePNG($resImage, $image);
				break;

			case '2':
			default:
				ImageJPEG($resImage, $image, 100);
				break;
		}

		ImageDestroy($srcImage); 
		ImageDestroy($resImage); 
	}
}

function SetRightsToUploadedFile($file_name)
{
	@chmod($file_name, 0666);
}

?>