<?php

class ps_robokassa extends shopPaymentSystem{

/* ========================================================================== */
/* ========================================================================== */

    /**
     * Получает всю информацию о заказе в массиве $order
     * и сохраняет внутри класса
     * @param array $order 
     */
    public function __construct($order, $config){

        parent::__construct();

        $this->order    = $order;
        $this->config   = $config;

    }

/* ========================================================================== */
/* ========================================================================== */

    /**
     * Генерирует и возвращает код формы для отправки в платежную систему
     */
    public function getHtmlForm($order, $currency){

        global $_LANG;

        $currency_kurs  = $this->config['currency'][$currency];
        $this->order['summ']  = round($this->order['summ']/$currency_kurs, 2);

        $signature = $this->config['sMerchantLogin']['value'] . ':' .
                     $this->order['summ'] . ':' .
                     $this->order['id'] . ':' .
                     $this->config['sMerchantPass1']['value'];

        $this->order['secret_key'] = md5($signature);

        ob_start();

        include('form.php');

        return ob_get_clean();

    }

/* ========================================================================== */
/* ========================================================================== */

    private function preRequest($model) {

        $inCore         = cmsCore::getInstance();

        $out_summ       = $inCore->request('OutSum', 'str');
        $out_id         = $inCore->request('InvId', 'int');
        $out_signature  = $inCore->request('SignatureValue', 'str');

        // Проверяем, не произошла ли подмена суммы
        $currency_kurs    = $this->config['currency']['RUR'];
        $currency_price   = ceil($this->order['summ']/$currency_kurs);

        if ($currency_price != $out_summ) { return "ERR1: НЕВЕРНАЯ СУММА ЗАКАЗА"; }

        // Проверяем, не произошла ли подмена номера заказа
        if ($this->order['id'] != $out_id) { return "ERR2: НЕВЕРНЫЙ НОМЕР ЗАКАЗА"; }

        // Проверяем сигнатуру
        $signature = $out_summ . ':' .
                     $this->order['id'] . ':' .
                     $this->config['sMerchantPass2']['value'];

        if(strtoupper(md5($signature)) != $out_signature){ return "ERR3: КОНТРОЛЬНЫЕ СУММЫ НЕ СОВПАЛИ"; }

        // Фиксируем оплату заказа
        $model->setOrderStatus($this->order['id'], $this->order['secret_key'], 1);

        return "OK{$out_id}";

    }

/* ========================================================================== */
/* ========================================================================== */

    public function processPayment($model) {
               
        return iconv('cp1251', 'utf-8', $this->preRequest($model));

    }

/* ========================================================================== */
/* ========================================================================== */

}

?>