<h1 class="con_heading">{$LANG.BILLING_CONVERT}</h1>

<form action="/billing/buy_convert" method="post">

    {if $cfg.r2p_enabled}
        <input type="hidden" id="r2p_kurs" value="{$cfg.r2p_kurs}" />
        <input type="hidden" id="r2p_all" value="{$rating}" />
    {/if}
    {if $cfg.p2r_enabled}
        <input type="hidden" id="p2r_kurs" value="{$cfg.p2r_kurs}" />
        <input type="hidden" id="p2r_all" value="{$points}" />
    {/if}

    <div class="billing_convert">

        <table cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td width="150" class="title">{$LANG.BILLING_CONVERT_MODE}:</td>
                <td>
                    <select name="mode" id="convert_mode" style="width:200px" onchange="toggleConvertMode()">
                        {if $cfg.r2p_enabled}<option value="r2p">{$LANG.BILLING_CONVERT_MODE_R2P}</option>{/if}
                        {if $cfg.p2r_enabled}<option value="p2r">{$LANG.BILLING_CONVERT_MODE_P2R}</option>{/if}
                    </select>
                </td>
            </tr>
        </table>
        <table cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td width="150" class="title">{$LANG.BILLING_CONVERT_MAX}:</td>
                <td>
                    <span class="r2p convert_unit">{$rating} {$LANG.BILLING_CONVERT_R}</span>
                    <span class="p2r convert_unit">{$points} {$LANG.BILLING_CONVERT_P}</span> 
                    <a class="convert_all" href="javascript:convertAll()">{$LANG.BILLING_CONVERT_ALL}</a>
                </td>
            </tr>
            <tr>
                <td width="150" class="title">{$LANG.BILLING_CONVERT_OUT}:</td>
                <td>
                    <input type="text" name="in" id="in" style="width:60px" onkeyup="calculate()" />
                    <span class="r2p convert_unit">{$LANG.BILLING_CONVERT_R}</span>
                    <span class="p2r convert_unit">{$LANG.BILLING_CONVERT_P}</span>
                </td>
            </tr>
            <tr>
                <td width="150" class="title">{$LANG.BILLING_CONVERT_IN}:</td>
                <td>
                    <span id="convert_out" name="out" style="font-weight:bold">0</span>
                    <span class="r2p convert_unit">{$LANG.BILLING_CONVERT_P}</span>
                    <span class="p2r convert_unit">{$LANG.BILLING_CONVERT_R}</span>
                </td>
            </tr>
        </table>

    </div>

    <p>
        <input type="submit" name="submit" value="{$LANG.BILLING_CONVERT_SUBMIT}" onclick="{literal}if($('#in').val()==''||$('#in').val()=='0'){ return false; }{/literal}" />
        <input type="button" name="cancel" value="{$LANG.CANCEL}" onclick="window.history.go(-1)" />
    </p>

</form>

<script type="text/javascript">
    {literal}
        function toggleConvertMode(){
            var mode = $('#convert_mode').val();
            $('.convert_unit').hide();
            $('.convert_unit').hide();            
            $('.'+mode).show();
            var i    = $('#in').val();
            var all  = $('#'+mode+'_all').val();
            if (i > all) { $('#in').val(all); }
            calculate();
        }

        function convertAll(){
            var mode = $('#convert_mode').val();
            var all  = $('#'+mode+'_all').val();
            $('#in').val(all);
            calculate();
        }

        function calculate(){
            var mode = $('#convert_mode').val();
            var kurs = $('#'+mode+'_kurs').val();
            var i    = $('#in').val();
            var o    = 0;

            if (isNaN(i) || i == ''){
                o = '0';
            } else {
                o = Math.floor(i / kurs);
            }

            $('#convert_out').html(o); return;

        }

        $(document).ready(function(){
           toggleConvertMode();
        });

    {/literal}
</script>