<?php
    if(!defined('VALID_CMS_ADMIN')) { die('ACCESS DENIED'); }

    $inCore->loadClass('billing');

    $inCore->loadModel('billing');
    $model = new cms_model_billing();

    $inDB = cmsDatabase::getInstance();

    $cfg = $model->getConfig();

    $opt = $inCore->request('opt', 'str', 'list_psys');

    $GLOBALS['cp_page_head'][] = '<script type="text/javascript" src="/admin/components/billing/js/common.js"></script>';
    $GLOBALS['cp_page_head'][] = '<link type="text/css" rel="stylesheet" href="/admin/components/billing/css/styles.css">';

    cpAddPathway('Биллинг пользователей', '?view=components&do=config&id='.$_REQUEST['id']);

//=================================================================================================//
//=================================================================================================//

	$toolmenu = array();

    echo '<h3>Биллинг пользователей</h3>';

    $toolmenu[0]['icon'] = 'bill_psys.gif';
    $toolmenu[0]['title'] = 'Платежные системы';
    $toolmenu[0]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=list_psys';

    $toolmenu[1]['icon'] = 'bill_prices.gif';
    $toolmenu[1]['title'] = 'Редактирование цен';
    $toolmenu[1]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=edit_prices';

    $toolmenu[2]['icon'] = 'bill_subs.gif';
    $toolmenu[2]['title'] = 'Подписки';
    $toolmenu[2]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=edit_subs';

    $toolmenu[3]['icon'] = 'bill_balance.gif';
    $toolmenu[3]['title'] = 'Пополнить баланс';
    $toolmenu[3]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=add_balance';

    $toolmenu[4]['icon'] = 'bill_log.gif';
    $toolmenu[4]['title'] = 'История операций';
    $toolmenu[4]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=history';

    $toolmenu[5]['icon'] = 'bill_out.gif';
    $toolmenu[5]['title'] = 'Заявки на вывод';
    $toolmenu[5]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=outs';

    $toolmenu[6]['icon'] = 'config.gif';
    $toolmenu[6]['title'] = 'Настройки';
    $toolmenu[6]['link'] = '?view=components&do=config&id='.$_REQUEST['id'].'&opt=config';

    cpToolMenu($toolmenu);

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'show_psys'){
		if (!isset($_REQUEST['item'])){
			if (isset($_REQUEST['item_id'])){
                dbShow('cms_billing_psys', $_REQUEST['item_id']);
            }
		} else {
			dbShowList('cms_billing_psys', $_REQUEST['item']);
		}
		echo '1'; exit;
	}

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'hide_psys'){
		if (!isset($_REQUEST['item'])){
			if (isset($_REQUEST['item_id'])){ dbHide('cms_billing_psys', $_REQUEST['item_id']);  }
		} else {
			dbHideList('cms_billing_psys', $_REQUEST['item']);
		}
		echo '1'; exit;
	}

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'move_psys'){

        $item_id = $inCore->request('item_id', 'int', 0);

        $dir     = $_REQUEST['dir'];
        $step    = 1;

        $model->movePaySys($item_id, $dir, $step);
        echo '1'; exit;

	}

//=================================================================================================//
//=================================================================================================//

    if ($opt == 'list_psys'){

        $component_id = (int)$_REQUEST['id'];

		cpAddPathway('Платежные системы', '?view=components&do=config&id='.$_REQUEST['id'].'&opt=list_items');

        $installed = $model->installPaymentSystems();

        if (is_array($installed)){
            echo '<p style="color:green">';
                echo '<strong>Были установлены платежные системы:</strong> ';
                foreach($installed as $num=>$system){
                    echo $system;
                    if ($num<sizeof($installed)-1){ echo ', '; }
                }
            echo '</p>';
        }

        $items = $model->getPaymentSystems(false);

        include($_SERVER['DOCUMENT_ROOT'].'/admin/components/billing/psys.tpl.php');

    }

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'config_psys'){

     $item_id = $inCore->request('item_id', 'int', 0);

     $mod = $model->getPaymentSystem($item_id);

     echo '<h3><span style="color:gray">Настройки:</span> '.$mod['title'].'</h3>';
     cpAddPathway('Платежные системы', '?view=components&do=config&id='.$_REQUEST['id'].'&opt=list_psys');
     cpAddPathway($mod['title'], '?view=components&do=config&id='.$_REQUEST['id'].'&opt=config_psys&item_id='.$mod['id']);

     $config = false;

?>
            <form id="addform" name="addform" method="post" action="index.php?view=components&do=config&id=<?php echo $_REQUEST['id'];?>">

                <?php if ($mod['config']['currency']){  ?>
                    <h3 style="margin-top:0px;font-weight:normal;font-size:16px">Курсы валют</h3>
                    <table width="260" border="0" cellspacing="5" class="proptable">
                        <?php foreach($mod['config']['currency'] as $currency=>$kurs) { ?>
                            <?php if ($currency) { ?>
                                <tr>
                                    <td width="100" align="right">
                                        <strong>1 <?php echo $currency; ?> = </strong>
                                    </td>
                                    <td>
                                        <input type="text" name="config[currency][<?php echo $currency; ?>]" value="<?php echo $kurs; ?>" style="width:60px"/> <?php echo htmlspecialchars($cfg['currency']); ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </table>
                <?php } ?>

                <?php if ($mod['config']){  ?>
                    <h3 style="font-weight:normal;font-size:16px">Настройки системы</h3>
                    <table width="700" border="0" cellspacing="5" class="proptable">
                        <?php foreach($mod['config'] as $param_id=>$param) { ?>
                            <?php if ($param['title']) { $confg = true; ?>
                                <tr>
                                    <td width="250">
                                        <strong><?php echo $param['title']; ?>:</strong>
                                        <input type="hidden" name="config[<?php echo $param_id; ?>][title]" value="<?php echo $param['title']; ?>" />
                                    </td>
                                    <td>
                                        <input type="text" name="config[<?php echo $param_id; ?>][value]" value="<?php echo htmlspecialchars($param['value']); ?>" style="width:98%"/>
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </table>
                <?php } ?>

                <?php if (!$confg){ ?>
                    <p style="margin-top:0px;margin-bottom:20px;">Платежная система не имеет настроек.</p>
                <?php } ?>

                <p>
                    <?php if ($confg){ ?>
                        <input name="add_mod" type="submit" id="add_mod" value="Сохранить изменения" />
                    <?php } ?>
                    <input name="back" type="button" id="back" value="Отмена" onclick="window.location.href='index.php?view=components&do=config&id=<?php echo $_REQUEST['id']; ?>&opt=list_psys';"/>
                    <input name="opt" type="hidden" id="do" value="save_psys_config" />
                    <input name="item_id" type="hidden" value="<?php echo $mod['id']; ?>" />
                </p>
            </form>
		 <?php
	}

//=================================================================================================//
//=================================================================================================//

    if ($opt == 'save_psys_config'){

        $item_id    = $inCore->request('item_id', 'int', 0);
        $config     = $inCore->request('config', 'array');

		$model->savePaymentSystemConfig($item_id, $config);

		$inCore->redirect('?view=components&do=config&opt=list_psys&id='.$_REQUEST['id']);

	}

//=================================================================================================//
//=================================================================================================//

	if($opt=='saveconfig'){

        $cfg['license_key']     = $inCore->request('license_key', 'str', '');

        $cfg['currency']        = $inCore->request('currency', 'str', 'руб.');
        $cfg['point_cost']      = str_replace(',', '.', $inCore->request('point_cost', 'str', 0));
        $cfg['packs_only']      = $inCore->request('packs_only', 'int', 0);
        $cfg['reg_bonus']       = $inCore->request('reg_bonus', 'int', 10);
        $cfg['subs_enabled']    = $inCore->request('subs_enabled', 'int', 1);
        $cfg['in_enabled']      = $inCore->request('in_enabled', 'int', 1);

        $cfg['r2p_enabled'] = $inCore->request('r2p_enabled', 'int', 0);
        $cfg['p2r_enabled'] = $inCore->request('p2r_enabled', 'int', 0);
        $cfg['r2p_kurs']    = $inCore->request('r2p_kurs', 'str', 1);
        $cfg['p2r_kurs']    = $inCore->request('p2r_kurs', 'str', 1);

        $cfg['ref_enabled'] = $inCore->request('ref_enabled', 'int', 0);
        $cfg['ref_bonus']   = $inCore->request('ref_bonus', 'int', 10);
        $cfg['ref_percent'] = $inCore->request('ref_percent', 'int', 10);
        $cfg['ref_ttl']     = $inCore->request('ref_ttl', 'int', 100);
        $cfg['ref_url']     = $inCore->request('ref_url', 'str', '/');

        $cfg['out_enabled'] = $inCore->request('out_enabled', 'int', 0);
        $cfg['out_period']  = $inCore->request('out_period', 'int', 0);
        $cfg['out_min']     = $inCore->request('out_min', 'int', 0);
        $cfg['out_kurs']    = $inCore->request('out_kurs', 'str', 0);
        $cfg['out_ps']      = $inCore->request('out_ps', 'html', 0);
        $cfg['out_email']   = $inCore->request('out_email', 'str', '');

        $cfg['tf_enabled']  = $inCore->request('tf_enabled', 'int', 0);
        $cfg['tf_confirm']  = $inCore->request('tf_confirm', 'int', 1);

        $dis_amount = $inCore->request('dis_amount', 'array');
        $dis_price  = $inCore->request('dis_price', 'array');

        $cfg['discount'] = array();

        if (is_array($dis_amount) && $dis_amount[0]){

            foreach($dis_amount as $num=>$amount){
                $amount = (int)$amount;
                $price  = (int)$dis_price[$num];
                $cfg['discount'][$amount] = $price;
            }

            ksort($cfg['discount']);

        }

        $inCore->saveComponentConfig('billing', $cfg);

        $msg = 'Настройки успешно сохранены';

        if( $inCore->request('clear_history', 'int', 0) ){
            $inDB->query("DELETE FROM cms_billing_log");
            $msg .= '<br/>' . 'История операций очищена';
        }

        $opt = 'config';

	}

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'config') {

		cpAddPathway('Настройки', $_SERVER['REQUEST_URI']);

        $GLOBALS['cp_page_head'][] = '<script type="text/javascript" src="/includes/jquery/tabs/jquery.ui.min.js"></script>';
        $GLOBALS['cp_page_head'][] = '<link href="/includes/jquery/tabs/tabs.css" rel="stylesheet" type="text/css" />';

        if ($msg){
            echo '<p style="color:green">'.$msg.'</p>';
        }

         ?>
 <form action="index.php?view=components&amp;do=config&amp;id=<?php echo $_REQUEST['id'];?>" method="post" name="optform" target="_self" id="form1">

    <div id="config_tabs" style="margin-top:12px;">

        <ul id="tabs">
            <li><a href="#general"><span>Пополнение</span></a></li>
            <li><a href="#discount"><span>Скидки / Пакеты</span></a></li>
            <li><a href="#subs"><span>Подписки</span></a></li>
            <li><a href="#convert"><span>Обмен</span></a></li>
            <li><a href="#refs"><span>Рефералы</span></a></li>
            <li><a href="#out"><span>Вывод</span></a></li>
            <li><a href="#transfer"><span>Переводы</span></a></li>
            <li><a href="#other"><span>Прочее</span></a></li>
        </ul>

        <div id="general">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="250" valign="top">
                        <strong <?php if (!$cfg['license_key']){ ?>style="color:red"<?php } ?>>Ключ лицензии биллинга: </strong><br/>
                        <span class="hinttext">
                            Необходим для работы компонента, уникален для домена
                        </span>
                    </td>
                    <td valign="top">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td><input name="license_key" type="text" id="license_key" value="<?php echo $cfg['license_key'];?>" style="width:240px"/></td>
                                <td style="padding-left:10px;"><a href="http://www.instantmaps.ru/shop/buy/billing.html" target="_blank">Купить ключ</a></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Расчетная валюта:</strong>
                    </td>
                    <td valign="top">
                        <input type="text" name="currency" value="<?php echo $cfg['currency']; ?>" style="width:60px" onkeyup="$('.curr_name').html($(this).val())"/>
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Стоимость 1 балла:</strong>
                    </td>
                    <td valign="top">
                        <input type="text" name="point_cost" value="<?php echo $cfg['point_cost']; ?>" style="width:60px" /> <span class="curr_name"><?php echo $cfg['currency']; ?></span>
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Начислять при регистрации:</strong><br/>
                        <span class="hinttext">
                            Стартовый баланс для новых<br/>пользователей
                        </span>
                    </td>
                    <td valign="top">
                        <input type="text" name="reg_bonus" value="<?php echo $cfg['reg_bonus']; ?>" style="width:60px" /> баллов
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Выбор количества баллов:</strong><br/>
                        <span class="hinttext">
                            при пополнении баланса
                        </span>
                    </td>
                    <td valign="top">
                        <select name="packs_only" style="width:185px">
                            <option value="0" <?php if (!$cfg['packs_only']) { ?>selected="selected"<?php } ?>>любое количество</option>
                            <option value="1" <?php if ($cfg['packs_only']) { ?>selected="selected"<?php } ?>>только пакетами</option>
                       </select>
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Пополнение баланса через<br/>платежные системы:</strong><br/>
                        <span class="hinttext">Можно отключить, если пополнение планируется вручную или только через обмен рейтинга</span>
                    </td>
                    <td valign="top">
                        <input name="in_enabled" type="radio" value="1" <?php if (@$cfg['in_enabled']) { echo 'checked="checked"'; } ?>/> Разрешить
                        <input name="in_enabled" type="radio" value="0" <?php if (@!$cfg['in_enabled']) { echo 'checked="checked"'; } ?>/> Запретить
                    </td>
                </tr>
            </table>
        </div>

        <div id="discount">

            <table border="0" cellpadding="5" cellspacing="0" id="discounts">
                <tr>
                    <th width="160">Количество баллов, от</th>
                    <th width="160">Цена за балл, <span class="curr_name"><?php echo $cfg['currency']; ?></span></th>
                    <th width="17" class="dis_del">&nbsp;</th>
                </tr>
                <?php if (!$cfg['discount']){ ?>
                <tr class="var">
                    <td><input type="text" class="dis_amount"  name="dis_amount[]" style="width:80px" /></td>
                    <td><input type="text" class="dis_price"  name="dis_price[]" style="width:80px" /></td>
                    <td width="17" class="char_del">
                        <a href="javascript:" onclick="deleteDiscount(this)" title="Удалить скидку">
                            <img src="/admin/images/actions/delete.gif" alt="Удалить скидку" border="0">
                        </a>
                    </td>
                </tr>
                <?php } else { ?>
                    <?php foreach($cfg['discount'] as $amount=>$price){?>
                         <tr class="var">
                            <td><input type="text" class="dis_amount" name="dis_amount[]" style="width:80px" value="<?php echo $amount; ?>" /></td>
                            <td><input type="text" class="dis_price" name="dis_price[]" style="width:80px" value="<?php echo $price; ?>" /></td>
                            <td width="17" class="char_del">
                                <a href="javascript:" onclick="deleteDiscount(this)" title="Удалить скидку">
                                    <img src="/admin/images/actions/delete.gif" alt="Удалить скидку" border="0">
                                </a>
                            </td>
                        </tr>
                    <?php } ?>
                <?php } ?>
            </table>

            <script type="text/javascript">
                updateDiscounts();
            </script>

            <div style="margin:15px 0; margin-left:17px;" class="add_discount">
                <a href="javascript:addDiscount()">Добавить скидку (пакет)</a>
            </div>

        </div>

        <div id="subs">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="260">
                        <strong>Разрешить подписки:</strong><br/>
                        <span class="hinttext">Подписки позволяют пользователям временно переходить в другие группы</span>
                    </td>
                    <td valign="top">
                        <input name="subs_enabled" type="radio" value="1" <?php if (@$cfg['subs_enabled']) { echo 'checked="checked"'; } ?>/> Разрешить
                        <input name="subs_enabled" type="radio" value="0" <?php if (@!$cfg['subs_enabled']) { echo 'checked="checked"'; } ?>/> Запретить
                    </td>
                </tr>
                <tr>
                    <td width="260">
                        <strong>Стоимость и сроки:</strong>
                    </td>
                    <td valign="top">
                        <span class="hinttext">
                            Настраивается в разделе "<a href="/admin/index.php?view=components&do=config&link=billing&opt=edit_subs">Подписки</a>"<br/>
                            Не забудьте сохранить настройки здесь, перед переходом в раздел подписок!
                        </span>
                    </td>
                </tr>
            </table>
        </div>

        <div id="convert">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="16">
                        <input id="r2p_enabled" name="r2p_enabled" type="checkbox" value="1" <?php if (@$cfg['r2p_enabled']) { echo 'checked="checked"'; } ?>/>
                    </td>
                    <td>
                        <label for="r2p_enabled">
                            <strong>Разрешить обмен рейтинга на баллы</strong>
                        </label>
                    </td>
                </tr>
                <tr>
                    <td>
                       &nbsp;
                    </td>
                    <td valign="top">
                        1 балл = <input type="text" name="r2p_kurs" style="width:50px" value="<?php echo $cfg['r2p_kurs']; ?>" /> ед. рейтинга
                    </td>
                </tr>
                <tr>
                    <td width="16">
                        <input id="p2r_enabled" name="p2r_enabled" type="checkbox" value="1" <?php if (@$cfg['p2r_enabled']) { echo 'checked="checked"'; } ?>/>
                    </td>
                    <td>
                        <label for="p2r_enabled">
                            <strong>Разрешить обмен баллов на рейтинг</strong>
                        </label>
                    </td>
                </tr>
                <tr>
                    <td>
                       &nbsp;
                    </td>
                    <td valign="top">
                        1 ед. рейтинга = <input type="text" name="p2r_kurs" style="width:50px" value="<?php echo $cfg['p2r_kurs']; ?>" /> баллов
                    </td>
                </tr>
            </table>
        </div>

        <div id="refs">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="260">
                        <strong>Реферальная система:</strong><br/>
                        <span class="hinttext">Позволяет пользователям получать доход за приглашенных ими новых пользователей</span>
                    </td>
                    <td valign="top">
                        <input name="ref_enabled" type="radio" value="1" <?php if (@$cfg['ref_enabled']) { echo 'checked="checked"'; } ?>/> Включена
                        <input name="ref_enabled" type="radio" value="0" <?php if (@!$cfg['ref_enabled']) { echo 'checked="checked"'; } ?>/> Отключена
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Вознаграждение за реферала:</strong><br/>
                        <span class="hinttext">Выдается единоразово при регистрации реферала</span>
                    </td>
                    <td valign="top">
                        <input type="text" name="ref_bonus" style="width:50px" value="<?php echo $cfg['ref_bonus']; ?>" /> баллов
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Реферальный процент:</strong><br/>
                        <span class="hinttext">Отчисляется при каждом пополнении баланса реферала</span>
                    </td>
                    <td valign="top">
                        <input type="text" name="ref_percent" style="width:50px" value="<?php echo $cfg['ref_percent']; ?>" /> %
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Время жизни реферальной куки:</strong><br/>
                        <span class="hinttext">Определяет сколько дней сайт будет помнить кто привел реферала</span>
                    </td>
                    <td valign="top">
                        <input type="text" name="ref_ttl" style="width:50px" value="<?php echo $cfg['ref_ttl']; ?>" /> дней
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Редирект реферала:</strong><br/>
                        <span class="hinttext">
                            URL страницы, на которую реферал<br/>
                            попадет после захода по реферальной<br/>
                            ссылке и установке куки
                        </span>
                    </td>
                    <td valign="top">
                        <input type="text" name="ref_url" style="width:200px" value="<?php echo $cfg['ref_url']; ?>" />
                        <div style="padding-top:5px">
                            <span class="hinttext">
                                <strong style="color:gray">/</strong> &mdash; главная страница<br/>
                                <strong style="color:gray">/registration</strong> &mdash; регистрация
                            </span>
                        </div>
                    </td>
                </tr>
            </table>

        </div>

        <div id="out">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="260">
                        <strong>Разрешить вывод баллов:</strong><br/>
                        <span class="hinttext">Пользователи смогут подавать<br/>заявки на вывод баллов</span>
                    </td>
                    <td valign="top">
                        <input name="out_enabled" type="radio" value="1" <?php if (@$cfg['out_enabled']) { echo 'checked="checked"'; } ?>/> Разрешить
                        <input name="out_enabled" type="radio" value="0" <?php if (@!$cfg['out_enabled']) { echo 'checked="checked"'; } ?>/> Запретить
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Период вывода:</strong>
                    </td>
                    <td valign="top">
                        <select name="out_period" style="width:212px">
                            <option value="0" <?php if (!$cfg['out_period']) { ?>selected="selected"<?php } ?>>не ограничено</option>
                            <option value="1" <?php if ($cfg['out_period']==1) { ?>selected="selected"<?php } ?>>раз в сутки</option>
                            <option value="7" <?php if ($cfg['out_period']==7) { ?>selected="selected"<?php } ?>>раз в неделю</option>
                            <option value="30" <?php if ($cfg['out_period']==30) { ?>selected="selected"<?php } ?>>раз в месяц</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Минимальная сумма для вывода:</strong>
                    </td>
                    <td valign="top">
                        <input type="text" name="out_min" style="width:50px" value="<?php echo $cfg['out_min']; ?>" /> баллов
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Стоимость 1 балла при выводе:</strong>
                    </td>
                    <td valign="top">
                        <input type="text" name="out_kurs" style="width:50px" value="<?php echo $cfg['out_kurs']; ?>" /> <span class="curr_name"><?php echo $cfg['currency']; ?></span>
                    </td>
                </tr>
                <tr>
                    <td valign="top">
                        <strong>Платежные системы для вывода:</strong><br/>
                        <span class="hinttext">
                            Пользователь сможет выбрать систему из списка.
                            Каждая система с новой строки.
                        </span>
                    </td>
                    <td valign="top">
                        <textarea name="out_ps" style="width:200px;height:60px"><?php echo $cfg['out_ps']; ?></textarea>
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>E-mail для уведомлений о заявках:</strong><br/>
                        <span class="hinttext">
                            Оставьте пустым, если вы не хотите получать уведомления о новых<br/>заявках на вывод
                        </span>
                    </td>
                    <td valign="top">
                        <input type="text" name="out_email" style="width:204px" value="<?php echo $cfg['out_email']; ?>" />
                    </td>
                </tr>
            </table>
        </div>

        <div id="transfer">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                <tr>
                    <td width="260">
                        <strong>Переводы между пользователями:</strong><br/>
                        <span class="hinttext">Пользователи смогут переводить<br/>баллы между собой</span>
                    </td>
                    <td valign="top">
                        <input name="tf_enabled" type="radio" value="1" <?php if (@$cfg['tf_enabled']) { echo 'checked="checked"'; } ?>/> Разрешить
                        <input name="tf_enabled" type="radio" value="0" <?php if (@!$cfg['tf_enabled']) { echo 'checked="checked"'; } ?>/> Запретить
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Подтверждение по e-mail:</strong><br/>
                        <span class="hinttext">Пользователь должен будет перейти по ссылке из полученного письма, чтобы совершить перевод</span>
                    </td>
                    <td valign="top">
                        <input name="tf_confirm" type="radio" value="1" <?php if (@$cfg['tf_confirm']) { echo 'checked="checked"'; } ?>/> Да
                        <input name="tf_confirm" type="radio" value="0" <?php if (@!$cfg['tf_confirm']) { echo 'checked="checked"'; } ?>/> Нет
                    </td>
                </tr>
            </table>
        </div>

        <div id="other">
            <table width="" border="0" cellpadding="5" cellspacing="0" class="proptable" style="border:none">
                    <tr>
                        <td width="260">
                            <label for="clear_history"><strong>Очистить историю всех операций: </strong></label>
                        </td>
                        <td>
                            <input type="checkbox" id="clear_history" name="clear_history" value="1" />
                        </td>
                    </tr>
            </table>
        </div>

    </div>

    <p>
        <input name="opt" type="hidden" value="saveconfig" />
        <input name="save" type="submit" id="save" value="Сохранить" />
        <input name="back" type="button" id="back" value="Отмена" onclick="window.location.href='index.php?view=components';"/>
    </p>

</form>

<script type="text/javascript">$('#config_tabs > ul#tabs').tabs();</script>

<?php }
//=================================================================================================//
//=================================================================================================//

    if ($opt == 'saveprices'){

        $titles         = $inCore->request('title', 'array');
        $point_costs    = $inCore->request('point_cost', 'array');

        foreach ($titles as $action_id=>$title){
            $point_cost = $inCore->arrayToYaml($point_costs[$action_id]);
            cmsBilling::updateAction($action_id, array(
                'title'=>$inDB->escape_string($title),
                'point_cost'=>$inDB->escape_string($point_cost)
            ));
        }

        $inCore->redirectBack();

    }

	if ($opt == 'edit_prices') {

		cpAddPathway('Редактирование цен', $_SERVER['REQUEST_URI']);

        $GLOBALS['cp_page_head'][] = '<script type="text/javascript" src="/includes/jquery/tabs/jquery.ui.min.js"></script>';
        $GLOBALS['cp_page_head'][] = '<link href="/includes/jquery/tabs/tabs.css" rel="stylesheet" type="text/css" />';

        $actions = cmsBilling::getActions();

        if (!$actions) { echo 'Нет действий, поддерживающих оплату'; }

        $groups = cmsUser::getGroups(true);

        $components = array();

    ?>

<h3>Редактирование цен</h3>

 <form action="index.php?view=components&amp;do=config&amp;id=<?php echo $_REQUEST['id'];?>" method="post" name="optform" target="_self" id="form1">

    <div id="config_tabs" style="margin-top:12px;">

        <ul id="tabs">
            <?php foreach($actions as $component=>$action) { ?>
                <li><a href="#<?php echo $component; ?>"><span><?php echo $action[0]['component_name']; ?></span></a></li>
            <?php $components[] = $component; } ?>
        </ul>

        <?php foreach($components as $component) { ?>
        <div id="<?php echo $component; ?>">
            <table cellpadding="5" cellspacing="0" border="0" class="prices_table">
                <tr>
                    <th rowspan="2" class="th_action">Действие / услуга</th>
                    <th colspan="<?php echo sizeof($groups); ?>">Стоимость для групп, в баллах</th>
                </tr>
                <tr>
                    <?php foreach($groups as $group){ ?>
                        <th class="th_group"><?php echo $group['title']; ?></th>
                    <?php } ?>
                </tr>
                <?php foreach($actions[$component] as $action) { ?>
                <?php $point_cost = $inCore->yamlToArray($action['point_cost']); ?>
                    <tr>
                        <td class="td_action">
                            <input type="text" class="action_title" value="<?php echo $action['title']; ?>" name="title[<?php echo $action['id']; ?>]" />
                        </td>
                        <?php foreach($groups as $group){ ?>
                            <td class="td_group">
                                <input type="text" class="price_input" name="point_cost[<?php echo $action['id']; ?>][<?php echo $group['id']; ?>]" value="<?php echo (int)$point_cost[$group['id']]; ?>" />
                            </td>
                        <?php } ?>
                    </tr>
                <?php } ?>
            </table>
        </div>
        <?php } ?>

    </div>

    <p style="padding:5px">
        <span class="hinttext">
            Можно указывать отрицательные суммы.<br/>
            В этом случае пользователи будут получать вознаграждения, вместо списаний.
        </span>
    </p>

    <p>
        <input name="opt" type="hidden" value="saveprices" />
        <input name="save" type="submit" id="save" value="Сохранить" />
        <input name="back" type="button" id="back" value="Отмена" onclick="window.location.href='index.php?view=components';"/>
    </p>

</form>

<script type="text/javascript">$('#config_tabs > ul#tabs').tabs();</script>

<?php }

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'add_balance') {

		cpAddPathway('Пополнить баланс', $_SERVER['REQUEST_URI']);

        $GLOBALS['cp_page_head'][] = '<script type="text/javascript" src="/includes/jquery/tabs/jquery.ui.min.js"></script>';
        $GLOBALS['cp_page_head'][] = '<link href="/includes/jquery/tabs/tabs.css" rel="stylesheet" type="text/css" />';

        $target     = $inCore->request('target', 'str', 'user');
        $user_id    = $inCore->request('user_id', 'int', 0);
        $group_id   = $inCore->request('group_id', 'int', 0);
        $amount     = $inCore->request('amount', 'int', 0);
        $with_ref   = $inCore->request('in_ref', 'int', 0);
        $is_percent = $inCore->request('is_percent', 'int', 0);

        $to_id      = $inCore->request('to_id', 'int', 0);

        $comment    = $inCore->request('comment', 'str', '');
        if (!$comment){ $comment = $amount>0 ? 'Пополнение' : 'Списание'; }

        $units      = $is_percent ? '%' : 'баллов';

        if ($target=='user' && $amount){

            $user = $inDB->get_fields('cms_users', "id='{$user_id}'", 'nickname, login');

            if ($amount > 0){
                cmsBilling::income($user_id, $amount, $comment, $is_percent, $with_ref, $cfg);
                $msg = 'Баланс пользователя <strong>'.$user['nickname'].'</strong> пополнен на <strong>'.$amount.' '.$units.'</strong>';
            }

            if ($amount < 0){
                cmsBilling::pay($user_id, abs($amount), $comment, $is_percent);
                $msg = 'Баланс пользователя <strong>'.$user['nickname'].'</strong> уменьшен на <strong>'.abs($amount).' '.$units.'</strong>';
            }

            if ($inCore->inRequest('back_to_profile')) {
                $inCore->redirect(cmsUser::getProfileURL($user['login']).'#upr_p_balance');
            }

        }

        if ($target=='group' && $amount){

            $group  = $inDB->get_fields('cms_user_groups', "id='{$group_id}'", 'title');

            cmsBilling::incomeGroup($group_id, $amount, $comment, $is_percent, $with_ref, $cfg);

            if ($amount > 0){
                $msg = 'Баланс группы <strong>'.$group['title'].'</strong> пополнен на <strong>'.$amount.' '.$units.'</strong>';
            } else {
                $msg = 'Баланс группы <strong>'.$group['title'].'</strong> уменьшен на <strong>'.abs($amount).' '.$units.'</strong>';
            }

        }

        if ($msg){
            echo '<p style="color:green">'.$msg.'</p>';
        }

        $groups = cmsUser::getGroups(true);
        $users  = cmsUser::getAllUsers();

    ?>

<h3>Пополнить баланс</h3>

    <div id="config_tabs" style="margin-top:12px;">

        <ul id="tabs">
            <li><a href="#user"><span>Пользователь</span></a></li>
            <li><a href="#group"><span>Группа</span></a></li>
        </ul>

        <div id="user">

            <form action="index.php?view=components&amp;do=config&amp;id=<?php echo $_REQUEST['id'];?>" method="post">
                <input type="hidden" name="target" value="user" />
                <table cellpadding="4" cellspacing="0" border="0" class="add_bal_table">
                    <tr>
                        <td width="120">
                            <strong>Пользователь:</strong>
                        </td>
                        <td>
                            <select name="user_id" style="width:255px">
                                <?php foreach($users as $user){ ?>
                                    <option value="<?php echo $user['id']; ?>" <?php if($to_id == $user['id']) { ?>selected="selected"<?php } ?>><?php echo $user['nickname']; ?> &lt;<?php echo $user['login']; ?>&gt; - <?php echo $user['balance']; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>Баллы:</strong>
                        </td>
                        <td>
                            <input type="text" name="amount" value="10" style="width:60px" />
                            <select name="is_percent" style="width:50px">
                                <option value="0" <?php if(!$is_percent) { ?>selected="selected"<?php } ?>>ед.</option>
                                <option value="1" <?php if($is_percent) { ?>selected="selected"<?php } ?>>%</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>Комментарий:</strong><br/>
                            <span class="hinttext">не обязательно</span>
                        </td>
                        <td>
                            <input type="text" name="comment" value="" style="width:250px" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                        <td>
                            <label>
                                <input type="checkbox" name="in_ref" checked="checked" value="1" />
                                Начислить реферальный процент пригласившему
                            </label><br/>
                            <label>
                                <input type="checkbox" name="back_to_profile" <?php if ($to_id){ ?>checked="checked"<?php } ?> value="1" />
                                Перейти в профиль после пополнения
                            </label>
                        </td>
                    </tr>
                </table>

                <p>
                    <span class="hinttext">Если вы хотите <strong>уменьшить</strong> баланс пользователя, то укажите отрицательное число</span>
                </p>

                <p>
                    <input name="opt" type="hidden" value="add_balance" />
                    <input name="submit" type="submit" id="save" value="Пополнить" />
                    <input name="back" type="button" id="back" value="Отмена" onclick="window.location.href='index.php?view=components';"/>
                </p>

            </form>

        </div>

        <div id="group">

            <form action="index.php?view=components&amp;do=config&amp;id=<?php echo $_REQUEST['id'];?>" method="post">
                <input type="hidden" name="target" value="group" />
                <table cellpadding="4" cellspacing="0" border="0" class="add_bal_table">
                    <tr>
                        <td width="120">
                            <strong>Группа:</strong>
                        </td>
                        <td>
                            <select name="group_id" style="width:255px">
                                <option value="0">Все</option>
                                <?php foreach($groups as $group){ ?>
                                    <option value="<?php echo $group['id']; ?>"><?php echo $group['title']; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>Баллы:</strong>
                        </td>
                        <td>
                            <input type="text" name="amount" value="10" style="width:60px" />
                            <select name="is_percent" style="width:50px">
                                <option value="0" <?php if(!$is_percent) { ?>selected="selected"<?php } ?>>ед.</option>
                                <option value="1" <?php if($is_percent) { ?>selected="selected"<?php } ?>>%</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>Комментарий:</strong><br/>
                            <span class="hinttext">не обязательно</span>
                        </td>
                        <td>
                            <input type="text" name="comment" value="" style="width:250px" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                        <td>
                            <label>
                                <input type="checkbox" name="in_ref" checked="checked" value="1" />
                                Начислить реферальный процент пригласившему
                            </label>
                        </td>
                    </tr>
                </table>

                <p>
                    <span class="hinttext">Если вы хотите <strong>уменьшить</strong> баланс группы, то укажите отрицательное число</span>
                </p>

                <p>
                    <input name="opt" type="hidden" value="add_balance" />
                    <input name="submit" type="submit" id="save" value="Пополнить" />
                    <input name="back" type="button" id="back" value="Отмена" onclick="window.location.href='index.php?view=components';"/>
                </p>
            </form>

        </div>

    </div>

<script type="text/javascript">$('#config_tabs > ul#tabs').tabs();</script>

<?php }

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'history') {

        cpAddPathway('История операций', $_SERVER['REQUEST_URI']);

        $users  = cmsUser::getAllUsers();

        $page       = $inCore->request('page', 'int', 1);
        $perpage    = 15;

        $date_start = $inCore->request('date_start', 'str', date('Y-m-d', time()-3600*24*7));
        $date_end   = $inCore->request('date_end', 'str', date('Y-m-d'));
        $user_id    = $inCore->request('user_id', 'int', 0);

        if (isset($_REQUEST['op_type'])){
            $op_type    = $_REQUEST['op_type'];
            if ($op_type !== 'any') { $op_type = (int)$op_type; }
        } else {
            $op_type = 'any';
        }

        $op_count = cmsBilling::getOperationsCount($date_start, $date_end, $user_id, $op_type);

        if ($op_count) {

            $ops = cmsBilling::getOperations($page, $date_start, $date_end, $user_id, $op_type);

            $base_url = "/admin/index.php?view=components&do=config&id={$_REQUEST['id']}&opt=history";
            $url      = "/admin/index.php?view=components&do=config&id={$_REQUEST['id']}&opt=history&date_start=%date_start%&date_end=%date_end%&op_type=%op_type%&user_id=%user_id%&page=%page%";

            $pagebar = cmsPage::getPagebar($op_count, $page, $perpage, $url, array(
               'date_start' => $date_start,
               'date_end' => $date_end,
               'user_id' => $user_id,
               'op_type' => $op_type
            ));

        }

    ?>

<h3>История операций</h3>

<form action="<?php echo $base_url; ?>" method="post">
    <table cellpadding="5" cellspacing="0" border="0" id="filterpanel" class="toolmenu" width="100%" style="margin-bottom:0px">
        <tr>
            <td width="50">Период:</td>
            <td width="100"><input type="text" name="date_start" id="date_start" value="<?php echo $date_start; ?>" style="width:100px"/></td>
            <td width="10">&mdash;</td>
            <td width="100"><input type="text" name="date_end" id="date_end" value="<?php echo $date_end; ?>" style="width:100px"/></td>
            <td width="65">Операции:</td>
            <td width="150">
                <select name="op_type" style="width:150px">
                    <option value="any" <?php if ($op_type==='any'){ ?>selected="selected"<?php } ?>>Любые</option>
                    <option value="<?php echo OP_TYPE_INCOME; ?>" <?php if ($op_type===OP_TYPE_INCOME){ ?>selected="selected"<?php } ?>>Пополнения</option>
                    <option value="<?php echo OP_TYPE_PAY; ?>" <?php if ($op_type===OP_TYPE_PAY){ ?>selected="selected"<?php } ?>>Списания</option>
                </select>
            </td>
            <td width="85">Пользователь:</td>
            <td width="210">
                <select name="user_id" style="width:210px">
                    <option value="0" <?php if ($user_id==0){ ?>selected="selected"<?php } ?>>Любой</option>
                    <?php foreach($users as $u){ ?>
                        <option value="<?php echo $u['id']; ?>" <?php if ($user_id==$u['id']){ ?>selected="selected"<?php } ?>><?php echo $u['nickname']; ?> &lt;<?php echo $u['login']; ?>&gt;</option>
                    <?php } ?>
                </select>
            </td>
            <td>
                <input type="submit" name="submit" value="Показать" />
            </td>
        </tr>
    </table>
</form>

<?php if ($op_count==0){ ?>
    <p>Операции не найдены</p>
<?php } else { ?>

    <table border="0" cellpadding="5" cellspacing="0" width="100%" id="listTable" class="tablesorter">
        <thead>
            <tr>
                <th class="lt_header" width="140">Дата операции</th>
                <th class="lt_header" width="150">Пользователь</th>
                <th class="lt_header" width="100">Тип операции</th>
                <th class="lt_header" width="">Комментарий</th>
                <th class="lt_header" width="70">Баллы</th>
                <th class="lt_header" width="70">Стоимость</th>
                <th class="lt_header" width="16">&nbsp;</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($ops as $op) { ?>
            <tr>
                <td height="20"><?php echo $op['op_date']; ?></td>
                <td><a href="<?php echo cmsUser::getProfileURL($op['user_login']); ?>" target="_blank"><?php echo $op['user']; ?></a></td>
                <td>
                    <?php if ($op['op_type']==OP_TYPE_INCOME){ ?>
                        <span class="b_plus"><?php echo $op['op_type_name']; ?></span>
                    <?php } else { ?>
                        <span class="b_minus"><?php echo $op['op_type_name']; ?></span>
                    <?php } ?>
                </td>
                <td><?php echo $op['comment'] ? $op['comment'] : '<span style="color:silver">&mdash;</span>'; ?></td>
                <td>
                    <?php if ($op['op_type']==OP_TYPE_INCOME){ ?>
                        <span class="b_plus">+<?php echo $op['amount']; ?></span>
                    <?php } else { ?>
                        <span class="b_minus">-<?php echo $op['amount']; ?></span>
                    <?php } ?>
                </td>
                <td><?php echo $op['summ'] ? $op['summ'].' '.$cfg['currency'] : '<span style="color:silver">&mdash;</span>'; ?></td>
                <td>
                    <a href="/billing/delete_op/<?php echo $op['id']; ?>" title="Отменить" onclick="if(!confirm('Отменить операцию?')){return false;}">
                        <img src="/templates/_default_/images/icons/delete.png" border="0" />
                    </a>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <?php if ($pagebar) { ?>
        <p><?php echo $pagebar; ?></p>
    <?php } ?>

    <script type="text/javascript">highlightTableRows("listTable","hoverRow","clickedRow");</script>

<?php }

    }

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'outs') {

        cpAddPathway('Заявки на вывод', $_SERVER['REQUEST_URI']);

        $users  = cmsUser::getAllUsers();

        $page       = $inCore->request('page', 'int', 1);
        $perpage    = 15;

        $date_start = $inCore->request('date_start', 'str', date('Y-m-d', time()-3600*24*7));
        $date_end   = $inCore->request('date_end', 'str', date('Y-m-d'));
        $user_id    = $inCore->request('user_id', 'int', 0);

        if (isset($_REQUEST['status'])){
            $status    = $_REQUEST['status'];
            if ($status !== 'any') { $status = (int)$status; }
        } else {
            $status = 'any';
        }

        $op_count = cmsBilling::getOutsCount($date_start, $date_end, $user_id, $status);

        if ($op_count) {

            $ops = cmsBilling::getOuts($page, $date_start, $date_end, $user_id, $status);

            $base_url = "/admin/index.php?view=components&do=config&id={$_REQUEST['id']}&opt=outs";
            $url      = "/admin/index.php?view=components&do=config&id={$_REQUEST['id']}&opt=outs&date_start=%date_start%&date_end=%date_end%&status=%status%&user_id=%user_id%&page=%page%";

            $pagebar = cmsPage::getPagebar($op_count, $page, $perpage, $url, array(
               'date_start' => $date_start,
               'date_end' => $date_end,
               'user_id' => $user_id,
               'status' => $status
            ));

        }

        $statuses = array(
            BILL_OUT_STATUS_WAIT => 'Ожидает подтверждения',
            BILL_OUT_STATUS_WORK => 'В обработке',
            BILL_OUT_STATUS_DONE => 'Выполнена'
        );

        $status_colors = array(
            BILL_OUT_STATUS_WAIT => '#5F98BF',
            BILL_OUT_STATUS_WORK => '#870C0A',
            BILL_OUT_STATUS_DONE => '#086D0A'
        );

    ?>

<h3>Заявки на вывод средств</h3>

<form action="<?php echo $base_url; ?>" method="post">
    <table cellpadding="5" cellspacing="0" border="0" id="filterpanel" class="toolmenu" width="100%" style="margin-bottom:0px">
        <tr>
            <td width="50">Период:</td>
            <td width="100"><input type="text" name="date_start" id="date_start" value="<?php echo $date_start; ?>" style="width:100px"/></td>
            <td width="10">&mdash;</td>
            <td width="100"><input type="text" name="date_end" id="date_end" value="<?php echo $date_end; ?>" style="width:100px"/></td>
            <td width="65">Статус:</td>
            <td width="150">
                <select name="status" style="width:150px">
                    <option value="any" <?php if ($status==='any'){ ?>selected="selected"<?php } ?>>Любой</option>
                    <?php foreach($statuses as $s_code=>$title) { ?>
                        <option value="<?php echo $s_code; ?>" <?php if ($status===$s_code){ ?>selected="selected"<?php } ?>><?php echo $title; ?></option>
                    <?php } ?>
                </select>
            </td>
            <td width="85">Пользователь:</td>
            <td width="210">
                <select name="user_id" style="width:210px">
                    <option value="0" <?php if ($user_id==0){ ?>selected="selected"<?php } ?>>Любой</option>
                    <?php foreach($users as $u){ ?>
                        <option value="<?php echo $u['id']; ?>" <?php if ($user_id==$u['id']){ ?>selected="selected"<?php } ?>><?php echo $u['nickname']; ?> &lt;<?php echo $u['login']; ?>&gt;</option>
                    <?php } ?>
                </select>
            </td>
            <td>
                <input type="submit" name="submit" value="Показать" />
            </td>
        </tr>
    </table>
</form>

<?php if ($op_count==0){ ?>
    <p>Операции не найдены</p>
<?php } else { ?>

    <table border="0" cellpadding="5" cellspacing="0" width="100%" id="listTable" class="tablesorter">
        <thead>
            <tr>
                <th class="lt_header" width="85">Дата заявки</th>
                <th class="lt_header" width="130">Пользователь</th>
                <th class="lt_header" width="130">Статус</th>
                <th class="lt_header" width="">№ счета</th>
                <th class="lt_header" width="60">Баллы</th>
                <th class="lt_header" width="80">Сумма</th>
                <th class="lt_header" width="100">Выполнено</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($ops as $op) { ?>
                <tr>
                    <td height="20">
                        <?php echo $op['pubdate']; ?><br/>
                        <span style="color:#5F98BF"><?php echo $op['datediff']; ?> назад</span>
                    </td>
                    <td><a href="<?php echo cmsUser::getProfileURL($op['user_login']); ?>" target="_blank"><?php echo $op['user']; ?></a></td>
                    <td>
                        <span style="color:<?php echo $status_colors[$op['status']]; ?>">
                            <?php echo $statuses[$op['status']]; ?>
                        </span>
                        <?php if ($op['status'] == BILL_OUT_STATUS_DONE){ ?>
                        <br/>
                        <span style="color:#5F98BF"><?php echo $op['donedate']; ?></span>
                        <?php } ?>
                    </td>
                    <td><?php echo $op['ps_name'].': '.$op['ps_account']; ?></td>
                    <td><?php echo $op['amount']; ?></td>
                    <td><?php echo $op['summ'] . ' ' . $cfg['currency']; ?></td>
                    <td>
                        <a href="/billing/done_out/<?php echo $op['id']; ?>" onclick="if(!confirmOut('<?php echo $op['summ'] . ' ' . $cfg['currency']; ?>', '<?php echo $op['ps_name']; ?>', '<?php echo $op['ps_account']; ?>')) return false;" title="Выполнить">
                            <img border="0" hspace="2" src="images/actions/on.gif" alt="Выполнить">
                        </a>
                        <a href="javascript:" onclick="jsmsg('Удалить заявку?', '/billing/delete_out/<?php echo $op['id']; ?>')" title="Удалить">
                            <img border="0" hspace="2" src="images/actions/delete.gif" alt="Удалить">
                        </a>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <?php if ($pagebar) { ?>
        <p><?php echo $pagebar; ?></p>
    <?php } ?>

    <script type="text/javascript">

        function confirmOut(summ, ps_name, ps_account){
            return confirm('Перевод суммы '+summ+'\nна счет '+ps_name+' '+ps_account+'\nвыполнен?');
        }

        $('#listTable td').css('vertical-align', 'middle');
        highlightTableRows("listTable","hoverRow","clickedRow");

    </script>

<?php }

    }
//=================================================================================================//
//=================================================================================================//

    if($opt=='save_subs'){

		$groups = $inCore->request('groups', 'array');
		$cost   = $inCore->request('cost', 'array');
		$period = $inCore->request('period', 'array');

        $subs   = array();

        foreach($groups as $group_id){
            $group_id = (int)$group_id;
            $subs[$group_id]['cost']    = $cost[$group_id];
            $subs[$group_id]['period']  = $period[$group_id];
        }

        $cfg['subs'] = $subs;

        $inCore->saveComponentConfig('billing', $cfg);

        $inCore->redirectBack();

	}

//=================================================================================================//
//=================================================================================================//

	if ($opt == 'edit_subs') {

    	cpAddPathway('Подписки', $_SERVER['REQUEST_URI']);

        $groups     = cmsUser::getGroups(true);
        $base_url   = "/admin/index.php?view=components&do=config&id={$_REQUEST['id']}&opt=save_subs";

        $subs = $cfg['subs'];

    ?>

<h3>Подписки</h3>

<form action="<?php echo $base_url; ?>" method="post">

    <table cellpadding="5" cellspacing="0" border="0" class="subs_table">

        <thead>
            <tr>
                <th width="160" class="left">Группа</th>
                <th width="140">Разрешить переход</th>
                <th>Стоимость, в баллах</th>
                <th>Период</th>
            </tr>
        </thead>

        <tbody>
            <?php foreach($groups as $group){ ?>
                <tr>
                    <td><?php echo $group['title']; ?></td>
                    <td align="center">
                        <label>
                            <input type="checkbox" name="groups[]" value="<?php echo $group['id']; ?>" <?php if($subs[$group['id']]){ ?>checked="checked"<?php } ?> /> Да
                        </label>
                    </td>
                    <td align="center">
                        <label>
                            <input type="text" class="price_input" name="cost[<?php echo $group['id']; ?>]" value="<?php echo (int)$subs[$group['id']]['cost']; ?>" />
                        </label>
                    </td>
                    <td>
                        <select name="period[<?php echo $group['id']; ?>]">
                            <option value="1" <?php if ($subs[$group['id']]['period']==1) { ?>selected="selected"<?php } ?>>день</option>
                            <option value="7" <?php if ($subs[$group['id']]['period']==7) { ?>selected="selected"<?php } ?>>неделя</option>
                            <option value="31" <?php if ($subs[$group['id']]['period']==31) { ?>selected="selected"<?php } ?>>месяц</option>
                            <option value="365" <?php if ($subs[$group['id']]['period']==365) { ?>selected="selected"<?php } ?>>год</option>
                        </select>
                    </td>
                </tr>
            <?php } ?>
        </tbody>

    </table>

    <p style="margin-top:25px">
        <input type="submit" name="submit" value="Сохранить" />
    </p>

</form>

<?php }

