<?php

class ps_qiwi extends shopPaymentSystem{

/* ========================================================================== */
/* ========================================================================== */

    /**
     * Получает всю информацию о заказе в массиве $order
     * и сохраняет внутри класса
     * @param array $order 
     */
    public function __construct($order, $config){

        parent::__construct();

        $this->order    = $order;
        $this->config   = $config;

    }

/* ========================================================================== */
/* ========================================================================== */

    /**
     * Генерирует и возвращает код формы для отправки в платежную систему
     */
    public function getHtmlForm($order, $currency){

        global $_LANG;

        $currency_kurs  = $this->config['currency'][$currency];
        $this->summ     = str_replace(',', '.', round($this->order['summ']/$currency_kurs, 2));

        ob_start();

        include('form.php');

        return ob_get_clean();

    }

/* ========================================================================== */
/* ========================================================================== */

    public function processPayment($model) {

        $inCore = cmsCore::getInstance();

        // Помещаем заказ в обработку
        $model->setOrderStatus($this->order['id'], $this->order['secret_key'], 1);
        $this->order['status'] = 1;

        $inCore->redirect('/billing/order-success.html');

        return true;

    }

/* ========================================================================== */
/* ========================================================================== */

}

?>