<h1 class="con_heading">{$LANG.BILLING_TRANSFER}</h1>

<div class="billing_out">

        <form action="/billing/submit_transfer" method="post">

            <input type="hidden" id="balance" value="{$balance}" />

            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td class="title">{$LANG.BILLING_TRANSFER_USER}:</td>
                    <td>
                        <div id="login_input">
                            <input type="text" id="login" name="login" style="width:200px" />
                            {if $friends}<a href="javascript:selectFriend()"  class="transfer_all">{$LANG.BILLING_SELECT_FRIEND}</a>{/if}
                        </div>
                        {if $friends}
                            <div id="friends" style="display:none">
                                <select id="friends_list" style="width:200px">
                                    {foreach key=r item=f from=$friends}
                                        <option value="{$f.login}">{$f.nickname} &lt;{$f.login}&gt;</option>
                                    {/foreach}
                                </select>
                                <input type="button" onclick="setLogin()" value="Ok" />
                                <input type="button" onclick="{literal}$('#friends').hide();$('#login_input').show();{/literal}" value="{$LANG.CANCEL}" />
                            </div>
                        {/if}
                    </td>
                </tr>
                <tr>
                    <td class="title" width="180">{$LANG.BILLING_YOUR_BALANCE}:</td>
                    <td>
                        {$balance|spellcount:$LANG.BILLING_POINT1:$LANG.BILLING_POINT2:$LANG.BILLING_POINT10}
                        <a class="transfer_all" href="javascript:transferAll()">{$LANG.BILLING_TRANSFER_ALL}</a>
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_TRANSFER_AMOUNT}:</td>
                    <td>
                        <input type="text" id="amount" name="amount" style="width:60px" /> {$LANG.BILLING_POINT10}
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_COMMENT}:</td>
                    <td>
                        <input type="text" id="comment" name="comment" style="width:195px" maxlength="200" />
                    </td>
                </tr>
            </table>

            <p>
                <input type="submit" name="submit" value="{$LANG.BILLING_TRANSFER_SUBMIT}" onclick="{literal}if($('#amount').val()==''||$('#amount').val()=='0'){ return false; }{/literal}"/>
                <input type="button" name="cancel" value="{$LANG.CANCEL}" onclick="window.history.go(-1)" />
            </p>

        </form>

</div>

<h3>{$LANG.BILLING_TRANSFER_LATEST}</h3>

{if !$transfers}
    <p>{$LANG.BILLING_TRANSFER_LATEST_NO}</p>
{else}

    <table border="0" cellpadding="5" cellspacing="0" id="billing_history">
        <tr>
            <th width="120">{$LANG.DATE}</th>
            <th width="150">{$LANG.BILLING_TF_USER_TO}</th>
            <th width="70">{$LANG.BILLING_POINTS}</th>
            <th width="190">{$LANG.BILLING_STATUS}</th>
            <th width="55">&nbsp;</th>
        </tr>
        {foreach key=r item=row from=$transfers}
            <tr>
                <td class="op_date">{$row.pubdate}</td>
                <td><a href="{profile_url login=$row.user_login}">{$row.user}</a></td>
                <td>{$row.amount}</td>
                <td>
                    <span class="tf_status{$row.status}">
                        {$LANG.BILLING_TF_STATUS[$row.status]}{if $row.status==1}: {$row.donedate}{/if}
                    </span>
                </td>
                <td>
                    {if $row.status == 0}
                        <a href="/billing/delete_tf/{$row.id}">{$LANG.CANCEL}</a>
                    {else}
                        &mdash;
                    {/if}
                </td>
            </tr>
        {/foreach}
    </table>

{/if}

<script type="text/javascript">
    {literal}

        function selectFriend(){
            $('#login_input').hide();
            $('#friends').show();
        }

        function setLogin(){
            var login = $('#friends_list').val();
            $('#login').val(login);
            $('#login_input').show();
            $('#friends').hide();
        }

        function transferAll(){
            var all  = $('#balance').val();
            $('#amount').val(all);
        }
        
    {/literal}
</script>