<?php

class p_balance extends cmsPlugin {

// ==================================================================== //

    public function __construct(){

        parent::__construct();

        // Информация о плагине

        $this->info['plugin']           = 'p_balance';
        $this->info['title']            = 'Баланс пользователя';
        $this->info['description']      = 'Показывает баланс пользователя и историю операций в профиле';
        $this->info['author']           = 'InstantSoft';
        $this->info['version']          = '1.3';

        $this->info['tab']              = 'Баланс'; //-- Заголовок закладки в профиле

        // События, которые будут отлавливаться плагином

        $this->events[]                 = 'USER_PROFILE';
        $this->events[]                 = 'USER_REGISTER';
        $this->events[]                 = 'USER_ACTIVATED';

    }

// ==================================================================== //

    /**
     * Процедура установки плагина
     * @return bool
     */
    public function install(){

        return parent::install();

    }

// ==================================================================== //

    /**
     * Процедура обновления плагина
     * @return bool
     */
    public function upgrade(){

        return parent::upgrade();

    }

// ==================================================================== //

    /**
     * Обработка событий
     * @param string $event
     * @param array $user
     * @return html
     */
    public function execute($event, $user){

        parent::execute();

        switch ($event){

            case 'USER_PROFILE': $result = $this->profileTab($user); break;
            case 'USER_REGISTER': $result = $this->userRegistered($user); break;
            case 'USER_ACTIVATED': $result = $this->userActivated($user); break;

            default: $result = false; break;

        }

        return $result;

    }

// ==================================================================== //

    public function userRegistered($user){

        $inCore     = cmsCore::getInstance();
        $inDB       = cmsDatabase::getInstance();

        $cfg = $inCore->loadComponentConfig('billing');

        $is_locked = $inDB->get_field('cms_users', "id='{$user['id']}'", 'is_locked');

        if ($is_locked){ return false; }

        if ($cfg['ref_enabled']){

            if (!$cfg['ref_bonus']) { $cfg['ref_bonus'] = 0; }

            $ref_id = $inCore->getCookie('ref_id');

            if ($ref_id && is_numeric($ref_id)) {

                $sql = "UPDATE cms_users
                        SET ref_id = '{$ref_id}'
                        WHERE id = '{$user['id']}'";

                $inDB->query($sql);

                $inCore->loadClass('billing');

                cmsBilling::income($ref_id, $cfg['ref_bonus']);

                cmsBilling::addOperation(array(
                    'op_type' => OP_TYPE_INCOME,
                    'user_id' => $ref_id,
                    'owner_id' => $ref_id,
                    'amount'  => $cfg['ref_bonus'],
                    'summ'    => 0,
                    'status'  => 1,
                    'comment' => 'Новый реферал: '.$user['nickname']
                ));

            }

        }

        if ($cfg['reg_bonus']){

            $sql = "UPDATE cms_users
                    SET balance = '{$cfg['reg_bonus']}'
                    WHERE id = '{$user['id']}'";

            $inDB->query($sql);

        }

        return true;

    }

// ==================================================================== //

    public function userActivated($user_id){

        $inCore     = cmsCore::getInstance();
        $inDB       = cmsDatabase::getInstance();

        $cfg = $inCore->loadComponentConfig('billing');

        $user = $inDB->get_fields('cms_users', "id='{$user_id}'", '*');

        if ($cfg['ref_enabled']){

            if (!$cfg['ref_bonus']) { $cfg['ref_bonus'] = 0; }

            $ref_id = $inCore->getCookie('ref_id');

            if ($ref_id && is_numeric($ref_id)) {

                $sql = "UPDATE cms_users
                        SET ref_id = '{$ref_id}'
                        WHERE id = '{$user_id}'";

                $inDB->query($sql);

                $inCore->loadClass('billing');

                cmsBilling::income($ref_id, $cfg['ref_bonus']);

                cmsBilling::addOperation(array(
                    'op_type' => OP_TYPE_INCOME,
                    'user_id' => $ref_id,
                    'owner_id' => $ref_id,
                    'amount'  => $cfg['ref_bonus'],
                    'summ'    => 0,
                    'status'  => 1,
                    'comment' => 'Новый реферал: '.$user['nickname']
                ));

            }

        }

        if ($cfg['reg_bonus']){

            $sql = "UPDATE cms_users
                    SET balance = '{$cfg['reg_bonus']}'
                    WHERE id = '{$user_id}'";

            $inDB->query($sql);

        }

        return true;

    }

// ==================================================================== //

    public function profileTab($user){

        $inConf     = cmsConfig::getInstance();
        $inCore     = cmsCore::getInstance();
        $inUser     = cmsUser::getInstance();
        $inPage     = cmsPage::getInstance();

        // авторизация
        if (!$inUser->id){ return false; }
        if ($inUser->id != $user['id'] && !$inUser->is_admin) { return false; }

        // наличие установленного биллинга
        if (!$inCore->isComponentInstalled('billing')){
            return 'Для работы плагина требуется компонент &laquo;Биллинг пользователей&raquo;.';
        }

        // инициализация
        global $_CFG;
        $inCore->loadClass('billing');
        $cfg = $inCore->loadComponentConfig('billing');

        // подключаем все необходимое
        $inPage->addHeadCSS('templates/'.$inConf->template.'/css/billing.css');
        $inCore->loadModel('billing');
        $inCore->loadLanguage('billing');

        $model      = new cms_model_billing();

        $history    = cmsBilling::getLastOperations($user['id']);
        $subs       = cmsBilling::getUserSubscription($user['id']);

        $is_wait_out = cmsBilling::isUserWaitOut($user['id']);

        ob_start();

        $smarty= $this->inCore->initSmarty('plugins', 'p_balance.tpl');
        $smarty->assign('user', $inUser);
        $smarty->assign('user_id', $user['id']);
        $smarty->assign('is_admin', $inUser->is_admin);
        $smarty->assign('group', $user['grp']);
        $smarty->assign('subs', $subs);
        $smarty->assign('is_wait_out', $is_wait_out);
        $smarty->assign('my_profile', ($inUser->id == $user['id']));
        $smarty->assign('balance', cmsBilling::getBalance($user['id']));
        $smarty->assign('history', $history);
        $smarty->assign('cfg', $cfg);
        $smarty->display('p_balance.tpl');

        $html = ob_get_clean();

        return $html;

    }

// ==================================================================== //
// ==================================================================== //

}

?>
