<h1 class="con_heading">{$LANG.BILLING_OUT}</h1>

<div class="billing_out">

    {if $is_wait_out}
        <p class="error">{$LANG.BILLING_OUT_ALREADY_WAIT}</p>
    {/if}

    {if !$is_enough && !$is_wait_out}
        <p>{$LANG.BILLING_YOUR_BALANCE}: {$balance|spellcount:$LANG.BILLING_POINT1:$LANG.BILLING_POINT2:$LANG.BILLING_POINT10}</p>        
        <p>{$LANG.BILLING_OUT_MIN}: {$cfg.out_min|spellcount:$LANG.BILLING_POINT1:$LANG.BILLING_POINT2:$LANG.BILLING_POINT10}</p>
        <p class="error">{$LANG.BILLING_OUT_NOT_ENOUGH}</p>
    {/if}

    {if !$is_can_out && $is_enough && !$is_wait_out}
        <p>{$LANG.BILLING_OUT_PERIOD_TEXT}: {$LANG.BILLING_OUT_PERIOD[$cfg.out_period]}</p>
        <p class="error">{$LANG.BILLING_OUT_PERIOD_REACH}</p>
    {/if}

    {if $is_enough && $is_can_out && !$is_wait_out}
    
        <form action="/billing/submit_out" method="post">

            <input type="hidden" id="kurs" value="{$cfg.out_kurs}" />
            <input type="hidden" id="balance" value="{$balance}" />

            <p>{$LANG.BILLING_OUT_MIN}: {$cfg.out_min|spellcount:$LANG.BILLING_POINT1:$LANG.BILLING_POINT2:$LANG.BILLING_POINT10}</p>
            <p>{$LANG.BILLING_OUT_PERIOD_TEXT}: {$LANG.BILLING_OUT_PERIOD[$cfg.out_period]}</p>

            <h3>{$LANG.BILLING_OUT_CREATE}</h3>

            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td class="title" width="180">{$LANG.BILLING_YOUR_BALANCE}:</td>
                    <td>
                        {$balance|spellcount:$LANG.BILLING_POINT1:$LANG.BILLING_POINT2:$LANG.BILLING_POINT10}
                        <a class="out_all" href="javascript:outAll()">{$LANG.BILLING_OUT_ALL}</a>
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_OUT_AMOUNT}:</td>
                    <td>
                        <input type="text" id="amount" name="amount" style="width:200px" onkeyup="calculate()" />
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_OUT_PS_NAME}:</td>
                    <td>
                        <select name="ps_name" style="width:205px">
                            {foreach key=k item=p from=$ps}
                                <option value="{$p}">{$p}</option>
                            {/foreach}
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_OUT_PS_ACCOUNT}:</td>
                    <td>
                        <input type="text" name="ps_account" style="width:200px" />
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_OUT_KURS}:</td>
                    <td>
                        1 {$LANG.BILLING_POINT1} = {$cfg.out_kurs} {$cfg.currency}
                    </td>
                </tr>
                <tr>
                    <td class="title">{$LANG.BILLING_OUT_SUMM}:</td>
                    <td>
                        <div class="total">
                            <span id="summ_out">0</span> {$cfg.currency}
                        </div>
                    </td>
                </tr>
            </table>

            <p>
                <input type="submit" name="submit" value="{$LANG.BILLING_OUT_SUBMIT}" />
                <input type="button" name="cancel" value="{$LANG.CANCEL}" onclick="window.history.go(-1)" />
            </p>

        </form>

    {/if}

</div>

<h3>{$LANG.BILLING_OUT_LAST_OUTS}</h3>

{if !$outs}
    <p>{$LANG.BILLING_OUT_LAST_OUTS_NO}</p>
{else}

    <table border="0" cellpadding="5" cellspacing="0" id="billing_history">
        <tr>
            <th width="120">{$LANG.DATE}</th>
            <th width="70">{$LANG.BILLING_POINTS}</th>
            <th width="100">{$LANG.BILLING_SUMM}</th>
            <th width="190">{$LANG.BILLING_STATUS}</th>
            <th width="55">&nbsp;</th>
        </tr>
        {foreach key=r item=row from=$outs}
            <tr>
                <td class="op_date">{$row.pubdate}</td>
                <td>{$row.amount}</td>
                <td>{$row.summ} {$cfg.currency}</td>
                <td>
                    <span class="op_status{$row.status}">
                        {$LANG.BILLING_OUT_STATUS[$row.status]}{if $row.status==2}: {$row.donedate}{/if}
                    </span>
                </td>
                <td>
                    {if $row.status < 2}
                        <a href="/billing/delete_out/{$row.id}">{$LANG.CANCEL}</a>
                    {else}
                        &mdash;
                    {/if}
                </td>
            </tr>
        {/foreach}
    </table>

{/if}

<script type="text/javascript">
    {literal}

        function outAll(){
            var all  = $('#balance').val();
            $('#amount').val(all);
            calculate();
        }

        function calculate(){

            var kurs = $('#kurs').val();
            var all  = $('#balance').val();
            var i    = $('#amount').val();
            var o    = 0;

            if (isNaN(i) || i == ''){
                o = '0';
            } else {
                o = i * kurs;
            }

            $('#summ_out').html(o); return;

        }

    {/literal}
</script>