<?php

class ps_interkassa extends shopPaymentSystem{

/* ========================================================================== */
/* ========================================================================== */

    /**
     *        $order
     *    
     * @param array $order
     */
    public function __construct($order, $config){

        parent::__construct();

        $this->order    = $order;
        $this->config   = $config;

    }

/* ========================================================================== */
/* ========================================================================== */

    /**
     *          
     */
    public function getHtmlForm($order, $currency){

        global $_LANG;

        $currency_kurs  = $this->config['currency'][$currency];
        $this->order['summ']  = round($this->order['summ']/$currency_kurs, 2);

        $this->order['secret_key'] = md5($order['id'].time().rand(0,9999));

        ob_start();

        include('form.php');

        return ob_get_clean();

    }

/* ========================================================================== */
/* ========================================================================== */

	public function log($str){
//        $filename = $_SERVER['DOCUMENT_ROOT'] . '/components/shop/payments/interkassa/log.txt';
//        $f = fopen($filename, 'w');
//        $str = date('[H:i] ') . $str;
//        fputs($f, $str);
//        fclose($f);
	}

    private function preRequest($model) {

        $inCore         = cmsCore::getInstance();

        $out_shop_id    = $inCore->request('ik_shop_id', 'str');
        $out_summ       = $inCore->request('ik_payment_amount', 'str');
        $out_id         = $inCore->request('ik_payment_id', 'int');
        $out_signature  = $inCore->request('ik_sign_hash', 'str');
        $out_psys_alias = $inCore->request('ik_paysystem_alias', 'str', '');
        $out_baggage    = $inCore->request('ik_baggage_fields', 'str', '');
        $out_status     = $inCore->request('ik_payment_state', 'str', 'fail');
        $out_trans_id   = $inCore->request('ik_trans_id', 'str', '');
        $out_curr_exch  = $inCore->request('ik_currency_exch', 'str', '');
        $out_fees_payer = $inCore->request('ik_fees_payer', 'str', '0');

        if ($out_status != 'success') { return 'ERR:   ';  }

        // ,     
        $currency_kurs    = $this->config['currency']['RUR'];
        $currency_price   = ($currency_kurs > 1 ? round($this->order['summ']/$currency_kurs, 2) : round($this->order['summ']*$currency_kurs, 2));

        //  
        if ($this->config['ik_shop_id']['value'] != $out_shop_id) {
            $this->log("ERR0:   ");
			return "ERR0:   ";
		}

        //   
        if ($currency_price != $out_summ) {
            $this->log("ERR1:   ");
			return "ERR1:   ";
		}

        // ,      
        if ($this->order['id'] != $out_id) {
            $this->log("ERR2:   ");
			return "ERR2:   ";
		}

        //  
        $signature = $out_shop_id.':'.
                     $out_summ.':'.
                     $out_id.':'.
                     $out_psys_alias.':'.
                     $out_baggage.':'.
                     $out_status.':'.
                     $out_trans_id.':'.
                     $out_curr_exch.':'.
                     $out_fees_payer.':'.
                     trim($this->config['ik_secret_key']['value']);

        $signature_md5 = strtoupper(md5($signature));

        if($signature_md5 != $out_signature){

            $log =  "ERR3:    " . "\n" .
                    "SIG: {$signature}" . "\n" .
                    "SIG MD5: {$signature_md5}" . "\n" .
                    "IK MD5: {$out_signature}" ;
            $this->log($log);
			return "ERR3:    ";

		}


        $log =  "SIG: {$signature}" . "\n" .
                "SIG MD5: {$signature_md5}" . "\n" .
                "IK MD5: {$out_signature}" ;

        $this->log($log);

        //   
        $model->setOrderStatus($this->order['id'], $this->order['secret_key'], 2);

        return;

    }

/* ========================================================================== */
/* ========================================================================== */

    public function processPayment($model) {

        return iconv('cp1251', 'utf-8', $this->preRequest($model));

    }

/* ========================================================================== */
/* ========================================================================== */

}
