<?php
/*********************************************************************************************/
//																							 //
//                              InstantCMS v1.5   (c) 2009 FREEWARE                          //
//	 					  http://www.instantcms.ru/, info@instantcms.ru                      //
//                                                                                           //
// 						      written by InstantCMS Team 2007-2009                           //
//                                                                                           //
//                                   LICENSED BY GNU/GPL v2                                  //
//                                                                                           //
/*********************************************************************************************/
if(!defined('VALID_CMS')) { die('ACCESS DENIED'); }

function shop(){

    global $_LANG;
    global $_CFG;

    setlocale(LC_NUMERIC, 'POSIX');

    //  
    $inCore     = cmsCore::getInstance();       //
    $inPage     = cmsPage::getInstance();       //
    $inDB       = cmsDatabase::getInstance();   // 
    $inUser     = cmsUser::getInstance();       //

    // ID   
	$menuid     = $inCore->menuId();
    $menutitle  = $inCore->menuTitle();

    if ($menuid == 1){ $menutitle = ''; }

    // 
    $inCore->loadModel('shop');
    $model = new cms_model_shop();

    //  
    $cfg = $model->getConfig();

    //  
	$id         = $inCore->request('id', 'int', 0);
	$seolink    = $inCore->request('seolink', 'str', '');
	$do         = $inCore->request('do', 'str', 'view');

	$page       = $inCore->request('page', 'int', 1);
	$perpage    = $cfg['perpage'];

    // CSS  
	$inPage->addHeadCSS('templates/'.$_CFG['template'].'/css/inshop.css');

//============================================================================//
//============================================================================//

    //
    //   
    //

	if ($do=='view'){

        if ($menuid == 1){ $inPage->backButton(FALSE); }

        // --------   --------------

        if (!$seolink){
            // 
            $root_cat           = $model->getRootCategory();
            $root_cat['title']  = ($menuid > 1 ? $menutitle : '');
        }

        if ($seolink){
            // ( ) 
            $root_cat   = $model->getCategoryByLink($seolink);
            $path_list  = $model->getCategoryPath($root_cat['NSLeft'], $root_cat['NSRight']);
        }

        //   - 404
        if (!$root_cat){ cmsCore::error404(); }

        $_SESSION['inshop_last_url'] = $_SERVER['REQUEST_URI'];
        $_SESSION['inshop_last_cat_id'] = $root_cat['id'];

        //  
		if ($root_cat['pagetitle']) { $inPage->setTitle($root_cat['pagetitle']) ; } else {$inPage->setTitle($root_cat['title']);}

       //SET META KEYWORDS AND DESCRIPTION
		$inPage->setKeywords($root_cat['meta_keys']);
		$inPage->setDescription($root_cat['meta_desc']);

        //    ,    
        if ($path_list){
            foreach($path_list as $pcat){
                $inPage->addPathway($pcat['title'], '/shop/'.$pcat['seolink']);
            }
        }

        // 
        $subcats = $model->getSubCats($root_cat['id']);

        //   
        $vendors = $model->getCatVendors($root_cat['id']);

        // - 
        $chars = $model->getCatChars($root_cat['id']);

        // -------     -----------------
        if (is_array($_SESSION['shop_filters'])){
            foreach ($_SESSION['shop_filters'] as $f_cat_id=>$f){
                if ($f_cat_id != $root_cat['id']){
                    unset($_SESSION['shop_filters'][$f_cat_id]);
                }
            }
            if(!strpos($_SERVER['REQUEST_URI'],'page')) {
               unset($_SESSION['shop_filters'][$root_cat['id']]);
            }
        }

        // -------    -----------------

        if($inCore->inRequest('all')) {
            unset($_SESSION['shop_filters'][$root_cat['id']]);
            $inCore->redirect('/shop/'.$root_cat['seolink']);
        }

        $filter     = array();
        $filter_str = $_SESSION['shop_filters'][$root_cat['id']];

        if ($filter_str){ $filter = $model->parseFilterString($filter_str); }
        if ($inCore->inRequest('filter')) {
            $filter = $inCore->request('filter', 'array');
            unset($_SESSION['shop_filters']);
        }

        if (is_array($filter)){

            foreach($filter as $key=>$val){

                if ($val && $key){

                    //
                    if ($key == 'vendors'){
                        $model->whereVendorIn($val);
                        continue;
                    }

                    //    (select)
                    if (!is_array($val)){
                        $val = trim($val);
                        switch($key){
                            case 'pfrom':  $model->wherePriceFrom($val); break;
                            case 'pto':    $model->wherePriceTo($val); break;
                            default:
                                if ($chars[$key]['values']){
                                    $model->whereCharIs($key, $val);
                                } else {
                                    $model->whereCharLike($key, $val);
                                }
                                break;
                        }
                    }

                    //     
                    if (is_array($val)){
                        if (isset($val['from']) || isset($val['to'])){
                            $model->whereCharBetween($key, $val);
                        } else {
                            $model->whereCharIn($key, $val);
                        }
                    }


                }

            }
            if (!$filter_str) {
                $filter_str = $model->makeFilterString($filter);
            }

        }

        if ($filter_str){
            $_SESSION['shop_filters'][$root_cat['id']] = $filter_str;
        }

        // -------   -----------------

        //  
        if ($root_cat['id']==1 || ($root_cat['id']>1 && !$cfg['show_nested'])){
            $model->whereCatIs($root_cat['id']);
        } else {
            $model->whereRecursiveCatIs($root_cat['id'], array('NSLeft'=>$root_cat['NSLeft'], 'NSRight'=>$root_cat['NSRight']));
        }

        $model->groupBy('i.id');

        //      
        $total = $model->getItemsCount();

        // 
        $orderby = $_SESSION['inshop_orderby'] ? $_SESSION['inshop_orderby'] : $cfg['items_orderby'];
        $orderto = $_SESSION['inshop_orderto'] ? $_SESSION['inshop_orderto'] : $cfg['items_orderto'];
        $model->orderBy($orderby, $orderto);

        $order_types = array();

        foreach (array('ordering', 'price', 'title', 'id') as $order){

            switch ($order){
                case 'ordering': $name = $_LANG['SHOP_SORT_ORDERING']; break;
                case 'price': $name = $_LANG['SHOP_SORT_PRICE']; break;
                case 'title': $name = $_LANG['SHOP_SORT_TITLE']; break;
                case 'id': $name = $_LANG['SHOP_SORT_DATE']; break;
            }

            $order_types[] = array(
                'order' => $order,
                'name' => $name,
                'selected' => ($orderby==$order)
            );

        }

        //     -   
        $model->limitPage($page, $perpage);

        //      
        $items = $model->getItems();

        //   
        $pages = ceil($total / $perpage);

        $pages_url = '/shop/'.$root_cat['seolink'].'/page-%page%';

        $pagebar = cmsPage::getPagebar($total, $page, $perpage, $pages_url);

        //   
        if (!$root_cat['tpl']) { $root_cat['tpl'] = 'com_inshop_view.tpl'; }

        //   
		$smarty = $inCore->initSmarty('components', $root_cat['tpl']);
		$smarty->assign('cfg', $cfg);
		$smarty->assign('subcats', $subcats);
		$smarty->assign('items', $items);
		$smarty->assign('chars', $chars);
		$smarty->assign('vendors', $vendors);
		$smarty->assign('filter', $filter);
        $smarty->assign('filter_str', $filter_str);
		$smarty->assign('total', $total);
		$smarty->assign('pages', $pages);
		$smarty->assign('page', $page);
		$smarty->assign('pagebar', $pagebar);
		$smarty->assign('orderby', $orderby);
		$smarty->assign('orderto', $orderto);
		$smarty->assign('order_types', $order_types);
		$smarty->assign('root_cat', $root_cat);
		$smarty->assign('is_user', $inUser->id);
		$smarty->display($root_cat['tpl']);

	}

//============================================================================//
//============================================================================//

    //
    //  
    //

    if ($do=='item'){

        //   - 
        if (!$seolink) { cmsCore::error404(); }

        //   
        $item = $model->getItemBySeolink($seolink);

        //    - 
        if (!$item) { cmsCore::error404(); }

        if ($item['images']){
            $inPage->addHeadJS('includes/jquery/lightbox/js/jquery.lightbox.js');
            $inPage->addHeadCSS('includes/jquery/lightbox/css/jquery.lightbox.css');
        }

        $_SESSION['inshop_last_url'] = $_SERVER['REQUEST_URI'];

        //    
        $nav = array();
        if ($cfg['show_items_nav']){
            $nav = $model->getItemNav($item['id'], $item['category_id']);
        }

        //    ( )
        $path_list  = $model->getCategoryPath($item['category']['NSLeft'], $item['category']['NSRight']);

        //    ,    
        if ($path_list){
            foreach($path_list as $pcat){
                $inPage->addPathway($pcat['title'], '/shop/'.$pcat['seolink']);
            }
        }

        $inPage->addPathway($item['title']);

        //  
        $inPage->setTitle($item['title']);

        if ($item['metakeys']){ $inPage->setKeywords($item['metakeys']); }
        if ($item['metadesc']){ $inPage->setDescription($item['metadesc']); }

        //  
        if ($cfg['show_related']){
            $related_items = $model->getRelatedItems($item['id']);
        }

        //   
        if (!$item['tpl']) { $item['tpl'] = 'com_inshop_item.tpl'; }

        //   
		$smarty = $inCore->initSmarty('components', $item['tpl']);
        $smarty->assign('cfg', $cfg);
		$smarty->assign('item', $item);
		$smarty->assign('nav', $nav);
		$smarty->assign('related_items', $related_items);
        $smarty->assign('is_user', $inUser->id);
		$smarty->display($item['tpl']);

        if($inCore->isComponentInstalled('comments') && $cfg['show_comments']){
            $inCore->includeComments();
            comments('shopitem', $item['id']);
        }

    }

//============================================================================//
//============================================================================//

    if ($do=='download'){

        $link_key = $inCore->request('link_key', 'str');

        $item = $model->getDigitalDownload($link_key);

        if (!$item){ cmsCore::error404(); }

        if ($item['is_loaded']){
            $loaded_msg  = "<p>   .   .</p>";
            $loaded_msg .= "<p>    <a href=\"/\"> </a> .</p>";
            $loaded_msg .= "<p><strong>  : #{$item['order_id']}</strong></p>";
            $inCore->halt($loaded_msg);
        }

        $file = '/upload/userfiles/'.$item['filename'];

        if (!file_exists(PATH. $file)) { $inCore->halt('  .     .   : #'.$item['order_id']); }

        header('Content-Disposition: attachment; filename='.$item['filename_orig'] . "\n");
        header('Content-Type: application/x-force-download; name="'.$file.'"' . "\n\n");

        echo file_get_contents(PATH . $file);

        $ip = $_SERVER['REMOTE_ADDR'];

        $inDB->query("UPDATE cms_shop_loads SET is_loaded=1, load_date = NOW(), load_ip='{$ip}' WHERE id = '{$item['id']}'");

        $inCore->halt();

    }

//============================================================================//
//============================================================================//

    if ($do=='compare'){

        $inPage->setTitle($_LANG['SHOP_COMPARE']);
        $inPage->addPathway($_LANG['SHOP_COMPARE'], '/shop/compare.html');
        $inPage->backButton(false);

        $add_item_id = $inCore->request('item_id', 'int', 0);

        if ($add_item_id) {
            $model->addCompareItem($add_item_id);
            $inCore->redirect('/shop/compare.html');
        }

        $items = $model->getCompareItems();
        $chars = $model->getChars(true, '', true); //only_published, all groups, only_compare

        $cmp_chars = array();

        foreach($chars as $char_id=>$char){
            if ($char['is_compare']){
                foreach($items as $num=>$item){
                    if ($item['chars'][$char_id]){
                        $cmp_chars[$char['title']][$item['id']] = $item['chars'][$char_id]['value'];
                    }
                }
            }
        }

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_compare.tpl');
        $smarty->assign('cfg', $cfg);
		$smarty->assign('items', $items);
		$smarty->assign('cmp_chars', $cmp_chars);
        $smarty->assign('last_url', $_SESSION['inshop_last_url']);
        $smarty->display('com_inshop_compare.tpl');

    }

    if ($do=='compare_remove'){

        $item_id = $inCore->request('item_id', 'int', 0);

        $model->deleteCompare($item_id);

        $inCore->redirectBack();

    }

//============================================================================//
//============================================================================//

    //
    //  
    //

    if ($do=='vendors'){

        //  
        $inPage->setTitle($_LANG['SHOP_VENDORS']);
        $inPage->addPathway($_LANG['SHOP_VENDORS'], '/shop/vendors.html');

        // 
        $vendors = $model->getVendors();

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_vendors.tpl');
        $smarty->assign('cfg', $cfg);
		$smarty->assign('vendors', $vendors);
		$smarty->display('com_inshop_vendors.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //    
    //

	if ($do=='view_vendor'){

        // 
        $vendor_id = $inCore->request('vendor_id', 'int', 0);
        $vendor    = $model->getVendor($vendor_id);

        //   - 404
        if (!$vendor){ cmsCore::error404(); }

        $_SESSION['inshop_last_url'] = $_SERVER['REQUEST_URI'];

        //  
        $inPage->setTitle($vendor['title']);
        $inPage->addPathway($_LANG['SHOP_VENDORS'], '/shop/vendors.html');
        $inPage->addPathway($vendor['title']);

        // -------   -----------------

        //    
        $model->where('i.category_id = c.id');
        $model->whereVendorIs($vendor_id);

        //      
        $total = $model->getItemsCount();

        //  " "
        $model->orderBy('ordering', 'asc');

        //     -   
        $model->limitPage($page, $perpage);

        //      
        $items = $model->getItems();

        //   
        $pages = ceil($total / $perpage);

        $pagebar = cmsPage::getPagebar($total, $page, $perpage, '/shop/vendors/%vendor_id%/page-%page%', array('vendor_id'=>$vendor_id));

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_vendor.tpl');
        $smarty->assign('cfg', $cfg);
		$smarty->assign('vendor', $vendor);
		$smarty->assign('items', $items);
		$smarty->assign('total', $total);
		$smarty->assign('pages', $pages);
		$smarty->assign('page', $page);
		$smarty->assign('pagebar', $pagebar);
		$smarty->display('com_inshop_vendor.tpl');

	}

//============================================================================//
//============================================================================//

    //
    //      
    //

    if ($do=='payment'){

        //  
        $inPage->setTitle($_LANG['SHOP_SELECT_PAYSYS']);
        $inPage->addPathway($_LANG['SHOP_SELECT_PAYSYS']);

        //  ""
        $inPage->backButton(false);

        // ---- C  ----

        //        
        $items = $model->getCartItems();
        if (!$items){ cmsCore::error404(); }

        //   
        $d_type = $inCore->request('d_type', 'int', 0);

        //   
        $giftcode = $inCore->request('giftcode', 'str', '');

        //   
        $order['secret_key']        = md5(session_id());

        $customer_type              = $inCore->request('cust_type', 'str', 'fis');

        $order['customer_name']     = $inCore->request('customer_name', 'str', '');
        $order['customer_org']      = $inCore->request('customer_org', 'str', '');
        $order['customer_inn']      = $inCore->request('customer_inn', 'str', '');
        $order['customer_phone']    = $inCore->request('customer_phone', 'str', '');
        $order['customer_email']    = $inCore->request('customer_email', 'str', '');
        $order['customer_address']  = $inCore->request('customer_address', 'str', '');
        $order['customer_comment']  = $inCore->request('customer_comment', 'str', '');

        $order['items']             = $inCore->arrayToYaml($items);
        $order['giftcode']          = $giftcode;
        $order['status']            = 0;
        $order['user_id']           = $inUser->id;
        $order['summ']              = $model->calculateOrderSumm($items, $d_type, $giftcode);

        if ($d_type){
            $delivery_types         = $model->getDeliveryTypes($order['summ']);
            $order['d_type']        = $d_type;
            $order['d_price']       = $delivery_types[$d_type]['price'];
        } else {
            $order['d_type']        = $d_type;
            $order['d_price']       = 0;
        }

        //     
        $model->deleteExpiredOrders(session_id());

        //  
        if ($inUser->id){
            $customer_data['customer_name']     = $order['customer_name'];
            $customer_data['customer_org']      = $order['customer_org'];
            $customer_data['customer_inn']      = $order['customer_inn'];
            $customer_data['customer_phone']    = $order['customer_phone'];
            $customer_data['customer_email']    = $order['customer_email'];
            $customer_data['customer_address']  = $order['customer_address'];
            $model->saveCustomerData($inUser->id, $customer_data);
        }

        //  
        $order['id']                = $model->addOrder($order);

        $order['description']       = $_LANG['SHOP_ORDER'].' #'.$order['id'];

        //    
        if (!$order['customer_name'] && in_array('name', $cfg['ord_req'])){
            $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_NAME'], 'error');
        }
        if (!$order['customer_phone'] && in_array('phone', $cfg['ord_req'])){
            $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_PHONE'], 'error');
        }
        if (!$order['customer_email'] && in_array('email', $cfg['ord_req'])){
            $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_EMAIL'], 'error');
        }
        if (!$order['customer_address'] && in_array('address', $cfg['ord_req'])){
            $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_ADDRESS'], 'error');
        }
        if ($customer_type == 'org'){
            if (!$order['customer_org'] && in_array('org', $cfg['ord_req'])){
                $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_ORG'], 'error');
            }
            if (!$order['customer_inn'] && in_array('inn', $cfg['ord_req'])){
                $errors = true; cmsCore::addSessionMessage($_LANG['SHOP_ERR_REQ_INN'], 'error');
            }
        }

        if ($errors) { $inCore->redirectBack(); }

        if ($cfg['is_skip_pay']){
            $model->setOrderStatus($order['id'], $order['secret_key'], 1);
            $inCore->redirect('/shop/order-accept.html');
        }

        // ----     ----

        $p_systems = $model->getPaymentSystems();

        if ($p_systems){ $inCore->includeFile('components/shop/payments/paysys.class.php'); }

        $is_billing = $inCore->isComponentInstalled('billing');
        if (!$is_billing){ unset($p_systems['balance']); }

        foreach ($p_systems as $sys_id=>$p_sys){

            $inCore->includeFile('components/shop/payments/'.$sys_id.'/'.$sys_id.'.php');
            $inCore->includeFile('components/shop/payments/'.$sys_id.'/info.php');
            eval('$sys = new ps_'.$sys_id.'($order, $p_sys[\'config\']);');

            if($p_sys['config']['currency']){
                foreach($p_sys['config']['currency'] as $currency=>$kurs){
                    if($kurs){
                        $p_systems[$sys_id]['forms'][$currency] = $sys->getHtmlForm($order, $currency);
                        $p_systems[$sys_id]['config']['currency'][$currency] = round($order['summ']/$kurs, 2);
                    }
                }
            }

        }

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_pay.tpl');
        $smarty->assign('cfg', $cfg);
		$smarty->assign('p_systems', $p_systems);
		$smarty->assign('order', $order);
		$smarty->display('com_inshop_pay.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //  
    //

    if ($do=='view_order'){

        // -   
        $qty_arr = $inCore->request('qty', 'array');
        if ($qty_arr) {
            $model->saveCart($qty_arr);
            $inCore->redirect($_SERVER['REQUEST_URI']);
        }

        // ID  (        )
        $order_id = $inCore->request('order_id', 'int', 0);

        //   ,   
        //   (..        )
        if ($order_id){
            $order = $model->getOrder($order_id, md5(session_id()));
            if ($order){
                $model->deleteOrder($id, $order['secret_key']);
            }
        } else {
            $model->deleteExpiredOrders(session_id());
        }

        //  
        $inPage->setTitle($_LANG['SHOP_START_ORDER']);
        $inPage->addPathway($_LANG['SHOP_START_ORDER']);

        //  ""
        $inPage->backButton(false);

        //       
        $items = $model->getCartItems();

        $totalsumm = 0;

        foreach($items as $item){
            $totalsumm += ($item['price'] * $item['cart_qty']);
        }

        $discount_size = $model->getOrderDiscountSize($totalsumm);
        $totalsumm = $model->getOrderSummDiscounted($totalsumm, $discount_size);

        //  
        if ($items){
            $delivery_types = $model->getDeliveryTypes($totalsumm);
        }

        //  
        if ($inUser->id){
            $customer_data = $model->getCustomerData($inUser->id);
            if ($customer_data && !$order){
                $order = array();
                $order['customer_name']     = $customer_data['customer_name'];
                $order['customer_org']      = $customer_data['customer_org'];
                $order['customer_inn']      = $customer_data['customer_inn'];
                $order['customer_phone']    = $customer_data['customer_phone'];
                $order['customer_email']    = $customer_data['customer_email'];
                $order['customer_address']  = $customer_data['customer_address'];
            }
        }

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_order.tpl');
        $smarty->assign('cfg', $cfg);
        $smarty->assign('user_id', $inUser->id);
        $smarty->assign('customer_data', $customer_data);
		$smarty->assign('readonly', true);
		if (isset($order)) { $smarty->assign('order', $order); }
		$smarty->assign('items', $items);
		$smarty->assign('delivery_types', $delivery_types);
		$smarty->assign('discount_size', $discount_size);
		$smarty->assign('totalsumm', round($totalsumm, 2));
		$smarty->assign('last_url', $_SESSION['inshop_last_url']);
		$smarty->display('com_inshop_order.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //  
    //

    if ($do=='view_cart'){

        //  
        $inPage->setTitle($_LANG['SHOP_CART']);
        $inPage->addPathway($_LANG['SHOP_CART']);

        //  ""
        $inPage->backButton(false);

        //       
        $items = $model->getCartItems();

        $totalsumm = 0;

        foreach($items as $item){
            $totalsumm += ($item['price'] * $item['cart_qty']);
        }

        $discount_size = $model->getOrderDiscountSize($totalsumm);
        $totalsumm = $model->getOrderSummDiscounted($totalsumm, $discount_size);

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_cart.tpl');
		$smarty->assign('readonly', false);
        $smarty->assign('cfg', $cfg);
		$smarty->assign('items', $items);
		$smarty->assign('discount_size', $discount_size);
		$smarty->assign('totalsumm', round($totalsumm, 2));
		$smarty->assign('last_url', $_SESSION['inshop_last_url']);
		$smarty->display('com_inshop_cart.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //    
    //

    if ($do=='add_to_cart'){

        $item_id    = $inCore->request('add_to_cart_item_id', 'int', 0);
        $var_art_no = $inCore->request('var_art_no', 'str', '');
        $qty        = $inCore->request('qty', 'int', 1);
        $chars      = $inCore->request('chars', 'array', false);

        $model->addToCart($item_id, $var_art_no, $qty, $chars);

        if ($cfg['after_cart'] == 'stay'){
            $inCore->redirectBack();
        }

        if ($cfg['after_cart'] == 'cart'){
            $inCore->redirect('/shop/cart.html');
        }

        $inCore->redirectBack();

    }

//============================================================================//
//============================================================================//

    //
    //    
    //

    if ($do=='delete_from_cart'){

        $item_id    = $inCore->request('delete_from_cart_item_id', 'int', 0);

        $model->deleteFromCart($item_id);

        $inCore->redirectBack();

    }

//============================================================================//
//============================================================================//

    //
    //   (result-url   )
    //

    if ($do=='process_payment'){

        $result = '';

        //  
        $psys_id = $inCore->request('psys_id', 'str', '');
        if (!$psys_id || strstr($psys_id, '.')) { $inCore->halt("ERR:   "); }

        $psys = $model->getPaymentSystem($psys_id);

        if (!$psys) { $inCore->halt("ERR:   : $psys_id"); }

        //       
        $order_id = $inCore->request('order_id', 'int', 0);
        //  InvId    
        if (!$order_id) { $order_id = $inCore->request('InvId', 'int', 0); }

        $order    = $model->getOrder($order_id);

        if (!$order) {
            $inCore->halt("ERR:   ");
        }

        if ($order['status'] != 0) {
            $inCore->halt("ERR:   ");
        }

        $inCore->includeFile('components/shop/payments/paysys.class.php');
        $inCore->includeFile('components/shop/payments/'.$psys['link'].'/'.$psys['link'].'.php');

        $model->setOrderPaymentSystem($order_id, $psys['title']);
        $order['psys_title'] = $psys['title'];

        eval('$sys = new ps_'.$psys['link'].'($order, $psys[\'config\']);');

        $result = $sys->processPayment($model);

        echo $result;

    }

//============================================================================//
//============================================================================//

    //
    //   (success-url   )
    //

    if ($do=='order_success'){

        $inPage->backButton(false);
        $inPage->setTitle($_LANG['SHOP_ORDER_SUCCESS']);

        $order_id = $inCore->request('order_id', 'int', 0);

        //  InvId    
        if (!$order_id) { $order_id = $inCore->request('InvId', 'int', 0); }

        //  ik_payment_id    
        if (!$order_id) { $order_id = $inCore->request('ik_payment_id', 'int', 0); }

        $order = $model->getOrder($order_id);

        $model->clearCart(session_id());

        if ($order && ($order['status'] >= 1))  {
            $model->sendOrder($order, 'success', $cfg);
        }

        $message_text  = $_LANG['SHOP_ORDER_SUCCESS_TEXT'];

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_pay_result.tpl');
		$smarty->assign('success', true);
        $smarty->assign('cfg', $cfg);
		$smarty->assign('message_text', $message_text);
		$smarty->assign('order', $order);
		$smarty->assign('order_id', $order_id);
		$smarty->display('com_inshop_pay_result.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //    (fail-url   )
    //

    if ($do=='order_fail'){

        $inPage->backButton(false);
        $inPage->setTitle($_LANG['SHOP_ORDER_FAIL']);

        $message_text = $_LANG['SHOP_ORDER_FAIL_TEXT'];

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_pay_result.tpl');
		$smarty->assign('success', false);
        $smarty->assign('cfg', $cfg);
		$smarty->assign('message_text', $message_text);
		$smarty->display('com_inshop_pay_result.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //    (   )
    //

    if ($do=='order_accept'){

        $inPage->backButton(false);
        $inPage->setTitle($_LANG['SHOP_ORDER_ACCEPTED_TEXT']);

        $order_id   = $inCore->request('order_id', 'int', 0);
        $secret_key = $inCore->request('osk', 'str', '');

        $order    = $model->getOrder($order_id);

        $model->clearCart(session_id());
        if ($order) { $model->sendOrder($order, 'accept', $cfg); }

        $message_text = $_LANG['SHOP_ORDER_ACCEPTED_TEXT'];

        //   
		$smarty = $inCore->initSmarty('components', 'com_inshop_pay_result.tpl');
		$smarty->assign('accept', true);
        $smarty->assign('cfg', $cfg);
		$smarty->assign('message_text', $message_text);
		$smarty->display('com_inshop_pay_result.tpl');

    }

//============================================================================//
//============================================================================//

    //
    //   
    //

    if ($do=='download_char'){

        $item_id = $inCore->request('item_id', 'int', 0);
        $char_id = $inCore->request('char_id', 'int', 0);

        if (!$item_id || !$char_id) { $inCore->halt('no item'); }

        $file = '/upload/userfiles/shop-char-'.$item_id.'-'.$char_id.'.file';

        if (!file_exists(PATH. $file)) { $inCore->halt('no file'); }

        $data = $inDB->get_field('cms_shop_chars_val', "item_id={$item_id} AND char_id={$char_id}", 'val');

        $data = $inCore->yamlToArray($data);

        if (!is_array($data)) { $inCore->halt('no data'); }

        header('Content-Disposition: attachment; filename='.$data['name'] . "\n");
        header('Content-Type: application/x-force-download; name="'.$file.'"' . "\n\n");

        echo file_get_contents(PATH . $file);

        $inCore->halt();

    }

//============================================================================//
//============================================================================//

    //
    //   
    //

    if ($do=='sberbank'){

        $sbrf = $model->getPaymentSystem('sberbank');
        if (!$sbrf) { $inCore->halt(); }

        $order_id   = $inCore->request('order_id', 'int', 0);
        $order      = $model->getOrder($order_id);
        if (!$order) { $inCore->halt(); }

        $currency_kurs  = $sbrf['config']['currency']['RUR'];
        $order['summ']  = round($order['summ']/$currency_kurs, 2);

        $order['title']         = '  '.$order_id;
        $order['summ_parts']    = explode('.', $order['summ']);

        $month = mb_strtolower($inCore->getRusDate(date('F')));

        for($i=0; $i<10; $i++){
            if (!isset($sbrf['config']['SBRF_SHOP_INN']['value'][$i])){
                $sbrf['config']['SBRF_SHOP_INN']['value'][$i] = '&nbsp;';
            }
            if (!isset($sbrf['config']['SBRF_SHOP_BIK']['value'][$i])){
                $sbrf['config']['SBRF_SHOP_BIK']['value'][$i] = '&nbsp;';
            }
        }

        for($i=0; $i<20; $i++){
            if (!isset($sbrf['config']['SBRF_SHOP_ACC']['value'][$i])){
                $sbrf['config']['SBRF_SHOP_ACC']['value'][$i] = '&nbsp;';
            }
            if (!isset($sbrf['config']['SBRF_SHOP_KS']['value'][$i])){
                $sbrf['config']['SBRF_SHOP_KS']['value'][$i] = '&nbsp;';
            }
        }

        if ($order['summ_parts'][1]=='') { $order['summ_parts'][1] = '00'; }

        if (!$order['customer_name']) { $order['customer_name'] = '&nbsp;'; }
        if (!$order['customer_address']) { $order['customer_address'] = '&nbsp;'; }

        $model->setOrderPaymentSystem($order_id, ' ');

        include(PATH.'/components/shop/payments/sberbank/template.php');

        $inCore->halt();

    }

//============================================================================//
//============================================================================//

    //
    //      
    //

    if ($do=='beznal'){

        $bill = $model->getPaymentSystem('bill');
        if (!$bill) { $inCore->halt(); }

        $order_id   = $inCore->request('order_id', 'int', 0);
        $order      = $model->getOrder($order_id);
        if (!$order) { $inCore->halt(); }

        $order['summ_parts']    = explode('.', $order['summ']);

        $month = mb_strtolower($inCore->getRusDate(date('F')));

        if ($order['summ_parts'][1]=='') { $order['summ_parts'][1] = '00'; }

        $model->setOrderPaymentSystem($order_id, ' ');

        $currency_kurs  = $bill['config']['currency']['RUR'];
        $order['summ']  = round($order['summ']/$currency_kurs, 2);

        include(PATH.'/components/shop/payments/bill/template.php');

        $inCore->halt();

    }

//============================================================================//
//============================================================================//

    //
    //   
    //

    if ($do=='balance'){

        $is_billing = $inCore->isComponentInstalled('billing');

        if ($is_billing) {
            $inCore->loadClass('billing');
        } else {
            $inCore->halt(' <a href="http://www.instantcms.ru/billing/about.html"> </a>');
        }

        $order_id   = $inCore->request('order_id', 'int', 0);
        $order      = $model->getOrder($order_id);

        if (!$order){ $inCore->halt(); }

        $bill = $model->getPaymentSystem('balance');

        $currency_kurs  = $bill['config']['currency']['RUR'];

        $summ = round($order['summ']/$currency_kurs, 2);
        $balance = $inUser->balance;

        $comment = $_LANG['SHOP'].': '.$_LANG['SHOP_ORDER'].' #'.$order_id;

        if ($balance < $summ){

            $billing_ticket = array(
                'action' => $comment,
                'cost'   => $summ,
                'amount' => $summ-$balance,
                'url'    => $_SERVER['REQUEST_URI']
            );
            cmsUser::sessionPut('billing_ticket', $billing_ticket);

            $inCore->redirect('/billing/pay');
            return;

        }

        if ($balance >= $summ){
            cmsBilling::pay($inUser->id, $summ, $comment, false);
            $model->setOrderStatus($order['id'], $order['secret_key'], 2);
            $model->clearCart(session_id());
            $inCore->redirect('/shop/order-success.html');
        }

    }

//============================================================================//
//============================================================================//

    if ($do=='set_sort'){

        $orderby = $inCore->request('orderby', 'str', 'ordering');
        $orderto = $inCore->request('orderto', 'str', 'asc');

        $_SESSION['inshop_orderby'] = $orderby;
        $_SESSION['inshop_orderto'] = $orderto;

        $inCore->redirectBack();

    }

//============================================================================//
//============================================================================//

    if ($do == 'rate_item'){

        $item_id    = $inCore->request('item_id', 'int');
        $points     = $inCore->request('rate', 'int');

        $user_id    = $inUser->id;

        $model->rateItem($item_id, $user_id, $points);

        $inCore->redirectBack();

    }

//============================================================================//
//============================================================================//

    if ($do == 'export_yml'){

        $inConf = cmsConfig::getInstance();

        if (!$cfg['yml']['shop_name']) { $cfg['yml']['shop_name'] = $inConf->sitename; }
        if (!$cfg['yml']['shop_url']) { $cfg['yml']['shop_url'] = 'http://'.$_SERVER['HTTP_HOST'].'/'; }
        if (!$cfg['yml']['base_curr']) { $cfg['yml']['base_curr'] = 'RUR'; }
        if (!$cfg['yml']['curr']['RUR']) { $cfg['yml']['curr']['RUR'] = 'CBRF'; }
        if (!$cfg['yml']['curr']['UAH']) { $cfg['yml']['curr']['UAH'] = 'CBRF'; }
        if (!$cfg['yml']['curr']['BYR']) { $cfg['yml']['curr']['BYR'] = 'CBRF'; }
        if (!$cfg['yml']['curr']['KZT']) { $cfg['yml']['curr']['KZT'] = 'CBRF'; }
        if (!$cfg['yml']['curr']['USD']) { $cfg['yml']['curr']['USD'] = 'CBRF'; }
        if (!$cfg['yml']['curr']['EUR']) { $cfg['yml']['curr']['EUR'] = 'CBRF'; }
        if (!$cfg['yml']['ldc']) { $cfg['yml']['ldc'] = 0; }
        if (!isset($cfg['yml']['store'])) { $cfg['yml']['store'] = -1; }
        if (!isset($cfg['yml']['pickup'])) { $cfg['yml']['pickup'] = -1; }
        if (!isset($cfg['yml']['delivery'])) { $cfg['yml']['delivery'] = -1; }

        $cats = $model->getCategories();

        $model->groupBy('i.id');
        $model->limitIs(10000);
        $items = $model->getItems();

        $file = 'components/com_inshop_yml.php';

        echo '<?xml version="1.0" encoding="windows-1251"?>'."\n";

        if (file_exists(TEMPLATE_DIR.$file)){
            include(TEMPLATE_DIR.$file);
        } else {
            include(DEFAULT_TEMPLATE_DIR.$file);
        }

        exit;

    }

//============================================================================//
//============================================================================//

}
